/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.gdal;

import cats.syntax.OptionIdOps$;
import cats.syntax.package$option$;
import com.azavea.gdal.GDALWarp;
import geotrellis.proj4.CRS;
import geotrellis.proj4.CRS$;
import geotrellis.proj4.LatLng$;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.BitCellType$;
import geotrellis.raster.ByteCellType$;
import geotrellis.raster.CellSize;
import geotrellis.raster.DataType;
import geotrellis.raster.Dimensions;
import geotrellis.raster.Dimensions$;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridBounds$;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.gdal.GDALDataType;
import geotrellis.raster.gdal.GDALDataType$;
import geotrellis.raster.gdal.GDALDataset;
import geotrellis.raster.gdal.GDALDataset$SOURCE$;
import geotrellis.raster.gdal.GDALDataset$WARPED$;
import geotrellis.raster.gdal.GDALIOException;
import geotrellis.raster.gdal.GDALMetadataDomain;
import geotrellis.raster.gdal.GDALMetadataDomain$;
import geotrellis.raster.gdal.GDALUtils$;
import geotrellis.raster.gdal.ImageStructureDomain$;
import geotrellis.raster.gdal.MalformedDataException;
import geotrellis.raster.gdal.MalformedDataTypeException;
import geotrellis.raster.gdal.MalformedProjectionException;
import geotrellis.raster.gdal.UserDefinedDomain$;
import geotrellis.raster.gdal.config.GDALOptionsConfig$;
import geotrellis.raster.gdal.package$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import spire.math.Integral$;

public final class GDALDataset$
implements scala.Serializable {
    public static GDALDataset$ MODULE$;

    static {
        new GDALDataset$();
    }

    public long apply(String uri, String[] options) {
        return GDALWarp.get_token(uri, options);
    }

    public long apply(String uri) {
        return this.apply(uri, (String[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(String.class)));
    }

    public long apply(long token) {
        return token;
    }

    public Option<Object> unapply(long x$0) {
        return new GDALDataset(x$0) == null ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToLong((long)x$0));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final Map<String, String> getAllMetadataFlatten$extension0(long $this) {
        return this.getAllMetadataFlatten$extension1($this, GDALDataset$SOURCE$.MODULE$);
    }

    public final Map<String, String> getAllMetadataFlatten$extension1(long $this, GDALDataset.DatasetType datasetType) {
        return (Map)((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.bandCount$extension1($this, datasetType)).map((Function1 & Serializable & scala.Serializable)x$1 -> GDALDataset$.$anonfun$getAllMetadataFlatten$1($this, datasetType, BoxesRunTime.unboxToInt((Object)x$1)), IndexedSeq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$3, x$4) -> x$3.$plus$plus((GenTraversableOnce)x$4));
    }

    public final Map<GDALMetadataDomain, Map<String, String>> getAllMetadata$extension0(long $this, int band) {
        return this.getAllMetadata$extension1($this, GDALDataset$SOURCE$.MODULE$, band);
    }

    public final Map<GDALMetadataDomain, Map<String, String>> getAllMetadata$extension1(long $this, GDALDataset.DatasetType datasetType, int band) {
        return ((TraversableOnce)((TraversableLike)this.getMetadataDomainList$extension0($this, datasetType.value()).map((Function1 & Serializable & scala.Serializable)domain -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(domain), MODULE$.getMetadata$extension2($this, (GDALMetadataDomain)domain, band)), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)GDALDataset$.$anonfun$getAllMetadata$2(x$5)))).toMap(Predef$.MODULE$.$conforms());
    }

    public final List<GDALMetadataDomain> getMetadataDomainList$extension0(long $this, int band) {
        return this.getMetadataDomainList$extension1($this, GDALDataset$SOURCE$.MODULE$, band);
    }

    public final List<GDALMetadataDomain> getMetadataDomainList$extension1(long $this, GDALDataset.DatasetType datasetType, int band) {
        Predef$.MODULE$.require(package$.MODULE$.acceptableDatasets().contains((Object)datasetType));
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(100, 1024, ClassTag$.MODULE$.Byte());
        int returnValue = GDALWarp.get_metadata_domain_list($this, datasetType.value(), package$.MODULE$.numberOfAttempts(), band, arr);
        this.errorHandler$extension($this, returnValue, (Function1<Object, Throwable>)(Function1 & Serializable & scala.Serializable)positiveValue -> GDALDataset$.$anonfun$getMetadataDomainList$1(BoxesRunTime.unboxToInt((Object)positiveValue)));
        return (List)((SeqLike)GDALMetadataDomain$.MODULE$.ALL().$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).map((Function1 & Serializable & scala.Serializable)x$6 -> new String((byte[])x$6, "UTF-8").trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)GDALDataset$.$anonfun$getMetadataDomainList$3(x$7))))).toList().map((Function1)UserDefinedDomain$.MODULE$, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).distinct();
    }

    public final Map<GDALMetadataDomain, Map<String, String>> getMetadata$extension0(long $this, List<GDALMetadataDomain> domains, int band) {
        return this.getMetadata$extension1($this, GDALDataset$SOURCE$.MODULE$, domains, band);
    }

    public final Map<GDALMetadataDomain, Map<String, String>> getMetadata$extension1(long $this, GDALDataset.DatasetType datasetType, List<GDALMetadataDomain> domains, int band) {
        return ((TraversableOnce)((TraversableLike)domains.map((Function1 & Serializable & scala.Serializable)domain -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(domain), MODULE$.getMetadata$extension3($this, datasetType, (GDALMetadataDomain)domain, band)), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)GDALDataset$.$anonfun$getMetadata$2(x$8)))).toMap(Predef$.MODULE$.$conforms());
    }

    public final Map<String, String> getMetadata$extension2(long $this, GDALMetadataDomain domain, int band) {
        return this.getMetadata$extension3($this, GDALDataset$SOURCE$.MODULE$, domain, band);
    }

    public final Map<String, String> getMetadata$extension3(long $this, GDALDataset.DatasetType datasetType, GDALMetadataDomain domain, int band) {
        Predef$.MODULE$.require(package$.MODULE$.acceptableDatasets().contains((Object)datasetType));
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(100, 1024, ClassTag$.MODULE$.Byte());
        int returnValue = GDALWarp.get_metadata($this, datasetType.value(), package$.MODULE$.numberOfAttempts(), band, domain.name(), arr);
        this.errorHandler$extension($this, returnValue, (Function1<Object, Throwable>)(Function1 & Serializable & scala.Serializable)positiveValue -> GDALDataset$.$anonfun$getMetadata$3(BoxesRunTime.unboxToInt((Object)positiveValue)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])arr)).map((Function1 & Serializable & scala.Serializable)x$9 -> new String((byte[])x$9, "UTF-8").trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)GDALDataset$.$anonfun$getMetadata$5(x$10))))).flatMap((Function1 & Serializable & scala.Serializable)str -> {
            Iterable iterable;
            String[] arr = str.split("=");
            if (arr.length == 2) {
                String[] stringArray = str.split("=");
                Option option2 = Array$.MODULE$.unapplySeq((Object)stringArray);
                if (option2.isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(2) != 0) {
                    throw new MatchError((Object)stringArray);
                }
                String key = (String)((SeqLike)option2.get()).apply(0);
                String value = (String)((SeqLike)option2.get()).apply(1);
                Tuple2 tuple22 = new Tuple2((Object)key, (Object)value);
                Tuple2 tuple23 = tuple22;
                String key2 = (String)tuple23._1();
                String value2 = (String)tuple23._2();
                iterable = Option$.MODULE$.option2Iterable(OptionIdOps$.MODULE$.some$extension(package$option$.MODULE$.catsSyntaxOptionId(new Tuple2((Object)key2, (Object)value2))));
            } else {
                iterable = Option$.MODULE$.option2Iterable(OptionIdOps$.MODULE$.some$extension(package$option$.MODULE$.catsSyntaxOptionId(new Tuple2((Object)"", str))));
            }
            return iterable;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    public final String getMetadataItem$extension0(long $this, String key, GDALMetadataDomain domain, int band) {
        return this.getMetadataItem$extension1($this, GDALDataset$WARPED$.MODULE$, key, domain, band);
    }

    public final String getMetadataItem$extension1(long $this, GDALDataset.DatasetType datasetType, String key, GDALMetadataDomain domain, int band) {
        Predef$.MODULE$.require(package$.MODULE$.acceptableDatasets().contains((Object)datasetType));
        byte[] arr = (byte[])Array$.MODULE$.ofDim(1024, ClassTag$.MODULE$.Byte());
        int returnValue = GDALWarp.get_metadata_item($this, datasetType.value(), package$.MODULE$.numberOfAttempts(), band, key, domain.name(), arr);
        this.errorHandler$extension($this, returnValue, (Function1<Object, Throwable>)(Function1 & Serializable & scala.Serializable)positiveValue -> GDALDataset$.$anonfun$getMetadataItem$1(BoxesRunTime.unboxToInt((Object)positiveValue)));
        return new String(arr, "UTF-8").trim();
    }

    public final Option<String> getProjection$extension0(long $this) {
        return this.getProjection$extension1($this, GDALDataset$WARPED$.MODULE$);
    }

    public final Option<String> getProjection$extension1(long $this, GDALDataset.DatasetType datasetType) {
        Predef$.MODULE$.require(package$.MODULE$.acceptableDatasets().contains((Object)datasetType));
        byte[] crs = (byte[])Array$.MODULE$.ofDim(1024, ClassTag$.MODULE$.Byte());
        int returnValue = GDALWarp.get_crs_wkt($this, datasetType.value(), package$.MODULE$.numberOfAttempts(), crs);
        this.errorHandler$extension($this, returnValue, (Function1<Object, Throwable>)(Function1 & Serializable & scala.Serializable)positiveValue -> GDALDataset$.$anonfun$getProjection$1(BoxesRunTime.unboxToInt((Object)positiveValue)));
        return OptionIdOps$.MODULE$.some$extension(package$option$.MODULE$.catsSyntaxOptionId(new String(crs, "UTF-8")));
    }

    public final List<Dimensions<Object>> overviewDimensions$extension0(long $this) {
        return this.overviewDimensions$extension1($this, GDALDataset$WARPED$.MODULE$);
    }

    public final List<Dimensions<Object>> overviewDimensions$extension1(long $this, GDALDataset.DatasetType datasetType) {
        Predef$.MODULE$.require(package$.MODULE$.acceptableDatasets().contains((Object)datasetType));
        int N = 256;
        int[] widths = (int[])Array$.MODULE$.ofDim(N, ClassTag$.MODULE$.Int());
        int[] heights = (int[])Array$.MODULE$.ofDim(N, ClassTag$.MODULE$.Int());
        int returnValue = GDALWarp.get_overview_widths_heights($this, datasetType.value(), package$.MODULE$.numberOfAttempts(), 1, widths, heights);
        this.errorHandler$extension($this, returnValue, (Function1<Object, Throwable>)(Function1 & Serializable & scala.Serializable)positiveValue -> GDALDataset$.$anonfun$overviewDimensions$1(BoxesRunTime.unboxToInt((Object)positiveValue)));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(widths)).zip((GenIterable)Predef$.MODULE$.wrapIntArray(heights), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple22 = x0$1;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            int w = tuple22._1$mcI$sp();
            int h = tuple22._2$mcI$sp();
            Iterable iterable = w > 0 && h > 0 ? Option$.MODULE$.option2Iterable(OptionIdOps$.MODULE$.some$extension(package$option$.MODULE$.catsSyntaxOptionId(Dimensions$.MODULE$.apply(w, h)))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            return iterable;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Dimensions.class))))).toList();
    }

    public final Dimensions<Object> dimensions$extension0(long $this) {
        return this.dimensions$extension1($this, GDALDataset$WARPED$.MODULE$);
    }

    public final Dimensions<Object> dimensions$extension1(long $this, GDALDataset.DatasetType datasetType) {
        Predef$.MODULE$.require(package$.MODULE$.acceptableDatasets().contains((Object)datasetType));
        int[] dimensions = (int[])Array$.MODULE$.ofDim(2, ClassTag$.MODULE$.Int());
        int returnValue = GDALWarp.get_width_height($this, datasetType.value(), package$.MODULE$.numberOfAttempts(), dimensions);
        this.errorHandler$extension($this, returnValue, (Function1<Object, Throwable>)(Function1 & Serializable & scala.Serializable)positiveValue -> GDALDataset$.$anonfun$dimensions$1(BoxesRunTime.unboxToInt((Object)positiveValue)));
        return Dimensions$.MODULE$.apply(dimensions[0], dimensions[1]);
    }

    public final double[] getTransform$extension0(long $this) {
        return this.getTransform$extension1($this, GDALDataset$WARPED$.MODULE$);
    }

    public final double[] getTransform$extension1(long $this, GDALDataset.DatasetType datasetType) {
        Predef$.MODULE$.require(package$.MODULE$.acceptableDatasets().contains((Object)datasetType));
        double[] transform = (double[])Array$.MODULE$.ofDim(6, ClassTag$.MODULE$.Double());
        int returnValue = GDALWarp.get_transform($this, datasetType.value(), package$.MODULE$.numberOfAttempts(), transform);
        this.errorHandler$extension($this, returnValue, (Function1<Object, Throwable>)(Function1 & Serializable & scala.Serializable)positiveValue -> GDALDataset$.$anonfun$getTransform$1(BoxesRunTime.unboxToInt((Object)positiveValue)));
        return transform;
    }

    public final RasterExtent rasterExtent$extension0(long $this) {
        return this.rasterExtent$extension1($this, GDALDataset$WARPED$.MODULE$);
    }

    public final RasterExtent rasterExtent$extension1(long $this, GDALDataset.DatasetType datasetType) {
        RasterExtent rasterExtent;
        Predef$.MODULE$.require(package$.MODULE$.acceptableDatasets().contains((Object)datasetType));
        Dimensions<Object> dimensions = this.dimensions$extension1($this, datasetType);
        if (dimensions == null) {
            throw new MatchError(dimensions);
        }
        int cols = dimensions.cols$mcI$sp();
        int rows = dimensions.rows$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(cols, rows);
        Tuple2.mcII.sp sp3 = sp2;
        int cols2 = sp3._1$mcI$sp();
        int rows2 = sp3._2$mcI$sp();
        double[] dArray = this.getTransform$extension1($this, datasetType);
        Option option2 = Array$.MODULE$.unapplySeq((Object)dArray);
        if (option2.isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(6) != 0) {
            throw new MatchError((Object)dArray);
        }
        double xskew = BoxesRunTime.unboxToDouble((Object)((SeqLike)option2.get()).apply(2));
        double yskew = BoxesRunTime.unboxToDouble((Object)((SeqLike)option2.get()).apply(4));
        Tuple3 tuple32 = new Tuple3((Object)dArray, (Object)BoxesRunTime.boxToDouble((double)xskew), (Object)BoxesRunTime.boxToDouble((double)yskew));
        Tuple3 tuple33 = tuple32;
        double[] transform = (double[])tuple33._1();
        double xskew2 = BoxesRunTime.unboxToDouble((Object)tuple33._2());
        double yskew2 = BoxesRunTime.unboxToDouble((Object)tuple33._3());
        Extent ext = this.extent$extension2($this, transform, cols2, rows2);
        if (xskew2 == 0.0 && yskew2 == 0.0) {
            CellSize cs = this.cellSize$extension2($this, transform);
            rasterExtent = new RasterExtent(ext, cs.width(), cs.height(), cols2, rows2);
        } else {
            rasterExtent = RasterExtent$.MODULE$.apply(ext, cols2, rows2);
        }
        return rasterExtent;
    }

    public final List<RasterExtent> resolutions$extension0(long $this) {
        return this.resolutions$extension1($this, GDALDataset$WARPED$.MODULE$);
    }

    public final List<RasterExtent> resolutions$extension1(long $this, GDALDataset.DatasetType datasetType) {
        Predef$.MODULE$.require(package$.MODULE$.acceptableDatasets().contains((Object)datasetType));
        Extent ext = this.extent$extension1($this, datasetType);
        return (List)this.overviewDimensions$extension1($this, datasetType).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Dimensions dimensions = x0$1;
            if (dimensions == null) {
                throw new MatchError((Object)dimensions);
            }
            int cols = dimensions.cols$mcI$sp();
            int rows = dimensions.rows$mcI$sp();
            RasterExtent rasterExtent = RasterExtent$.MODULE$.apply(ext, cols, rows);
            return rasterExtent;
        }, List$.MODULE$.canBuildFrom());
    }

    public final Extent extent$extension0(long $this) {
        return this.extent$extension1($this, GDALDataset$WARPED$.MODULE$);
    }

    public final Extent extent$extension1(long $this, GDALDataset.DatasetType datasetType) {
        Predef$.MODULE$.require(package$.MODULE$.acceptableDatasets().contains((Object)datasetType));
        return this.rasterExtent$extension1($this, datasetType).extent();
    }

    public final Extent extent$extension2(long $this, double[] transform, int cols, int rows) {
        double[] dArray = transform;
        Option option2 = Array$.MODULE$.unapplySeq((Object)dArray);
        if (option2.isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(6) != 0) {
            throw new MatchError((Object)dArray);
        }
        double upx = BoxesRunTime.unboxToDouble((Object)((SeqLike)option2.get()).apply(0));
        double xres = BoxesRunTime.unboxToDouble((Object)((SeqLike)option2.get()).apply(1));
        double xskew = BoxesRunTime.unboxToDouble((Object)((SeqLike)option2.get()).apply(2));
        double upy = BoxesRunTime.unboxToDouble((Object)((SeqLike)option2.get()).apply(3));
        double yskew = BoxesRunTime.unboxToDouble((Object)((SeqLike)option2.get()).apply(4));
        double yres = BoxesRunTime.unboxToDouble((Object)((SeqLike)option2.get()).apply(5));
        Tuple6 tuple62 = new Tuple6((Object)BoxesRunTime.boxToDouble((double)upx), (Object)BoxesRunTime.boxToDouble((double)xres), (Object)BoxesRunTime.boxToDouble((double)xskew), (Object)BoxesRunTime.boxToDouble((double)upy), (Object)BoxesRunTime.boxToDouble((double)yskew), (Object)BoxesRunTime.boxToDouble((double)yres));
        Tuple6 tuple63 = tuple62;
        double upx2 = BoxesRunTime.unboxToDouble((Object)tuple63._1());
        double xres2 = BoxesRunTime.unboxToDouble((Object)tuple63._2());
        double xskew2 = BoxesRunTime.unboxToDouble((Object)tuple63._3());
        double upy2 = BoxesRunTime.unboxToDouble((Object)tuple63._4());
        double yskew2 = BoxesRunTime.unboxToDouble((Object)tuple63._5());
        double yres2 = BoxesRunTime.unboxToDouble((Object)tuple63._6());
        double ulx = upx2 + 0.0 * xres2 + 0.0 * xskew2;
        double uly = upy2 + 0.0 * yskew2 + 0.0 * yres2;
        double llx = upx2 + 0.0 * xres2 + (double)rows * xskew2;
        double lly = upy2 + 0.0 * yskew2 + (double)rows * yres2;
        double lrx = upx2 + (double)cols * xres2 + (double)rows * xskew2;
        double lry = upy2 + (double)cols * yskew2 + (double)rows * yres2;
        double urx = upx2 + (double)cols * xres2 + 0.0 * xskew2;
        double ury = upy2 + (double)cols * yskew2 + 0.0 * yres2;
        List xs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{ulx, llx, lrx, urx}));
        List ys = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{uly, lly, lry, ury}));
        return new Extent(BoxesRunTime.unboxToDouble((Object)xs.min((Ordering)Ordering.Double$.MODULE$)), BoxesRunTime.unboxToDouble((Object)ys.min((Ordering)Ordering.Double$.MODULE$)), BoxesRunTime.unboxToDouble((Object)xs.max((Ordering)Ordering.Double$.MODULE$)), BoxesRunTime.unboxToDouble((Object)ys.max((Ordering)Ordering.Double$.MODULE$)));
    }

    public final int bandCount$extension0(long $this) {
        return this.bandCount$extension1($this, GDALDataset$WARPED$.MODULE$);
    }

    public final int bandCount$extension1(long $this, GDALDataset.DatasetType datasetType) {
        Predef$.MODULE$.require(package$.MODULE$.acceptableDatasets().contains((Object)datasetType));
        int[] count = (int[])Array$.MODULE$.ofDim(1, ClassTag$.MODULE$.Int());
        int returnValue = GDALWarp.get_band_count($this, datasetType.value(), package$.MODULE$.numberOfAttempts(), count);
        this.errorHandler$extension($this, returnValue, (Function1<Object, Throwable>)(Function1 & Serializable & scala.Serializable)positiveValue -> GDALDataset$.$anonfun$bandCount$1(BoxesRunTime.unboxToInt((Object)positiveValue)));
        return count[0];
    }

    public final CRS crs$extension0(long $this) {
        return this.crs$extension1($this, GDALDataset$WARPED$.MODULE$);
    }

    public final CRS crs$extension1(long $this, GDALDataset.DatasetType datasetType) {
        Predef$.MODULE$.require(package$.MODULE$.acceptableDatasets().contains((Object)datasetType));
        byte[] crs = (byte[])Array$.MODULE$.ofDim(65536, ClassTag$.MODULE$.Byte());
        int returnValue = GDALWarp.get_crs_proj4($this, datasetType.value(), package$.MODULE$.numberOfAttempts(), crs);
        this.errorHandler$extension($this, returnValue, (Function1<Object, Throwable>)(Function1 & Serializable & scala.Serializable)positiveValue -> GDALDataset$.$anonfun$crs$1(BoxesRunTime.unboxToInt((Object)positiveValue)));
        String proj4String = new String(crs, "UTF-8").trim();
        return new StringOps(Predef$.MODULE$.augmentString(proj4String)).nonEmpty() ? CRS$.MODULE$.fromString(proj4String.trim()) : LatLng$.MODULE$;
    }

    public final Option<Object> noDataValue$extension0(long $this) {
        return this.noDataValue$extension1($this, GDALDataset$WARPED$.MODULE$);
    }

    public final Option<Object> noDataValue$extension1(long $this, GDALDataset.DatasetType datasetType) {
        Predef$.MODULE$.require(package$.MODULE$.acceptableDatasets().contains((Object)datasetType));
        double[] nodata = (double[])Array$.MODULE$.ofDim(1, ClassTag$.MODULE$.Double());
        int[] success = (int[])Array$.MODULE$.ofDim(1, ClassTag$.MODULE$.Int());
        int returnValue = GDALWarp.get_band_nodata($this, datasetType.value(), package$.MODULE$.numberOfAttempts(), 1, nodata, success);
        this.errorHandler$extension($this, returnValue, (Function1<Object, Throwable>)(Function1 & Serializable & scala.Serializable)positiveValue -> GDALDataset$.$anonfun$noDataValue$1(BoxesRunTime.unboxToInt((Object)positiveValue)));
        return success[0] == 0 ? None$.MODULE$ : OptionIdOps$.MODULE$.some$extension(package$option$.MODULE$.catsSyntaxOptionId(BoxesRunTime.boxToDouble((double)nodata[0])));
    }

    public final int dataType$extension0(long $this) {
        return this.dataType$extension1($this, GDALDataset$WARPED$.MODULE$);
    }

    public final int dataType$extension1(long $this, GDALDataset.DatasetType datasetType) {
        Predef$.MODULE$.require(package$.MODULE$.acceptableDatasets().contains((Object)datasetType));
        int[] dataType = (int[])Array$.MODULE$.ofDim(1, ClassTag$.MODULE$.Int());
        int returnValue = GDALWarp.get_band_data_type($this, datasetType.value(), package$.MODULE$.numberOfAttempts(), 1, dataType);
        this.errorHandler$extension($this, returnValue, (Function1<Object, Throwable>)(Function1 & Serializable & scala.Serializable)positiveValue -> GDALDataset$.$anonfun$dataType$1(BoxesRunTime.unboxToInt((Object)positiveValue)));
        return dataType[0];
    }

    public final CellSize cellSize$extension0(long $this) {
        return this.cellSize$extension1($this, GDALDataset$WARPED$.MODULE$);
    }

    public final CellSize cellSize$extension1(long $this, GDALDataset.DatasetType datasetType) {
        Predef$.MODULE$.require(package$.MODULE$.acceptableDatasets().contains((Object)datasetType));
        return this.cellSize$extension2($this, this.getTransform$extension1($this, datasetType));
    }

    public final CellSize cellSize$extension2(long $this, double[] transform) {
        double[] dArray = transform;
        Option option2 = Array$.MODULE$.unapplySeq((Object)dArray);
        if (option2.isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(6) != 0) {
            throw new MatchError((Object)dArray);
        }
        double xres = BoxesRunTime.unboxToDouble((Object)((SeqLike)option2.get()).apply(1));
        double xskew = BoxesRunTime.unboxToDouble((Object)((SeqLike)option2.get()).apply(2));
        double yskew = BoxesRunTime.unboxToDouble((Object)((SeqLike)option2.get()).apply(4));
        double yres = BoxesRunTime.unboxToDouble((Object)((SeqLike)option2.get()).apply(5));
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)xres), (Object)BoxesRunTime.boxToDouble((double)xskew), (Object)BoxesRunTime.boxToDouble((double)yskew), (Object)BoxesRunTime.boxToDouble((double)yres));
        Tuple4 tuple43 = tuple42;
        double xres2 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
        double xskew2 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
        double yskew2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
        double yres2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
        return xskew2 == 0.0 && yskew2 == 0.0 ? new CellSize(scala.math.package$.MODULE$.abs(xres2), scala.math.package$.MODULE$.abs(yres2)) : new CellSize(scala.math.package$.MODULE$.sqrt(xres2 * xres2 + yskew2 * yskew2), scala.math.package$.MODULE$.sqrt(xskew2 * xskew2 + yres2 * yres2));
    }

    public final DataType cellType$extension0(long $this) {
        return this.cellType$extension1($this, GDALDataset$WARPED$.MODULE$);
    }

    public final DataType cellType$extension1(long $this, GDALDataset.DatasetType datasetType) {
        LazyRef md$lzy = new LazyRef();
        LazyRef bitsPerSample$lzy = new LazyRef();
        LazyBoolean signedByte$lzy = new LazyBoolean();
        Predef$.MODULE$.require(package$.MODULE$.acceptableDatasets().contains((Object)datasetType));
        Option<Object> nd = this.noDataValue$extension1($this, datasetType);
        GDALDataType dt = GDALDataType$.MODULE$.intToGDALDataType(this.dataType$extension1($this, datasetType));
        return GDALUtils$.MODULE$.dataTypeToCellType(dt, nd, (Function0<Option<Object>>)(Function0 & Serializable & scala.Serializable)() -> GDALDataset$.bitsPerSample$1(bitsPerSample$lzy, md$lzy, $this), (Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> GDALDataset$.signedByte$1(signedByte$lzy, md$lzy, $this));
    }

    public final Tile readTile$extension(long $this, GridBounds<Object> gb, int band, GDALDataset.DatasetType datasetType) {
        Predef$.MODULE$.require(package$.MODULE$.acceptableDatasets().contains((Object)datasetType));
        GridBounds<Object> gridBounds = gb;
        if (gridBounds == null) {
            throw new MatchError(gridBounds);
        }
        int xmin = gridBounds.colMin$mcI$sp();
        int ymin = gridBounds.rowMin$mcI$sp();
        int xmax = gridBounds.colMax$mcI$sp();
        int ymax = gridBounds.rowMax$mcI$sp();
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)xmin), (Object)BoxesRunTime.boxToInteger((int)ymin), (Object)BoxesRunTime.boxToInteger((int)xmax), (Object)BoxesRunTime.boxToInteger((int)ymax));
        Tuple4 tuple43 = tuple42;
        int xmin2 = BoxesRunTime.unboxToInt((Object)tuple43._1());
        int ymin2 = BoxesRunTime.unboxToInt((Object)tuple43._2());
        int xmax2 = BoxesRunTime.unboxToInt((Object)tuple43._3());
        int ymax2 = BoxesRunTime.unboxToInt((Object)tuple43._4());
        int[] srcWindow = new int[]{xmin2, ymin2, xmax2 - xmin2 + 1, ymax2 - ymin2 + 1};
        int[] dstWindow = new int[]{srcWindow[2], srcWindow[3]};
        DataType ct = this.cellType$extension1($this, datasetType);
        int dt = this.dataType$extension1($this, datasetType);
        DataType dataType = ct;
        DataType dataType2 = BitCellType$.MODULE$.equals(dataType) ? ByteCellType$.MODULE$ : ct;
        DataType rct = dataType2;
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(dstWindow[0] * dstWindow[1] * rct.bytes(), ClassTag$.MODULE$.Byte());
        int returnValue = GDALWarp.get_data($this, datasetType.value(), package$.MODULE$.numberOfAttempts(), srcWindow, dstWindow, band, dt, bytes);
        this.errorHandler$extension($this, returnValue, (Function1<Object, Throwable>)(Function1 & Serializable & scala.Serializable)positiveValue -> GDALDataset$.$anonfun$readTile$1(BoxesRunTime.unboxToInt((Object)positiveValue)));
        MutableArrayTile tile = ArrayTile$.MODULE$.fromBytes(bytes, rct, dstWindow[0], dstWindow[1]);
        DataType dataType3 = ct;
        ArrayTile arrayTile = BitCellType$.MODULE$.equals(dataType3) ? tile.convert(ct) : tile;
        return arrayTile;
    }

    public final GridBounds<Object> readTile$default$1$extension(long $this) {
        return GridBounds$.MODULE$.apply(this.dimensions$extension0($this), Integral$.MODULE$.IntIsIntegral());
    }

    public final GDALDataset.DatasetType readTile$default$3$extension(long $this) {
        return GDALDataset$WARPED$.MODULE$;
    }

    public final MultibandTile readMultibandTile$extension(long $this, GridBounds<Object> gb, Seq<Object> bands, GDALDataset.DatasetType datasetType) {
        return MultibandTile$.MODULE$.apply((Traversable<Tile>)((Traversable)bands.map((Function1 & Serializable & scala.Serializable)x$18 -> GDALDataset$.MODULE$.readTile$extension($this, gb, BoxesRunTime.unboxToInt((Object)x$18), datasetType), Seq$.MODULE$.canBuildFrom())));
    }

    public final GridBounds<Object> readMultibandTile$default$1$extension(long $this) {
        return GridBounds$.MODULE$.apply(this.dimensions$extension0($this), Integral$.MODULE$.IntIsIntegral());
    }

    public final Seq<Object> readMultibandTile$default$2$extension(long $this) {
        return RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.bandCount$extension0($this));
    }

    public final GDALDataset.DatasetType readMultibandTile$default$3$extension(long $this) {
        return GDALDataset$WARPED$.MODULE$;
    }

    public final Raster<MultibandTile> readMultibandRaster$extension(long $this, GridBounds<Object> gb, Seq<Object> bands, GDALDataset.DatasetType datasetType) {
        return new Raster<MultibandTile>(this.readMultibandTile$extension($this, gb, bands, datasetType), this.rasterExtent$extension0($this).rasterExtentFor(gb).extent());
    }

    public final GridBounds<Object> readMultibandRaster$default$1$extension(long $this) {
        return GridBounds$.MODULE$.apply(this.dimensions$extension0($this), Integral$.MODULE$.IntIsIntegral());
    }

    public final Seq<Object> readMultibandRaster$default$2$extension(long $this) {
        return RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), this.bandCount$extension0($this));
    }

    public final GDALDataset.DatasetType readMultibandRaster$default$3$extension(long $this) {
        return GDALDataset$WARPED$.MODULE$;
    }

    public final void errorHandler$extension(long $this, int returnValue, Function1<Object, Throwable> exception) {
        if (returnValue <= 0) {
            throw (Throwable)exception.apply((Object)BoxesRunTime.boxToInteger((int)scala.math.package$.MODULE$.abs(returnValue)));
        }
    }

    public final long copy$extension(long $this, long token) {
        return token;
    }

    public final long copy$default$1$extension(long $this) {
        return $this;
    }

    public final String productPrefix$extension(long $this) {
        return "GDALDataset";
    }

    public final int productArity$extension(long $this) {
        return 1;
    }

    public final Object productElement$extension(long $this, int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return BoxesRunTime.boxToLong((long)$this);
    }

    public final Iterator<Object> productIterator$extension(long $this) {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)new GDALDataset($this));
    }

    public final boolean canEqual$extension(long $this, Object x$1) {
        return x$1 instanceof Long;
    }

    public final int hashCode$extension(long $this) {
        return Long.hashCode($this);
    }

    public final boolean equals$extension(long $this, Object x$1) {
        long l;
        Object object = x$1;
        boolean bl = object instanceof GDALDataset;
        return bl && $this == (l = ((GDALDataset)x$1).token());
    }

    public final String toString$extension(long $this) {
        return ScalaRunTime$.MODULE$._toString((Product)new GDALDataset($this));
    }

    public static final /* synthetic */ Map $anonfun$getAllMetadataFlatten$1(long $this$1, GDALDataset.DatasetType datasetType$1, int x$1) {
        return (Map)MODULE$.getAllMetadata$extension1($this$1, datasetType$1, x$1).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> (Map)x$2._2(), Map$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$getAllMetadata$2(Tuple2 x$5) {
        return ((TraversableOnce)x$5._2()).nonEmpty();
    }

    public static final /* synthetic */ MalformedDataException $anonfun$getMetadataDomainList$1(int positiveValue) {
        return new MalformedDataException(new StringBuilder(57).append("Unable to get the metadata domain list. GDAL Error Code: ").append(positiveValue).toString(), positiveValue);
    }

    public static final /* synthetic */ boolean $anonfun$getMetadataDomainList$3(String x$7) {
        return new StringOps(Predef$.MODULE$.augmentString(x$7)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$getMetadata$2(Tuple2 x$8) {
        return ((TraversableOnce)x$8._2()).nonEmpty();
    }

    public static final /* synthetic */ MalformedDataException $anonfun$getMetadata$3(int positiveValue) {
        return new MalformedDataException(new StringBuilder(57).append("Unable to get the metadata domain list. GDAL Error Code: ").append(positiveValue).toString(), positiveValue);
    }

    public static final /* synthetic */ boolean $anonfun$getMetadata$5(String x$10) {
        return new StringOps(Predef$.MODULE$.augmentString(x$10)).nonEmpty();
    }

    public static final /* synthetic */ MalformedDataException $anonfun$getMetadataItem$1(int positiveValue) {
        return new MalformedDataException(new StringBuilder(50).append("Unable to get the metadata item. GDAL Error Code: ").append(positiveValue).toString(), positiveValue);
    }

    public static final /* synthetic */ MalformedProjectionException $anonfun$getProjection$1(int positiveValue) {
        return new MalformedProjectionException(new StringBuilder(59).append("Unable to parse projection as WKT String. GDAL Error Code: ").append(positiveValue).toString(), positiveValue);
    }

    public static final /* synthetic */ MalformedDataException $anonfun$overviewDimensions$1(int positiveValue) {
        return new MalformedDataException(new StringBuilder(58).append("Unable to construct overview dimensions. GDAL Error Code: ").append(positiveValue).toString(), positiveValue);
    }

    public static final /* synthetic */ MalformedDataException $anonfun$dimensions$1(int positiveValue) {
        return new MalformedDataException(new StringBuilder(57).append("Unable to construct dataset dimensions. GDAL Error Code: ").append(positiveValue).toString(), positiveValue);
    }

    public static final /* synthetic */ MalformedDataException $anonfun$getTransform$1(int positiveValue) {
        return new MalformedDataException(new StringBuilder(83).append("Unable to construct a RasterExtent from the Transformation given. GDAL Error Code: ").append(positiveValue).toString(), positiveValue);
    }

    public static final /* synthetic */ MalformedDataException $anonfun$bandCount$1(int positiveValue) {
        return new MalformedDataException(new StringBuilder(48).append("A bandCount of <= 0 was found. GDAL Error Code: ").append(positiveValue).toString(), positiveValue);
    }

    public static final /* synthetic */ MalformedProjectionException $anonfun$crs$1(int positiveValue) {
        return new MalformedProjectionException(new StringBuilder(52).append("Unable to parse projection as CRS. GDAL Error Code: ").append(positiveValue).toString(), positiveValue);
    }

    public static final /* synthetic */ MalformedDataTypeException $anonfun$noDataValue$1(int positiveValue) {
        return new MalformedDataTypeException(new StringBuilder(55).append("Unable to determine NoData value. GDAL Exception Code: ").append(positiveValue).toString(), positiveValue);
    }

    public static final /* synthetic */ MalformedDataTypeException $anonfun$dataType$1(int positiveValue) {
        return new MalformedDataTypeException(new StringBuilder(47).append("Unable to determine DataType. GDAL Error Code: ").append(positiveValue).toString(), positiveValue);
    }

    private static final /* synthetic */ Map md$lzycompute$1(LazyRef md$lzy$1, long $this$4) {
        Map map2;
        LazyRef lazyRef = md$lzy$1;
        synchronized (lazyRef) {
            map2 = md$lzy$1.initialized() ? (Map)md$lzy$1.value() : (Map)md$lzy$1.initialize(MODULE$.getMetadata$extension2($this$4, ImageStructureDomain$.MODULE$, 1));
        }
        return map2;
    }

    private static final Map md$1(LazyRef md$lzy$1, long $this$4) {
        return md$lzy$1.initialized() ? (Map)md$lzy$1.value() : GDALDataset$.md$lzycompute$1(md$lzy$1, $this$4);
    }

    public static final /* synthetic */ int $anonfun$cellType$1(String x$16) {
        return new StringOps(Predef$.MODULE$.augmentString(x$16)).toInt();
    }

    private static final /* synthetic */ Option bitsPerSample$lzycompute$1(LazyRef bitsPerSample$lzy$1, LazyRef md$lzy$1, long $this$4) {
        Option option2;
        LazyRef lazyRef = bitsPerSample$lzy$1;
        synchronized (lazyRef) {
            option2 = bitsPerSample$lzy$1.initialized() ? (Option)bitsPerSample$lzy$1.value() : (Option)bitsPerSample$lzy$1.initialize((Object)GDALDataset$.md$1(md$lzy$1, $this$4).get((Object)"NBITS").map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)GDALDataset$.$anonfun$cellType$1(x$16))));
        }
        return option2;
    }

    private static final Option bitsPerSample$1(LazyRef bitsPerSample$lzy$1, LazyRef md$lzy$1, long $this$4) {
        return bitsPerSample$lzy$1.initialized() ? (Option)bitsPerSample$lzy$1.value() : GDALDataset$.bitsPerSample$lzycompute$1(bitsPerSample$lzy$1, md$lzy$1, $this$4);
    }

    private static final /* synthetic */ boolean signedByte$lzycompute$1(LazyBoolean signedByte$lzy$1, LazyRef md$lzy$1, long $this$4) {
        boolean bl;
        LazyBoolean lazyBoolean = signedByte$lzy$1;
        synchronized (lazyBoolean) {
            bl = signedByte$lzy$1.initialized() ? signedByte$lzy$1.value() : signedByte$lzy$1.initialize(GDALDataset$.md$1(md$lzy$1, $this$4).get((Object)"PIXELTYPE").contains((Object)"SIGNEDBYTE"));
        }
        return bl;
    }

    private static final boolean signedByte$1(LazyBoolean signedByte$lzy$1, LazyRef md$lzy$1, long $this$4) {
        return signedByte$lzy$1.initialized() ? signedByte$lzy$1.value() : GDALDataset$.signedByte$lzycompute$1(signedByte$lzy$1, md$lzy$1, $this$4);
    }

    public static final /* synthetic */ GDALIOException $anonfun$readTile$1(int positiveValue) {
        return new GDALIOException(new StringBuilder(41).append("Unable to read in data. GDAL Error Code: ").append(positiveValue).toString(), positiveValue);
    }

    private GDALDataset$() {
        MODULE$ = this;
        GDALOptionsConfig$.MODULE$.setOptions();
    }
}

