/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.interpolation;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import geotrellis.raster.interpolation.InverseDistanceWeighted;
import geotrellis.raster.interpolation.InverseDistanceWeighted$Options$;
import geotrellis.vector.Extent;
import geotrellis.vector.Feature;
import geotrellis.vector.SpatialIndex;
import geotrellis.vector.SpatialIndex$;
import java.io.Serializable;
import org.locationtech.jts.geom.Point;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple8;
import scala.collection.Traversable;
import scala.collection.immutable.Vector;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;

public final class InverseDistanceWeighted$ {
    public static InverseDistanceWeighted$ MODULE$;

    static {
        new InverseDistanceWeighted$();
    }

    public <D> Raster<Tile> apply(Traversable<Feature<Point, D>> points, RasterExtent rasterExtent, InverseDistanceWeighted.Options options, Function1<D, Object> ev) {
        InverseDistanceWeighted.Options options2 = options;
        if (options2 == null) {
            throw new MatchError((Object)options2);
        }
        double radiusX = options2.radiusX();
        double radiusY = options2.radiusY();
        double rotation = options2.rotation();
        double weightingPower = options2.weightingPower();
        double smoothingFactor = options2.smoothingFactor();
        double equalWeightRadius = options2.equalWeightRadius();
        DataType cellType = options2.cellType();
        Function1<Object, Object> onSet = options2.onSet();
        Tuple8 tuple8 = new Tuple8((Object)BoxesRunTime.boxToDouble((double)radiusX), (Object)BoxesRunTime.boxToDouble((double)radiusY), (Object)BoxesRunTime.boxToDouble((double)rotation), (Object)BoxesRunTime.boxToDouble((double)weightingPower), (Object)BoxesRunTime.boxToDouble((double)smoothingFactor), (Object)BoxesRunTime.boxToDouble((double)equalWeightRadius), (Object)cellType, onSet);
        Tuple8 tuple82 = tuple8;
        double radiusX2 = BoxesRunTime.unboxToDouble((Object)tuple82._1());
        double radiusY2 = BoxesRunTime.unboxToDouble((Object)tuple82._2());
        double rotation2 = BoxesRunTime.unboxToDouble((Object)tuple82._3());
        double weightingPower2 = BoxesRunTime.unboxToDouble((Object)tuple82._4());
        double smoothingFactor2 = BoxesRunTime.unboxToDouble((Object)tuple82._5());
        double equalWeightRadius2 = BoxesRunTime.unboxToDouble((Object)tuple82._6());
        DataType cellType2 = (DataType)tuple82._7();
        Function1 onSet2 = (Function1)tuple82._8();
        int cols = rasterExtent.cols();
        int rows = rasterExtent.rows();
        MutableArrayTile tile = ArrayTile$.MODULE$.empty(cellType2, cols, rows);
        if (!points.isEmpty()) {
            double ewr2 = equalWeightRadius2 * equalWeightRadius2;
            double radiusXSquared = radiusX2 * radiusX2;
            double radiusYSquared = radiusY2 * radiusY2;
            double radiusXYSquared = radiusXSquared * radiusYSquared;
            double d = radiusX2 * radiusY2;
            if (Double.isInfinite(d)) {
                for (int index$macro$2 = 0; index$macro$2 < rows; ++index$macro$2) {
                    for (int index$macro$1 = 0; index$macro$1 < cols; ++index$macro$1) {
                        double x = rasterExtent.gridColToMap$mcI$sp(index$macro$1);
                        double y = rasterExtent.gridRowToMap$mcI$sp(index$macro$2);
                        double value = InverseDistanceWeighted$.idw$1(points, x, y, false, weightingPower2, smoothingFactor2, rotation2, radiusYSquared, radiusXSquared, radiusXYSquared, ev, ewr2, onSet2);
                        tile.setDouble(index$macro$1, index$macro$2, value);
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                SpatialIndex<Feature<Point, D>> index = SpatialIndex$.MODULE$.apply(points, (Function1 & Serializable & scala.Serializable)p -> new Tuple2.mcDD.sp(geotrellis.vector.package$.MODULE$.withExtraPointMethods((Point)p.geom()).x(), geotrellis.vector.package$.MODULE$.withExtraPointMethods((Point)p.geom()).y()));
                for (int index$macro$4 = 0; index$macro$4 < rows; ++index$macro$4) {
                    for (int index$macro$3 = 0; index$macro$3 < cols; ++index$macro$3) {
                        double y;
                        double x = rasterExtent.gridColToMap$mcI$sp(index$macro$3);
                        Vector<Feature<Point, D>> rPoints = index.pointsInExtent(new Extent(x - radiusX2, (y = rasterExtent.gridRowToMap$mcI$sp(index$macro$4)) - radiusY2, x + radiusX2, y + radiusY2));
                        double value = rPoints.isEmpty() ? Double.NaN : InverseDistanceWeighted$.idw$1(rPoints, x, y, true, weightingPower2, smoothingFactor2, rotation2, radiusYSquared, radiusXSquared, radiusXYSquared, ev, ewr2, onSet2);
                        tile.setDouble(index$macro$3, index$macro$4, value);
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
        return new Raster<Tile>(tile, rasterExtent.extent());
    }

    public <D> InverseDistanceWeighted.Options apply$default$3() {
        return InverseDistanceWeighted$Options$.MODULE$.DEFAULT();
    }

    public static final /* synthetic */ void $anonfun$apply$1(double x$11, double y$1, double smoothingFactor$1, double rotation$1, boolean hasRadius$1, double radiusYSquared$1, double radiusXSquared$1, double radiusXYSquared$1, Function1 ev$1, double ewr2$1, DoubleRef sampleSum$1, IntRef sampleCount$1, double halfPow$1, DoubleRef sum$1, DoubleRef weightSum$1, IntRef count$1, Feature point) {
        block5: {
            Tuple2.mcDD.sp sp2;
            Tuple2.mcDD.sp sp3;
            double dX = x$11 - geotrellis.vector.package$.MODULE$.withExtraPointMethods((Point)point.geom()).x();
            double dY = y$1 - geotrellis.vector.package$.MODULE$.withExtraPointMethods((Point)point.geom()).y();
            double d2 = dX * dX + dY * dY + smoothingFactor$1 * smoothingFactor$1;
            if (rotation$1 != 0.0) {
                double rotRads = package$.MODULE$.toRadians(rotation$1);
                double coeff1 = package$.MODULE$.cos(rotRads);
                double coeff2 = package$.MODULE$.sin(rotRads);
                double dXRotated = dX * coeff1 + dY * coeff2;
                double dYRotated = dY * coeff1 - dX * coeff2;
                sp3 = new Tuple2.mcDD.sp(dXRotated, dYRotated);
            } else {
                sp3 = sp2 = new Tuple2.mcDD.sp(dX, dY);
            }
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            double dX2 = sp2._1$mcD$sp();
            double dY2 = sp2._2$mcD$sp();
            Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(dX2, dY2);
            Tuple2.mcDD.sp sp5 = sp4;
            double dX22 = sp5._1$mcD$sp();
            double dY22 = sp5._2$mcD$sp();
            if (hasRadius$1 && !(radiusYSquared$1 * dX22 * dX22 + radiusXSquared$1 * dY22 * dY22 <= radiusXYSquared$1)) break block5;
            double data = BoxesRunTime.unboxToDouble((Object)ev$1.apply(point.data()));
            if (d2 <= ewr2$1) {
                sampleSum$1.elem += data;
                ++sampleCount$1.elem;
            } else {
                double powerWeight = package$.MODULE$.pow(d2, halfPow$1);
                double w = 1.0 / powerWeight;
                sum$1.elem += data * w;
                weightSum$1.elem += w;
                ++count$1.elem;
            }
        }
    }

    private static final double idw$1(Traversable points, double x, double y, boolean hasRadius, double weightingPower$1, double smoothingFactor$1, double rotation$1, double radiusYSquared$1, double radiusXSquared$1, double radiusXYSquared$1, Function1 ev$1, double ewr2$1, Function1 onSet$1) {
        DoubleRef sum = DoubleRef.create((double)0.0);
        IntRef count = IntRef.create((int)0);
        DoubleRef weightSum = DoubleRef.create((double)0.0);
        DoubleRef sampleSum = DoubleRef.create((double)0.0);
        IntRef sampleCount = IntRef.create((int)0);
        double halfPow = weightingPower$1 / 2.0;
        points.foreach((Function1 & Serializable & scala.Serializable)point -> {
            InverseDistanceWeighted$.$anonfun$apply$1(x, y, smoothingFactor$1, rotation$1, hasRadius, radiusYSquared$1, radiusXSquared$1, radiusXYSquared$1, ev$1, ewr2$1, sampleSum, sampleCount, halfPow, sum, weightSum, count, point);
            return BoxedUnit.UNIT;
        });
        return sampleCount.elem == 0 ? (count.elem == 0 ? Double.NaN : onSet$1.apply$mcDD$sp(sum.elem / weightSum.elem)) : onSet$1.apply$mcDD$sp(sampleSum.elem / (double)sampleCount.elem);
    }

    private InverseDistanceWeighted$() {
        MODULE$ = this;
    }
}

