/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.writer;

import geotrellis.proj4.CRS;
import geotrellis.raster.PixelIsPoint$;
import geotrellis.raster.PixelSampleType;
import geotrellis.raster.io.geotiff.tags.AngularUnitTypes$;
import geotrellis.raster.io.geotiff.tags.CommonPublicValues$;
import geotrellis.raster.io.geotiff.tags.CoordinateTransformTypes$;
import geotrellis.raster.io.geotiff.tags.DatumTypes$;
import geotrellis.raster.io.geotiff.tags.EllipsoidTypes$;
import geotrellis.raster.io.geotiff.tags.GeoKeys$;
import geotrellis.raster.io.geotiff.tags.GeographicCSTypes$;
import geotrellis.raster.io.geotiff.tags.ModelTypes$;
import geotrellis.raster.io.geotiff.tags.ProjectedLinearUnits$;
import geotrellis.raster.io.geotiff.tags.ProjectionTypesMap$;
import geotrellis.raster.io.geotiff.writer.CoordinateSystemParser$;
import geotrellis.raster.io.geotiff.writer.GeoTiffWriterLimitationException;
import geotrellis.raster.io.geotiff.writer.MalformedProj4Exception;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005ev!\u0002\u0016,\u0011\u00031d!\u0002\u001d,\u0011\u0003I\u0004\"\u0002!\u0002\t\u0003\t\u0005b\u0002\"\u0002\u0005\u0004%\ta\u0011\u0005\u0007\u000f\u0006\u0001\u000b\u0011\u0002#\t\u000b!\u000bA\u0011A%\t\u000f\u0005}\u0011\u0001\"\u0001\u0002.\u001a!\u0001h\u000b\u0001L\u0011!auA!b\u0001\n\u0003i\u0005\u0002\u0003+\b\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011U;!Q1A\u0005\u0002YC\u0001BX\u0004\u0003\u0002\u0003\u0006Ia\u0016\u0005\u0006\u0001\u001e!\ta\u0018\u0005\bE\u001e\u0011\r\u0011\"\u0003d\u0011\u0019yw\u0001)A\u0005I\"9\u0001o\u0002b\u0001\n\u0013\t\bB\u0002>\bA\u0003%!\u000f\u0003\u0006|\u000fA\u0005\tr1Q\u0005\nqD\u0011\"a\u0004\b\u0011\u000b\u0007I\u0011B\"\t\u0015\u0005Eq\u0001#b\u0001\n\u0013\t\u0019\u0002\u0003\u0007\u0002\u0016\u001d\u0001\n\u0011cb!\n\u0013\t9\u0002C\u0005\u0002\u001c\u001dA)\u0019!C\u0005\u0007\"I\u0011QD\u0004\t\u0006\u0004%Ia\u0011\u0005\u000b\u0003?9\u0001R1A\u0005\u0002\u0005\u0005\u0002BCA\u001a\u000f!\u0015\r\u0011\"\u0003\u00026!Q\u00111I\u0004\t\u0006\u0004%I!!\u000e\t\u0015\u0005\u0015s\u0001#b\u0001\n\u0013\t)\u0004\u0003\u0006\u0002H\u001dA)\u0019!C\u0005\u0003kA!\"!\u0013\b\u0011\u000b\u0007I\u0011BA\u001b\u0011)\tYe\u0002EC\u0002\u0013%\u0011Q\n\u0005\u000b\u0003/:\u0001R1A\u0005\n\u00055\u0003BCA-\u000f!\u0015\r\u0011\"\u0003\u00026!Q\u00111L\u0004\t\u0006\u0004%I!!\u000e\t\u0015\u0005us\u0001#b\u0001\n\u0013\t)\u0004\u0003\u0006\u0002`\u001dA)\u0019!C\u0005\u0003kAq!!\u0019\b\t\u0013\t\u0019\u0007C\u0004\u0002p\u001d!I!!\u001d\t\u000f\u0005et\u0001\"\u0003\u0002|!I\u0011\u0011Q\u0004\u0012\u0002\u0013%\u00111\u0011\u0005\b\u00033;A\u0011BAN\u0011%\t\tkBI\u0001\n\u0013\t\u0019\tC\u0004\u0002$\u001e!I!!*\u0002-\r{wN\u001d3j]\u0006$XmU=ti\u0016l\u0007+\u0019:tKJT!\u0001L\u0017\u0002\r]\u0014\u0018\u000e^3s\u0015\tqs&A\u0004hK>$\u0018N\u001a4\u000b\u0005A\n\u0014AA5p\u0015\t\u00114'\u0001\u0004sCN$XM\u001d\u0006\u0002i\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001A\u0011q'A\u0007\u0002W\t12i\\8sI&t\u0017\r^3TsN$X-\u001c)beN,'o\u0005\u0002\u0002uA\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u001c\u0002!\u001d+w\u000eV5gM\u0012{WO\u00197f)\u0006<W#\u0001#\u0011\u0005m*\u0015B\u0001$=\u0005\rIe\u000e^\u0001\u0012\u000f\u0016|G+\u001b4g\t>,(\r\\3UC\u001e\u0004\u0013!B1qa2LH#\u0002&\u0002*\u0006-\u0006CA\u001c\b'\t9!(A\u0002deN,\u0012A\u0014\t\u0003\u001fJk\u0011\u0001\u0015\u0006\u0003#N\nQ\u0001\u001d:pURJ!a\u0015)\u0003\u0007\r\u00136+\u0001\u0003deN\u0004\u0013a\u00049jq\u0016d7+Y7qY\u0016$\u0016\u0010]3\u0016\u0003]\u00032a\u000f-[\u0013\tIFH\u0001\u0004PaRLwN\u001c\t\u00037rk\u0011!M\u0005\u0003;F\u0012q\u0002U5yK2\u001c\u0016-\u001c9mKRK\b/Z\u0001\u0011a&DX\r\\*b[BdW\rV=qK\u0002\"2A\u00131b\u0011\u0015aE\u00021\u0001O\u0011\u0015)F\u00021\u0001X\u0003-\u0001(o\u001c65'R\u0014\u0018N\\4\u0016\u0003\u0011\u0004\"!\u001a7\u000f\u0005\u0019T\u0007CA4=\u001b\u0005A'BA56\u0003\u0019a$o\\8u}%\u00111\u000eP\u0001\u0007!J,G-\u001a4\n\u00055t'AB*ue&twM\u0003\u0002ly\u0005a\u0001O]8kiM#(/\u001b8hA\u0005A\u0001O]8ki5\u000b\u0007/F\u0001s!\u0011\u0019\b\u0010\u001a3\u000e\u0003QT!!\u001e<\u0002\u0013%lW.\u001e;bE2,'BA<=\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003sR\u00141!T1q\u0003%\u0001(o\u001c65\u001b\u0006\u0004\b%A\u0002yIY*\u0012! \t\u0006wy$\u0015\u0011A\u0005\u0003\u007fr\u0012a\u0001V;qY\u0016\u0014\u0004\u0003B\u001eY\u0003\u0007\u0001\u0012bOA\u0003\u0003\u0013\tI!!\u0003\n\u0007\u0005\u001dAH\u0001\u0004UkBdWm\r\t\u0004w\u0005-\u0011bAA\u0007y\t1Ai\\;cY\u0016\f\u0011\"\u001a7mSB\u001cx.\u001b3\u0002\u0011=\u0004HoU3nSN,\"!!\u0001\u0002\u0007a$s'\u0006\u0002\u0002\u001aA!1H #E\u0003\r97m]\u0001\u0006I\u0006$X/\\\u0001\u0006a\u0006\u00148/Z\u000b\u0003\u0003G\u0001ba\u000f@\u0002&\u0005E\u0002#B\u001e\u0002(\u0005-\u0012bAA\u0015y\t)\u0011I\u001d:bsB91(!\fE\t\u0012#\u0015bAA\u0018y\t1A+\u001e9mKR\u0002RaOA\u0014\u0003\u0013\t\u0011\u0002\u001d:pUB\u0013x\u000e]:\u0016\u0005\u0005]\u0002CB\u001e\u007f\u0003s\ty\u0004E\u0003t\u0003w\tI\"C\u0002\u0002>Q\u0014A\u0001T5tiB)1/a\u000f\u0002BA)1H #\u0002\n\u0005QA/\\3sGB\u0013x\u000e]:\u0002\u00135,'o\u0019)s_B\u001c\u0018\u0001C;u[B\u0013x\u000e]:\u0002\u00111\u001c7\r\u0015:paN\fA\u0002\\8oO2\u000bG\u000f\u0015:paN,\"!a\u0014\u0011\rmr\u0018\u0011HA)\u001d\r\u0019\u00181K\u0005\u0004\u0003+\"\u0018a\u0001(jY\u0006yqmY:Pe\u0012\u000bG/^7Qe>\u00048/\u0001\bfY2L\u0007o]8jIB\u0013x\u000e]:\u0002\u0013MLg.\u001e)s_B\u001c\u0018a\u00047j]\u0016\f'/\u00168jiB\u0013x\u000e]:\u0002\u0011\u0005,\u0017\r\u0015:paN\f\u0011\"[:EK\u001aLg.\u001a3\u0015\t\u0005\u0015\u00141\u000e\t\u0004w\u0005\u001d\u0014bAA5y\t9!i\\8mK\u0006t\u0007BBA7G\u0001\u0007A-A\u0002lKf\f\u0011bZ3u'R\u0014\u0018N\\4\u0015\u000b\u0011\f\u0019(!\u001e\t\r\u00055D\u00051\u0001e\u0011\u0019\t9\b\na\u0001I\u0006!A-\u001a4W\u0003\u00199W\r^%oiR)A)! \u0002\u0000!1\u0011QN\u0013A\u0002\u0011D\u0001\"a\u001e&!\u0003\u0005\r\u0001Z\u0001\u0011O\u0016$\u0018J\u001c;%I\u00164\u0017-\u001e7uII*\"!!\"+\u0007\u0011\f9i\u000b\u0002\u0002\nB!\u00111RAK\u001b\t\tiI\u0003\u0003\u0002\u0010\u0006E\u0015!C;oG\",7m[3e\u0015\r\t\u0019\nP\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAL\u0003\u001b\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003%9W\r\u001e#pk\ndW\r\u0006\u0004\u0002\n\u0005u\u0015q\u0014\u0005\u0007\u0003[:\u0003\u0019\u00013\t\u0011\u0005]t\u0005%AA\u0002\u0011\f1cZ3u\t>,(\r\\3%I\u00164\u0017-\u001e7uII\nAaZ3u\u0017R!\u0011\u0011BAT\u0011\u001d\t9(\u000ba\u0001\u0003\u0013AQ\u0001T\u0003A\u00029CQ!V\u0003A\u0002]#b!a,\u00026\u0006]\u0006cA\u001c\u00022&\u0019\u00111W\u0016\u0003!\u001d+w\u000eR5sK\u000e$xN]=UC\u001e\u001c\b\"\u0002'\u0007\u0001\u0004q\u0005\"B+\u0007\u0001\u00049\u0006")
public class CoordinateSystemParser {
    private Tuple2<Object, Option<Tuple3<Object, Object, Object>>> x$6;
    private int ellipsoid;
    private Option<Tuple3<Object, Object, Object>> optSemis;
    private Tuple2<Object, Object> x$7;
    private int gcs;
    private int datum;
    private Tuple2<Tuple4<Object, Object, Object, Object>[], double[]> parse;
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> projProps;
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> tmercProps;
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> mercProps;
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> utmProps;
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> lccProps;
    private Tuple2<List<Tuple2<Object, Object>>, Nil$> longLatProps;
    private Tuple2<List<Tuple2<Object, Object>>, Nil$> gcsOrDatumProps;
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> ellipsoidProps;
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> sinuProps;
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> linearUnitProps;
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> aeaProps;
    private final CRS crs;
    private final Option<PixelSampleType> pixelSampleType;
    private final String proj4String;
    private final Map<String, String> proj4Map;
    private volatile int bitmap$0;

    public static CoordinateSystemParser apply(CRS cRS, Option<PixelSampleType> option2) {
        return CoordinateSystemParser$.MODULE$.apply(cRS, option2);
    }

    public static int GeoTiffDoubleTag() {
        return CoordinateSystemParser$.MODULE$.GeoTiffDoubleTag();
    }

    public CRS crs() {
        return this.crs;
    }

    public Option<PixelSampleType> pixelSampleType() {
        return this.pixelSampleType;
    }

    private String proj4String() {
        return this.proj4String;
    }

    private Map<String, String> proj4Map() {
        return this.proj4Map;
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<Object, Option<Tuple3<Object, Object, Object>>> x$6$lzycompute() {
        block12: {
            var3_1 = this;
            synchronized (var3_1) {
                if ((this.bitmap$0 & 1) != 0) break block12;
                var5_2 = false;
                var6_3 = null;
                var7_4 = this.proj4Map().get((Object)"ellps");
                if (!(var7_4 instanceof Some)) ** GOTO lbl-1000
                var5_2 = true;
                var6_3 = (Some)var7_4;
                var8_5 = (String)var6_3.value();
                if ("WGS84".equals(var8_5)) {
                    var2_6 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)EllipsoidTypes$.MODULE$.Ellipse_WGS_84()), (Object)None$.MODULE$);
                } else if (var5_2 && "clrk66".equals(var9_7 = (String)var6_3.value())) {
                    var2_6 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)EllipsoidTypes$.MODULE$.Ellipse_Clarke_1866()), (Object)None$.MODULE$);
                } else if (var5_2 && "clrk80".equals(var10_8 = (String)var6_3.value())) {
                    var2_6 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)EllipsoidTypes$.MODULE$.Ellipse_Clarke_1880()), (Object)None$.MODULE$);
                } else if (var5_2 && "GRS80".equals(var11_9 = (String)var6_3.value())) {
                    var2_6 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)EllipsoidTypes$.MODULE$.Ellipse_GRS_1980()), (Object)None$.MODULE$);
                } else {
                    ellps = CommonPublicValues$.MODULE$.UserDefinedCPV();
                    major = this.getDouble("a", this.getDouble$default$2());
                    minor = this.getDouble("b", this.getDouble$default$2());
                    invFlattening = this.getDouble("rf", this.getDouble$default$2());
                    var2_6 = invFlattening == 0.0 && minor != 0.0 ? new Tuple2((Object)BoxesRunTime.boxToInteger((int)ellps), (Object)new Some((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)major), (Object)BoxesRunTime.boxToDouble((double)minor), (Object)BoxesRunTime.boxToDouble((double)((double)-1 / (minor / major - (double)true)))))) : new Tuple2((Object)BoxesRunTime.boxToInteger((int)ellps), (Object)new Some((Object)new Tuple3((Object)BoxesRunTime.boxToDouble((double)major), (Object)BoxesRunTime.boxToDouble((double)minor), (Object)BoxesRunTime.boxToDouble((double)invFlattening))));
                }
                var4_14 = var2_6;
                if (var4_14 == null) {
                    throw new MatchError((Object)var4_14);
                }
                ellipsoid = var4_14._1$mcI$sp();
                optSemis = (Option)var4_14._2();
                var1_17 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)ellipsoid), (Object)optSemis);
                this.x$6 = var1_17;
                this.bitmap$0 |= 1;
            }
        }
        return this.x$6;
    }

    private /* synthetic */ Tuple2 x$6() {
        return (this.bitmap$0 & 1) == 0 ? this.x$6$lzycompute() : this.x$6;
    }

    private int ellipsoid$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 2) == 0) {
                this.ellipsoid = this.x$6()._1$mcI$sp();
                this.bitmap$0 |= 2;
            }
        }
        return this.ellipsoid;
    }

    private int ellipsoid() {
        return (this.bitmap$0 & 2) == 0 ? this.ellipsoid$lzycompute() : this.ellipsoid;
    }

    private Option<Tuple3<Object, Object, Object>> optSemis$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 4) == 0) {
                this.optSemis = (Option)this.x$6()._2();
                this.bitmap$0 |= 4;
            }
        }
        return this.optSemis;
    }

    private Option<Tuple3<Object, Object, Object>> optSemis() {
        return (this.bitmap$0 & 4) == 0 ? this.optSemis$lzycompute() : this.optSemis;
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<Object, Object> x$7$lzycompute() {
        block6: {
            var3_1 = this;
            synchronized (var3_1) {
                if ((this.bitmap$0 & 8) != 0) break block6;
                var5_2 = false;
                var6_3 = null;
                var7_4 = this.proj4Map().get((Object)"datum");
                if (!(var7_4 instanceof Some)) ** GOTO lbl-1000
                var5_2 = true;
                var6_3 = (Some)var7_4;
                var8_5 = (String)var6_3.value();
                if ("WGS84".equals(var8_5)) {
                    var2_6 = new Tuple2.mcII.sp(GeographicCSTypes$.MODULE$.GCS_WGS_84(), DatumTypes$.MODULE$.Datum_WGS84());
                } else lbl-1000:
                // 2 sources

                {
                    var2_6 = var5_2 != false && "NAD83".equals(var9_7 = (String)var6_3.value()) != false ? new Tuple2.mcII.sp(GeographicCSTypes$.MODULE$.GCS_NAD83(), DatumTypes$.MODULE$.Datum_North_American_Datum_1983()) : (var5_2 != false && "NAD27".equals(var10_8 = (String)var6_3.value()) != false ? new Tuple2.mcII.sp(GeographicCSTypes$.MODULE$.GCS_NAD27(), DatumTypes$.MODULE$.Datum_North_American_Datum_1927()) : new Tuple2.mcII.sp(CommonPublicValues$.MODULE$.UserDefinedCPV(), CommonPublicValues$.MODULE$.UserDefinedCPV()));
                }
                var4_9 = var2_6;
                if (var4_9 == null) {
                    throw new MatchError((Object)var4_9);
                }
                gcs = var4_9._1$mcI$sp();
                datum = var4_9._2$mcI$sp();
                var1_12 = new Tuple2.mcII.sp(gcs, datum);
                this.x$7 = var1_12;
                this.bitmap$0 |= 8;
            }
        }
        return this.x$7;
    }

    private /* synthetic */ Tuple2 x$7() {
        return (this.bitmap$0 & 8) == 0 ? this.x$7$lzycompute() : this.x$7;
    }

    private int gcs$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x10) == 0) {
                this.gcs = this.x$7()._1$mcI$sp();
                this.bitmap$0 |= 0x10;
            }
        }
        return this.gcs;
    }

    private int gcs() {
        return (this.bitmap$0 & 0x10) == 0 ? this.gcs$lzycompute() : this.gcs;
    }

    private int datum$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x20) == 0) {
                this.datum = this.x$7()._2$mcI$sp();
                this.bitmap$0 |= 0x20;
            }
        }
        return this.datum;
    }

    private int datum() {
        return (this.bitmap$0 & 0x20) == 0 ? this.datum$lzycompute() : this.datum;
    }

    private Tuple2<Tuple4<Object, Object, Object, Object>[], double[]> parse$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x40) == 0) {
                ListBuffer listBuffer;
                Some some;
                PixelSampleType pixelSampleType;
                ListBuffer geoKeysIntBuffer = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                ListBuffer doublesBuffer = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                Option<PixelSampleType> option2 = this.pixelSampleType();
                ListBuffer listBuffer2 = option2 instanceof Some && PixelIsPoint$.MODULE$.equals(pixelSampleType = (PixelSampleType)(some = (Some)option2).value()) ? geoKeysIntBuffer.$plus$plus$eq((TraversableOnce)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTRasterTypeGeoKey(), 2), (List)Nil$.MODULE$)) : geoKeysIntBuffer.$plus$plus$eq((TraversableOnce)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTRasterTypeGeoKey(), 1), (List)Nil$.MODULE$));
                int epsgCode = BoxesRunTime.unboxToInt((Object)this.crs().epsgCode().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ProjectionTypesMap$.MODULE$.UserDefinedProjectionType()));
                if (epsgCode != ProjectionTypesMap$.MODULE$.UserDefinedProjectionType()) {
                    .colon.colon projPropsGeoKeysInt = this.crs().isGeographic() ? new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTModelTypeGeoKey(), ModelTypes$.MODULE$.ModelTypeGeographic()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GeogTypeGeoKey(), epsgCode), (List)Nil$.MODULE$)) : new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTModelTypeGeoKey(), ModelTypes$.MODULE$.ModelTypeProjected()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GeogAngularUnitsGeoKey(), 9102), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectedCSTypeGeoKey(), epsgCode), (List)Nil$.MODULE$)));
                    listBuffer = geoKeysIntBuffer.$plus$plus$eq((TraversableOnce)projPropsGeoKeysInt);
                } else {
                    Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> tuple22 = this.projProps();
                    if (tuple22 == null) {
                        throw new MatchError(tuple22);
                    }
                    List projPropsGeoKeysInt = (List)tuple22._1();
                    List projPropsDoubles = (List)tuple22._2();
                    Tuple2 tuple23 = new Tuple2((Object)projPropsGeoKeysInt, (Object)projPropsDoubles);
                    Tuple2 tuple24 = tuple23;
                    List projPropsGeoKeysInt2 = (List)tuple24._1();
                    List projPropsDoubles2 = (List)tuple24._2();
                    geoKeysIntBuffer.$plus$plus$eq((TraversableOnce)projPropsGeoKeysInt2);
                    doublesBuffer.$plus$plus$eq((TraversableOnce)projPropsDoubles2);
                    Tuple2<List<Tuple2<Object, Object>>, Nil$> tuple25 = this.gcsOrDatumProps();
                    if (tuple25 == null) {
                        throw new MatchError(tuple25);
                    }
                    List gcsOrDatumGeoKeysInt = (List)tuple25._1();
                    Nil$ gcsOrDatumDoubles = (Nil$)tuple25._2();
                    Tuple2 tuple26 = new Tuple2((Object)gcsOrDatumGeoKeysInt, (Object)gcsOrDatumDoubles);
                    Tuple2 tuple27 = tuple26;
                    List gcsOrDatumGeoKeysInt2 = (List)tuple27._1();
                    Nil$ gcsOrDatumDoubles2 = (Nil$)tuple27._2();
                    geoKeysIntBuffer.$plus$plus$eq((TraversableOnce)gcsOrDatumGeoKeysInt2);
                    doublesBuffer.$plus$plus$eq((TraversableOnce)gcsOrDatumDoubles2);
                    Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> tuple28 = this.ellipsoidProps();
                    if (tuple28 == null) {
                        throw new MatchError(tuple28);
                    }
                    List ellipsoidGeoKeysInt = (List)tuple28._1();
                    List ellipsoidDoubles = (List)tuple28._2();
                    Tuple2 tuple29 = new Tuple2((Object)ellipsoidGeoKeysInt, (Object)ellipsoidDoubles);
                    Tuple2 tuple210 = tuple29;
                    List ellipsoidGeoKeysInt2 = (List)tuple210._1();
                    List ellipsoidDoubles2 = (List)tuple210._2();
                    geoKeysIntBuffer.$plus$plus$eq((TraversableOnce)ellipsoidGeoKeysInt2);
                    listBuffer = doublesBuffer.$plus$plus$eq((TraversableOnce)ellipsoidDoubles2);
                }
                Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> tuple211 = this.linearUnitProps();
                if (tuple211 == null) {
                    throw new MatchError(tuple211);
                }
                List linearUnitsGeoKeysInt = (List)tuple211._1();
                List linearUnitsDoubles = (List)tuple211._2();
                Tuple2 tuple212 = new Tuple2((Object)linearUnitsGeoKeysInt, (Object)linearUnitsDoubles);
                Tuple2 tuple213 = tuple212;
                List linearUnitsGeoKeysInt2 = (List)tuple213._1();
                List linearUnitsDoubles2 = (List)tuple213._2();
                geoKeysIntBuffer.$plus$plus$eq((TraversableOnce)linearUnitsGeoKeysInt2);
                doublesBuffer.$plus$plus$eq((TraversableOnce)linearUnitsDoubles2);
                List doubles = (List)doublesBuffer.toList().sortBy((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$);
                List geoKeysInt = (List)geoKeysIntBuffer.toList().map((Function1 & Serializable & scala.Serializable)x -> new Tuple4((Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)x._2$mcI$sp())), List$.MODULE$.canBuildFrom());
                List geoKeys = (List)((SeqLike)geoKeysInt.$plus$plus((GenTraversableOnce)((List)doubles.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> new Tuple4((Object)BoxesRunTime.boxToInteger((int)((Tuple2)x._1())._1$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)CoordinateSystemParser$.MODULE$.GeoTiffDoubleTag()), (Object)BoxesRunTime.boxToInteger((int)1), (Object)BoxesRunTime.boxToInteger((int)x._2$mcI$sp())), List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)CoordinateSystemParser.$anonfun$parse$5(x$13)), (Ordering)Ordering.Int$.MODULE$);
                this.parse = new Tuple2(geoKeys.toArray(ClassTag$.MODULE$.apply(Tuple4.class)), ((TraversableOnce)doubles.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToDouble((double)x$14._2$mcD$sp()), List$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double()));
                this.bitmap$0 |= 0x40;
            }
        }
        return this.parse;
    }

    public Tuple2<Tuple4<Object, Object, Object, Object>[], double[]> parse() {
        return (this.bitmap$0 & 0x40) == 0 ? this.parse$lzycompute() : this.parse;
    }

    /*
     * Unable to fully structure code
     */
    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> projProps$lzycompute() {
        block19: {
            var3_1 = this;
            synchronized (var3_1) {
                if ((this.bitmap$0 & 128) != 0) break block19;
                var4_2 = false;
                var5_3 = null;
                var6_4 = this.proj4Map().get((Object)"proj");
                if (!(var6_4 instanceof Some)) ** GOTO lbl-1000
                var4_2 = true;
                var5_3 = (Some)var6_4;
                var7_5 = (String)var5_3.value();
                if ("tmerc".equals(var7_5)) {
                    var1_6 = this.tmercProps();
                } else if (var4_2 && "merc".equals(var8_7 = (String)var5_3.value())) {
                    var1_6 = this.mercProps();
                } else if (var4_2 && "utm".equals(var9_8 = (String)var5_3.value())) {
                    var1_6 = this.utmProps();
                } else if (var4_2 && "lcc".equals(var10_9 = (String)var5_3.value())) {
                    var1_6 = this.lccProps();
                } else {
                    var2_12 = var6_4 instanceof Some != false && "longlat".equals(var12_11 = (String)(var11_10 = (Some)var6_4).value()) != false ? true : var6_4 instanceof Some != false && "latlong".equals(var14_14 = (String)(var13_13 = (Some)var6_4).value()) != false;
                    if (var2_12) {
                        var1_6 = this.longLatProps();
                    } else if (var4_2 && "sinu".equals(var15_15 = (String)var5_3.value())) {
                        var1_6 = this.sinuProps();
                    } else if (var4_2 && "aea".equals(var16_16 = (String)var5_3.value())) {
                        var1_6 = this.aeaProps();
                    } else {
                        if (var4_2) {
                            throw new GeoTiffWriterLimitationException(new StringBuilder(196).append("This GeoTiff writer does not currently support the projection ").append(this.proj4String()).append(" without an EPSG code associated with the CRS. You'll need to use a CRS that has an EPSG code, or reproject before writing to GeoTIFF.").toString());
                        }
                        if (None$.MODULE$.equals(var6_4)) {
                            throw new MalformedProj4Exception("No +proj flag specified.");
                        }
                        throw new MatchError((Object)var6_4);
                    }
                }
                this.projProps = var1_6;
                this.bitmap$0 |= 128;
            }
        }
        return this.projProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> projProps() {
        return (this.bitmap$0 & 0x80) == 0 ? this.projProps$lzycompute() : this.projProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> tmercProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x100) == 0) {
                .colon.colon geoKeysInt = new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTModelTypeGeoKey(), ModelTypes$.MODULE$.ModelTypeProjected()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectedCSTypeGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjCoordTransGeoKey(), CoordinateTransformTypes$.MODULE$.CT_TransverseMercator()), (List)Nil$.MODULE$)));
                .colon.colon doubles = new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLatGeoKey(), this.getDouble("lat_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), this.getDouble("lon_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjScaleAtNatOriginGeoKey(), this.getK(1.0)), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), this.getDouble("x_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), this.getDouble("y_0", this.getDouble$default$2())), (List)Nil$.MODULE$)))));
                this.tmercProps = new Tuple2((Object)geoKeysInt, (Object)doubles);
                this.bitmap$0 |= 0x100;
            }
        }
        return this.tmercProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> tmercProps() {
        return (this.bitmap$0 & 0x100) == 0 ? this.tmercProps$lzycompute() : this.tmercProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> mercProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x200) == 0) {
                .colon.colon geoKeysInt = new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTModelTypeGeoKey(), ModelTypes$.MODULE$.ModelTypeProjected()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectedCSTypeGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectionGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjCoordTransGeoKey(), CoordinateTransformTypes$.MODULE$.CT_Mercator()), (List)Nil$.MODULE$))));
                .colon.colon doubles = new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLatGeoKey(), this.getDouble("lat_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), this.getDouble("lon_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjStdParallel1GeoKey(), this.getDouble("lat_ts", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjScaleAtNatOriginGeoKey(), this.getK(1.0)), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), this.getDouble("x_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), this.getDouble("y_0", this.getDouble$default$2())), (List)Nil$.MODULE$))))));
                this.mercProps = new Tuple2((Object)geoKeysInt, (Object)doubles);
                this.bitmap$0 |= 0x200;
            }
        }
        return this.mercProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> mercProps() {
        return (this.bitmap$0 & 0x200) == 0 ? this.mercProps$lzycompute() : this.mercProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> utmProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x400) == 0) {
                int zone = this.getInt("zone", this.getInt$default$2());
                boolean south = this.proj4Map().contains((Object)"south");
                int epsgCodeBase = south ? 32700 : 32600;
                .colon.colon geoKeysInt = new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTModelTypeGeoKey(), ModelTypes$.MODULE$.ModelTypeProjected()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectedCSTypeGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjCoordTransGeoKey(), CoordinateTransformTypes$.MODULE$.CT_TransverseMercator()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectedCSTypeGeoKey(), epsgCodeBase + zone), (List)Nil$.MODULE$))));
                .colon.colon doubles = new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLatGeoKey(), 0.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), (double)(zone * 6) - 183.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjScaleAtNatOriginGeoKey(), 0.9996), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), 500000.0), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), south ? 1.0E7 : 0.0), (List)Nil$.MODULE$)))));
                this.utmProps = new Tuple2((Object)geoKeysInt, (Object)doubles);
                this.bitmap$0 |= 0x400;
            }
        }
        return this.utmProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> utmProps() {
        return (this.bitmap$0 & 0x400) == 0 ? this.utmProps$lzycompute() : this.utmProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> lccProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x800) == 0) {
                ListBuffer listBuffer;
                double lat0 = this.getDouble("lat_0", this.getDouble$default$2());
                double lat1 = this.getDouble("lat_1", this.getDouble$default$2());
                double lon0 = this.getDouble("lon_0", this.getDouble$default$2());
                ListBuffer geoKeysIntLB = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTModelTypeGeoKey(), ModelTypes$.MODULE$.ModelTypeProjected()), new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectedCSTypeGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV()), new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectionGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV())}));
                ListBuffer doublesLB = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                if (lat0 == lat1 && !this.isDefined("lat_2")) {
                    geoKeysIntLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjCoordTransGeoKey())), (Object)BoxesRunTime.boxToInteger((int)CoordinateTransformTypes$.MODULE$.CT_LambertConfConic_1SP())));
                    doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjNatOriginLatGeoKey())), (Object)BoxesRunTime.boxToDouble((double)lat0)));
                    doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjNatOriginLongGeoKey())), (Object)BoxesRunTime.boxToDouble((double)lon0)));
                    listBuffer = doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjScaleAtNatOriginGeoKey())), (Object)BoxesRunTime.boxToDouble((double)this.getK(1.0))));
                } else {
                    geoKeysIntLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjCoordTransGeoKey())), (Object)BoxesRunTime.boxToInteger((int)CoordinateTransformTypes$.MODULE$.CT_LambertConfConic_2SP())));
                    doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjFalseOriginLatGeoKey())), (Object)BoxesRunTime.boxToDouble((double)lat0)));
                    doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjFalseOriginLongGeoKey())), (Object)BoxesRunTime.boxToDouble((double)lon0)));
                    doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjStdParallel1GeoKey())), (Object)BoxesRunTime.boxToDouble((double)lat1)));
                    listBuffer = doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjStdParallel2GeoKey())), (Object)BoxesRunTime.boxToDouble((double)this.getDouble("lat_2", this.getDouble$default$2()))));
                }
                doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjFalseEastingGeoKey())), (Object)BoxesRunTime.boxToDouble((double)this.getDouble("x_0", this.getDouble$default$2()))));
                doublesLB.$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)GeoKeys$.MODULE$.ProjFalseNorthingGeoKey())), (Object)BoxesRunTime.boxToDouble((double)this.getDouble("y_0", this.getDouble$default$2()))));
                this.lccProps = new Tuple2((Object)geoKeysIntLB.toList(), (Object)doublesLB.toList());
                this.bitmap$0 |= 0x800;
            }
        }
        return this.lccProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> lccProps() {
        return (this.bitmap$0 & 0x800) == 0 ? this.lccProps$lzycompute() : this.lccProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, Nil$> longLatProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x1000) == 0) {
                this.longLatProps = new Tuple2((Object)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTModelTypeGeoKey(), ModelTypes$.MODULE$.ModelTypeGeographic()), (List)Nil$.MODULE$), (Object)Nil$.MODULE$);
                this.bitmap$0 |= 0x1000;
            }
        }
        return this.longLatProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, Nil$> longLatProps() {
        return (this.bitmap$0 & 0x1000) == 0 ? this.longLatProps$lzycompute() : this.longLatProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, Nil$> gcsOrDatumProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x2000) == 0) {
                Tuple2 tuple22;
                if (this.gcs() != CommonPublicValues$.MODULE$.UserDefinedCPV()) {
                    tuple22 = new Tuple2((Object)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GeogTypeGeoKey(), this.gcs()), (List)Nil$.MODULE$), (Object)Nil$.MODULE$);
                } else {
                    .colon.colon geoKeysInt = new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GeogTypeGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GeogGeodeticDatumGeoKey(), this.datum()), (List)Nil$.MODULE$));
                    tuple22 = new Tuple2((Object)geoKeysInt, (Object)Nil$.MODULE$);
                }
                this.gcsOrDatumProps = tuple22;
                this.bitmap$0 |= 0x2000;
            }
        }
        return this.gcsOrDatumProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, Nil$> gcsOrDatumProps() {
        return (this.bitmap$0 & 0x2000) == 0 ? this.gcsOrDatumProps$lzycompute() : this.gcsOrDatumProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> ellipsoidProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x4000) == 0) {
                Tuple2 tuple22;
                if (this.gcs() == CommonPublicValues$.MODULE$.UserDefinedCPV()) {
                    .colon.colon geoKeysInt = new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GeogEllipsoidGeoKey(), this.ellipsoid()), (List)Nil$.MODULE$);
                    if (this.optSemis().nonEmpty()) {
                        Tuple3 tuple32 = (Tuple3)this.optSemis().get();
                        if (tuple32 == null) {
                            throw new MatchError((Object)tuple32);
                        }
                        double major = BoxesRunTime.unboxToDouble((Object)tuple32._1());
                        double minor = BoxesRunTime.unboxToDouble((Object)tuple32._2());
                        double invFlattening = BoxesRunTime.unboxToDouble((Object)tuple32._3());
                        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)major), (Object)BoxesRunTime.boxToDouble((double)minor), (Object)BoxesRunTime.boxToDouble((double)invFlattening));
                        Tuple3 tuple34 = tuple33;
                        double major2 = BoxesRunTime.unboxToDouble((Object)tuple34._1());
                        double minor2 = BoxesRunTime.unboxToDouble((Object)tuple34._2());
                        double invFlattening2 = BoxesRunTime.unboxToDouble((Object)tuple34._3());
                        .colon.colon doubles = new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.GeogSemiMajorAxisGeoKey(), major2), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.GeogSemiMinorAxisGeoKey(), minor2), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.GeogInvFlatteningGeoKey(), invFlattening2), (List)Nil$.MODULE$)));
                        tuple22 = new Tuple2((Object)geoKeysInt, (Object)doubles);
                    } else {
                        tuple22 = new Tuple2((Object)geoKeysInt, (Object)Nil$.MODULE$);
                    }
                } else {
                    tuple22 = new Tuple2((Object)Nil$.MODULE$, (Object)Nil$.MODULE$);
                }
                this.ellipsoidProps = tuple22;
                this.bitmap$0 |= 0x4000;
            }
        }
        return this.ellipsoidProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> ellipsoidProps() {
        return (this.bitmap$0 & 0x4000) == 0 ? this.ellipsoidProps$lzycompute() : this.ellipsoidProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> sinuProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x8000) == 0) {
                .colon.colon geoKeysInt = new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTModelTypeGeoKey(), ModelTypes$.MODULE$.ModelTypeProjected()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectedCSTypeGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjCoordTransGeoKey(), CoordinateTransformTypes$.MODULE$.CT_Sinusoidal()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjLinearUnitsGeoKey(), ProjectedLinearUnits$.MODULE$.LinearMeterCode()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GeogAngularUnitsGeoKey(), AngularUnitTypes$.MODULE$.Angular_Degree()), (List)Nil$.MODULE$)))));
                .colon.colon doubles = new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLatGeoKey(), this.getDouble("lat_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), this.getDouble("lon_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), this.getDouble("x_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), this.getDouble("y_0", this.getDouble$default$2())), (List)Nil$.MODULE$))));
                this.sinuProps = new Tuple2((Object)geoKeysInt, (Object)doubles);
                this.bitmap$0 |= 0x8000;
            }
        }
        return this.sinuProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> sinuProps() {
        return (this.bitmap$0 & 0x8000) == 0 ? this.sinuProps$lzycompute() : this.sinuProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> linearUnitProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x10000) == 0) {
                String unitString = this.getString("units", "err");
                int code = BoxesRunTime.unboxToInt((Object)ProjectedLinearUnits$.MODULE$.reversedProjectedLinearUnitsMap().getOrElse((Object)unitString, (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> CommonPublicValues$.MODULE$.UserDefinedCPV()));
                .colon.colon geoKeysInt = new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjLinearUnitsGeoKey(), code), (List)Nil$.MODULE$);
                double toMeters = this.getDouble("to_meter", "1.0");
                Nil$ doubles = code == CommonPublicValues$.MODULE$.UserDefinedCPV() ? new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjLinearUnitSizeGeoKey(), toMeters), (List)Nil$.MODULE$) : Nil$.MODULE$;
                this.linearUnitProps = new Tuple2((Object)geoKeysInt, (Object)doubles);
                this.bitmap$0 |= 0x10000;
            }
        }
        return this.linearUnitProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> linearUnitProps() {
        return (this.bitmap$0 & 0x10000) == 0 ? this.linearUnitProps$lzycompute() : this.linearUnitProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> aeaProps$lzycompute() {
        CoordinateSystemParser coordinateSystemParser = this;
        synchronized (coordinateSystemParser) {
            if ((this.bitmap$0 & 0x20000) == 0) {
                .colon.colon geoKeysInt = new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.GTModelTypeGeoKey(), ModelTypes$.MODULE$.ModelTypeProjected()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectedCSTypeGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjectionGeoKey(), CommonPublicValues$.MODULE$.UserDefinedCPV()), (List)new .colon.colon((Object)new Tuple2.mcII.sp(GeoKeys$.MODULE$.ProjCoordTransGeoKey(), CoordinateTransformTypes$.MODULE$.CT_AlbersEqualArea()), (List)Nil$.MODULE$))));
                .colon.colon doubles = new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjStdParallel1GeoKey(), this.getDouble("lat_1", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjStdParallel2GeoKey(), this.getDouble("lat_2", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLatGeoKey(), this.getDouble("lat_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjNatOriginLongGeoKey(), this.getDouble("lon_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseEastingGeoKey(), this.getDouble("x_0", this.getDouble$default$2())), (List)new .colon.colon((Object)new Tuple2.mcID.sp(GeoKeys$.MODULE$.ProjFalseNorthingGeoKey(), this.getDouble("y_0", this.getDouble$default$2())), (List)Nil$.MODULE$))))));
                this.aeaProps = new Tuple2((Object)geoKeysInt, (Object)doubles);
                this.bitmap$0 |= 0x20000;
            }
        }
        return this.aeaProps;
    }

    private Tuple2<List<Tuple2<Object, Object>>, List<Tuple2<Object, Object>>> aeaProps() {
        return (this.bitmap$0 & 0x20000) == 0 ? this.aeaProps$lzycompute() : this.aeaProps;
    }

    private boolean isDefined(String key) {
        return this.proj4Map().get((Object)key).isDefined();
    }

    private String getString(String key, String defV) {
        return (String)this.proj4Map().getOrElse((Object)key, (Function0 & Serializable & scala.Serializable)() -> defV);
    }

    private int getInt(String key, String defV) {
        return new StringOps(Predef$.MODULE$.augmentString((String)this.proj4Map().getOrElse((Object)key, (Function0 & Serializable & scala.Serializable)() -> defV))).toInt();
    }

    private String getInt$default$2() {
        return "0";
    }

    private double getDouble(String key, String defV) {
        return new StringOps(Predef$.MODULE$.augmentString(this.getString(key, defV))).toDouble();
    }

    private String getDouble$default$2() {
        return "0.0";
    }

    private double getK(double defV) {
        double d;
        Option option2 = this.proj4Map().get((Object)"k");
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            String k = (String)some.value();
            d = new StringOps(Predef$.MODULE$.augmentString(k)).toDouble();
        } else if (None$.MODULE$.equals(option2)) {
            double d2;
            Option option3 = this.proj4Map().get((Object)"k_0");
            if (option3 instanceof Some) {
                Some some = (Some)option3;
                String k = (String)some.value();
                d2 = new StringOps(Predef$.MODULE$.augmentString(k)).toDouble();
            } else if (None$.MODULE$.equals(option3)) {
                d2 = defV;
            } else {
                throw new MatchError((Object)option3);
            }
            d = d2;
        } else {
            throw new MatchError((Object)option2);
        }
        return d;
    }

    public static final /* synthetic */ boolean $anonfun$proj4Map$2(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).contains((Object)BoxesRunTime.boxToCharacter((char)'='));
    }

    public static final /* synthetic */ boolean $anonfun$proj4Map$4(char x$4) {
        return x$4 != '=';
    }

    public static final /* synthetic */ boolean $anonfun$proj4Map$6(char x$5) {
        return x$5 != '=';
    }

    public static final /* synthetic */ int $anonfun$parse$5(Tuple4 x$13) {
        return BoxesRunTime.unboxToInt((Object)x$13._1());
    }

    public CoordinateSystemParser(CRS crs, Option<PixelSampleType> pixelSampleType) {
        this.crs = crs;
        this.pixelSampleType = pixelSampleType;
        this.proj4String = crs.toProj4String();
        this.proj4Map = (Map)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(this.proj4String())).split('+'))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)CoordinateSystemParser.$anonfun$proj4Map$2(x$3))))).groupBy((Function1 & Serializable & scala.Serializable)s -> (String)new StringOps(Predef$.MODULE$.augmentString(s)).takeWhile((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)CoordinateSystemParser.$anonfun$proj4Map$4(BoxesRunTime.unboxToChar((Object)x$4))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple22 = x0$1;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            String a = (String)tuple22._1();
            String[] b = (String[])tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)a, (Object)((String)new StringOps(Predef$.MODULE$.augmentString((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])b)).head())).dropWhile((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)CoordinateSystemParser.$anonfun$proj4Map$6(BoxesRunTime.unboxToChar((Object)x$5))))).substring(1));
            return tuple23;
        }, Map$.MODULE$.canBuildFrom());
    }
}

