/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.resample;

import geotrellis.raster.CellSize;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.resample.PointResampleMethod;
import geotrellis.raster.resample.Resample$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.vector.Extent;
import geotrellis.vector.package$;
import org.locationtech.jts.geom.Point;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-c!\u0002\u0012$\u0003\u0003Q\u0003\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\t\u0011Y\u0002!\u0011!Q\u0001\n]BQ!\u0010\u0001\u0005\u0002yBqa\u0011\u0001C\u0002\u0013EA\t\u0003\u0004I\u0001\u0001\u0006I!\u0012\u0005\b\u0013\u0002\u0011\r\u0011\"\u0005K\u0011\u0019q\u0005\u0001)A\u0005\u0017\"9q\n\u0001b\u0001\n#Q\u0005B\u0002)\u0001A\u0003%1\nC\u0004R\u0001\t\u0007I\u0011\u0002*\t\rY\u0003\u0001\u0015!\u0003T\u0011\u001d9\u0006A1A\u0005\nICa\u0001\u0017\u0001!\u0002\u0013\u0019\u0006bB-\u0001\u0005\u0004%IA\u0015\u0005\u00075\u0002\u0001\u000b\u0011B*\t\u000fm\u0003!\u0019!C\u0005%\"1A\f\u0001Q\u0001\nMCq!\u0018\u0001C\u0002\u0013E!\u000b\u0003\u0004_\u0001\u0001\u0006Ia\u0015\u0005\b?\u0002\u0011\r\u0011\"\u0005S\u0011\u0019\u0001\u0007\u0001)A\u0005'\")\u0011\r\u0001C\u0005E\")A\u0005\u0001C\u0003U\")A\u0005\u0001C\u0003w\")a\u0010\u0001C\u0003\u007f\"1a\u0010\u0001C\u0003\u0003\u0007Aq!!\u0003\u0001\r#\tY\u0001C\u0004\u0002\u0012\u00011\t\"a\u0005\b\u000f\u0005e1\u0005#\u0001\u0002\u001c\u00191!e\tE\u0001\u0003;Aa!\u0010\u0010\u0005\u0002\u0005}\u0001bBA\u0011=\u0011\u0005\u00111\u0005\u0005\b\u0003CqB\u0011AA\u001a\u0005!\u0011Vm]1na2,'B\u0001\u0013&\u0003!\u0011Xm]1na2,'B\u0001\u0014(\u0003\u0019\u0011\u0018m\u001d;fe*\t\u0001&\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001a\u0005\u0002\u0001WA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t1\u0011I\\=SK\u001a\fA\u0001^5mKB\u00111\u0007N\u0007\u0002K%\u0011Q'\n\u0002\u0005)&dW-\u0001\u0004fqR,g\u000e\u001e\t\u0003qmj\u0011!\u000f\u0006\u0003u\u001d\naA^3di>\u0014\u0018B\u0001\u001f:\u0005\u0019)\u0005\u0010^3oi\u00061A(\u001b8jiz\"2aP!C!\t\u0001\u0005!D\u0001$\u0011\u0015\t4\u00011\u00013\u0011\u001514\u00011\u00018\u0003\t\u0011X-F\u0001F!\t\u0019d)\u0003\u0002HK\ta!+Y:uKJ,\u0005\u0010^3oi\u0006\u0019!/\u001a\u0011\u0002\t\r|Gn]\u000b\u0002\u0017B\u0011A\u0006T\u0005\u0003\u001b6\u00121!\u00138u\u0003\u0015\u0019w\u000e\\:!\u0003\u0011\u0011xn^:\u0002\u000bI|wo\u001d\u0011\u0002\u0013],7\u000f\u001e\"pk:$W#A*\u0011\u00051\"\u0016BA+.\u0005\u0019!u.\u001e2mK\u0006Qq/Z:u\u0005>,h\u000e\u001a\u0011\u0002\u0013\u0015\f7\u000f\u001e\"pk:$\u0017AC3bgR\u0014u.\u001e8eA\u0005Qan\u001c:uQ\n{WO\u001c3\u0002\u00179|'\u000f\u001e5C_VtG\rI\u0001\u000bg>,H\u000f\u001b\"pk:$\u0017aC:pkRD'i\\;oI\u0002\n\u0011bY3mY^LG\r\u001e5\u0002\u0015\r,G\u000e\\<jIRD\u0007%\u0001\u0006dK2d\u0007.Z5hQR\f1bY3mY\",\u0017n\u001a5uA\u00059\u0011n\u001d,bY&$GcA2gQB\u0011A\u0006Z\u0005\u0003K6\u0012qAQ8pY\u0016\fg\u000eC\u0003h-\u0001\u00071+A\u0001y\u0011\u0015Ig\u00031\u0001T\u0003\u0005IHCA&l\u0011\u0015aw\u00031\u0001n\u0003\u0005\u0001\bC\u00018y\u001d\tygO\u0004\u0002qk:\u0011\u0011\u000f^\u0007\u0002e*\u00111/K\u0001\u0007yI|w\u000e\u001e \n\u0003!J!AO\u0014\n\u0005]L\u0014a\u00029bG.\fw-Z\u0005\u0003sj\u0014Q\u0001U8j]RT!a^\u001d\u0015\u0007-cX\u0010C\u0003h1\u0001\u00071\u000bC\u0003j1\u0001\u00071+\u0001\bsKN\fW\u000e\u001d7f\t>,(\r\\3\u0015\u0007M\u000b\t\u0001C\u0003m3\u0001\u0007Q\u000eF\u0003T\u0003\u000b\t9\u0001C\u0003h5\u0001\u00071\u000bC\u0003j5\u0001\u00071+A\u0007sKN\fW\u000e\u001d7f-\u0006d\u0017\u000e\u001a\u000b\u0006\u0017\u00065\u0011q\u0002\u0005\u0006On\u0001\ra\u0015\u0005\u0006Sn\u0001\raU\u0001\u0014e\u0016\u001c\u0018-\u001c9mK\u0012{WO\u00197f-\u0006d\u0017\u000e\u001a\u000b\u0006'\u0006U\u0011q\u0003\u0005\u0006Or\u0001\ra\u0015\u0005\u0006Sr\u0001\raU\u0001\t%\u0016\u001c\u0018-\u001c9mKB\u0011\u0001IH\n\u0003=-\"\"!a\u0007\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f}\n)#a\f\u00022!9\u0011q\u0005\u0011A\u0002\u0005%\u0012AB7fi\"|G\rE\u0002A\u0003WI1!!\f$\u0005M\u0001v.\u001b8u%\u0016\u001c\u0018-\u001c9mK6+G\u000f[8e\u0011\u0015\t\u0004\u00051\u00013\u0011\u00151\u0004\u00051\u00018)%y\u0014QGA\u001f\u0003\u007f\t\t\u0005C\u0004\u0002(\u0005\u0002\r!a\u000e\u0011\u0007\u0001\u000bI$C\u0002\u0002<\r\u0012aBU3tC6\u0004H.Z'fi\"|G\rC\u00032C\u0001\u0007!\u0007C\u00037C\u0001\u0007q\u0007C\u0004\u0002D\u0005\u0002\r!!\u0012\u0002\u0005\r\u001c\bcA\u001a\u0002H%\u0019\u0011\u0011J\u0013\u0003\u0011\r+G\u000e\\*ju\u0016\u0004")
public abstract class Resample {
    private final RasterExtent re;
    private final int cols;
    private final int rows;
    private final double westBound;
    private final double eastBound;
    private final double northBound;
    private final double southBound;
    private final double cellwidth;
    private final double cellheight;

    public static Resample apply(ResampleMethod resampleMethod, Tile tile, Extent extent, CellSize cellSize) {
        return Resample$.MODULE$.apply(resampleMethod, tile, extent, cellSize);
    }

    public static Resample apply(PointResampleMethod pointResampleMethod, Tile tile, Extent extent) {
        return Resample$.MODULE$.apply(pointResampleMethod, tile, extent);
    }

    public RasterExtent re() {
        return this.re;
    }

    public int cols() {
        return this.cols;
    }

    public int rows() {
        return this.rows;
    }

    private double westBound() {
        return this.westBound;
    }

    private double eastBound() {
        return this.eastBound;
    }

    private double northBound() {
        return this.northBound;
    }

    private double southBound() {
        return this.southBound;
    }

    public double cellwidth() {
        return this.cellwidth;
    }

    public double cellheight() {
        return this.cellheight;
    }

    private boolean isValid(double x, double y) {
        return x >= this.westBound() && x <= this.eastBound() && y >= this.southBound() && y <= this.northBound();
    }

    public final int resample(Point p) {
        return this.resample(package$.MODULE$.withExtraPointMethods(p).x(), package$.MODULE$.withExtraPointMethods(p).y());
    }

    public final int resample(double x, double y) {
        return !this.isValid(x, y) ? Integer.MIN_VALUE : this.resampleValid(x, y);
    }

    public final double resampleDouble(Point p) {
        return this.resampleDouble(package$.MODULE$.withExtraPointMethods(p).x(), package$.MODULE$.withExtraPointMethods(p).y());
    }

    public final double resampleDouble(double x, double y) {
        return !this.isValid(x, y) ? Double.NaN : this.resampleDoubleValid(x, y);
    }

    public abstract int resampleValid(double var1, double var3);

    public abstract double resampleDoubleValid(double var1, double var3);

    public Resample(Tile tile, Extent extent) {
        this.re = RasterExtent$.MODULE$.apply(tile, extent);
        this.cols = tile.cols$mcI$sp();
        this.rows = tile.rows$mcI$sp();
        this.westBound = extent.xmin();
        this.eastBound = extent.xmax();
        this.northBound = extent.ymax();
        this.southBound = extent.ymin();
        this.cellwidth = this.re().cellwidth();
        this.cellheight = this.re().cellheight();
    }
}

