/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector.interpolation;

import geotrellis.vector.Feature;
import geotrellis.vector.interpolation.Circular$;
import geotrellis.vector.interpolation.EmpiricalVariogram;
import geotrellis.vector.interpolation.EmpiricalVariogram$;
import geotrellis.vector.interpolation.Exponential$;
import geotrellis.vector.interpolation.Gaussian$;
import geotrellis.vector.interpolation.ModelType;
import geotrellis.vector.interpolation.Semivariogram;
import geotrellis.vector.interpolation.Semivariogram$;
import geotrellis.vector.interpolation.Spherical$;
import geotrellis.vector.interpolation.Wave$;
import java.io.Serializable;
import org.locationtech.jts.geom.Point;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class NonLinearSemivariogram$ {
    public static NonLinearSemivariogram$ MODULE$;

    static {
        new NonLinearSemivariogram$();
    }

    private Function1<Object, Object> explicitGaussian(double r, double s, double a) {
        return (JFunction1.mcDD.sp & Serializable & scala.Serializable)h -> h == 0.0 ? 0.0 : a + (s - a) * (1.0 - package$.MODULE$.exp(-package$.MODULE$.pow(h, 2.0) / package$.MODULE$.pow(r, 2.0)));
    }

    private Function1<Object, Object> explicitGaussianNugget(double r, double s) {
        return this.explicitGaussian(r, s, 0.0);
    }

    private Function1<Object, double[]> jacobianGaussian(double[] variables) {
        return (Function1 & Serializable & scala.Serializable)x -> NonLinearSemivariogram$.$anonfun$jacobianGaussian$1(variables, BoxesRunTime.unboxToDouble((Object)x));
    }

    private Function1<Object, double[]> jacobianGaussianNugget(double[] variables) {
        return (Function1 & Serializable & scala.Serializable)x -> NonLinearSemivariogram$.$anonfun$jacobianGaussianNugget$1(variables, BoxesRunTime.unboxToDouble((Object)x));
    }

    private Function1<Object, Object> explicitCircular(double r, double s, double a) {
        return (JFunction1.mcDD.sp & Serializable & scala.Serializable)h -> h == 0.0 ? 0.0 : (h > r ? s : a + (s - a) * (1.0 - 0.6366197723675814 * package$.MODULE$.acos(h / r) + (double)2 * h / (Math.PI * r) * package$.MODULE$.sqrt(1.0 - package$.MODULE$.pow(h, 2.0) / package$.MODULE$.pow(r, 2.0))));
    }

    private Function1<Object, Object> explicitCircularNugget(double r, double s) {
        return this.explicitCircular(r, s, 0.0);
    }

    private Function1<Object, double[]> jacobianCircular(double[] variables) {
        return (Function1 & Serializable & scala.Serializable)x -> NonLinearSemivariogram$.$anonfun$jacobianCircular$1(variables, BoxesRunTime.unboxToDouble((Object)x));
    }

    private Function1<Object, double[]> jacobianCircularNugget(double[] variables) {
        return (Function1 & Serializable & scala.Serializable)x -> NonLinearSemivariogram$.$anonfun$jacobianCircularNugget$1(variables, BoxesRunTime.unboxToDouble((Object)x));
    }

    private Function1<Object, Object> explicitSpherical(double r, double s, double a) {
        return (JFunction1.mcDD.sp & Serializable & scala.Serializable)h -> h == 0.0 ? 0.0 : (h > r ? s : a + (s - a) * ((double)3 * h / ((double)2 * r) - package$.MODULE$.pow(h, 3.0) / ((double)2 * package$.MODULE$.pow(r, 3.0))));
    }

    private Function1<Object, Object> explicitSphericalNugget(double r, double s) {
        return this.explicitSpherical(r, s, 0.0);
    }

    private Function1<Object, double[]> jacobianSpherical(double[] variables) {
        return (Function1 & Serializable & scala.Serializable)x -> NonLinearSemivariogram$.$anonfun$jacobianSpherical$1(variables, BoxesRunTime.unboxToDouble((Object)x));
    }

    private Function1<Object, double[]> jacobianSphericalNugget(double[] variables) {
        return (Function1 & Serializable & scala.Serializable)x -> NonLinearSemivariogram$.$anonfun$jacobianSphericalNugget$1(variables, BoxesRunTime.unboxToDouble((Object)x));
    }

    private Function1<Object, Object> explicitExponential(double r, double s, double a) {
        return (JFunction1.mcDD.sp & Serializable & scala.Serializable)h -> h == 0.0 ? 0.0 : a + (s - a) * (1.0 - package$.MODULE$.exp((double)-3 * h / r));
    }

    private Function1<Object, Object> explicitExponentialNugget(double r, double s) {
        return this.explicitExponential(r, s, 0.0);
    }

    private Function1<Object, double[]> jacobianExponential(double[] variables) {
        return (Function1 & Serializable & scala.Serializable)x -> NonLinearSemivariogram$.$anonfun$jacobianExponential$1(variables, BoxesRunTime.unboxToDouble((Object)x));
    }

    private Function1<Object, double[]> jacobianExponentialNugget(double[] variables) {
        return (Function1 & Serializable & scala.Serializable)x -> NonLinearSemivariogram$.$anonfun$jacobianExponentialNugget$1(variables, BoxesRunTime.unboxToDouble((Object)x));
    }

    private Function1<Object, Object> explicitWave(double w, double s, double a) {
        return (JFunction1.mcDD.sp & Serializable & scala.Serializable)h -> h == 0.0 ? 0.0 : a + (s - a) * (1.0 - w * package$.MODULE$.sin(h / w) / h);
    }

    private Function1<Object, Object> explicitWaveNugget(double w, double s) {
        return this.explicitWave(w, s, 0.0);
    }

    private Function1<Object, double[]> jacobianWave(double[] variables) {
        return (Function1 & Serializable & scala.Serializable)x -> NonLinearSemivariogram$.$anonfun$jacobianWave$1(variables, BoxesRunTime.unboxToDouble((Object)x));
    }

    private Function1<Object, double[]> jacobianWaveNugget(double[] variables) {
        return (Function1 & Serializable & scala.Serializable)x -> NonLinearSemivariogram$.$anonfun$jacobianWaveNugget$1(variables, BoxesRunTime.unboxToDouble((Object)x));
    }

    public Function1<Object, Object> explicitNuggetModel(double[] svParam, ModelType model) {
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(svParam[0], svParam[1]);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        double range = sp2._1$mcD$sp();
        double sill = sp2._2$mcD$sp();
        double d = range;
        double d2 = sill;
        Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(d, d2);
        Tuple2.mcDD.sp sp4 = sp3;
        double range2 = sp4._1$mcD$sp();
        double sill2 = sp4._2$mcD$sp();
        return this.explicitNuggetModel(range2, sill2, model);
    }

    public Function1<Object, Object> explicitNuggetModel(double range, double sill, ModelType model) {
        Function1<Object, Object> function1;
        ModelType modelType = model;
        if (Circular$.MODULE$.equals(modelType)) {
            function1 = this.explicitCircularNugget(range, sill);
        } else if (Spherical$.MODULE$.equals(modelType)) {
            function1 = this.explicitSphericalNugget(range, sill);
        } else if (Gaussian$.MODULE$.equals(modelType)) {
            function1 = this.explicitGaussianNugget(range, sill);
        } else if (Exponential$.MODULE$.equals(modelType)) {
            function1 = this.explicitExponentialNugget(range, sill);
        } else if (Wave$.MODULE$.equals(modelType)) {
            function1 = this.explicitWaveNugget(range, sill);
        } else {
            throw new UnsupportedOperationException("$model is an invalid model or is not implemented");
        }
        return function1;
    }

    public Function1<Object, Object> explicitModel(double[] svParam, ModelType model) {
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)svParam[0]), (Object)BoxesRunTime.boxToDouble((double)svParam[1]), (Object)BoxesRunTime.boxToDouble((double)svParam[2]));
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        double range = BoxesRunTime.unboxToDouble((Object)tuple32._1());
        double sill = BoxesRunTime.unboxToDouble((Object)tuple32._2());
        double nugget = BoxesRunTime.unboxToDouble((Object)tuple32._3());
        double d = range;
        double d2 = sill;
        double d3 = nugget;
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d2), (Object)BoxesRunTime.boxToDouble((double)d3));
        Tuple3 tuple34 = tuple33;
        double range2 = BoxesRunTime.unboxToDouble((Object)tuple34._1());
        double sill2 = BoxesRunTime.unboxToDouble((Object)tuple34._2());
        double nugget2 = BoxesRunTime.unboxToDouble((Object)tuple34._3());
        return this.explicitModel(range2, sill2, nugget2, model);
    }

    public Function1<Object, Object> explicitModel(double range, double sill, double nugget, ModelType model) {
        Function1<Object, Object> function1;
        ModelType modelType = model;
        if (Circular$.MODULE$.equals(modelType)) {
            function1 = this.explicitCircular(range, sill, nugget);
        } else if (Spherical$.MODULE$.equals(modelType)) {
            function1 = this.explicitSpherical(range, sill, nugget);
        } else if (Gaussian$.MODULE$.equals(modelType)) {
            function1 = this.explicitGaussian(range, sill, nugget);
        } else if (Exponential$.MODULE$.equals(modelType)) {
            function1 = this.explicitExponential(range, sill, nugget);
        } else if (Wave$.MODULE$.equals(modelType)) {
            function1 = this.explicitWave(range, sill, nugget);
        } else {
            throw new UnsupportedOperationException("$model is an invalid model or is not implemented");
        }
        return function1;
    }

    public Function1<Object, double[]> jacobianModel(double[] variables, ModelType model) {
        Function1<Object, double[]> function1;
        if (variables.length == 3) {
            Function1<Object, double[]> function12;
            ModelType modelType = model;
            if (Circular$.MODULE$.equals(modelType)) {
                function12 = this.jacobianCircular(variables);
            } else if (Spherical$.MODULE$.equals(modelType)) {
                function12 = this.jacobianSpherical(variables);
            } else if (Gaussian$.MODULE$.equals(modelType)) {
                function12 = this.jacobianGaussian(variables);
            } else if (Exponential$.MODULE$.equals(modelType)) {
                function12 = this.jacobianExponential(variables);
            } else if (Wave$.MODULE$.equals(modelType)) {
                function12 = this.jacobianWave(variables);
            } else {
                throw new UnsupportedOperationException("$model is an invalid model or is not implemented");
            }
            function1 = function12;
        } else {
            Function1<Object, double[]> function13;
            ModelType modelType = model;
            if (Circular$.MODULE$.equals(modelType)) {
                function13 = this.jacobianCircularNugget(variables);
            } else if (Spherical$.MODULE$.equals(modelType)) {
                function13 = this.jacobianSphericalNugget(variables);
            } else if (Gaussian$.MODULE$.equals(modelType)) {
                function13 = this.jacobianGaussianNugget(variables);
            } else if (Exponential$.MODULE$.equals(modelType)) {
                function13 = this.jacobianExponentialNugget(variables);
            } else if (Wave$.MODULE$.equals(modelType)) {
                function13 = this.jacobianWaveNugget(variables);
            } else {
                throw new UnsupportedOperationException("$model is an invalid model or is not implemented");
            }
            function1 = function13;
        }
        return function1;
    }

    public Semivariogram apply(double[] svParam, ModelType model) {
        return svParam.length == 3 ? Semivariogram$.MODULE$.apply(this.explicitModel(svParam, model), svParam[0], svParam[1], svParam[2]) : Semivariogram$.MODULE$.apply(this.explicitNuggetModel(svParam, model), svParam[0], svParam[1], 0.0);
    }

    public Semivariogram apply(double range, double sill, double nugget, ModelType model) {
        return Semivariogram$.MODULE$.apply(this.explicitModel(range, sill, nugget, model), range, sill, nugget);
    }

    public Semivariogram apply(double range, double sill, ModelType model) {
        return Semivariogram$.MODULE$.apply(this.explicitNuggetModel(range, sill, model), range, sill, 0.0);
    }

    public Semivariogram apply(Feature<Point, Object>[] pts, double maxDistanceBandwidth, int binMaxCount, ModelType model) {
        EmpiricalVariogram es = EmpiricalVariogram$.MODULE$.nonlinear(pts, maxDistanceBandwidth, binMaxCount);
        double[] dist = es.distances();
        double[] varianceValue = es.variance();
        double[] start = (double[])Array$.MODULE$.fill(3, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        start[0] = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(dist)).foldLeft((Object)BoxesRunTime.boxToDouble((double)dist[0]), (Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x0$1, x1$1);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            double maxM = sp2._1$mcD$sp();
            double e = sp2._2$mcD$sp();
            double d = package$.MODULE$.max(maxM, e);
            return d;
        }));
        double[] Z = (double[])Array$.MODULE$.tabulate(pts.length, (Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> BoxesRunTime.unboxToDouble(pts[i].data()), ClassTag$.MODULE$.Double());
        start[1] = package$.MODULE$.pow(NonLinearSemivariogram$.stdev$1(Z), 2.0);
        start[2] = package$.MODULE$.max(0.0, BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(varianceValue)).foldLeft((Object)BoxesRunTime.boxToDouble((double)dist[0]), (Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x0$2, x1$2);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            double minM = sp2._1$mcD$sp();
            double e = sp2._2$mcD$sp();
            double d = package$.MODULE$.min(minM, e);
            return d;
        })));
        return Semivariogram$.MODULE$.fit(es, model, start);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ double[] $anonfun$jacobianGaussian$1(double[] variables$1, double x) {
        double[] dArray;
        if (x == 0.0) {
            dArray = (double[])Array$.MODULE$.fill(3, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        } else {
            void var3_2;
            double[] jacobianRet = (double[])Array$.MODULE$.ofDim(3, ClassTag$.MODULE$.Double());
            jacobianRet[0] = (variables$1[2] - variables$1[1]) * ((double)2 * package$.MODULE$.pow(x, 2.0) / package$.MODULE$.pow(variables$1[0], 3.0)) * package$.MODULE$.exp((double)-1 * package$.MODULE$.pow(x, 2.0) / package$.MODULE$.pow(variables$1[0], 2.0));
            jacobianRet[1] = 1.0 - package$.MODULE$.exp((double)-1 * package$.MODULE$.pow(x, 2.0) / package$.MODULE$.pow(variables$1[0], 2.0));
            jacobianRet[2] = 1.0 - jacobianRet[1];
            dArray = var3_2;
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ double[] $anonfun$jacobianGaussianNugget$1(double[] variables$2, double x) {
        double[] dArray;
        if (x == 0.0) {
            dArray = (double[])Array$.MODULE$.fill(2, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        } else {
            void var3_2;
            double[] jacobianRet = (double[])Array$.MODULE$.ofDim(2, ClassTag$.MODULE$.Double());
            jacobianRet[0] = variables$2[1] * ((double)2 * package$.MODULE$.pow(x, 2.0) / package$.MODULE$.pow(variables$2[0], 3.0)) * package$.MODULE$.exp((double)-1 * package$.MODULE$.pow(x, 2.0) / package$.MODULE$.pow(variables$2[0], 2.0));
            jacobianRet[1] = 1.0 - package$.MODULE$.exp((double)-1 * package$.MODULE$.pow(x, 2.0) / package$.MODULE$.pow(variables$2[0], 2.0));
            dArray = var3_2;
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ double[] $anonfun$jacobianCircular$1(double[] variables$3, double x) {
        double[] dArray;
        if (x == 0.0) {
            dArray = (double[])Array$.MODULE$.fill(3, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        } else {
            void var3_2;
            double[] jacobianRet = (double[])Array$.MODULE$.ofDim(3, ClassTag$.MODULE$.Double());
            jacobianRet[0] = (double)-4 * x * (variables$3[1] - variables$3[2]) * package$.MODULE$.sqrt(package$.MODULE$.pow(variables$3[0], 2.0) - package$.MODULE$.pow(x, 2.0)) / (Math.PI * package$.MODULE$.pow(variables$3[0], 3.0));
            jacobianRet[1] = 1.0 - 0.6366197723675814 * package$.MODULE$.acos(x / variables$3[0]) + (double)2 * x / (Math.PI * variables$3[0]) * package$.MODULE$.sqrt(1.0 - package$.MODULE$.pow(x / variables$3[0], 2.0));
            jacobianRet[2] = 1.0 - jacobianRet[1];
            dArray = var3_2;
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ double[] $anonfun$jacobianCircularNugget$1(double[] variables$4, double x) {
        double[] dArray;
        if (x == 0.0) {
            dArray = (double[])Array$.MODULE$.fill(2, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        } else {
            void var3_2;
            double[] jacobianRet = (double[])Array$.MODULE$.ofDim(2, ClassTag$.MODULE$.Double());
            jacobianRet[0] = (double)-4 * x * variables$4[1] * package$.MODULE$.sqrt(package$.MODULE$.pow(variables$4[0], 2.0) - package$.MODULE$.pow(x, 2.0)) / (Math.PI * package$.MODULE$.pow(variables$4[0], 3.0));
            jacobianRet[1] = 1.0 - 0.6366197723675814 * package$.MODULE$.acos(x / variables$4[0]) + (double)2 * x / (Math.PI * variables$4[0]) * package$.MODULE$.sqrt(1.0 - package$.MODULE$.pow(x / variables$4[0], 2.0));
            dArray = var3_2;
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ double[] $anonfun$jacobianSpherical$1(double[] variables$5, double x) {
        double[] dArray;
        if (x == 0.0) {
            dArray = (double[])Array$.MODULE$.fill(3, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        } else if (x > 0.0 && x <= variables$5[0]) {
            void var3_2;
            double[] jacobianRet = (double[])Array$.MODULE$.ofDim(3, ClassTag$.MODULE$.Double());
            jacobianRet[0] = (variables$5[1] - variables$5[2]) * ((double)-3 * x / ((double)2 * package$.MODULE$.pow(variables$5[0], 2.0)) + (double)3 * package$.MODULE$.pow(x, 3.0) / ((double)2 * package$.MODULE$.pow(variables$5[0], 4.0)));
            jacobianRet[1] = (double)3 * x / ((double)2 * variables$5[0]) - 0.5 * package$.MODULE$.pow(x / variables$5[0], 3.0);
            jacobianRet[2] = 1.0 - jacobianRet[1];
            dArray = var3_2;
        } else {
            dArray = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0, 0.0}), ClassTag$.MODULE$.Double());
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ double[] $anonfun$jacobianSphericalNugget$1(double[] variables$6, double x) {
        double[] dArray;
        if (x == 0.0) {
            dArray = (double[])Array$.MODULE$.fill(2, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        } else if (x > 0.0 && x <= variables$6[0]) {
            void var3_2;
            double[] jacobianRet = (double[])Array$.MODULE$.ofDim(2, ClassTag$.MODULE$.Double());
            jacobianRet[0] = variables$6[1] * ((double)-3 * x / ((double)2 * package$.MODULE$.pow(variables$6[0], 2.0)) + (double)3 * package$.MODULE$.pow(x, 3.0) / ((double)2 * package$.MODULE$.pow(variables$6[0], 4.0)));
            jacobianRet[1] = (double)3 * x / ((double)2 * variables$6[0]) - 0.5 * package$.MODULE$.pow(x / variables$6[0], 3.0);
            dArray = var3_2;
        } else {
            dArray = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 1.0}), ClassTag$.MODULE$.Double());
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ double[] $anonfun$jacobianExponential$1(double[] variables$7, double x) {
        double[] dArray;
        if (x == 0.0) {
            dArray = (double[])Array$.MODULE$.fill(3, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        } else {
            void var3_2;
            double[] jacobianRet = (double[])Array$.MODULE$.ofDim(3, ClassTag$.MODULE$.Double());
            jacobianRet[0] = (variables$7[2] - variables$7[1]) * ((double)3 * x / package$.MODULE$.pow(variables$7[0], 2.0)) * package$.MODULE$.exp((double)-3 * x / variables$7[0]);
            jacobianRet[1] = 1.0 - package$.MODULE$.exp((double)-3 * x / variables$7[0]);
            jacobianRet[2] = 1.0 - jacobianRet[1];
            dArray = var3_2;
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ double[] $anonfun$jacobianExponentialNugget$1(double[] variables$8, double x) {
        double[] dArray;
        if (x == 0.0) {
            dArray = (double[])Array$.MODULE$.fill(2, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        } else {
            void var3_2;
            double[] jacobianRet = (double[])Array$.MODULE$.ofDim(2, ClassTag$.MODULE$.Double());
            jacobianRet[0] = (double)-1 * variables$8[1] * ((double)3 * x / package$.MODULE$.pow(variables$8[0], 2.0)) * package$.MODULE$.exp((double)-3 * x / variables$8[0]);
            jacobianRet[1] = 1.0 - package$.MODULE$.exp((double)-3 * x / variables$8[0]);
            dArray = var3_2;
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ double[] $anonfun$jacobianWave$1(double[] variables$9, double x) {
        double[] dArray;
        if (x == 0.0) {
            dArray = (double[])Array$.MODULE$.fill(3, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        } else {
            void var3_2;
            double[] jacobianRet = (double[])Array$.MODULE$.ofDim(3, ClassTag$.MODULE$.Double());
            jacobianRet[0] = (variables$9[1] - variables$9[2]) * (package$.MODULE$.cos(x / variables$9[0]) / variables$9[0] - package$.MODULE$.sin(x / variables$9[0]) / x);
            jacobianRet[1] = 1.0 - variables$9[0] * package$.MODULE$.sin(x / variables$9[0]) / x;
            jacobianRet[2] = 1.0 - jacobianRet[1];
            dArray = var3_2;
        }
        return dArray;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ double[] $anonfun$jacobianWaveNugget$1(double[] variables$10, double x) {
        double[] dArray;
        if (x == 0.0) {
            dArray = (double[])Array$.MODULE$.fill(2, (Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> 0.0, ClassTag$.MODULE$.Double());
        } else {
            void var3_2;
            double[] jacobianRet = (double[])Array$.MODULE$.ofDim(2, ClassTag$.MODULE$.Double());
            jacobianRet[0] = variables$10[1] * (package$.MODULE$.cos(x / variables$10[0]) / variables$10[0] - package$.MODULE$.sin(x / variables$10[0]) / x);
            jacobianRet[1] = 1.0 - variables$10[0] * package$.MODULE$.sin(x / variables$10[0]) / x;
            dArray = var3_2;
        }
        return dArray;
    }

    private static final double f$1(double sum, double tail, double mean$1) {
        double dif = tail - mean$1;
        return sum + dif * dif;
    }

    private static final double stdev$1(double[] data) {
        if (data.length < 2) {
            return Double.NaN;
        }
        double mean = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(data)).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)data.length;
        double sum = BoxesRunTime.unboxToDouble((Object)new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(data)).foldLeft((Object)BoxesRunTime.boxToDouble((double)0.0), (Function2)(JFunction2.mcDDD.sp & Serializable & scala.Serializable)(s, t) -> NonLinearSemivariogram$.f$1(s, t, mean)));
        return package$.MODULE$.sqrt(sum / (double)(data.length - 1));
    }

    private NonLinearSemivariogram$() {
        MODULE$ = this;
    }
}

