/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector.triangulation;

import geotrellis.vector.Extent;
import geotrellis.vector.Point$;
import geotrellis.vector.Polygon$;
import geotrellis.vector.io.wkt.WKT$;
import geotrellis.vector.mesh.HalfEdgeTable;
import geotrellis.vector.mesh.IndexedPointSet;
import geotrellis.vector.mesh.IndexedPointSet$;
import geotrellis.vector.triangulation.BoundaryDelaunay;
import geotrellis.vector.triangulation.DelaunayTriangulation;
import geotrellis.vector.triangulation.TriangleMap;
import java.io.Serializable;
import org.locationtech.jts.algorithm.distance.DistanceToPoint;
import org.locationtech.jts.algorithm.distance.PointPairDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class BoundaryDelaunay$
implements scala.Serializable {
    public static BoundaryDelaunay$ MODULE$;

    static {
        new BoundaryDelaunay$();
    }

    public boolean isMeshValid(TriangleMap triangles, HalfEdgeTable het) {
        BooleanRef valid = BooleanRef.create((boolean)true);
        triangles.getTriangles().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            BoundaryDelaunay$.$anonfun$isMeshValid$1(het, valid, x0$1);
            return BoxedUnit.UNIT;
        }, Iterable$.MODULE$.canBuildFrom());
        return valid.elem;
    }

    public BoundaryDelaunay apply(DelaunayTriangulation dt, Extent boundingExtent) {
        int n;
        Map verts = (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        HalfEdgeTable halfEdgeTable = new HalfEdgeTable(3 * dt.pointSet().length() - 6);
        Set liveVertices = Set$.MODULE$.empty();
        boolean isLinear = dt.isLinear();
        TriangleMap triangles = new TriangleMap(halfEdgeTable);
        Set outerEdges = Set$.MODULE$.empty();
        Map innerEdges = Map$.MODULE$.empty();
        if (dt.isLinear()) {
            int n2 = dt.numVertices();
            switch (n2) {
                case 0: {
                    n = -1;
                    break;
                }
                case 1: {
                    BoundaryDelaunay$.addPoint$1(BoxesRunTime.unboxToInt((Object)dt.liveVertices().toSeq().apply(0)), verts, dt, liveVertices);
                    n = -1;
                    break;
                }
                default: {
                    n = BoundaryDelaunay$.copyConvertLinearBound$1(dt, halfEdgeTable, verts, liveVertices);
                    break;
                }
            }
        } else {
            n = BoundaryDelaunay$.copyConvertBoundingTris$1(dt, halfEdgeTable, outerEdges, innerEdges, verts, liveVertices, boundingExtent, triangles);
        }
        int boundary = n;
        return new BoundaryDelaunay(IndexedPointSet$.MODULE$.apply((scala.collection.immutable.Map<Object, Coordinate>)verts.toMap(Predef$.MODULE$.$conforms())), (scala.collection.immutable.Set<Object>)liveVertices.toSet(), halfEdgeTable, triangles, boundary, isLinear);
    }

    public BoundaryDelaunay apply(IndexedPointSet pointSet, scala.collection.immutable.Set<Object> liveVertices, HalfEdgeTable halfEdgeTable, TriangleMap triangleMap, int boundary, boolean isLinear) {
        return new BoundaryDelaunay(pointSet, liveVertices, halfEdgeTable, triangleMap, boundary, isLinear);
    }

    public Option<Tuple6<IndexedPointSet, scala.collection.immutable.Set<Object>, HalfEdgeTable, TriangleMap, Object, Object>> unapply(BoundaryDelaunay x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple6((Object)x$0.pointSet(), x$0.liveVertices(), (Object)x$0.halfEdgeTable(), (Object)x$0.triangleMap(), (Object)BoxesRunTime.boxToInteger((int)x$0.boundary()), (Object)BoxesRunTime.boxToBoolean((boolean)x$0.isLinear())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ void $anonfun$isMeshValid$1(HalfEdgeTable het$1, BooleanRef valid$1, Tuple2 x0$1) {
        Tuple2 tuple22 = x0$1;
        if (tuple22 != null) {
            Tuple3 idx = (Tuple3)tuple22._1();
            int e0 = tuple22._2$mcI$sp();
            Tuple3 tuple32 = idx;
            if (tuple32 == null) {
                throw new MatchError((Object)tuple32);
            }
            int a = BoxesRunTime.unboxToInt((Object)tuple32._1());
            int b = BoxesRunTime.unboxToInt((Object)tuple32._2());
            int c = BoxesRunTime.unboxToInt((Object)tuple32._3());
            Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)a), (Object)BoxesRunTime.boxToInteger((int)b), (Object)BoxesRunTime.boxToInteger((int)c));
            Tuple3 tuple34 = tuple33;
            int a2 = BoxesRunTime.unboxToInt((Object)tuple34._1());
            int b2 = BoxesRunTime.unboxToInt((Object)tuple34._2());
            int c2 = BoxesRunTime.unboxToInt((Object)tuple34._3());
            int e = e0;
            do {
                if (het$1.getFlip(het$1.getFlip(e)) == e) continue;
                Predef$.MODULE$.println((Object)new StringBuilder(42).append("In triangle ").append(new Tuple3((Object)BoxesRunTime.boxToInteger((int)a2), (Object)BoxesRunTime.boxToInteger((int)b2), (Object)BoxesRunTime.boxToInteger((int)c2))).append(": edge ").append(het$1.getSrc(e)).append(" -> ").append(het$1.getDest(e)).append(" has improper flips").toString());
                valid$1.elem = false;
            } while ((e = het$1.getNext(e)) != e0);
        } else {
            throw new MatchError((Object)tuple22);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final int addPoint$1(int v, Map verts$1, DelaunayTriangulation dt$1, Set liveVertices$1) {
        int ix = v;
        verts$1.getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)ix), (Function0 & Serializable & scala.Serializable)() -> new Coordinate(dt$1.pointSet().getX(v), dt$1.pointSet().getY(v), dt$1.pointSet().getZ(v)));
        liveVertices$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)ix));
        return ix;
    }

    private static final int addHalfEdges$1(int a, int b, HalfEdgeTable halfEdgeTable$1) {
        return halfEdgeTable$1.createHalfEdges(a, b);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean circumcircleLeavesExtent$1(Extent extent, int tri, DelaunayTriangulation dt$1) {
        Tuple3<Object, Coordinate, Object> tuple32 = dt$1.predicates().circleCenter(dt$1.halfEdgeTable().getDest(tri), dt$1.halfEdgeTable().getDest(dt$1.halfEdgeTable().getNext(tri)), dt$1.halfEdgeTable().getDest(dt$1.halfEdgeTable().getNext(dt$1.halfEdgeTable().getNext(tri))));
        if (tuple32 == null) throw new MatchError(tuple32);
        double radius = BoxesRunTime.unboxToDouble((Object)tuple32._1());
        Coordinate center = (Coordinate)tuple32._2();
        boolean valid = BoxesRunTime.unboxToBoolean((Object)tuple32._3());
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)radius), (Object)center, (Object)BoxesRunTime.boxToBoolean((boolean)valid));
        Tuple3 tuple34 = tuple33;
        double radius2 = BoxesRunTime.unboxToDouble((Object)tuple34._1());
        Coordinate center2 = (Coordinate)tuple34._2();
        boolean valid2 = BoxesRunTime.unboxToBoolean((Object)tuple34._3());
        if (!valid2) return true;
        PointPairDistance ppd = new PointPairDistance();
        DistanceToPoint.computeDistance((Polygon)extent.toPolygon(), (Coordinate)center2, (PointPairDistance)ppd);
        if (!(ppd.getDistance() < radius2)) return false;
        return true;
    }

    public static final /* synthetic */ Coordinate $anonfun$apply$2(DelaunayTriangulation dt$1, int x$4) {
        return dt$1.pointSet().getCoordinate(x$4);
    }

    private static final boolean outside$1(double x) {
        return x < 0.0 || x > 1.0;
    }

    private static final boolean inclusionTest$1(Extent extent, double thresh, int tri, DelaunayTriangulation dt$1) {
        boolean bl;
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)dt$1.halfEdgeTable().getSrc(tri)), (Object)BoxesRunTime.boxToInteger((int)dt$1.halfEdgeTable().getDest(tri)), (Object)BoxesRunTime.boxToInteger((int)dt$1.halfEdgeTable().getDest(dt$1.halfEdgeTable().getNext(tri))));
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        int i = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int j = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int k = BoxesRunTime.unboxToInt((Object)tuple32._3());
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)i), (Object)BoxesRunTime.boxToInteger((int)j), (Object)BoxesRunTime.boxToInteger((int)k));
        Tuple3 tuple34 = tuple33;
        int i2 = BoxesRunTime.unboxToInt((Object)tuple34._1());
        int j2 = BoxesRunTime.unboxToInt((Object)tuple34._2());
        int k2 = BoxesRunTime.unboxToInt((Object)tuple34._3());
        Function1 & Serializable & scala.Serializable trans = (Function1 & Serializable & scala.Serializable)x$4 -> BoundaryDelaunay$.$anonfun$apply$2(dt$1, BoxesRunTime.unboxToInt((Object)x$4));
        Coordinate pi = (Coordinate)trans.apply((Object)BoxesRunTime.boxToInteger((int)i2));
        Coordinate pj = (Coordinate)trans.apply((Object)BoxesRunTime.boxToInteger((int)j2));
        Coordinate pk = (Coordinate)trans.apply((Object)BoxesRunTime.boxToInteger((int)k2));
        Tuple3<Object, Coordinate, Object> tuple35 = dt$1.predicates().circleCenter(i2, j2, k2);
        if (tuple35 == null) {
            throw new MatchError(tuple35);
        }
        double radius = BoxesRunTime.unboxToDouble((Object)tuple35._1());
        Coordinate center = (Coordinate)tuple35._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)radius), (Object)center);
        Tuple2 tuple23 = tuple22;
        double radius2 = tuple23._1$mcD$sp();
        Coordinate center2 = (Coordinate)tuple23._2();
        double shortest = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{pi.distance(pj), pi.distance(pk), pj.distance(pk)}))).min((Ordering)Ordering.Double$.MODULE$));
        if (radius2 / shortest > thresh) {
            bl = true;
        } else {
            Extent extent2 = extent;
            if (extent2 == null) {
                throw new MatchError((Object)extent2);
            }
            double x0 = extent2.xmin();
            double y0 = extent2.ymin();
            double x1 = extent2.xmax();
            double y1 = extent2.ymax();
            Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)x0), (Object)BoxesRunTime.boxToDouble((double)y0), (Object)BoxesRunTime.boxToDouble((double)x1), (Object)BoxesRunTime.boxToDouble((double)y1));
            Tuple4 tuple43 = tuple42;
            double x02 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
            double y02 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
            double x12 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
            double y12 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
            bl = x12 - radius2 < x02 + radius2 || y12 - radius2 < y02 + radius2 || BoundaryDelaunay$.outside$1((center2.x - (x02 + radius2)) / (x12 - radius2 - (x02 + radius2))) || BoundaryDelaunay$.outside$1((center2.y - (y02 + radius2)) / (y12 - radius2 - (y02 + radius2)));
        }
        return bl;
    }

    private static final Option lookupTriangle$1(int tri, TriangleMap triangles$1, DelaunayTriangulation dt$1, HalfEdgeTable halfEdgeTable$1) {
        Option<Object> option2 = triangles$1.get(dt$1.halfEdgeTable().getDest(tri), dt$1.halfEdgeTable().getDest(dt$1.halfEdgeTable().getNext(tri)), dt$1.halfEdgeTable().getDest(dt$1.halfEdgeTable().getNext(dt$1.halfEdgeTable().getNext(tri))));
        if (option2 instanceof Some) {
            int base;
            Some some = (Some)option2;
            int e = base = BoxesRunTime.unboxToInt((Object)some.value());
            do {
                if (halfEdgeTable$1.getDest(e) != dt$1.halfEdgeTable().getDest(tri)) continue;
                return new Some((Object)BoxesRunTime.boxToInteger((int)e));
            } while ((e = halfEdgeTable$1.getNext(e)) != base);
            throw new IllegalStateException("Unhandled case");
        }
        if (!None$.MODULE$.equals(option2)) {
            throw new MatchError(option2);
        }
        None$ none$ = None$.MODULE$;
        return none$;
    }

    private static final int copyConvertEdge$1(int e, DelaunayTriangulation dt$1, Map verts$1, Set liveVertices$1, HalfEdgeTable halfEdgeTable$1) {
        BoundaryDelaunay$.addPoint$1(dt$1.halfEdgeTable().getSrc(e), verts$1, dt$1, liveVertices$1);
        BoundaryDelaunay$.addPoint$1(dt$1.halfEdgeTable().getDest(e), verts$1, dt$1, liveVertices$1);
        return BoundaryDelaunay$.addHalfEdges$1(dt$1.halfEdgeTable().getSrc(e), dt$1.halfEdgeTable().getDest(e), halfEdgeTable$1);
    }

    private static final int copyConvertLinearBound$1(DelaunayTriangulation dt$1, HalfEdgeTable halfEdgeTable$1, Map verts$1, Set liveVertices$1) {
        Map correspondingEdge = Map$.MODULE$.empty();
        int e = dt$1.boundary();
        do {
            int edge = halfEdgeTable$1.createHalfEdge(dt$1.halfEdgeTable().getDest(e));
            BoundaryDelaunay$.addPoint$1(dt$1.halfEdgeTable().getDest(e), verts$1, dt$1, liveVertices$1);
            correspondingEdge.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(dt$1.halfEdgeTable().getSrc(e), dt$1.halfEdgeTable().getDest(e))), (Object)BoxesRunTime.boxToInteger((int)edge)));
            e = dt$1.halfEdgeTable().getNext(e);
        } while (e != dt$1.boundary());
        do {
            int edge = BoxesRunTime.unboxToInt((Object)correspondingEdge.apply((Object)new Tuple2.mcII.sp(dt$1.halfEdgeTable().getSrc(e), dt$1.halfEdgeTable().getDest(e))));
            int flip = BoxesRunTime.unboxToInt((Object)correspondingEdge.apply((Object)new Tuple2.mcII.sp(dt$1.halfEdgeTable().getDest(e), dt$1.halfEdgeTable().getSrc(e))));
            halfEdgeTable$1.setFlip(edge, flip);
            halfEdgeTable$1.setFlip(flip, edge);
            halfEdgeTable$1.setNext(edge, BoxesRunTime.unboxToInt((Object)correspondingEdge.apply((Object)new Tuple2.mcII.sp(dt$1.halfEdgeTable().getDest(e), dt$1.halfEdgeTable().getDest(dt$1.halfEdgeTable().getNext(e))))));
            e = dt$1.halfEdgeTable().getNext(e);
        } while (e != dt$1.boundary());
        return BoxesRunTime.unboxToInt((Object)correspondingEdge.apply((Object)new Tuple2.mcII.sp(dt$1.halfEdgeTable().getSrc(dt$1.boundary()), dt$1.halfEdgeTable().getDest(dt$1.boundary()))));
    }

    private static final int copyConvertBoundingLoop$1(DelaunayTriangulation dt$1, Set outerEdges$1, Map innerEdges$1, HalfEdgeTable halfEdgeTable$1, Map verts$1, Set liveVertices$1) {
        int first2;
        int last = first2 = BoundaryDelaunay$.copyConvertEdge$1(dt$1.boundary(), dt$1, verts$1, liveVertices$1, halfEdgeTable$1);
        outerEdges$1.$plus$eq((Object)new Tuple2.mcII.sp(dt$1.halfEdgeTable().getSrc(dt$1.boundary()), dt$1.halfEdgeTable().getDest(dt$1.boundary())));
        innerEdges$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(dt$1.halfEdgeTable().getDest(dt$1.boundary()), dt$1.halfEdgeTable().getSrc(dt$1.boundary()))), (Object)new Tuple2.mcII.sp(dt$1.halfEdgeTable().getFlip(dt$1.boundary()), first2)));
        int e = dt$1.halfEdgeTable().getNext(dt$1.boundary());
        do {
            int copy = BoundaryDelaunay$.copyConvertEdge$1(e, dt$1, verts$1, liveVertices$1, halfEdgeTable$1);
            outerEdges$1.$plus$eq((Object)new Tuple2.mcII.sp(dt$1.halfEdgeTable().getSrc(e), dt$1.halfEdgeTable().getDest(e)));
            innerEdges$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(dt$1.halfEdgeTable().getDest(e), dt$1.halfEdgeTable().getSrc(e))), (Object)new Tuple2.mcII.sp(dt$1.halfEdgeTable().getFlip(e), copy)));
            halfEdgeTable$1.setNext(last, copy);
            halfEdgeTable$1.setNext(halfEdgeTable$1.getFlip(copy), halfEdgeTable$1.getFlip(last));
            last = copy;
            e = dt$1.halfEdgeTable().getNext(e);
        } while (e != dt$1.boundary());
        halfEdgeTable$1.setNext(last, first2);
        halfEdgeTable$1.setNext(halfEdgeTable$1.getFlip(first2), halfEdgeTable$1.getFlip(last));
        return first2;
    }

    private static final int copyConvertTriangle$1(int tri, DelaunayTriangulation dt$1, HalfEdgeTable halfEdgeTable$1, TriangleMap triangles$1, Map verts$1, Set liveVertices$1) {
        int a = BoundaryDelaunay$.addPoint$1(dt$1.halfEdgeTable().getDest(tri), verts$1, dt$1, liveVertices$1);
        int b = BoundaryDelaunay$.addPoint$1(dt$1.halfEdgeTable().getDest(dt$1.halfEdgeTable().getNext(tri)), verts$1, dt$1, liveVertices$1);
        int c = BoundaryDelaunay$.addPoint$1(dt$1.halfEdgeTable().getDest(dt$1.halfEdgeTable().getNext(dt$1.halfEdgeTable().getNext(tri))), verts$1, dt$1, liveVertices$1);
        int copy = halfEdgeTable$1.getFlip(halfEdgeTable$1.getNext(halfEdgeTable$1.createHalfEdges(a, b, c)));
        triangles$1.$plus$eq((Tuple2<Tuple3<Object, Object, Object>, Object>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)a), (Object)BoxesRunTime.boxToInteger((int)b), (Object)BoxesRunTime.boxToInteger((int)c))), (Object)BoxesRunTime.boxToInteger((int)copy)));
        return copy;
    }

    private static final void recursiveAddTris$1(int e0, int opp0, Set outerEdges$1, DelaunayTriangulation dt$1, Map innerEdges$1, HalfEdgeTable halfEdgeTable$1, Extent boundingExtent$1, TriangleMap triangles$1, Map verts$1, Set liveVertices$1) {
        Queue workQueue = (Queue)Queue$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(e0, opp0)}));
        while (workQueue.nonEmpty()) {
            BoxedUnit boxedUnit;
            Tuple2 tuple22 = (Tuple2)workQueue.dequeue();
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            int e = tuple22._1$mcI$sp();
            int opp = tuple22._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(e, opp);
            Tuple2.mcII.sp sp3 = sp2;
            int e2 = sp3._1$mcI$sp();
            int opp2 = sp3._2$mcI$sp();
            boolean isOuterEdge = outerEdges$1.contains((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)dt$1.halfEdgeTable().getSrc(e2))), (Object)BoxesRunTime.boxToInteger((int)dt$1.halfEdgeTable().getDest(e2))));
            boolean isInInnerRing = innerEdges$1.contains((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)dt$1.halfEdgeTable().getSrc(e2))), (Object)BoxesRunTime.boxToInteger((int)dt$1.halfEdgeTable().getDest(e2))));
            if (!isOuterEdge && isInInnerRing) {
                BoxedUnit boxedUnit2;
                Option option2 = BoundaryDelaunay$.lookupTriangle$1(e2, triangles$1, dt$1, halfEdgeTable$1);
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    int tri = BoxesRunTime.unboxToInt((Object)some.value());
                    halfEdgeTable$1.join(opp2, tri);
                    innerEdges$1.$minus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)halfEdgeTable$1.getSrc(tri))), (Object)BoxesRunTime.boxToInteger((int)halfEdgeTable$1.getDest(tri))));
                    boxedUnit2 = innerEdges$1.$minus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)halfEdgeTable$1.getDest(tri))), (Object)BoxesRunTime.boxToInteger((int)halfEdgeTable$1.getSrc(tri))));
                } else if (None$.MODULE$.equals(option2)) {
                    BoxedUnit boxedUnit3;
                    if (BoundaryDelaunay$.inclusionTest$1(boundingExtent$1, 5.0, e2, dt$1)) {
                        int tri = BoundaryDelaunay$.copyConvertTriangle$1(e2, dt$1, halfEdgeTable$1, triangles$1, verts$1, liveVertices$1);
                        int tri2 = halfEdgeTable$1.getNext(tri);
                        int tri3 = halfEdgeTable$1.getNext(halfEdgeTable$1.getNext(tri));
                        halfEdgeTable$1.join(opp2, tri);
                        innerEdges$1.$minus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)halfEdgeTable$1.getSrc(tri))), (Object)BoxesRunTime.boxToInteger((int)halfEdgeTable$1.getDest(tri))));
                        innerEdges$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(halfEdgeTable$1.getDest(tri2), halfEdgeTable$1.getSrc(tri2))), (Object)new Tuple2.mcII.sp(dt$1.halfEdgeTable().getFlip(dt$1.halfEdgeTable().getNext(e2)), tri2)));
                        innerEdges$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(halfEdgeTable$1.getDest(tri3), halfEdgeTable$1.getSrc(tri3))), (Object)new Tuple2.mcII.sp(dt$1.halfEdgeTable().getFlip(dt$1.halfEdgeTable().getNext(dt$1.halfEdgeTable().getNext(e2))), tri3)));
                        workQueue.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(dt$1.halfEdgeTable().getFlip(dt$1.halfEdgeTable().getNext(e2)), tri2)}));
                        workQueue.enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcII.sp(dt$1.halfEdgeTable().getFlip(dt$1.halfEdgeTable().getNext(dt$1.halfEdgeTable().getNext(e2))), tri3)}));
                        boxedUnit3 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit3 = BoxedUnit.UNIT;
                    }
                    boxedUnit2 = boxedUnit3;
                } else {
                    throw new MatchError((Object)option2);
                }
                boxedUnit = boxedUnit2;
                continue;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$apply$4(HalfEdgeTable halfEdgeTable$1, scala.collection.immutable.Map bounds$1, Map verts$1, ListBuffer polys$1, DelaunayTriangulation dt$1, TriangleMap triangles$1, Set liveVertices$1, Tuple2 x0$2) {
        Tuple2 tuple22 = x0$2;
        if (tuple22 != null) {
            int e0 = tuple22._1$mcI$sp();
            int o0 = tuple22._2$mcI$sp();
            int e = e0;
            int pairedE = halfEdgeTable$1.getFlip(o0);
            boolean bl = true;
            int j = 0;
            do {
                BoxedUnit boxedUnit;
                Option option2;
                if ((option2 = bounds$1.get((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)halfEdgeTable$1.getSrc(pairedE))), (Object)BoxesRunTime.boxToInteger((int)halfEdgeTable$1.getDest(pairedE))))) instanceof Some) {
                    Some some = (Some)option2;
                    int next = BoxesRunTime.unboxToInt((Object)some.value());
                    if (pairedE != next) {
                        halfEdgeTable$1.join(halfEdgeTable$1.getFlip(pairedE), next);
                        pairedE = next;
                    }
                    bl = false;
                    boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option2)) {
                    BoxedUnit boxedUnit2;
                    Option option3 = BoundaryDelaunay$.lookupTriangle$1(e, triangles$1, dt$1, halfEdgeTable$1);
                    if (None$.MODULE$.equals(option3)) {
                        int tri = BoundaryDelaunay$.copyConvertTriangle$1(e, dt$1, halfEdgeTable$1, triangles$1, verts$1, liveVertices$1);
                        int a = halfEdgeTable$1.getDest(tri);
                        int b = halfEdgeTable$1.getDest(halfEdgeTable$1.getNext(tri));
                        int c = halfEdgeTable$1.getDest(halfEdgeTable$1.getNext(halfEdgeTable$1.getNext(tri)));
                        Point pa = Point$.MODULE$.apply(((Coordinate)verts$1.apply((Object)BoxesRunTime.boxToInteger((int)a))).x, ((Coordinate)verts$1.apply((Object)BoxesRunTime.boxToInteger((int)a))).y);
                        Point pb = Point$.MODULE$.apply(((Coordinate)verts$1.apply((Object)BoxesRunTime.boxToInteger((int)b))).x, ((Coordinate)verts$1.apply((Object)BoxesRunTime.boxToInteger((int)b))).y);
                        Point pc = Point$.MODULE$.apply(((Coordinate)verts$1.apply((Object)BoxesRunTime.boxToInteger((int)c))).x, ((Coordinate)verts$1.apply((Object)BoxesRunTime.boxToInteger((int)c))).y);
                        polys$1.$plus$eq((Object)Polygon$.MODULE$.apply((Seq<Point>)Predef$.MODULE$.wrapRefArray((Object[])new Point[]{pa, pb, pc, pa}), Predef.DummyImplicit$.MODULE$.dummyImplicit()));
                        try {
                            halfEdgeTable$1.join(tri, halfEdgeTable$1.getFlip(pairedE));
                        }
                        catch (AssertionError assertionError) {
                            Predef$.MODULE$.println((Object)WKT$.MODULE$.write((Geometry)Polygon$.MODULE$.apply((Seq<Point>)Predef$.MODULE$.wrapRefArray((Object[])new Point[]{pa, pb, pc, pa}), Predef.DummyImplicit$.MODULE$.dummyImplicit())));
                            throw new IllegalArgumentException("Improper join");
                        }
                        pairedE = tri;
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else if (option3 instanceof Some) {
                        BoxedUnit boxedUnit3;
                        Some some = (Some)option3;
                        int tri = BoxesRunTime.unboxToInt((Object)some.value());
                        if (pairedE != tri) {
                            halfEdgeTable$1.join(tri, halfEdgeTable$1.getFlip(pairedE));
                            pairedE = tri;
                            boxedUnit3 = BoxedUnit.UNIT;
                        } else {
                            boxedUnit3 = BoxedUnit.UNIT;
                        }
                        boxedUnit2 = boxedUnit3;
                    } else {
                        throw new MatchError((Object)option3);
                    }
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    throw new MatchError((Object)option2);
                }
                e = dt$1.halfEdgeTable().rotCWDest(e);
                pairedE = halfEdgeTable$1.rotCWDest(pairedE);
                ++j;
            } while (bl);
        } else {
            throw new MatchError((Object)tuple22);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private static final void fillInnerLoop$1(Map innerEdges$1, HalfEdgeTable halfEdgeTable$1, Map verts$1, DelaunayTriangulation dt$1, TriangleMap triangles$1, Set liveVertices$1) {
        ListBuffer polys = (ListBuffer)ListBuffer$.MODULE$.empty();
        scala.collection.immutable.Map bounds = ((TraversableOnce)innerEdges$1.values().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple22 = x0$1;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            int o = tuple22._2$mcI$sp();
            Tuple2 tuple23 = new Tuple2((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)halfEdgeTable$1.getSrc(o))), (Object)BoxesRunTime.boxToInteger((int)halfEdgeTable$1.getDest(o))), (Object)BoxesRunTime.boxToInteger((int)o));
            return tuple23;
        }, scala.collection.Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        innerEdges$1.values().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            BoundaryDelaunay$.$anonfun$apply$4(halfEdgeTable$1, bounds, verts$1, polys, dt$1, triangles$1, liveVertices$1, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    private static final int copyConvertBoundingTris$1(DelaunayTriangulation dt$1, HalfEdgeTable halfEdgeTable$1, Set outerEdges$1, Map innerEdges$1, Map verts$1, Set liveVertices$1, Extent boundingExtent$1, TriangleMap triangles$1) {
        int newBound = BoundaryDelaunay$.copyConvertBoundingLoop$1(dt$1, outerEdges$1, innerEdges$1, halfEdgeTable$1, verts$1, liveVertices$1);
        int e = dt$1.boundary();
        int ne = newBound;
        do {
            Predef$.MODULE$.assert(dt$1.halfEdgeTable().getDest(e) == halfEdgeTable$1.getDest(ne) && dt$1.halfEdgeTable().getSrc(e) == halfEdgeTable$1.getSrc(ne));
            BoundaryDelaunay$.recursiveAddTris$1(dt$1.halfEdgeTable().getFlip(e), ne, outerEdges$1, dt$1, innerEdges$1, halfEdgeTable$1, boundingExtent$1, triangles$1, verts$1, liveVertices$1);
            e = dt$1.halfEdgeTable().getNext(e);
            ne = halfEdgeTable$1.getNext(ne);
        } while (e != dt$1.boundary());
        BoundaryDelaunay$.fillInnerLoop$1(innerEdges$1, halfEdgeTable$1, verts$1, dt$1, triangles$1, liveVertices$1);
        return newBound;
    }

    private BoundaryDelaunay$() {
        MODULE$ = this;
    }
}

