/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector.voronoi;

import geotrellis.vector.Extent;
import geotrellis.vector.mesh.CompleteIndexedPointSet;
import geotrellis.vector.mesh.HalfEdgeTable;
import geotrellis.vector.triangulation.DelaunayTriangulation;
import geotrellis.vector.voronoi.VoronoiDiagram$;
import geotrellis.vector.voronoi.VoronoiDiagram$V2$;
import java.io.Serializable;
import org.apache.commons.math3.linear.RealVector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Polygon;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0005r\u0001CA\u0002\u0003\u000bA\t!a\u0005\u0007\u0011\u0005]\u0011Q\u0001E\u0001\u00033Aq!!\f\u0002\t\u0003\ty\u0003C\u0004\u00022\u0005!\t!a\r\t\u0013\u0005=\u0018!%A\u0005\u0002\u0005Exa\u0002B\u0004\u0003!\u0005!\u0011\u0002\u0004\b\u0005\u001b\t\u0001\u0012\u0001B\b\u0011\u001d\tiC\u0002C\u0001\u0005#Aq!!\r\u0007\t\u0003\u0011\u0019\u0002C\u0004\u00022\u0019!\tAa9\t\u0013\u0005Eb!!A\u0005\u0002\n%\b\"\u0003Bw\r\u0005\u0005I\u0011\u0011Bx\u0011%\u00119PBA\u0001\n\u0013\u0011IP\u0002\u0004\u0003\u000e\u0005\u0001%q\u0003\u0005\u000b\u0005?i!Q3A\u0005\u0002\t\u0005\u0002B\u0003B\u001e\u001b\tE\t\u0015!\u0003\u0003$!9\u0011QF\u0007\u0005\u0002\tu\u0002b\u0002B!\u001b\u0011\u0005!1\t\u0005\b\u0005\u0013jA\u0011\u0001B&\u0011\u001d\u0011I%\u0004C\u0001\u0005\u001fBqAa\u0015\u000e\t\u0003\u0011)\u0006C\u0004\u0003b5!\tAa\u0019\t\u000f\t\u001dT\u0002\"\u0001\u0003j!9!1N\u0007\u0005\u0002\t5\u0004b\u0002B8\u001b\u0011\u0005!\u0011\u000e\u0005\b\u0005cjA\u0011\u0001B5\u0011\u001d\u0011\u0019(\u0004C!\u0005kBqAa\"\u000e\t\u0003\u0011I\tC\u0004\u0003\f6!\tA!\u001c\t\u000f\t5U\u0002\"\u0001\u0003n!I!qR\u0007\u0002\u0002\u0013\u0005!\u0011\u0013\u0005\n\u0005+k\u0011\u0013!C\u0001\u0005/C\u0011Ba'\u000e\u0003\u0003%\tE!(\t\u0013\t5V\"!A\u0005\u0002\t=\u0006\"\u0003BY\u001b\u0005\u0005I\u0011\u0001BZ\u0011%\u0011y,DA\u0001\n\u0003\u0012\t\rC\u0005\u0003P6\t\t\u0011\"\u0001\u0003R\"I!Q[\u0007\u0002\u0002\u0013\u0005#q\u001b\u0005\n\u00053l\u0011\u0011!C!\u000574\u0011b!\u0001\u0002!\u0003\r\nca\u0001\u0007\r\r\u001d\u0011\u0001QB\u0005\u0011)\u0019i\u0001\u000bBK\u0002\u0013\u00051q\u0002\u0005\u000b\u0007#A#\u0011#Q\u0001\n\u0005\u0005\u0007BCB\nQ\tU\r\u0011\"\u0001\u0004\u0016!Q1q\u0003\u0015\u0003\u0012\u0003\u0006IA!\u0006\t\u000f\u00055\u0002\u0006\"\u0001\u0004\u001a!I!q\u0012\u0015\u0002\u0002\u0013\u00051\u0011\u0005\u0005\n\u0005+C\u0013\u0013!C\u0001\u0007OA\u0011ba\u000b)#\u0003%\ta!\f\t\u0013\tm\u0005&!A\u0005B\tu\u0005\"\u0003BWQ\u0005\u0005I\u0011\u0001BX\u0011%\u0011\t\fKA\u0001\n\u0003\u0019\t\u0004C\u0005\u0003@\"\n\t\u0011\"\u0011\u0003B\"I!q\u001a\u0015\u0002\u0002\u0013\u00051Q\u0007\u0005\n\u0005+D\u0013\u0011!C!\u0005/D\u0011Ba\u001d)\u0003\u0003%\te!\u000f\t\u0013\te\u0007&!A\u0005B\rmr!CB>\u0003\u0005\u0005\t\u0012AB?\r%\u00199!AA\u0001\u0012\u0003\u0019y\bC\u0004\u0002.i\"\ta!$\t\u0013\tM$(!A\u0005F\re\u0002\"CA\u0019u\u0005\u0005I\u0011QBH\u0011%\u0011iOOA\u0001\n\u0003\u001b)\nC\u0005\u0003xj\n\t\u0011\"\u0003\u0003z\u001a11qH\u0001A\u0007\u0003B!b!\u0004A\u0005+\u0007I\u0011AB\b\u0011)\u0019\t\u0002\u0011B\tB\u0003%\u0011\u0011\u0019\u0005\u000b\u0007'\u0001%Q3A\u0005\u0002\rU\u0001BCB\f\u0001\nE\t\u0015!\u0003\u0003\u0016!9\u0011Q\u0006!\u0005\u0002\r\r\u0003\"\u0003BH\u0001\u0006\u0005I\u0011AB&\u0011%\u0011)\nQI\u0001\n\u0003\u00199\u0003C\u0005\u0004,\u0001\u000b\n\u0011\"\u0001\u0004.!I!1\u0014!\u0002\u0002\u0013\u0005#Q\u0014\u0005\n\u0005[\u0003\u0015\u0011!C\u0001\u0005_C\u0011B!-A\u0003\u0003%\ta!\u0015\t\u0013\t}\u0006)!A\u0005B\t\u0005\u0007\"\u0003Bh\u0001\u0006\u0005I\u0011AB+\u0011%\u0011)\u000eQA\u0001\n\u0003\u00129\u000eC\u0005\u0003t\u0001\u000b\t\u0011\"\u0011\u0004:!I!\u0011\u001c!\u0002\u0002\u0013\u00053\u0011L\u0004\n\u0007;\u000b\u0011\u0011!E\u0001\u0007?3\u0011ba\u0010\u0002\u0003\u0003E\ta!)\t\u000f\u00055\"\u000b\"\u0001\u0004&\"I!1\u000f*\u0002\u0002\u0013\u00153\u0011\b\u0005\n\u0003c\u0011\u0016\u0011!CA\u0007OC\u0011B!<S\u0003\u0003%\ti!,\t\u0013\t](+!A\u0005\n\tehABB/\u0003\u0001\u001by\u0006\u0003\u0006\u0004\u000ea\u0013)\u001a!C\u0001\u0007\u001fA!b!\u0005Y\u0005#\u0005\u000b\u0011BAa\u0011)\u0019\u0019\u0002\u0017BK\u0002\u0013\u00051Q\u0003\u0005\u000b\u0007/A&\u0011#Q\u0001\n\tU\u0001bBA\u00171\u0012\u00051\u0011\r\u0005\n\u0005\u001fC\u0016\u0011!C\u0001\u0007SB\u0011B!&Y#\u0003%\taa\n\t\u0013\r-\u0002,%A\u0005\u0002\r5\u0002\"\u0003BN1\u0006\u0005I\u0011\tBO\u0011%\u0011i\u000bWA\u0001\n\u0003\u0011y\u000bC\u0005\u00032b\u000b\t\u0011\"\u0001\u0004p!I!q\u0018-\u0002\u0002\u0013\u0005#\u0011\u0019\u0005\n\u0005\u001fD\u0016\u0011!C\u0001\u0007gB\u0011B!6Y\u0003\u0003%\tEa6\t\u0013\tM\u0004,!A\u0005B\re\u0002\"\u0003Bm1\u0006\u0005I\u0011IB<\u000f%\u0019\t,AA\u0001\u0012\u0003\u0019\u0019LB\u0005\u0004^\u0005\t\t\u0011#\u0001\u00046\"9\u0011Q\u00066\u0005\u0002\re\u0006\"\u0003B:U\u0006\u0005IQIB\u001d\u0011%\t\tD[A\u0001\n\u0003\u001bY\fC\u0005\u0003n*\f\t\u0011\"!\u0004B\"I!q\u001f6\u0002\u0002\u0013%!\u0011 \u0005\n\u0007\u000b\f!\u0019!C\u0007\u0007\u000fD\u0001b!4\u0002A\u000351\u0011\u001a\u0005\b\u0007\u001f\fA\u0011BBi\u0011\u001d\u0019Y0\u0001C\u0005\u0007{Dq\u0001b\u0005\u0002\t\u0003!)\u0002C\u0005\u0003x\u0006\t\t\u0011\"\u0003\u0003z\u001a9\u0011qCA\u0003\u0001\u0005]\u0002BCA\u001dm\n\u0015\r\u0011\"\u0001\u0002<!Q\u0011\u0011\n<\u0003\u0002\u0003\u0006I!!\u0010\t\u0015\u0005-cO!b\u0001\n\u0003\ti\u0005\u0003\u0006\u0002XY\u0014\t\u0011)A\u0005\u0003\u001fBq!!\fw\t\u0003\tI\u0006C\u0005\u0002`Y\u0014\r\u0011\"\u0001\u0002b!A\u0011q\u000e<!\u0002\u0013\t\u0019\u0007C\u0004\u0002rY$\t!a\u001d\t\u000f\u0005\u0005f\u000f\"\u0001\u0002$\"9\u0011Q\u0017<\u0005\u0002\u0005]\u0016A\u0004,pe>tw.\u001b#jC\u001e\u0014\u0018-\u001c\u0006\u0005\u0003\u000f\tI!A\u0004w_J|gn\\5\u000b\t\u0005-\u0011QB\u0001\u0007m\u0016\u001cGo\u001c:\u000b\u0005\u0005=\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u0001\u0001cAA\u000b\u00035\u0011\u0011Q\u0001\u0002\u000f->\u0014xN\\8j\t&\fwM]1n'\u0015\t\u00111DA\u0014!\u0011\ti\"a\t\u000e\u0005\u0005}!BAA\u0011\u0003\u0015\u00198-\u00197b\u0013\u0011\t)#a\b\u0003\r\u0005s\u0017PU3g!\u0011\ti\"!\u000b\n\t\u0005-\u0012q\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005M\u0011!B1qa2LH\u0003CA\u001b\u00033\f\u0019/!:\u0011\u0007\u0005UaoE\u0003w\u00037\t9#\u0001\u0002eiV\u0011\u0011Q\b\t\u0005\u0003\u007f\t)%\u0004\u0002\u0002B)!\u00111IA\u0005\u00035!(/[1oOVd\u0017\r^5p]&!\u0011qIA!\u0005U!U\r\\1v]\u0006LHK]5b]\u001e,H.\u0019;j_:\f1\u0001\u001a;!\u0003\u0019)\u0007\u0010^3oiV\u0011\u0011q\n\t\u0005\u0003#\n\u0019&\u0004\u0002\u0002\n%!\u0011QKA\u0005\u0005\u0019)\u0005\u0010^3oi\u00069Q\r\u001f;f]R\u0004CCBA\u001b\u00037\ni\u0006C\u0004\u0002:m\u0004\r!!\u0010\t\u000f\u0005-3\u00101\u0001\u0002P\u0005A\u0001o\\5oiN+G/\u0006\u0002\u0002dA!\u0011QMA6\u001b\t\t9G\u0003\u0003\u0002j\u0005%\u0011\u0001B7fg\"LA!!\u001c\u0002h\t92i\\7qY\u0016$X-\u00138eKb,G\rU8j]R\u001cV\r^\u0001\na>Lg\u000e^*fi\u0002\n1B^8s_:|\u0017nQ3mYR!\u0011QOAL!\u0019\ti\"a\u001e\u0002|%!\u0011\u0011PA\u0010\u0005\u0019y\u0005\u000f^5p]B!\u0011QPAI\u001d\u0011\ty(!$\u000f\t\u0005\u0005\u00151\u0012\b\u0005\u0003\u0007\u000bI)\u0004\u0002\u0002\u0006*!\u0011qQA\t\u0003\u0019a$o\\8u}%\u0011\u0011qB\u0005\u0005\u0003\u0017\ti!\u0003\u0003\u0002\u0010\u0006%\u0011a\u00029bG.\fw-Z\u0005\u0005\u0003'\u000b)JA\u0004Q_2Lxm\u001c8\u000b\t\u0005=\u0015\u0011\u0002\u0005\b\u00033s\b\u0019AAN\u0003\u0005I\u0007\u0003BA\u000f\u0003;KA!a(\u0002 \t\u0019\u0011J\u001c;\u0002\u0019Y|'o\u001c8pS\u000e+G\u000e\\:\u0015\u0005\u0005\u0015\u0006CBAT\u0003_\u000bYH\u0004\u0003\u0002*\u00065f\u0002BAB\u0003WK!!!\t\n\t\u0005=\u0015qD\u0005\u0005\u0003c\u000b\u0019LA\u0002TKFTA!a$\u0002 \u00051bo\u001c:p]>L7)\u001a7mg^KG\u000f\u001b)pS:$8\u000f\u0006\u0002\u0002:B1\u0011qUAX\u0003w\u0003\u0002\"!\b\u0002>\u0006m\u0014\u0011Y\u0005\u0005\u0003\u007f\u000byB\u0001\u0004UkBdWM\r\t\u0005\u0003\u0007\f).\u0004\u0002\u0002F*!\u0011qYAe\u0003\u00119Wm\\7\u000b\t\u0005-\u0017QZ\u0001\u0004UR\u001c(\u0002BAh\u0003#\fA\u0002\\8dCRLwN\u001c;fG\"T!!a5\u0002\u0007=\u0014x-\u0003\u0003\u0002X\u0006\u0015'AC\"p_J$\u0017N\\1uK\"9\u00111\\\u0002A\u0002\u0005u\u0017a\u00019ugB1\u0011QDAp\u0003\u0003LA!!9\u0002 \t)\u0011I\u001d:bs\"9\u00111J\u0002A\u0002\u0005=\u0003\"CAt\u0007A\u0005\t\u0019AAu\u0003\u0015!WMY;h!\u0011\ti\"a;\n\t\u00055\u0018q\u0004\u0002\b\u0005>|G.Z1o\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001aTCAAzU\u0011\tI/!>,\u0005\u0005]\b\u0003BA}\u0005\u0007i!!a?\u000b\t\u0005u\u0018q`\u0001\nk:\u001c\u0007.Z2lK\u0012TAA!\u0001\u0002 \u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0015\u00111 \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017A\u0001,3!\r\u0011YAB\u0007\u0002\u0003\t\u0011aKM\n\u0006\r\u0005m\u0011q\u0005\u000b\u0003\u0005\u0013!bA!\u0006\u0003`\n\u0005\bc\u0001B\u0006\u001bM9Q\"a\u0007\u0003\u001a\u0005\u001d\u0002\u0003BA\u000f\u00057IAA!\b\u0002 \t9\u0001K]8ek\u000e$\u0018!\u0001<\u0016\u0005\t\r\u0002\u0003\u0002B\u0013\u0005oi!Aa\n\u000b\t\t%\"1F\u0001\u0007Y&tW-\u0019:\u000b\t\t5\"qF\u0001\u0006[\u0006$\bn\r\u0006\u0005\u0005c\u0011\u0019$A\u0004d_6lwN\\:\u000b\t\tU\u0012\u0011[\u0001\u0007CB\f7\r[3\n\t\te\"q\u0005\u0002\u000b%\u0016\fGNV3di>\u0014\u0018A\u0001<!)\u0011\u0011)Ba\u0010\t\u000f\t}\u0001\u00031\u0001\u0003$\u00051A%\\5okN$BA!\u0006\u0003F!9!qI\tA\u0002\tU\u0011\u0001\u0002;iCR\fQ\u0001\n9mkN$BA!\u0006\u0003N!9!q\t\nA\u0002\tUA\u0003BAa\u0005#BqAa\u0012\u0014\u0001\u0004\t\t-\u0001\u0004%i&lWm\u001d\u000b\u0005\u0005+\u00119\u0006C\u0004\u0003ZQ\u0001\rAa\u0017\u0002\u0003M\u0004B!!\b\u0003^%!!qLA\u0010\u0005\u0019!u.\u001e2mK\u0006\u0019Am\u001c;\u0015\t\tm#Q\r\u0005\b\u0005\u000f*\u0002\u0019\u0001B\u000b\u0003\u0019aWM\\4uQR\u0011!1L\u0001\n]>\u0014X.\u00197ju\u0016$\"A!\u0006\u0002\u0003a\f\u0011!_\u0001\ti>\u001cFO]5oOR\u0011!q\u000f\t\u0005\u0005s\u0012\tI\u0004\u0003\u0003|\tu\u0004\u0003BAB\u0003?IAAa \u0002 \u00051\u0001K]3eK\u001aLAAa!\u0003\u0006\n11\u000b\u001e:j]\u001eTAAa \u0002 \u00059Ao\\\"p_J$GCAAa\u0003!\u0011x\u000e^\u001d1\u0007\u000e;\u0016a\u0002:pif\u00024iV\u0001\u0005G>\u0004\u0018\u0010\u0006\u0003\u0003\u0016\tM\u0005\"\u0003B\u0010=A\u0005\t\u0019\u0001B\u0012\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"A!'+\t\t\r\u0012Q_\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\t}\u0005\u0003\u0002BQ\u0005Wk!Aa)\u000b\t\t\u0015&qU\u0001\u0005Y\u0006twM\u0003\u0002\u0003*\u0006!!.\u0019<b\u0013\u0011\u0011\u0019Ia)\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u0005m\u0015A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005k\u0013Y\f\u0005\u0003\u0002\u001e\t]\u0016\u0002\u0002B]\u0003?\u00111!\u00118z\u0011%\u0011iLIA\u0001\u0002\u0004\tY*A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005\u0007\u0004bA!2\u0003L\nUVB\u0001Bd\u0015\u0011\u0011I-a\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003N\n\u001d'\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$B!!;\u0003T\"I!Q\u0018\u0013\u0002\u0002\u0003\u0007!QW\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u00111T\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005%(Q\u001c\u0005\n\u0005{3\u0013\u0011!a\u0001\u0005kCqAa\u001c\t\u0001\u0004\u0011Y\u0006C\u0004\u0003r!\u0001\rAa\u0017\u0015\t\tU!Q\u001d\u0005\b\u0005OL\u0001\u0019AAa\u0003\u0005\u0019G\u0003\u0002B\u000b\u0005WDqAa\b\u000b\u0001\u0004\u0011\u0019#A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tE(1\u001f\t\u0007\u0003;\t9Ha\t\t\u0013\tU8\"!AA\u0002\tU\u0011a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011Y\u0010\u0005\u0003\u0003\"\nu\u0018\u0002\u0002B\u0000\u0005G\u0013aa\u00142kK\u000e$(!C\"fY2\u0014u.\u001e8e'\r9\u00131D\u0015\u0005O!\u0002\u0005L\u0001\u0006C_VtG-\u001a3SCf\u001c\u0012\u0002KA\u000e\u0007\u0017\u0011I\"a\n\u0011\u0007\t-q%\u0001\u0003cCN,WCAAa\u0003\u0015\u0011\u0017m]3!\u0003\r!\u0017N]\u000b\u0003\u0005+\tA\u0001Z5sAQ111DB\u000f\u0007?\u00012Aa\u0003)\u0011\u001d\u0019i!\fa\u0001\u0003\u0003Dqaa\u0005.\u0001\u0004\u0011)\u0002\u0006\u0004\u0004\u001c\r\r2Q\u0005\u0005\n\u0007\u001bq\u0003\u0013!a\u0001\u0003\u0003D\u0011ba\u0005/!\u0003\u0005\rA!\u0006\u0016\u0005\r%\"\u0006BAa\u0003k\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u00040)\"!QCA{)\u0011\u0011)la\r\t\u0013\tu6'!AA\u0002\u0005mE\u0003BAu\u0007oA\u0011B!06\u0003\u0003\u0005\rA!.\u0015\u0005\t}E\u0003BAu\u0007{A\u0011B!09\u0003\u0003\u0005\rA!.\u0003\u0007I\u000b\u0017pE\u0005A\u00037\u0019YA!\u0007\u0002(Q11QIB$\u0007\u0013\u00022Aa\u0003A\u0011\u001d\u0019i!\u0012a\u0001\u0003\u0003Dqaa\u0005F\u0001\u0004\u0011)\u0002\u0006\u0004\u0004F\r53q\n\u0005\n\u0007\u001b1\u0005\u0013!a\u0001\u0003\u0003D\u0011ba\u0005G!\u0003\u0005\rA!\u0006\u0015\t\tU61\u000b\u0005\n\u0005{[\u0015\u0011!a\u0001\u00037#B!!;\u0004X!I!QX'\u0002\u0002\u0003\u0007!Q\u0017\u000b\u0005\u0003S\u001cY\u0006C\u0005\u0003>B\u000b\t\u00111\u0001\u00036\nQ!+\u001a<feN,'+Y=\u0014\u0013a\u000bYba\u0003\u0003\u001a\u0005\u001dBCBB2\u0007K\u001a9\u0007E\u0002\u0003\faCqa!\u0004^\u0001\u0004\t\t\rC\u0004\u0004\u0014u\u0003\rA!\u0006\u0015\r\r\r41NB7\u0011%\u0019iA\u0018I\u0001\u0002\u0004\t\t\rC\u0005\u0004\u0014y\u0003\n\u00111\u0001\u0003\u0016Q!!QWB9\u0011%\u0011ilYA\u0001\u0002\u0004\tY\n\u0006\u0003\u0002j\u000eU\u0004\"\u0003B_K\u0006\u0005\t\u0019\u0001B[)\u0011\tIo!\u001f\t\u0013\tu\u0006.!AA\u0002\tU\u0016A\u0003\"pk:$W\r\u001a*bsB\u0019!1\u0002\u001e\u0014\u000bi\u001a\t)a\n\u0011\u0015\r\r5\u0011RAa\u0005+\u0019Y\"\u0004\u0002\u0004\u0006*!1qQA\u0010\u0003\u001d\u0011XO\u001c;j[\u0016LAaa#\u0004\u0006\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\u001c\u001a\u0015\u0005\ruDCBB\u000e\u0007#\u001b\u0019\nC\u0004\u0004\u000eu\u0002\r!!1\t\u000f\rMQ\b1\u0001\u0003\u0016Q!1qSBN!\u0019\ti\"a\u001e\u0004\u001aBA\u0011QDA_\u0003\u0003\u0014)\u0002C\u0005\u0003vz\n\t\u00111\u0001\u0004\u001c\u0005\u0019!+Y=\u0011\u0007\t-!kE\u0003S\u0007G\u000b9\u0003\u0005\u0006\u0004\u0004\u000e%\u0015\u0011\u0019B\u000b\u0007\u000b\"\"aa(\u0015\r\r\u00153\u0011VBV\u0011\u001d\u0019i!\u0016a\u0001\u0003\u0003Dqaa\u0005V\u0001\u0004\u0011)\u0002\u0006\u0003\u0004\u0018\u000e=\u0006\"\u0003B{-\u0006\u0005\t\u0019AB#\u0003)\u0011VM^3sg\u0016\u0014\u0016-\u001f\t\u0004\u0005\u0017Q7#\u00026\u00048\u0006\u001d\u0002CCBB\u0007\u0013\u000b\tM!\u0006\u0004dQ\u001111\u0017\u000b\u0007\u0007G\u001aila0\t\u000f\r5Q\u000e1\u0001\u0002B\"911C7A\u0002\tUA\u0003BBL\u0007\u0007D\u0011B!>o\u0003\u0003\u0005\raa\u0019\u0002\u000f\u0015\u00036+\u0013'P\u001dV\u00111\u0011Z\b\u0003\u0007\u0017\u0004\u0003\"Pn}?h?^xo\u0001\t\u000bB\u001b\u0016\nT(OA\u0005i1-\u001a7m\u0005>,h\u000eZ:OK^$\u0002ba5\u0004f\u000e=8\u0011 \u000b\u0005\u0007+\u001c\t\u000f\u0005\u0004\u0004X\u000eu71B\u0007\u0003\u00073TAaa7\u0003H\u00069Q.\u001e;bE2,\u0017\u0002BBp\u00073\u0014!\u0002T5ti\n+hMZ3s\u0011\u001d\u0019\u0019O\u001da\u0001\u00037\u000bA\"\u001b8dS\u0012,g\u000e^#eO\u0016Dqaa:s\u0001\u0004\u0019I/A\u0002iKR\u0004B!!\u001a\u0004l&!1Q^A4\u00055A\u0015\r\u001c4FI\u001e,G+\u00192mK\"91\u0011\u001f:A\u0002\rM\u0018!\u0002<feR\u001c\b\u0003CA\u000f\u0007k\fY*!1\n\t\r]\u0018q\u0004\u0002\n\rVt7\r^5p]FBq!a\u0013s\u0001\u0004\ty%\u0001\fdK2dW\t\u001f;f]RLe\u000e^3sg\u0016\u001cG/[8o)!\u0019y\u0010\"\u0004\u0005\u0010\u0011EAC\u0002C\u0001\t\u000f!Y\u0001\u0005\u0004\u0002\u001e\u0005]D1\u0001\t\u0005\t\u000b\t\tJ\u0004\u0003\u0002R\u00055\u0005b\u0002C\u0005g\u0002\u00071Q[\u0001\u0005G\u0016dG\u000eC\u0004\u0002LM\u0004\r!a\u0014\t\u000f\r\u001d8\u000f1\u0001\u0004j\"91\u0011_:A\u0002\rM\bbBBrg\u0002\u0007\u00111T\u0001\u000ea>d\u0017pZ8oC2\u001cU\r\u001c7\u0015\u0011\u0011]A1\u0004C\u000f\t?!B!!\u001e\u0005\u001a!911\u001d;A\u0002\u0005m\u0005bBBti\u0002\u00071\u0011\u001e\u0005\b\u0007c$\b\u0019ABz\u0011\u001d\tY\u0005\u001ea\u0001\u0003\u001f\u0002")
public class VoronoiDiagram
implements scala.Serializable {
    private final DelaunayTriangulation dt;
    private final Extent extent;
    private final CompleteIndexedPointSet pointSet;

    public static Option<Polygon> polygonalCell(HalfEdgeTable halfEdgeTable, Function1<Object, Coordinate> function1, Extent extent, int n) {
        return VoronoiDiagram$.MODULE$.polygonalCell(halfEdgeTable, function1, extent, n);
    }

    public static boolean apply$default$3() {
        return VoronoiDiagram$.MODULE$.apply$default$3();
    }

    public static VoronoiDiagram apply(Coordinate[] coordinateArray, Extent extent, boolean bl) {
        return VoronoiDiagram$.MODULE$.apply(coordinateArray, extent, bl);
    }

    public DelaunayTriangulation dt() {
        return this.dt;
    }

    public Extent extent() {
        return this.extent;
    }

    public CompleteIndexedPointSet pointSet() {
        return this.pointSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Polygon> voronoiCell(int i) {
        Option<Polygon> option2;
        if (this.dt().liveVertices().size() == 1) {
            if (!this.dt().liveVertices().apply((Object)BoxesRunTime.boxToInteger((int)i))) throw new IllegalArgumentException(new StringBuilder(49).append("Cannot build Voronoi cell for nonexistent vertex ").append(i).toString());
            option2 = new Option<Polygon>((Object)this.extent().toPolygon());
            return option2;
        } else {
            option2 = VoronoiDiagram$.MODULE$.polygonalCell(this.dt().halfEdgeTable(), (Function1<Object, Coordinate>)(Function1 & Serializable & scala.Serializable)x$8 -> VoronoiDiagram.$anonfun$voronoiCell$1(this, BoxesRunTime.unboxToInt((Object)x$8)), this.extent(), this.dt().halfEdgeTable().edgeIncidentTo(i));
        }
        return option2;
    }

    public Seq<Polygon> voronoiCells() {
        return (Seq)this.dt().liveVertices().toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$9 -> Option$.MODULE$.option2Iterable(this.voronoiCell(BoxesRunTime.unboxToInt((Object)x$9))), Seq$.MODULE$.canBuildFrom());
    }

    public Seq<Tuple2<Polygon, Coordinate>> voronoiCellsWithPoints() {
        return (Seq)this.dt().liveVertices().toSeq().flatMap((Function1 & Serializable & scala.Serializable)i -> VoronoiDiagram.$anonfun$voronoiCellsWithPoints$1(this, BoxesRunTime.unboxToInt((Object)i)), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ Coordinate $anonfun$voronoiCell$1(VoronoiDiagram $this, int x$8) {
        return $this.pointSet().getCoordinate(x$8);
    }

    public static final /* synthetic */ Iterable $anonfun$voronoiCellsWithPoints$1(VoronoiDiagram $this, int i) {
        Iterable iterable;
        Option<Polygon> option2 = $this.voronoiCell(i);
        if (None$.MODULE$.equals(option2)) {
            iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        } else if (option2 instanceof Some) {
            Some some = (Some)option2;
            Polygon poly = (Polygon)some.value();
            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)poly, (Object)$this.dt().pointSet().getCoordinate(i))));
        } else {
            throw new MatchError(option2);
        }
        return iterable;
    }

    public VoronoiDiagram(DelaunayTriangulation dt, Extent extent) {
        this.dt = dt;
        this.extent = extent;
        this.pointSet = dt.pointSet();
    }

    public static class BoundedRay
    implements CellBound,
    Product,
    scala.Serializable {
        private final Coordinate base;
        private final V2 dir;

        public Coordinate base() {
            return this.base;
        }

        public V2 dir() {
            return this.dir;
        }

        public BoundedRay copy(Coordinate base, V2 dir) {
            return new BoundedRay(base, dir);
        }

        public Coordinate copy$default$1() {
            return this.base();
        }

        public V2 copy$default$2() {
            return this.dir();
        }

        public String productPrefix() {
            return "BoundedRay";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.base();
                    break;
                }
                case 1: {
                    object = this.dir();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof BoundedRay;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof BoundedRay)) return false;
            boolean bl = true;
            if (!bl) return false;
            BoundedRay boundedRay = (BoundedRay)x$1;
            Coordinate coordinate = this.base();
            Coordinate coordinate2 = boundedRay.base();
            if (coordinate == null) {
                if (coordinate2 != null) {
                    return false;
                }
            } else if (!coordinate.equals(coordinate2)) return false;
            V2 v2 = this.dir();
            V2 v22 = boundedRay.dir();
            if (v2 == null) {
                if (v22 != null) {
                    return false;
                }
            } else if (!((Object)v2).equals(v22)) return false;
            if (!boundedRay.canEqual(this)) return false;
            return true;
        }

        public BoundedRay(Coordinate base, V2 dir) {
            this.base = base;
            this.dir = dir;
            Product.$init$((Product)this);
        }
    }

    public static interface CellBound {
    }

    public static class Ray
    implements CellBound,
    Product,
    scala.Serializable {
        private final Coordinate base;
        private final V2 dir;

        public Coordinate base() {
            return this.base;
        }

        public V2 dir() {
            return this.dir;
        }

        public Ray copy(Coordinate base, V2 dir) {
            return new Ray(base, dir);
        }

        public Coordinate copy$default$1() {
            return this.base();
        }

        public V2 copy$default$2() {
            return this.dir();
        }

        public String productPrefix() {
            return "Ray";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.base();
                    break;
                }
                case 1: {
                    object = this.dir();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Ray;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Ray)) return false;
            boolean bl = true;
            if (!bl) return false;
            Ray ray = (Ray)x$1;
            Coordinate coordinate = this.base();
            Coordinate coordinate2 = ray.base();
            if (coordinate == null) {
                if (coordinate2 != null) {
                    return false;
                }
            } else if (!coordinate.equals(coordinate2)) return false;
            V2 v2 = this.dir();
            V2 v22 = ray.dir();
            if (v2 == null) {
                if (v22 != null) {
                    return false;
                }
            } else if (!((Object)v2).equals(v22)) return false;
            if (!ray.canEqual(this)) return false;
            return true;
        }

        public Ray(Coordinate base, V2 dir) {
            this.base = base;
            this.dir = dir;
            Product.$init$((Product)this);
        }
    }

    public static class ReverseRay
    implements CellBound,
    Product,
    scala.Serializable {
        private final Coordinate base;
        private final V2 dir;

        public Coordinate base() {
            return this.base;
        }

        public V2 dir() {
            return this.dir;
        }

        public ReverseRay copy(Coordinate base, V2 dir) {
            return new ReverseRay(base, dir);
        }

        public Coordinate copy$default$1() {
            return this.base();
        }

        public V2 copy$default$2() {
            return this.dir();
        }

        public String productPrefix() {
            return "ReverseRay";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.base();
                    break;
                }
                case 1: {
                    object = this.dir();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReverseRay;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ReverseRay)) return false;
            boolean bl = true;
            if (!bl) return false;
            ReverseRay reverseRay = (ReverseRay)x$1;
            Coordinate coordinate = this.base();
            Coordinate coordinate2 = reverseRay.base();
            if (coordinate == null) {
                if (coordinate2 != null) {
                    return false;
                }
            } else if (!coordinate.equals(coordinate2)) return false;
            V2 v2 = this.dir();
            V2 v22 = reverseRay.dir();
            if (v2 == null) {
                if (v22 != null) {
                    return false;
                }
            } else if (!((Object)v2).equals(v22)) return false;
            if (!reverseRay.canEqual(this)) return false;
            return true;
        }

        public ReverseRay(Coordinate base, V2 dir) {
            this.base = base;
            this.dir = dir;
            Product.$init$((Product)this);
        }
    }

    public static class V2
    implements Product,
    scala.Serializable {
        private final RealVector v;

        public RealVector v() {
            return this.v;
        }

        public V2 $minus(V2 that) {
            return new V2(this.v().subtract(that.v()));
        }

        public V2 $plus(V2 that) {
            return new V2(this.v().add(that.v()));
        }

        public Coordinate $plus(Coordinate that) {
            return new Coordinate(that.x + this.x(), that.y + this.y());
        }

        public V2 $times(double s) {
            return new V2(this.v().mapMultiply(s));
        }

        public double dot(V2 that) {
            return this.v().dotProduct(that.v());
        }

        public double length() {
            return package$.MODULE$.sqrt(this.v().dotProduct(this.v()));
        }

        public V2 normalize() {
            double len2 = this.dot(this);
            return package$.MODULE$.abs(len2) > 1.0E-16 ? this.$times(1.0 / package$.MODULE$.sqrt(len2)) : VoronoiDiagram$V2$.MODULE$.apply(0.0, 0.0);
        }

        public double x() {
            return this.v().getEntry(0);
        }

        public double y() {
            return this.v().getEntry(1);
        }

        public String toString() {
            return new StringBuilder(3).append("(").append(this.x()).append(",").append(this.y()).append(")").toString();
        }

        public Coordinate toCoord() {
            return new Coordinate(this.x(), this.y());
        }

        public V2 rot90CCW() {
            return VoronoiDiagram$V2$.MODULE$.apply(-this.y(), this.x());
        }

        public V2 rot90CW() {
            return VoronoiDiagram$V2$.MODULE$.apply(this.y(), -this.x());
        }

        public V2 copy(RealVector v) {
            return new V2(v);
        }

        public RealVector copy$default$1() {
            return this.v();
        }

        public String productPrefix() {
            return "V2";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return this.v();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof V2;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof V2)) return false;
            boolean bl = true;
            if (!bl) return false;
            V2 v2 = (V2)x$1;
            RealVector realVector = this.v();
            RealVector realVector2 = v2.v();
            if (realVector == null) {
                if (realVector2 != null) {
                    return false;
                }
            } else if (!realVector.equals(realVector2)) return false;
            if (!v2.canEqual(this)) return false;
            return true;
        }

        public V2(RealVector v) {
            this.v = v;
            Product.$init$((Product)this);
        }
    }
}

