/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.compression;

import scala.Array$;
import scala.reflect.ClassTag$;

public final class YCbCrConverter$ {
    public static YCbCrConverter$ MODULE$;
    private final int[] Cr_R_LUT;
    private final int[] Cb_B_LUT;
    private final int[] Cr_G_LUT;
    private final int[] Cb_G_LUT;

    static {
        new YCbCrConverter$();
    }

    private final int SCALEBITS() {
        return 16;
    }

    private final int MAXJSAMPLE() {
        return 255;
    }

    private final int CENTERJSAMPLE() {
        return 128;
    }

    private final int ONE_HALF() {
        return 32768;
    }

    private final int[] Cr_R_LUT() {
        return this.Cr_R_LUT;
    }

    private final int[] Cb_B_LUT() {
        return this.Cb_B_LUT;
    }

    private final int[] Cr_G_LUT() {
        return this.Cr_G_LUT;
    }

    private final int[] Cb_G_LUT() {
        return this.Cb_G_LUT;
    }

    private void buildYCCtoRGBtable() {
        int i = 0;
        int x = -128;
        while (i <= 255) {
            this.Cr_R_LUT()[i] = (int)(91881.972 * (double)x + (double)32768) >> 16;
            this.Cb_B_LUT()[i] = (int)(116130.292 * (double)x + (double)32768) >> 16;
            this.Cr_G_LUT()[i] = -((int)(46802.37904 * (double)x));
            this.Cb_G_LUT()[i] = -((int)(22554.05904 * (double)x + (double)32768));
            ++i;
            ++x;
        }
    }

    public void convertYCbCr2RGB(byte[] yCbCr, byte[] rgb, double[] coefficients, double[] referenceBW, int offset) {
        double y = 0.0;
        double cb = 0.0;
        double cr = 0.0;
        if (referenceBW == null) {
            y = yCbCr[offset] & 0xFF;
            cb = (yCbCr[offset + 1] & 0xFF) - 128;
            cr = (yCbCr[offset + 2] & 0xFF) - 128;
        } else {
            y = ((double)(yCbCr[offset] & 0xFF) - referenceBW[0]) * 255.0 / (referenceBW[1] - referenceBW[0]);
            cb = ((double)(yCbCr[offset + 1] & 0xFF) - referenceBW[2]) * 127.0 / (referenceBW[3] - referenceBW[2]);
            cr = ((double)(yCbCr[offset + 2] & 0xFF) - referenceBW[4]) * 127.0 / (referenceBW[5] - referenceBW[4]);
        }
        double lumaRed = coefficients[0];
        double lumaGreen = coefficients[1];
        double lumaBlue = coefficients[2];
        int red = (int)Math.round(cr * (2.0 - 2.0 * lumaRed) + y);
        int blue = (int)Math.round(cb * (2.0 - 2.0 * lumaBlue) + y);
        int green = (int)Math.round((y - lumaRed * (double)red - lumaBlue * (double)blue) / lumaGreen);
        rgb[offset] = this.clamp(red);
        rgb[offset + 2] = this.clamp(blue);
        rgb[offset + 1] = this.clamp(green);
    }

    public void convertYCbCr2RGB(byte[] yCbCr, byte[] rgb, int offset) {
        int y = yCbCr[offset] & 0xFF;
        int cr = yCbCr[offset + 2] & 0xFF;
        int cb = yCbCr[offset + 1] & 0xFF;
        rgb[offset] = this.clamp(y + this.Cr_R_LUT()[cr]);
        rgb[offset + 1] = this.clamp(y + (this.Cb_G_LUT()[cb] + this.Cr_G_LUT()[cr] >> 16));
        rgb[offset + 2] = this.clamp(y + this.Cb_B_LUT()[cb]);
    }

    public byte clamp(int v) {
        return (byte)Math.max(0, Math.min(255, v));
    }

    private YCbCrConverter$() {
        MODULE$ = this;
        this.Cr_R_LUT = (int[])Array$.MODULE$.ofDim(256, ClassTag$.MODULE$.Int());
        this.Cb_B_LUT = (int[])Array$.MODULE$.ofDim(256, ClassTag$.MODULE$.Int());
        this.Cr_G_LUT = (int[])Array$.MODULE$.ofDim(256, ClassTag$.MODULE$.Int());
        this.Cb_G_LUT = (int[])Array$.MODULE$.ofDim(256, ClassTag$.MODULE$.Int());
        this.buildYCCtoRGBtable();
    }
}

