/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.reader;

import geotrellis.raster.CellGrid;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.Tile;
import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.GeoTiff;
import geotrellis.raster.io.geotiff.GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.GeoTiffMultibandTile$;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.GeoTiffTile$;
import geotrellis.raster.io.geotiff.MultibandGeoTiff;
import geotrellis.raster.io.geotiff.SinglebandGeoTiff;
import geotrellis.raster.io.geotiff.reader.GeoTiffInfo;
import geotrellis.raster.io.geotiff.reader.GeoTiffInfo$;
import geotrellis.raster.io.geotiff.reader.GeoTiffReader;
import geotrellis.util.ByteReader;
import geotrellis.util.ByteReader$;
import geotrellis.util.FileRangeReader$;
import geotrellis.util.Filesystem$;
import geotrellis.util.StreamingByteReader$;
import geotrellis.vector.Extent;
import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;

public final class GeoTiffReader$
implements scala.Serializable {
    public static GeoTiffReader$ MODULE$;
    private final GeoTiffReader<Tile> singlebandGeoTiffReader;
    private final GeoTiffReader<MultibandTile> multibandGeoTiffReader;

    static {
        new GeoTiffReader$();
    }

    public SinglebandGeoTiff readSingleband(String path) {
        return this.readSingleband(path, false);
    }

    public SinglebandGeoTiff readSingleband(String path, Extent e) {
        return this.readSingleband(path, (Option<Extent>)new Some((Object)e));
    }

    public SinglebandGeoTiff readSingleband(String path, Option<Extent> e) {
        SinglebandGeoTiff singlebandGeoTiff;
        Option<Extent> option2 = e;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Extent x = (Extent)some.value();
            singlebandGeoTiff = this.readSingleband(path, true).crop(x);
        } else if (None$.MODULE$.equals(option2)) {
            singlebandGeoTiff = this.readSingleband(path);
        } else {
            throw new MatchError(option2);
        }
        return singlebandGeoTiff;
    }

    public SinglebandGeoTiff readSingleband(String path, boolean streaming) {
        String ovrPath = new StringBuilder(4).append(path).append(".ovr").toString();
        boolean ovrPathExists = new File(ovrPath).isFile();
        return streaming ? this.readSingleband(StreamingByteReader$.MODULE$.apply(FileRangeReader$.MODULE$.apply(path)), streaming, true, (Option<ByteReader>)(ovrPathExists ? new Some((Object)StreamingByteReader$.MODULE$.apply(FileRangeReader$.MODULE$.apply(ovrPath))) : None$.MODULE$)) : this.readSingleband(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(Filesystem$.MODULE$.slurp(path, Filesystem$.MODULE$.slurp$default$2()))), streaming, true, (Option<ByteReader>)(ovrPathExists ? new Some((Object)ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(Filesystem$.MODULE$.slurp(ovrPath, Filesystem$.MODULE$.slurp$default$2())))) : None$.MODULE$));
    }

    public SinglebandGeoTiff readSingleband(byte[] bytes) {
        return this.readSingleband(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(bytes)), false);
    }

    public SinglebandGeoTiff readSingleband(byte[] bytes, boolean streaming) {
        return this.readSingleband(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(bytes)), streaming);
    }

    public SinglebandGeoTiff readSingleband(ByteReader byteReader) {
        return this.readSingleband(byteReader, false);
    }

    public SinglebandGeoTiff readSingleband(ByteReader byteReader, Extent e) {
        return this.readSingleband(byteReader, (Option<Extent>)new Some((Object)e));
    }

    public SinglebandGeoTiff readSingleband(ByteReader byteReader, Option<Extent> e) {
        SinglebandGeoTiff singlebandGeoTiff;
        Option<Extent> option2 = e;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Extent x = (Extent)some.value();
            singlebandGeoTiff = this.readSingleband(byteReader, true).crop(x);
        } else if (None$.MODULE$.equals(option2)) {
            singlebandGeoTiff = this.readSingleband(byteReader);
        } else {
            throw new MatchError(option2);
        }
        return singlebandGeoTiff;
    }

    public SinglebandGeoTiff readSingleband(ByteReader byteReader, boolean streaming) {
        return this.readSingleband(byteReader, streaming, true, (Option<ByteReader>)None$.MODULE$);
    }

    public SinglebandGeoTiff readSingleband(ByteReader byteReader, boolean streaming, boolean withOverviews, Option<ByteReader> byteReaderExternal) {
        GeoTiffInfo info = GeoTiffInfo$.MODULE$.read(byteReader, streaming, withOverviews, byteReaderExternal);
        GeoTiffTile geoTiffTile = this.geoTiffSinglebandTile(info);
        return GeoTiffReader$.getSingleband$1(geoTiffTile, info);
    }

    public GeoTiffTile geoTiffSinglebandTile(GeoTiffInfo info2) {
        return info2.bandCount() == 1 ? GeoTiffTile$.MODULE$.apply(info2.segmentBytes(), info2.decompressor(), info2.segmentLayout(), info2.compression(), info2.cellType(), (Option<BandType>)new Some((Object)info2.bandType()), (List<GeoTiffTile>)((List)info2.overviews().map((Function1 & Serializable & scala.Serializable)info -> MODULE$.geoTiffSinglebandTile((GeoTiffInfo)info), List$.MODULE$.canBuildFrom()))) : GeoTiffMultibandTile$.MODULE$.apply(info2.segmentBytes(), info2.decompressor(), info2.segmentLayout(), info2.compression(), info2.bandCount(), info2.cellType(), (Option<BandType>)new Some((Object)info2.bandType()), (List<GeoTiffMultibandTile>)((List)info2.overviews().map((Function1 & Serializable & scala.Serializable)info -> MODULE$.geoTiffMultibandTile((GeoTiffInfo)info), List$.MODULE$.canBuildFrom()))).band(0);
    }

    public MultibandGeoTiff readMultiband(String path) {
        return this.readMultiband(path, false);
    }

    public MultibandGeoTiff readMultiband(String path, Extent e) {
        return this.readMultiband(path, (Option<Extent>)new Some((Object)e));
    }

    public MultibandGeoTiff readMultiband(String path, Option<Extent> e) {
        MultibandGeoTiff multibandGeoTiff;
        Option<Extent> option2 = e;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Extent x = (Extent)some.value();
            multibandGeoTiff = this.readMultiband(path, true).crop(x);
        } else if (None$.MODULE$.equals(option2)) {
            multibandGeoTiff = this.readMultiband(path);
        } else {
            throw new MatchError(option2);
        }
        return multibandGeoTiff;
    }

    public MultibandGeoTiff readMultiband(String path, boolean streaming) {
        String ovrPath = new StringBuilder(4).append(path).append(".ovr").toString();
        boolean ovrPathExists = new File(ovrPath).isFile();
        return streaming ? this.readMultiband(StreamingByteReader$.MODULE$.apply(FileRangeReader$.MODULE$.apply(path)), streaming, true, (Option<ByteReader>)(ovrPathExists ? new Some((Object)StreamingByteReader$.MODULE$.apply(FileRangeReader$.MODULE$.apply(ovrPath))) : None$.MODULE$)) : this.readMultiband(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(Filesystem$.MODULE$.slurp(path, Filesystem$.MODULE$.slurp$default$2()))), streaming, true, (Option<ByteReader>)(ovrPathExists ? new Some((Object)ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(Filesystem$.MODULE$.slurp(ovrPath, Filesystem$.MODULE$.slurp$default$2())))) : None$.MODULE$));
    }

    public MultibandGeoTiff readMultiband(ByteReader byteReader, Extent e) {
        return this.readMultiband(byteReader, (Option<Extent>)new Some((Object)e));
    }

    public MultibandGeoTiff readMultiband(ByteReader byteReader, Option<Extent> e) {
        MultibandGeoTiff multibandGeoTiff;
        Option<Extent> option2 = e;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            Extent x = (Extent)some.value();
            multibandGeoTiff = this.readMultiband(byteReader, true).crop(x);
        } else if (None$.MODULE$.equals(option2)) {
            multibandGeoTiff = this.readMultiband(byteReader);
        } else {
            throw new MatchError(option2);
        }
        return multibandGeoTiff;
    }

    public MultibandGeoTiff readMultiband(byte[] bytes) {
        return this.readMultiband(bytes, false);
    }

    public MultibandGeoTiff readMultiband(byte[] bytes, boolean streaming) {
        return this.readMultiband(ByteReader$.MODULE$.byteBuffer2ByteReader(ByteBuffer.wrap(bytes)), streaming);
    }

    public MultibandGeoTiff readMultiband(ByteReader byteReader) {
        return this.readMultiband(byteReader, false);
    }

    public MultibandGeoTiff readMultiband(ByteReader byteReader, boolean streaming) {
        return this.readMultiband(byteReader, streaming, true, (Option<ByteReader>)None$.MODULE$);
    }

    public MultibandGeoTiff readMultiband(ByteReader byteReader, boolean streaming, boolean withOverviews, Option<ByteReader> byteReaderExternal) {
        GeoTiffInfo info = GeoTiffInfo$.MODULE$.read(byteReader, streaming, withOverviews, byteReaderExternal);
        GeoTiffMultibandTile geoTiffTile = this.geoTiffMultibandTile(info);
        return GeoTiffReader$.getMultiband$1(geoTiffTile, info);
    }

    public GeoTiffMultibandTile geoTiffMultibandTile(GeoTiffInfo info2) {
        return GeoTiffMultibandTile$.MODULE$.apply(info2.segmentBytes(), info2.decompressor(), info2.segmentLayout(), info2.compression(), info2.bandCount(), info2.cellType(), (Option<BandType>)new Some((Object)info2.bandType()), (List<GeoTiffMultibandTile>)((List)info2.overviews().map((Function1 & Serializable & scala.Serializable)info -> MODULE$.geoTiffMultibandTile((GeoTiffInfo)info), List$.MODULE$.canBuildFrom())));
    }

    public GeoTiffReader<Tile> singlebandGeoTiffReader() {
        return this.singlebandGeoTiffReader;
    }

    public GeoTiffReader<MultibandTile> multibandGeoTiffReader() {
        return this.multibandGeoTiffReader;
    }

    public <V extends CellGrid<Object>> GeoTiffReader<V> apply(GeoTiffReader<V> ev) {
        return ev;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final SinglebandGeoTiff getSingleband$1(GeoTiffTile geoTiffTile, GeoTiffInfo info) {
        return new SinglebandGeoTiff(geoTiffTile, info.extent(), info.crs(), info.tags(), info.options(), (List<GeoTiff<Tile>>)((List)info.overviews().map((Function1 & Serializable & scala.Serializable)i -> GeoTiffReader$.getSingleband$1(MODULE$.geoTiffSinglebandTile((GeoTiffInfo)i), i), List$.MODULE$.canBuildFrom())));
    }

    private static final MultibandGeoTiff getMultiband$1(GeoTiffMultibandTile geoTiffTile, GeoTiffInfo info) {
        return new MultibandGeoTiff(geoTiffTile, info.extent(), info.crs(), info.tags(), info.options(), (List<GeoTiff<MultibandTile>>)((List)info.overviews().map((Function1 & Serializable & scala.Serializable)i -> GeoTiffReader$.getMultiband$1(MODULE$.geoTiffMultibandTile((GeoTiffInfo)i), i), List$.MODULE$.canBuildFrom())));
    }

    private GeoTiffReader$() {
        MODULE$ = this;
        this.singlebandGeoTiffReader = new GeoTiffReader<Tile>(){

            public GeoTiff<Tile> read(byte[] bytes) {
                return GeoTiffReader.read$(this, bytes);
            }

            public GeoTiff<Tile> read(ByteReader byteReader, boolean streaming) {
                return GeoTiffReader$.MODULE$.readSingleband(byteReader, streaming);
            }
            {
                GeoTiffReader.$init$(this);
            }
        };
        this.multibandGeoTiffReader = new GeoTiffReader<MultibandTile>(){

            public GeoTiff<MultibandTile> read(byte[] bytes) {
                return GeoTiffReader.read$(this, bytes);
            }

            public GeoTiff<MultibandTile> read(ByteReader byteReader, boolean streaming) {
                return GeoTiffReader$.MODULE$.readMultiband(byteReader, streaming);
            }
            {
                GeoTiffReader.$init$(this);
            }
        };
    }
}

