/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.util;

import geotrellis.util.ByteReader;
import geotrellis.util.RangeReader;
import geotrellis.util.StreamingByteReader$;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import scala.Array$;
import scala.Predef$;
import scala.collection.immutable.NumericRange;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0014)\u00015B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!)\u0001\t\u0001C\u0001\u0003\"IQ\t\u0001a\u0001\u0002\u0004%IA\u0012\u0005\n\u001b\u0002\u0001\r\u00111A\u0005\n9C\u0011\u0002\u0016\u0001A\u0002\u0003\u0005\u000b\u0015B$\t\u0013U\u0003\u0001\u0019!a\u0001\n\u00131\u0006\"C0\u0001\u0001\u0004\u0005\r\u0011\"\u0003a\u0011%\u0011\u0007\u00011A\u0001B\u0003&q\u000bC\u0004d\u0001\u0001\u0007I\u0011\u00023\t\u000fA\u0004\u0001\u0019!C\u0005c\"11\u000f\u0001Q!\n\u0015Dq\u0001\u001e\u0001A\u0002\u0013%Q\u000fC\u0004w\u0001\u0001\u0007I\u0011B<\t\re\u0004\u0001\u0015)\u0003n\u0011\u001dQ\b\u00011A\u0005\nmD\u0001b \u0001A\u0002\u0013%\u0011\u0011\u0001\u0005\b\u0003\u000b\u0001\u0001\u0015)\u0003}\u0011\u001d\t9\u0001\u0001C\u0001\u0003\u0013Aq!a\u0002\u0001\t\u0003\tY\u0001C\u0004\u0002\u0012\u0001!\t!a\u0005\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0016!9\u0011\u0011\u0004\u0001\u0005\n\u0005m\u0001bBA\u0011\u0001\u0011%\u00111\u0005\u0005\b\u0003S\u0001A\u0011AA\u0016\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!a\r\u0001\t\u0003\t)\u0004C\u0004\u0002>\u0001!\t!a\u0010\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002J!9\u00111\n\u0001\u0005\u0002\u00055\u0003bBA+\u0001\u0011\u0005\u0011q\u000b\u0005\u0007\u0003?\u0002A\u0011A;\b\u000f\u0005\u0005\u0004\u0006#\u0001\u0002d\u00191q\u0005\u000bE\u0001\u0003KBa\u0001\u0011\u0012\u0005\u0002\u0005\u001d\u0004bBA5E\u0011\u0005\u00111\u000e\u0005\b\u0003S\u0012C\u0011AA8\u0011%\t)HII\u0001\n\u0003\t9HA\nTiJ,\u0017-\\5oO\nKH/\u001a*fC\u0012,'O\u0003\u0002*U\u0005!Q\u000f^5m\u0015\u0005Y\u0013AC4f_R\u0014X\r\u001c7jg\u000e\u00011c\u0001\u0001/iA\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t1\u0011I\\=SK\u001a\u0004\"!\u000e\u001c\u000e\u0003!J!a\u000e\u0015\u0003\u0015\tKH/\u001a*fC\u0012,'/A\u0006sC:<WMU3bI\u0016\u0014\bCA\u001b;\u0013\tY\u0004FA\u0006SC:<WMU3bI\u0016\u0014\u0018!C2ik:\\7+\u001b>f!\tyc(\u0003\u0002@a\t\u0019\u0011J\u001c;\u0002\rqJg.\u001b;?)\r\u00115\t\u0012\t\u0003k\u0001AQ\u0001O\u0002A\u0002eBq\u0001P\u0002\u0011\u0002\u0003\u0007Q(\u0001\u0006dQVt7NQ=uKN,\u0012a\u0012\t\u0004_!S\u0015BA%1\u0005\u0015\t%O]1z!\ty3*\u0003\u0002Ma\t!!)\u001f;f\u00039\u0019\u0007.\u001e8l\u0005f$Xm]0%KF$\"a\u0014*\u0011\u0005=\u0002\u0016BA)1\u0005\u0011)f.\u001b;\t\u000fM+\u0011\u0011!a\u0001\u000f\u0006\u0019\u0001\u0010J\u0019\u0002\u0017\rDWO\\6CsR,7\u000fI\u0001\fG\",hn\u001b\"vM\u001a,'/F\u0001X!\tAV,D\u0001Z\u0015\tQ6,A\u0002oS>T\u0011\u0001X\u0001\u0005U\u00064\u0018-\u0003\u0002_3\nQ!)\u001f;f\u0005V4g-\u001a:\u0002\u001f\rDWO\\6Ck\u001a4WM]0%KF$\"aT1\t\u000fMC\u0011\u0011!a\u0001/\u0006a1\r[;oW\n+hMZ3sA\u0005Q1\r[;oWJ\u000bgnZ3\u0016\u0003\u0015\u00042AZ6n\u001b\u00059'B\u00015j\u0003%IW.\\;uC\ndWM\u0003\u0002ka\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u00051<'\u0001\u0004(v[\u0016\u0014\u0018n\u0019*b]\u001e,\u0007CA\u0018o\u0013\ty\u0007G\u0001\u0003M_:<\u0017AD2ik:\\'+\u00198hK~#S-\u001d\u000b\u0003\u001fJDqaU\u0006\u0002\u0002\u0003\u0007Q-A\u0006dQVt7NU1oO\u0016\u0004\u0013\u0001\u00044jY\u0016\u0004vn]5uS>tW#A7\u0002!\u0019LG.\u001a)pg&$\u0018n\u001c8`I\u0015\fHCA(y\u0011\u001d\u0019f\"!AA\u00025\fQBZ5mKB{7/\u001b;j_:\u0004\u0013!\u00032zi\u0016|%\u000fZ3s+\u0005a\bC\u0001-~\u0013\tq\u0018LA\u0005CsR,wJ\u001d3fe\u0006i!-\u001f;f\u001fJ$WM]0%KF$2aTA\u0002\u0011\u001d\u0019\u0016#!AA\u0002q\f!BY=uK>\u0013H-\u001a:!\u0003!\u0001xn]5uS>tG#A7\u0015\u0007Q\ni\u0001\u0003\u0004\u0002\u0010Q\u0001\r!\\\u0001\f]\u0016<\bk\\:ji&|g.A\u0003pe\u0012,'\u000fF\u0001})\ry\u0015q\u0003\u0005\u0006uZ\u0001\r\u0001`\u0001\ne\u0016\fGm\u00115v].$2aTA\u000f\u0011\u0019\tyb\u0006a\u0001K\u0006Aa.Z<SC:<W-A\u0006f]N,(/Z\"ik:\\GcA\u001f\u0002&!1\u0011q\u0005\rA\u0002u\na\u0001\\3oORD\u0017\u0001C4fi\nKH/Z:\u0015\u0007\u001d\u000bi\u0003\u0003\u0004\u0002(e\u0001\r!P\u0001\u0004O\u0016$X#\u0001&\u0002\u000f\u001d,Go\u00115beV\u0011\u0011q\u0007\t\u0004_\u0005e\u0012bAA\u001ea\t!1\t[1s\u0003!9W\r^*i_J$XCAA!!\ry\u00131I\u0005\u0004\u0003\u000b\u0002$!B*i_J$\u0018AB4fi&sG/F\u0001>\u0003!9W\r\u001e$m_\u0006$XCAA(!\ry\u0013\u0011K\u0005\u0004\u0003'\u0002$!\u0002$m_\u0006$\u0018!C4fi\u0012{WO\u00197f+\t\tI\u0006E\u00020\u00037J1!!\u00181\u0005\u0019!u.\u001e2mK\u00069q-\u001a;M_:<\u0017aE*ue\u0016\fW.\u001b8h\u0005f$XMU3bI\u0016\u0014\bCA\u001b#'\t\u0011c\u0006\u0006\u0002\u0002d\u0005)\u0011\r\u001d9msR\u0019!)!\u001c\t\u000ba\"\u0003\u0019A\u001d\u0015\u000b\t\u000b\t(a\u001d\t\u000ba*\u0003\u0019A\u001d\t\u000bq*\u0003\u0019A\u001f\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tIHK\u0002>\u0003wZ#!! \u0011\t\u0005}\u0014\u0011R\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u000f\u0003\u0014AC1o]>$\u0018\r^5p]&!\u00111RAA\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class StreamingByteReader
implements ByteReader {
    private final RangeReader rangeReader;
    private final int chunkSize;
    private byte[] chunkBytes;
    private ByteBuffer chunkBuffer;
    private NumericRange<Object> chunkRange;
    private long filePosition;
    private ByteOrder byteOrder;

    public static int $lessinit$greater$default$2() {
        return StreamingByteReader$.MODULE$.$lessinit$greater$default$2();
    }

    public static StreamingByteReader apply(RangeReader rangeReader, int n) {
        return StreamingByteReader$.MODULE$.apply(rangeReader, n);
    }

    public static StreamingByteReader apply(RangeReader rangeReader) {
        return StreamingByteReader$.MODULE$.apply(rangeReader);
    }

    private byte[] chunkBytes() {
        return this.chunkBytes;
    }

    private void chunkBytes_$eq(byte[] x$1) {
        this.chunkBytes = x$1;
    }

    private ByteBuffer chunkBuffer() {
        return this.chunkBuffer;
    }

    private void chunkBuffer_$eq(ByteBuffer x$1) {
        this.chunkBuffer = x$1;
    }

    private NumericRange<Object> chunkRange() {
        return this.chunkRange;
    }

    private void chunkRange_$eq(NumericRange<Object> x$1) {
        this.chunkRange = x$1;
    }

    private long filePosition() {
        return this.filePosition;
    }

    private void filePosition_$eq(long x$1) {
        this.filePosition = x$1;
    }

    private ByteOrder byteOrder() {
        return this.byteOrder;
    }

    private void byteOrder_$eq(ByteOrder x$1) {
        this.byteOrder = x$1;
    }

    @Override
    public long position() {
        return this.filePosition();
    }

    @Override
    public ByteReader position(long newPosition) {
        this.filePosition_$eq(newPosition);
        return this;
    }

    @Override
    public ByteOrder order() {
        return this.byteOrder();
    }

    @Override
    public void order(ByteOrder byteOrder) {
        block0: {
            this.byteOrder_$eq(byteOrder);
            if (this.chunkBuffer() == null) break block0;
            this.chunkBuffer().order(byteOrder);
        }
    }

    private void readChunk(NumericRange<Object> newRange) {
        if (this.chunkBytes() != null && BoxesRunTime.unboxToLong((Object)newRange.start()) >= BoxesRunTime.unboxToLong((Object)this.chunkRange().start()) && BoxesRunTime.unboxToLong((Object)newRange.end()) <= BoxesRunTime.unboxToLong((Object)this.chunkRange().end())) {
            return;
        }
        if (this.chunkBytes() != null && BoxesRunTime.unboxToLong((Object)this.chunkRange().start()) <= BoxesRunTime.unboxToLong((Object)newRange.end()) && BoxesRunTime.unboxToLong((Object)newRange.start()) <= BoxesRunTime.unboxToLong((Object)this.chunkRange().end())) {
            NumericRange.Inclusive intersection = new RichLong(Predef$.MODULE$.longWrapper(package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)this.chunkRange().start()), BoxesRunTime.unboxToLong((Object)newRange.start())))).to((Object)BoxesRunTime.boxToLong((long)package$.MODULE$.min(BoxesRunTime.unboxToLong((Object)this.chunkRange().end()), BoxesRunTime.unboxToLong((Object)newRange.end()))));
            byte[] newChunkBytes = (byte[])Array$.MODULE$.ofDim(newRange.length(), ClassTag$.MODULE$.Byte());
            System.arraycopy(this.chunkBytes(), (int)(BoxesRunTime.unboxToLong((Object)intersection.start()) - BoxesRunTime.unboxToLong((Object)this.chunkRange().start())), newChunkBytes, (int)(BoxesRunTime.unboxToLong((Object)intersection.start()) - BoxesRunTime.unboxToLong((Object)newRange.start())), intersection.length());
            if (BoxesRunTime.unboxToLong((Object)newRange.start()) < BoxesRunTime.unboxToLong((Object)this.chunkRange().start())) {
                int length = (int)(BoxesRunTime.unboxToLong((Object)this.chunkRange().start()) - BoxesRunTime.unboxToLong((Object)newRange.start()));
                byte[] bytes = this.rangeReader.readRange(BoxesRunTime.unboxToLong((Object)newRange.start()), length);
                System.arraycopy(bytes, 0, newChunkBytes, 0, length);
            }
            if (BoxesRunTime.unboxToLong((Object)newRange.end()) > BoxesRunTime.unboxToLong((Object)this.chunkRange().end())) {
                int length = (int)(BoxesRunTime.unboxToLong((Object)newRange.end()) - BoxesRunTime.unboxToLong((Object)this.chunkRange().end()));
                byte[] bytes = this.rangeReader.readRange(BoxesRunTime.unboxToLong((Object)this.chunkRange().end()) + 1L, length);
                System.arraycopy(bytes, 0, newChunkBytes, newRange.length() - length, length);
            }
            this.chunkBytes_$eq(newChunkBytes);
            this.chunkRange_$eq(newRange);
            this.chunkBuffer_$eq(ByteBuffer.wrap(this.chunkBytes()).order(this.byteOrder()));
        } else {
            this.chunkBytes_$eq(this.rangeReader.readRange(BoxesRunTime.unboxToLong((Object)newRange.start()), newRange.length()));
            this.chunkRange_$eq(newRange);
            this.chunkBuffer_$eq(ByteBuffer.wrap(this.chunkBytes()).order(this.byteOrder()));
        }
    }

    private int ensureChunk(int length) {
        long trimmed = package$.MODULE$.min((long)length, this.rangeReader.totalLength() - this.filePosition());
        if (!this.chunkRange().contains((Object)BoxesRunTime.boxToLong((long)this.filePosition())) || !this.chunkRange().contains((Object)BoxesRunTime.boxToLong((long)(this.filePosition() + trimmed - 1L)))) {
            long len = package$.MODULE$.min((long)package$.MODULE$.max(length, this.chunkSize), this.rangeReader.totalLength() - this.filePosition());
            this.readChunk((NumericRange<Object>)new RichLong(Predef$.MODULE$.longWrapper(this.filePosition())).to((Object)BoxesRunTime.boxToLong((long)(this.filePosition() + len - 1L))));
        }
        Object object = this.filePosition() != BoxesRunTime.unboxToLong((Object)this.chunkRange().start()) + (long)this.chunkBuffer().position() ? this.chunkBuffer().position((int)(this.filePosition() - BoxesRunTime.unboxToLong((Object)this.chunkRange().start()))) : BoxedUnit.UNIT;
        return (int)trimmed;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getBytes(int length) {
        void var3_3;
        int actualLength = this.ensureChunk(length);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(actualLength, ClassTag$.MODULE$.Byte());
        this.chunkBuffer().get(bytes);
        this.filePosition_$eq(this.filePosition() + (long)actualLength);
        return var3_3;
    }

    @Override
    public byte get() {
        this.ensureChunk(1);
        this.filePosition_$eq(this.filePosition() + 1L);
        return this.chunkBuffer().get();
    }

    @Override
    public char getChar() {
        this.ensureChunk(2);
        this.filePosition_$eq(this.filePosition() + 2L);
        return this.chunkBuffer().getChar();
    }

    @Override
    public short getShort() {
        this.ensureChunk(2);
        this.filePosition_$eq(this.filePosition() + 2L);
        return this.chunkBuffer().getShort();
    }

    @Override
    public int getInt() {
        this.ensureChunk(4);
        this.filePosition_$eq(this.filePosition() + 4L);
        return this.chunkBuffer().getInt();
    }

    @Override
    public float getFloat() {
        this.ensureChunk(4);
        this.filePosition_$eq(this.filePosition() + 4L);
        return this.chunkBuffer().getFloat();
    }

    @Override
    public double getDouble() {
        this.ensureChunk(8);
        this.filePosition_$eq(this.filePosition() + 8L);
        return this.chunkBuffer().getDouble();
    }

    @Override
    public long getLong() {
        this.ensureChunk(8);
        this.filePosition_$eq(this.filePosition() + 8L);
        return this.chunkBuffer().getLong();
    }

    public StreamingByteReader(RangeReader rangeReader, int chunkSize) {
        this.rangeReader = rangeReader;
        this.chunkSize = chunkSize;
        this.chunkRange = new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)0L));
        this.filePosition = 0L;
        this.byteOrder = ByteOrder.BIG_ENDIAN;
    }
}

