/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector.triangulation;

import geotrellis.vector.LineString$;
import geotrellis.vector.MultiPolygon$;
import geotrellis.vector.Point$;
import geotrellis.vector.Polygon$;
import geotrellis.vector.io.wkt.WKT$;
import geotrellis.vector.mesh.CompleteIndexedPointSet;
import geotrellis.vector.mesh.HalfEdge;
import geotrellis.vector.mesh.HalfEdge$;
import geotrellis.vector.mesh.HalfEdgeTable;
import geotrellis.vector.triangulation.DelaunayStitcher;
import geotrellis.vector.triangulation.DelaunayTriangulation$;
import geotrellis.vector.triangulation.QuadricError$;
import geotrellis.vector.triangulation.TriangleMap;
import geotrellis.vector.triangulation.TriangleMap$;
import geotrellis.vector.triangulation.TriangulationPredicates;
import java.io.PrintWriter;
import java.io.Serializable;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.MapLike;
import scala.collection.mutable.PriorityQueue;
import scala.collection.mutable.PriorityQueue$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.io.StdIn$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\teg\u0001B\"E\u0001.C\u0001\u0002\u0017\u0001\u0003\u0016\u0004%\t!\u0017\u0005\tA\u0002\u0011\t\u0012)A\u00055\"A\u0011\r\u0001BK\u0002\u0013\u0005!\r\u0003\u0005g\u0001\tE\t\u0015!\u0003d\u0011!9\u0007A!f\u0001\n\u0003A\u0007\u0002\u00037\u0001\u0005#\u0005\u000b\u0011B5\t\u00115\u0004!Q3A\u0005\u00029D\u0001B\u001d\u0001\u0003\u0012\u0003\u0006Ia\u001c\u0005\u0006g\u0002!\t\u0001\u001e\u0005\bw\u0002\u0011\r\u0011\"\u0001}\u0011\u001d\t\t\u0001\u0001Q\u0001\nuD\u0011\"a\u0001\u0001\u0005\u0004%\t!!\u0002\t\u0011\u00055\u0001\u0001)A\u0005\u0003\u000fA\u0011\"a\u0004\u0001\u0005\u0004%I!!\u0005\t\u0011\u0005e\u0001\u0001)A\u0005\u0003'AA\"a\u0007\u0001!\u0003\u0005\u0019\u0011)A\u0005\u0003;A\u0011\"!\u000f\u0001\u0001\u0004%I!a\u000f\t\u0013\u0005u\u0002\u00011A\u0005\n\u0005}\u0002\u0002CA&\u0001\u0001\u0006K!a\t\t\u0011\u00055\u0003\u00011A\u0005\n9D\u0011\"a\u0014\u0001\u0001\u0004%I!!\u0015\t\u000f\u0005U\u0003\u0001)Q\u0005_\"I\u0011q\u000b\u0001A\u0002\u0013%\u0011\u0011\f\u0005\n\u00037\u0002\u0001\u0019!C\u0005\u0003;B\u0001\"!\u0019\u0001A\u0003&\u0011\u0011\u0006\u0005\b\u0003G\u0002A\u0011AA-\u0011\u001d\t)\u0007\u0001C\u0001\u0003wAq!a\u001a\u0001\t\u0003\tI\u0007C\u0004\u0002l\u0001!\t!!\u001c\t\u000f\u0005=\u0004\u0001\"\u0001\u0002n!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004bBA@\u0001\u0011\u0005\u0011\u0011\u0011\u0005\b\u0003[\u0003A\u0011BAX\u0011\u001d\tY\f\u0001C\u0005\u0003{Cq!a4\u0001\t\u0013\t\t\u000eC\u0004\u0002f\u0002!I!a:\t\u000f\u00055\b\u0001\"\u0003\u0002p\"9\u0011Q\u001f\u0001\u0005\n\u0005]\bbBA~\u0001\u0011%\u0011Q \u0005\b\u0005\u0007\u0001A\u0011\u0002B\u0003\u0011\u001d\u0011Y\u0002\u0001C\u0001\u0005;AqA!\t\u0001\t\u0003\ti\u0007C\u0004\u0003$\u0001!\tA!\n\t\u000f\t\u001d\u0002\u0001\"\u0001\u0003*!I!q\u0006\u0001\u0002\u0002\u0013\u0005!\u0011\u0007\u0005\n\u0005w\u0001\u0011\u0013!C\u0001\u0005{A\u0011Ba\u0015\u0001#\u0003%\tA!\u0016\t\u0013\te\u0003!%A\u0005\u0002\tm\u0003\"\u0003B0\u0001E\u0005I\u0011\u0001B1\u0011%\u0011)\u0007AA\u0001\n\u0003\u00129\u0007C\u0005\u0003t\u0001\t\t\u0011\"\u0001\u0002<!I!Q\u000f\u0001\u0002\u0002\u0013\u0005!q\u000f\u0005\n\u0005\u0003\u0003\u0011\u0011!C!\u0005\u0007C\u0011B!$\u0001\u0003\u0003%\tAa$\t\u0013\tM\u0005!!A\u0005B\u0005%\u0004\"\u0003BK\u0001\u0005\u0005I\u0011\tBL\u0011%\u0011I\nAA\u0001\n\u0003\u0012YjB\u0004\u0003 \u0012C\tA!)\u0007\r\r#\u0005\u0012\u0001BR\u0011\u0019\u00198\b\"\u0001\u0003&\"9!qU\u001e\u0005\u0002\t%\u0006\"\u0003BYwE\u0005I\u0011\u0001B.\u0011%\u0011\u0019lOI\u0001\n\u0003\u0011\t\u0007C\u0005\u0003(n\n\t\u0011\"!\u00036\"I!qX\u001e\u0002\u0002\u0013\u0005%\u0011\u0019\u0005\n\u0005\u001f\\\u0014\u0011!C\u0005\u0005#\u0014Q\u0003R3mCVt\u0017-\u001f+sS\u0006tw-\u001e7bi&|gN\u0003\u0002F\r\u0006iAO]5b]\u001e,H.\u0019;j_:T!a\u0012%\u0002\rY,7\r^8s\u0015\u0005I\u0015AC4f_R\u0014X\r\u001c7jg\u000e\u00011\u0003\u0002\u0001M%V\u0003\"!\u0014)\u000e\u00039S\u0011aT\u0001\u0006g\u000e\fG.Y\u0005\u0003#:\u0013a!\u00118z%\u00164\u0007CA'T\u0013\t!fJA\u0004Qe>$Wo\u0019;\u0011\u000553\u0016BA,O\u00051\u0019VM]5bY&T\u0018M\u00197f\u0003!\u0001x.\u001b8u'\u0016$X#\u0001.\u0011\u0005msV\"\u0001/\u000b\u0005u3\u0015\u0001B7fg\"L!a\u0018/\u0003/\r{W\u000e\u001d7fi\u0016Le\u000eZ3yK\u0012\u0004v.\u001b8u'\u0016$\u0018!\u00039pS:$8+\u001a;!\u00035A\u0017\r\u001c4FI\u001e,G+\u00192mKV\t1\r\u0005\u0002\\I&\u0011Q\r\u0018\u0002\u000e\u0011\u0006dg-\u00123hKR\u000b'\r\\3\u0002\u001d!\fGNZ#eO\u0016$\u0016M\u00197fA\u0005IAo\u001c7fe\u0006t7-Z\u000b\u0002SB\u0011QJ[\u0005\u0003W:\u0013a\u0001R8vE2,\u0017A\u0003;pY\u0016\u0014\u0018M\\2fA\u0005)A-\u001a2vOV\tq\u000e\u0005\u0002Na&\u0011\u0011O\u0014\u0002\b\u0005>|G.Z1o\u0003\u0019!WMY;hA\u00051A(\u001b8jiz\"R!^<ysj\u0004\"A\u001e\u0001\u000e\u0003\u0011CQ\u0001W\u0005A\u0002iCQ!Y\u0005A\u0002\rDQaZ\u0005A\u0002%DQ!\\\u0005A\u0002=\f1\u0002\u001e:jC:<G.Z'baV\tQ\u0010\u0005\u0002w}&\u0011q\u0010\u0012\u0002\f)JL\u0017M\\4mK6\u000b\u0007/\u0001\u0007ue&\fgn\u001a7f\u001b\u0006\u0004\b%\u0001\u0006qe\u0016$\u0017nY1uKN,\"!a\u0002\u0011\u0007Y\fI!C\u0002\u0002\f\u0011\u0013q\u0003\u0016:jC:<W\u000f\\1uS>t\u0007K]3eS\u000e\fG/Z:\u0002\u0017A\u0014X\rZ5dCR,7\u000fI\u0001\tgRLGo\u00195feV\u0011\u00111\u0003\t\u0004m\u0006U\u0011bAA\f\t\n\u0001B)\u001a7bk:\f\u0017p\u0015;ji\u000eDWM]\u0001\ngRLGo\u00195fe\u0002\n1\u0001\u001f\u00139!!i\u0015qDA\u0012_\u0006%\u0012bAA\u0011\u001d\n1A+\u001e9mKN\u00022!TA\u0013\u0013\r\t9C\u0014\u0002\u0004\u0013:$\bCBA\u0016\u0003k\t\u0019#\u0004\u0002\u0002.)!\u0011qFA\u0019\u0003\u001diW\u000f^1cY\u0016T1!a\rO\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003o\tiCA\u0002TKR\f\u0011b\u00182pk:$\u0017M]=\u0016\u0005\u0005\r\u0012!D0c_VtG-\u0019:z?\u0012*\u0017\u000f\u0006\u0003\u0002B\u0005\u001d\u0003cA'\u0002D%\u0019\u0011Q\t(\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003\u0013\u0012\u0012\u0011!a\u0001\u0003G\t1\u0001\u001f\u00132\u0003)y&m\\;oI\u0006\u0014\u0018\u0010I\u0001\n?&\u001cH*\u001b8fCJ\fQbX5t\u0019&tW-\u0019:`I\u0015\fH\u0003BA!\u0003'B\u0001\"!\u0013\u0016\u0003\u0003\u0005\ra\\\u0001\u000b?&\u001cH*\u001b8fCJ\u0004\u0013!D0mSZ,g+\u001a:uS\u000e,7/\u0006\u0002\u0002*\u0005\tr\f\\5wKZ+'\u000f^5dKN|F%Z9\u0015\t\u0005\u0005\u0013q\f\u0005\n\u0003\u0013B\u0012\u0011!a\u0001\u0003S\tab\u00187jm\u00164VM\u001d;jG\u0016\u001c\b%\u0001\u0007mSZ,g+\u001a:uS\u000e,7/A\u0006ok64VM\u001d;jG\u0016\u001c\u0018\u0001\u00032pk:$\u0017M]=\u0015\u0005\u0005\r\u0012\u0001C5t\u0019&tW-\u0019:\u0015\u0003=\f!\"[:V]\u001a|G\u000eZ3e)\u001dy\u00171OA<\u0003wBq!!\u001e \u0001\u0004\t\u0019#A\u0003c_VtG\rC\u0004\u0002z}\u0001\r!a\t\u0002\u00051|\u0007bBA??\u0001\u0007\u00111E\u0001\u0003Q&\f\u0001b\u001e:ji\u0016<6\n\u0016\u000b\u0005\u0003\u0007\u000b\u0019\n\u0005\u0003\u0002\u0006\u0006=UBAAD\u0015\u0011\tI)a#\u0002\u0005%|'BAAG\u0003\u0011Q\u0017M^1\n\t\u0005E\u0015q\u0011\u0002\f!JLg\u000e^,sSR,'\u000fC\u0004\u0002\u0016\u0002\u0002\r!a&\u0002\u000f]\\GOR5mKB!\u0011\u0011TAT\u001d\u0011\tY*a)\u0011\u0007\u0005ue*\u0004\u0002\u0002 *\u0019\u0011\u0011\u0015&\u0002\rq\u0012xn\u001c;?\u0013\r\t)KT\u0001\u0007!J,G-\u001a4\n\t\u0005%\u00161\u0016\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005\u0015f*A\u0005i_2,'i\\;oIR!\u0011\u0011WA\\!\u001dY\u00161WA\u0012\u0003GI1!!.]\u0005!A\u0015\r\u001c4FI\u001e,\u0007bBA]C\u0001\u0007\u00111E\u0001\u0003m&\fq\u0002\u001e:jC:<W\u000f\\1uK\"{G.\u001a\u000b\u0007\u0003\u0003\ny,a1\t\u000f\u0005\u0005'\u00051\u0001\u00022\u0006)\u0011N\u001c8fe\"9\u0011Q\u0019\u0012A\u0002\u0005\u001d\u0017\u0001\u0002;sSN\u0004\u0002\"a\u000b\u0002J\u00065\u0017\u0011W\u0005\u0005\u0003\u0017\fiCA\u0002NCB\u0004\u0012\"TA\u0010\u0003G\t\u0019#a\t\u0002\u0015\u0005dGnU1uSN4\u0017\u0010F\u0004p\u0003'\f9.a7\t\u000f\u0005U7\u00051\u0001\u00022\u0006\t\u0011\rC\u0004\u0002Z\u000e\u0002\r!!-\u0002\u0003\tDq!!8$\u0001\u0004\ty.A\u0001g!\u0019i\u0015\u0011]AY_&\u0019\u00111\u001d(\u0003\u0013\u0019+hn\u0019;j_:\f\u0014\u0001\u00027j].$b!!-\u0002j\u0006-\bbBAkI\u0001\u0007\u0011\u0011\u0017\u0005\b\u00033$\u0003\u0019AAY\u0003i\u0011X\r\u001e:jC:<W\u000f\\1uK\n{WO\u001c3bef\u0004v.\u001b8u)\u0011\t\t0a=\u0011\u00135\u000by\"!-\u0002$\u0005\u001d\u0007bBA]K\u0001\u0007\u00111E\u0001\u001be\u0016$(/[1oOVd\u0017\r^3J]R,'/[8s!>Lg\u000e\u001e\u000b\u0005\u0003\u000f\fI\u0010C\u0004\u0002:\u001a\u0002\r!a\t\u0002\u001d\u0011,7m\\;qY\u00164VM\u001d;fqR!\u0011q B\u0001!!\tY#!3\u0002$\u0005\r\u0002bBA]O\u0001\u0007\u00111E\u0001\u0014e\u0016lwN^3WKJ$X\r_!oI\u001aKG\u000e\u001c\u000b\t\u0005\u000f\u0011iAa\u0004\u0003\u0012A1\u00111\u0006B\u0005\u0003GIAAa\u0003\u0002.\tQA*[:u\u0005V4g-\u001a:\t\u000f\u0005e\u0006\u00061\u0001\u0002$!9\u0011Q\u0019\u0015A\u0002\u0005\u001d\u0007b\u0002B\nQ\u0001\u0007!QC\u0001\u0004E:$\u0007#B'\u0003\u0018\u0005\r\u0012b\u0001B\r\u001d\n1q\n\u001d;j_:\f1\u0002Z3mKR,\u0007k\\5oiR!\u0011\u0011\tB\u0010\u0011\u001d\tI,\u000ba\u0001\u0003G\t1\"[:NKNDg+\u00197jI\u0006Aa.\u0019<jO\u0006$X\r\u0006\u0002\u0002B\u0005AA-Z2j[\u0006$X\r\u0006\u0003\u0002B\t-\u0002b\u0002B\u0017Y\u0001\u0007\u00111E\u0001\b]J+Wn\u001c<f\u0003\u0011\u0019w\u000e]=\u0015\u0013U\u0014\u0019D!\u000e\u00038\te\u0002b\u0002-.!\u0003\u0005\rA\u0017\u0005\bC6\u0002\n\u00111\u0001d\u0011\u001d9W\u0006%AA\u0002%Dq!\\\u0017\u0011\u0002\u0003\u0007q.\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t}\"f\u0001.\u0003B-\u0012!1\t\t\u0005\u0005\u000b\u0012y%\u0004\u0002\u0003H)!!\u0011\nB&\u0003%)hn\u00195fG.,GMC\u0002\u0003N9\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u0011\tFa\u0012\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\t]#fA2\u0003B\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001aTC\u0001B/U\rI'\u0011I\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011\u0019GK\u0002p\u0005\u0003\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B5!\u0011\u0011YG!\u001d\u000e\u0005\t5$\u0002\u0002B8\u0003\u0017\u000bA\u0001\\1oO&!\u0011\u0011\u0016B7\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BA!\u001f\u0003\u0000A\u0019QJa\u001f\n\u0007\tudJA\u0002B]fD\u0011\"!\u00135\u0003\u0003\u0005\r!a\t\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\"\u0011\r\t\u001d%\u0011\u0012B=\u001b\t\t\t$\u0003\u0003\u0003\f\u0006E\"\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2a\u001cBI\u0011%\tIENA\u0001\u0002\u0004\u0011I(\u0001\u0005iCND7i\u001c3f\u0003!!xn\u0015;sS:<GC\u0001B5\u0003\u0019)\u0017/^1mgR\u0019qN!(\t\u0013\u0005%\u0013(!AA\u0002\te\u0014!\u0006#fY\u0006,h.Y=Ue&\fgnZ;mCRLwN\u001c\t\u0003mn\u001a2a\u000f'V)\t\u0011\t+A\u0003baBd\u0017\u0010F\u0004v\u0005W\u0013iKa,\t\u000bak\u0004\u0019\u0001.\t\u000f\u001dl\u0004\u0013!a\u0001S\"9Q.\u0010I\u0001\u0002\u0004y\u0017aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001f\u0005\u0004\b\u000f\\=%I\u00164\u0017-\u001e7uIM\"\u0012\"\u001eB\\\u0005s\u0013YL!0\t\u000ba\u0003\u0005\u0019\u0001.\t\u000b\u0005\u0004\u0005\u0019A2\t\u000b\u001d\u0004\u0005\u0019A5\t\u000b5\u0004\u0005\u0019A8\u0002\u000fUt\u0017\r\u001d9msR!!1\u0019Bf!\u0015i%q\u0003Bc!\u001di%q\u0019.dS>L1A!3O\u0005\u0019!V\u000f\u001d7fi!A!QZ!\u0002\u0002\u0003\u0007Q/A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!1\u001b\t\u0005\u0005W\u0012).\u0003\u0003\u0003X\n5$AB(cU\u0016\u001cG\u000f")
public class DelaunayTriangulation
implements Product,
scala.Serializable {
    private final CompleteIndexedPointSet pointSet;
    private final HalfEdgeTable halfEdgeTable;
    private final double tolerance;
    private final boolean debug;
    private final TriangleMap triangleMap;
    private final TriangulationPredicates predicates;
    private final DelaunayStitcher stitcher;
    private final /* synthetic */ Tuple3 x$8;
    private int _boundary;
    private boolean _isLinear;
    private Set<Object> _liveVertices;

    public static Option<Tuple4<CompleteIndexedPointSet, HalfEdgeTable, Object, Object>> unapply(DelaunayTriangulation delaunayTriangulation) {
        return DelaunayTriangulation$.MODULE$.unapply(delaunayTriangulation);
    }

    public static DelaunayTriangulation apply(CompleteIndexedPointSet completeIndexedPointSet, HalfEdgeTable halfEdgeTable, double d, boolean bl) {
        return DelaunayTriangulation$.MODULE$.apply(completeIndexedPointSet, halfEdgeTable, d, bl);
    }

    public static boolean apply$default$3() {
        return DelaunayTriangulation$.MODULE$.apply$default$3();
    }

    public static double apply$default$2() {
        return DelaunayTriangulation$.MODULE$.apply$default$2();
    }

    public static DelaunayTriangulation apply(CompleteIndexedPointSet completeIndexedPointSet, double d, boolean bl) {
        return DelaunayTriangulation$.MODULE$.apply(completeIndexedPointSet, d, bl);
    }

    public CompleteIndexedPointSet pointSet() {
        return this.pointSet;
    }

    public HalfEdgeTable halfEdgeTable() {
        return this.halfEdgeTable;
    }

    public double tolerance() {
        return this.tolerance;
    }

    public boolean debug() {
        return this.debug;
    }

    public TriangleMap triangleMap() {
        return this.triangleMap;
    }

    public TriangulationPredicates predicates() {
        return this.predicates;
    }

    private DelaunayStitcher stitcher() {
        return this.stitcher;
    }

    private int _boundary() {
        return this._boundary;
    }

    private void _boundary_$eq(int x$1) {
        this._boundary = x$1;
    }

    private boolean _isLinear() {
        return this._isLinear;
    }

    private void _isLinear_$eq(boolean x$1) {
        this._isLinear = x$1;
    }

    private Set<Object> _liveVertices() {
        return this._liveVertices;
    }

    private void _liveVertices_$eq(Set<Object> x$1) {
        this._liveVertices = x$1;
    }

    public Set<Object> liveVertices() {
        return this._liveVertices();
    }

    public int numVertices() {
        return this.liveVertices().size();
    }

    public int boundary() {
        return this._boundary();
    }

    public boolean isLinear() {
        return this._isLinear();
    }

    public boolean isUnfolded() {
        Set bounds = Set$.MODULE$.empty();
        if (this.liveVertices().size() < 2) {
            return true;
        }
        int e = this.boundary();
        do {
            bounds.$plus$eq((Object)BoxesRunTime.boxToInteger((int)e));
            e = this.halfEdgeTable().getNext(e);
        } while (e != this.boundary());
        return this.triangleMap().getTriangles().forall((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DelaunayTriangulation.$anonfun$isUnfolded$1(this, bounds, x0$1)));
    }

    public boolean isUnfolded(int bound, int lo, int hi) {
        Set bounds = Set$.MODULE$.empty();
        int e = bound;
        do {
            bounds.$plus$eq((Object)BoxesRunTime.boxToInteger((int)e));
            e = this.halfEdgeTable().getNext(e);
        } while (e != bound);
        return ((IterableLike)this.triangleMap().getTriangles().filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DelaunayTriangulation.$anonfun$isUnfolded$2(lo, hi, x0$1)))).forall((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)DelaunayTriangulation.$anonfun$isUnfolded$3(this, bounds, x0$2)));
    }

    public PrintWriter writeWKT(String wktFile) {
        Function1 & Serializable & scala.Serializable indexToCoord = (Function1 & Serializable & scala.Serializable)x$9 -> DelaunayTriangulation.$anonfun$writeWKT$1(this, BoxesRunTime.unboxToInt((Object)x$9));
        MultiPolygon mp = MultiPolygon$.MODULE$.apply((Traversable<Polygon>)((Traversable)this.triangleMap().getTriangles().keys().toSeq().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple3 tuple32 = x0$1;
            if (tuple32 == null) {
                throw new MatchError((Object)tuple32);
            }
            int i = BoxesRunTime.unboxToInt((Object)tuple32._1());
            int j = BoxesRunTime.unboxToInt((Object)tuple32._2());
            int k = BoxesRunTime.unboxToInt((Object)tuple32._3());
            Polygon polygon = Polygon$.MODULE$.apply((Seq<Coordinate>)Predef$.MODULE$.wrapRefArray((Object[])new Coordinate[]{(Coordinate)indexToCoord.apply((Object)BoxesRunTime.boxToInteger((int)i)), (Coordinate)indexToCoord.apply((Object)BoxesRunTime.boxToInteger((int)j)), (Coordinate)indexToCoord.apply((Object)BoxesRunTime.boxToInteger((int)k)), (Coordinate)indexToCoord.apply((Object)BoxesRunTime.boxToInteger((int)i))}), Predef.DummyImplicit$.MODULE$.dummyImplicit(), Predef.DummyImplicit$.MODULE$.dummyImplicit());
            return polygon;
        }, Seq$.MODULE$.canBuildFrom())));
        String wktString = WKT$.MODULE$.write((Geometry)mp);
        return new PrintWriter(null, wktFile, wktString){
            {
                this.write(wktString$1);
                this.close();
            }
        };
    }

    private HalfEdge<Object, Object> holeBound(int vi) {
        int e0 = this.halfEdgeTable().getFlip(this.halfEdgeTable().edgeIncidentTo(vi));
        HalfEdge b0 = HalfEdge$.MODULE$.apply(BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getDest(this.halfEdgeTable().rotCCWSrc(e0))), BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getDest(e0)));
        b0.face_$eq(new Some((Object)BoxesRunTime.boxToInteger((int)this.halfEdgeTable().rotCWDest(e0))));
        HalfEdge last = b0;
        int e = this.halfEdgeTable().rotCWSrc(e0);
        do {
            HalfEdge b = HalfEdge$.MODULE$.apply(BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getDest(this.halfEdgeTable().rotCCWSrc(e))), BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getDest(e)));
            b.face_$eq(new Some((Object)BoxesRunTime.boxToInteger((int)this.halfEdgeTable().rotCWDest(e))));
            last.next_$eq(b);
            b.flip().next_$eq(last.flip());
            last = b;
            e = this.halfEdgeTable().rotCWSrc(e);
        } while (e != e0);
        last.next_$eq(b0);
        b0.flip().next_$eq(last.flip());
        return b0.flip();
    }

    private void triangulateHole(HalfEdge<Object, Object> inner, Map<Tuple3<Object, Object, Object>, HalfEdge<Object, Object>> tris) {
        HalfEdge<Object, Object> halfEdge;
        HalfEdge<Object, Object> halfEdge2;
        ListBuffer bps = (ListBuffer)ListBuffer$.MODULE$.empty();
        bps.$plus$eq((Object)Point$.MODULE$.apply(this.pointSet().getCoordinate(BoxesRunTime.unboxToInt((Object)inner.src()))));
        int n = 0;
        HalfEdge<Object, Object> e = inner;
        do {
            ++n;
            bps.$plus$eq((Object)Point$.MODULE$.apply(this.pointSet().getCoordinate(BoxesRunTime.unboxToInt((Object)e.vert()))));
            halfEdge2 = e = e.next();
            halfEdge = inner;
        } while (halfEdge2 != null ? !halfEdge2.equals(halfEdge) : halfEdge != null);
        if (n == 3) {
            tris.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TriangleMap$.MODULE$.regularizeIndex(BoxesRunTime.unboxToInt((Object)inner.src()), BoxesRunTime.unboxToInt((Object)inner.vert()), BoxesRunTime.unboxToInt((Object)inner.next().vert()))), inner));
            return;
        }
        HalfEdge<Object, Object> best = inner.next();
        while (!this.predicates().isCCW(BoxesRunTime.unboxToInt((Object)inner.src()), BoxesRunTime.unboxToInt((Object)inner.vert()), BoxesRunTime.unboxToInt((Object)best.vert()))) {
            best = best.next();
        }
        e = best.next();
        while (BoxesRunTime.unboxToInt((Object)e.vert()) != BoxesRunTime.unboxToInt((Object)inner.src()) && !this.predicates().isCCW(BoxesRunTime.unboxToInt((Object)inner.src()), BoxesRunTime.unboxToInt((Object)inner.vert()), BoxesRunTime.unboxToInt((Object)e.vert()))) {
            e = e.next();
        }
        while (BoxesRunTime.unboxToInt((Object)e.vert()) != BoxesRunTime.unboxToInt((Object)inner.src())) {
            if (this.predicates().inCircle(BoxesRunTime.unboxToInt((Object)inner.src()), BoxesRunTime.unboxToInt((Object)inner.vert()), BoxesRunTime.unboxToInt((Object)best.vert()), BoxesRunTime.unboxToInt((Object)e.vert()))) {
                best = e;
                while (!this.predicates().isCCW(BoxesRunTime.unboxToInt((Object)inner.src()), BoxesRunTime.unboxToInt((Object)inner.vert()), BoxesRunTime.unboxToInt((Object)best.vert()))) {
                    best = best.next();
                }
            }
            e = e.next();
            while (BoxesRunTime.unboxToInt((Object)e.vert()) != BoxesRunTime.unboxToInt((Object)inner.src()) && !this.predicates().isCCW(BoxesRunTime.unboxToInt((Object)inner.src()), BoxesRunTime.unboxToInt((Object)inner.vert()), BoxesRunTime.unboxToInt((Object)e.vert()))) {
                e = e.next();
            }
        }
        HalfEdge<Object, Object> halfEdge3 = best;
        HalfEdge<Object, Object> halfEdge4 = inner.next();
        if (halfEdge3 == null ? halfEdge4 != null : !halfEdge3.equals(halfEdge4)) {
            HalfEdge<Object, Object> te = HalfEdge$.MODULE$.apply(inner.vert(), best.vert());
            te.next_$eq(best.next());
            te.flip().next_$eq(inner.next());
            inner.next_$eq(te);
            best.next_$eq(te.flip());
            best = te;
            this.triangulateHole(te.flip(), tris);
        }
        if (BoxesRunTime.unboxToInt((Object)best.vert()) != BoxesRunTime.unboxToInt((Object)inner.prev().src())) {
            HalfEdge<Object, Object> te = HalfEdge$.MODULE$.apply(best.vert(), inner.src());
            te.next_$eq(inner);
            te.flip().next_$eq(best.next());
            inner.prev().next_$eq(te.flip());
            best.next_$eq(te);
            this.triangulateHole(te.flip(), tris);
        }
        tris.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(TriangleMap$.MODULE$.regularizeIndex(BoxesRunTime.unboxToInt((Object)inner.src()), BoxesRunTime.unboxToInt((Object)inner.vert()), BoxesRunTime.unboxToInt((Object)inner.next().vert()))), inner));
    }

    private boolean allSatisfy(HalfEdge<Object, Object> a, HalfEdge<Object, Object> b, Function1<HalfEdge<Object, Object>, Object> f) {
        HalfEdge<Object, Object> halfEdge;
        HalfEdge<Object, Object> halfEdge2;
        HalfEdge<Object, Object> e = a;
        boolean result = true;
        do {
            result = result && BoxesRunTime.unboxToBoolean((Object)f.apply(e));
            e = e.next();
            if (!result) break;
            halfEdge2 = e;
            halfEdge = b;
        } while (halfEdge2 == null ? halfEdge != null : !halfEdge2.equals(halfEdge));
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private HalfEdge<Object, Object> link(HalfEdge<Object, Object> a, HalfEdge<Object, Object> b) {
        void var3_3;
        HalfEdge<Object, Object> result = HalfEdge$.MODULE$.apply(a.src(), b.vert());
        result.flip().next_$eq(a);
        result.next_$eq(b.next());
        a.prev().next_$eq(result);
        b.next_$eq(result.flip());
        return var3_3;
    }

    private Tuple3<HalfEdge<Object, Object>, Object, Map<Tuple3<Object, Object, Object>, HalfEdge<Object, Object>>> retriangulateBoundaryPoint(int vi) {
        HalfEdge first2;
        Function1 & Serializable & scala.Serializable c2p = (Function1 & Serializable & scala.Serializable)i -> Point$.MODULE$.apply(this.pointSet().getCoordinate(BoxesRunTime.unboxToInt((Object)i)));
        Map tris = Map$.MODULE$.empty();
        int e = this.halfEdgeTable().getFlip(this.halfEdgeTable().edgeIncidentTo(vi));
        while (this.halfEdgeTable().getDest(this.halfEdgeTable().getNext(this.halfEdgeTable().rotCWSrc(e))) == this.halfEdgeTable().getDest(e)) {
            e = this.halfEdgeTable().rotCWSrc(e);
        }
        int end = this.halfEdgeTable().getDest(this.halfEdgeTable().rotCWSrc(e));
        e = this.halfEdgeTable().getNext(e);
        HalfEdge last = first2 = HalfEdge$.MODULE$.apply(BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getSrc(e)), BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getDest(e)));
        last.flip().face_$eq(new Some((Object)BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getFlip(e))));
        ListBuffer bps = (ListBuffer)ListBuffer$.MODULE$.empty();
        bps.$plus$eq(c2p.apply((Object)first2.src()));
        bps.$plus$eq(c2p.apply((Object)first2.vert()));
        if (this.halfEdgeTable().getDest(e) == end) {
            return new Tuple3(first2, (Object)BoxesRunTime.boxToInteger((int)end), (Object)tris);
        }
        while (this.halfEdgeTable().getDest(e) != end) {
            e = this.halfEdgeTable().getNext(this.halfEdgeTable().getFlip(this.halfEdgeTable().getNext(e)));
            HalfEdge b = HalfEdge$.MODULE$.apply(BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getSrc(e)), BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getDest(e)));
            b.flip().face_$eq(new Some((Object)BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getFlip(e))));
            b.flip().next_$eq(last.flip());
            last.next_$eq(b);
            last = b;
            bps.$plus$eq(c2p.apply((Object)b.vert()));
        }
        HalfEdge outOfBounds = last.next();
        ObjectRef base = ObjectRef.create(first2);
        HalfEdge best = null;
        while (true) {
            HalfEdge halfEdge = (HalfEdge)base.elem;
            HalfEdge halfEdge2 = outOfBounds;
            if (!(halfEdge == null ? halfEdge2 != null : !halfEdge.equals(halfEdge2))) break;
            ObjectRef b = ObjectRef.create(((HalfEdge)base.elem).next());
            while (true) {
                HalfEdge halfEdge3 = (HalfEdge)b.elem;
                HalfEdge halfEdge4 = outOfBounds;
                if (!(halfEdge3 == null ? halfEdge4 != null : !halfEdge3.equals(halfEdge4))) break;
                if (this.allSatisfy((HalfEdge)base.elem, (HalfEdge)b.elem, (Function1<HalfEdge<Object, Object>, Object>)(Function1 & Serializable & scala.Serializable)edge -> BoxesRunTime.boxToBoolean((boolean)DelaunayTriangulation.$anonfun$retriangulateBoundaryPoint$2(this, b, base, edge)))) {
                    best = (HalfEdge)b.elem;
                }
                b.elem = ((HalfEdge)b.elem).next();
            }
            if (best == null) {
                base.elem = ((HalfEdge)base.elem).next();
                continue;
            }
            HalfEdge<Object, Object> connector = this.link((HalfEdge)base.elem, best);
            this.triangulateHole(connector.flip(), (Map<Tuple3<Object, Object, Object>, HalfEdge<Object, Object>>)tris);
            base.elem = connector.next();
            best = null;
        }
        return new Tuple3(first2.flip().next(), (Object)BoxesRunTime.boxToInteger((int)end), (Object)tris);
    }

    /*
     * WARNING - void declaration
     */
    private Map<Tuple3<Object, Object, Object>, HalfEdge<Object, Object>> retriangulateInteriorPoint(int vi) {
        void var2_2;
        Map tris = Map$.MODULE$.empty();
        this.triangulateHole(this.holeBound(vi), (Map<Tuple3<Object, Object, Object>, HalfEdge<Object, Object>>)tris);
        return var2_2;
    }

    private Map<Object, Object> decoupleVertex(int vi) {
        int e0;
        int e2 = e0 = this.halfEdgeTable().getFlip(this.halfEdgeTable().edgeIncidentTo(vi));
        Set toKill = Set$.MODULE$.empty();
        ListBuffer pts = (ListBuffer)ListBuffer$.MODULE$.empty();
        do {
            this.triangleMap().$minus$eq((Tuple3<Object, Object, Object>)new Tuple3((Object)BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getSrc(this.halfEdgeTable().getFlip(e2))), (Object)BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getDest(this.halfEdgeTable().getFlip(e2))), (Object)BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getDest(this.halfEdgeTable().getNext(this.halfEdgeTable().getFlip(e2))))));
            e2 = this.halfEdgeTable().rotCWSrc(e2);
        } while (e2 != e0);
        do {
            Point point = Point$.MODULE$.apply(this.pointSet().getCoordinate(this.halfEdgeTable().getDest(e2)));
            pts.$plus$eq$colon((Object)point);
            this.halfEdgeTable().setNext(this.halfEdgeTable().getPrev(this.halfEdgeTable().getFlip(e2)), this.halfEdgeTable().getNext(e2));
            int b = this.halfEdgeTable().getFlip(this.halfEdgeTable().getNext(e2));
            this.halfEdgeTable().setIncidentEdge(this.halfEdgeTable().getDest(e2), b);
            toKill.$plus$eq((Object)BoxesRunTime.boxToInteger((int)e2));
            e2 = this.halfEdgeTable().rotCWSrc(e2);
        } while (e2 != e0);
        LineString region = LineString$.MODULE$.apply((Traversable<Point>)pts, Predef.DummyImplicit$.MODULE$.dummyImplicit(), Predef.DummyImplicit$.MODULE$.dummyImplicit());
        toKill.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)e -> {
            this.halfEdgeTable().killEdge(this.halfEdgeTable().getFlip(e));
            this.halfEdgeTable().killEdge(e);
        });
        this.liveVertices().remove((Object)BoxesRunTime.boxToInteger((int)vi));
        return this.halfEdgeTable().removeIncidentEdge(vi);
    }

    private ListBuffer<Object> removeVertexAndFill(int vi, Map<Tuple3<Object, Object, Object>, HalfEdge<Object, Object>> tris, Option<Object> bnd) {
        ListBuffer exteriorRing;
        block1: {
            exteriorRing = (ListBuffer)ListBuffer$.MODULE$.empty();
            this.decoupleVertex(vi);
            if (bnd.isDefined()) {
                this._boundary_$eq(this.halfEdgeTable().getFlip(BoxesRunTime.unboxToInt((Object)bnd.get())));
            }
            Map edges = Map$.MODULE$.empty();
            tris.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                DelaunayTriangulation.$anonfun$removeVertexAndFill$1(this, exteriorRing, edges, x0$1);
                return BoxedUnit.UNIT;
            });
            if (!edges.nonEmpty()) break block1;
            this._boundary_$eq(this.halfEdgeTable().getFlip(((Tuple2)edges.head())._2$mcI$sp()));
        }
        return exteriorRing;
    }

    public void deletePoint(int vi) {
        Tuple2 tuple22;
        Tuple2 tuple23;
        Set boundvs = Set$.MODULE$.empty();
        int e = this.boundary();
        do {
            boundvs.$plus$eq((Object)BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getDest(e)));
        } while ((e = this.halfEdgeTable().getNext(e)) != this.boundary());
        if (boundvs.contains((Object)BoxesRunTime.boxToInteger((int)vi))) {
            Tuple3<HalfEdge<Object, Object>, Object, Map<Tuple3<Object, Object, Object>, HalfEdge<Object, Object>>> tuple32 = this.retriangulateBoundaryPoint(vi);
            if (tuple32 == null) {
                throw new MatchError(tuple32);
            }
            HalfEdge bnd = (HalfEdge)tuple32._1();
            Map tris = (Map)tuple32._3();
            Tuple2 tuple24 = new Tuple2((Object)bnd, (Object)tris);
            Tuple2 tuple25 = tuple24;
            HalfEdge bnd2 = (HalfEdge)tuple25._1();
            Map tris2 = (Map)tuple25._2();
            tuple23 = new Tuple2((Object)tris2, bnd2.flip().face());
        } else {
            tuple23 = tuple22 = new Tuple2(this.retriangulateInteriorPoint(vi), (Object)None$.MODULE$);
        }
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        Map tris = (Map)tuple22._1();
        Option bnd = (Option)tuple22._2();
        Tuple2 tuple26 = new Tuple2((Object)tris, (Object)bnd);
        Tuple2 tuple27 = tuple26;
        Map tris3 = (Map)tuple27._1();
        Option bnd3 = (Option)tuple27._2();
        this.removeVertexAndFill(vi, (Map<Tuple3<Object, Object, Object>, HalfEdge<Object, Object>>)tris3, (Option<Object>)bnd3);
    }

    public boolean isMeshValid() {
        BooleanRef result;
        block3: {
            Map edges = Map$.MODULE$.empty();
            Set triedges = Set$.MODULE$.empty();
            result = BooleanRef.create((boolean)true);
            int e = this.boundary();
            do {
                edges.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getSrc(e))), (Object)BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getDest(e)))), (Object)BoxesRunTime.boxToInteger((int)e)));
                e = this.halfEdgeTable().getNext(e);
            } while (e != this.boundary());
            Set triverts = Set$.MODULE$.empty();
            this.triangleMap().triangleVertices().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple3 tuple32 = x0$1;
                if (tuple32 == null) {
                    throw new MatchError((Object)tuple32);
                }
                int i = BoxesRunTime.unboxToInt((Object)tuple32._1());
                int j = BoxesRunTime.unboxToInt((Object)tuple32._2());
                int k = BoxesRunTime.unboxToInt((Object)tuple32._3());
                triverts.$plus$eq((Object)BoxesRunTime.boxToInteger((int)i));
                triverts.$plus$eq((Object)BoxesRunTime.boxToInteger((int)j));
                Set set2 = (Set)triverts.$plus$eq((Object)BoxesRunTime.boxToInteger((int)k));
                return set2;
            });
            this.triangleMap().getTriangles().foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                DelaunayTriangulation.$anonfun$isMeshValid$2(this, result, triedges, edges, x0$2);
                return BoxedUnit.UNIT;
            });
            this.halfEdgeTable().allVertices().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)v -> {
                block0: {
                    int t = this.halfEdgeTable().edgeIncidentTo(v);
                    if (triedges.contains((Object)BoxesRunTime.boxToInteger((int)t))) break block0;
                    Predef$.MODULE$.println((Object)new StringBuilder(67).append("edgeIncidentTo(").append(v).append(") refers to non-interior or stale edge [").append(this.halfEdgeTable().getSrc(t)).append(" -> ").append(this.halfEdgeTable().getDest(t)).append("] (ID: ").append(t).append(")").toString());
                    result$1.elem = false;
                }
            });
            Iterable<Object> iterable = this.halfEdgeTable().allVertices();
            Set set2 = triverts;
            if (!(iterable == null ? set2 != null : !iterable.equals((Object)set2))) break block3;
            scala.collection.immutable.Set vertsNotInTris = (scala.collection.immutable.Set)this.halfEdgeTable().allVertices().toSet().$minus$minus((GenTraversableOnce)triverts);
            Set trivertsNotInEdges = triverts.$minus$minus(this.halfEdgeTable().allVertices());
            if (vertsNotInTris.nonEmpty()) {
                Predef$.MODULE$.println((Object)new StringBuilder(68).append("The vertices ").append(vertsNotInTris).append(" are not contained in triangles but have incident edges").toString());
            }
            if (trivertsNotInEdges.nonEmpty()) {
                Predef$.MODULE$.println((Object)new StringBuilder(60).append("The vertices ").append(trivertsNotInEdges).append(" appear in triangles but have no incident edges").toString());
            }
            result.elem = false;
        }
        return result.elem;
    }

    public void navigate() {
        scala.collection.immutable.Map cmds = (scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'i')), (Object)new Tuple2((Object)"mesh information", (JFunction1.mcII.sp & Serializable & scala.Serializable)e -> {
            Predef$.MODULE$.println((Object)new StringBuilder(21).append("Number of vertices:  ").append(this.halfEdgeTable().allVertices().size()).toString());
            Predef$.MODULE$.println((Object)new StringBuilder(21).append("Number of triangles: ").append(this.triangleMap().getTriangles().size()).toString());
            Predef$.MODULE$.print((Object)"List of triangles:   ");
            this.triangleMap().triangleVertices().foreach((Function1 & Serializable & scala.Serializable)t -> {
                Predef$.MODULE$.print((Object)new StringBuilder(1).append(t).append(" ").toString());
                return BoxedUnit.UNIT;
            });
            Predef$.MODULE$.println();
            return e;
        })), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)'x')), (Object)new Tuple2((Object)"export to WKT file", (JFunction1.mcII.sp & Serializable & scala.Serializable)e -> {
            String name = StdIn$.MODULE$.readLine("Enter file name: ", (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            this.writeWKT(name);
            return e;
        }))}));
        this.halfEdgeTable().navigate(this.boundary(), (Function1<Object, Coordinate>)(Function1 & Serializable & scala.Serializable)x$13 -> DelaunayTriangulation.$anonfun$navigate$4(this, BoxesRunTime.unboxToInt((Object)x$13)), (scala.collection.immutable.Map<Object, Tuple2<String, Function1<Object, Object>>>)cmds);
    }

    public void decimate(int nRemove) {
        Function1 & Serializable & scala.Serializable trans = (Function1 & Serializable & scala.Serializable)x$14 -> DelaunayTriangulation.$anonfun$decimate$1(this, BoxesRunTime.unboxToInt((Object)x$14));
        ObjectRef pq = ObjectRef.create((Object)((PriorityQueue)PriorityQueue$.MODULE$.empty(package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToDouble((double)DelaunayTriangulation.$anonfun$decimate$2(x$17)), (Ordering)Ordering.Double$.MODULE$).reverse())));
        this.halfEdgeTable().allVertices().foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)vi -> ((PriorityQueue)pq$1.elem).enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{this.constructPQEntry$1(vi, trans)})));
        for (int index$macro$1 = 0; index$macro$1 < nRemove && ((PriorityQueue)pq.elem).nonEmpty(); ++index$macro$1) {
            Tuple5 tuple52 = (Tuple5)((PriorityQueue)pq.elem).dequeue();
            if (tuple52 == null) {
                throw new MatchError((Object)tuple52);
            }
            double score = BoxesRunTime.unboxToDouble((Object)tuple52._1());
            int vi2 = BoxesRunTime.unboxToInt((Object)tuple52._2());
            Map tris = (Map)tuple52._4();
            Option bnd = (Option)tuple52._5();
            Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)score), (Object)BoxesRunTime.boxToInteger((int)vi2), (Object)tris, (Object)bnd);
            Tuple4 tuple43 = tuple42;
            double score2 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
            int vi3 = BoxesRunTime.unboxToInt((Object)tuple43._2());
            Map tris2 = (Map)tuple43._3();
            Option bnd2 = (Option)tuple43._4();
            scala.collection.immutable.Set nbhd = (scala.collection.immutable.Set)this.halfEdgeTable().neighborsOf(vi3).toSet().$plus$plus(this.removeVertexAndFill(vi3, (Map<Tuple3<Object, Object, Object>, HalfEdge<Object, Object>>)tris2, (Option<Object>)bnd2));
            pq.elem = (PriorityQueue)((PriorityQueue)pq.elem).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)DelaunayTriangulation.$anonfun$decimate$4(nbhd, x0$1)));
            nbhd.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)neighbor -> ((PriorityQueue)pq$1.elem).enqueue((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple5[]{this.constructPQEntry$1(neighbor, trans)})));
        }
    }

    public DelaunayTriangulation copy(CompleteIndexedPointSet pointSet, HalfEdgeTable halfEdgeTable, double tolerance, boolean debug) {
        return new DelaunayTriangulation(pointSet, halfEdgeTable, tolerance, debug);
    }

    public CompleteIndexedPointSet copy$default$1() {
        return this.pointSet();
    }

    public HalfEdgeTable copy$default$2() {
        return this.halfEdgeTable();
    }

    public double copy$default$3() {
        return this.tolerance();
    }

    public boolean copy$default$4() {
        return this.debug();
    }

    public String productPrefix() {
        return "DelaunayTriangulation";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.pointSet();
                break;
            }
            case 1: {
                object = this.halfEdgeTable();
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToDouble((double)this.tolerance());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToBoolean((boolean)this.debug());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DelaunayTriangulation;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.pointSet()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.halfEdgeTable()));
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.tolerance()));
        n = Statics.mix((int)n, (int)(this.debug() ? 1231 : 1237));
        return Statics.finalizeHash((int)n, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DelaunayTriangulation)) return false;
        boolean bl = true;
        if (!bl) return false;
        DelaunayTriangulation delaunayTriangulation = (DelaunayTriangulation)x$1;
        CompleteIndexedPointSet completeIndexedPointSet = this.pointSet();
        CompleteIndexedPointSet completeIndexedPointSet2 = delaunayTriangulation.pointSet();
        if (completeIndexedPointSet == null) {
            if (completeIndexedPointSet2 != null) {
                return false;
            }
        } else if (!completeIndexedPointSet.equals(completeIndexedPointSet2)) return false;
        HalfEdgeTable halfEdgeTable = this.halfEdgeTable();
        HalfEdgeTable halfEdgeTable2 = delaunayTriangulation.halfEdgeTable();
        if (halfEdgeTable == null) {
            if (halfEdgeTable2 != null) {
                return false;
            }
        } else if (!halfEdgeTable.equals(halfEdgeTable2)) return false;
        if (this.tolerance() != delaunayTriangulation.tolerance()) return false;
        if (this.debug() != delaunayTriangulation.debug()) return false;
        if (!delaunayTriangulation.canEqual(this)) return false;
        return true;
    }

    private final List dpInternal$1(List l, List acc) {
        List list2;
        block5: {
            List list3;
            while (true) {
                boolean bl = false;
                .colon.colon colon2 = null;
                list3 = l;
                if (Nil$.MODULE$.equals(list3)) {
                    list2 = acc;
                    break block5;
                }
                if (list3 instanceof .colon.colon) {
                    bl = true;
                    colon2 = (.colon.colon)list3;
                    int i = BoxesRunTime.unboxToInt((Object)colon2.head());
                    List list4 = colon2.tl$access$1();
                    if (Nil$.MODULE$.equals(list4)) {
                        int n = i;
                        list2 = acc.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n));
                        break block5;
                    }
                }
                if (!bl) break;
                int i = BoxesRunTime.unboxToInt((Object)colon2.head());
                List rest = colon2.tl$access$1();
                List chunk = rest.takeWhile((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)j -> this.pointSet().getX(j) <= this.pointSet().getX(i) + this.tolerance());
                if (chunk.exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)j -> {
                    Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(this.pointSet().getX(j), this.pointSet().getY(j));
                    if (sp2 == null) {
                        throw new MatchError((Object)sp2);
                    }
                    double xj = sp2._1$mcD$sp();
                    double yj = sp2._2$mcD$sp();
                    Tuple2.mcDD.sp sp3 = new Tuple2.mcDD.sp(xj, yj);
                    Tuple2.mcDD.sp sp4 = sp3;
                    double xj2 = sp4._1$mcD$sp();
                    double yj2 = sp4._2$mcD$sp();
                    Tuple2.mcDD.sp sp5 = new Tuple2.mcDD.sp(this.pointSet().getX(i), this.pointSet().getY(i));
                    if (sp5 == null) {
                        throw new MatchError((Object)sp5);
                    }
                    double xi = sp5._1$mcD$sp();
                    double yi = sp5._2$mcD$sp();
                    Tuple2.mcDD.sp sp6 = new Tuple2.mcDD.sp(xi, yi);
                    Tuple2.mcDD.sp sp7 = sp6;
                    double xi2 = sp7._1$mcD$sp();
                    double yi2 = sp7._2$mcD$sp();
                    double dx = xj2 - xi2;
                    double dy = yj2 - yi2;
                    return scala.math.package$.MODULE$.sqrt(dx * dx + dy * dy) < this.tolerance();
                })) {
                    l = rest;
                    continue;
                }
                int n = i;
                acc = acc.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n));
                l = rest;
            }
            throw new MatchError((Object)list3);
        }
        return list2;
    }

    private final List distinctPoints$1(List lst) {
        return this.dpInternal$1(lst, (List)Nil$.MODULE$).reverse();
    }

    private final Tuple2 triangulate$1(int lo, int hi, int[] sortedVs$1) {
        Tuple2.mcIZ.sp sp2;
        int n = hi - lo + 1;
        if (this.debug()) {
            Predef$.MODULE$.println((Object)new StringBuilder(33).append("\u001b[38;5;208mTriangulating [").append(lo).append("..").append(hi).append("]\u001b[0m").toString());
        }
        int n2 = n;
        switch (n2) {
            case 1: {
                throw new IllegalArgumentException("Cannot triangulate a point set of size less than 2");
            }
            case 2: {
                int e = this.halfEdgeTable().createHalfEdges(sortedVs$1[lo], sortedVs$1[hi]);
                this.halfEdgeTable().setIncidentEdge(this.halfEdgeTable().getDest(e), e);
                this.halfEdgeTable().setIncidentEdge(this.halfEdgeTable().getSrc(e), this.halfEdgeTable().getFlip(e));
                if (this.debug()) {
                    Predef$.MODULE$.println((Object)new StringBuilder(25).append("setIncidentEdge(").append(this.halfEdgeTable().getDest(e)).append(", [").append(this.halfEdgeTable().getSrc(e)).append(" -> ").append(this.halfEdgeTable().getDest(e)).append("])").toString());
                    Predef$.MODULE$.println((Object)new StringBuilder(25).append("setIncidentEdge(").append(this.halfEdgeTable().getSrc(e)).append(", [").append(this.halfEdgeTable().getSrc(this.halfEdgeTable().getFlip(e))).append(" -> ").append(this.halfEdgeTable().getDest(this.halfEdgeTable().getFlip(e))).append("])").toString());
                }
                sp2 = new Tuple2.mcIZ.sp(e, true);
                break;
            }
            case 3: {
                int v1 = sortedVs$1[lo];
                int v2 = sortedVs$1[lo + 1];
                int v3 = sortedVs$1[lo + 2];
                if (this.predicates().isCCW(v1, v2, v3)) {
                    int e = this.halfEdgeTable().createHalfEdges(v1, v2, v3);
                    int p = this.halfEdgeTable().getPrev(e);
                    this.triangleMap().$plus$eq((Tuple2<Tuple3<Object, Object, Object>, Object>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)v1), (Object)BoxesRunTime.boxToInteger((int)v2), (Object)BoxesRunTime.boxToInteger((int)v3))), (Object)BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getFlip(p))));
                    sp2 = new Tuple2.mcIZ.sp(p, false);
                    break;
                }
                if (this.predicates().isCCW(v1, v3, v2)) {
                    int e = this.halfEdgeTable().createHalfEdges(v1, v3, v2);
                    this.triangleMap().$plus$eq((Tuple2<Tuple3<Object, Object, Object>, Object>)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)v1), (Object)BoxesRunTime.boxToInteger((int)v3), (Object)BoxesRunTime.boxToInteger((int)v2))), (Object)BoxesRunTime.boxToInteger((int)this.halfEdgeTable().getFlip(e))));
                    sp2 = new Tuple2.mcIZ.sp(e, false);
                    break;
                }
                int e1 = this.halfEdgeTable().createHalfEdges(v1, v2);
                int e2 = this.halfEdgeTable().createHalfEdges(v2, v3);
                int e2Flip = this.halfEdgeTable().getFlip(e2);
                this.halfEdgeTable().setNext(e1, e2);
                this.halfEdgeTable().setNext(e2Flip, this.halfEdgeTable().getFlip(e1));
                this.halfEdgeTable().setIncidentEdge(v1, this.halfEdgeTable().getFlip(e1));
                this.halfEdgeTable().setIncidentEdge(v2, e1);
                this.halfEdgeTable().setIncidentEdge(v3, e2);
                if (this.debug()) {
                    Predef$.MODULE$.println((Object)new StringBuilder(24).append("setIncidentEdge(").append(v1).append(", [").append(this.halfEdgeTable().getSrc(this.halfEdgeTable().getFlip(e1))).append(" -> ").append(this.halfEdgeTable().getDest(this.halfEdgeTable().getFlip(e1))).append("]").toString());
                    Predef$.MODULE$.println((Object)new StringBuilder(25).append("setIncidentEdge(").append(v2).append(", [").append(this.halfEdgeTable().getSrc(e1)).append(" -> ").append(this.halfEdgeTable().getDest(e1)).append("])").toString());
                    Predef$.MODULE$.println((Object)new StringBuilder(25).append("setIncidentEdge(").append(v3).append(", [").append(this.halfEdgeTable().getSrc(e2)).append(" -> ").append(this.halfEdgeTable().getDest(e2)).append("])").toString());
                }
                sp2 = new Tuple2.mcIZ.sp(e2Flip, true);
                break;
            }
            default: {
                int med = (hi + lo) / 2;
                Tuple2 tuple22 = this.triangulate$1(lo, med, sortedVs$1);
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                int left = tuple22._1$mcI$sp();
                boolean isLeftLinear = tuple22._2$mcZ$sp();
                Tuple2.mcIZ.sp sp3 = new Tuple2.mcIZ.sp(left, isLeftLinear);
                Tuple2.mcIZ.sp sp4 = sp3;
                int left2 = sp4._1$mcI$sp();
                boolean isLeftLinear2 = sp4._2$mcZ$sp();
                Tuple2 tuple23 = this.triangulate$1(med + 1, hi, sortedVs$1);
                if (tuple23 == null) {
                    throw new MatchError((Object)tuple23);
                }
                int right = tuple23._1$mcI$sp();
                boolean isRightLinear = tuple23._2$mcZ$sp();
                Tuple2.mcIZ.sp sp5 = new Tuple2.mcIZ.sp(right, isRightLinear);
                Tuple2.mcIZ.sp sp6 = sp5;
                int right2 = sp6._1$mcI$sp();
                boolean isRightLinear2 = sp6._2$mcZ$sp();
                sp2 = this.stitcher().merge(left2, isLeftLinear2, right2, isRightLinear2, this.triangleMap(), this.debug());
                break;
            }
        }
        Tuple2.mcIZ.sp result = sp2;
        return result;
    }

    public static final /* synthetic */ boolean $anonfun$isUnfolded$1(DelaunayTriangulation $this, Set bounds$1, Tuple2 x0$1) {
        boolean ok;
        Tuple2 tuple22 = x0$1;
        if (tuple22 != null) {
            int e;
            int f = e = tuple22._2$mcI$sp();
            ok = true;
            do {
                if (bounds$1.contains((Object)BoxesRunTime.boxToInteger((int)$this.halfEdgeTable().getFlip(f)))) continue;
                int v = $this.halfEdgeTable().getDest($this.halfEdgeTable().getNext($this.halfEdgeTable().getFlip(f)));
                boolean bl = ok = ok && $this.predicates().isRightOf(f, v);
            } while ((f = $this.halfEdgeTable().getNext(f)) != e);
        } else {
            throw new MatchError((Object)tuple22);
        }
        boolean bl = ok;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$isUnfolded$2(int lo$1, int hi$1, Tuple2 x0$1) {
        Tuple3 tuple32;
        Tuple2 tuple22 = x0$1;
        if (tuple22 == null || (tuple32 = (Tuple3)tuple22._1()) == null) {
            throw new MatchError((Object)tuple22);
        }
        int a = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int b = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int c = BoxesRunTime.unboxToInt((Object)tuple32._3());
        boolean bl = lo$1 <= a && a <= hi$1 && lo$1 <= b && b <= hi$1 && lo$1 <= c && c <= hi$1;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$isUnfolded$3(DelaunayTriangulation $this, Set bounds$2, Tuple2 x0$2) {
        boolean ok;
        Tuple2 tuple22 = x0$2;
        if (tuple22 != null) {
            int e;
            int f = e = tuple22._2$mcI$sp();
            ok = true;
            do {
                if (bounds$2.contains((Object)BoxesRunTime.boxToInteger((int)$this.halfEdgeTable().getFlip(f)))) continue;
                int v = $this.halfEdgeTable().getDest($this.halfEdgeTable().getNext($this.halfEdgeTable().getFlip(f)));
                boolean bl = ok = ok && $this.predicates().isRightOf(f, v);
            } while ((f = $this.halfEdgeTable().getNext(f)) != e);
        } else {
            throw new MatchError((Object)tuple22);
        }
        boolean bl = ok;
        return bl;
    }

    public static final /* synthetic */ Coordinate $anonfun$writeWKT$1(DelaunayTriangulation $this, int x$9) {
        return $this.pointSet().getCoordinate(x$9);
    }

    public static final /* synthetic */ boolean $anonfun$retriangulateBoundaryPoint$2(DelaunayTriangulation $this, ObjectRef b$1, ObjectRef base$1, HalfEdge edge) {
        return $this.predicates().isCCW(BoxesRunTime.unboxToInt(((HalfEdge)b$1.elem).vert()), BoxesRunTime.unboxToInt(((HalfEdge)base$1.elem).src()), BoxesRunTime.unboxToInt(edge.vert()));
    }

    public static final /* synthetic */ void $anonfun$removeVertexAndFill$1(DelaunayTriangulation $this, ListBuffer exteriorRing$1, Map edges$1, Tuple2 x0$1) {
        Tuple2 tuple22 = x0$1;
        if (tuple22 != null) {
            HalfEdge halfEdge;
            HalfEdge halfEdge2;
            HalfEdge h = (HalfEdge)tuple22._2();
            int v1 = BoxesRunTime.unboxToInt(h.src());
            int v2 = BoxesRunTime.unboxToInt(h.vert());
            int v3 = BoxesRunTime.unboxToInt(h.next().vert());
            int newtri = $this.halfEdgeTable().getFlip($this.halfEdgeTable().createHalfEdges(v1, v2, v3));
            $this.triangleMap().$plus$eq(newtri);
            HalfEdge b = h;
            do {
                BoxedUnit boxedUnit;
                Predef$.MODULE$.assert($this.halfEdgeTable().getSrc(newtri) == BoxesRunTime.unboxToInt(b.src()) && $this.halfEdgeTable().getDest(newtri) == BoxesRunTime.unboxToInt(b.vert()));
                Option option2 = b.flip().face();
                if (option2 instanceof Some) {
                    Some some = (Some)option2;
                    int opp = BoxesRunTime.unboxToInt((Object)some.value());
                    exteriorRing$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)$this.halfEdgeTable().getDest($this.halfEdgeTable().getNext(opp))));
                    $this.halfEdgeTable().join(newtri, opp);
                    boxedUnit = BoxedUnit.UNIT;
                } else if (None$.MODULE$.equals(option2)) {
                    MapLike mapLike;
                    Option option3 = edges$1.get((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(b.vert()), b.src()));
                    if (option3 instanceof Some) {
                        Some some = (Some)option3;
                        int opp = BoxesRunTime.unboxToInt((Object)some.value());
                        edges$1.$minus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(b.vert()), b.src()));
                        $this.halfEdgeTable().join(newtri, opp);
                        mapLike = BoxedUnit.UNIT;
                    } else if (None$.MODULE$.equals(option3)) {
                        mapLike = edges$1.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2.mcII.sp(BoxesRunTime.unboxToInt(b.src()), BoxesRunTime.unboxToInt(b.vert()))), (Object)BoxesRunTime.boxToInteger((int)newtri)));
                    } else {
                        throw new MatchError((Object)option3);
                    }
                    boxedUnit = mapLike;
                } else {
                    throw new MatchError(option2);
                }
                newtri = $this.halfEdgeTable().getNext(newtri);
                halfEdge2 = b = b.next();
                halfEdge = h;
            } while (halfEdge2 == null ? halfEdge != null : !halfEdge2.equals(halfEdge));
        } else {
            throw new MatchError((Object)tuple22);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$isMeshValid$2(DelaunayTriangulation $this, BooleanRef result$1, Set triedges$1, Map edges$2, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple22 = x0$2;
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        Tuple3 tuple32 = (Tuple3)tuple22._1();
        int t0 = tuple22._2$mcI$sp();
        if (tuple32 == null) throw new MatchError((Object)tuple22);
        int i1 = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int i2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
        int i3 = BoxesRunTime.unboxToInt((Object)tuple32._3());
        int t = t0;
        int i = 0;
        GenTraversable genTraversable = Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{i1, i2, i3}));
        GenTraversable genTraversable2 = Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.halfEdgeTable().getSrc(t), $this.halfEdgeTable().getDest(t), $this.halfEdgeTable().getDest($this.halfEdgeTable().getNext(t))}));
        if (genTraversable == null ? genTraversable2 != null : !genTraversable.equals(genTraversable2)) {
            Predef$.MODULE$.println((Object)new StringBuilder(44).append("Triangle ").append(new Tuple3((Object)BoxesRunTime.boxToInteger((int)i1), (Object)BoxesRunTime.boxToInteger((int)i2), (Object)BoxesRunTime.boxToInteger((int)i3))).append(" references loop over [").append($this.halfEdgeTable().getSrc(t)).append(", ").append($this.halfEdgeTable().getDest(t)).append(", ").append($this.halfEdgeTable().getDest($this.halfEdgeTable().getNext(t))).append(", ").append($this.halfEdgeTable().getDest($this.halfEdgeTable().getNext($this.halfEdgeTable().getNext(t)))).append(", ...]").toString());
            result$1.elem = false;
        }
        do {
            MapLike mapLike;
            triedges$1.$plus$eq((Object)BoxesRunTime.boxToInteger((int)t));
            Option option2 = edges$2.get((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)$this.halfEdgeTable().getSrc(t))), (Object)BoxesRunTime.boxToInteger((int)$this.halfEdgeTable().getDest(t))));
            if (None$.MODULE$.equals(option2)) {
                MapLike mapLike2;
                Option option3 = edges$2.get((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)$this.halfEdgeTable().getDest(t))), (Object)BoxesRunTime.boxToInteger((int)$this.halfEdgeTable().getSrc(t))));
                if (None$.MODULE$.equals(option3)) {
                    mapLike2 = edges$2.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)$this.halfEdgeTable().getSrc(t))), (Object)BoxesRunTime.boxToInteger((int)$this.halfEdgeTable().getDest(t)))), (Object)BoxesRunTime.boxToInteger((int)t)));
                } else {
                    BoxedUnit boxedUnit2;
                    if (!(option3 instanceof Some)) throw new MatchError((Object)option3);
                    Some some = (Some)option3;
                    int s = BoxesRunTime.unboxToInt((Object)some.value());
                    if ($this.halfEdgeTable().getFlip(t) != s || $this.halfEdgeTable().getFlip(s) != t) {
                        Predef$.MODULE$.println((Object)new StringBuilder(45).append("Edges [").append($this.halfEdgeTable().getSrc(t)).append(" -> ").append($this.halfEdgeTable().getDest(t)).append("] and [").append($this.halfEdgeTable().getSrc(s)).append(" -> ").append($this.halfEdgeTable().getDest(s)).append("] are not mutual flips!").toString());
                        result$1.elem = false;
                        boxedUnit2 = BoxedUnit.UNIT;
                    } else {
                        boxedUnit2 = BoxedUnit.UNIT;
                    }
                    mapLike2 = boxedUnit2;
                }
                mapLike = mapLike2;
            } else {
                if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                Some some = (Some)option2;
                int s = BoxesRunTime.unboxToInt((Object)some.value());
                Predef$.MODULE$.println((Object)new StringBuilder(46).append("In triangle ").append(new Tuple3((Object)BoxesRunTime.boxToInteger((int)i1), (Object)BoxesRunTime.boxToInteger((int)i2), (Object)BoxesRunTime.boxToInteger((int)i3))).append(": already encountered edge [").append($this.halfEdgeTable().getSrc(t)).append(" -> ").append($this.halfEdgeTable().getDest(t)).append("]!").toString());
                Predef$.MODULE$.print((Object)"   first in ");
                $this.halfEdgeTable().showLoop(s);
                Predef$.MODULE$.print((Object)"   and then in ");
                $this.halfEdgeTable().showLoop(t);
                result$1.elem = false;
                mapLike = BoxedUnit.UNIT;
            }
            ++i;
        } while ((t = $this.halfEdgeTable().getNext(t)) != t0);
        if (i != 3) {
            Predef$.MODULE$.println((Object)new StringBuilder(64).append("Edge [").append($this.halfEdgeTable().getSrc(t0)).append(" -> ").append($this.halfEdgeTable().getDest(t0)).append("] does not participate in triangle ").append(new Tuple3((Object)BoxesRunTime.boxToInteger((int)i1), (Object)BoxesRunTime.boxToInteger((int)i2), (Object)BoxesRunTime.boxToInteger((int)i3))).append("! (loop of length ").append(i).append(")").toString());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BoxedUnit boxedUnit3 = boxedUnit;
    }

    public static final /* synthetic */ Coordinate $anonfun$navigate$4(DelaunayTriangulation $this, int x$13) {
        return $this.pointSet().getCoordinate(x$13);
    }

    public static final /* synthetic */ Coordinate $anonfun$decimate$1(DelaunayTriangulation $this, int x$14) {
        return $this.pointSet().getCoordinate(x$14);
    }

    private final Tuple5 constructPQEntry$1(int vi, Function1 trans$1) {
        Tuple3 tuple32;
        Tuple3 tuple33;
        if (this.halfEdgeTable().onBoundary(vi, this.boundary())) {
            Tuple3<HalfEdge<Object, Object>, Object, Map<Tuple3<Object, Object, Object>, HalfEdge<Object, Object>>> tuple34 = this.retriangulateBoundaryPoint(vi);
            if (tuple34 == null) {
                throw new MatchError(tuple34);
            }
            HalfEdge bound = (HalfEdge)tuple34._1();
            int end = BoxesRunTime.unboxToInt((Object)tuple34._2());
            Map tris = (Map)tuple34._3();
            Tuple3 tuple35 = new Tuple3((Object)bound, (Object)BoxesRunTime.boxToInteger((int)end), (Object)tris);
            Tuple3 tuple36 = tuple35;
            HalfEdge bound2 = (HalfEdge)tuple36._1();
            int end2 = BoxesRunTime.unboxToInt((Object)tuple36._2());
            Map tris2 = (Map)tuple36._3();
            RealMatrix quadric = QuadricError$.MODULE$.facetMatrix((Traversable<Tuple3<Object, Object, Object>>)tris2.keys(), (Function1<Object, Coordinate>)trans$1).add(QuadricError$.MODULE$.edgeMatrix(bound2, end2, (Function1<Object, Coordinate>)trans$1));
            tuple33 = new Tuple3((Object)quadric, (Object)tris2, bound2.flip().face());
        } else {
            Map<Tuple3<Object, Object, Object>, HalfEdge<Object, Object>> tris = this.retriangulateInteriorPoint(vi);
            RealMatrix quadric = QuadricError$.MODULE$.facetMatrix((Traversable<Tuple3<Object, Object, Object>>)tris.keys(), (Function1<Object, Coordinate>)trans$1);
            tuple33 = tuple32 = new Tuple3((Object)quadric, tris, (Object)None$.MODULE$);
        }
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        RealMatrix quadric = (RealMatrix)tuple32._1();
        Map tris = (Map)tuple32._2();
        Option bnd = (Option)tuple32._3();
        Tuple3 tuple37 = new Tuple3((Object)quadric, (Object)tris, (Object)bnd);
        Tuple3 tuple38 = tuple37;
        RealMatrix quadric2 = (RealMatrix)tuple38._1();
        Map tris3 = (Map)tuple38._2();
        Option bnd2 = (Option)tuple38._3();
        Coordinate pt = (Coordinate)trans$1.apply((Object)BoxesRunTime.boxToInteger((int)vi));
        RealVector v = MatrixUtils.createRealVector((double[])new double[]{pt.getX(), pt.getY(), pt.getZ(), 1.0});
        double score = v.dotProduct(quadric2.operate(v));
        return new Tuple5((Object)BoxesRunTime.boxToDouble((double)score), (Object)BoxesRunTime.boxToInteger((int)vi), (Object)quadric2, (Object)tris3, (Object)bnd2);
    }

    public static final /* synthetic */ double $anonfun$decimate$2(Tuple5 x$17) {
        return BoxesRunTime.unboxToDouble((Object)x$17._1());
    }

    public static final /* synthetic */ boolean $anonfun$decimate$4(scala.collection.immutable.Set nbhd$1, Tuple5 x0$1) {
        Tuple5 tuple52 = x0$1;
        if (tuple52 == null) {
            throw new MatchError((Object)tuple52);
        }
        int ix = BoxesRunTime.unboxToInt((Object)tuple52._2());
        boolean bl = !nbhd$1.contains((Object)BoxesRunTime.boxToInteger((int)ix));
        return bl;
    }

    public DelaunayTriangulation(CompleteIndexedPointSet pointSet, HalfEdgeTable halfEdgeTable, double tolerance, boolean debug) {
        Tuple2.mcIZ.sp sp2;
        this.pointSet = pointSet;
        this.halfEdgeTable = halfEdgeTable;
        this.tolerance = tolerance;
        this.debug = debug;
        Product.$init$((Product)this);
        this.triangleMap = new TriangleMap(halfEdgeTable);
        this.predicates = new TriangulationPredicates(pointSet, halfEdgeTable);
        this.stitcher = new DelaunayStitcher(pointSet, halfEdgeTable);
        List s = (List)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), pointSet.length()).toList().sortWith((Function2)(JFunction2.mcZII.sp & Serializable & scala.Serializable)(i1, i2) -> {
            double x2;
            double x1 = this.pointSet().getX(i1);
            return x1 < (x2 = this.pointSet().getX(i2)) ? true : (x1 > x2 ? false : this.pointSet().getY(i1) < this.pointSet().getY(i2));
        });
        int[] sortedVs = (int[])this.distinctPoints$1(s).toArray(ClassTag$.MODULE$.Int());
        Object object = sp2 = sortedVs.length < 2 ? new Tuple2.mcIZ.sp(-1, true) : this.triangulate$1(0, sortedVs.length - 1, sortedVs);
        if (sp2 == null) {
            throw new MatchError((Object)sp2);
        }
        int bnd = sp2._1$mcI$sp();
        boolean isBnd = sp2._2$mcZ$sp();
        Tuple2.mcIZ.sp sp3 = new Tuple2.mcIZ.sp(bnd, isBnd);
        Tuple2.mcIZ.sp sp4 = sp3;
        int bnd2 = sp4._1$mcI$sp();
        boolean isBnd2 = sp4._2$mcZ$sp();
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)bnd2), (Object)BoxesRunTime.boxToBoolean((boolean)isBnd2), (Object)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(sortedVs)));
        if (tuple32 == null) {
            throw new MatchError((Object)tuple32);
        }
        int _boundary = BoxesRunTime.unboxToInt((Object)tuple32._1());
        boolean _isLinear = BoxesRunTime.unboxToBoolean((Object)tuple32._2());
        Set _liveVertices = (Set)tuple32._3();
        Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)_boundary), (Object)BoxesRunTime.boxToBoolean((boolean)_isLinear), (Object)_liveVertices);
        this.x$8 = tuple33;
        this._boundary = BoxesRunTime.unboxToInt((Object)this.x$8._1());
        this._isLinear = BoxesRunTime.unboxToBoolean((Object)this.x$8._2());
        this._liveVertices = (Set)this.x$8._3();
    }
}

