/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.ascii;

import geotrellis.raster.IntArrayTile;
import geotrellis.raster.IntArrayTile$;
import geotrellis.raster.IntConstantNoDataCellType$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import geotrellis.raster.io.ascii.IntReadState;
import geotrellis.raster.io.ascii.ReadState;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.RichChar$;
import scala.util.matching.Regex;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u000b\u0017\u0005}A\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tm\u0001\u0011)\u0019!C\u0001o!AA\b\u0001B\u0001B\u0003%\u0001\b\u0003\u0005>\u0001\t\u0015\r\u0011\"\u00018\u0011!q\u0004A!A!\u0002\u0013A\u0004\u0002C \u0001\u0005\u000b\u0007I\u0011\u0001!\t\u0011\u0011\u0003!\u0011!Q\u0001\n\u0005CQ!\u0012\u0001\u0005\u0002\u0019CA\u0002\u0014\u0001\u0005\u0002\u0003\u0015\t\u00111A\u0005\n5C\u0011\"\u0015\u0001\u0003\u0002\u0003\u0007I\u0011\u0002*\t\u0013a\u0003!\u0011!A!B\u0013q\u0005\"B-\u0001\t\u0003Q\u0006\"\u00020\u0001\t\u0003\u0001\u0005bB0\u0001\u0005\u0004%\t\u0001\u0019\u0005\u0007S\u0002\u0001\u000b\u0011B1\t\u000f)\u0004!\u0019!C\u0001A\"11\u000e\u0001Q\u0001\n\u0005DQ\u0001\u001c\u0001\u0005\u00025DQ!\u001e\u0001\u0005\u0002YDQa\u001f\u0001\u0005\u0002q\u0014a\"Q:dS&\u0014V-\u00193Ti\u0006$XM\u0003\u0002\u00181\u0005)\u0011m]2jS*\u0011\u0011DG\u0001\u0003S>T!a\u0007\u000f\u0002\rI\f7\u000f^3s\u0015\u0005i\u0012AC4f_R\u0014X\r\u001c7jg\u000e\u00011c\u0001\u0001!MA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\u0004\"a\n\u0015\u000e\u0003YI!!\u000b\f\u0003\u0019%sGOU3bIN#\u0018\r^3\u0002\tA\fG\u000f\u001b\t\u0003YMr!!L\u0019\u0011\u00059\u0012S\"A\u0018\u000b\u0005Ar\u0012A\u0002\u001fs_>$h(\u0003\u00023E\u00051\u0001K]3eK\u001aL!\u0001N\u001b\u0003\rM#(/\u001b8h\u0015\t\u0011$%\u0001\u0007sCN$XM]#yi\u0016tG/F\u00019!\tI$(D\u0001\u001b\u0013\tY$D\u0001\u0007SCN$XM]#yi\u0016tG/A\u0007sCN$XM]#yi\u0016tG\u000fI\u0001\u0007i\u0006\u0014x-\u001a;\u0002\u000fQ\f'oZ3uA\u0005Yan\u001c#bi\u00064\u0016\r\\;f+\u0005\t\u0005CA\u0011C\u0013\t\u0019%EA\u0002J]R\fAB\\8ECR\fg+\u00197vK\u0002\na\u0001P5oSRtD#B$I\u0013*[\u0005CA\u0014\u0001\u0011\u0015Q\u0003\u00021\u0001,\u0011\u00151\u0004\u00021\u00019\u0011\u0015i\u0004\u00021\u00019\u0011\u0015y\u0004\u00021\u0001B\u0003=:Wm\u001c;sK2d\u0017n\u001d\u0013sCN$XM\u001d\u0013j_\u0012\n7oY5jI\u0005\u001b8-[5SK\u0006$7\u000b^1uK\u0012\"\u0013N\u001c;t+\u0005q\u0005CA\u001dP\u0013\t\u0001&D\u0001\u0007J]R\f%O]1z)&dW-A\u001ahK>$(/\u001a7mSN$#/Y:uKJ$\u0013n\u001c\u0013bg\u000eL\u0017\u000eJ!tG&L'+Z1e'R\fG/\u001a\u0013%S:$8o\u0018\u0013fcR\u00111K\u0016\t\u0003CQK!!\u0016\u0012\u0003\tUs\u0017\u000e\u001e\u0005\b/*\t\t\u00111\u0001O\u0003\rAH%M\u00011O\u0016|GO]3mY&\u001cHE]1ti\u0016\u0014H%[8%CN\u001c\u0017.\u001b\u0013Bg\u000eL\u0017NU3bIN#\u0018\r^3%I%tGo\u001d\u0011\u0002\u000f\u001d,G\u000fV=qKV\t1L\u0004\u0002:9&\u0011QLG\u0001\u001a\u0013:$8i\u001c8ti\u0006tGOT8ECR\f7)\u001a7m)f\u0004X-\u0001\bhKRtu\u000eR1uCZ\u000bG.^3\u0002\u000b%tGOU3\u0016\u0003\u0005\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\u00115\fGo\u00195j]\u001eT!A\u001a\u0012\u0002\tU$\u0018\u000e\\\u0005\u0003Q\u000e\u0014QAU3hKb\fa!\u001b8u%\u0016\u0004\u0013a\u00024m_\u0006$(+Z\u0001\tM2|\u0017\r\u001e*fA\u0005\tr-\u001a;Ck\u001a4WM]3e%\u0016\fG-\u001a:\u0015\u00039\u0004\"a\\:\u000e\u0003AT!!G9\u000b\u0003I\fAA[1wC&\u0011A\u000f\u001d\u0002\u000f\u0005V4g-\u001a:fIJ+\u0017\rZ3s\u0003)Ig.\u001b;T_V\u00148-\u001a\u000b\u0004'^L\b\"\u0002=\u0014\u0001\u0004\t\u0015a\u00019pg\")!p\u0005a\u0001\u0003\u0006!1/\u001b>f\u0003A\t7o]5h]\u001a\u0013x.\\*pkJ\u001cW\rF\u0003T{~\fI\u0001C\u0003\u007f)\u0001\u0007\u0011)A\u0006t_V\u00148-Z%oI\u0016D\bbBA\u0001)\u0001\u0007\u00111A\u0001\u0005I\u0016\u001cH\u000fE\u0002:\u0003\u000bI1!a\u0002\u001b\u0005AiU\u000f^1cY\u0016\f%O]1z)&dW\r\u0003\u0004\u0002\fQ\u0001\r!Q\u0001\nI\u0016\u001cH/\u00138eKbD3\u0001FA\b!\r\t\u0013\u0011C\u0005\u0004\u0003'\u0011#AB5oY&tW\r")
public final class AsciiReadState
implements IntReadState {
    private final String path;
    private final RasterExtent rasterExtent;
    private final RasterExtent target;
    private final int noDataValue;
    private IntArrayTile geotrellis$raster$io$ascii$AsciiReadState$$ints;
    private final Regex intRe;
    private final Regex floatRe;

    @Override
    public void translate(MutableArrayTile tile) {
        IntReadState.translate$(this, tile);
    }

    @Override
    public MutableArrayTile createTile(int cols, int rows) {
        return ReadState.createTile$(this, cols, rows);
    }

    @Override
    public void destroy() {
        ReadState.destroy$(this);
    }

    @Override
    public Tile loadRaster() {
        return ReadState.loadRaster$(this);
    }

    @Override
    public RasterExtent rasterExtent() {
        return this.rasterExtent;
    }

    @Override
    public RasterExtent target() {
        return this.target;
    }

    public int noDataValue() {
        return this.noDataValue;
    }

    public IntArrayTile geotrellis$raster$io$ascii$AsciiReadState$$ints() {
        return this.geotrellis$raster$io$ascii$AsciiReadState$$ints;
    }

    private void geotrellis$raster$io$ascii$AsciiReadState$$ints_$eq(IntArrayTile x$1) {
        this.geotrellis$raster$io$ascii$AsciiReadState$$ints = x$1;
    }

    @Override
    public IntConstantNoDataCellType$ getType() {
        return IntConstantNoDataCellType$.MODULE$;
    }

    @Override
    public int getNoDataValue() {
        return this.noDataValue();
    }

    public Regex intRe() {
        return this.intRe;
    }

    public Regex floatRe() {
        return this.floatRe;
    }

    public BufferedReader getBufferedReader() {
        File fh = new File(this.path);
        if (!fh.canRead()) {
            throw new Exception(new StringBuilder(12).append("cannot read ").append(this.path).toString());
        }
        FileReader fr = new FileReader(this.path);
        return new BufferedReader(fr);
    }

    @Override
    public void initSource(int pos, int size) {
        Predef$.MODULE$.assert(pos == 0);
        Predef$.MODULE$.assert(size == this.rasterExtent().cols() * this.rasterExtent().rows());
        this.geotrellis$raster$io$ascii$AsciiReadState$$ints_$eq(IntArrayTile$.MODULE$.ofDim(this.rasterExtent().cols(), this.rasterExtent().rows()));
        try (BufferedReader br = this.getBufferedReader();){
            boolean done = false;
            boolean i = false;
            int n = 0;
            while (!done) {
                String line = br.readLine();
                if (line == null) {
                    throw new Exception(new StringBuilder(23).append("premature end of file: ").append(this.path).toString());
                }
                if (line.length() == 0) {
                    throw new Exception(new StringBuilder(20).append("illegal empty line: ").append(this.path).toString());
                }
                String[] toks = line.trim().split(" ");
                if (RichChar$.MODULE$.isDigit$extension(Predef$.MODULE$.charWrapper(toks[0].charAt(0)))) {
                    if (toks.length != this.rasterExtent().cols()) {
                        throw new Exception(new StringBuilder(22).append("saw ").append(toks.length).append(" cols, expected ").append(this.rasterExtent().cols()).append(": ").append(this.path).toString());
                    }
                    int i2 = 0;
                    while (i2 < this.rasterExtent().cols()) {
                        this.geotrellis$raster$io$ascii$AsciiReadState$$ints().update(n, new StringOps(Predef$.MODULE$.augmentString(toks[i2])).toInt());
                        ++i2;
                        ++n;
                    }
                }
                if (n < size) continue;
                done = true;
            }
            if (n != size) {
                throw new Exception(new StringBuilder(22).append("saw ").append(n).append(" rows, expected ").append(size).append(": ").append(this.path).toString());
            }
        }
    }

    @Override
    public void assignFromSource(int sourceIndex, MutableArrayTile dest, int destIndex) {
        dest.update(destIndex, this.geotrellis$raster$io$ascii$AsciiReadState$$ints().apply(sourceIndex));
    }

    public AsciiReadState(String path, RasterExtent rasterExtent, RasterExtent target, int noDataValue) {
        this.path = path;
        this.rasterExtent = rasterExtent;
        this.target = target;
        this.noDataValue = noDataValue;
        ReadState.$init$(this);
        IntReadState.$init$(this);
        this.geotrellis$raster$io$ascii$AsciiReadState$$ints = null;
        this.intRe = new StringOps(Predef$.MODULE$.augmentString("^(-?[0-9]+)$")).r();
        this.floatRe = new StringOps(Predef$.MODULE$.augmentString("^(-?[0-9]+\\.[0-9]+)$")).r();
    }
}

