/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.resample;

import geotrellis.raster.CellSize;
import geotrellis.raster.Tile;
import geotrellis.raster.resample.AggregateResample;
import geotrellis.vector.Extent;
import scala.Function2;
import scala.MatchError;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001E3A\u0001C\u0005\u0001!!AQ\u0003\u0001B\u0001B\u0003%a\u0003\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001c\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0003\"B\u0013\u0001\t\u00031\u0003\"B\u0016\u0001\t\u0013a\u0003\"B$\u0001\t\u0003A\u0005\"B'\u0001\t\u0003q%aD!wKJ\fw-\u001a*fg\u0006l\u0007\u000f\\3\u000b\u0005)Y\u0011\u0001\u0003:fg\u0006l\u0007\u000f\\3\u000b\u00051i\u0011A\u0002:bgR,'OC\u0001\u000f\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\t\u0001\u0011\u0003\u0005\u0002\u0013'5\t\u0011\"\u0003\u0002\u0015\u0013\t\t\u0012iZ4sK\u001e\fG/\u001a*fg\u0006l\u0007\u000f\\3\u0002\tQLG.\u001a\t\u0003/ai\u0011aC\u0005\u00033-\u0011A\u0001V5mK\u00061Q\r\u001f;f]R\u0004\"\u0001H\u0010\u000e\u0003uQ!AH\u0007\u0002\rY,7\r^8s\u0013\t\u0001SD\u0001\u0004FqR,g\u000e^\u0001\ti\u0006\u0014x-\u001a;D'B\u0011qcI\u0005\u0003I-\u0011\u0001bQ3mYNK'0Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\u001dB\u0013F\u000b\t\u0003%\u0001AQ!\u0006\u0003A\u0002YAQA\u0007\u0003A\u0002mAQ!\t\u0003A\u0002\t\n\u0001cY1mGVd\u0017\r^3Bm\u0016\u0014\u0018mZ3\u0015\u00055\u001a\u0004C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#A\u0002#pk\ndW\rC\u00035\u000b\u0001\u0007Q'A\u0004j]\u0012L7-Z:\u0011\u0007Yr\u0014I\u0004\u00028y9\u0011\u0001hO\u0007\u0002s)\u0011!hD\u0001\u0007yI|w\u000e\u001e \n\u0003AJ!!P\u0018\u0002\u000fA\f7m[1hK&\u0011q\b\u0011\u0002\u0004'\u0016\f(BA\u001f0!\u0011q#\t\u0012#\n\u0005\r{#A\u0002+va2,'\u0007\u0005\u0002/\u000b&\u0011ai\f\u0002\u0004\u0013:$\u0018!\u0004:fg\u0006l\u0007\u000f\\3WC2LG\rF\u0002E\u0013.CQA\u0013\u0004A\u00025\n\u0011\u0001\u001f\u0005\u0006\u0019\u001a\u0001\r!L\u0001\u0002s\u0006\u0019\"/Z:b[BdW\rR8vE2,g+\u00197jIR\u0019Qf\u0014)\t\u000b);\u0001\u0019A\u0017\t\u000b1;\u0001\u0019A\u0017")
public class AverageResample
extends AggregateResample {
    private final Tile tile;

    private double calculateAverage(Seq<Tuple2<Object, Object>> indices) {
        Tuple2 tuple22 = (Tuple2)indices.foldLeft((Object)new Tuple2.mcDI.sp(0.0, 0), (Function2 & java.io.Serializable & Serializable)(x0$1, x1$1) -> {
            Tuple2 coords;
            Tuple2 tuple22;
            block3: {
                Tuple2 tuple23;
                block2: {
                    tuple23 = new Tuple2(x0$1, x1$1);
                    if (tuple23 == null) break block2;
                    tuple22 = (Tuple2)tuple23._1();
                    coords = (Tuple2)tuple23._2();
                    if (tuple22 != null) break block3;
                }
                throw new MatchError((Object)tuple23);
            }
            double sum = tuple22._1$mcD$sp();
            int count = tuple22._2$mcI$sp();
            double v = $this.tile.getDouble(coords._1$mcI$sp(), coords._2$mcI$sp());
            Tuple2.mcDI.sp sp2 = !Double.isNaN(v) ? new Tuple2.mcDI.sp(sum + v, count + 1) : new Tuple2.mcDI.sp(sum, count);
            return sp2;
        });
        if (tuple22 == null) {
            throw new MatchError((Object)tuple22);
        }
        double sum = tuple22._1$mcD$sp();
        int count = tuple22._2$mcI$sp();
        Tuple2.mcDI.sp sp2 = new Tuple2.mcDI.sp(sum, count);
        Tuple2.mcDI.sp sp3 = sp2;
        double sum2 = sp3._1$mcD$sp();
        int count2 = sp3._2$mcI$sp();
        return count2 > 0 ? sum2 / (double)count2 : Double.NaN;
    }

    @Override
    public int resampleValid(double x, double y) {
        double doubleAvg = this.calculateAverage(this.contributions(x, y));
        return !Double.isNaN(doubleAvg) ? (int)doubleAvg : Integer.MIN_VALUE;
    }

    @Override
    public double resampleDoubleValid(double x, double y) {
        return this.calculateAverage(this.contributions(x, y));
    }

    public AverageResample(Tile tile, Extent extent, CellSize targetCS) {
        this.tile = tile;
        super(tile, extent, targetCS);
    }
}

