/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector.io.json;

import cats.syntax.EitherOps$;
import cats.syntax.package$either$;
import geotrellis.vector.GeometryCollection$;
import geotrellis.vector.LineString$;
import geotrellis.vector.MultiLineString$;
import geotrellis.vector.MultiPoint$;
import geotrellis.vector.MultiPolygon$;
import geotrellis.vector.Point$;
import geotrellis.vector.Polygon$;
import geotrellis.vector.package$;
import io.circe.Decoder;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.Encoder;
import io.circe.Encoder$;
import io.circe.HCursor;
import io.circe.Json;
import io.circe.Json$;
import io.circe.syntax.package$EncoderOps$;
import java.io.Serializable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005da\u0002\u000f\u001e!\u0003\r\tA\n\u0005\u0006[\u0001!\tA\f\u0005\u0006e\u0001!Ia\r\u0005\u0006\u0017\u0002!I\u0001\u0014\u0005\u0006%\u0002!Ia\u0015\u0005\u00063\u0002!IA\u0017\u0005\u0006;\u0002!IA\u0018\u0005\u0006A\u0002!I!\u0019\u0005\tG\u0002A)\u0019!C\u0002I\"A\u0001\u000e\u0001EC\u0002\u0013\r\u0011\u000e\u0003\u0005n\u0001!\u0015\r\u0011b\u0001o\u0011!\u0001\b\u0001#b\u0001\n\u0007\t\b\u0002C:\u0001\u0011\u000b\u0007I1\u0001;\t\u0011Y\u0004\u0001R1A\u0005\u0004]D\u0001\"\u001f\u0001\t\u0006\u0004%\u0019A\u001f\u0005\n\u007f\u0002A)\u0019!C\u0002\u0003\u0003A!\"!\u0002\u0001\u0011\u000b\u0007I1AA\u0004\u0011)\t\t\u0002\u0001EC\u0002\u0013\r\u00111\u0003\u0005\u000b\u0003/\u0001\u0001R1A\u0005\u0004\u0005e\u0001BCA\u0012\u0001!\u0015\r\u0011b\u0001\u0002&!Q\u0011\u0011\u0006\u0001\t\u0006\u0004%\u0019!a\u000b\t\u0015\u0005U\u0002\u0001#b\u0001\n\u0007\t9\u0004\u0003\u0006\u0002<\u0001A)\u0019!C\u0002\u0003{A!\"a\u0012\u0001\u0011\u000b\u0007I1AA%\u0011\u001d\ti\u0005\u0001C\u0005\u0003\u001f:q!a\u0015\u001e\u0011\u0003\t)F\u0002\u0004\u001d;!\u0005\u0011\u0011\f\u0005\b\u0003;RB\u0011AA0\u0005=9Um\\7fiJLhi\u001c:nCR\u001c(B\u0001\u0010 \u0003\u0011Q7o\u001c8\u000b\u0005\u0001\n\u0013AA5p\u0015\t\u00113%\u0001\u0004wK\u000e$xN\u001d\u0006\u0002I\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0011\u0001a\n\t\u0003Q-j\u0011!\u000b\u0006\u0002U\u0005)1oY1mC&\u0011A&\u000b\u0002\u0007\u0003:L(+\u001a4\u0002\r\u0011Jg.\u001b;%)\u0005y\u0003C\u0001\u00151\u0013\t\t\u0014F\u0001\u0003V]&$\u0018\u0001E<sSR,\u0007k\\5oi\u000e{wN\u001d3t)\t!4\b\u0005\u00026s5\taG\u0003\u00028q\u0005)1-\u001b:dK*\t\u0001%\u0003\u0002;m\t!!j]8o\u0011\u0015a$\u00011\u0001>\u0003\u0015\u0001x.\u001b8u!\tq\u0004J\u0004\u0002@\r:\u0011\u0001)\u0012\b\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007\u0016\na\u0001\u0010:p_Rt\u0014\"\u0001\u0013\n\u0005\t\u001a\u0013BA$\"\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0013&\u0003\u000bA{\u0017N\u001c;\u000b\u0005\u001d\u000b\u0013aD<sSR,G*\u001b8f\u0007>|'\u000fZ:\u0015\u0005Qj\u0005\"\u0002(\u0004\u0001\u0004y\u0015\u0001\u00027j]\u0016\u0004\"A\u0010)\n\u0005ES%A\u0003'j]\u0016\u001cFO]5oO\u0006\u0011rO]5uKB{G._4p]\u000e{wN\u001d3t)\t!D\u000bC\u0003V\t\u0001\u0007a+A\u0004q_2Lxm\u001c8\u0011\u0005y:\u0016B\u0001-K\u0005\u001d\u0001v\u000e\\=h_:\fqB]3bIB{\u0017N\u001c;D_>\u0014Hm\u001d\u000b\u0003{mCQ\u0001X\u0003A\u0002Q\nQA^1mk\u0016\faB]3bI2Kg.Z\"p_J$7\u000f\u0006\u0002P?\")AL\u0002a\u0001i\u0005\t\"/Z1e!>d\u0017pZ8o\u0007>|'\u000fZ:\u0015\u0005Y\u0013\u0007\"\u0002/\b\u0001\u0004!\u0014\u0001\u00049pS:$XI\\2pI\u0016\u0014X#A3\u0011\u0007U2W(\u0003\u0002hm\t9QI\\2pI\u0016\u0014\u0018\u0001\u00049pS:$H)Z2pI\u0016\u0014X#\u00016\u0011\u0007UZW(\u0003\u0002mm\t9A)Z2pI\u0016\u0014\u0018a\u00037j]\u0016,enY8eKJ,\u0012a\u001c\t\u0004k\u0019|\u0015a\u00037j]\u0016$UmY8eKJ,\u0012A\u001d\t\u0004k-|\u0015A\u00049pYf<wN\\#oG>$WM]\u000b\u0002kB\u0019QG\u001a,\u0002\u001dA|G._4p]\u0012+7m\u001c3feV\t\u0001\u0010E\u00026WZ\u000b\u0011#\\;mi&\u0004v.\u001b8u\u000b:\u001cw\u000eZ3s+\u0005Y\bcA\u001bgyB\u0011a(`\u0005\u0003}*\u0013!\"T;mi&\u0004v.\u001b8u\u0003EiW\u000f\u001c;j!>Lg\u000e\u001e#fG>$WM]\u000b\u0003\u0003\u0007\u00012!N6}\u0003YiW\u000f\u001c;j\u0019&tWm\u0015;sS:<WI\\2pI\u0016\u0014XCAA\u0005!\u0011)d-a\u0003\u0011\u0007y\ni!C\u0002\u0002\u0010)\u0013q\"T;mi&d\u0015N\\3TiJLgnZ\u0001\u0017[VdG/\u001b'j]\u0016\u001cFO]5oO\u0012+7m\u001c3feV\u0011\u0011Q\u0003\t\u0005k-\fY!A\nnk2$\u0018\u000eU8ms\u001e|g.\u00128d_\u0012,'/\u0006\u0002\u0002\u001cA!QGZA\u000f!\rq\u0014qD\u0005\u0004\u0003CQ%\u0001D'vYRL\u0007k\u001c7zO>t\u0017aE7vYRL\u0007k\u001c7zO>tG)Z2pI\u0016\u0014XCAA\u0014!\u0011)4.!\b\u00023\u001d,w.\\3uef\u001cu\u000e\u001c7fGRLwN\\#oG>$WM]\u000b\u0003\u0003[\u0001B!\u000e4\u00020A\u0019a(!\r\n\u0007\u0005M\"J\u0001\nHK>lW\r\u001e:z\u0007>dG.Z2uS>t\u0017!G4f_6,GO]=D_2dWm\u0019;j_:$UmY8eKJ,\"!!\u000f\u0011\tUZ\u0017qF\u0001\u0010O\u0016|W.\u001a;ss\u0016s7m\u001c3feV\u0011\u0011q\b\t\u0005k\u0019\f\t\u0005E\u0002?\u0003\u0007J1!!\u0012K\u0005!9Um\\7fiJL\u0018aD4f_6,GO]=EK\u000e|G-\u001a:\u0016\u0005\u0005-\u0003\u0003B\u001bl\u0003\u0003\nQ\"\u001e8xe\u0006\u0004h)Z1ukJ,Gc\u0001\u001b\u0002R!)A\f\u0007a\u0001i\u0005yq)Z8nKR\u0014\u0018PR8s[\u0006$8\u000fE\u0002\u0002Xii\u0011!H\n\u00055\u001d\nY\u0006E\u0002\u0002X\u0001\ta\u0001P5oSRtDCAA+\u0001")
public interface GeometryFormats {
    private Json writePointCoords(Point point) {
        return package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(scala.package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Json[]{package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(BoxesRunTime.boxToDouble((double)package$.MODULE$.withExtraPointMethods(point).x())), Encoder$.MODULE$.encodeDouble()), package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(BoxesRunTime.boxToDouble((double)package$.MODULE$.withExtraPointMethods(point).y())), Encoder$.MODULE$.encodeDouble())}))), Encoder$.MODULE$.encodeVector(Encoder$.MODULE$.encodeJson()));
    }

    private Json writeLineCoords(LineString line) {
        return package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.withExtraLineStringMethods(line).points())).map((Function1 & Serializable & scala.Serializable)point -> this.writePointCoords((Point)point), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Json.class))))).toVector()), Encoder$.MODULE$.encodeVector(Encoder$.MODULE$.encodeJson()));
    }

    private Json writePolygonCoords(Polygon polygon) {
        Json json = this.writeLineCoords(package$.MODULE$.withExtraPolygonMethods(polygon).exterior());
        return package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.withExtraPolygonMethods(polygon).holes())).map((Function1 & Serializable & scala.Serializable)line -> this.writeLineCoords((LineString)line), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Json.class))))).toVector().$plus$colon((Object)json, Vector$.MODULE$.canBuildFrom())), Encoder$.MODULE$.encodeVector(Encoder$.MODULE$.encodeJson()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Point readPointCoords(Json value) {
        boolean bl = false;
        Right right = null;
        Either<DecodingFailure, Vector<Object>> either2 = value.as(Decoder$.MODULE$.decodeVector(Decoder$.MODULE$.decodeDouble()));
        if (either2 instanceof Right) {
            bl = true;
            right = (Right)either2;
            Vector vector2 = (Vector)right.value();
            Some some = scala.package$.MODULE$.Vector().unapplySeq((Seq)vector2);
            if (!some.isEmpty() && some.get() != null && ((Vector)some.get()).lengthCompare(2) == 0) {
                double x = BoxesRunTime.unboxToDouble((Object)((Vector)some.get()).apply(0));
                double y = BoxesRunTime.unboxToDouble((Object)((Vector)some.get()).apply(1));
                return Point$.MODULE$.apply(x, y);
            }
        }
        if (!bl) throw new Exception("Point [x,y] or [x,y,_] coordinates expected");
        Vector vector3 = (Vector)right.value();
        Some some = scala.package$.MODULE$.Vector().unapplySeq((Seq)vector3);
        if (some.isEmpty()) throw new Exception("Point [x,y] or [x,y,_] coordinates expected");
        if (some.get() == null) throw new Exception("Point [x,y] or [x,y,_] coordinates expected");
        if (((Vector)some.get()).lengthCompare(3) != 0) throw new Exception("Point [x,y] or [x,y,_] coordinates expected");
        double x = BoxesRunTime.unboxToDouble((Object)((Vector)some.get()).apply(0));
        double y = BoxesRunTime.unboxToDouble((Object)((Vector)some.get()).apply(1));
        return Point$.MODULE$.apply(x, y);
    }

    private LineString readLineCoords(Json value2) {
        Option<Vector<Json>> option2 = value2.asArray();
        if (!(option2 instanceof Some)) {
            throw new Exception("LineString coordinates array expected");
        }
        Some some = (Some)option2;
        Vector arr = (Vector)some.value();
        LineString lineString = LineString$.MODULE$.apply((Traversable<Point>)((Traversable)arr.map((Function1 & Serializable & scala.Serializable)value -> this.readPointCoords((Json)value), Vector$.MODULE$.canBuildFrom())), Predef.DummyImplicit$.MODULE$.dummyImplicit(), Predef.DummyImplicit$.MODULE$.dummyImplicit());
        return lineString;
    }

    private Polygon readPolygonCoords(Json value2) {
        Option<Vector<Json>> option2 = value2.asArray();
        if (!(option2 instanceof Some)) {
            throw new Exception("Polygon coordinates array expected");
        }
        Some some = (Some)option2;
        Vector arr = (Vector)some.value();
        Vector lines = (Vector)((TraversableLike)arr.map((Function1 & Serializable & scala.Serializable)value -> this.readLineCoords((Json)value), Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> package$.MODULE$.withExtraLineStringMethods((LineString)x$2).closed(), Vector$.MODULE$.canBuildFrom());
        Polygon polygon = Polygon$.MODULE$.apply((LineString)lines.head(), (GenTraversable<LineString>)lines.tail().toSet());
        return polygon;
    }

    public static /* synthetic */ Encoder pointEncoder$(GeometryFormats $this) {
        return $this.pointEncoder();
    }

    default public Encoder<Point> pointEncoder() {
        return Encoder$.MODULE$.encodeJson().contramap((Function1 & Serializable & scala.Serializable)obj -> Json$.MODULE$.obj((Seq<Tuple2<String, Json>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps("Point"), Encoder$.MODULE$.encodeString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"coordinates"), (Object)this.writePointCoords((Point)obj))})));
    }

    public static /* synthetic */ Decoder pointDecoder$(GeometryFormats $this) {
        return $this.pointDecoder();
    }

    default public Decoder<Point> pointDecoder() {
        return Decoder$.MODULE$.decodeJson().emap((Function1 & Serializable & scala.Serializable)json -> {
            HCursor c = json.hcursor();
            return EitherOps$.MODULE$.leftMap$extension(package$either$.MODULE$.catsSyntaxEither(c.downField("type").as(Decoder$.MODULE$.decodeString()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string2 = x0$1;
                Object object = "Point".equals(string2) ? c.downField("coordinates").focus().map((Function1 & Serializable & scala.Serializable)value -> this.readPointCoords((Json)value)).toRight((Function0 & Serializable & scala.Serializable)() -> "Point geometry expected") : ("Feature".equals(string2) ? this.pointDecoder().apply(this.unwrapFeature((Json)json).hcursor()) : scala.package$.MODULE$.Left().apply((Object)"Point geometry expected"));
                return object;
            })), (Function1 & Serializable & scala.Serializable)x$3 -> "Point geometry expected");
        });
    }

    public static /* synthetic */ Encoder lineEncoder$(GeometryFormats $this) {
        return $this.lineEncoder();
    }

    default public Encoder<LineString> lineEncoder() {
        return Encoder$.MODULE$.encodeJson().contramap((Function1 & Serializable & scala.Serializable)obj -> Json$.MODULE$.obj((Seq<Tuple2<String, Json>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps("LineString"), Encoder$.MODULE$.encodeString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"coordinates"), (Object)this.writeLineCoords((LineString)obj))})));
    }

    public static /* synthetic */ Decoder lineDecoder$(GeometryFormats $this) {
        return $this.lineDecoder();
    }

    default public Decoder<LineString> lineDecoder() {
        return Decoder$.MODULE$.decodeJson().emap((Function1 & Serializable & scala.Serializable)json -> {
            HCursor c = json.hcursor();
            return EitherOps$.MODULE$.leftMap$extension(package$either$.MODULE$.catsSyntaxEither(c.downField("type").as(Decoder$.MODULE$.decodeString()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string2 = x0$1;
                Object object = "LineString".equals(string2) ? c.downField("coordinates").focus().map((Function1 & Serializable & scala.Serializable)value -> this.readLineCoords((Json)value)).toRight((Function0 & Serializable & scala.Serializable)() -> "LineString geometry expected") : ("Feature".equals(string2) ? this.lineDecoder().apply(this.unwrapFeature((Json)json).hcursor()) : scala.package$.MODULE$.Left().apply((Object)"LineString geometry expected"));
                return object;
            })), (Function1 & Serializable & scala.Serializable)x$4 -> "LineString geometry expected");
        });
    }

    public static /* synthetic */ Encoder polygonEncoder$(GeometryFormats $this) {
        return $this.polygonEncoder();
    }

    default public Encoder<Polygon> polygonEncoder() {
        return Encoder$.MODULE$.encodeJson().contramap((Function1 & Serializable & scala.Serializable)obj -> Json$.MODULE$.obj((Seq<Tuple2<String, Json>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps("Polygon"), Encoder$.MODULE$.encodeString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"coordinates"), (Object)this.writePolygonCoords((Polygon)obj))})));
    }

    public static /* synthetic */ Decoder polygonDecoder$(GeometryFormats $this) {
        return $this.polygonDecoder();
    }

    default public Decoder<Polygon> polygonDecoder() {
        return Decoder$.MODULE$.decodeJson().emap((Function1 & Serializable & scala.Serializable)json -> {
            HCursor c = json.hcursor();
            return EitherOps$.MODULE$.leftMap$extension(package$either$.MODULE$.catsSyntaxEither(c.downField("type").as(Decoder$.MODULE$.decodeString()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string2 = x0$1;
                Object object = "Polygon".equals(string2) ? c.downField("coordinates").focus().map((Function1 & Serializable & scala.Serializable)value -> this.readPolygonCoords((Json)value)).toRight((Function0 & Serializable & scala.Serializable)() -> "Polygon geometry expected") : ("Feature".equals(string2) ? this.polygonDecoder().apply(this.unwrapFeature((Json)json).hcursor()) : scala.package$.MODULE$.Left().apply((Object)"Polygon geometry expected"));
                return object;
            })), (Function1 & Serializable & scala.Serializable)x$5 -> "Polygon geometry expected");
        });
    }

    public static /* synthetic */ Encoder multiPointEncoder$(GeometryFormats $this) {
        return $this.multiPointEncoder();
    }

    default public Encoder<MultiPoint> multiPointEncoder() {
        return Encoder$.MODULE$.encodeJson().contramap((Function1 & Serializable & scala.Serializable)obj -> Json$.MODULE$.obj((Seq<Tuple2<String, Json>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps("MultiPoint"), Encoder$.MODULE$.encodeString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"coordinates"), (Object)package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.withExtraMultiPointMethods((MultiPoint)obj).points())).map((Function1 & Serializable & scala.Serializable)point -> this.writePointCoords((Point)point), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Json.class)))), Encoder$.MODULE$.encodeIterable(Encoder$.MODULE$.encodeJson(), (Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs))))})));
    }

    public static /* synthetic */ Decoder multiPointDecoder$(GeometryFormats $this) {
        return $this.multiPointDecoder();
    }

    default public Decoder<MultiPoint> multiPointDecoder() {
        return Decoder$.MODULE$.decodeJson().emap((Function1 & Serializable & scala.Serializable)json -> {
            HCursor c = json.hcursor();
            return EitherOps$.MODULE$.leftMap$extension(package$either$.MODULE$.catsSyntaxEither(c.downField("type").as(Decoder$.MODULE$.decodeString()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string2 = x0$1;
                Object object = "MultiPoint".equals(string2) ? c.downField("coordinates").focus().map((Function1 & Serializable & scala.Serializable)json -> MultiPoint$.MODULE$.apply((Traversable<Point>)((Traversable)((TraversableLike)Option$.MODULE$.option2Iterable(json.asArray()).toVector().flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)value -> this.readPointCoords((Json)value), Vector$.MODULE$.canBuildFrom())))).toRight((Function0 & Serializable & scala.Serializable)() -> "MultiPoint geometry expected") : ("Feature".equals(string2) ? this.multiPointDecoder().apply(this.unwrapFeature((Json)json).hcursor()) : scala.package$.MODULE$.Left().apply((Object)"MultiPoint geometry expected"));
                return object;
            })), (Function1 & Serializable & scala.Serializable)x$6 -> "MultiPoint geometry expected");
        });
    }

    public static /* synthetic */ Encoder multiLineStringEncoder$(GeometryFormats $this) {
        return $this.multiLineStringEncoder();
    }

    default public Encoder<MultiLineString> multiLineStringEncoder() {
        return Encoder$.MODULE$.encodeJson().contramap((Function1 & Serializable & scala.Serializable)obj -> Json$.MODULE$.obj((Seq<Tuple2<String, Json>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps("MultiLineString"), Encoder$.MODULE$.encodeString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"coordinates"), (Object)package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.withExtraMultiLineStringMethods((MultiLineString)obj).lines())).map((Function1 & Serializable & scala.Serializable)line -> this.writeLineCoords((LineString)line), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Json.class))))).toVector()), Encoder$.MODULE$.encodeVector(Encoder$.MODULE$.encodeJson())))})));
    }

    public static /* synthetic */ Decoder multiLineStringDecoder$(GeometryFormats $this) {
        return $this.multiLineStringDecoder();
    }

    default public Decoder<MultiLineString> multiLineStringDecoder() {
        return Decoder$.MODULE$.decodeJson().emap((Function1 & Serializable & scala.Serializable)json -> {
            HCursor c = json.hcursor();
            return EitherOps$.MODULE$.leftMap$extension(package$either$.MODULE$.catsSyntaxEither(c.downField("type").as(Decoder$.MODULE$.decodeString()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string2 = x0$1;
                Object object = "MultiLineString".equals(string2) ? c.downField("coordinates").focus().map((Function1 & Serializable & scala.Serializable)json -> MultiLineString$.MODULE$.apply((Traversable<LineString>)((Traversable)((TraversableLike)Option$.MODULE$.option2Iterable(json.asArray()).toVector().flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)value -> this.readLineCoords((Json)value), Vector$.MODULE$.canBuildFrom())))).toRight((Function0 & Serializable & scala.Serializable)() -> "MultiLineString geometry expected") : ("Feature".equals(string2) ? this.multiLineStringDecoder().apply(this.unwrapFeature((Json)json).hcursor()) : scala.package$.MODULE$.Left().apply((Object)"MultiLineString geometry expected"));
                return object;
            })), (Function1 & Serializable & scala.Serializable)x$7 -> "MultiLineString geometry expected");
        });
    }

    public static /* synthetic */ Encoder multiPolygonEncoder$(GeometryFormats $this) {
        return $this.multiPolygonEncoder();
    }

    default public Encoder<MultiPolygon> multiPolygonEncoder() {
        return Encoder$.MODULE$.encodeJson().contramap((Function1 & Serializable & scala.Serializable)obj -> Json$.MODULE$.obj((Seq<Tuple2<String, Json>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps("MultiPolygon"), Encoder$.MODULE$.encodeString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"coordinates"), (Object)package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.withExtraMultiPolygonMethods((MultiPolygon)obj).polygons())).map((Function1 & Serializable & scala.Serializable)polygon -> this.writePolygonCoords((Polygon)polygon), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Json.class))))).toVector()), Encoder$.MODULE$.encodeVector(Encoder$.MODULE$.encodeJson())))})));
    }

    public static /* synthetic */ Decoder multiPolygonDecoder$(GeometryFormats $this) {
        return $this.multiPolygonDecoder();
    }

    default public Decoder<MultiPolygon> multiPolygonDecoder() {
        return Decoder$.MODULE$.decodeJson().emap((Function1 & Serializable & scala.Serializable)json -> {
            HCursor c = json.hcursor();
            return EitherOps$.MODULE$.leftMap$extension(package$either$.MODULE$.catsSyntaxEither(c.downField("type").as(Decoder$.MODULE$.decodeString()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string2 = x0$1;
                Object object = "MultiPolygon".equals(string2) ? c.downField("coordinates").focus().map((Function1 & Serializable & scala.Serializable)json -> MultiPolygon$.MODULE$.apply((Traversable<Polygon>)((Traversable)((TraversableLike)Option$.MODULE$.option2Iterable(json.asArray()).toVector().flatten((Function1)Predef$.MODULE$.$conforms())).map((Function1 & Serializable & scala.Serializable)value -> this.readPolygonCoords((Json)value), Vector$.MODULE$.canBuildFrom())))).toRight((Function0 & Serializable & scala.Serializable)() -> "MultiPolygon geometry expected") : ("Feature".equals(string2) ? this.multiPolygonDecoder().apply(this.unwrapFeature((Json)json).hcursor()) : scala.package$.MODULE$.Left().apply((Object)"MultiPolygon geometry expected"));
                return object;
            })), (Function1 & Serializable & scala.Serializable)x$8 -> "MultiPolygon geometry expected");
        });
    }

    public static /* synthetic */ Encoder geometryCollectionEncoder$(GeometryFormats $this) {
        return $this.geometryCollectionEncoder();
    }

    default public Encoder<GeometryCollection> geometryCollectionEncoder() {
        return Encoder$.MODULE$.encodeJson().contramap((Function1 & Serializable & scala.Serializable)obj -> Json$.MODULE$.obj((Seq<Tuple2<String, Json>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps("GeometryCollection"), Encoder$.MODULE$.encodeString())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"geometries"), (Object)package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(package$.MODULE$.withExtraGeometryCollectionMethods((GeometryCollection)obj).geometries().collect((PartialFunction)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ GeometryFormats $outer;

            public final <A1 extends Geometry, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof Point) {
                    Point point = (Point)A1;
                    object = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(point), this.$outer.pointEncoder());
                } else if (A1 instanceof LineString) {
                    LineString lineString = (LineString)A1;
                    object = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(lineString), this.$outer.lineEncoder());
                } else if (A1 instanceof Polygon) {
                    Polygon polygon = (Polygon)A1;
                    object = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(polygon), this.$outer.polygonEncoder());
                } else if (A1 instanceof MultiPolygon) {
                    MultiPolygon multiPolygon = (MultiPolygon)A1;
                    object = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(multiPolygon), this.$outer.multiPolygonEncoder());
                } else if (A1 instanceof MultiPoint) {
                    MultiPoint multiPoint = (MultiPoint)A1;
                    object = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(multiPoint), this.$outer.multiPointEncoder());
                } else if (A1 instanceof MultiLineString) {
                    MultiLineString multiLineString = (MultiLineString)A1;
                    object = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(multiLineString), this.$outer.multiLineStringEncoder());
                } else if (A1 instanceof GeometryCollection) {
                    GeometryCollection geometryCollection = (GeometryCollection)A1;
                    object = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(geometryCollection), this.$outer.geometryCollectionEncoder());
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Geometry x1) {
                Geometry geometry = x1;
                boolean bl = geometry instanceof Point ? true : (geometry instanceof LineString ? true : (geometry instanceof Polygon ? true : (geometry instanceof MultiPolygon ? true : (geometry instanceof MultiPoint ? true : (geometry instanceof MultiLineString ? true : geometry instanceof GeometryCollection)))));
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())), Encoder$.MODULE$.encodeSeq(Encoder$.MODULE$.encodeJson())))})));
    }

    public static /* synthetic */ Decoder geometryCollectionDecoder$(GeometryFormats $this) {
        return $this.geometryCollectionDecoder();
    }

    default public Decoder<GeometryCollection> geometryCollectionDecoder() {
        return Decoder$.MODULE$.decodeJson().emap((Function1 & Serializable & scala.Serializable)json -> {
            HCursor c = json.hcursor();
            return EitherOps$.MODULE$.leftMap$extension(package$either$.MODULE$.catsSyntaxEither(c.downField("type").as(Decoder$.MODULE$.decodeString()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string2 = x0$1;
                Object object = "GeometryCollection".equals(string2) ? c.downField("geometries").focus().map((Function1 & Serializable & scala.Serializable)json -> GeometryCollection$.MODULE$.apply((Traversable<Geometry>)((Traversable)((TraversableLike)Option$.MODULE$.option2Iterable(json.asArray()).toVector().flatten((Function1)Predef$.MODULE$.$conforms())).flatMap((Function1 & Serializable & scala.Serializable)j -> Option$.MODULE$.option2Iterable(this.geometryDecoder().apply(j.hcursor()).toOption()), Vector$.MODULE$.canBuildFrom())))).toRight((Function0 & Serializable & scala.Serializable)() -> "MultiPolygon geometry expected") : ("Feature".equals(string2) ? this.geometryCollectionDecoder().apply(this.unwrapFeature((Json)json).hcursor()) : scala.package$.MODULE$.Left().apply((Object)"GeometryCollection geometry expected"));
                return object;
            })), (Function1 & Serializable & scala.Serializable)x$9 -> "GeometryCollection geometry expected");
        });
    }

    public static /* synthetic */ Encoder geometryEncoder$(GeometryFormats $this) {
        return $this.geometryEncoder();
    }

    default public Encoder<Geometry> geometryEncoder() {
        return Encoder$.MODULE$.encodeJson().contramap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Json json;
            Geometry geometry = x0$1;
            if (geometry instanceof Point) {
                Point point = (Point)geometry;
                json = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(point), this.pointEncoder());
            } else if (geometry instanceof LineString) {
                LineString lineString = (LineString)geometry;
                json = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(lineString), this.lineEncoder());
            } else if (geometry instanceof Polygon) {
                Polygon polygon = (Polygon)geometry;
                json = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(polygon), this.polygonEncoder());
            } else if (geometry instanceof MultiPolygon) {
                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                json = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(multiPolygon), this.multiPolygonEncoder());
            } else if (geometry instanceof MultiPoint) {
                MultiPoint multiPoint = (MultiPoint)geometry;
                json = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(multiPoint), this.multiPointEncoder());
            } else if (geometry instanceof MultiLineString) {
                MultiLineString multiLineString = (MultiLineString)geometry;
                json = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(multiLineString), this.multiLineStringEncoder());
            } else if (geometry instanceof GeometryCollection) {
                GeometryCollection geometryCollection = (GeometryCollection)geometry;
                json = package$EncoderOps$.MODULE$.asJson$extension(io.circe.syntax.package$.MODULE$.EncoderOps(geometryCollection), this.geometryCollectionEncoder());
            } else {
                throw new Exception(new StringBuilder(24).append("Unknown Geometry type ").append(geometry.getClass().getName()).append(": ").append(geometry).toString());
            }
            return json;
        });
    }

    public static /* synthetic */ Decoder geometryDecoder$(GeometryFormats $this) {
        return $this.geometryDecoder();
    }

    default public Decoder<Geometry> geometryDecoder() {
        return Decoder$.MODULE$.decodeJson().emap((Function1 & Serializable & scala.Serializable)json -> {
            HCursor c = json.hcursor();
            return EitherOps$.MODULE$.leftMap$extension(package$either$.MODULE$.catsSyntaxEither(c.downField("type").as(Decoder$.MODULE$.decodeString()).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                String string2 = x0$1;
                Object object = "Feature".equals(string2) ? this.geometryDecoder().apply(this.unwrapFeature((Json)json).hcursor()) : ("Point".equals(string2) ? json.as(this.pointDecoder()) : ("LineString".equals(string2) ? json.as(this.lineDecoder()) : ("Polygon".equals(string2) ? json.as(this.polygonDecoder()) : ("MultiPolygon".equals(string2) ? json.as(this.multiPolygonDecoder()) : ("MultiPoint".equals(string2) ? json.as(this.multiPointDecoder()) : ("MultiLineString".equals(string2) ? json.as(this.multiLineStringDecoder()) : ("GeometryCollection".equals(string2) ? json.as(this.geometryCollectionDecoder()) : scala.package$.MODULE$.Left().apply((Object)new StringBuilder(23).append("Unknown Geometry type: ").append(string2).toString()))))))));
                return object;
            })), (Function1 & Serializable & scala.Serializable)x$10 -> "Geometry expected");
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Json unwrapFeature(Json value) {
        HCursor c = value.hcursor();
        Tuple2 tuple22 = new Tuple2(c.downField("type").as(Decoder$.MODULE$.decodeString()), c.downField("geometry").focus());
        if (tuple22 == null) return value;
        Either either2 = (Either)tuple22._1();
        Option option2 = (Option)tuple22._2();
        if (!(either2 instanceof Right)) return value;
        Right right = (Right)either2;
        String string2 = (String)right.value();
        if (!"Feature".equals(string2)) return value;
        if (!(option2 instanceof Some)) return value;
        Some some = (Some)option2;
        Json geom = (Json)some.value();
        return geom;
    }

    public static void $init$(GeometryFormats $this) {
    }
}

