/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.raster.IntArrayTile;
import geotrellis.raster.IntCellType$;
import geotrellis.raster.IntCells;
import geotrellis.raster.IntCells$;
import geotrellis.raster.IntConstantNoDataArrayTile;
import geotrellis.raster.IntConstantNoDataCellType$;
import geotrellis.raster.IntRawArrayTile;
import geotrellis.raster.IntUserDefinedNoDataArrayTile;
import geotrellis.raster.IntUserDefinedNoDataCellType;
import geotrellis.raster.package$;
import geotrellis.raster.package$IntArrayFiller$;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class IntArrayTile$
implements Serializable {
    public static IntArrayTile$ MODULE$;

    static {
        new IntArrayTile$();
    }

    public IntArrayTile apply(int[] arr, int cols, int rows) {
        return this.apply(arr, cols, rows, IntConstantNoDataCellType$.MODULE$);
    }

    public IntArrayTile apply(int[] arr, int cols, int rows, IntCells cellType) {
        IntArrayTile intArrayTile;
        IntCells intCells = cellType;
        if (IntCellType$.MODULE$.equals(intCells)) {
            intArrayTile = new IntRawArrayTile(arr, cols, rows);
        } else if (IntConstantNoDataCellType$.MODULE$.equals(intCells)) {
            intArrayTile = new IntConstantNoDataArrayTile(arr, cols, rows);
        } else if (intCells instanceof IntUserDefinedNoDataCellType) {
            IntUserDefinedNoDataCellType intUserDefinedNoDataCellType = (IntUserDefinedNoDataCellType)intCells;
            intArrayTile = new IntUserDefinedNoDataArrayTile(arr, cols, rows, intUserDefinedNoDataCellType);
        } else {
            throw new MatchError((Object)intCells);
        }
        return intArrayTile;
    }

    public IntArrayTile apply(int[] arr, int cols, int rows, Option<Object> noDataValue) {
        return this.apply(arr, cols, rows, IntCells$.MODULE$.withNoData(noDataValue));
    }

    public IntArrayTile apply(int[] arr, int cols, int rows, int noDataValue) {
        return this.apply(arr, cols, rows, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)noDataValue)));
    }

    public IntArrayTile ofDim(int cols, int rows) {
        return this.ofDim(cols, rows, IntConstantNoDataCellType$.MODULE$);
    }

    public IntArrayTile ofDim(int cols, int rows, IntCells cellType) {
        IntArrayTile intArrayTile;
        IntCells intCells = cellType;
        if (IntCellType$.MODULE$.equals(intCells)) {
            intArrayTile = new IntRawArrayTile((int[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Int()), cols, rows);
        } else if (IntConstantNoDataCellType$.MODULE$.equals(intCells)) {
            intArrayTile = new IntConstantNoDataArrayTile((int[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Int()), cols, rows);
        } else if (intCells instanceof IntUserDefinedNoDataCellType) {
            IntUserDefinedNoDataCellType intUserDefinedNoDataCellType = (IntUserDefinedNoDataCellType)intCells;
            intArrayTile = new IntUserDefinedNoDataArrayTile((int[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Int()), cols, rows, intUserDefinedNoDataCellType);
        } else {
            throw new MatchError((Object)intCells);
        }
        return intArrayTile;
    }

    public IntArrayTile empty(int cols, int rows) {
        return this.empty(cols, rows, IntConstantNoDataCellType$.MODULE$);
    }

    public IntArrayTile empty(int cols, int rows, IntCells cellType) {
        IntArrayTile intArrayTile;
        IntCells intCells = cellType;
        if (IntCellType$.MODULE$.equals(intCells)) {
            intArrayTile = this.ofDim(cols, rows, cellType);
        } else if (IntConstantNoDataCellType$.MODULE$.equals(intCells)) {
            intArrayTile = this.fill(Integer.MIN_VALUE, cols, rows, cellType);
        } else if (intCells instanceof IntUserDefinedNoDataCellType) {
            IntUserDefinedNoDataCellType intUserDefinedNoDataCellType = (IntUserDefinedNoDataCellType)intCells;
            int nd = intUserDefinedNoDataCellType.noDataValue();
            intArrayTile = this.fill(nd, cols, rows, cellType);
        } else {
            throw new MatchError((Object)intCells);
        }
        return intArrayTile;
    }

    public IntArrayTile fill(int v, int cols, int rows) {
        return this.fill(v, cols, rows, IntConstantNoDataCellType$.MODULE$);
    }

    public IntArrayTile fill(int v, int cols, int rows, IntCells cellType) {
        IntArrayTile intArrayTile;
        IntCells intCells = cellType;
        if (IntCellType$.MODULE$.equals(intCells)) {
            intArrayTile = new IntRawArrayTile(package$IntArrayFiller$.MODULE$.fill$extension(package$.MODULE$.IntArrayFiller((int[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Int())), v), cols, rows);
        } else if (IntConstantNoDataCellType$.MODULE$.equals(intCells)) {
            intArrayTile = new IntConstantNoDataArrayTile(package$IntArrayFiller$.MODULE$.fill$extension(package$.MODULE$.IntArrayFiller((int[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Int())), v), cols, rows);
        } else if (intCells instanceof IntUserDefinedNoDataCellType) {
            IntUserDefinedNoDataCellType intUserDefinedNoDataCellType = (IntUserDefinedNoDataCellType)intCells;
            intArrayTile = new IntUserDefinedNoDataArrayTile(package$IntArrayFiller$.MODULE$.fill$extension(package$.MODULE$.IntArrayFiller((int[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Int())), v), cols, rows, intUserDefinedNoDataCellType);
        } else {
            throw new MatchError((Object)intCells);
        }
        return intArrayTile;
    }

    private int[] constructIntArray(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, 0, new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).size());
        IntBuffer intBuffer = byteBuffer.asIntBuffer();
        int[] intArray = new int[new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).size() / IntConstantNoDataCellType$.MODULE$.bytes()];
        intBuffer.get(intArray);
        return intArray;
    }

    public IntArrayTile fromBytes(byte[] bytes, int cols, int rows) {
        return this.fromBytes(bytes, cols, rows, IntConstantNoDataCellType$.MODULE$);
    }

    public IntArrayTile fromBytes(byte[] bytes, int cols, int rows, IntCells cellType) {
        IntArrayTile intArrayTile;
        IntCells intCells = cellType;
        if (IntCellType$.MODULE$.equals(intCells)) {
            intArrayTile = new IntRawArrayTile(this.constructIntArray(bytes), cols, rows);
        } else if (IntConstantNoDataCellType$.MODULE$.equals(intCells)) {
            intArrayTile = new IntConstantNoDataArrayTile(this.constructIntArray(bytes), cols, rows);
        } else if (intCells instanceof IntUserDefinedNoDataCellType) {
            IntUserDefinedNoDataCellType intUserDefinedNoDataCellType = (IntUserDefinedNoDataCellType)intCells;
            intArrayTile = new IntUserDefinedNoDataArrayTile(this.constructIntArray(bytes), cols, rows, intUserDefinedNoDataCellType);
        } else {
            throw new MatchError((Object)intCells);
        }
        return intArrayTile;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private IntArrayTile$() {
        MODULE$ = this;
    }
}

