/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.Dimensions;
import geotrellis.raster.Dimensions$;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridBounds$;
import geotrellis.raster.PixelIsArea$;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.TileLayout;
import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout$;
import geotrellis.raster.io.geotiff.InterleaveMethod;
import geotrellis.raster.io.geotiff.PixelInterleave$;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Tiled;
import geotrellis.raster.rasterize.Rasterizer;
import geotrellis.raster.rasterize.Rasterizer$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import org.locationtech.jts.geom.Geometry;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\tec\u0001\u0002\u00180\u0001bB\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\"A1\n\u0001BK\u0002\u0013\u0005a\t\u0003\u0005M\u0001\tE\t\u0015!\u0003H\u0011!i\u0005A!f\u0001\n\u0003q\u0005\u0002C*\u0001\u0005#\u0005\u000b\u0011B(\t\u0011Q\u0003!Q3A\u0005\u0002UC\u0001B\u0017\u0001\u0003\u0012\u0003\u0006IA\u0016\u0005\t7\u0002\u0011)\u001a!C\u00019\"A\u0001\r\u0001B\tB\u0003%Q\fC\u0003b\u0001\u0011\u0005!\rC\u0003j\u0001\u0011\u0005!\u000eC\u0003o\u0001\u0011\u0005!\u000eC\u0003p\u0001\u0011\u0005!\u000e\u0003\u0004q\u0001\u0011\u0005q&\u001d\u0005\u0006m\u0002!\ta\u001e\u0005\b\u0003K\u0001A\u0011BA\u0014\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!!\r\u0001\t\u0003\t9\u0004C\u0004\u00022\u0001!\t!a\u0019\t\r\u00055\u0004\u0001\"\u0001G\u0011\u001d\ty\u0007\u0001C\u0001\u0003cBq!! \u0001\t\u0003\ty\b\u0003\u0005\u0002\n\u0002!\t!NAF\u0011%\ty\tAA\u0001\n\u0003\t\t\nC\u0005\u0002\u001e\u0002\t\n\u0011\"\u0001\u0002 \"I\u0011Q\u0017\u0001\u0012\u0002\u0013\u0005\u0011q\u0014\u0005\n\u0003o\u0003\u0011\u0013!C\u0001\u0003sC\u0011\"!0\u0001#\u0003%\t!a0\t\u0013\u0005\r\u0007!%A\u0005\u0002\u0005\u0015\u0007\"CAe\u0001\u0005\u0005I\u0011IAf\u0011!\ti\u000eAA\u0001\n\u00031\u0005\"CAp\u0001\u0005\u0005I\u0011AAq\u0011%\ti\u000fAA\u0001\n\u0003\ny\u000fC\u0005\u0002~\u0002\t\t\u0011\"\u0001\u0002\u0000\"I!1\u0001\u0001\u0002\u0002\u0013\u0005#Q\u0001\u0005\n\u0005\u000f\u0001\u0011\u0011!C!\u0005\u0013A\u0011Ba\u0003\u0001\u0003\u0003%\tE!\u0004\b\u000f\tEq\u0006#\u0001\u0003\u0014\u00191af\fE\u0001\u0005+Aa!\u0019\u0015\u0005\u0002\t]\u0001b\u0002B\rQ\u0011\u0005!1\u0004\u0005\n\u00053A\u0013\u0011!CA\u0005_A\u0011Ba\u000f)\u0003\u0003%\tI!\u0010\t\u0013\t=\u0003&!A\u0005\n\tE#\u0001F$f_RKgMZ*fO6,g\u000e\u001e'bs>,HO\u0003\u00021c\u00059q-Z8uS\u001a4'B\u0001\u001a4\u0003\tIwN\u0003\u00025k\u00051!/Y:uKJT\u0011AN\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\n\u0005\u0001ez$\t\u0005\u0002;{5\t1HC\u0001=\u0003\u0015\u00198-\u00197b\u0013\tq4H\u0001\u0004B]f\u0014VM\u001a\t\u0003u\u0001K!!Q\u001e\u0003\u000fA\u0013x\u000eZ;diB\u0011!hQ\u0005\u0003\tn\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f\u0011\u0002^8uC2\u001cu\u000e\\:\u0016\u0003\u001d\u0003\"A\u000f%\n\u0005%[$aA%oi\u0006QAo\u001c;bY\u000e{Gn\u001d\u0011\u0002\u0013Q|G/\u00197S_^\u001c\u0018A\u0003;pi\u0006d'k\\<tA\u0005QA/\u001b7f\u0019\u0006Lx.\u001e;\u0016\u0003=\u0003\"\u0001U)\u000e\u0003MJ!AU\u001a\u0003\u0015QKG.\u001a'bs>,H/A\u0006uS2,G*Y=pkR\u0004\u0013!D:u_J\fw-Z'fi\"|G-F\u0001W!\t9\u0006,D\u00010\u0013\tIvFA\u0007Ti>\u0014\u0018mZ3NKRDw\u000eZ\u0001\u000fgR|'/Y4f\u001b\u0016$\bn\u001c3!\u0003AIg\u000e^3sY\u0016\fg/Z'fi\"|G-F\u0001^!\t9f,\u0003\u0002`_\t\u0001\u0012J\u001c;fe2,\u0017M^3NKRDw\u000eZ\u0001\u0012S:$XM\u001d7fCZ,W*\u001a;i_\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0004dI\u00164w\r\u001b\t\u0003/\u0002AQ!R\u0006A\u0002\u001dCQaS\u0006A\u0002\u001dCQ!T\u0006A\u0002=CQ\u0001V\u0006A\u0002YCQaW\u0006A\u0002u\u000bq![:US2,G-F\u0001l!\tQD.\u0003\u0002nw\t9!i\\8mK\u0006t\u0017!C5t'R\u0014\u0018\u000e]3e\u0003IA\u0017m\u001d)jq\u0016d\u0017J\u001c;fe2,\u0017M^3\u0002\u001f\u001d,GoU3h[\u0016tG/\u00138eKb$2a\u0012:u\u0011\u0015\u0019x\u00021\u0001H\u0003\r\u0019w\u000e\u001c\u0005\u0006k>\u0001\raR\u0001\u0004e><\u0018A\u00079beRLG/[8o/&tGm\\<t\u0005f\u001cVmZ7f]R\u001cH\u0003\u0002=\u0000\u00037\u00012AO=|\u0013\tQ8HA\u0003BeJ\f\u0017\u0010E\u0002;sr\u00042\u0001U?H\u0013\tq8G\u0001\u0006He&$'i\\;oINDq!!\u0001\u0011\u0001\u0004\t\u0019!A\u0004xS:$wn^:\u0011\u000b\u0005\u0015\u0011Q\u0003?\u000f\t\u0005\u001d\u0011\u0011\u0003\b\u0005\u0003\u0013\ty!\u0004\u0002\u0002\f)\u0019\u0011QB\u001c\u0002\rq\u0012xn\u001c;?\u0013\u0005a\u0014bAA\nw\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\f\u00033\u00111aU3r\u0015\r\t\u0019b\u000f\u0005\b\u0003;\u0001\u0002\u0019AA\u0010\u0003Ai\u0017\r\u001f)beRLG/[8o'&TX\rE\u0002;\u0003CI1!a\t<\u0005\u0011auN\\4\u0002\u001d\t,7\u000f^,j]\u0012|woU5{KR)q)!\u000b\u0002.!1\u00111F\tA\u0002\u001d\u000bq!\\1y'&TX\r\u0003\u0004\u00020E\u0001\raR\u0001\bg\u0016<W.\u001a8u\u0003-a\u0017n\u001d;XS:$wn^:\u0015\u0007m\f)\u0004\u0003\u0004\u0002,I\u0001\ra\u0012\u000b\bw\u0006e\u00121HA&\u0011\u0019\tYc\u0005a\u0001\u000f\"9\u0011QH\nA\u0002\u0005}\u0012AB3yi\u0016tG\u000f\u0005\u0003\u0002B\u0005\u001dSBAA\"\u0015\r\t)%N\u0001\u0007m\u0016\u001cGo\u001c:\n\t\u0005%\u00131\t\u0002\u0007\u000bb$XM\u001c;\t\u000f\u000553\u00031\u0001\u0002P\u0005Aq-Z8nKR\u0014\u0018\u0010\u0005\u0003\u0002R\u0005uc\u0002BA*\u00037rA!!\u0016\u0002Z9!\u0011\u0011BA,\u0013\u00051\u0014bAA#k%!\u00111CA\"\u0013\u0011\ty&!\u0019\u0003\u0011\u001d+w.\\3uefTA!a\u0005\u0002DQ)10!\u001a\u0002j!1\u0011q\r\u000bA\u0002\u001d\u000bAaY8mg\"1\u00111\u000e\u000bA\u0002\u001d\u000bAA]8xg\u0006\u0001\"-\u00198e'\u0016<W.\u001a8u\u0007>,h\u000e^\u0001\u0015O\u0016$8+Z4nK:$8i\\8sI&t\u0017\r^3\u0015\t\u0005M\u0014\u0011\u0010\t\u0006u\u0005UtiR\u0005\u0004\u0003oZ$A\u0002+va2,'\u0007\u0003\u0004\u0002|Y\u0001\raR\u0001\rg\u0016<W.\u001a8u\u0013:$W\r_\u0001\u0015O\u0016$8+Z4nK:$H)[7f]NLwN\\:\u0015\t\u0005\u0005\u0015q\u0011\t\u0005!\u0006\ru)C\u0002\u0002\u0006N\u0012!\u0002R5nK:\u001c\u0018n\u001c8t\u0011\u0019\tYh\u0006a\u0001\u000f\u0006iq-\u001a;He&$'i\\;oIN$2\u0001`AG\u0011\u0019\tY\b\u0007a\u0001\u000f\u0006!1m\u001c9z)-\u0019\u00171SAK\u0003/\u000bI*a'\t\u000f\u0015K\u0002\u0013!a\u0001\u000f\"91*\u0007I\u0001\u0002\u00049\u0005bB'\u001a!\u0003\u0005\ra\u0014\u0005\b)f\u0001\n\u00111\u0001W\u0011\u001dY\u0016\u0004%AA\u0002u\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\"*\u001aq)a),\u0005\u0005\u0015\u0006\u0003BAT\u0003ck!!!+\u000b\t\u0005-\u0016QV\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a,<\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003g\u000bIKA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005m&fA(\u0002$\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAAaU\r1\u00161U\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136+\t\t9MK\u0002^\u0003G\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAg!\u0011\ty-!7\u000e\u0005\u0005E'\u0002BAj\u0003+\fA\u0001\\1oO*\u0011\u0011q[\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\\\u0006E'AB*ue&tw-\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005\r\u0018\u0011\u001e\t\u0004u\u0005\u0015\u0018bAAtw\t\u0019\u0011I\\=\t\u0011\u0005-\u0018%!AA\u0002\u001d\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAy!\u0019\t\u00190!?\u0002d6\u0011\u0011Q\u001f\u0006\u0004\u0003o\\\u0014AC2pY2,7\r^5p]&!\u00111`A{\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007-\u0014\t\u0001C\u0005\u0002l\u000e\n\t\u00111\u0001\u0002d\u0006A\u0001.Y:i\u0007>$W\rF\u0001H\u0003!!xn\u0015;sS:<GCAAg\u0003\u0019)\u0017/^1mgR\u00191Na\u0004\t\u0013\u0005-h%!AA\u0002\u0005\r\u0018\u0001F$f_RKgMZ*fO6,g\u000e\u001e'bs>,H\u000f\u0005\u0002XQM\u0019\u0001&\u000f\"\u0015\u0005\tM\u0011!B1qa2LHcC2\u0003\u001e\t}!\u0011\u0005B\u0012\u0005KAQ!\u0012\u0016A\u0002\u001dCQa\u0013\u0016A\u0002\u001dCQ\u0001\u0016\u0016A\u0002YCQa\u0017\u0016A\u0002uCqAa\n+\u0001\u0004\u0011I#\u0001\u0005cC:$G+\u001f9f!\r9&1F\u0005\u0004\u0005[y#\u0001\u0003\"b]\u0012$\u0016\u0010]3\u0015\u0017\r\u0014\tDa\r\u00036\t]\"\u0011\b\u0005\u0006\u000b.\u0002\ra\u0012\u0005\u0006\u0017.\u0002\ra\u0012\u0005\u0006\u001b.\u0002\ra\u0014\u0005\u0006).\u0002\rA\u0016\u0005\u00067.\u0002\r!X\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011yDa\u0013\u0011\u000bi\u0012\tE!\u0012\n\u0007\t\r3H\u0001\u0004PaRLwN\u001c\t\tu\t\u001dsiR(W;&\u0019!\u0011J\u001e\u0003\rQ+\b\u000f\\36\u0011!\u0011i\u0005LA\u0001\u0002\u0004\u0019\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011\u0019\u0006\u0005\u0003\u0002P\nU\u0013\u0002\u0002B,\u0003#\u0014aa\u00142kK\u000e$\b")
public class GeoTiffSegmentLayout
implements Product,
scala.Serializable {
    private final int totalCols;
    private final int totalRows;
    private final TileLayout tileLayout;
    private final StorageMethod storageMethod;
    private final InterleaveMethod interleaveMethod;

    public static Option<Tuple5<Object, Object, TileLayout, StorageMethod, InterleaveMethod>> unapply(GeoTiffSegmentLayout geoTiffSegmentLayout) {
        return GeoTiffSegmentLayout$.MODULE$.unapply(geoTiffSegmentLayout);
    }

    public static GeoTiffSegmentLayout apply(int n, int n2, TileLayout tileLayout, StorageMethod storageMethod, InterleaveMethod interleaveMethod) {
        return GeoTiffSegmentLayout$.MODULE$.apply(n, n2, tileLayout, storageMethod, interleaveMethod);
    }

    public static GeoTiffSegmentLayout apply(int n, int n2, StorageMethod storageMethod, InterleaveMethod interleaveMethod, BandType bandType) {
        return GeoTiffSegmentLayout$.MODULE$.apply(n, n2, storageMethod, interleaveMethod, bandType);
    }

    public int totalCols() {
        return this.totalCols;
    }

    public int totalRows() {
        return this.totalRows;
    }

    public TileLayout tileLayout() {
        return this.tileLayout;
    }

    public StorageMethod storageMethod() {
        return this.storageMethod;
    }

    public InterleaveMethod interleaveMethod() {
        return this.interleaveMethod;
    }

    public boolean isTiled() {
        StorageMethod storageMethod = this.storageMethod();
        boolean bl = storageMethod instanceof Tiled;
        return bl;
    }

    public boolean isStriped() {
        return !this.isTiled();
    }

    public boolean hasPixelInterleave() {
        InterleaveMethod interleaveMethod = this.interleaveMethod();
        PixelInterleave$ pixelInterleave$ = PixelInterleave$.MODULE$;
        return !(interleaveMethod != null ? !interleaveMethod.equals(pixelInterleave$) : pixelInterleave$ != null);
    }

    public int getSegmentIndex(int col, int row) {
        int layoutCol = col / this.tileLayout().tileCols();
        int layoutRow = row / this.tileLayout().tileRows();
        return layoutRow * this.tileLayout().layoutCols() + layoutCol;
    }

    public GridBounds<Object>[][] partitionWindowsBySegments(Seq<GridBounds<Object>> windows, long maxPartitionSize) {
        ArrayBuilder partition = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(GridBounds.class));
        partition.sizeHintBounded(128, windows);
        LongRef partitionSize = LongRef.create((long)0L);
        LongRef partitionCount = LongRef.create((long)0L);
        ArrayBuilder partitions = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(GridBounds.class)));
        GridBounds<Object> sourceBounds = GridBounds$.MODULE$.apply(0, 0, this.totalCols() - 1, this.totalRows() - 1);
        Seq sorted = (Seq)((SeqLike)((TraversableLike)windows.filter((Function1 & Serializable & scala.Serializable)other -> BoxesRunTime.boxToBoolean((boolean)sourceBounds.intersects$mcI$sp(other)))).map((Function1 & Serializable & scala.Serializable)window -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(window), (Object)BoxesRunTime.boxToInteger((int)this.getSegmentIndex(window.colMin$mcI$sp(), window.rowMin$mcI$sp()))), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$);
        sorted.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)GeoTiffSegmentLayout.$anonfun$partitionWindowsBySegments$4(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            GeoTiffSegmentLayout.$anonfun$partitionWindowsBySegments$5(partitionCount, partitionSize, maxPartitionSize, partition, partitions, x$2);
            return BoxedUnit.UNIT;
        });
        GeoTiffSegmentLayout.finalizePartition$1(partition, partitions, partitionSize, partitionCount);
        return (GridBounds[][])partitions.result();
    }

    private int bestWindowSize(int maxSize, int segment) {
        int i = 1;
        int result = -1;
        while ((double)i < package$.MODULE$.sqrt((double)segment) && result == -1) {
            if (segment % i == 0 && segment / i <= maxSize) {
                result = segment / i;
            }
            ++i;
        }
        return result == -1 ? maxSize : result;
    }

    public GridBounds<Object>[] listWindows(int maxSize) {
        int colSize;
        int segCols = this.tileLayout().tileCols();
        int segRows = this.tileLayout().tileRows();
        int n = maxSize >= segCols * 2 ? (int)package$.MODULE$.floor((double)maxSize / (double)segCols) * segCols : (colSize = maxSize >= segCols ? segCols : this.bestWindowSize(maxSize, segCols));
        int rowSize = maxSize >= segRows * 2 ? (int)package$.MODULE$.floor((double)maxSize / (double)segRows) * segRows : (maxSize >= segRows ? segRows : this.bestWindowSize(maxSize, segRows));
        GridBounds<Object>[] windows = this.listWindows(colSize, rowSize);
        return windows;
    }

    public GridBounds<Object>[] listWindows(int maxSize, Extent extent, Geometry geometry) {
        int maxColSize;
        int segCols = this.tileLayout().tileCols();
        int segRows = this.tileLayout().tileRows();
        int n = maxSize >= segCols * 2 ? (int)package$.MODULE$.floor((double)maxSize / (double)segCols) * segCols : (maxColSize = maxSize >= segCols ? segCols : this.bestWindowSize(maxSize, segCols));
        int maxRowSize = maxSize >= segRows ? (int)package$.MODULE$.floor((double)maxSize / (double)segRows) * segRows : (maxSize >= segRows ? segRows : this.bestWindowSize(maxSize, segRows));
        Set result = Set$.MODULE$.empty();
        RasterExtent re = RasterExtent$.MODULE$.apply(extent, package$.MODULE$.max(this.totalCols() / maxColSize, 1), package$.MODULE$.max(this.totalRows() / maxRowSize, 1));
        Rasterizer.Options options = new Rasterizer.Options(true, PixelIsArea$.MODULE$);
        Rasterizer$.MODULE$.foreachCellByGeometry(geometry, re, options, (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(col, row) -> result.$plus$eq(GridBounds$.MODULE$.apply(col * maxColSize, row * maxRowSize, package$.MODULE$.min((col + 1) * maxColSize - 1, this.totalCols() - 1), package$.MODULE$.min((row + 1) * maxRowSize - 1, this.totalRows() - 1))));
        return (GridBounds[])result.toArray(ClassTag$.MODULE$.apply(GridBounds.class));
    }

    public GridBounds<Object>[] listWindows(int cols, int rows) {
        ArrayBuilder result = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(GridBounds.class));
        result.sizeHint(this.totalCols() / cols * (this.totalRows() / rows));
        for (int index$macro$2 = 0; index$macro$2 < this.totalCols(); index$macro$2 += cols) {
            for (int index$macro$1 = 0; index$macro$1 < this.totalRows(); index$macro$1 += rows) {
                result.$plus$eq(GridBounds$.MODULE$.apply(index$macro$2, index$macro$1, package$.MODULE$.min(index$macro$2 + cols - 1, this.totalCols() - 1), package$.MODULE$.min(index$macro$1 + rows - 1, this.totalRows() - 1)));
            }
        }
        return (GridBounds[])result.result();
    }

    public int bandSegmentCount() {
        return this.tileLayout().layoutCols() * this.tileLayout().layoutRows();
    }

    public Tuple2<Object, Object> getSegmentCoordinate(int segmentIndex) {
        return new Tuple2.mcII.sp(segmentIndex % this.tileLayout().layoutCols(), segmentIndex / this.tileLayout().layoutCols());
    }

    public Dimensions<Object> getSegmentDimensions(int segmentIndex) {
        int normalizedSegmentIndex = segmentIndex % this.bandSegmentCount();
        int layoutCol = normalizedSegmentIndex % this.tileLayout().layoutCols();
        int layoutRow = normalizedSegmentIndex / this.tileLayout().layoutCols();
        int cols = layoutCol == this.tileLayout().layoutCols() - 1 ? this.totalCols() - (this.tileLayout().layoutCols() - 1) * this.tileLayout().tileCols() : this.tileLayout().tileCols();
        int rows = layoutRow == this.tileLayout().layoutRows() - 1 ? this.totalRows() - (this.tileLayout().layoutRows() - 1) * this.tileLayout().tileRows() : this.tileLayout().tileRows();
        return Dimensions$.MODULE$.apply(cols, rows);
    }

    public GridBounds<Object> getGridBounds(int segmentIndex) {
        int normalizedSegmentIndex = segmentIndex % this.bandSegmentCount();
        Dimensions<Object> dimensions = this.getSegmentDimensions(segmentIndex);
        if (dimensions == null) {
            throw new MatchError(dimensions);
        }
        int segmentCols = dimensions.cols$mcI$sp();
        int segmentRows = dimensions.rows$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(segmentCols, segmentRows);
        Tuple2.mcII.sp sp3 = sp2;
        int segmentCols2 = sp3._1$mcI$sp();
        int segmentRows2 = sp3._2$mcI$sp();
        Tuple2<Object, Object> tuple22 = this.getSegmentCoordinate(normalizedSegmentIndex);
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int layoutCol = tuple22._1$mcI$sp();
        int layoutRow = tuple22._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(layoutCol, layoutRow);
        Tuple2.mcII.sp sp5 = sp4;
        int layoutCol2 = sp5._1$mcI$sp();
        int layoutRow2 = sp5._2$mcI$sp();
        Tuple2.mcII.sp sp6 = new Tuple2.mcII.sp(layoutCol2 * this.tileLayout().tileCols(), layoutRow2 * this.tileLayout().tileRows());
        if (sp6 == null) {
            throw new MatchError((Object)sp6);
        }
        int startCol = sp6._1$mcI$sp();
        int startRow = sp6._2$mcI$sp();
        Tuple2.mcII.sp sp7 = new Tuple2.mcII.sp(startCol, startRow);
        Tuple2.mcII.sp sp8 = sp7;
        int startCol2 = sp8._1$mcI$sp();
        int startRow2 = sp8._2$mcI$sp();
        int endCol = startCol2 + segmentCols2 - 1;
        int endRow = startRow2 + segmentRows2 - 1;
        return GridBounds$.MODULE$.apply(startCol2, startRow2, endCol, endRow);
    }

    public GeoTiffSegmentLayout copy(int totalCols, int totalRows, TileLayout tileLayout, StorageMethod storageMethod, InterleaveMethod interleaveMethod) {
        return new GeoTiffSegmentLayout(totalCols, totalRows, tileLayout, storageMethod, interleaveMethod);
    }

    public int copy$default$1() {
        return this.totalCols();
    }

    public int copy$default$2() {
        return this.totalRows();
    }

    public TileLayout copy$default$3() {
        return this.tileLayout();
    }

    public StorageMethod copy$default$4() {
        return this.storageMethod();
    }

    public InterleaveMethod copy$default$5() {
        return this.interleaveMethod();
    }

    public String productPrefix() {
        return "GeoTiffSegmentLayout";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.totalCols());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.totalRows());
                break;
            }
            case 2: {
                object = this.tileLayout();
                break;
            }
            case 3: {
                object = this.storageMethod();
                break;
            }
            case 4: {
                object = this.interleaveMethod();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GeoTiffSegmentLayout;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.totalCols());
        n = Statics.mix((int)n, (int)this.totalRows());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tileLayout()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.storageMethod()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.interleaveMethod()));
        return Statics.finalizeHash((int)n, (int)5);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GeoTiffSegmentLayout)) return false;
        boolean bl = true;
        if (!bl) return false;
        GeoTiffSegmentLayout geoTiffSegmentLayout = (GeoTiffSegmentLayout)x$1;
        if (this.totalCols() != geoTiffSegmentLayout.totalCols()) return false;
        if (this.totalRows() != geoTiffSegmentLayout.totalRows()) return false;
        TileLayout tileLayout = this.tileLayout();
        TileLayout tileLayout2 = geoTiffSegmentLayout.tileLayout();
        if (tileLayout == null) {
            if (tileLayout2 != null) {
                return false;
            }
        } else if (!((Object)tileLayout).equals(tileLayout2)) return false;
        StorageMethod storageMethod = this.storageMethod();
        StorageMethod storageMethod2 = geoTiffSegmentLayout.storageMethod();
        if (storageMethod == null) {
            if (storageMethod2 != null) {
                return false;
            }
        } else if (!storageMethod.equals(storageMethod2)) return false;
        InterleaveMethod interleaveMethod = this.interleaveMethod();
        InterleaveMethod interleaveMethod2 = geoTiffSegmentLayout.interleaveMethod();
        if (interleaveMethod == null) {
            if (interleaveMethod2 != null) {
                return false;
            }
        } else if (!interleaveMethod.equals(interleaveMethod2)) return false;
        if (!geoTiffSegmentLayout.canEqual(this)) return false;
        return true;
    }

    private static final void finalizePartition$1(ArrayBuilder partition$1, ArrayBuilder partitions$1, LongRef partitionSize$1, LongRef partitionCount$1) {
        GridBounds[] res = (GridBounds[])partition$1.result();
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])res)).nonEmpty() ? partitions$1.$plus$eq((Object)res) : BoxedUnit.UNIT;
        partition$1.clear();
        partitionSize$1.elem = 0L;
        partitionCount$1.elem = 0L;
    }

    private static final void addToPartition$1(GridBounds window, ArrayBuilder partition$1, LongRef partitionSize$1, LongRef partitionCount$1) {
        partition$1.$plus$eq((Object)window);
        partitionSize$1.elem += (long)window.size$mcI$sp();
        ++partitionCount$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$partitionWindowsBySegments$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple22 = check$ifrefutable$1;
        boolean bl = tuple22 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$partitionWindowsBySegments$5(LongRef partitionCount$1, LongRef partitionSize$1, long maxPartitionSize$1, ArrayBuilder partition$1, ArrayBuilder partitions$1, Tuple2 x$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple22 = x$2;
        if (tuple22 != null) {
            GridBounds window = (GridBounds)tuple22._1();
            if (partitionCount$1.elem == 0L || partitionSize$1.elem + (long)window.size$mcI$sp() < maxPartitionSize$1) {
                GeoTiffSegmentLayout.addToPartition$1(window, partition$1, partitionSize$1, partitionCount$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                GeoTiffSegmentLayout.finalizePartition$1(partition$1, partitions$1, partitionSize$1, partitionCount$1);
                GeoTiffSegmentLayout.addToPartition$1(window, partition$1, partitionSize$1, partitionCount$1);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple22);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public GeoTiffSegmentLayout(int totalCols, int totalRows, TileLayout tileLayout, StorageMethod storageMethod, InterleaveMethod interleaveMethod) {
        this.totalCols = totalCols;
        this.totalRows = totalRows;
        this.tileLayout = tileLayout;
        this.storageMethod = storageMethod;
        this.interleaveMethod = interleaveMethod;
        Product.$init$((Product)this);
    }
}

