/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import cats.instances.package$either$;
import cats.instances.package$list$;
import cats.syntax.OptionIdOps$;
import cats.syntax.package$foldable$;
import cats.syntax.package$option$;
import geotrellis.raster.CellSize;
import geotrellis.raster.CellSize$;
import geotrellis.raster.io.geotiff.Auto;
import geotrellis.raster.io.geotiff.AutoHigherResolution$;
import geotrellis.raster.io.geotiff.Base$;
import geotrellis.raster.io.geotiff.Level;
import geotrellis.raster.io.geotiff.OverviewStrategy;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.package$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class OverviewStrategy$ {
    public static OverviewStrategy$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new OverviewStrategy$();
    }

    private Logger logger$lzycompute() {
        OverviewStrategy$ overviewStrategy$ = this;
        synchronized (overviewStrategy$) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger((String)"geotrellis.raster.io.geotiff.OverviewStrategy");
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    private Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public OverviewStrategy DEFAULT() {
        return AutoHigherResolution$.MODULE$;
    }

    public int selectOverview(List<CellSize> overviewCS, CellSize desiredCS, OverviewStrategy strategy) {
        int n;
        OverviewStrategy overviewStrategy = strategy;
        if (overviewStrategy instanceof Level) {
            int overviewIdx;
            Level level = (Level)overviewStrategy;
            n = overviewIdx = level.overviewLevel();
        } else if (overviewStrategy instanceof Auto) {
            Auto auto2 = (Auto)overviewStrategy;
            int n2 = auto2.n();
            n = this.selectIndexByProximity(overviewCS, desiredCS, 0.5) + n2;
        } else if (Base$.MODULE$.equals(overviewStrategy)) {
            n = overviewCS.indexOf(overviewCS.min(CellSize$.MODULE$.cellsizeOrdering()));
        } else if (AutoHigherResolution$.MODULE$.equals(overviewStrategy)) {
            int idx = this.selectIndexByProximity(overviewCS, desiredCS, 1.0);
            n = idx > overviewCS.size() ? idx - 1 : idx;
        } else {
            throw new MatchError((Object)overviewStrategy);
        }
        int maybeIndex = n;
        return maybeIndex < 0 ? 0 : (maybeIndex >= overviewCS.size() ? overviewCS.size() - 1 : maybeIndex);
    }

    private int selectIndexByProximity(List<CellSize> overviewCS, CellSize desiredCS, double proximityThreshold) {
        int idx;
        Some some;
        Tuple2 tuple22;
        Left left;
        Option option2;
        int idx2;
        Some some2;
        Tuple2 tuple23;
        Right right;
        Option option3;
        Either either2 = (Either)package$foldable$.MODULE$.toFoldableOps(overviewCS.zipWithIndex(List$.MODULE$.canBuildFrom()), package$list$.MODULE$.catsStdInstancesForList()).foldLeftM(Option$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Right right;
            Some some;
            Tuple2 tuple22;
            Tuple2 tuple23 = new Tuple2(x0$1, x1$1);
            if (tuple23 == null) throw new MatchError((Object)tuple23);
            Option acc = (Option)tuple23._1();
            Tuple2 r = (Tuple2)tuple23._2();
            if (r == null) throw new MatchError((Object)tuple23);
            CellSize rightCZ = (CellSize)r._1();
            Option option2 = acc;
            if (option2 instanceof Some && (tuple22 = (Tuple2)(some = (Some)option2).value()) != null) {
                Object object;
                CellSize leftCZ = (CellSize)tuple22._1();
                double proportion = 1.0 - (rightCZ.resolution() - desiredCS.resolution()) / (rightCZ.resolution() - leftCZ.resolution());
                if (package$.MODULE$.Ordering().apply(CellSize$.MODULE$.cellsizeOrdering()).compare((Object)rightCZ, (Object)leftCZ) < 0) {
                    if (MODULE$.logger().isDebugEnabled()) {
                        MODULE$.logger().debug(new StringBuilder(39).append("The input list ").append(overviewCS).append(" is probably not sorted.").toString());
                    }
                    object = package$.MODULE$.Left().apply(package$option$.MODULE$.none());
                } else {
                    object = proportion >= proximityThreshold ? package$.MODULE$.Right().apply(OptionIdOps$.MODULE$.some$extension(package$option$.MODULE$.catsSyntaxOptionId(r))) : package$.MODULE$.Left().apply((Object)some);
                }
                right = object;
                return right;
            } else {
                if (!None$.MODULE$.equals(option2)) throw new MatchError((Object)option2);
                right = package$.MODULE$.Right().apply(OptionIdOps$.MODULE$.some$extension(package$option$.MODULE$.catsSyntaxOptionId(r)));
            }
            return right;
        }, package$either$.MODULE$.catsStdInstancesForEither());
        int n = either2 instanceof Right && (option3 = (Option)(right = (Right)either2).value()) instanceof Some && (tuple23 = (Tuple2)(some2 = (Some)option3).value()) != null ? (idx2 = tuple23._2$mcI$sp()) : (either2 instanceof Left && (option2 = (Option)(left = (Left)either2).value()) instanceof Some && (tuple22 = (Tuple2)(some = (Some)option2).value()) != null ? (idx = tuple22._2$mcI$sp()) : -1);
        return n;
    }

    private OverviewStrategy$() {
        MODULE$ = this;
    }
}

