/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.resample;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DoubleConstantNoDataArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.resample.BilinearResample;
import geotrellis.vector.Extent;
import scala.Array$;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple4;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\u00114Q!\u0004\b\u0002\u0002UA\u0001B\u0007\u0001\u0003\u0002\u0003\u0006Ia\u0007\u0005\t?\u0001\u0011\t\u0011)A\u0005A!Aa\u0005\u0001B\u0001B\u0003%q\u0005C\u0003.\u0001\u0011\u0005a\u0006C\u00044\u0001\t\u0007I\u0011\u0002\u001b\t\ra\u0002\u0001\u0015!\u00036\u0011\u0015I\u0004A\"\u0005;\u0011\u0015!\u0005\u0001\"\u0003F\u0011\u0015\u0011\u0006\u0001\"\u0003T\u0011\u0015A\u0006\u0001\"\u0003Z\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015\u0001\u0007\u0001\"\u0011b\u00055\u0019UOY5d%\u0016\u001c\u0018-\u001c9mK*\u0011q\u0002E\u0001\te\u0016\u001c\u0018-\u001c9mK*\u0011\u0011CE\u0001\u0007e\u0006\u001cH/\u001a:\u000b\u0003M\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u0019\"\u0001\u0001\f\u0011\u0005]AR\"\u0001\b\n\u0005eq!\u0001\u0005\"jY&tW-\u0019:SKN\fW\u000e\u001d7f\u0003\u0011!\u0018\u000e\\3\u0011\u0005qiR\"\u0001\t\n\u0005y\u0001\"\u0001\u0002+jY\u0016\fa!\u001a=uK:$\bCA\u0011%\u001b\u0005\u0011#BA\u0012\u0013\u0003\u00191Xm\u0019;pe&\u0011QE\t\u0002\u0007\u000bb$XM\u001c;\u0002\u0013\u0011LW.\u001a8tS>t\u0007C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#aA%oi\u00061A(\u001b8jiz\"Ba\f\u00192eA\u0011q\u0003\u0001\u0005\u00065\u0011\u0001\ra\u0007\u0005\u0006?\u0011\u0001\r\u0001\t\u0005\u0006M\u0011\u0001\raJ\u0001\nGV\u0014\u0017n\u0019+jY\u0016,\u0012!\u000e\t\u00039YJ!a\u000e\t\u0003;\u0011{WO\u00197f\u0007>t7\u000f^1oi:{G)\u0019;b\u0003J\u0014\u0018-\u001f+jY\u0016\f!bY;cS\u000e$\u0016\u000e\\3!\u00035\u0019WOY5d%\u0016\u001c\u0018-\u001c9mKR!1H\u0010!C!\tAC(\u0003\u0002>S\t1Ai\\;cY\u0016DQaP\u0004A\u0002m\t\u0011\u0001\u001e\u0005\u0006\u0003\u001e\u0001\raO\u0001\u0002q\")1i\u0002a\u0001w\u0005\t\u00110\u0001\btKR\u001cUOY5d-\u0006dW/Z:\u0015\t\u0019K5*\u0014\t\u0003Q\u001dK!\u0001S\u0015\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0015\"\u0001\raJ\u0001\bY\u00164GoQ8m\u0011\u0015a\u0005\u00021\u0001(\u0003\u0019!x\u000e\u001d*po\")a\n\u0003a\u0001\u001f\u0006\ta\rE\u0003)!\u001e:3(\u0003\u0002RS\tIa)\u001e8di&|gNM\u0001\u0007O\u0016$H/\u001a:\u0015\u0007\u001d\"f\u000bC\u0003V\u0013\u0001\u0007q%A\u0002d_2DQaV\u0005A\u0002\u001d\n1A]8x\u000319W\r\u001e;fe\u0012{WO\u00197f)\rY$l\u0017\u0005\u0006+*\u0001\ra\n\u0005\u0006/*\u0001\raJ\u0001\u000ee\u0016\u001c\u0018-\u001c9mKZ\u000bG.\u001b3\u0015\u0007\u001drv\fC\u0003B\u0017\u0001\u00071\bC\u0003D\u0017\u0001\u00071(A\nsKN\fW\u000e\u001d7f\t>,(\r\\3WC2LG\rF\u0002<E\u000eDQ!\u0011\u0007A\u0002mBQa\u0011\u0007A\u0002m\u0002")
public abstract class CubicResample
extends BilinearResample {
    private final Tile tile;
    private final int dimension;
    private final DoubleConstantNoDataArrayTile cubicTile;

    private DoubleConstantNoDataArrayTile cubicTile() {
        return this.cubicTile;
    }

    public abstract double cubicResample(Tile var1, double var2, double var4);

    private void setCubicValues(int leftCol, int topRow, Function2<Object, Object, Object> f) {
        int offset = this.dimension / 2;
        for (int index$macro$2 = 0; index$macro$2 < this.dimension; ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.dimension; ++index$macro$1) {
                double v = f.apply$mcDII$sp(leftCol - offset + 1 + index$macro$1, topRow - offset + 1 + index$macro$2);
                this.cubicTile().setDouble(index$macro$1, index$macro$2, v);
            }
        }
    }

    private int getter(int col, int row) {
        return col >= this.cols() && row >= this.rows() ? this.tile.get(this.cols() - 1, this.rows() - 1) : (col >= this.cols() && row < 0 ? this.tile.get(this.cols() - 1, 0) : (col < 0 && row >= this.rows() ? this.tile.get(0, this.rows() - 1) : (col < 0 && row < 0 ? this.tile.get(0, 0) : (col < 0 ? this.tile.get(0, row) : (col >= this.cols() ? this.tile.get(this.cols() - 1, row) : (row < 0 ? this.tile.get(col, 0) : (row >= this.rows() ? this.tile.get(col, this.rows() - 1) : this.tile.get(col, row))))))));
    }

    private double getterDouble(int col, int row) {
        return col >= this.cols() && row >= this.rows() ? this.tile.getDouble(this.cols() - 1, this.rows() - 1) : (col >= this.cols() && row < 0 ? this.tile.getDouble(this.cols() - 1, 0) : (col < 0 && row >= this.rows() ? this.tile.getDouble(0, this.rows() - 1) : (col < 0 && row < 0 ? this.tile.getDouble(0, 0) : (col < 0 ? this.tile.getDouble(0, row) : (col >= this.cols() ? this.tile.getDouble(this.cols() - 1, row) : (row < 0 ? this.tile.getDouble(col, 0) : (row >= this.rows() ? this.tile.getDouble(col, this.rows() - 1) : this.tile.getDouble(col, row))))))));
    }

    @Override
    public int resampleValid(double x, double y) {
        Tuple4<Object, Object, Object, Object> tuple42 = this.resolveTopLeftCoordsAndRatios(x, y);
        if (tuple42 == null) {
            throw new MatchError(tuple42);
        }
        int leftCol = BoxesRunTime.unboxToInt((Object)tuple42._1());
        int topRow = BoxesRunTime.unboxToInt((Object)tuple42._2());
        double xRatio = BoxesRunTime.unboxToDouble((Object)tuple42._3());
        double yRatio = BoxesRunTime.unboxToDouble((Object)tuple42._4());
        Tuple4 tuple43 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)leftCol), (Object)BoxesRunTime.boxToInteger((int)topRow), (Object)BoxesRunTime.boxToDouble((double)xRatio), (Object)BoxesRunTime.boxToDouble((double)yRatio));
        Tuple4 tuple44 = tuple43;
        int leftCol2 = BoxesRunTime.unboxToInt((Object)tuple44._1());
        int topRow2 = BoxesRunTime.unboxToInt((Object)tuple44._2());
        double xRatio2 = BoxesRunTime.unboxToDouble((Object)tuple44._3());
        double yRatio2 = BoxesRunTime.unboxToDouble((Object)tuple44._4());
        this.setCubicValues(leftCol2, topRow2, (Function2<Object, Object, Object>)(JFunction2.mcDII.sp & java.io.Serializable & Serializable)(col, row) -> this.getter(col, row));
        return (int)RichDouble$.MODULE$.round$extension(Predef$.MODULE$.doubleWrapper(this.cubicResample(this.cubicTile(), xRatio2, yRatio2)));
    }

    @Override
    public double resampleDoubleValid(double x, double y) {
        Tuple4<Object, Object, Object, Object> tuple42 = this.resolveTopLeftCoordsAndRatios(x, y);
        if (tuple42 == null) {
            throw new MatchError(tuple42);
        }
        int leftCol = BoxesRunTime.unboxToInt((Object)tuple42._1());
        int topRow = BoxesRunTime.unboxToInt((Object)tuple42._2());
        double xRatio = BoxesRunTime.unboxToDouble((Object)tuple42._3());
        double yRatio = BoxesRunTime.unboxToDouble((Object)tuple42._4());
        Tuple4 tuple43 = new Tuple4((Object)BoxesRunTime.boxToInteger((int)leftCol), (Object)BoxesRunTime.boxToInteger((int)topRow), (Object)BoxesRunTime.boxToDouble((double)xRatio), (Object)BoxesRunTime.boxToDouble((double)yRatio));
        Tuple4 tuple44 = tuple43;
        int leftCol2 = BoxesRunTime.unboxToInt((Object)tuple44._1());
        int topRow2 = BoxesRunTime.unboxToInt((Object)tuple44._2());
        double xRatio2 = BoxesRunTime.unboxToDouble((Object)tuple44._3());
        double yRatio2 = BoxesRunTime.unboxToDouble((Object)tuple44._4());
        this.setCubicValues(leftCol2, topRow2, (Function2<Object, Object, Object>)(JFunction2.mcDII.sp & java.io.Serializable & Serializable)(col, row) -> this.getterDouble(col, row));
        return this.cubicResample(this.cubicTile(), xRatio2, yRatio2);
    }

    public CubicResample(Tile tile, Extent extent, int dimension) {
        this.tile = tile;
        this.dimension = dimension;
        super(tile, extent);
        this.cubicTile = ArrayTile$.MODULE$.apply((double[])Array$.MODULE$.ofDim(dimension * dimension, ClassTag$.MODULE$.Double()), dimension, dimension);
    }
}

