/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.BitCellType$;
import geotrellis.raster.BitConstantTile;
import geotrellis.raster.ByteCells;
import geotrellis.raster.ByteConstantTile;
import geotrellis.raster.ConstantTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCells;
import geotrellis.raster.DoubleConstantTile;
import geotrellis.raster.FloatCells;
import geotrellis.raster.FloatConstantTile;
import geotrellis.raster.IntCells;
import geotrellis.raster.IntConstantTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.NoDataHandling;
import geotrellis.raster.ShortCells;
import geotrellis.raster.ShortConstantTile;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCells;
import geotrellis.raster.UByteConstantTile;
import geotrellis.raster.UShortCells;
import geotrellis.raster.UShortConstantTile;
import geotrellis.raster.package$;
import geotrellis.raster.package$DoubleArrayFiller$;
import geotrellis.raster.package$IntArrayFiller$;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed!B\u000e\u001d\u0003\u0003\t\u0003\"\u0002\u0014\u0001\t\u00039\u0003\"B\u0015\u0001\r\u0003Q\u0003\"B\u0019\u0001\r\u0003Q\u0003b\u0002\u001a\u0001\u0005\u00045\tB\u000b\u0005\bg\u0001\u0011\rQ\"\u00055\u0011\u0015A\u0004\u0001\"\u0001:\u0011\u0015q\u0004\u0001\"\u0001@\u0011\u0015\u0011\u0005\u0001\"\u0001D\u0011\u00159\u0005\u0001\"\u0001I\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u0015I\u0006\u0001\"\u0001[\u0011\u0015\u0019\u0007\u0001\"\u0001e\u0011\u00159\u0007\u0001\"\u0001i\u0011\u0015q\u0007\u0001\"\u0001p\u0011\u0015!\bA\"\u0001v\u0011\u0015A\b\u0001\"\u0001z\u0011\u001d\t\u0019\u0001\u0001D\u0001\u0003\u000bAq!a\u0003\u0001\t\u0003\ti\u0001C\u0004\u0002\u0018\u0001!\t!!\u0007\t\u000f\u0005\u0015\u0002\u0001\"\u0001\u0002(\u001d9\u0011\u0011\u0007\u000f\t\u0002\u0005MbAB\u000e\u001d\u0011\u0003\t)\u0004\u0003\u0004'/\u0011\u0005\u00111\t\u0005\b\u0003\u000b:B\u0011AA$\u0011%\tifFA\u0001\n\u0013\tyF\u0001\u0007D_:\u001cH/\u00198u)&dWM\u0003\u0002\u001e=\u00051!/Y:uKJT\u0011aH\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\n\u0003\u0001\t\u0002\"a\t\u0013\u000e\u0003qI!!\n\u000f\u0003\tQKG.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003!\u0002\"a\t\u0001\u0002\t\r|Gn]\u000b\u0002WA\u0011AfL\u0007\u0002[)\ta&A\u0003tG\u0006d\u0017-\u0003\u00021[\t\u0019\u0011J\u001c;\u0002\tI|wo]\u0001\u0005SZ\u000bG.\u0001\u0003e-\u0006dW#A\u001b\u0011\u000512\u0014BA\u001c.\u0005\u0019!u.\u001e2mK\u0006\u0019q-\u001a;\u0015\u0007-RD\bC\u0003<\r\u0001\u00071&A\u0002d_2DQ!\u0010\u0004A\u0002-\n1A]8x\u0003%9W\r\u001e#pk\ndW\rF\u00026\u0001\u0006CQaO\u0004A\u0002-BQ!P\u0004A\u0002-\nq\u0001^8BeJ\f\u0017\u0010F\u0001E!\raSiK\u0005\u0003\r6\u0012Q!\u0011:sCf\fQ\u0002^8BeJ\f\u0017\u0010R8vE2,G#A%\u0011\u00071*U'A\u0004d_:4XM\u001d;\u0015\u0005\tb\u0005\"B'\u000b\u0001\u0004q\u0015a\u00028foRK\b/\u001a\t\u0003\u001fJs!a\t)\n\u0005Ec\u0012a\u00029bG.\fw-Z\u0005\u0003'R\u0013\u0001bQ3mYRK\b/\u001a\u0006\u0003#r\t1\"\u001b8uKJ\u0004(/\u001a;BgR\u0011!e\u0016\u0005\u00061.\u0001\rAT\u0001\f]\u0016<8)\u001a7m)f\u0004X-A\u0004g_J,\u0017m\u00195\u0015\u0005ms\u0006C\u0001\u0017]\u0013\tiVF\u0001\u0003V]&$\b\"B0\r\u0001\u0004\u0001\u0017!\u00014\u0011\t1\n7fW\u0005\u0003E6\u0012\u0011BR;oGRLwN\\\u0019\u0002\u001b\u0019|'/Z1dQ\u0012{WO\u00197f)\tYV\rC\u0003`\u001b\u0001\u0007a\r\u0005\u0003-CVZ\u0016!\u00054pe\u0016\f7\r[%oiZK7/\u001b;peR\u00111,\u001b\u0005\u0006U:\u0001\ra[\u0001\bm&\u001c\u0018\u000e^8s!\tyE.\u0003\u0002n)\nq\u0011J\u001c;US2,g+[:ji>\u0014\u0018\u0001\u00064pe\u0016\f7\r\u001b#pk\ndWMV5tSR|'\u000f\u0006\u0002\\a\")!n\u0004a\u0001cB\u0011qJ]\u0005\u0003gR\u0013\u0011\u0003R8vE2,G+\u001b7f-&\u001c\u0018\u000e^8s\u0003\ri\u0017\r\u001d\u000b\u0003EYDQa\u0018\tA\u0002]\u0004B\u0001L1,W\u000591m\\7cS:,GC\u0001>\u0000)\t\u00113\u0010C\u0003`#\u0001\u0007A\u0010E\u0003-{.Z3&\u0003\u0002\u007f[\tIa)\u001e8di&|gN\r\u0005\u0007\u0003\u0003\t\u0002\u0019\u0001\u0012\u0002\u000b=$\b.\u001a:\u0002\u00135\f\u0007\u000fR8vE2,Gc\u0001\u0012\u0002\b!1qL\u0005a\u0001\u0003\u0013\u0001B\u0001L16k\u0005i1m\\7cS:,Gi\\;cY\u0016$B!a\u0004\u0002\u0016Q\u0019!%!\u0005\t\r}\u001b\u0002\u0019AA\n!\u0015aS0N\u001b6\u0011\u0019\t\ta\u0005a\u0001E\u0005aQ.\u00199J]Rl\u0015\r\u001d9feR\u0019!%a\u0007\t\u000f\u0005uA\u00031\u0001\u0002 \u00051Q.\u00199qKJ\u00042aTA\u0011\u0013\r\t\u0019\u0003\u0016\u0002\u000e\u0013:$H+\u001b7f\u001b\u0006\u0004\b/\u001a:\u0002\u001f5\f\u0007\u000fR8vE2,W*\u00199qKJ$2AIA\u0015\u0011\u001d\ti\"\u0006a\u0001\u0003W\u00012aTA\u0017\u0013\r\ty\u0003\u0016\u0002\u0011\t>,(\r\\3US2,W*\u00199qKJ\fAbQ8ogR\fg\u000e\u001e+jY\u0016\u0004\"aI\f\u0014\u000b]\t9$!\u0010\u0011\u00071\nI$C\u0002\u0002<5\u0012a!\u00118z%\u00164\u0007c\u0001\u0017\u0002@%\u0019\u0011\u0011I\u0017\u0003\u0019M+'/[1mSj\f'\r\\3\u0015\u0005\u0005M\u0012!\u00034s_6\u0014\u0015\u0010^3t)%A\u0013\u0011JA+\u00033\nY\u0006C\u0004\u0002Le\u0001\r!!\u0014\u0002\u000b\tLH/Z:\u0011\t1*\u0015q\n\t\u0004Y\u0005E\u0013bAA*[\t!!)\u001f;f\u0011\u0019\t9&\u0007a\u0001\u001d\u0006\tA\u000fC\u0003*3\u0001\u00071\u0006C\u000323\u0001\u00071&A\u0006sK\u0006$'+Z:pYZ,GCAA1!\u0011\t\u0019'!\u001c\u000e\u0005\u0005\u0015$\u0002BA4\u0003S\nA\u0001\\1oO*\u0011\u00111N\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002p\u0005\u0015$AB(cU\u0016\u001cG\u000f")
public abstract class ConstantTile
extends Tile {
    public static ConstantTile fromBytes(byte[] byArray, DataType dataType, int n, int n2) {
        return ConstantTile$.MODULE$.fromBytes(byArray, dataType, n, n2);
    }

    @Override
    public abstract int cols();

    @Override
    public abstract int rows();

    public abstract int iVal();

    public abstract double dVal();

    @Override
    public int get(int col, int row) {
        return this.iVal();
    }

    @Override
    public double getDouble(int col, int row) {
        return this.dVal();
    }

    @Override
    public int[] toArray() {
        return package$IntArrayFiller$.MODULE$.fill$extension(package$.MODULE$.IntArrayFiller((int[])Array$.MODULE$.ofDim(this.cols$mcI$sp() * this.rows$mcI$sp(), ClassTag$.MODULE$.Int())), this.iVal());
    }

    @Override
    public double[] toArrayDouble() {
        return package$DoubleArrayFiller$.MODULE$.fill$extension(package$.MODULE$.DoubleArrayFiller((double[])Array$.MODULE$.ofDim(this.cols$mcI$sp() * this.rows$mcI$sp(), ClassTag$.MODULE$.Double())), this.dVal());
    }

    @Override
    public Tile convert(DataType newType) {
        ConstantTile constantTile;
        DataType dataType = newType;
        if (BitCellType$.MODULE$.equals(dataType)) {
            constantTile = new BitConstantTile(this.iVal() != 0, this.cols$mcI$sp(), this.rows$mcI$sp());
        } else if (dataType instanceof ByteCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new ByteConstantTile((byte)this.iVal(), this.cols$mcI$sp(), this.rows$mcI$sp(), (ByteCells)((Object)noDataHandling));
        } else if (dataType instanceof UByteCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new UByteConstantTile((byte)this.iVal(), this.cols$mcI$sp(), this.rows$mcI$sp(), (UByteCells)((Object)noDataHandling));
        } else if (dataType instanceof ShortCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new ShortConstantTile((short)this.iVal(), this.cols$mcI$sp(), this.rows$mcI$sp(), (ShortCells)((Object)noDataHandling));
        } else if (dataType instanceof UShortCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new UShortConstantTile((short)this.iVal(), this.cols$mcI$sp(), this.rows$mcI$sp(), (UShortCells)((Object)noDataHandling));
        } else if (dataType instanceof IntCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new IntConstantTile(this.iVal(), this.cols$mcI$sp(), this.rows$mcI$sp(), (IntCells)((Object)noDataHandling));
        } else if (dataType instanceof FloatCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new FloatConstantTile((float)this.dVal(), this.cols$mcI$sp(), this.rows$mcI$sp(), (FloatCells)((Object)noDataHandling));
        } else if (dataType instanceof DoubleCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new DoubleConstantTile(this.dVal(), this.cols$mcI$sp(), this.rows$mcI$sp(), (DoubleCells)((Object)noDataHandling));
        } else {
            throw new MatchError((Object)dataType);
        }
        return constantTile;
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        return this.withNoData((Option<Object>)None$.MODULE$).convert(newCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        int len = BoxesRunTime.unboxToInt(this.size());
        for (int i = 0; i < len; ++i) {
            f.apply$mcVI$sp(this.iVal());
        }
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        int len = BoxesRunTime.unboxToInt(this.size());
        for (int i = 0; i < len; ++i) {
            f.apply$mcVD$sp(this.dVal());
        }
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                visitor.apply(index$macro$1, index$macro$2, this.iVal());
            }
        }
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                visitor.apply(index$macro$1, index$macro$2, this.dVal());
            }
        }
    }

    @Override
    public abstract Tile map(Function1<Object, Object> var1);

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return other.map((Function1<Object, Object>)(JFunction1.mcII.sp & Serializable & scala.Serializable)z -> f.apply$mcIII$sp(this.iVal(), z));
    }

    @Override
    public abstract Tile mapDouble(Function1<Object, Object> var1);

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return other.mapDouble((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)z -> f.apply$mcDDD$sp(this.dVal(), z));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols$mcI$sp(), this.rows$mcI$sp());
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                tile.set(index$macro$1, index$macro$2, mapper.apply(index$macro$1, index$macro$2, this.get(index$macro$1, index$macro$2)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols$mcI$sp(), this.rows$mcI$sp());
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                tile.setDouble(index$macro$1, index$macro$2, mapper.apply(index$macro$1, index$macro$2, this.getDouble(index$macro$1, index$macro$2)));
            }
        }
        return var2_2;
    }

    @Override
    public int cols$mcI$sp() {
        return this.cols();
    }

    @Override
    public int rows$mcI$sp() {
        return this.rows();
    }
}

