/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import scala.Array$;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.io.BufferedSource;
import scala.io.Source$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class Filesystem$ {
    public static Filesystem$ MODULE$;

    static {
        new Filesystem$();
    }

    public boolean exists(String path) {
        return Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
    }

    public ByteBuffer toMappedByteBuffer(String path) {
        File f = new File(path);
        FileInputStream fis = new FileInputStream(f);
        int size = (int)f.length();
        FileChannel channel = fis.getChannel();
        MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, size);
        channel.close();
        fis.close();
        return buffer;
    }

    public byte[] slurp(String path, int bs) {
        ByteBuffer buffer = this.toMappedByteBuffer(path);
        int i = 0;
        byte[] data = (byte[])Array$.MODULE$.ofDim(buffer.capacity(), ClassTag$.MODULE$.Byte());
        while (buffer.hasRemaining()) {
            int n = package$.MODULE$.min(buffer.remaining(), bs);
            buffer.get(data, i, n);
            i += n;
        }
        return data;
    }

    public int slurp$default$2() {
        return 262144;
    }

    public void mapToByteArray(String path, byte[] data, int startIndex, int size) {
        MappedByteBuffer mappedByteBuffer;
        File f = new File(path);
        try (FileInputStream fis = new FileInputStream(f);){
            FileChannel channel = fis.getChannel();
            mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, startIndex, size);
        }
        MappedByteBuffer buffer = mappedByteBuffer;
        buffer.get(data, startIndex, size);
    }

    public String basename(String path) {
        String string2;
        int n = path.lastIndexOf(".");
        switch (n) {
            case -1: {
                string2 = path;
                break;
            }
            default: {
                string2 = path.substring(0, n);
                break;
            }
        }
        return string2;
    }

    public Tuple2<String, String> split(String path) {
        Tuple2 tuple22;
        int n = path.lastIndexOf(".");
        switch (n) {
            case -1: {
                tuple22 = new Tuple2((Object)path, (Object)"");
                break;
            }
            default: {
                tuple22 = new Tuple2((Object)path.substring(0, n), (Object)path.substring(n + 1, path.length()));
                break;
            }
        }
        return tuple22;
    }

    public String join(Seq<String> parts) {
        return parts.mkString(File.separator);
    }

    public String readText(String path) {
        String string2;
        try (BufferedSource src = Source$.MODULE$.fromFile(path, "UTF-8");){
            string2 = src.mkString();
        }
        return string2;
    }

    public String readText(File file) {
        return this.readText(file.getAbsolutePath());
    }

    public void writeBytes(String path, byte[] bytes) {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path));
        bos.write(bytes);
        bos.close();
    }

    public void writeText(String path, String text) {
        Files.write(Paths.get(path, new String[0]), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public void writeText(File file, String text) {
        this.writeText(file.getAbsolutePath(), text);
    }

    public void move(String source, String target) {
        Files.move(Paths.get(source, new String[0]), Paths.get(target, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    public void move(File source, File target) {
        this.move(source.getAbsolutePath(), target.getAbsolutePath());
    }

    public void copy(String source, String target) {
        Files.copy(Paths.get(source, new String[0]), Paths.get(target, new String[0]), StandardCopyOption.REPLACE_EXISTING);
    }

    public void copy(File source, File target) {
        this.copy(source.getAbsolutePath(), target.getAbsolutePath());
    }

    public String ensureDirectory(String path) {
        Boolean bl;
        File f = new File(path);
        if (f.exists()) {
            Predef$.MODULE$.require(f.isDirectory(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append(f).append(" exists and is not a directory").toString());
            bl = BoxedUnit.UNIT;
        } else {
            bl = BoxesRunTime.boxToBoolean((boolean)f.mkdirs());
        }
        return path;
    }

    private Filesystem$() {
        MODULE$ = this;
    }
}

