/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.BufferTile$;
import geotrellis.raster.CellSize;
import geotrellis.raster.DataType;
import geotrellis.raster.GeoAttrsError;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridBounds$mcI$sp;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.BufferTileFocalMethods;
import geotrellis.raster.mapalgebra.focal.Kernel;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import geotrellis.raster.mapalgebra.focal.TargetCell;
import geotrellis.raster.package$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import spire.math.Integral;
import spire.math.Integral$;

@ScalaSignature(bytes="\u0006\u0001\t}g\u0001\u0002\"D\u0001\"C\u0001B\u0016\u0001\u0003\u0016\u0004%\ta\u0016\u0005\t1\u0002\u0011\t\u0012)A\u0005\u0013\"A\u0011\f\u0001BK\u0002\u0013\u0005!\f\u0003\u0005b\u0001\tE\t\u0015!\u0003\\\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u001d9\u0007A1A\u0005\u0002!Da!\u001b\u0001!\u0002\u0013q\u0006b\u00026\u0001\u0005\u0004%\t\u0001\u001b\u0005\u0007W\u0002\u0001\u000b\u0011\u00020\t\u000f1\u0004!\u0019!C\u0001[\"1Q\u000f\u0001Q\u0001\n9DQA\u001e\u0001\u0005\n!DQa\u001e\u0001\u0005\n!DQ\u0001\u001f\u0001\u0005\n!DQ!\u001f\u0001\u0005\n!DQA\u001f\u0001\u0005\u0002!DQa\u001f\u0001\u0005\u0002!DQ\u0001 \u0001\u0005\u0002!DQ! \u0001\u0005\u0002!DQA \u0001\u0005\u0002}Dq!!\u0002\u0001\t\u0003\t9\u0001C\u0004\u0002\u001a\u0001!\t!a\u0007\t\u000f\u0005\u0005\u0002\u0001\"\u0001\u0002$!9\u0011Q\u0006\u0001\u0005\u0002\u0005=\u0002bBA\u001b\u0001\u0011\u0005\u0011q\u0007\u0005\b\u0003\u007f\u0001A\u0011AA!\u0011\u001d\ty\u0004\u0001C\u0001\u0003\u0013Bq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002X\u0001!\t!!\u0017\t\u000f\u0005u\u0003\u0001\"\u0001\u0002`!9\u0011\u0011\u000e\u0001\u0005\u0002\u0005-\u0004bBA?\u0001\u0011\u0005\u0011q\u0010\u0005\b\u0003\u000b\u0003A\u0011AAD\u0011\u001d\t\u0019\n\u0001C\u0001\u0003+Cq!a(\u0001\t\u0003\t\t\u000bC\u0004\u0002(\u0002!\t!!+\t\u000f\u0005=\u0006\u0001\"\u0001\u00022\"9\u0011Q\u0018\u0001\u0005\u0002\u0005}\u0006bBAe\u0001\u0011\u0005\u00111\u001a\u0005\b\u00037\u0004A\u0011AAo\u0011\u001d\tI\r\u0001C\u0001\u0003ODq!a7\u0001\t\u0003\ty\u000fC\u0004\u0002x\u0002!\t!!?\t\u000f\u0005}\b\u0001\"\u0011\u0003\u0002!I!\u0011\u0004\u0001\u0002\u0002\u0013\u0005!1\u0004\u0005\n\u0005C\u0001\u0011\u0013!C\u0001\u0005GA\u0011B!\u000f\u0001#\u0003%\tAa\u000f\t\u0013\t}\u0002!!A\u0005B\t\u0005\u0003\u0002\u0003B)\u0001\u0005\u0005I\u0011\u00015\t\u0013\tM\u0003!!A\u0005\u0002\tU\u0003\"\u0003B1\u0001\u0005\u0005I\u0011\tB2\u0011%\u0011\t\bAA\u0001\n\u0003\u0011\u0019\bC\u0005\u0003~\u0001\t\t\u0011\"\u0011\u0003\u0000!I!\u0011\u0011\u0001\u0002\u0002\u0013\u0005#1Q\u0004\b\u0005\u000f\u001b\u0005\u0012\u0001BE\r\u0019\u00115\t#\u0001\u0003\f\"1!\r\u000fC\u0001\u0005'3aA!&9\u0003\t]\u0005B\u0003BUu\t\u0015\r\u0011\"\u0001\u0003,\"I!Q\u0016\u001e\u0003\u0002\u0003\u0006I\u0001\u001a\u0005\u0007Ej\"\tAa,\t\u0013\t]\u0006(!A\u0005\u0004\te\u0006\"\u0003B_q\u0005\u0005I\u0011\u0011B`\u0011%\u0011)\rOA\u0001\n\u0003\u00139\rC\u0005\u0003Vb\n\t\u0011\"\u0003\u0003X\nQ!)\u001e4gKJ$\u0016\u000e\\3\u000b\u0005\u0011+\u0015A\u0002:bgR,'OC\u0001G\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\u0011\u0001\u0011*T*\u0011\u0005)[U\"A\"\n\u00051\u001b%\u0001\u0002+jY\u0016\u0004\"AT)\u000e\u0003=S\u0011\u0001U\u0001\u0006g\u000e\fG.Y\u0005\u0003%>\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002O)&\u0011Qk\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u000bg>,(oY3US2,W#A%\u0002\u0017M|WO]2f)&dW\rI\u0001\u000bOJLGMQ8v]\u0012\u001cX#A.\u0011\u0007)cf,\u0003\u0002^\u0007\nQqI]5e\u0005>,h\u000eZ:\u0011\u00059{\u0016B\u00011P\u0005\rIe\u000e^\u0001\fOJLGMQ8v]\u0012\u001c\b%\u0001\u0004=S:LGO\u0010\u000b\u0004I\u00164\u0007C\u0001&\u0001\u0011\u00151V\u00011\u0001J\u0011\u0015IV\u00011\u0001\\\u0003\u0011\u0019w\u000e\\:\u0016\u0003y\u000bQaY8mg\u0002\nAA]8xg\u0006)!o\\<tA\u0005A1-\u001a7m)f\u0004X-F\u0001o!\ty'O\u0004\u0002Ka&\u0011\u0011oQ\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0019HO\u0001\u0005DK2dG+\u001f9f\u0015\t\t8)A\u0005dK2dG+\u001f9fA\u000511m\u001c7NS:\faA]8x\u001b&t\u0017AC:pkJ\u001cWmQ8mg\u0006Q1o\\;sG\u0016\u0014vn^:\u0002\u0013\t,hMZ3s)>\u0004\u0018A\u00032vM\u001a,'\u000fT3gi\u0006Y!-\u001e4gKJ\u0014\u0016n\u001a5u\u00031\u0011WO\u001a4fe\n{G\u000f^8n\u0003\u001d\u0019wN\u001c<feR$2!SA\u0001\u0011\u0019\t\u0019\u0001\u0006a\u0001]\u0006qA/\u0019:hKR\u001cU\r\u001c7UsB,\u0017AC<ji\"tu\u000eR1uCR\u0019A-!\u0003\t\u000f\u0005-Q\u00031\u0001\u0002\u000e\u0005Yan\u001c#bi\u00064\u0016\r\\;f!\u0015q\u0015qBA\n\u0013\r\t\tb\u0014\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u00079\u000b)\"C\u0002\u0002\u0018=\u0013a\u0001R8vE2,\u0017aC5oi\u0016\u0014\bO]3u\u0003N$2\u0001ZA\u000f\u0011\u0019\tyB\u0006a\u0001]\u0006Ya.Z<DK2dG+\u001f9f\u0003\r9W\r\u001e\u000b\u0006=\u0006\u0015\u0012\u0011\u0006\u0005\u0007\u0003O9\u0002\u0019\u00010\u0002\u0007\r|G\u000e\u0003\u0004\u0002,]\u0001\rAX\u0001\u0004e><\u0018!C4fi\u0012{WO\u00197f)\u0019\t\u0019\"!\r\u00024!1\u0011q\u0005\rA\u0002yCa!a\u000b\u0019\u0001\u0004q\u0016a\u0003;p\u0003J\u0014\u0018-\u001f+jY\u0016$\"!!\u000f\u0011\u0007)\u000bY$C\u0002\u0002>\r\u0013\u0011\"\u0011:sCf$\u0016\u000e\\3\u0002\u000f5,H/\u00192mKV\u0011\u00111\t\t\u0004\u0015\u0006\u0015\u0013bAA$\u0007\n\u0001R*\u001e;bE2,\u0017I\u001d:bsRKG.\u001a\u000b\u0005\u0003\u0007\nY\u0005\u0003\u0004\u0002\u0004m\u0001\rA\\\u0001\bi>\f%O]1z)\t\t\t\u0006\u0005\u0003O\u0003'r\u0016bAA+\u001f\n)\u0011I\u001d:bs\u0006iAo\\!se\u0006LHi\\;cY\u0016$\"!a\u0017\u0011\u000b9\u000b\u0019&a\u0005\u0002\u000fQ|')\u001f;fgR\u0011\u0011\u0011\r\t\u0006\u001d\u0006M\u00131\r\t\u0004\u001d\u0006\u0015\u0014bAA4\u001f\n!!)\u001f;f\u0003\u001d1wN]3bG\"$B!!\u001c\u0002tA\u0019a*a\u001c\n\u0007\u0005EtJ\u0001\u0003V]&$\bbBA;?\u0001\u0007\u0011qO\u0001\u0002MB1a*!\u001f_\u0003[J1!a\u001fP\u0005%1UO\\2uS>t\u0017'A\u0007g_J,\u0017m\u00195E_V\u0014G.\u001a\u000b\u0005\u0003[\n\t\tC\u0004\u0002v\u0001\u0002\r!a!\u0011\u000f9\u000bI(a\u0005\u0002n\u0005\tbm\u001c:fC\u000eD\u0017J\u001c;WSNLGo\u001c:\u0015\t\u00055\u0014\u0011\u0012\u0005\b\u0003\u0017\u000b\u0003\u0019AAG\u0003\u001d1\u0018n]5u_J\u00042a\\AH\u0013\r\t\t\n\u001e\u0002\u000f\u0013:$H+\u001b7f-&\u001c\u0018\u000e^8s\u0003Q1wN]3bG\"$u.\u001e2mKZK7/\u001b;peR!\u0011QNAL\u0011\u001d\tYI\ta\u0001\u00033\u00032a\\AN\u0013\r\ti\n\u001e\u0002\u0012\t>,(\r\\3US2,g+[:ji>\u0014\u0018aA7baR\u0019\u0011*a)\t\u000f\u0005U4\u00051\u0001\u0002&B)a*!\u001f_=\u0006IQ.\u00199E_V\u0014G.\u001a\u000b\u0004\u0013\u0006-\u0006bBA;I\u0001\u0007\u0011Q\u0016\t\b\u001d\u0006e\u00141CA\n\u00031i\u0017\r]%oi6\u000b\u0007\u000f]3s)\rI\u00151\u0017\u0005\b\u0003k+\u0003\u0019AA\\\u0003\u0019i\u0017\r\u001d9feB\u0019q.!/\n\u0007\u0005mFOA\u0007J]R$\u0016\u000e\\3NCB\u0004XM]\u0001\u0010[\u0006\u0004Hi\\;cY\u0016l\u0015\r\u001d9feR\u0019\u0011*!1\t\u000f\u0005Uf\u00051\u0001\u0002DB\u0019q.!2\n\u0007\u0005\u001dGO\u0001\tE_V\u0014G.\u001a+jY\u0016l\u0015\r\u001d9fe\u000691m\\7cS:,G\u0003BAg\u0003/$2!SAh\u0011\u001d\t)h\na\u0001\u0003#\u0004bATAj=zs\u0016bAAk\u001f\nIa)\u001e8di&|gN\r\u0005\u0007\u00033<\u0003\u0019\u00013\u0002\u000b=$\b.\u001a:\u0002\u001b\r|WNY5oK\u0012{WO\u00197f)\u0011\ty.!:\u0015\u0007%\u000b\t\u000fC\u0004\u0002v!\u0002\r!a9\u0011\u00139\u000b\u0019.a\u0005\u0002\u0014\u0005M\u0001BBAmQ\u0001\u0007A\r\u0006\u0003\u0002j\u00065HcA%\u0002l\"9\u0011QO\u0015A\u0002\u0005E\u0007BBAmS\u0001\u0007\u0011\n\u0006\u0003\u0002r\u0006UHcA%\u0002t\"9\u0011Q\u000f\u0016A\u0002\u0005\r\bBBAmU\u0001\u0007\u0011*A\u0004nCB$\u0016\u000e\\3\u0015\u0007\u0011\fY\u0010C\u0004\u0002v-\u0002\r!!@\u0011\u000b9\u000bI(S%\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"Aa\u0001\u0011\t\t\u0015!1\u0003\b\u0005\u0005\u000f\u0011y\u0001E\u0002\u0003\n=k!Aa\u0003\u000b\u0007\t5q)\u0001\u0004=e>|GOP\u0005\u0004\u0005#y\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0003\u0016\t]!AB*ue&twMC\u0002\u0003\u0012=\u000bAaY8qsR)AM!\b\u0003 !9a+\fI\u0001\u0002\u0004I\u0005bB-.!\u0003\u0005\raW\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011)CK\u0002J\u0005OY#A!\u000b\u0011\t\t-\"QG\u0007\u0003\u0005[QAAa\f\u00032\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005gy\u0015AC1o]>$\u0018\r^5p]&!!q\u0007B\u0017\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011iDK\u0002\\\u0005O\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXC\u0001B\"!\u0011\u0011)Ea\u0014\u000e\u0005\t\u001d#\u0002\u0002B%\u0005\u0017\nA\u0001\\1oO*\u0011!QJ\u0001\u0005U\u00064\u0018-\u0003\u0003\u0003\u0016\t\u001d\u0013\u0001\u00049s_\u0012,8\r^!sSRL\u0018A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0005/\u0012i\u0006E\u0002O\u00053J1Aa\u0017P\u0005\r\te.\u001f\u0005\t\u0005?\u0012\u0014\u0011!a\u0001=\u0006\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"A!\u001a\u0011\r\t\u001d$Q\u000eB,\u001b\t\u0011IGC\u0002\u0003l=\u000b!bY8mY\u0016\u001cG/[8o\u0013\u0011\u0011yG!\u001b\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0005k\u0012Y\bE\u0002O\u0005oJ1A!\u001fP\u0005\u001d\u0011un\u001c7fC:D\u0011Ba\u00185\u0003\u0003\u0005\rAa\u0016\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012AX\u0001\u0007KF,\u0018\r\\:\u0015\t\tU$Q\u0011\u0005\n\u0005?2\u0014\u0011!a\u0001\u0005/\n!BQ;gM\u0016\u0014H+\u001b7f!\tQ\u0005h\u0005\u00039\u0005\u001b\u001b\u0006c\u0001(\u0003\u0010&\u0019!\u0011S(\u0003\r\u0005s\u0017PU3g)\t\u0011II\u0001\u000exSRD')\u001e4gKJ$\u0016\u000e\\3G_\u000e\fG.T3uQ>$7oE\u0003;\u0005\u001b\u0013I\n\u0005\u0003\u0003\u001c\n\u0015VB\u0001BO\u0015\u0011\u0011yJ!)\u0002\u000b\u0019|7-\u00197\u000b\u0007\t\r6)\u0001\u0006nCB\fGnZ3ce\u0006LAAa*\u0003\u001e\n1\")\u001e4gKJ$\u0016\u000e\\3G_\u000e\fG.T3uQ>$7/\u0001\u0003tK24W#\u00013\u0002\u000bM,GN\u001a\u0011\u0015\t\tE&Q\u0017\t\u0004\u0005gST\"\u0001\u001d\t\r\t%V\b1\u0001e\u0003i9\u0018\u000e\u001e5Ck\u001a4WM\u001d+jY\u00164unY1m\u001b\u0016$\bn\u001c3t)\u0011\u0011\tLa/\t\r\t%f\b1\u0001e\u0003\u0015\t\u0007\u000f\u001d7z)\u0015!'\u0011\u0019Bb\u0011\u00151v\b1\u0001J\u0011\u0015Iv\b1\u0001\\\u0003\u001d)h.\u00199qYf$BA!3\u0003RB)a*a\u0004\u0003LB)aJ!4J7&\u0019!qZ(\u0003\rQ+\b\u000f\\33\u0011!\u0011\u0019\u000eQA\u0001\u0002\u0004!\u0017a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011I\u000e\u0005\u0003\u0003F\tm\u0017\u0002\u0002Bo\u0005\u000f\u0012aa\u00142kK\u000e$\b")
public class BufferTile
extends Tile
implements Product {
    private final Tile sourceTile;
    private final GridBounds<Object> gridBounds;
    private final int cols;
    private final int rows;
    private final DataType cellType;

    public static Option<Tuple2<Tile, GridBounds<Object>>> unapply(BufferTile bufferTile) {
        return BufferTile$.MODULE$.unapply(bufferTile);
    }

    public static BufferTile apply(Tile tile, GridBounds<Object> gridBounds) {
        return BufferTile$.MODULE$.apply(tile, gridBounds);
    }

    public static withBufferTileFocalMethods withBufferTileFocalMethods(BufferTile bufferTile) {
        return BufferTile$.MODULE$.withBufferTileFocalMethods(bufferTile);
    }

    public Tile sourceTile() {
        return this.sourceTile;
    }

    public GridBounds<Object> gridBounds() {
        return this.gridBounds;
    }

    @Override
    public int cols() {
        return this.cols$mcI$sp();
    }

    @Override
    public int rows() {
        return this.rows$mcI$sp();
    }

    @Override
    public DataType cellType() {
        return this.cellType;
    }

    private int colMin() {
        return this.gridBounds().colMin$mcI$sp();
    }

    private int rowMin() {
        return this.gridBounds().rowMin$mcI$sp();
    }

    private int sourceCols() {
        return this.sourceTile().cols$mcI$sp();
    }

    private int sourceRows() {
        return this.sourceTile().rows$mcI$sp();
    }

    public int bufferTop() {
        return this.gridBounds().rowMin$mcI$sp();
    }

    public int bufferLeft() {
        return this.gridBounds().colMin$mcI$sp();
    }

    public int bufferRight() {
        return this.sourceTile().cols$mcI$sp() - this.gridBounds().colMin$mcI$sp() - this.gridBounds().colMax$mcI$sp();
    }

    public int bufferBottom() {
        return this.sourceTile().rows$mcI$sp() - this.gridBounds().rowMin$mcI$sp() - this.gridBounds().rowMax$mcI$sp();
    }

    @Override
    public Tile convert(DataType targetCellType) {
        return this.mutable(targetCellType);
    }

    @Override
    public BufferTile withNoData(Option<Object> noDataValue) {
        return new BufferTile(this.sourceTile().withNoData(noDataValue), this.gridBounds());
    }

    @Override
    public BufferTile interpretAs(DataType newCellType) {
        return new BufferTile(this.sourceTile().interpretAs(newCellType), this.gridBounds());
    }

    @Override
    public int get(int col, int row) {
        int c = col + this.colMin();
        int r = row + this.rowMin();
        if (c < 0 || r < 0 || c >= this.sourceCols() || r >= this.sourceRows()) {
            throw new IndexOutOfBoundsException(new StringBuilder(34).append("(col=").append(col).append(", row=").append(row).append(") is out of tile bounds").toString());
        }
        return this.sourceTile().get(c, r);
    }

    @Override
    public double getDouble(int col, int row) {
        int c = col + this.colMin();
        int r = row + this.rowMin();
        if (c < 0 || r < 0 || c >= this.sourceCols() || r >= this.sourceRows()) {
            throw new IndexOutOfBoundsException(new StringBuilder(34).append("(col=").append(col).append(", row=").append(row).append(") is out of tile bounds").toString());
        }
        return this.sourceTile().getDouble(col + this.gridBounds().colMin$mcI$sp(), row + this.gridBounds().rowMin$mcI$sp());
    }

    @Override
    public ArrayTile toArrayTile() {
        return this.mutable();
    }

    @Override
    public MutableArrayTile mutable() {
        return this.mutable(this.cellType());
    }

    /*
     * WARNING - void declaration
     */
    public MutableArrayTile mutable(DataType targetCellType) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(targetCellType, this.cols$mcI$sp(), this.rows$mcI$sp());
        if (!this.cellType().isFloatingPoint()) {
            for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
                for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                    tile.set(index$macro$1, index$macro$2, this.get(index$macro$1, index$macro$2));
                }
            }
        } else {
            for (int index$macro$4 = 0; index$macro$4 < this.rows$mcI$sp(); ++index$macro$4) {
                for (int index$macro$3 = 0; index$macro$3 < this.cols$mcI$sp(); ++index$macro$3) {
                    tile.setDouble(index$macro$3, index$macro$4, this.getDouble(index$macro$3, index$macro$4));
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] toArray() {
        void var1_1;
        int[] arr = (int[])Array$.MODULE$.ofDim(this.cols$mcI$sp() * this.rows$mcI$sp(), ClassTag$.MODULE$.Int());
        int i = 0;
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                arr[i] = this.get(index$macro$1, index$macro$2);
                ++i;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArrayDouble() {
        void var1_1;
        double[] arr = (double[])Array$.MODULE$.ofDim(this.cols$mcI$sp() * this.rows$mcI$sp(), ClassTag$.MODULE$.Double());
        int i = 0;
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                arr[i] = this.getDouble(index$macro$1, index$macro$2);
                ++i;
            }
        }
        return var1_1;
    }

    @Override
    public byte[] toBytes() {
        return this.toArrayTile().toBytes();
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                f.apply$mcVI$sp(this.get(index$macro$1, index$macro$2));
            }
        }
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                f.apply$mcVD$sp(this.getDouble(index$macro$1, index$macro$2));
            }
        }
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                visitor.apply(index$macro$1, index$macro$2, this.get(index$macro$1, index$macro$2));
            }
        }
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                visitor.apply(index$macro$1, index$macro$2, this.getDouble(index$macro$1, index$macro$2));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile map(Function1<Object, Object> f) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols$mcI$sp(), this.rows$mcI$sp());
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                tile.set(index$macro$1, index$macro$2, f.apply$mcII$sp(this.get(index$macro$1, index$macro$2)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols$mcI$sp(), this.rows$mcI$sp());
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                tile.setDouble(index$macro$1, index$macro$2, f.apply$mcDD$sp(this.getDouble(index$macro$1, index$macro$2)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols$mcI$sp(), this.rows$mcI$sp());
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                tile.set(index$macro$1, index$macro$2, mapper.apply(index$macro$1, index$macro$2, this.get(index$macro$1, index$macro$2)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols$mcI$sp(), this.rows$mcI$sp());
        for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
            for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                tile.setDouble(index$macro$1, index$macro$2, mapper.apply(index$macro$1, index$macro$2, this.getDouble(index$macro$1, index$macro$2)));
            }
        }
        return var2_2;
    }

    public Tile combine(BufferTile other, Function2<Object, Object, Object> f) {
        if (this.gridBounds().width$mcI$sp() != other.gridBounds().width$mcI$sp() || this.gridBounds().height$mcI$sp() != other.gridBounds().height$mcI$sp()) {
            throw new GeoAttrsError(new StringBuilder(56).append("Cannot combine rasters with different dimensions: ").append(this.gridBounds().width$mcI$sp()).append("x").append(this.gridBounds().height$mcI$sp()).append(" != ").append(other.gridBounds().width$mcI$sp()).append("x").append(other.gridBounds().height$mcI$sp()).toString());
        }
        int bufferTop = scala.math.package$.MODULE$.min(this.bufferTop(), other.bufferTop());
        int bufferLeft = scala.math.package$.MODULE$.min(this.bufferLeft(), other.bufferLeft());
        int bufferRight = scala.math.package$.MODULE$.min(this.bufferRight(), other.bufferRight());
        int bufferBottom = scala.math.package$.MODULE$.min(this.bufferBottom(), other.bufferBottom());
        int cols = bufferLeft + this.gridBounds().width$mcI$sp() + bufferRight;
        int rows = bufferTop + this.gridBounds().height$mcI$sp() + bufferBottom;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType().union(other.cellType()), cols, rows);
        for (int index$macro$2 = -bufferTop; index$macro$2 < this.gridBounds().height$mcI$sp() + bufferRight; ++index$macro$2) {
            for (int index$macro$1 = -bufferLeft; index$macro$1 < this.gridBounds().width$mcI$sp() + bufferRight; ++index$macro$1) {
                int leftV = this.get(index$macro$1, index$macro$2);
                int rightV = other.get(index$macro$1, index$macro$2);
                tile.set(index$macro$1 + bufferLeft, index$macro$2 + bufferTop, f.apply$mcIII$sp(leftV, rightV));
            }
        }
        return bufferTop + bufferLeft + bufferRight + bufferBottom == 0 ? tile : new BufferTile(tile, new GridBounds$mcI$sp(bufferLeft, bufferTop, bufferLeft + this.gridBounds().width$mcI$sp() - 1, bufferTop + this.gridBounds().height$mcI$sp() - 1, (Integral<Object>)Integral$.MODULE$.IntIsIntegral()));
    }

    public Tile combineDouble(BufferTile other, Function2<Object, Object, Object> f) {
        if (this.gridBounds().width$mcI$sp() != other.gridBounds().width$mcI$sp() || this.gridBounds().height$mcI$sp() != other.gridBounds().height$mcI$sp()) {
            throw new GeoAttrsError(new StringBuilder(56).append("Cannot combine rasters with different dimensions: ").append(this.gridBounds().width$mcI$sp()).append("x").append(this.gridBounds().height$mcI$sp()).append(" != ").append(other.gridBounds().width$mcI$sp()).append("x").append(other.gridBounds().height$mcI$sp()).toString());
        }
        int bufferTop = scala.math.package$.MODULE$.min(this.bufferTop(), other.bufferTop());
        int bufferLeft = scala.math.package$.MODULE$.min(this.bufferLeft(), other.bufferLeft());
        int bufferRight = scala.math.package$.MODULE$.min(this.bufferRight(), other.bufferRight());
        int bufferBottom = scala.math.package$.MODULE$.min(this.bufferBottom(), other.bufferBottom());
        int cols = bufferLeft + this.gridBounds().width$mcI$sp() + bufferRight;
        int rows = bufferTop + this.gridBounds().height$mcI$sp() + bufferBottom;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType().union(other.cellType()), cols, rows);
        for (int index$macro$2 = -bufferTop; index$macro$2 < this.gridBounds().height$mcI$sp() + bufferRight; ++index$macro$2) {
            for (int index$macro$1 = -bufferLeft; index$macro$1 < this.gridBounds().width$mcI$sp() + bufferRight; ++index$macro$1) {
                double leftV = this.getDouble(index$macro$1, index$macro$2);
                double rightV = other.getDouble(index$macro$1, index$macro$2);
                tile.setDouble(index$macro$1 + bufferLeft, index$macro$2 + bufferTop, f.apply$mcDDD$sp(leftV, rightV));
            }
        }
        return bufferTop + bufferLeft + bufferRight + bufferBottom == 0 ? tile : new BufferTile(tile, new GridBounds$mcI$sp(bufferLeft, bufferTop, bufferLeft + this.gridBounds().width$mcI$sp() - 1, bufferTop + this.gridBounds().height$mcI$sp() - 1, (Integral<Object>)Integral$.MODULE$.IntIsIntegral()));
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        Tile tile;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)this, (Object)other)).assertEqualDimensions();
        Tile tile2 = other;
        if (tile2 instanceof BufferTile) {
            BufferTile bufferTile = (BufferTile)tile2;
            tile = this.combine(bufferTile, f);
        } else {
            MutableArrayTile tile3 = ArrayTile$.MODULE$.alloc(this.cellType().union(other.cellType()), this.cols$mcI$sp(), this.rows$mcI$sp());
            for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
                for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                    tile3.set(index$macro$1, index$macro$2, f.apply$mcIII$sp(this.get(index$macro$1, index$macro$2), other.get(index$macro$1, index$macro$2)));
                }
            }
            tile = tile3;
        }
        return tile;
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        Tile tile;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)this, (Object)other)).assertEqualDimensions();
        Tile tile2 = other;
        if (tile2 instanceof BufferTile) {
            BufferTile bufferTile = (BufferTile)tile2;
            tile = this.combineDouble(bufferTile, f);
        } else {
            MutableArrayTile tile3 = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols$mcI$sp(), this.rows$mcI$sp());
            for (int index$macro$2 = 0; index$macro$2 < this.rows$mcI$sp(); ++index$macro$2) {
                for (int index$macro$1 = 0; index$macro$1 < this.cols$mcI$sp(); ++index$macro$1) {
                    tile3.setDouble(index$macro$1, index$macro$2, f.apply$mcDDD$sp(this.getDouble(index$macro$1, index$macro$2), other.getDouble(index$macro$1, index$macro$2)));
                }
            }
            tile = tile3;
        }
        return tile;
    }

    public BufferTile mapTile(Function1<Tile, Tile> f) {
        return new BufferTile((Tile)f.apply((Object)this.sourceTile()), this.gridBounds());
    }

    public String toString() {
        return new StringBuilder(16).append("BufferTile(").append(this.sourceTile().dimensions()).append(", ").append(this.gridBounds()).append(", ").append(this.cellType()).append(")").toString();
    }

    public BufferTile copy(Tile sourceTile, GridBounds<Object> gridBounds) {
        return new BufferTile(sourceTile, gridBounds);
    }

    public Tile copy$default$1() {
        return this.sourceTile();
    }

    public GridBounds<Object> copy$default$2() {
        return this.gridBounds();
    }

    public String productPrefix() {
        return "BufferTile";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        scala.Serializable serializable;
        int n = x$1;
        switch (n) {
            case 0: {
                serializable = this.sourceTile();
                break;
            }
            case 1: {
                serializable = this.gridBounds();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return serializable;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BufferTile;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BufferTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        BufferTile bufferTile = (BufferTile)x$1;
        Tile tile = this.sourceTile();
        Tile tile2 = bufferTile.sourceTile();
        if (tile == null) {
            if (tile2 != null) {
                return false;
            }
        } else if (!tile.equals(tile2)) return false;
        GridBounds<Object> gridBounds = this.gridBounds();
        GridBounds<Object> gridBounds2 = bufferTile.gridBounds();
        if (gridBounds == null) {
            if (gridBounds2 != null) {
                return false;
            }
        } else if (!((Object)gridBounds).equals(gridBounds2)) return false;
        if (!bufferTile.canEqual(this)) return false;
        return true;
    }

    @Override
    public int cols$mcI$sp() {
        return this.cols;
    }

    @Override
    public int rows$mcI$sp() {
        return this.rows;
    }

    public boolean specInstance$() {
        return false;
    }

    public BufferTile(Tile sourceTile, GridBounds<Object> gridBounds) {
        this.sourceTile = sourceTile;
        this.gridBounds = gridBounds;
        Product.$init$((Product)this);
        Predef$.MODULE$.require(gridBounds.colMin$mcI$sp() >= 0 && gridBounds.rowMin$mcI$sp() >= 0 && gridBounds.colMax$mcI$sp() < sourceTile.cols$mcI$sp() && gridBounds.rowMax$mcI$sp() < sourceTile.rows$mcI$sp(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Tile center bounds ").append(this.gridBounds()).append(" exceed underlying tile dimensions ").append(this.sourceTile().dimensions()).toString());
        this.cols = gridBounds.width$mcI$sp();
        this.rows = gridBounds.height$mcI$sp();
        this.cellType = sourceTile.cellType();
    }

    public static class withBufferTileFocalMethods
    implements BufferTileFocalMethods {
        private final BufferTile self;

        @Override
        public BufferTile focalMin(Neighborhood n, Option<GridBounds<Object>> bounds, TargetCell target) {
            return BufferTileFocalMethods.focalMin$(this, n, bounds, target);
        }

        @Override
        public Option<GridBounds<Object>> focalMin$default$2() {
            return BufferTileFocalMethods.focalMin$default$2$(this);
        }

        @Override
        public TargetCell focalMin$default$3() {
            return BufferTileFocalMethods.focalMin$default$3$(this);
        }

        @Override
        public BufferTile focalMax(Neighborhood n, Option<GridBounds<Object>> bounds, TargetCell target) {
            return BufferTileFocalMethods.focalMax$(this, n, bounds, target);
        }

        @Override
        public Option<GridBounds<Object>> focalMax$default$2() {
            return BufferTileFocalMethods.focalMax$default$2$(this);
        }

        @Override
        public TargetCell focalMax$default$3() {
            return BufferTileFocalMethods.focalMax$default$3$(this);
        }

        @Override
        public BufferTile focalMode(Neighborhood n, Option<GridBounds<Object>> bounds, TargetCell target) {
            return BufferTileFocalMethods.focalMode$(this, n, bounds, target);
        }

        @Override
        public Option<GridBounds<Object>> focalMode$default$2() {
            return BufferTileFocalMethods.focalMode$default$2$(this);
        }

        @Override
        public TargetCell focalMode$default$3() {
            return BufferTileFocalMethods.focalMode$default$3$(this);
        }

        @Override
        public BufferTile focalMedian(Neighborhood n, Option<GridBounds<Object>> bounds, TargetCell target) {
            return BufferTileFocalMethods.focalMedian$(this, n, bounds, target);
        }

        @Override
        public Option<GridBounds<Object>> focalMedian$default$2() {
            return BufferTileFocalMethods.focalMedian$default$2$(this);
        }

        @Override
        public TargetCell focalMedian$default$3() {
            return BufferTileFocalMethods.focalMedian$default$3$(this);
        }

        @Override
        public BufferTile focalMean(Neighborhood n, Option<GridBounds<Object>> bounds, TargetCell target) {
            return BufferTileFocalMethods.focalMean$(this, n, bounds, target);
        }

        @Override
        public Option<GridBounds<Object>> focalMean$default$2() {
            return BufferTileFocalMethods.focalMean$default$2$(this);
        }

        @Override
        public TargetCell focalMean$default$3() {
            return BufferTileFocalMethods.focalMean$default$3$(this);
        }

        @Override
        public BufferTile focalSum(Neighborhood n, Option<GridBounds<Object>> bounds, TargetCell target) {
            return BufferTileFocalMethods.focalSum$(this, n, bounds, target);
        }

        @Override
        public Option<GridBounds<Object>> focalSum$default$2() {
            return BufferTileFocalMethods.focalSum$default$2$(this);
        }

        @Override
        public TargetCell focalSum$default$3() {
            return BufferTileFocalMethods.focalSum$default$3$(this);
        }

        @Override
        public BufferTile focalStandardDeviation(Neighborhood n, Option<GridBounds<Object>> bounds, TargetCell target) {
            return BufferTileFocalMethods.focalStandardDeviation$(this, n, bounds, target);
        }

        @Override
        public Option<GridBounds<Object>> focalStandardDeviation$default$2() {
            return BufferTileFocalMethods.focalStandardDeviation$default$2$(this);
        }

        @Override
        public TargetCell focalStandardDeviation$default$3() {
            return BufferTileFocalMethods.focalStandardDeviation$default$3$(this);
        }

        @Override
        public BufferTile focalConway(Option<GridBounds<Object>> bounds) {
            return BufferTileFocalMethods.focalConway$(this, bounds);
        }

        @Override
        public Option<GridBounds<Object>> focalConway$default$1() {
            return BufferTileFocalMethods.focalConway$default$1$(this);
        }

        @Override
        public BufferTile convolve(Kernel kernel, Option<GridBounds<Object>> bounds, TargetCell target) {
            return BufferTileFocalMethods.convolve$(this, kernel, bounds, target);
        }

        @Override
        public Option<GridBounds<Object>> convolve$default$2() {
            return BufferTileFocalMethods.convolve$default$2$(this);
        }

        @Override
        public TargetCell convolve$default$3() {
            return BufferTileFocalMethods.convolve$default$3$(this);
        }

        @Override
        public BufferTile tileMoransI(Neighborhood n, Option<GridBounds<Object>> bounds, TargetCell target) {
            return BufferTileFocalMethods.tileMoransI$(this, n, bounds, target);
        }

        @Override
        public Option<GridBounds<Object>> tileMoransI$default$2() {
            return BufferTileFocalMethods.tileMoransI$default$2$(this);
        }

        @Override
        public TargetCell tileMoransI$default$3() {
            return BufferTileFocalMethods.tileMoransI$default$3$(this);
        }

        @Override
        public double scalarMoransI(Neighborhood n, Option<GridBounds<Object>> bounds) {
            return BufferTileFocalMethods.scalarMoransI$(this, n, bounds);
        }

        @Override
        public Option<GridBounds<Object>> scalarMoransI$default$2() {
            return BufferTileFocalMethods.scalarMoransI$default$2$(this);
        }

        @Override
        public BufferTile slope(CellSize cs, double zFactor, Option<GridBounds<Object>> bounds, TargetCell target) {
            return BufferTileFocalMethods.slope$(this, cs, zFactor, bounds, target);
        }

        @Override
        public double slope$default$2() {
            return BufferTileFocalMethods.slope$default$2$(this);
        }

        @Override
        public Option<GridBounds<Object>> slope$default$3() {
            return BufferTileFocalMethods.slope$default$3$(this);
        }

        @Override
        public TargetCell slope$default$4() {
            return BufferTileFocalMethods.slope$default$4$(this);
        }

        @Override
        public BufferTile aspect(CellSize cs, Option<GridBounds<Object>> bounds, TargetCell target) {
            return BufferTileFocalMethods.aspect$(this, cs, bounds, target);
        }

        @Override
        public Option<GridBounds<Object>> aspect$default$2() {
            return BufferTileFocalMethods.aspect$default$2$(this);
        }

        @Override
        public TargetCell aspect$default$3() {
            return BufferTileFocalMethods.aspect$default$3$(this);
        }

        @Override
        public BufferTile self() {
            return this.self;
        }

        public withBufferTileFocalMethods(BufferTile self) {
            this.self = self;
            BufferTileFocalMethods.$init$(this);
        }
    }
}

