/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.costdistance;

import geotrellis.raster.ArrayTile;
import geotrellis.raster.Dimensions;
import geotrellis.raster.Tile;
import geotrellis.raster.costdistance.CostDistanceWithPaths$;
import geotrellis.raster.costdistance.CostDistanceWithPathsResult;
import geotrellis.raster.package$;
import geotrellis.raster.package$DoubleArrayFiller$;
import java.util.BitSet;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uq!B\u000e\u001d\u0011\u0003\u0019c!B\u0013\u001d\u0011\u00031\u0003\"B\u0017\u0002\t\u0003q\u0003\"B\u0018\u0002\t\u0003\u0001d\u0001B\u0013\u001d\t\tCAb\u0011\u0003\u0005\u0002\u0003\u0015)\u0011!Q\u0001\n\u0011C\u0001b\u000f\u0003\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\u0006[\u0011!\ta\u0012\u0005\b\u0017\u0012\u0011\r\u0011\"\u0001M\u0011\u0019iE\u0001)A\u0005\t\"9a\n\u0002b\u0001\n\u0003y\u0005BB*\u0005A\u0003%\u0001\u000b\u0003\u0006U\tA\u0005\t1!Q\u0001\nqBq!\u0016\u0003C\u0002\u0013\u0005a\u000b\u0003\u0004X\t\u0001\u0006Ia\u0010\u0005\b1\u0012\u0011\r\u0011\"\u0001W\u0011\u0019IF\u0001)A\u0005\u007f!)!\f\u0002C\u00037\")!\r\u0002C\u0003G\")\u0011\u000e\u0002C\u0003U\")\u0001\u000f\u0002C\u0003c\u001a!q\u000f\u0002\u0001y\u0011\u0015iS\u0003\"\u0001z\u0011\u001daXC1A\u0005\u0002uDq!a\u0001\u0016A\u0003%a\u0010C\u0004\u0002\u0006U!\t!a\u0002\t\u000f\u0005EA\u0001\"\u0001\u0002\u0014\u0005)2i\\:u\t&\u001cH/\u00198dK^KG\u000f\u001b)bi\"\u001c(BA\u000f\u001f\u00031\u0019wn\u001d;eSN$\u0018M\\2f\u0015\ty\u0002%\u0001\u0004sCN$XM\u001d\u0006\u0002C\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001A\u0011A%A\u0007\u00029\t)2i\\:u\t&\u001cH/\u00198dK^KG\u000f\u001b)bi\"\u001c8CA\u0001(!\tA3&D\u0001*\u0015\u0005Q\u0013!B:dC2\f\u0017B\u0001\u0017*\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012aI\u0001\u0006CB\u0004H.\u001f\u000b\u0004cQR\u0004C\u0001\u00133\u0013\t\u0019DDA\u000eD_N$H)[:uC:\u001cWmV5uQB\u000bG\u000f[:SKN,H\u000e\u001e\u0005\u0006k\r\u0001\rAN\u0001\u0005G>\u001cH\u000f\u0005\u00028q5\ta$\u0003\u0002:=\t!A+\u001b7f\u0011\u0015Y4\u00011\u0001=\u0003\u0019\u0019x.\u001e:dKB!\u0001&P @\u0013\tq\u0014F\u0001\u0004UkBdWM\r\t\u0003Q\u0001K!!Q\u0015\u0003\u0007%sGo\u0005\u0002\u0005O\u0005Qt-Z8ue\u0016dG.[:%e\u0006\u001cH/\u001a:%G>\u001cH\u000fZ5ti\u0006t7-\u001a\u0013D_N$H)[:uC:\u001cWmV5uQB\u000bG\u000f[:%I\r|7\u000f\u001e\t\u0003o\u0015K!A\u0012\u0010\u0003\u0013\u0005\u0013(/Y=US2,Gc\u0001%J\u0015B\u0011A\u0005\u0002\u0005\u0006k\u001d\u0001\r\u0001\u0012\u0005\u0006w\u001d\u0001\r\u0001P\u0001\ni&dW-\u0011:sCf,\u0012\u0001R\u0001\u000bi&dW-\u0011:sCf\u0004\u0013!B*reR\u0014T#\u0001)\u0011\u0005!\n\u0016B\u0001**\u0005\u0019!u.\u001e2mK\u000611+\u001d:ue\u0001\n1\u0001\u001f\u00139\u0003\u0011\u0019w\u000e\\:\u0016\u0003}\nQaY8mg\u0002\nAA]8xg\u0006)!o\\<tA\u0005\u0011\u0012N\u001c3fqR{7i\\8sI&t\u0017\r^3t)\taD\fC\u0003^#\u0001\u0007q(A\u0002jIbD#!E0\u0011\u0005!\u0002\u0017BA1*\u0005\u0019Ig\u000e\\5oK\u0006\u00112m\\8sI&t\u0017\r^3t)>Le\u000eZ3y)\ryDM\u001a\u0005\u0006KJ\u0001\raP\u0001\u0002G\")qM\u0005a\u0001\u007f\u0005\t!\u000f\u000b\u0002\u0013?\u0006Yq-\u001a;US2,7i\\:u)\r\u00016.\u001c\u0005\u0006YN\u0001\raP\u0001\u0005g&#\u0007\u0010C\u0003o'\u0001\u0007q(\u0001\u0003f\u0013\u0012D\bFA\n`\u000319W\r\u001e(fS\u001eD'm\u001c:t)\t\u0011X\u000fE\u0002)g~J!\u0001^\u0015\u0003\u000b\u0005\u0013(/Y=\t\u000bu#\u0002\u0019A )\u0005Qy&!B$sCBD7CA\u000b()\u0005Q\bCA>\u0016\u001b\u0005!\u0011!\u00038fS\u001eD'm\u001c:t+\u0005q\bc\u0001\u0015t\u007fB!\u0001f]A\u0001!\u0011ASh\u0010)\u0002\u00159,\u0017n\u001a5c_J\u001c\b%A\u0004hKR\u001cun\u001d;\u0015\u000bA\u000bI!!\u0004\t\r\u0005-\u0011\u00041\u0001@\u0003\u0005\u0019\bBBA\b3\u0001\u0007q(A\u0001f\u0003\u001d\u0019w.\u001c9vi\u0016,\u0012!\r")
public class CostDistanceWithPaths {
    public final ArrayTile geotrellis$raster$costdistance$CostDistanceWithPaths$$cost;
    private final Tuple2<Object, Object> source;
    private final ArrayTile tileArray;
    private final double Sqrt2;
    private final /* synthetic */ Tuple2 x$8;
    private final int cols;
    private final int rows;

    public static CostDistanceWithPathsResult apply(Tile tile, Tuple2<Object, Object> tuple22) {
        return CostDistanceWithPaths$.MODULE$.apply(tile, tuple22);
    }

    public ArrayTile tileArray() {
        return this.tileArray;
    }

    public double Sqrt2() {
        return this.Sqrt2;
    }

    public int cols() {
        return this.cols;
    }

    public int rows() {
        return this.rows;
    }

    public final Tuple2<Object, Object> indexToCoordinates(int idx) {
        return new Tuple2.mcII.sp(idx % this.cols(), idx / this.cols());
    }

    public final int coordinatesToIndex(int c, int r) {
        return r * this.cols() + c;
    }

    public final double getTileCost(int sIdx, int eIdx) {
        int v1 = this.geotrellis$raster$costdistance$CostDistanceWithPaths$$cost.apply(sIdx);
        int v2 = this.geotrellis$raster$costdistance$CostDistanceWithPaths$$cost.apply(eIdx);
        int r = v1 + v2;
        int absDifference = scala.math.package$.MODULE$.abs(sIdx - eIdx);
        return absDifference > 1 && absDifference != this.cols() ? (double)r / this.Sqrt2() : (double)r / 2.0;
    }

    public final int[] getNeighbors(int idx) {
        Tuple2<Object, Object> tuple22 = this.indexToCoordinates(idx);
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int col = tuple22._1$mcI$sp();
        int row = tuple22._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(col, row);
        Tuple2.mcII.sp sp3 = sp2;
        int col2 = sp3._1$mcI$sp();
        int row2 = sp3._2$mcI$sp();
        ArrayBuffer buff = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        boolean isRight = col2 == this.cols() - 1;
        boolean isLeft = col2 == 0;
        boolean isTop = row2 == 0;
        boolean isBottom = row2 == this.rows() - 1;
        Object object = !isLeft ? buff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(idx - 1))) : BoxedUnit.UNIT;
        Object object2 = !isRight ? buff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(idx + 1))) : BoxedUnit.UNIT;
        Object object3 = !isTop ? buff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(idx - this.cols()))) : BoxedUnit.UNIT;
        Object object4 = !isBottom ? buff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(idx + this.cols()))) : BoxedUnit.UNIT;
        Object object5 = !isLeft && !isTop ? buff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(idx - this.cols() - 1))) : BoxedUnit.UNIT;
        Object object6 = !isLeft && !isBottom ? buff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(idx + this.cols() - 1))) : BoxedUnit.UNIT;
        Object object7 = !isRight && !isTop ? buff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(idx - this.cols() + 1))) : BoxedUnit.UNIT;
        Object object8 = !isRight && !isBottom ? buff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(idx + this.cols() + 1))) : BoxedUnit.UNIT;
        return (int[])buff.toArray(ClassTag$.MODULE$.Int());
    }

    public CostDistanceWithPathsResult compute() {
        Tuple2<Object, Object> tuple22 = this.source;
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int sourceCol = tuple22._1$mcI$sp();
        int sourceRow = tuple22._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(sourceCol, sourceRow);
        Tuple2.mcII.sp sp3 = sp2;
        int sourceCol2 = sp3._1$mcI$sp();
        int sourceRow2 = sp3._2$mcI$sp();
        int sourceIdx = this.coordinatesToIndex(sourceCol2, sourceRow2);
        BitSet marked = new BitSet(this.cols() * this.rows());
        double[] pathCosts = package$DoubleArrayFiller$.MODULE$.fill$extension(package$.MODULE$.DoubleArrayFiller((double[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.Double())), Double.MAX_VALUE);
        pathCosts[sourceIdx] = 0.0;
        Seq[] rememberParents = (Seq[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.apply(Seq.class));
        PriorityQueue<Object> priorityQueue = new PriorityQueue<Object>(this.cols() * this.rows(), new Comparator<Object>(null, pathCosts){
            private final double[] pathCosts$1;

            public Comparator<Object> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<Object> thenComparing(Comparator<? super Object> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<Object> thenComparing(Function<? super Object, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<Object> thenComparing(Function<? super Object, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<Object> thenComparingInt(ToIntFunction<? super Object> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<Object> thenComparingLong(ToLongFunction<? super Object> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<Object> thenComparingDouble(ToDoubleFunction<? super Object> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public boolean equals(Object a) {
                return a.equals(this);
            }

            public int compare(int a, int b) {
                return Predef$.MODULE$.double2Double(this.pathCosts$1[a]).compareTo(Predef$.MODULE$.double2Double(this.pathCosts$1[b]));
            }
            {
                this.pathCosts$1 = pathCosts$1;
            }
        });
        Graph graph = new Graph();
        for (int index$macro$1 = 0; index$macro$1 < this.cols() * this.rows(); ++index$macro$1) {
            rememberParents[index$macro$1] = (Seq)Nil$.MODULE$;
        }
        priorityQueue.add(BoxesRunTime.boxToInteger((int)sourceIdx));
        while (!priorityQueue.isEmpty()) {
            int current = BoxesRunTime.unboxToInt((Object)priorityQueue.poll());
            marked.flip(current);
            int[] neighbors = this.getNeighbors(current);
            for (int index$macro$2 = 0; index$macro$2 < new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(neighbors)).size(); ++index$macro$2) {
                double oldCost;
                int neighbor = neighbors[index$macro$2];
                if (marked.get(neighbor)) continue;
                double alt = pathCosts[current] + graph.getCost(current, neighbor);
                if (alt < (oldCost = pathCosts[neighbor])) {
                    pathCosts[neighbor] = alt;
                    rememberParents[neighbor] = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{current}));
                    priorityQueue.add(BoxesRunTime.boxToInteger((int)neighbor));
                    continue;
                }
                if (alt != oldCost) continue;
                rememberParents[neighbor] = (Seq)rememberParents[neighbor].$colon$plus((Object)BoxesRunTime.boxToInteger((int)current), Seq$.MODULE$.canBuildFrom());
            }
        }
        return new CostDistanceWithPathsResult(rememberParents, pathCosts, this.geotrellis$raster$costdistance$CostDistanceWithPaths$$cost.dimensions());
    }

    public CostDistanceWithPaths(ArrayTile cost, Tuple2<Object, Object> source) {
        this.geotrellis$raster$costdistance$CostDistanceWithPaths$$cost = cost;
        this.source = source;
        this.tileArray = cost;
        this.Sqrt2 = scala.math.package$.MODULE$.sqrt(2.0);
        Dimensions dimensions = cost.dimensions();
        if (dimensions == null) {
            throw new MatchError(dimensions);
        }
        int cols = dimensions.cols$mcI$sp();
        int rows = dimensions.rows$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(cols, rows);
        this.x$8 = sp2;
        this.cols = this.x$8._1$mcI$sp();
        this.rows = this.x$8._2$mcI$sp();
    }

    public class Graph {
        private final Tuple2<Object, Object>[][] neighbors;

        public Tuple2<Object, Object>[][] neighbors() {
            return this.neighbors;
        }

        public double getCost(int s, int e) {
            Tuple2<Object, Object>[] sNeighbors = this.neighbors()[s];
            double res = Double.MAX_VALUE;
            for (int index$macro$1 = 0; index$macro$1 < new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sNeighbors)).size(); ++index$macro$1) {
                Tuple2<Object, Object> tuple22 = sNeighbors[index$macro$1];
                if (tuple22 == null) {
                    throw new MatchError(tuple22);
                }
                int other = tuple22._1$mcI$sp();
                double c = tuple22._2$mcD$sp();
                Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(other, c);
                Tuple2.mcID.sp sp3 = sp2;
                int other2 = sp3._1$mcI$sp();
                double c2 = sp3._2$mcD$sp();
                if (other2 != e) continue;
                res = c2;
            }
            return res;
        }

        public /* synthetic */ CostDistanceWithPaths geotrellis$raster$costdistance$CostDistanceWithPaths$Graph$$$outer() {
            return CostDistanceWithPaths.this;
        }

        /*
         * WARNING - void declaration
         */
        public Graph() {
            void var3_3;
            if (CostDistanceWithPaths.this == null) {
                throw null;
            }
            int vertices = CostDistanceWithPaths.this.cols() * CostDistanceWithPaths.this.rows();
            Tuple2[][] res = (Tuple2[][])Array$.MODULE$.ofDim(vertices, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
            for (int index$macro$2 = 0; index$macro$2 < vertices; ++index$macro$2) {
                int[] neighborIndices = CostDistanceWithPaths.this.getNeighbors(index$macro$2);
                Tuple2[] neighbors = (Tuple2[])Array$.MODULE$.ofDim(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(neighborIndices)).size(), ClassTag$.MODULE$.apply(Tuple2.class));
                for (int index$macro$1 = 0; index$macro$1 < new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(neighborIndices)).size(); ++index$macro$1) {
                    int other = neighborIndices[index$macro$1];
                    double cost = CostDistanceWithPaths.this.getTileCost(index$macro$2, other);
                    neighbors[index$macro$1] = new Tuple2.mcID.sp(other, cost);
                }
                res[index$macro$2] = neighbors;
            }
            this.neighbors = var3_3;
        }
    }
}

