/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.focal;

import geotrellis.raster.CellSet;
import geotrellis.raster.GridBounds;
import geotrellis.raster.Tile;
import geotrellis.raster.mapalgebra.focal.Cursor$;
import geotrellis.raster.mapalgebra.focal.CursorMask;
import geotrellis.raster.mapalgebra.focal.Movement;
import geotrellis.raster.mapalgebra.focal.Movement$;
import geotrellis.raster.mapalgebra.focal.Neighborhood;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t\u0005t!B*U\u0011\u0003if!B0U\u0011\u0003\u0001\u0007\"B4\u0002\t\u0003A\u0007\"B5\u0002\t\u0003Q\u0007BB5\u0002\t\u0003\u0011)\u0006\u0003\u0004j\u0003\u0011\u0005!1\f\u0004\u0005?R\u0003A\u000e\u0003\u0005n\r\t\u0005\t\u0015!\u0003o\u0011!\u0011hA!A!\u0002\u0013\u0019\b\u0002C=\u0007\u0005\u000b\u0007I\u0011\u0001>\t\u0011m4!\u0011!Q\u0001\nYDQa\u001a\u0004\u0005\u0002qD\u0001\"!\u0001\u0007\u0005\u0004%IA\u001f\u0005\b\u0003\u00071\u0001\u0015!\u0003w\u0011!\t)A\u0002b\u0001\n\u0013Q\bbBA\u0004\r\u0001\u0006IA\u001e\u0005\t\u0003\u00131!\u0019!C\u0001u\"9\u00111\u0002\u0004!\u0002\u00131\b\u0002CA\u0007\r\t\u0007I\u0011\u0001>\t\u000f\u0005=a\u0001)A\u0005m\"A\u0011\u0011\u0003\u0004C\u0002\u0013%!\u0010C\u0004\u0002\u0014\u0019\u0001\u000b\u0011\u0002<\t\u0013\u0005Ua\u00011A\u0005\n\u0005]\u0001\"CA\u0010\r\u0001\u0007I\u0011BA\u0011\u0011!\tiC\u0002Q!\n\u0005e\u0001\"CA\u0018\r\u0001\u0007I\u0011BA\u0019\u0011%\tID\u0002a\u0001\n\u0013\tY\u0004\u0003\u0005\u0002@\u0019\u0001\u000b\u0015BA\u001a\u0011!\t\tE\u0002a\u0001\n\u0013Q\b\"CA\"\r\u0001\u0007I\u0011BA#\u0011\u001d\tIE\u0002Q!\nYD\u0001\"a\u0013\u0007\u0001\u0004%IA\u001f\u0005\n\u0003\u001b2\u0001\u0019!C\u0005\u0003\u001fBq!a\u0015\u0007A\u0003&a\u000f\u0003\u0005\u0002V\u0019\u0001\r\u0011\"\u0003{\u0011%\t9F\u0002a\u0001\n\u0013\tI\u0006C\u0004\u0002^\u0019\u0001\u000b\u0015\u0002<\t\u0011\u0005}c\u00011A\u0005\niD\u0011\"!\u0019\u0007\u0001\u0004%I!a\u0019\t\u000f\u0005\u001dd\u0001)Q\u0005m\"1\u0011\u0011\u000e\u0004\u0005\u0012iDa!a\u001b\u0007\t#Q\bBBA7\r\u0011E!\u0010\u0003\u0004\u0002p\u0019!\tB\u001f\u0005\t\u0003c2\u0001\u0019!C\u0005u\"I\u00111\u000f\u0004A\u0002\u0013%\u0011Q\u000f\u0005\b\u0003s2\u0001\u0015)\u0003w\u0011!\tYH\u0002a\u0001\n\u0013Q\b\"CA?\r\u0001\u0007I\u0011BA@\u0011\u001d\t\u0019I\u0002Q!\nYD\u0001\"!\"\u0007\u0001\u0004%IA\u001f\u0005\n\u0003\u000f3\u0001\u0019!C\u0005\u0003\u0013Cq!!$\u0007A\u0003&a\u000f\u0003\u0005\u0002\u0010\u001a\u0001\r\u0011\"\u0003{\u0011%\t\tJ\u0002a\u0001\n\u0013\t\u0019\nC\u0004\u0002\u0018\u001a\u0001\u000b\u0015\u0002<\t\u0013\u0005ee\u00011A\u0005\u0002\u0005m\u0005\"CAY\r\u0001\u0007I\u0011AAZ\u0011!\t9L\u0002Q!\n\u0005u\u0005\u0002CA]\r\u0001\u0007I\u0011\u0002>\t\u0013\u0005mf\u00011A\u0005\n\u0005u\u0006bBAa\r\u0001\u0006KA\u001e\u0005\t\u0003\u00074\u0001\u0019!C\u0005u\"I\u0011Q\u0019\u0004A\u0002\u0013%\u0011q\u0019\u0005\b\u0003\u00174\u0001\u0015)\u0003w\u0011\u0019\tiM\u0002C\u0001u\"1\u0011q\u001a\u0004\u0005\u0002iDq!!5\u0007\t\u0003\t\t\u0004\u0003\u0004\u0002T\u001a!\tA\u001f\u0005\u0007\u0003+4A\u0011\u0001>\t\u000f\u0005]g\u0001\"\u0001\u0002Z\"9\u0011q\u001c\u0004\u0005\u0002\u0005\u0005\bbBAt\r\u0011\u0005\u0011\u0011\u001e\u0005\n\u0003k4!\u0019!C\u0001\u0003oD\u0001\"!@\u0007A\u0003%\u0011\u0011 \u0005\n\u0005\u000b1!\u0019!C\u0001\u0005\u000fA\u0001B!\u0004\u0007A\u0003%!\u0011\u0002\u0005\n\u0005\u001f1!\u0019!C\u0001\u0005#A\u0001Ba\u0006\u0007A\u0003%!1\u0003\u0005\b\u000531A\u0011\u0003B\u000e\u0011\u001d\u0011\tC\u0002C\t\u0005GAqAa\n\u0007\t#\u0011I\u0003C\u0004\u0003.\u0019!\tAa\f\u0002\r\r+(o]8s\u0015\t)f+A\u0003g_\u000e\fGN\u0003\u0002X1\u0006QQ.\u00199bY\u001e,'M]1\u000b\u0005eS\u0016A\u0002:bgR,'OC\u0001\\\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001!\tq\u0016!D\u0001U\u0005\u0019\u0019UO]:peN\u0011\u0011!\u0019\t\u0003E\u0016l\u0011a\u0019\u0006\u0002I\u0006)1oY1mC&\u0011am\u0019\u0002\u0007\u0003:L(+\u001a4\u0002\rqJg.\u001b;?)\u0005i\u0016!B1qa2LHcB6\u0003H\t%#1\u000b\t\u0003=\u001a\u0019\"AB1\u0002\u0003I\u0004\"a\u001c9\u000e\u0003aK!!\u001d-\u0003\tQKG.Z\u0001\rC:\fG._:jg\u0006\u0013X-\u0019\t\u0004_R4\u0018BA;Y\u0005)9%/\u001b3C_VtGm\u001d\t\u0003E^L!\u0001_2\u0003\u0007%sG/\u0001\u0004fqR,g\u000e^\u000b\u0002m\u00069Q\r\u001f;f]R\u0004C\u0003B6~}~DQ!\\\u0006A\u00029DQA]\u0006A\u0002MDQ!_\u0006A\u0002Y\fAA]8xg\u0006)!o\\<tA\u0005!1m\u001c7t\u0003\u0015\u0019w\u000e\\:!\u0003I\tg.\u00197zg&\u001cxJ\u001a4tKR\u001cu\u000e\\:\u0002'\u0005t\u0017\r\\=tSN|eMZ:fi\u000e{Gn\u001d\u0011\u0002%\u0005t\u0017\r\\=tSN|eMZ:fiJ{wo]\u0001\u0014C:\fG._:jg>3gm]3u%><8\u000fI\u0001\u0002I\u0006\u0011A\rI\u0001\u0005[\u0006\u001c8.\u0006\u0002\u0002\u001aA\u0019a,a\u0007\n\u0007\u0005uAK\u0001\u0006DkJ\u001cxN]'bg.\f\u0001\"\\1tW~#S-\u001d\u000b\u0005\u0003G\tI\u0003E\u0002c\u0003KI1!a\nd\u0005\u0011)f.\u001b;\t\u0013\u0005-r#!AA\u0002\u0005e\u0011a\u0001=%c\u0005)Q.Y:lA\u00059\u0001.Y:NCN\\WCAA\u001a!\r\u0011\u0017QG\u0005\u0004\u0003o\u0019'a\u0002\"p_2,\u0017M\\\u0001\fQ\u0006\u001cX*Y:l?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0005u\u0002\"CA\u00165\u0005\u0005\t\u0019AA\u001a\u0003!A\u0017m]'bg.\u0004\u0013aB0d_2l\u0017N\\\u0001\f?\u000e|G.\\5o?\u0012*\u0017\u000f\u0006\u0003\u0002$\u0005\u001d\u0003\u0002CA\u0016;\u0005\u0005\t\u0019\u0001<\u0002\u0011}\u001bw\u000e\\7j]\u0002\nqaX2pY6\f\u00070A\u0006`G>dW.\u0019=`I\u0015\fH\u0003BA\u0012\u0003#B\u0001\"a\u000b!\u0003\u0003\u0005\rA^\u0001\t?\u000e|G.\\1yA\u00059qL]8x[&t\u0017aC0s_^l\u0017N\\0%KF$B!a\t\u0002\\!A\u00111F\u0012\u0002\u0002\u0003\u0007a/\u0001\u0005`e><X.\u001b8!\u0003\u001dy&o\\<nCb\f1b\u0018:po6\f\u0007p\u0018\u0013fcR!\u00111EA3\u0011!\tYCJA\u0001\u0002\u00041\u0018\u0001C0s_^l\u0017\r\u001f\u0011\u0002\r\r|G.\\5o\u0003\u0019\u0019w\u000e\\7bq\u00061!o\\<nS:\faA]8x[\u0006D\u0018\u0001C1eI\u0016$7i\u001c7\u0002\u0019\u0005$G-\u001a3D_2|F%Z9\u0015\t\u0005\r\u0012q\u000f\u0005\t\u0003Wi\u0013\u0011!a\u0001m\u0006I\u0011\r\u001a3fI\u000e{G\u000eI\u0001\u000be\u0016lwN^3e\u0007>d\u0017A\u0004:f[>4X\rZ\"pY~#S-\u001d\u000b\u0005\u0003G\t\t\t\u0003\u0005\u0002,A\n\t\u00111\u0001w\u0003-\u0011X-\\8wK\u0012\u001cu\u000e\u001c\u0011\u0002\u0011\u0005$G-\u001a3S_^\fA\"\u00193eK\u0012\u0014vn^0%KF$B!a\t\u0002\f\"A\u00111F\u001a\u0002\u0002\u0003\u0007a/A\u0005bI\u0012,GMU8xA\u0005Q!/Z7pm\u0016$'k\\<\u0002\u001dI,Wn\u001c<fIJ{wo\u0018\u0013fcR!\u00111EAK\u0011!\tYCNA\u0001\u0002\u00041\u0018a\u0003:f[>4X\r\u001a*po\u0002\n\u0001\"\\8wK6,g\u000e^\u000b\u0003\u0003;\u0013R!a(b\u0003W3a!!)\u0001\u0001\u0005u%\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0014\u0002BAS\u0003O\u000b1BT8N_Z,W.\u001a8uA)\u0019\u0011\u0011\u0016+\u0002\u00115{g/Z7f]R\u00042AXAW\u0013\r\ty\u000b\u0016\u0002\t\u001b>4X-\\3oi\u0006aQn\u001c<f[\u0016tGo\u0018\u0013fcR!\u00111EA[\u0011%\tY#OA\u0001\u0002\u0004\ti*A\u0005n_Z,W.\u001a8uA\u0005!qlY8m\u0003!y6m\u001c7`I\u0015\fH\u0003BA\u0012\u0003\u007fC\u0001\"a\u000b=\u0003\u0003\u0005\rA^\u0001\u0006?\u000e|G\u000eI\u0001\u0005?J|w/\u0001\u0005`e><x\fJ3r)\u0011\t\u0019#!3\t\u0011\u0005-r(!AA\u0002Y\fQa\u0018:po\u0002\n\u0001BZ8dkN\u001cu\u000e\\\u0001\tM>\u001cWo\u001d*po\u00069\u0011n\u001d*fg\u0016$\u0018aA2pY\u0006\u0019!o\\<\u0002\u0011\r,g\u000e^3s\u001f:$b!a\t\u0002\\\u0006u\u0007BBAj\r\u0002\u0007a\u000f\u0003\u0004\u0002V\u001a\u0003\rA^\u0001\u0005[>4X\r\u0006\u0003\u0002$\u0005\r\bbBAs\u000f\u0002\u0007\u00111V\u0001\u0002[\u000691/\u001a;NCN\\G\u0003BA\u0012\u0003WDq!!<I\u0001\u0004\ty/A\u0001g!\u001d\u0011\u0017\u0011\u001f<w\u0003gI1!a=d\u0005%1UO\\2uS>t''\u0001\u0005bY2\u001cU\r\u001c7t+\t\tIPE\u0003\u0002|\u0006\fyP\u0002\u0004\u0002\"*\u0003\u0011\u0011`\u0001\nC2d7)\u001a7mg\u0002\u00022a\u001cB\u0001\u0013\r\u0011\u0019\u0001\u0017\u0002\b\u0007\u0016dGnU3u\u0003)\tG\rZ3e\u0007\u0016dGn]\u000b\u0003\u0005\u0013\u0011RAa\u0003b\u0003\u007f4a!!)M\u0001\t%\u0011aC1eI\u0016$7)\u001a7mg\u0002\nAB]3n_Z,GmQ3mYN,\"Aa\u0005\u0013\u000b\tU\u0011-a@\u0007\r\u0005\u0005f\n\u0001B\n\u00035\u0011X-\\8wK\u0012\u001cU\r\u001c7tA\u00059am\u001c:fC\u000eDG\u0003BA\u0012\u0005;Aq!!<P\u0001\u0004\u0011y\u0002E\u0004c\u0003c4h/a\t\u0002\u0019\u0019|'/Z1dQ\u0006#G-\u001a3\u0015\t\u0005\r\"Q\u0005\u0005\b\u0003[\u0004\u0006\u0019\u0001B\u0010\u000391wN]3bG\"\u0014V-\\8wK\u0012$B!a\t\u0003,!9\u0011Q^)A\u0002\t}\u0011!C1tG&LGI]1x+\t\u0011\t\u0004\u0005\u0003\u00034\t\u0005c\u0002\u0002B\u001b\u0005{\u00012Aa\u000ed\u001b\t\u0011IDC\u0002\u0003<q\u000ba\u0001\u0010:p_Rt\u0014b\u0001B G\u00061\u0001K]3eK\u001aLAAa\u0011\u0003F\t11\u000b\u001e:j]\u001eT1Aa\u0010d\u0011\u0015i7\u00011\u0001o\u0011\u001d\u0011Ye\u0001a\u0001\u0005\u001b\n\u0011A\u001c\t\u0004=\n=\u0013b\u0001B))\naa*Z5hQ\n|'\u000f[8pI\")!o\u0001a\u0001gR)1Na\u0016\u0003Z!)Q\u000e\u0002a\u0001]\"9!1\n\u0003A\u0002\t5C#B6\u0003^\t}\u0003\"B7\u0006\u0001\u0004q\u0007\"B=\u0006\u0001\u00041\b")
public class Cursor {
    private final Tile r;
    private final int extent;
    private final int rows;
    private final int cols;
    private final int analysisOffsetCols;
    private final int analysisOffsetRows;
    private final int d;
    private CursorMask mask;
    private boolean hasMask;
    private int _colmin;
    private int _colmax;
    private int _rowmin;
    private int _rowmax;
    private int addedCol;
    private int removedCol;
    private int addedRow;
    private int removedRow;
    private Movement movement;
    private int _col;
    private int _row;
    private final CellSet allCells;
    private final CellSet addedCells;
    private final CellSet removedCells;

    public static Cursor apply(Tile tile, int n) {
        return Cursor$.MODULE$.apply(tile, n);
    }

    public static Cursor apply(Tile tile, Neighborhood neighborhood) {
        return Cursor$.MODULE$.apply(tile, neighborhood);
    }

    public static Cursor apply(Tile tile, Neighborhood neighborhood, GridBounds<Object> gridBounds) {
        return Cursor$.MODULE$.apply(tile, neighborhood, gridBounds);
    }

    public int extent() {
        return this.extent;
    }

    private int rows() {
        return this.rows;
    }

    private int cols() {
        return this.cols;
    }

    public int analysisOffsetCols() {
        return this.analysisOffsetCols;
    }

    public int analysisOffsetRows() {
        return this.analysisOffsetRows;
    }

    private int d() {
        return this.d;
    }

    private CursorMask mask() {
        return this.mask;
    }

    private void mask_$eq(CursorMask x$1) {
        this.mask = x$1;
    }

    private boolean hasMask() {
        return this.hasMask;
    }

    private void hasMask_$eq(boolean x$1) {
        this.hasMask = x$1;
    }

    private int _colmin() {
        return this._colmin;
    }

    private void _colmin_$eq(int x$1) {
        this._colmin = x$1;
    }

    private int _colmax() {
        return this._colmax;
    }

    private void _colmax_$eq(int x$1) {
        this._colmax = x$1;
    }

    private int _rowmin() {
        return this._rowmin;
    }

    private void _rowmin_$eq(int x$1) {
        this._rowmin = x$1;
    }

    private int _rowmax() {
        return this._rowmax;
    }

    private void _rowmax_$eq(int x$1) {
        this._rowmax = x$1;
    }

    public int colmin() {
        return this._colmin();
    }

    public int colmax() {
        return this._colmax();
    }

    public int rowmin() {
        return this._rowmin();
    }

    public int rowmax() {
        return this._rowmax();
    }

    private int addedCol() {
        return this.addedCol;
    }

    private void addedCol_$eq(int x$1) {
        this.addedCol = x$1;
    }

    private int removedCol() {
        return this.removedCol;
    }

    private void removedCol_$eq(int x$1) {
        this.removedCol = x$1;
    }

    private int addedRow() {
        return this.addedRow;
    }

    private void addedRow_$eq(int x$1) {
        this.addedRow = x$1;
    }

    private int removedRow() {
        return this.removedRow;
    }

    private void removedRow_$eq(int x$1) {
        this.removedRow = x$1;
    }

    public Movement movement() {
        return this.movement;
    }

    public void movement_$eq(Movement x$1) {
        this.movement = x$1;
    }

    private int _col() {
        return this._col;
    }

    private void _col_$eq(int x$1) {
        this._col = x$1;
    }

    private int _row() {
        return this._row;
    }

    private void _row_$eq(int x$1) {
        this._row = x$1;
    }

    public int focusCol() {
        return this._col();
    }

    public int focusRow() {
        return this._row();
    }

    public boolean isReset() {
        Movement movement = this.movement();
        Movement movement2 = Movement$.MODULE$.NoMovement();
        return !(movement != null ? !movement.equals(movement2) : movement2 != null);
    }

    public int col() {
        return this._col() - this.analysisOffsetCols();
    }

    public int row() {
        return this._row() - this.analysisOffsetRows();
    }

    public void centerOn(int col, int row) {
        this.movement_$eq(Movement$.MODULE$.NoMovement());
        this._col_$eq(col);
        this._row_$eq(row);
        this._colmin_$eq(package$.MODULE$.max(0, this._col() - this.extent()));
        this._colmax_$eq(package$.MODULE$.min(this.cols() - 1, this._col() + this.extent()));
        this._rowmin_$eq(package$.MODULE$.max(0, this._row() - this.extent()));
        this._rowmax_$eq(package$.MODULE$.min(this.rows() - 1, this._row() + this.extent()));
    }

    public void move(Movement m) {
        this.movement_$eq(m);
        Movement movement = m;
        Movement movement2 = Movement$.MODULE$.Up();
        Movement movement3 = movement;
        if (!(movement2 != null ? !movement2.equals(movement3) : movement3 != null)) {
            this.addedRow_$eq(this._rowmin() - 1);
            this.removedRow_$eq(this._row() + this.extent());
            this._row_$eq(this._row() - 1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Movement movement4 = Movement$.MODULE$.Down();
            Movement movement5 = movement;
            if (!(movement4 != null ? !movement4.equals(movement5) : movement5 != null)) {
                this.addedRow_$eq(this._rowmax() + 1);
                this.removedRow_$eq(this._row() - this.extent());
                this._row_$eq(this._row() + 1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Movement movement6 = Movement$.MODULE$.Left();
                Movement movement7 = movement;
                if (!(movement6 != null ? !movement6.equals(movement7) : movement7 != null)) {
                    this.addedCol_$eq(this._colmin() - 1);
                    this.removedCol_$eq(this._col() + this.extent());
                    this._col_$eq(this._col() - 1);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Movement movement8 = Movement$.MODULE$.Right();
                    Movement movement9 = movement;
                    if (!(movement8 != null ? !movement8.equals(movement9) : movement9 != null)) {
                        this.addedCol_$eq(this._colmax() + 1);
                        this.removedCol_$eq(this._col() - this.extent());
                        this._col_$eq(this._col() + 1);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
        }
        this._colmin_$eq(package$.MODULE$.max(0, this._col() - this.extent()));
        this._colmax_$eq(package$.MODULE$.min(this.cols() - 1, this._col() + this.extent()));
        this._rowmin_$eq(package$.MODULE$.max(0, this._row() - this.extent()));
        this._rowmax_$eq(package$.MODULE$.min(this.rows() - 1, this._row() + this.extent()));
    }

    public void setMask(Function2<Object, Object, Object> f) {
        this.hasMask_$eq(true);
        this.mask_$eq(new CursorMask(this.d(), f));
    }

    public CellSet allCells() {
        return this.allCells;
    }

    public CellSet addedCells() {
        return this.addedCells;
    }

    public CellSet removedCells() {
        return this.removedCells;
    }

    public void foreach(Function2<Object, Object, BoxedUnit> f) {
        if (!this.hasMask()) {
            int x2 = 0;
            for (int y = this._rowmin(); y <= this._rowmax(); ++y) {
                for (x2 = this._colmin(); x2 <= this._colmax(); ++x2) {
                    f.apply$mcVII$sp(x2, y);
                }
            }
        } else {
            IntRef y = IntRef.create((int)0);
            while (y.elem < this.d()) {
                this.mask().foreachX(y.elem, (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> {
                    block0: {
                        int xTile = x + (this._col() - this.extent());
                        int yTile = y$1.elem + (this._row() - this.extent());
                        if (this._colmin() > xTile || xTile > this._colmax() || this._rowmin() > yTile || yTile > this._rowmax()) break block0;
                        f.apply$mcVII$sp(xTile, yTile);
                    }
                });
                ++y.elem;
            }
        }
    }

    public void foreachAdded(Function2<Object, Object, BoxedUnit> f) {
        block14: {
            Movement movement = this.movement();
            Movement movement2 = Movement$.MODULE$.NoMovement();
            if (!(movement != null ? !movement.equals(movement2) : movement2 != null)) {
                this.foreach(f);
            } else if (this.movement().isVertical()) {
                if (0 <= this.addedRow() && this.addedRow() < this.rows()) {
                    if (!this.hasMask()) {
                        for (int x2 = this._colmin(); x2 <= this._colmax(); ++x2) {
                            f.apply$mcVII$sp(x2, this.addedRow());
                        }
                    } else {
                        this.mask().foreachX(this.addedRow() - (this._row() - this.extent()), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> {
                            block0: {
                                int xTile = x + (this._col() - this.extent());
                                if (0 > xTile || xTile > this.cols()) break block0;
                                f.apply$mcVII$sp(xTile, this.addedRow());
                            }
                        });
                    }
                }
            } else if (0 <= this.addedCol() && this.addedCol() < this.cols()) {
                if (!this.hasMask()) {
                    for (int y2 = this._rowmin(); y2 <= this._rowmax(); ++y2) {
                        f.apply$mcVII$sp(this.addedCol(), y2);
                    }
                } else {
                    Movement movement3 = this.movement();
                    Movement movement4 = Movement$.MODULE$.Left();
                    if (!(movement3 != null ? !movement3.equals(movement4) : movement4 != null)) {
                        this.mask().foreachWestColumn((Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> {
                            block0: {
                                int yTile = y + (this._row() - this.extent());
                                if (0 > yTile || yTile >= this.rows()) break block0;
                                f.apply$mcVII$sp(this.addedCol(), yTile);
                            }
                        });
                    } else {
                        this.mask().foreachEastColumn((Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> {
                            block0: {
                                int yTile = y + (this._row() - this.extent());
                                if (0 > yTile || yTile >= this.rows()) break block0;
                                f.apply$mcVII$sp(this.addedCol(), yTile);
                            }
                        });
                    }
                }
            }
            if (!this.hasMask()) break block14;
            this.mask().foreachUnmasked(this.movement(), (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> {
                block0: {
                    int xTile = x + (this._col() - this.extent());
                    int yTile = y + (this._row() - this.extent());
                    if (0 > xTile || xTile >= this.cols() || 0 > yTile || yTile >= this.rows()) break block0;
                    f.apply$mcVII$sp(xTile, yTile);
                }
            });
        }
    }

    public void foreachRemoved(Function2<Object, Object, BoxedUnit> f) {
        block15: {
            Movement movement = this.movement();
            Movement movement2 = Movement$.MODULE$.NoMovement();
            if (!(movement != null ? !movement.equals(movement2) : movement2 != null)) {
                return;
            }
            if (this.movement().isVertical()) {
                if (0 <= this.removedRow() && this.removedRow() < this.rows()) {
                    if (!this.hasMask()) {
                        for (int x2 = this._colmin(); x2 <= this._colmax(); ++x2) {
                            f.apply$mcVII$sp(x2, this.removedRow());
                        }
                    } else {
                        Movement movement3 = this.movement();
                        Movement movement4 = Movement$.MODULE$.Up();
                        if (!(movement3 != null ? !movement3.equals(movement4) : movement4 != null)) {
                            this.mask().foreachX(this.d() - 1, (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> {
                                block0: {
                                    int xTile = x + (this._col() - this.extent());
                                    if (0 > xTile || xTile >= this.cols()) break block0;
                                    f.apply$mcVII$sp(xTile, this.removedRow());
                                }
                            });
                        } else {
                            this.mask().foreachX(0, (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x -> {
                                block0: {
                                    int xTile = x + (this._col() - this.extent());
                                    if (0 > xTile || xTile >= this.cols()) break block0;
                                    f.apply$mcVII$sp(xTile, this.removedRow());
                                }
                            });
                        }
                    }
                }
            } else if (0 <= this.removedCol() && this.removedCol() < this.cols()) {
                if (!this.hasMask()) {
                    for (int y2 = this._rowmin(); y2 <= this._rowmax(); ++y2) {
                        f.apply$mcVII$sp(this.removedCol(), y2);
                    }
                } else {
                    Movement movement5 = this.movement();
                    Movement movement6 = Movement$.MODULE$.Left();
                    if (!(movement5 != null ? !movement5.equals(movement6) : movement6 != null)) {
                        this.mask().foreachEastColumn((Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> {
                            block0: {
                                int yTile = y + (this._row() - this.extent());
                                if (0 > yTile || yTile >= this.rows()) break block0;
                                f.apply$mcVII$sp(this.removedCol(), yTile);
                            }
                        });
                    } else {
                        this.mask().foreachWestColumn((Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)y -> {
                            block0: {
                                int yTile = y + (this._row() - this.extent());
                                if (0 > yTile || yTile >= this.rows()) break block0;
                                f.apply$mcVII$sp(this.removedCol(), yTile);
                            }
                        });
                    }
                }
            }
            if (!this.hasMask()) break block15;
            this.mask().foreachMasked(this.movement(), (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> {
                block0: {
                    int xTile = x + (this._col() - this.extent());
                    int yTile = y + (this._row() - this.extent());
                    if (0 > xTile || xTile >= this.cols() || 0 > yTile || yTile >= this.rows()) break block0;
                    f.apply$mcVII$sp(xTile, yTile);
                }
            });
        }
    }

    public String asciiDraw() {
        scala.collection.mutable.StringBuilder sb = new scala.collection.mutable.StringBuilder();
        IntRef row = IntRef.create((int)0);
        this.allCells().foreach((Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(cl, rw) -> {
            if (row$1.elem != rw) {
                sb.append("\n");
                ++row$1.elem;
            }
            String s = Integer.toString($this.r.get(cl, rw));
            String pad = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(package$.MODULE$.max(6 - new StringOps(Predef$.MODULE$.augmentString(s)).size(), 0));
            sb.append(new StringBuilder(0).append(pad).append(s).toString());
        });
        return sb.toString();
    }

    public Cursor(Tile r, GridBounds<Object> analysisArea, int extent) {
        this.r = r;
        this.extent = extent;
        this.rows = r.rows$mcI$sp();
        this.cols = r.cols$mcI$sp();
        this.analysisOffsetCols = analysisArea.colMin$mcI$sp();
        this.analysisOffsetRows = analysisArea.rowMin$mcI$sp();
        this.d = 2 * extent + 1;
        this.mask = null;
        this.hasMask = false;
        this._colmin = 0;
        this._colmax = 0;
        this._rowmin = 0;
        this._rowmax = 0;
        this.addedCol = 0;
        this.removedCol = 0;
        this.addedRow = 0;
        this.removedRow = 0;
        this.movement = Movement$.MODULE$.NoMovement();
        this._col = 0;
        this._row = 0;
        this.allCells = new CellSet(this){
            private final /* synthetic */ Cursor $outer;

            public void foreach(Function2<Object, Object, BoxedUnit> f) {
                this.$outer.foreach(f);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.addedCells = new CellSet(this){
            private final /* synthetic */ Cursor $outer;

            public void foreach(Function2<Object, Object, BoxedUnit> f) {
                this.$outer.foreachAdded(f);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.removedCells = new CellSet(this){
            private final /* synthetic */ Cursor $outer;

            public void foreach(Function2<Object, Object, BoxedUnit> f) {
                this.$outer.foreachRemoved(f);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

