/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector.voronoi;

import geotrellis.vector.Extent;
import geotrellis.vector.Point$;
import geotrellis.vector.Polygon$;
import geotrellis.vector.RobustPredicates$;
import geotrellis.vector.mesh.CompleteIndexedPointSet;
import geotrellis.vector.mesh.HalfEdgeTable;
import geotrellis.vector.mesh.IndexedPointSet$;
import geotrellis.vector.triangulation.DelaunayTriangulation;
import geotrellis.vector.triangulation.DelaunayTriangulation$;
import geotrellis.vector.voronoi.VoronoiDiagram;
import geotrellis.vector.voronoi.VoronoiDiagram$V2$;
import java.io.Serializable;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class VoronoiDiagram$
implements scala.Serializable {
    public static VoronoiDiagram$ MODULE$;

    static {
        new VoronoiDiagram$();
    }

    public VoronoiDiagram apply(Coordinate[] pts, Extent extent, boolean debug) {
        CompleteIndexedPointSet x$1 = IndexedPointSet$.MODULE$.coordinateArrayToIndexedPointSet(pts);
        boolean x$2 = debug;
        double x$3 = DelaunayTriangulation$.MODULE$.apply$default$2();
        DelaunayTriangulation dt = DelaunayTriangulation$.MODULE$.apply(x$1, x$3, x$2);
        return new VoronoiDiagram(dt, extent);
    }

    public boolean apply$default$3() {
        return false;
    }

    private final double EPSILON() {
        return 1.0E-10;
    }

    private ListBuffer<VoronoiDiagram.CellBound> cellBoundsNew(HalfEdgeTable het, Function1<Object, Coordinate> verts, Extent extent, int incidentEdge) {
        int e = incidentEdge;
        VoronoiDiagram.V2 origin = VoronoiDiagram$V2$.MODULE$.apply((Coordinate)verts.apply((Object)BoxesRunTime.boxToInteger((int)het.getDest(e))));
        ListBuffer l = (ListBuffer)ListBuffer$.MODULE$.empty();
        do {
            VoronoiDiagram.V2 vplus = VoronoiDiagram$V2$.MODULE$.apply((Coordinate)verts.apply((Object)BoxesRunTime.boxToInteger((int)het.getSrc(het.rotCCWDest(e))))).$minus(origin);
            VoronoiDiagram.V2 v = VoronoiDiagram$V2$.MODULE$.apply((Coordinate)verts.apply((Object)BoxesRunTime.boxToInteger((int)het.getSrc(e)))).$minus(origin);
            VoronoiDiagram.V2 vminus = VoronoiDiagram$V2$.MODULE$.apply((Coordinate)verts.apply((Object)BoxesRunTime.boxToInteger((int)het.getSrc(het.rotCWDest(e))))).$minus(origin);
            VoronoiDiagram.V2 xplus = origin.$plus(vplus.$times(0.5));
            VoronoiDiagram.V2 x = origin.$plus(v.$times(0.5));
            VoronoiDiagram.V2 xminus = origin.$plus(vminus.$times(0.5));
            VoronoiDiagram.V2 norm = v.rot90CCW().normalize();
            double aplus = -x.$minus(xplus).dot(vplus) / norm.dot(vplus);
            double aminus = -x.$minus(xminus).dot(vminus) / norm.dot(vminus);
            Object object = package$.MODULE$.abs(norm.dot(vplus)) < 1.0E-10 ? (package$.MODULE$.abs(norm.dot(vminus)) < 1.0E-10 ? l.$plus$plus$eq((TraversableOnce)new .colon.colon((Object)new VoronoiDiagram.Ray(x.toCoord(), norm), (List)Nil$.MODULE$)) : l.$plus$eq((Object)new VoronoiDiagram.Ray(x.$plus(norm.$times(aminus)).toCoord(), norm))) : (package$.MODULE$.abs(norm.dot(vminus)) < 1.0E-10 ? new VoronoiDiagram.ReverseRay(x.$plus(norm.$times(aplus)).toCoord(), norm.$times(-1.0)) : (package$.MODULE$.abs(aplus - aminus) > 1.0E-10 ? (aplus > aminus ? l.$plus$eq((Object)new VoronoiDiagram.BoundedRay(x.$plus(norm.$times(aminus)).toCoord(), norm.$times(aplus - aminus))) : (RobustPredicates$.MODULE$.isCCW(x.x(), x.y(), origin.x(), origin.y(), xminus.x(), xminus.y()) ? l.$plus$eq((Object)new VoronoiDiagram.Ray(x.$plus(norm.$times(aminus)).toCoord(), norm)) : l.$plus$eq((Object)new VoronoiDiagram.ReverseRay(x.$plus(norm.$times(aplus)).toCoord(), norm.$times(-1.0))))) : BoxedUnit.UNIT));
            e = het.rotCCWDest(e);
        } while (e != incidentEdge);
        return l;
    }

    private Option<Polygon> cellExtentIntersection(HalfEdgeTable het, Function1<Object, Coordinate> verts, int incidentEdge, ListBuffer<VoronoiDiagram.CellBound> cell, Extent extent) {
        None$ none$;
        Extent extent2 = extent;
        if (extent2 == null) {
            throw new MatchError((Object)extent2);
        }
        double xmin = extent2.xmin();
        double ymin = extent2.ymin();
        double xmax = extent2.xmax();
        double ymax = extent2.ymax();
        Tuple4 tuple42 = new Tuple4((Object)BoxesRunTime.boxToDouble((double)xmin), (Object)BoxesRunTime.boxToDouble((double)ymin), (Object)BoxesRunTime.boxToDouble((double)xmax), (Object)BoxesRunTime.boxToDouble((double)ymax));
        Tuple4 tuple43 = tuple42;
        double xmin2 = BoxesRunTime.unboxToDouble((Object)tuple43._1());
        double ymin2 = BoxesRunTime.unboxToDouble((Object)tuple43._2());
        double xmax2 = BoxesRunTime.unboxToDouble((Object)tuple43._3());
        double ymax2 = BoxesRunTime.unboxToDouble((Object)tuple43._4());
        ListBuffer expts = (ListBuffer)((TraversableLike)ListBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcDD.sp(xmin2, ymin2), new Tuple2.mcDD.sp(xmax2, ymin2), new Tuple2.mcDD.sp(xmax2, ymax2), new Tuple2.mcDD.sp(xmin2, ymax2)}))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple22 = x0$1;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            double x = tuple22._1$mcD$sp();
            double y = tuple22._2$mcD$sp();
            Coordinate coordinate = new Coordinate(x, y);
            return coordinate;
        }, ListBuffer$.MODULE$.canBuildFrom());
        ListBuffer clippedCorners = (ListBuffer)cell.foldLeft((Object)expts, (Function2 & Serializable & scala.Serializable)(poly, bound) -> VoronoiDiagram$.clipToCellBound$1(poly, bound));
        if (clippedCorners.isEmpty()) {
            none$ = None$.MODULE$;
        } else {
            clippedCorners.$plus$eq(clippedCorners.head());
            Polygon poly2 = Polygon$.MODULE$.apply((Seq<Point>)((ListBuffer)clippedCorners.map((Function1 & Serializable & scala.Serializable)x$7 -> Point$.MODULE$.apply((Coordinate)x$7), ListBuffer$.MODULE$.canBuildFrom())).toSeq());
            none$ = new Some((Object)poly2);
        }
        return none$;
    }

    public Option<Polygon> polygonalCell(HalfEdgeTable het, Function1<Object, Coordinate> verts, Extent extent, int incidentEdge) {
        ListBuffer<VoronoiDiagram.CellBound> cell = this.cellBoundsNew(het, verts, extent, incidentEdge);
        return this.cellExtentIntersection(het, verts, incidentEdge, cell, extent);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final boolean isContained$1(Coordinate c, VoronoiDiagram.CellBound bound$1) {
        Tuple2 tuple22;
        VoronoiDiagram.CellBound cellBound = bound$1;
        if (cellBound instanceof VoronoiDiagram.BoundedRay) {
            VoronoiDiagram.BoundedRay boundedRay = (VoronoiDiagram.BoundedRay)cellBound;
            Coordinate base = boundedRay.base();
            VoronoiDiagram.V2 dir = boundedRay.dir();
            tuple22 = new Tuple2((Object)base, (Object)dir);
        } else if (cellBound instanceof VoronoiDiagram.Ray) {
            VoronoiDiagram.Ray ray = (VoronoiDiagram.Ray)cellBound;
            Coordinate base = ray.base();
            VoronoiDiagram.V2 dir = ray.dir();
            tuple22 = new Tuple2((Object)base, (Object)dir);
        } else if (cellBound instanceof VoronoiDiagram.ReverseRay) {
            VoronoiDiagram.ReverseRay reverseRay = (VoronoiDiagram.ReverseRay)cellBound;
            Coordinate base = reverseRay.base();
            VoronoiDiagram.V2 dir = reverseRay.dir();
            tuple22 = new Tuple2((Object)base, (Object)dir.$times(-1.0));
        } else {
            throw new MatchError((Object)cellBound);
        }
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        Coordinate base = (Coordinate)tuple23._1();
        VoronoiDiagram.V2 dir = (VoronoiDiagram.V2)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)base, (Object)dir);
        Tuple2 tuple25 = tuple24;
        Coordinate base2 = (Coordinate)tuple25._1();
        VoronoiDiagram.V2 dir2 = (VoronoiDiagram.V2)tuple25._2();
        return !RobustPredicates$.MODULE$.isCCW(base2.x + dir2.x(), base2.y + dir2.y(), base2.x, base2.y, c.x, c.y);
    }

    private static final Coordinate crossing$1(Coordinate ca, Coordinate cb, VoronoiDiagram.CellBound bound$1) {
        Tuple2 tuple22;
        VoronoiDiagram.CellBound cellBound = bound$1;
        if (cellBound instanceof VoronoiDiagram.BoundedRay) {
            VoronoiDiagram.BoundedRay boundedRay = (VoronoiDiagram.BoundedRay)cellBound;
            Coordinate base = boundedRay.base();
            VoronoiDiagram.V2 dir = boundedRay.dir();
            tuple22 = new Tuple2((Object)VoronoiDiagram$V2$.MODULE$.apply(base), (Object)dir);
        } else if (cellBound instanceof VoronoiDiagram.Ray) {
            VoronoiDiagram.Ray ray = (VoronoiDiagram.Ray)cellBound;
            Coordinate base = ray.base();
            VoronoiDiagram.V2 dir = ray.dir();
            tuple22 = new Tuple2((Object)VoronoiDiagram$V2$.MODULE$.apply(base), (Object)dir);
        } else if (cellBound instanceof VoronoiDiagram.ReverseRay) {
            VoronoiDiagram.ReverseRay reverseRay = (VoronoiDiagram.ReverseRay)cellBound;
            Coordinate base = reverseRay.base();
            VoronoiDiagram.V2 dir = reverseRay.dir();
            tuple22 = new Tuple2((Object)VoronoiDiagram$V2$.MODULE$.apply(base), (Object)dir);
        } else {
            throw new MatchError((Object)cellBound);
        }
        Tuple2 tuple23 = tuple22;
        if (tuple23 == null) {
            throw new MatchError((Object)tuple23);
        }
        VoronoiDiagram.V2 base = (VoronoiDiagram.V2)tuple23._1();
        VoronoiDiagram.V2 dir = (VoronoiDiagram.V2)tuple23._2();
        Tuple2 tuple24 = new Tuple2((Object)base, (Object)dir);
        Tuple2 tuple25 = tuple24;
        VoronoiDiagram.V2 base2 = (VoronoiDiagram.V2)tuple25._1();
        VoronoiDiagram.V2 dir2 = (VoronoiDiagram.V2)tuple25._2();
        VoronoiDiagram.V2 norm = dir2.rot90CCW();
        VoronoiDiagram.V2 a = VoronoiDiagram$V2$.MODULE$.apply(ca);
        VoronoiDiagram.V2 v = VoronoiDiagram$V2$.MODULE$.apply(cb).$minus(a);
        double alpha = base2.$minus(a).dot(norm) / v.dot(norm);
        return a.$plus(v.$times(alpha)).toCoord();
    }

    private static final ListBuffer clipToCellBound$1(ListBuffer poly, VoronoiDiagram.CellBound bound) {
        int n = poly.length();
        ListBuffer result = (ListBuffer)ListBuffer$.MODULE$.empty();
        ListBuffer contained = (ListBuffer)poly.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)VoronoiDiagram$.isContained$1(x$4, bound)), ListBuffer$.MODULE$.canBuildFrom());
        for (int index$macro$1 = 0; index$macro$1 < n; ++index$macro$1) {
            BoxedUnit boxedUnit;
            Coordinate v3 = (Coordinate)poly.apply(index$macro$1);
            Coordinate v4 = (Coordinate)poly.apply((index$macro$1 + 1) % n);
            Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(BoxesRunTime.unboxToBoolean((Object)contained.apply(index$macro$1)), BoxesRunTime.unboxToBoolean((Object)contained.apply((index$macro$1 + 1) % n)));
            if (sp2 != null) {
                boolean bl = sp2._1$mcZ$sp();
                boolean bl2 = sp2._2$mcZ$sp();
                if (bl && bl2) {
                    result.$plus$eq((Object)v3);
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (sp2 != null) {
                boolean bl = sp2._1$mcZ$sp();
                boolean bl3 = sp2._2$mcZ$sp();
                if (bl && !bl3) {
                    result.$plus$plus$eq((TraversableOnce)new .colon.colon((Object)v3, (List)new .colon.colon((Object)VoronoiDiagram$.crossing$1(v3, v4, bound), (List)Nil$.MODULE$)));
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (sp2 != null) {
                boolean bl = sp2._1$mcZ$sp();
                boolean bl4 = sp2._2$mcZ$sp();
                if (!bl && bl4) {
                    result.$plus$eq((Object)VoronoiDiagram$.crossing$1(v3, v4, bound));
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            if (sp2 != null) {
                boolean bl = sp2._1$mcZ$sp();
                boolean bl5 = sp2._2$mcZ$sp();
                if (!bl && !bl5) {
                    boxedUnit = BoxedUnit.UNIT;
                    continue;
                }
            }
            throw new MatchError((Object)sp2);
        }
        return result;
    }

    private VoronoiDiagram$() {
        MODULE$ = this;
    }
}

