/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.arg;

import geotrellis.raster.ConstantTile;
import geotrellis.raster.DataType;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.io.arg.ArgWriter$;
import geotrellis.raster.io.arg.CellWriter$;
import geotrellis.vector.Extent;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001\u0002\u000f\u001e\u0001\u001aB\u0001b\r\u0001\u0003\u0016\u0004%\t\u0001\u000e\u0005\t\u0007\u0002\u0011\t\u0012)A\u0005k!)A\t\u0001C\u0001\u000b\")\u0011\n\u0001C\u0001\u0015\")a\n\u0001C\u0001\u001f\")\u0001\f\u0001C\u00013\")\u0011\r\u0001C\u0001E\")\u0001\u000f\u0001C\u0001c\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001bBA\b\u0001\u0011\u0005\u0011\u0011\u0003\u0005\n\u0003G\u0001\u0011\u0011!C\u0001\u0003KA\u0011\"!\u000b\u0001#\u0003%\t!a\u000b\t\u0011\u0005\u0005\u0003!!A\u0005BeC\u0001\"a\u0011\u0001\u0003\u0003%\tA\u0013\u0005\n\u0003\u000b\u0002\u0011\u0011!C\u0001\u0003\u000fB\u0011\"a\u0015\u0001\u0003\u0003%\t%!\u0016\t\u0013\u0005\r\u0004!!A\u0005\u0002\u0005\u0015\u0004\"CA8\u0001\u0005\u0005I\u0011IA9\u0011%\t\u0019\bAA\u0001\n\u0003\n)\bC\u0005\u0002x\u0001\t\t\u0011\"\u0011\u0002z\u001dI\u0011QP\u000f\u0002\u0002#\u0005\u0011q\u0010\u0004\t9u\t\t\u0011#\u0001\u0002\u0002\"1AI\u0006C\u0001\u0003\u001fC\u0011\"a\u001d\u0017\u0003\u0003%)%!\u001e\t\u0013\u0005Ee#!A\u0005\u0002\u0006M\u0005\"CAL-\u0005\u0005I\u0011QAM\u0011%\t)KFA\u0001\n\u0013\t9KA\u0005Be\u001e<&/\u001b;fe*\u0011adH\u0001\u0004CJ<'B\u0001\u0011\"\u0003\tIwN\u0003\u0002#G\u00051!/Y:uKJT\u0011\u0001J\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\n\u0005\u0001\u001dj\u0003\u0007\u0005\u0002)W5\t\u0011FC\u0001+\u0003\u0015\u00198-\u00197b\u0013\ta\u0013F\u0001\u0004B]f\u0014VM\u001a\t\u0003Q9J!aL\u0015\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001&M\u0005\u0003e%\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f\u0001bY3mYRK\b/Z\u000b\u0002kA\u0011a\u0007\u0011\b\u0003oyr!\u0001O\u001f\u000f\u0005ebT\"\u0001\u001e\u000b\u0005m*\u0013A\u0002\u001fs_>$h(C\u0001%\u0013\t\u00113%\u0003\u0002@C\u00059\u0001/Y2lC\u001e,\u0017BA!C\u0005!\u0019U\r\u001c7UsB,'BA \"\u0003%\u0019W\r\u001c7UsB,\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0003\r\"\u0003\"a\u0012\u0001\u000e\u0003uAQaM\u0002A\u0002U\nQa^5ei\",\u0012a\u0013\t\u0003Q1K!!T\u0015\u0003\u0007%sG/\u0001\u0007dK2dG+\u001f9f\u001d\u0006lW-F\u0001Q!\t\tVK\u0004\u0002S'B\u0011\u0011(K\u0005\u0003)&\na\u0001\u0015:fI\u00164\u0017B\u0001,X\u0005\u0019\u0019FO]5oO*\u0011A+K\u0001\tI\u0006$\u0018\rV=qKV\t!\f\u0005\u0002\\A6\tAL\u0003\u0002^=\u0006!A.\u00198h\u0015\u0005y\u0016\u0001\u00026bm\u0006L!A\u0016/\u0002#]\u0014\u0018\u000e^3NKR\fG-\u0019;b\u0015N{e\n\u0006\u0003dM\"T\u0007C\u0001\u0015e\u0013\t)\u0017F\u0001\u0003V]&$\b\"B4\b\u0001\u0004\u0001\u0016\u0001\u00029bi\"DQ![\u0004A\u0002A\u000bAA\\1nK\")1n\u0002a\u0001Y\u0006\u0011!/\u001a\t\u0003[:l\u0011!I\u0005\u0003_\u0006\u0012ABU1ti\u0016\u0014X\t\u001f;f]R\fQa\u001e:ji\u0016$ba\u0019:us\u0006\r\u0001\"B:\t\u0001\u0004\u0001\u0016AD8viB,HOR5mKB\u000bG\u000f\u001b\u0005\u0006k\"\u0001\rA^\u0001\u0005i&dW\r\u0005\u0002no&\u0011\u00010\t\u0002\u0005)&dW\rC\u0003{\u0011\u0001\u000710\u0001\u0004fqR,g\u000e\u001e\t\u0003y~l\u0011! \u0006\u0003}\u000e\naA^3di>\u0014\u0018bAA\u0001{\n1Q\t\u001f;f]RDa!!\u0002\t\u0001\u0004\u0001\u0016\u0001D7fi\u0006$\u0017\r^1OC6,\u0017!C<sSR,G)\u0019;b)\u0015\u0019\u00171BA\u0007\u0011\u00159\u0017\u00021\u0001Q\u0011\u0015)\u0018\u00021\u0001w\u0003E9(/\u001b;f\u0007>t7\u000f^1oiRKG.\u001a\u000b\nG\u0006M\u0011QCA\u0010\u0003CAQa\u001a\u0006A\u0002ACq!a\u0006\u000b\u0001\u0004\tI\"\u0001\u0002diB\u0019Q.a\u0007\n\u0007\u0005u\u0011E\u0001\u0007D_:\u001cH/\u00198u)&dW\rC\u0003j\u0015\u0001\u0007\u0001\u000bC\u0003l\u0015\u0001\u0007A.\u0001\u0003d_BLHc\u0001$\u0002(!91g\u0003I\u0001\u0002\u0004)\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003[Q3!NA\u0018W\t\t\t\u0004\u0005\u0003\u00024\u0005uRBAA\u001b\u0015\u0011\t9$!\u000f\u0002\u0013Ut7\r[3dW\u0016$'bAA\u001eS\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005}\u0012Q\u0007\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005%\u0013q\n\t\u0004Q\u0005-\u0013bAA'S\t\u0019\u0011I\\=\t\u0011\u0005Es\"!AA\u0002-\u000b1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA,!\u0019\tI&a\u0018\u0002J5\u0011\u00111\f\u0006\u0004\u0003;J\u0013AC2pY2,7\r^5p]&!\u0011\u0011MA.\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\t\u0005\u001d\u0014Q\u000e\t\u0004Q\u0005%\u0014bAA6S\t9!i\\8mK\u0006t\u0007\"CA)#\u0005\u0005\t\u0019AA%\u0003!A\u0017m\u001d5D_\u0012,G#A&\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012AW\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u001d\u00141\u0010\u0005\n\u0003#\"\u0012\u0011!a\u0001\u0003\u0013\n\u0011\"\u0011:h/JLG/\u001a:\u0011\u0005\u001d32\u0003\u0002\f\u0002\u0004B\u0002b!!\"\u0002\fV2UBAAD\u0015\r\tI)K\u0001\beVtG/[7f\u0013\u0011\ti)a\"\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007\u0006\u0002\u0002\u0000\u0005)\u0011\r\u001d9msR\u0019a)!&\t\u000bMJ\u0002\u0019A\u001b\u0002\u000fUt\u0017\r\u001d9msR!\u00111TAQ!\u0011A\u0013QT\u001b\n\u0007\u0005}\u0015F\u0001\u0004PaRLwN\u001c\u0005\t\u0003GS\u0012\u0011!a\u0001\r\u0006\u0019\u0001\u0010\n\u0019\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003S\u00032aWAV\u0013\r\ti\u000b\u0018\u0002\u0007\u001f\nTWm\u0019;")
public class ArgWriter
implements Product,
Serializable {
    private final DataType cellType;

    public static Option<DataType> unapply(ArgWriter argWriter) {
        return ArgWriter$.MODULE$.unapply(argWriter);
    }

    public static ArgWriter apply(DataType dataType) {
        return ArgWriter$.MODULE$.apply(dataType);
    }

    public static <A> Function1<DataType, A> andThen(Function1<ArgWriter, A> function1) {
        return ArgWriter$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, ArgWriter> compose(Function1<A, DataType> function1) {
        return ArgWriter$.MODULE$.compose(function1);
    }

    public DataType cellType() {
        return this.cellType;
    }

    public int width() {
        return this.cellType().bits() / 8;
    }

    public String cellTypeName() {
        return this.cellType().name();
    }

    public String dataType() {
        return "arg";
    }

    public void writeMetadataJSON(String path, String name, RasterExtent re) {
        String metadata = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(339).append("{\n        |  \"layer\": \"").append(name).append("\",\n        |  \"datatype\": \"").append(this.cellTypeName()).append("\",\n        |  \"type\": \"").append(this.dataType()).append("\",\n        |  \"xmin\": ").append(re.extent().xmin()).append(",\n        |  \"xmax\": ").append(re.extent().xmax()).append(",\n        |  \"ymin\": ").append(re.extent().ymin()).append(",\n        |  \"ymax\": ").append(re.extent().ymax()).append(",\n        |  \"cols\": ").append(re.cols()).append(",\n        |  \"rows\": ").append(re.rows()).append(",\n        |  \"cellwidth\": ").append(re.cellwidth()).append(",\n        |  \"cellheight\": ").append(re.cellheight()).append(",\n        |  \"epsg\": 3785,\n        |  \"yskew\": 0.0,\n        |  \"xskew\": 0.0\n        |}").toString())).stripMargin();
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path));
        bos.write(metadata.getBytes());
        bos.close();
    }

    public void write(String outputFilePath, Tile tile, Extent extent, String metadataName) {
        String path = outputFilePath;
        String base = path.endsWith(".arg") || path.endsWith(".json") || path.endsWith(".") ? path.substring(0, path.lastIndexOf(".")) : path;
        Tile tile2 = tile;
        if (tile2 instanceof ConstantTile) {
            ConstantTile constantTile = (ConstantTile)tile2;
            this.writeConstantTile(new StringBuilder(5).append(base).append(".json").toString(), constantTile, metadataName, RasterExtent$.MODULE$.apply(extent, tile.cols$mcI$sp(), tile.rows$mcI$sp()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.writeMetadataJSON(new StringBuilder(5).append(base).append(".json").toString(), metadataName, RasterExtent$.MODULE$.apply(extent, tile.cols$mcI$sp(), tile.rows$mcI$sp()));
            this.writeData(new StringBuilder(4).append(base).append(".arg").toString(), tile);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void writeData(String path, Tile tile) {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
        CellWriter$.MODULE$.byType(this.cellType()).writeCells(tile, dos);
        dos.close();
    }

    public void writeConstantTile(String path, ConstantTile ct, String name, RasterExtent re) {
        String metadata = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(391).append("{\n        |  \"layer\": \"").append(name).append("\",\n        |  \"datatype\": \"").append(this.cellTypeName()).append("\",\n        |  \"type\": \"constant\",\n        |  \"xmin\": ").append(re.extent().xmin()).append(",\n        |  \"xmax\": ").append(re.extent().xmax()).append(",\n        |  \"ymin\": ").append(re.extent().ymin()).append(",\n        |  \"ymax\": ").append(re.extent().ymax()).append(",\n        |  \"cols\": ").append(re.cols()).append(",\n        |  \"rows\": ").append(re.rows()).append(",\n        |  \"cellwidth\": ").append(re.cellwidth()).append(",\n        |  \"cellheight\": ").append(re.cellheight()).append(",\n        |  \"epsg\": 3785,\n        |  \"yskew\": 0.0,\n        |  \"xskew\": 0.0,\n        |  \"constant\": {ct.getDouble(0,0)}\n        |}").toString())).stripMargin();
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path));
        bos.write(metadata.getBytes());
        bos.close();
    }

    public ArgWriter copy(DataType cellType) {
        return new ArgWriter(cellType);
    }

    public DataType copy$default$1() {
        return this.cellType();
    }

    public String productPrefix() {
        return "ArgWriter";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return this.cellType();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArgWriter;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArgWriter)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArgWriter argWriter = (ArgWriter)x$1;
        DataType dataType = this.cellType();
        DataType dataType2 = argWriter.cellType();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        if (!argWriter.canEqual(this)) return false;
        return true;
    }

    public ArgWriter(DataType cellType) {
        this.cellType = cellType;
        Product.$init$((Product)this);
    }
}

