/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.mapalgebra.local;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.Dimensions;
import geotrellis.raster.GridIntegral;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;

public final class Mean$
implements Serializable {
    public static Mean$ MODULE$;

    static {
        new Mean$();
    }

    public Tile apply(Traversable<Tile> rs) {
        return this.apply((Seq<Tile>)rs.toSeq());
    }

    public Tile apply(Seq<Tile> rs, Predef.DummyImplicit d) {
        return this.apply(rs);
    }

    public Tile apply(Seq<Tile> rs) {
        package$.MODULE$.TraversableTileExtensions((Traversable<Tile>)rs).assertEqualDimensions();
        int layerCount = rs.length();
        if (layerCount == 0) {
            throw scala.sys.package$.MODULE$.error("Can't compute mean of empty sequence");
        }
        DataType newCellType = (DataType)((TraversableOnce)rs.map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.cellType(), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & java.io.Serializable & Serializable)(x$2, x$3) -> x$2.union((DataType)x$3));
        Dimensions dimensions = ((GridIntegral)rs.apply(0)).dimensions();
        if (dimensions == null) {
            throw new MatchError(dimensions);
        }
        int cols = dimensions.cols$mcI$sp();
        int rows = dimensions.rows$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(cols, rows);
        Tuple2.mcII.sp sp3 = sp2;
        int cols2 = sp3._1$mcI$sp();
        int rows2 = sp3._2$mcI$sp();
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(newCellType, cols2, rows2);
        if (newCellType.isFloatingPoint()) {
            for (int index$macro$3 = 0; index$macro$3 < rows2; ++index$macro$3) {
                for (int index$macro$2 = 0; index$macro$2 < cols2; ++index$macro$2) {
                    int count = 0;
                    double sum = 0.0;
                    for (int index$macro$1 = 0; index$macro$1 < layerCount; ++index$macro$1) {
                        double v = ((Tile)rs.apply(index$macro$1)).getDouble(index$macro$2, index$macro$3);
                        if (Double.isNaN(v)) continue;
                        ++count;
                        sum += v;
                    }
                    if (count > 0) {
                        tile.setDouble(index$macro$2, index$macro$3, sum / (double)count);
                        continue;
                    }
                    tile.setDouble(index$macro$2, index$macro$3, Double.NaN);
                }
            }
        } else {
            for (int index$macro$6 = 0; index$macro$6 < rows2; ++index$macro$6) {
                for (int index$macro$5 = 0; index$macro$5 < cols2; ++index$macro$5) {
                    int count = 0;
                    int sum = 0;
                    for (int index$macro$4 = 0; index$macro$4 < layerCount; ++index$macro$4) {
                        int v = ((Tile)rs.apply(index$macro$4)).get(index$macro$5, index$macro$6);
                        if (v == Integer.MIN_VALUE) continue;
                        ++count;
                        sum += v;
                    }
                    if (count > 0) {
                        tile.set(index$macro$5, index$macro$6, sum / count);
                        continue;
                    }
                    tile.set(index$macro$5, index$macro$6, Integer.MIN_VALUE);
                }
            }
        }
        return tile;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Mean$() {
        MODULE$ = this;
    }
}

