/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector;

public class ShewchuksDeterminant {
    private static final double epsilon;
    private static final double splitter;
    private static final double resulterrbound;
    private static final double ccwerrboundA;
    private static final double ccwerrboundB;
    private static final double ccwerrboundC;
    private static final double o3derrboundA;
    private static final double o3derrboundB;
    private static final double o3derrboundC;
    private static final double iccerrboundA;
    private static final double iccerrboundB;
    private static final double iccerrboundC;
    private static final double isperrboundA;
    private static final double isperrboundB;
    private static final double isperrboundC;

    public static int orientationIndexFilter(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8 = (d - d5) * (d4 - d6);
        double d9 = (d2 - d6) * (d3 - d5);
        double d10 = d8 - d9;
        if (d8 > 0.0) {
            if (d9 <= 0.0) {
                return ShewchuksDeterminant.signum(d10);
            }
            d7 = d8 + d9;
        } else if (d8 < 0.0) {
            if (d9 >= 0.0) {
                return ShewchuksDeterminant.signum(d10);
            }
            d7 = -d8 - d9;
        } else {
            return ShewchuksDeterminant.signum(d10);
        }
        double d11 = 1.0E-15;
        double d12 = d11 * d7;
        if (d10 >= d12 || -d10 >= d12) {
            return ShewchuksDeterminant.signum(d10);
        }
        return 2;
    }

    private static int signum(double d) {
        if (d > 0.0) {
            return 1;
        }
        if (d < 0.0) {
            return -1;
        }
        return 0;
    }

    public static int orientationIndex(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = ShewchuksDeterminant.orient2d(d, d2, d3, d4, d5, d6);
        if (d7 > 0.0) {
            return 1;
        }
        if (d7 < 0.0) {
            return -1;
        }
        return 0;
    }

    public static double orient2d(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8 = (d - d5) * (d4 - d6);
        double d9 = (d2 - d6) * (d3 - d5);
        double d10 = d8 - d9;
        if (d8 > 0.0) {
            if (d9 <= 0.0) {
                return d10;
            }
            d7 = d8 + d9;
        } else if (d8 < 0.0) {
            if (d9 >= 0.0) {
                return d10;
            }
            d7 = -d8 - d9;
        } else {
            return d10;
        }
        double d11 = ccwerrboundA * d7;
        if (d10 >= d11 || -d10 >= d11) {
            return d10;
        }
        return ShewchuksDeterminant.orient2dadapt(d, d2, d3, d4, d5, d6, d7);
    }

    private static double orient2dadapt(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8 = d - d5;
        double d9 = d3 - d5;
        double d10 = d2 - d6;
        double d11 = d4 - d6;
        double d12 = ShewchuksDeterminant.Two_Product_Head(d8, d11);
        double d13 = ShewchuksDeterminant.Two_Product_Tail(d8, d11, d12);
        double d14 = ShewchuksDeterminant.Two_Product_Head(d10, d9);
        double d15 = ShewchuksDeterminant.Two_Product_Tail(d10, d9, d14);
        double[] dArray = new double[4];
        dArray[2] = ShewchuksDeterminant.Two_Two_Diff__x2(d12, d13, d14, d15);
        dArray[1] = ShewchuksDeterminant.Two_Two_Diff__x1(d12, d13, d14, d15);
        dArray[0] = ShewchuksDeterminant.Two_Two_Diff__x0(d12, d13, d14, d15);
        dArray[3] = ShewchuksDeterminant.Two_Two_Diff__x3(d12, d13, d14, d15);
        double d16 = dArray[0] + dArray[1] + dArray[2] + dArray[3];
        double d17 = ccwerrboundB * d7;
        if (d16 >= d17 || -d16 >= d17) {
            return d16;
        }
        double d18 = ShewchuksDeterminant.Two_Diff_Tail(d, d5, d8);
        double d19 = ShewchuksDeterminant.Two_Diff_Tail(d3, d5, d9);
        double d20 = ShewchuksDeterminant.Two_Diff_Tail(d2, d6, d10);
        double d21 = ShewchuksDeterminant.Two_Diff_Tail(d4, d6, d11);
        if (d18 == 0.0 && d20 == 0.0 && d19 == 0.0 && d21 == 0.0) {
            return d16;
        }
        if ((d16 += d8 * d21 + d11 * d18 - (d10 * d19 + d9 * d20)) >= (d17 = ccwerrboundC * d7 + resulterrbound * ShewchuksDeterminant.Absolute(d16)) || -d16 >= d17) {
            return d16;
        }
        double d22 = ShewchuksDeterminant.Two_Product_Head(d18, d11);
        double d23 = ShewchuksDeterminant.Two_Product_Tail(d18, d11, d22);
        double d24 = ShewchuksDeterminant.Two_Product_Head(d20, d9);
        double d25 = ShewchuksDeterminant.Two_Product_Tail(d20, d9, d24);
        double d26 = ShewchuksDeterminant.Two_Two_Diff__x3(d22, d23, d24, d25);
        double[] dArray2 = new double[4];
        dArray2[2] = ShewchuksDeterminant.Two_Two_Diff__x2(d22, d23, d24, d25);
        dArray2[1] = ShewchuksDeterminant.Two_Two_Diff__x1(d22, d23, d24, d25);
        dArray2[0] = ShewchuksDeterminant.Two_Two_Diff__x0(d22, d23, d24, d25);
        dArray2[3] = d26;
        double[] dArray3 = new double[8];
        int n = ShewchuksDeterminant.fast_expansion_sum_zeroelim(4, dArray, 4, dArray2, dArray3);
        d22 = ShewchuksDeterminant.Two_Product_Head(d8, d21);
        d23 = ShewchuksDeterminant.Two_Product_Tail(d8, d21, d22);
        d24 = ShewchuksDeterminant.Two_Product_Head(d10, d19);
        d25 = ShewchuksDeterminant.Two_Product_Tail(d10, d19, d24);
        d26 = ShewchuksDeterminant.Two_Two_Diff__x3(d22, d23, d24, d25);
        dArray2[2] = ShewchuksDeterminant.Two_Two_Diff__x2(d22, d23, d24, d25);
        dArray2[1] = ShewchuksDeterminant.Two_Two_Diff__x1(d22, d23, d24, d25);
        dArray2[0] = ShewchuksDeterminant.Two_Two_Diff__x0(d22, d23, d24, d25);
        dArray2[3] = d26;
        double[] dArray4 = new double[12];
        int n2 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n, dArray3, 4, dArray2, dArray4);
        d22 = ShewchuksDeterminant.Two_Product_Head(d18, d21);
        d23 = ShewchuksDeterminant.Two_Product_Tail(d18, d21, d22);
        d24 = ShewchuksDeterminant.Two_Product_Head(d20, d19);
        d25 = ShewchuksDeterminant.Two_Product_Tail(d20, d19, d24);
        d26 = ShewchuksDeterminant.Two_Two_Diff__x3(d22, d23, d24, d25);
        dArray2[2] = ShewchuksDeterminant.Two_Two_Diff__x2(d22, d23, d24, d25);
        dArray2[1] = ShewchuksDeterminant.Two_Two_Diff__x1(d22, d23, d24, d25);
        dArray2[0] = ShewchuksDeterminant.Two_Two_Diff__x0(d22, d23, d24, d25);
        dArray2[3] = d26;
        double[] dArray5 = new double[16];
        int n3 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n2, dArray4, 4, dArray2, dArray5);
        return dArray5[n3 - 1];
    }

    private static double Absolute(double d) {
        return d >= 0.0 ? d : -d;
    }

    private static double Fast_Two_Sum_Tail(double d, double d2, double d3) {
        double d4 = d3 - d;
        double d5 = d2 - d4;
        return d5;
    }

    private static double Fast_Two_Sum_Head(double d, double d2) {
        double d3 = d + d2;
        return d3;
    }

    private static double Two_Sum_Tail(double d, double d2, double d3) {
        double d4 = d3 - d;
        double d5 = d3 - d4;
        double d6 = d2 - d4;
        double d7 = d - d5;
        double d8 = d7 + d6;
        return d8;
    }

    private static double Two_Sum_Head(double d, double d2) {
        double d3 = d + d2;
        return d3;
    }

    private static double Two_Diff_Tail(double d, double d2, double d3) {
        double d4 = d - d3;
        double d5 = d3 + d4;
        double d6 = d4 - d2;
        double d7 = d - d5;
        double d8 = d7 + d6;
        return d8;
    }

    private static double Two_Diff_Head(double d, double d2) {
        double d3 = d - d2;
        return d3;
    }

    private static double SplitLo(double d) {
        double d2 = splitter * d;
        double d3 = d2 - d;
        double d4 = d2 - d3;
        double d5 = d - d4;
        return d5;
    }

    private static double SplitHi(double d) {
        double d2 = splitter * d;
        double d3 = d2 - d;
        double d4 = d2 - d3;
        return d4;
    }

    private static double Two_Product_Tail(double d, double d2, double d3) {
        double d4 = ShewchuksDeterminant.SplitHi(d);
        double d5 = ShewchuksDeterminant.SplitLo(d);
        double d6 = ShewchuksDeterminant.SplitHi(d2);
        double d7 = ShewchuksDeterminant.SplitLo(d2);
        double d8 = d3 - d4 * d6;
        double d9 = d8 - d5 * d6;
        double d10 = d9 - d4 * d7;
        double d11 = d5 * d7 - d10;
        return d11;
    }

    private static double Two_Product_Tail_Presplit(double d, double d2, double d3, double d4, double d5) {
        double d6 = ShewchuksDeterminant.SplitHi(d);
        double d7 = ShewchuksDeterminant.SplitLo(d);
        double d8 = d5 - d6 * d3;
        double d9 = d8 - d7 * d3;
        double d10 = d9 - d6 * d4;
        double d11 = d7 * d4 - d10;
        return d11;
    }

    private static double Two_Product_Head(double d, double d2) {
        double d3 = d * d2;
        return d3;
    }

    private static double Two_One_Diff__x0(double d, double d2, double d3) {
        double d4 = ShewchuksDeterminant.Two_Diff_Head(d2, d3);
        double d5 = ShewchuksDeterminant.Two_Diff_Tail(d2, d3, d4);
        return d5;
    }

    private static double Two_One_Diff__x1(double d, double d2, double d3) {
        double d4 = ShewchuksDeterminant.Two_Diff_Head(d2, d3);
        double d5 = ShewchuksDeterminant.Two_Sum_Head(d, d4);
        double d6 = ShewchuksDeterminant.Two_Sum_Tail(d, d4, d5);
        return d6;
    }

    private static double Two_One_Diff__x2(double d, double d2, double d3) {
        double d4 = ShewchuksDeterminant.Two_Diff_Head(d2, d3);
        double d5 = ShewchuksDeterminant.Two_Sum_Head(d, d4);
        return d5;
    }

    private static double Two_Two_Diff__x0(double d, double d2, double d3, double d4) {
        double d5 = ShewchuksDeterminant.Two_One_Diff__x0(d, d2, d4);
        return d5;
    }

    private static double Two_Two_Diff__x1(double d, double d2, double d3, double d4) {
        double d5 = ShewchuksDeterminant.Two_One_Diff__x2(d, d2, d4);
        double d6 = ShewchuksDeterminant.Two_One_Diff__x1(d, d2, d4);
        double d7 = ShewchuksDeterminant.Two_One_Diff__x0(d5, d6, d3);
        return d7;
    }

    private static double Two_Two_Diff__x2(double d, double d2, double d3, double d4) {
        double d5 = ShewchuksDeterminant.Two_One_Diff__x2(d, d2, d4);
        double d6 = ShewchuksDeterminant.Two_One_Diff__x1(d, d2, d4);
        double d7 = ShewchuksDeterminant.Two_One_Diff__x1(d5, d6, d3);
        return d7;
    }

    private static double Two_Two_Diff__x3(double d, double d2, double d3, double d4) {
        double d5 = ShewchuksDeterminant.Two_One_Diff__x2(d, d2, d4);
        double d6 = ShewchuksDeterminant.Two_One_Diff__x1(d, d2, d4);
        double d7 = ShewchuksDeterminant.Two_One_Diff__x2(d5, d6, d3);
        return d7;
    }

    private static double Two_One_Sum__x0(double d, double d2, double d3) {
        double d4 = ShewchuksDeterminant.Two_Sum_Head(d2, d3);
        double d5 = ShewchuksDeterminant.Two_Sum_Tail(d2, d3, d4);
        return d5;
    }

    private static double Two_One_Sum__x1(double d, double d2, double d3) {
        double d4 = ShewchuksDeterminant.Two_Sum_Head(d2, d3);
        double d5 = ShewchuksDeterminant.Two_Sum_Head(d, d4);
        double d6 = ShewchuksDeterminant.Two_Sum_Tail(d, d4, d5);
        return d6;
    }

    private static double Two_One_Sum__x2(double d, double d2, double d3) {
        double d4 = ShewchuksDeterminant.Two_Sum_Head(d2, d3);
        double d5 = ShewchuksDeterminant.Two_Sum_Head(d, d4);
        return d5;
    }

    private static double Two_Two_Sum__x0(double d, double d2, double d3, double d4) {
        double d5 = ShewchuksDeterminant.Two_One_Sum__x0(d, d2, d4);
        return d5;
    }

    private static double Two_Two_Sum__x1(double d, double d2, double d3, double d4) {
        double d5 = ShewchuksDeterminant.Two_One_Sum__x2(d, d2, d4);
        double d6 = ShewchuksDeterminant.Two_One_Sum__x1(d, d2, d4);
        double d7 = ShewchuksDeterminant.Two_One_Sum__x0(d5, d6, d3);
        return d7;
    }

    private static double Two_Two_Sum__x2(double d, double d2, double d3, double d4) {
        double d5 = ShewchuksDeterminant.Two_One_Sum__x2(d, d2, d4);
        double d6 = ShewchuksDeterminant.Two_One_Sum__x1(d, d2, d4);
        double d7 = ShewchuksDeterminant.Two_One_Sum__x1(d5, d6, d3);
        return d7;
    }

    private static double Two_Two_Sum__x3(double d, double d2, double d3, double d4) {
        double d5 = ShewchuksDeterminant.Two_One_Sum__x2(d, d2, d4);
        double d6 = ShewchuksDeterminant.Two_One_Sum__x1(d, d2, d4);
        double d7 = ShewchuksDeterminant.Two_One_Sum__x2(d5, d6, d3);
        return d7;
    }

    private static double Square_Tail(double d, double d2) {
        double d3 = ShewchuksDeterminant.SplitHi(d);
        double d4 = ShewchuksDeterminant.SplitLo(d);
        double d5 = d2 - d3 * d3;
        return d4 * d4 - (d5 -= (d3 + d3) * d4);
    }

    private static double Square_Head(double d) {
        return d * d;
    }

    private static int fast_expansion_sum_zeroelim(int n, double[] dArray, int n2, double[] dArray2, double[] dArray3) {
        double d;
        double d2;
        double d3;
        double d4 = dArray[0];
        double d5 = dArray2[0];
        int n3 = 0;
        int n4 = 0;
        if (d5 > d4 == d5 > -d4) {
            d3 = d4;
            d4 = dArray[n4++];
        } else {
            d3 = d5;
            d5 = dArray2[n3++];
        }
        int n5 = 0;
        if (n4 < n && n3 < n2) {
            if (d5 > d4 == d5 > -d4) {
                d2 = ShewchuksDeterminant.Fast_Two_Sum_Head(d4, d3);
                d = ShewchuksDeterminant.Fast_Two_Sum_Tail(d4, d3, d2);
                d4 = dArray[n4++];
            } else {
                d2 = ShewchuksDeterminant.Fast_Two_Sum_Head(d5, d3);
                d = ShewchuksDeterminant.Fast_Two_Sum_Tail(d5, d3, d2);
                d5 = dArray2[n3++];
            }
            d3 = d2;
            if (d != 0.0) {
                dArray3[n5++] = d;
            }
            while (n4 < n && n3 < n2) {
                if (d5 > d4 == d5 > -d4) {
                    d2 = ShewchuksDeterminant.Two_Sum_Head(d3, d4);
                    d = ShewchuksDeterminant.Two_Sum_Tail(d3, d4, d2);
                    d4 = dArray[n4++];
                } else {
                    d2 = ShewchuksDeterminant.Two_Sum_Head(d3, d5);
                    d = ShewchuksDeterminant.Two_Sum_Tail(d3, d5, d2);
                    d5 = dArray2[n3++];
                }
                d3 = d2;
                if (d == 0.0) continue;
                dArray3[n5++] = d;
            }
        }
        while (n4 < n) {
            d2 = ShewchuksDeterminant.Two_Sum_Head(d3, d4);
            d = ShewchuksDeterminant.Two_Sum_Tail(d3, d4, d2);
            d4 = dArray[n4++];
            d3 = d2;
            if (d == 0.0) continue;
            dArray3[n5++] = d;
        }
        while (n3 < n2) {
            d2 = ShewchuksDeterminant.Two_Sum_Head(d3, d5);
            d = ShewchuksDeterminant.Two_Sum_Tail(d3, d5, d2);
            d5 = dArray2[n3++];
            d3 = d2;
            if (d == 0.0) continue;
            dArray3[n5++] = d;
        }
        if (d3 != 0.0 || n5 == 0) {
            dArray3[n5++] = d3;
        }
        return n5;
    }

    private static double estimate(int n, double[] dArray) {
        double d = dArray[0];
        for (int i = 1; i < n; ++i) {
            d += dArray[i];
        }
        return d;
    }

    private static int scale_expansion_zeroelim(int n, double[] dArray, double d, double[] dArray2) {
        double d2 = ShewchuksDeterminant.SplitHi(d);
        double d3 = ShewchuksDeterminant.SplitLo(d);
        double d4 = ShewchuksDeterminant.Two_Product_Head(dArray[0], d);
        double d5 = ShewchuksDeterminant.Two_Product_Tail_Presplit(dArray[0], d, d2, d3, d4);
        int n2 = 0;
        if (d5 != 0.0) {
            dArray2[n2++] = d5;
        }
        for (int i = 1; i < n; ++i) {
            double d6;
            double d7 = dArray[i];
            double d8 = ShewchuksDeterminant.Two_Product_Head(d7, d);
            double d9 = ShewchuksDeterminant.Two_Product_Tail_Presplit(d7, d, d2, d3, d8);
            d5 = ShewchuksDeterminant.Two_Sum_Tail(d4, d9, d6 = ShewchuksDeterminant.Two_Sum_Head(d4, d9));
            if (d5 != 0.0) {
                dArray2[n2++] = d5;
            }
            if ((d5 = ShewchuksDeterminant.Fast_Two_Sum_Tail(d8, d6, d4 = ShewchuksDeterminant.Fast_Two_Sum_Head(d8, d6))) == 0.0) continue;
            dArray2[n2++] = d5;
        }
        if (d4 != 0.0 || n2 == 0) {
            dArray2[n2++] = d4;
        }
        return n2;
    }

    public static double incircle(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = d - d7;
        double d10 = d2 - d8;
        double d11 = d9 * d9 + d10 * d10;
        double d12 = d3 - d7;
        double d13 = d6 - d8;
        double d14 = d12 * d13;
        double d15 = d5 - d7;
        double d16 = d4 - d8;
        double d17 = d15 * d16;
        double d18 = d12 * d12 + d16 * d16;
        double d19 = d15 * d10;
        double d20 = d9 * d13;
        double d21 = d15 * d15 + d13 * d13;
        double d22 = d9 * d16;
        double d23 = d12 * d10;
        double d24 = d11 * (d14 - d17) + d18 * (d19 - d20) + d21 * (d22 - d23);
        double d25 = (ShewchuksDeterminant.Absolute(d14) + ShewchuksDeterminant.Absolute(d17)) * d11 + (ShewchuksDeterminant.Absolute(d19) + ShewchuksDeterminant.Absolute(d20)) * d18 + (ShewchuksDeterminant.Absolute(d22) + ShewchuksDeterminant.Absolute(d23)) * d21;
        double d26 = iccerrboundA * d25;
        if (d24 > d26 || -d24 > d26) {
            return d24;
        }
        return ShewchuksDeterminant.incircleadapt(d, d2, d3, d4, d5, d6, d7, d8, d25);
    }

    public static double incircleadapt(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        int n;
        int n2;
        int n3;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double[] dArray;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        double d17;
        double[] dArray2 = new double[4];
        double[] dArray3 = new double[4];
        double[] dArray4 = new double[4];
        double[] dArray5 = new double[8];
        double[] dArray6 = new double[16];
        double[] dArray7 = new double[8];
        double[] dArray8 = new double[16];
        double[] dArray9 = new double[32];
        double[] dArray10 = new double[8];
        double[] dArray11 = new double[16];
        double[] dArray12 = new double[8];
        double[] dArray13 = new double[16];
        double[] dArray14 = new double[32];
        double[] dArray15 = new double[8];
        double[] dArray16 = new double[16];
        double[] dArray17 = new double[8];
        double[] dArray18 = new double[16];
        double[] dArray19 = new double[32];
        double[] dArray20 = new double[64];
        double[] dArray21 = new double[1152];
        double[] dArray22 = new double[1152];
        double[] dArray23 = new double[4];
        double[] dArray24 = new double[4];
        double[] dArray25 = new double[4];
        double[] dArray26 = new double[4];
        double[] dArray27 = new double[4];
        double[] dArray28 = new double[8];
        double[] dArray29 = new double[16];
        double[] dArray30 = new double[16];
        double[] dArray31 = new double[16];
        double[] dArray32 = new double[32];
        double[] dArray33 = new double[32];
        double[] dArray34 = new double[48];
        double[] dArray35 = new double[64];
        double[] dArray36 = new double[8];
        double[] dArray37 = new double[8];
        double[] dArray38 = new double[8];
        double[] dArray39 = new double[8];
        double[] dArray40 = new double[8];
        double[] dArray41 = new double[8];
        double[] dArray42 = new double[8];
        double[] dArray43 = new double[8];
        double[] dArray44 = new double[8];
        double[] dArray45 = new double[8];
        double[] dArray46 = new double[8];
        double[] dArray47 = new double[8];
        double[] dArray48 = new double[8];
        double[] dArray49 = new double[8];
        double[] dArray50 = new double[8];
        double[] dArray51 = new double[8];
        double[] dArray52 = new double[8];
        double[] dArray53 = new double[8];
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        double[] dArray54 = new double[16];
        double[] dArray55 = new double[16];
        double[] dArray56 = new double[16];
        double[] dArray57 = new double[16];
        double[] dArray58 = new double[16];
        double[] dArray59 = new double[16];
        double[] dArray60 = new double[8];
        double[] dArray61 = new double[8];
        double[] dArray62 = new double[8];
        double[] dArray63 = new double[8];
        double[] dArray64 = new double[8];
        double[] dArray65 = new double[8];
        double[] dArray66 = new double[8];
        double[] dArray67 = new double[8];
        double[] dArray68 = new double[8];
        double[] dArray69 = new double[4];
        double[] dArray70 = new double[4];
        double[] dArray71 = new double[4];
        double d18 = d - d7;
        double d19 = d3 - d7;
        double d20 = d5 - d7;
        double d21 = d2 - d8;
        double d22 = d4 - d8;
        double d23 = d6 - d8;
        double d24 = ShewchuksDeterminant.Two_Product_Head(d19, d23);
        double d25 = ShewchuksDeterminant.Two_Product_Tail(d19, d23, d24);
        double d26 = ShewchuksDeterminant.Two_Product_Head(d20, d22);
        double d27 = ShewchuksDeterminant.Two_Product_Tail(d20, d22, d26);
        double d28 = ShewchuksDeterminant.Two_Two_Diff__x3(d24, d25, d26, d27);
        dArray2[2] = ShewchuksDeterminant.Two_Two_Diff__x2(d24, d25, d26, d27);
        dArray2[1] = ShewchuksDeterminant.Two_Two_Diff__x1(d24, d25, d26, d27);
        dArray2[0] = ShewchuksDeterminant.Two_Two_Diff__x0(d24, d25, d26, d27);
        dArray2[3] = d28;
        int n15 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray2, d18, dArray5);
        int n16 = ShewchuksDeterminant.scale_expansion_zeroelim(n15, dArray5, d18, dArray6);
        int n17 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray2, d21, dArray7);
        int n18 = ShewchuksDeterminant.scale_expansion_zeroelim(n17, dArray7, d21, dArray8);
        int n19 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n16, dArray6, n18, dArray8, dArray9);
        double d29 = ShewchuksDeterminant.Two_Product_Head(d20, d21);
        double d30 = ShewchuksDeterminant.Two_Product_Tail(d20, d21, d29);
        double d31 = ShewchuksDeterminant.Two_Product_Head(d18, d23);
        double d32 = ShewchuksDeterminant.Two_Product_Tail(d18, d23, d31);
        double d33 = ShewchuksDeterminant.Two_Two_Diff__x3(d29, d30, d31, d32);
        dArray3[2] = ShewchuksDeterminant.Two_Two_Diff__x2(d29, d30, d31, d32);
        dArray3[1] = ShewchuksDeterminant.Two_Two_Diff__x1(d29, d30, d31, d32);
        dArray3[0] = ShewchuksDeterminant.Two_Two_Diff__x0(d29, d30, d31, d32);
        dArray3[3] = d33;
        int n20 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray3, d19, dArray10);
        int n21 = ShewchuksDeterminant.scale_expansion_zeroelim(n20, dArray10, d19, dArray11);
        int n22 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray3, d22, dArray12);
        int n23 = ShewchuksDeterminant.scale_expansion_zeroelim(n22, dArray12, d22, dArray13);
        int n24 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n21, dArray11, n23, dArray13, dArray14);
        double d34 = ShewchuksDeterminant.Two_Product_Head(d18, d22);
        double d35 = ShewchuksDeterminant.Two_Product_Tail(d18, d22, d34);
        double d36 = ShewchuksDeterminant.Two_Product_Head(d19, d21);
        double d37 = ShewchuksDeterminant.Two_Product_Tail(d19, d21, d36);
        double d38 = ShewchuksDeterminant.Two_Two_Diff__x3(d34, d35, d36, d37);
        dArray4[2] = ShewchuksDeterminant.Two_Two_Diff__x2(d34, d35, d36, d37);
        dArray4[1] = ShewchuksDeterminant.Two_Two_Diff__x1(d34, d35, d36, d37);
        dArray4[0] = ShewchuksDeterminant.Two_Two_Diff__x0(d34, d35, d36, d37);
        dArray4[3] = d38;
        int n25 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray4, d20, dArray15);
        int n26 = ShewchuksDeterminant.scale_expansion_zeroelim(n25, dArray15, d20, dArray16);
        int n27 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray4, d23, dArray17);
        int n28 = ShewchuksDeterminant.scale_expansion_zeroelim(n27, dArray17, d23, dArray18);
        int n29 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n26, dArray16, n28, dArray18, dArray19);
        int n30 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n19, dArray9, n24, dArray14, dArray20);
        int n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n30, dArray20, n29, dArray19, dArray21);
        double d39 = ShewchuksDeterminant.estimate(n31, dArray21);
        if (d39 >= (d17 = iccerrboundB * d9) || -d39 >= d17) {
            return d39;
        }
        double d40 = ShewchuksDeterminant.Two_Diff_Tail(d, d7, d18);
        double d41 = ShewchuksDeterminant.Two_Diff_Tail(d2, d8, d21);
        double d42 = ShewchuksDeterminant.Two_Diff_Tail(d3, d7, d19);
        double d43 = ShewchuksDeterminant.Two_Diff_Tail(d4, d8, d22);
        double d44 = ShewchuksDeterminant.Two_Diff_Tail(d5, d7, d20);
        double d45 = ShewchuksDeterminant.Two_Diff_Tail(d6, d8, d23);
        if (d40 == 0.0 && d42 == 0.0 && d44 == 0.0 && d41 == 0.0 && d43 == 0.0 && d45 == 0.0) {
            return d39;
        }
        if ((d39 += (d18 * d18 + d21 * d21) * (d19 * d45 + d23 * d42 - (d22 * d44 + d20 * d43)) + 2.0 * (d18 * d40 + d21 * d41) * (d19 * d23 - d22 * d20) + ((d19 * d19 + d22 * d22) * (d20 * d41 + d21 * d44 - (d23 * d40 + d18 * d45)) + 2.0 * (d19 * d42 + d22 * d43) * (d20 * d21 - d23 * d18)) + ((d20 * d20 + d23 * d23) * (d18 * d43 + d22 * d40 - (d21 * d42 + d19 * d41)) + 2.0 * (d20 * d44 + d23 * d45) * (d18 * d22 - d21 * d19))) >= (d17 = iccerrboundC * d9 + resulterrbound * ShewchuksDeterminant.Absolute(d39)) || -d39 >= d17) {
            return d39;
        }
        double[] dArray72 = dArray21;
        double[] dArray73 = dArray22;
        if (d42 != 0.0 || d43 != 0.0 || d44 != 0.0 || d45 != 0.0) {
            double d46 = ShewchuksDeterminant.Square_Head(d18);
            double d47 = ShewchuksDeterminant.Square_Tail(d18, d46);
            double d48 = ShewchuksDeterminant.Square_Head(d21);
            double d49 = ShewchuksDeterminant.Square_Tail(d21, d48);
            double d50 = ShewchuksDeterminant.Two_Two_Sum__x3(d46, d47, d48, d49);
            dArray23[2] = ShewchuksDeterminant.Two_Two_Sum__x2(d46, d47, d48, d49);
            dArray23[1] = ShewchuksDeterminant.Two_Two_Sum__x1(d46, d47, d48, d49);
            dArray23[0] = ShewchuksDeterminant.Two_Two_Sum__x0(d46, d47, d48, d49);
            dArray23[3] = d50;
        }
        if (d44 != 0.0 || d45 != 0.0 || d40 != 0.0 || d41 != 0.0) {
            double d51 = ShewchuksDeterminant.Square_Head(d19);
            double d52 = ShewchuksDeterminant.Square_Tail(d19, d51);
            double d53 = ShewchuksDeterminant.Square_Head(d22);
            double d54 = ShewchuksDeterminant.Square_Tail(d22, d53);
            double d55 = ShewchuksDeterminant.Two_Two_Sum__x3(d51, d52, d53, d54);
            dArray24[2] = ShewchuksDeterminant.Two_Two_Sum__x2(d51, d52, d53, d54);
            dArray24[1] = ShewchuksDeterminant.Two_Two_Sum__x1(d51, d52, d53, d54);
            dArray24[0] = ShewchuksDeterminant.Two_Two_Sum__x0(d51, d52, d53, d54);
            dArray24[3] = d55;
        }
        if (d40 != 0.0 || d41 != 0.0 || d42 != 0.0 || d43 != 0.0) {
            double d56 = ShewchuksDeterminant.Square_Head(d20);
            double d57 = ShewchuksDeterminant.Square_Tail(d20, d56);
            double d58 = ShewchuksDeterminant.Square_Head(d23);
            double d59 = ShewchuksDeterminant.Square_Tail(d23, d58);
            double d60 = ShewchuksDeterminant.Two_Two_Sum__x3(d56, d57, d58, d59);
            dArray25[2] = ShewchuksDeterminant.Two_Two_Sum__x2(d56, d57, d58, d59);
            dArray25[1] = ShewchuksDeterminant.Two_Two_Sum__x1(d56, d57, d58, d59);
            dArray25[0] = ShewchuksDeterminant.Two_Two_Sum__x0(d56, d57, d58, d59);
            dArray25[3] = d60;
        }
        if (d40 != 0.0) {
            n9 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray2, d40, dArray48);
            n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n9, dArray48, 2.0 * d18, dArray29);
            int n32 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray25, d40, dArray37);
            n7 = ShewchuksDeterminant.scale_expansion_zeroelim(n32, dArray37, d22, dArray30);
            int n33 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray24, d40, dArray36);
            n6 = ShewchuksDeterminant.scale_expansion_zeroelim(n33, dArray36, -d23, dArray31);
            n5 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n7, dArray30, dArray32);
            n4 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n6, dArray31, n5, dArray32, dArray34);
            n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n4, dArray34, dArray73);
            dArray = dArray72;
            dArray72 = dArray73;
            dArray73 = dArray;
        }
        if (d41 != 0.0) {
            n10 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray2, d41, dArray49);
            n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n10, dArray49, 2.0 * d21, dArray29);
            int n34 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray24, d41, dArray38);
            n7 = ShewchuksDeterminant.scale_expansion_zeroelim(n34, dArray38, d20, dArray30);
            int n35 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray25, d41, dArray39);
            n6 = ShewchuksDeterminant.scale_expansion_zeroelim(n35, dArray39, -d19, dArray31);
            n5 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n7, dArray30, dArray32);
            n4 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n6, dArray31, n5, dArray32, dArray34);
            n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n4, dArray34, dArray73);
            dArray = dArray72;
            dArray72 = dArray73;
            dArray73 = dArray;
        }
        if (d42 != 0.0) {
            n11 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray3, d42, dArray50);
            n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n11, dArray50, 2.0 * d19, dArray29);
            int n36 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray23, d42, dArray40);
            n7 = ShewchuksDeterminant.scale_expansion_zeroelim(n36, dArray40, d23, dArray30);
            int n37 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray25, d42, dArray41);
            n6 = ShewchuksDeterminant.scale_expansion_zeroelim(n37, dArray41, -d21, dArray31);
            n5 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n7, dArray30, dArray32);
            n4 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n6, dArray31, n5, dArray32, dArray34);
            n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n4, dArray34, dArray73);
            dArray = dArray72;
            dArray72 = dArray73;
            dArray73 = dArray;
        }
        if (d43 != 0.0) {
            n12 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray3, d43, dArray51);
            n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n12, dArray51, 2.0 * d22, dArray29);
            int n38 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray25, d43, dArray43);
            n7 = ShewchuksDeterminant.scale_expansion_zeroelim(n38, dArray43, d18, dArray30);
            int n39 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray23, d43, dArray42);
            n6 = ShewchuksDeterminant.scale_expansion_zeroelim(n39, dArray42, -d20, dArray31);
            n5 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n7, dArray30, dArray32);
            n4 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n6, dArray31, n5, dArray32, dArray34);
            n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n4, dArray34, dArray73);
            dArray = dArray72;
            dArray72 = dArray73;
            dArray73 = dArray;
        }
        if (d44 != 0.0) {
            n13 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray4, d44, dArray52);
            n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n13, dArray52, 2.0 * d20, dArray29);
            int n40 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray24, d44, dArray45);
            n7 = ShewchuksDeterminant.scale_expansion_zeroelim(n40, dArray45, d21, dArray30);
            int n41 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray23, d44, dArray44);
            n6 = ShewchuksDeterminant.scale_expansion_zeroelim(n41, dArray44, -d22, dArray31);
            n5 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n7, dArray30, dArray32);
            n4 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n6, dArray31, n5, dArray32, dArray34);
            n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n4, dArray34, dArray73);
            dArray = dArray72;
            dArray72 = dArray73;
            dArray73 = dArray;
        }
        if (d45 != 0.0) {
            n14 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray4, d45, dArray53);
            n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n14, dArray53, 2.0 * d23, dArray29);
            int n42 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray23, d45, dArray46);
            n7 = ShewchuksDeterminant.scale_expansion_zeroelim(n42, dArray46, d19, dArray30);
            int n43 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray24, d45, dArray47);
            n6 = ShewchuksDeterminant.scale_expansion_zeroelim(n43, dArray47, -d18, dArray31);
            n5 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n7, dArray30, dArray32);
            n4 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n6, dArray31, n5, dArray32, dArray34);
            n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n4, dArray34, dArray73);
            dArray = dArray72;
            dArray72 = dArray73;
            dArray73 = dArray;
        }
        if (d40 != 0.0 || d41 != 0.0) {
            int n44;
            int n45;
            if (d42 != 0.0 || d43 != 0.0 || d44 != 0.0 || d45 != 0.0) {
                d16 = ShewchuksDeterminant.Two_Product_Head(d42, d23);
                d15 = ShewchuksDeterminant.Two_Product_Tail(d42, d23, d16);
                d14 = ShewchuksDeterminant.Two_Product_Head(d19, d45);
                d13 = ShewchuksDeterminant.Two_Product_Tail(d19, d45, d14);
                d12 = ShewchuksDeterminant.Two_Two_Sum__x3(d16, d15, d14, d13);
                dArray26[2] = ShewchuksDeterminant.Two_Two_Sum__x2(d16, d15, d14, d13);
                dArray26[1] = ShewchuksDeterminant.Two_Two_Sum__x1(d16, d15, d14, d13);
                dArray26[0] = ShewchuksDeterminant.Two_Two_Sum__x0(d16, d15, d14, d13);
                dArray26[3] = d12;
                d11 = -d22;
                d16 = ShewchuksDeterminant.Two_Product_Head(d44, d11);
                d15 = ShewchuksDeterminant.Two_Product_Tail(d44, d11, d16);
                d11 = -d43;
                d14 = ShewchuksDeterminant.Two_Product_Head(d20, d11);
                d13 = ShewchuksDeterminant.Two_Product_Tail(d20, d11, d14);
                d10 = ShewchuksDeterminant.Two_Two_Sum__x3(d16, d15, d14, d13);
                dArray27[2] = ShewchuksDeterminant.Two_Two_Sum__x2(d16, d15, d14, d13);
                dArray27[1] = ShewchuksDeterminant.Two_Two_Sum__x1(d16, d15, d14, d13);
                dArray27[0] = ShewchuksDeterminant.Two_Two_Sum__x0(d16, d15, d14, d13);
                dArray27[3] = d10;
                n45 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(4, dArray26, 4, dArray27, dArray67);
                d16 = ShewchuksDeterminant.Two_Product_Head(d42, d45);
                d15 = ShewchuksDeterminant.Two_Product_Tail(d42, d45, d16);
                d14 = ShewchuksDeterminant.Two_Product_Head(d44, d43);
                d13 = ShewchuksDeterminant.Two_Product_Tail(d44, d43, d14);
                double d61 = ShewchuksDeterminant.Two_Two_Diff__x3(d16, d15, d14, d13);
                dArray70[2] = ShewchuksDeterminant.Two_Two_Diff__x2(d16, d15, d14, d13);
                dArray70[1] = ShewchuksDeterminant.Two_Two_Diff__x1(d16, d15, d14, d13);
                dArray70[0] = ShewchuksDeterminant.Two_Two_Diff__x0(d16, d15, d14, d13);
                dArray70[3] = d61;
                n44 = 4;
            } else {
                dArray67[0] = 0.0;
                n45 = 1;
                dArray70[0] = 0.0;
                n44 = 1;
            }
            if (d40 != 0.0) {
                n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n9, dArray48, d40, dArray29);
                int n46 = ShewchuksDeterminant.scale_expansion_zeroelim(n45, dArray67, d40, dArray54);
                n5 = ShewchuksDeterminant.scale_expansion_zeroelim(n46, dArray54, 2.0 * d18, dArray32);
                n4 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n5, dArray32, dArray34);
                n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n4, dArray34, dArray73);
                dArray = dArray72;
                dArray72 = dArray73;
                dArray73 = dArray;
                if (d43 != 0.0) {
                    n3 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray25, d40, dArray28);
                    n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n3, dArray28, d43, dArray29);
                    n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n8, dArray29, dArray73);
                    dArray = dArray72;
                    dArray72 = dArray73;
                    dArray73 = dArray;
                }
                if (d45 != 0.0) {
                    n3 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray24, -d40, dArray28);
                    n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n3, dArray28, d45, dArray29);
                    n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n8, dArray29, dArray73);
                    dArray = dArray72;
                    dArray72 = dArray73;
                    dArray73 = dArray;
                }
                n5 = ShewchuksDeterminant.scale_expansion_zeroelim(n46, dArray54, d40, dArray32);
                int n47 = ShewchuksDeterminant.scale_expansion_zeroelim(n44, dArray70, d40, dArray60);
                n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n47, dArray60, 2.0 * d18, dArray29);
                n7 = ShewchuksDeterminant.scale_expansion_zeroelim(n47, dArray60, d40, dArray30);
                n2 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n7, dArray30, dArray33);
                n = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n5, dArray32, n2, dArray33, dArray35);
                n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n, dArray35, dArray73);
                dArray = dArray72;
                dArray72 = dArray73;
                dArray73 = dArray;
            }
            if (d41 != 0.0) {
                n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n10, dArray49, d41, dArray29);
                int n48 = ShewchuksDeterminant.scale_expansion_zeroelim(n45, dArray67, d41, dArray55);
                n5 = ShewchuksDeterminant.scale_expansion_zeroelim(n48, dArray55, 2.0 * d21, dArray32);
                n4 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n5, dArray32, dArray34);
                n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n4, dArray34, dArray73);
                dArray = dArray72;
                dArray72 = dArray73;
                dArray73 = dArray;
                n5 = ShewchuksDeterminant.scale_expansion_zeroelim(n48, dArray55, d41, dArray32);
                int n49 = ShewchuksDeterminant.scale_expansion_zeroelim(n44, dArray70, d41, dArray61);
                n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n49, dArray61, 2.0 * d21, dArray29);
                n7 = ShewchuksDeterminant.scale_expansion_zeroelim(n49, dArray61, d41, dArray30);
                n2 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n7, dArray30, dArray33);
                n = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n5, dArray32, n2, dArray33, dArray35);
                n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n, dArray35, dArray73);
                dArray = dArray72;
                dArray72 = dArray73;
                dArray73 = dArray;
            }
        }
        if (d42 != 0.0 || d43 != 0.0) {
            int n50;
            int n51;
            if (d44 != 0.0 || d45 != 0.0 || d40 != 0.0 || d41 != 0.0) {
                d16 = ShewchuksDeterminant.Two_Product_Head(d44, d21);
                d15 = ShewchuksDeterminant.Two_Product_Tail(d44, d21, d16);
                d14 = ShewchuksDeterminant.Two_Product_Head(d20, d41);
                d13 = ShewchuksDeterminant.Two_Product_Tail(d20, d41, d14);
                d12 = ShewchuksDeterminant.Two_Two_Sum__x3(d16, d15, d14, d13);
                dArray26[2] = ShewchuksDeterminant.Two_Two_Sum__x2(d16, d15, d14, d13);
                dArray26[1] = ShewchuksDeterminant.Two_Two_Sum__x1(d16, d15, d14, d13);
                dArray26[0] = ShewchuksDeterminant.Two_Two_Sum__x0(d16, d15, d14, d13);
                dArray26[3] = d12;
                d11 = -d23;
                d16 = ShewchuksDeterminant.Two_Product_Head(d40, d11);
                d15 = ShewchuksDeterminant.Two_Product_Tail(d40, d11, d16);
                d11 = -d45;
                d14 = ShewchuksDeterminant.Two_Product_Head(d18, d11);
                d13 = ShewchuksDeterminant.Two_Product_Tail(d18, d11, d14);
                d10 = ShewchuksDeterminant.Two_Two_Sum__x3(d16, d15, d14, d13);
                dArray27[2] = ShewchuksDeterminant.Two_Two_Sum__x2(d16, d15, d14, d13);
                dArray27[1] = ShewchuksDeterminant.Two_Two_Sum__x1(d16, d15, d14, d13);
                dArray27[0] = ShewchuksDeterminant.Two_Two_Sum__x0(d16, d15, d14, d13);
                dArray27[3] = d10;
                n51 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(4, dArray26, 4, dArray27, dArray68);
                d16 = ShewchuksDeterminant.Two_Product_Head(d44, d41);
                d15 = ShewchuksDeterminant.Two_Product_Tail(d44, d41, d16);
                d14 = ShewchuksDeterminant.Two_Product_Head(d40, d45);
                d13 = ShewchuksDeterminant.Two_Product_Tail(d40, d45, d14);
                double d62 = ShewchuksDeterminant.Two_Two_Diff__x3(d16, d15, d14, d13);
                dArray71[2] = ShewchuksDeterminant.Two_Two_Diff__x2(d16, d15, d14, d13);
                dArray71[1] = ShewchuksDeterminant.Two_Two_Diff__x1(d16, d15, d14, d13);
                dArray71[0] = ShewchuksDeterminant.Two_Two_Diff__x0(d16, d15, d14, d13);
                dArray71[3] = d62;
                n50 = 4;
            } else {
                dArray68[0] = 0.0;
                n51 = 1;
                dArray71[0] = 0.0;
                n50 = 1;
            }
            if (d42 != 0.0) {
                n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n11, dArray50, d42, dArray29);
                int n52 = ShewchuksDeterminant.scale_expansion_zeroelim(n51, dArray68, d42, dArray56);
                n5 = ShewchuksDeterminant.scale_expansion_zeroelim(n52, dArray56, 2.0 * d19, dArray32);
                n4 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n5, dArray32, dArray34);
                n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n4, dArray34, dArray73);
                dArray = dArray72;
                dArray72 = dArray73;
                dArray73 = dArray;
                if (d45 != 0.0) {
                    n3 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray23, d42, dArray28);
                    n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n3, dArray28, d45, dArray29);
                    n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n8, dArray29, dArray73);
                    dArray = dArray72;
                    dArray72 = dArray73;
                    dArray73 = dArray;
                }
                if (d41 != 0.0) {
                    n3 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray25, -d42, dArray28);
                    n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n3, dArray28, d41, dArray29);
                    n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n8, dArray29, dArray73);
                    dArray = dArray72;
                    dArray72 = dArray73;
                    dArray73 = dArray;
                }
                n5 = ShewchuksDeterminant.scale_expansion_zeroelim(n52, dArray56, d42, dArray32);
                int n53 = ShewchuksDeterminant.scale_expansion_zeroelim(n50, dArray71, d42, dArray62);
                n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n53, dArray62, 2.0 * d19, dArray29);
                n7 = ShewchuksDeterminant.scale_expansion_zeroelim(n53, dArray62, d42, dArray30);
                n2 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n7, dArray30, dArray33);
                n = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n5, dArray32, n2, dArray33, dArray35);
                n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n, dArray35, dArray73);
                dArray = dArray72;
                dArray72 = dArray73;
                dArray73 = dArray;
            }
            if (d43 != 0.0) {
                n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n12, dArray51, d43, dArray29);
                int n54 = ShewchuksDeterminant.scale_expansion_zeroelim(n51, dArray68, d43, dArray57);
                n5 = ShewchuksDeterminant.scale_expansion_zeroelim(n54, dArray57, 2.0 * d22, dArray32);
                n4 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n5, dArray32, dArray34);
                n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n4, dArray34, dArray73);
                dArray = dArray72;
                dArray72 = dArray73;
                dArray73 = dArray;
                n5 = ShewchuksDeterminant.scale_expansion_zeroelim(n54, dArray57, d43, dArray32);
                int n55 = ShewchuksDeterminant.scale_expansion_zeroelim(n50, dArray71, d43, dArray63);
                n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n55, dArray63, 2.0 * d22, dArray29);
                n7 = ShewchuksDeterminant.scale_expansion_zeroelim(n55, dArray63, d43, dArray30);
                n2 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n7, dArray30, dArray33);
                n = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n5, dArray32, n2, dArray33, dArray35);
                n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n, dArray35, dArray73);
                dArray = dArray72;
                dArray72 = dArray73;
                dArray73 = dArray;
            }
        }
        if (d44 != 0.0 || d45 != 0.0) {
            int n56;
            int n57;
            if (d40 != 0.0 || d41 != 0.0 || d42 != 0.0 || d43 != 0.0) {
                d16 = ShewchuksDeterminant.Two_Product_Head(d40, d22);
                d15 = ShewchuksDeterminant.Two_Product_Tail(d40, d22, d16);
                d14 = ShewchuksDeterminant.Two_Product_Head(d18, d43);
                d13 = ShewchuksDeterminant.Two_Product_Tail(d18, d43, d14);
                d12 = ShewchuksDeterminant.Two_Two_Sum__x3(d16, d15, d14, d13);
                dArray26[2] = ShewchuksDeterminant.Two_Two_Sum__x2(d16, d15, d14, d13);
                dArray26[1] = ShewchuksDeterminant.Two_Two_Sum__x1(d16, d15, d14, d13);
                dArray26[0] = ShewchuksDeterminant.Two_Two_Sum__x0(d16, d15, d14, d13);
                dArray26[3] = d12;
                d11 = -d21;
                d16 = ShewchuksDeterminant.Two_Product_Head(d42, d11);
                d15 = ShewchuksDeterminant.Two_Product_Tail(d42, d11, d16);
                d11 = -d41;
                d14 = ShewchuksDeterminant.Two_Product_Head(d19, d11);
                d13 = ShewchuksDeterminant.Two_Product_Tail(d19, d11, d14);
                d10 = ShewchuksDeterminant.Two_Two_Sum__x3(d16, d15, d14, d13);
                dArray27[2] = ShewchuksDeterminant.Two_Two_Sum__x2(d16, d15, d14, d13);
                dArray27[1] = ShewchuksDeterminant.Two_Two_Sum__x1(d16, d15, d14, d13);
                dArray27[0] = ShewchuksDeterminant.Two_Two_Sum__x0(d16, d15, d14, d13);
                dArray27[3] = d10;
                n57 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(4, dArray26, 4, dArray27, dArray66);
                d16 = ShewchuksDeterminant.Two_Product_Head(d40, d43);
                d15 = ShewchuksDeterminant.Two_Product_Tail(d40, d43, d16);
                d14 = ShewchuksDeterminant.Two_Product_Head(d42, d41);
                d13 = ShewchuksDeterminant.Two_Product_Tail(d42, d41, d14);
                double d63 = ShewchuksDeterminant.Two_Two_Diff__x3(d16, d15, d14, d13);
                dArray69[2] = ShewchuksDeterminant.Two_Two_Diff__x2(d16, d15, d14, d13);
                dArray69[1] = ShewchuksDeterminant.Two_Two_Diff__x1(d16, d15, d14, d13);
                dArray69[0] = ShewchuksDeterminant.Two_Two_Diff__x0(d16, d15, d14, d13);
                dArray69[3] = d63;
                n56 = 4;
            } else {
                dArray66[0] = 0.0;
                n57 = 1;
                dArray69[0] = 0.0;
                n56 = 1;
            }
            if (d44 != 0.0) {
                n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n13, dArray52, d44, dArray29);
                int n58 = ShewchuksDeterminant.scale_expansion_zeroelim(n57, dArray66, d44, dArray58);
                n5 = ShewchuksDeterminant.scale_expansion_zeroelim(n58, dArray58, 2.0 * d20, dArray32);
                n4 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n5, dArray32, dArray34);
                n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n4, dArray34, dArray73);
                dArray = dArray72;
                dArray72 = dArray73;
                dArray73 = dArray;
                if (d41 != 0.0) {
                    n3 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray24, d44, dArray28);
                    n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n3, dArray28, d41, dArray29);
                    n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n8, dArray29, dArray73);
                    dArray = dArray72;
                    dArray72 = dArray73;
                    dArray73 = dArray;
                }
                if (d43 != 0.0) {
                    n3 = ShewchuksDeterminant.scale_expansion_zeroelim(4, dArray23, -d44, dArray28);
                    n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n3, dArray28, d43, dArray29);
                    n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n8, dArray29, dArray73);
                    dArray = dArray72;
                    dArray72 = dArray73;
                    dArray73 = dArray;
                }
                n5 = ShewchuksDeterminant.scale_expansion_zeroelim(n58, dArray58, d44, dArray32);
                int n59 = ShewchuksDeterminant.scale_expansion_zeroelim(n56, dArray69, d44, dArray64);
                n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n59, dArray64, 2.0 * d20, dArray29);
                n7 = ShewchuksDeterminant.scale_expansion_zeroelim(n59, dArray64, d44, dArray30);
                n2 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n7, dArray30, dArray33);
                n = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n5, dArray32, n2, dArray33, dArray35);
                n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n, dArray35, dArray73);
                dArray = dArray72;
                dArray72 = dArray73;
                dArray73 = dArray;
            }
            if (d45 != 0.0) {
                n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n14, dArray53, d45, dArray29);
                int n60 = ShewchuksDeterminant.scale_expansion_zeroelim(n57, dArray66, d45, dArray59);
                n5 = ShewchuksDeterminant.scale_expansion_zeroelim(n60, dArray59, 2.0 * d23, dArray32);
                n4 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n5, dArray32, dArray34);
                n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n4, dArray34, dArray73);
                dArray = dArray72;
                dArray72 = dArray73;
                dArray73 = dArray;
                n5 = ShewchuksDeterminant.scale_expansion_zeroelim(n60, dArray59, d45, dArray32);
                int n61 = ShewchuksDeterminant.scale_expansion_zeroelim(n56, dArray69, d45, dArray65);
                n8 = ShewchuksDeterminant.scale_expansion_zeroelim(n61, dArray65, 2.0 * d23, dArray29);
                n7 = ShewchuksDeterminant.scale_expansion_zeroelim(n61, dArray65, d45, dArray30);
                n2 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n8, dArray29, n7, dArray30, dArray33);
                n = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n5, dArray32, n2, dArray33, dArray35);
                n31 = ShewchuksDeterminant.fast_expansion_sum_zeroelim(n31, dArray72, n, dArray35, dArray73);
                dArray = dArray72;
                dArray72 = dArray73;
                dArray73 = dArray;
            }
        }
        return dArray72[n31 - 1];
    }

    static {
        double d;
        boolean bl = true;
        double d2 = 0.5;
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = 1.0;
        do {
            d = d5;
            d3 *= d2;
            if (bl) {
                d4 *= 2.0;
            }
            bl = !bl;
        } while ((d5 = 1.0 + d3) != 1.0 && d5 != d);
        d4 += 1.0;
        resulterrbound = (3.0 + 8.0 * d3) * d3;
        ccwerrboundA = (3.0 + 16.0 * d3) * d3;
        ccwerrboundB = (2.0 + 12.0 * d3) * d3;
        ccwerrboundC = (9.0 + 64.0 * d3) * d3 * d3;
        o3derrboundA = (7.0 + 56.0 * d3) * d3;
        o3derrboundB = (3.0 + 28.0 * d3) * d3;
        o3derrboundC = (26.0 + 288.0 * d3) * d3 * d3;
        iccerrboundA = (10.0 + 96.0 * d3) * d3;
        iccerrboundB = (4.0 + 48.0 * d3) * d3;
        iccerrboundC = (44.0 + 576.0 * d3) * d3 * d3;
        isperrboundA = (16.0 + 224.0 * d3) * d3;
        isperrboundB = (5.0 + 72.0 * d3) * d3;
        isperrboundC = (71.0 + 1408.0 * d3) * d3 * d3;
        epsilon = d3;
        splitter = d4;
    }
}

