/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.vector.triangulation;

import geotrellis.vector.mesh.HalfEdge;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.linear.RealVector;
import org.locationtech.jts.geom.Coordinate;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class QuadricError$ {
    public static QuadricError$ MODULE$;

    static {
        new QuadricError$();
    }

    public RealMatrix facetMatrix(Traversable<Tuple3<Object, Object, Object>> tris, Function1<Object, Coordinate> trans) {
        return (RealMatrix)((TraversableOnce)tris.map((Function1 & java.io.Serializable & Serializable)x0$1 -> {
            Tuple3 tuple32 = x0$1;
            if (tuple32 == null) {
                throw new MatchError((Object)tuple32);
            }
            int a = BoxesRunTime.unboxToInt((Object)tuple32._1());
            int b = BoxesRunTime.unboxToInt((Object)tuple32._2());
            int c = BoxesRunTime.unboxToInt((Object)tuple32._3());
            Coordinate pa = (Coordinate)trans.apply((Object)BoxesRunTime.boxToInteger((int)a));
            Coordinate pb = (Coordinate)trans.apply((Object)BoxesRunTime.boxToInteger((int)b));
            Coordinate pc = (Coordinate)trans.apply((Object)BoxesRunTime.boxToInteger((int)c));
            Coordinate d1 = new Coordinate(pb.getX() - pa.getX(), pb.getY() - pa.getY(), pb.getZ() - pa.getZ());
            Coordinate d2 = new Coordinate(pc.getX() - pa.getX(), pc.getY() - pa.getY(), pc.getZ() - pa.getZ());
            double[] normal = MatrixUtils.createRealVector((double[])new double[]{d1.getY() * d2.getZ() - d1.getZ() * d2.getY(), d1.getZ() * d2.getX() - d1.getX() * d2.getZ(), d1.getX() * d2.getY() - d1.getY() * d2.getX()}).unitVector().toArray();
            double coeff = -(pa.getX() * normal[0] + pa.getY() * normal[1] + pa.getZ() * normal[2]);
            RealVector plane = MatrixUtils.createRealVector((double[])((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(normal)).$colon$plus((Object)BoxesRunTime.boxToDouble((double)coeff), ClassTag$.MODULE$.Double())));
            RealMatrix realMatrix = plane.outerProduct(plane);
            return realMatrix;
        }, Traversable$.MODULE$.canBuildFrom())).fold((Object)MatrixUtils.createRealMatrix((int)4, (int)4), (Function2 & java.io.Serializable & Serializable)(x$1, x$2) -> x$1.add(x$2));
    }

    public RealMatrix edgeMatrix(HalfEdge<Object, Object> e0, int end, Function1<Object, Coordinate> trans) {
        HalfEdge<Object, Object> e = e0;
        RealMatrix accum = MatrixUtils.createRealMatrix((double[][])((double[][])((Object[])new double[][]{(double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 0.0}), ClassTag$.MODULE$.Double()), (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 0.0}), ClassTag$.MODULE$.Double()), (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 0.0}), ClassTag$.MODULE$.Double()), (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 0.0}), ClassTag$.MODULE$.Double())})));
        do {
            Coordinate pa = (Coordinate)trans.apply(e.src());
            Coordinate pb = (Coordinate)trans.apply(e.vert());
            Coordinate d1 = new Coordinate(pb.getX() - pa.getX(), pb.getY() - pa.getY(), pb.getZ() - pa.getZ());
            Coordinate d2 = new Coordinate(0.0, 0.0, 0.5);
            double[] normal = MatrixUtils.createRealVector((double[])new double[]{d1.getY() * d2.getZ() - d1.getZ() * d2.getY(), d1.getZ() * d2.getX() - d1.getX() * d2.getZ(), d1.getX() * d2.getY() - d1.getY() * d2.getX()}).unitVector().toArray();
            double coeff = -(pa.getX() * normal[0] + pa.getY() * normal[1] + pa.getZ() * normal[2]);
            RealVector plane = MatrixUtils.createRealVector((double[])((double[])new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps(normal)).$colon$plus((Object)BoxesRunTime.boxToDouble((double)coeff), ClassTag$.MODULE$.Double())));
            accum = accum.add(plane.outerProduct(plane));
        } while (BoxesRunTime.unboxToInt((Object)(e = e.next()).src()) != end);
        return accum;
    }

    private QuadricError$() {
        MODULE$ = this;
    }
}

