/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.storage.filesystem.hdfs.fs;

import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.data.common.storage.AtlasStorageInfo$;
import com.geoway.atlas.data.storage.filesystem.hdfs.storage.HdfsStorageInfo$;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FileSystemFactory$
implements LazyLogging {
    public static FileSystemFactory$ MODULE$;
    private final String[] HDFS_CONF_FILES;
    private final String ATLAS_PRINCIPAL;
    private final String ATLAS_KEYTAB;
    private final String ATLAS_FILESYSTEM_LOGIN_USER;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new FileSystemFactory$();
    }

    private Logger logger$lzycompute() {
        FileSystemFactory$ fileSystemFactory$ = this;
        synchronized (fileSystemFactory$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public String[] HDFS_CONF_FILES() {
        return this.HDFS_CONF_FILES;
    }

    public String ATLAS_PRINCIPAL() {
        return this.ATLAS_PRINCIPAL;
    }

    public String ATLAS_KEYTAB() {
        return this.ATLAS_KEYTAB;
    }

    public String ATLAS_FILESYSTEM_LOGIN_USER() {
        return this.ATLAS_FILESYSTEM_LOGIN_USER;
    }

    public void main(String[] args) {
        FileSystem fileSystem = this.newInstance((Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)AtlasStorageInfo$.MODULE$.STORAGE_CONF_DIR()), (Object)"D:\\Codebase\\java\\atlas-gis-toolkit\\data\\storage\\filesystem\\hdfs\\src\\test\\resources\\hadoop_conf"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HdfsStorageInfo$.MODULE$.CONNECT_PATH()), (Object)"hdfs://hacluster/bigdata_test")}))));
        Predef$.MODULE$.println((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileSystem.listStatus(new Path("hdfs://hacluster/bigdata_test")))).map((Function1 & Serializable & scala.Serializable)fs -> fs.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class))))).mkString(","));
    }

    public FileSystem newInstance(Map<String, String> storageParams) {
        FileSystem fileSystem;
        Predef$.MODULE$.println((Object)"\u83b7\u53d6\u914d\u7f6e\u4fe1\u606f!");
        Configuration conf = this.getConfiguration(storageParams);
        String pathString = (String)storageParams.apply((Object)HdfsStorageInfo$.MODULE$.CONNECT_PATH());
        String loginUser = conf.get(this.ATLAS_FILESYSTEM_LOGIN_USER(), "");
        if (StringUtils.isNotBlank((CharSequence)loginUser)) {
            this.logger().info(new StringBuilder(7).append("\u6587\u4ef6\u7cfb\u7edf\u7528\u6237\uff1a").append(loginUser).toString());
            fileSystem = (FileSystem)UserGroupInformation.getLoginUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<FileSystem>(pathString, conf){
                private final String pathString$1;
                private final Configuration conf$1;

                public FileSystem run() {
                    return FileSystem.newInstance((URI)new Path(this.pathString$1).toUri(), (Configuration)this.conf$1);
                }
                {
                    this.pathString$1 = pathString$1;
                    this.conf$1 = conf$1;
                }
            });
        } else {
            fileSystem = FileSystem.newInstance((URI)new Path(pathString).toUri(), (Configuration)conf);
        }
        return fileSystem;
    }

    /*
     * WARNING - void declaration
     */
    public Configuration getConfiguration(Map<String, String> storageParams) {
        void var2_2;
        block1: {
            String config_path;
            File config_dir;
            Configuration conf = new Configuration();
            String userName = null;
            if (!storageParams.contains((Object)AtlasStorageInfo$.MODULE$.STORAGE_CONF_DIR()) || !(config_dir = new File((String)storageParams.apply((Object)AtlasStorageInfo$.MODULE$.STORAGE_CONF_DIR()))).exists() || !config_dir.isDirectory() || !StringUtils.isNotBlank((CharSequence)(config_path = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File((String)storageParams.apply((Object)AtlasStorageInfo$.MODULE$.STORAGE_CONF_DIR())).listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])FileSystemFactory$.MODULE$.HDFS_CONF_FILES())).contains((Object)name.toLowerCase());
                }
            }))).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getAbsolutePath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",")))) break block1;
            Predef$.MODULE$.println((Object)new StringBuilder(7).append("\u52a0\u8f7d\u914d\u7f6e\u6587\u4ef6:").append(config_path).toString());
            conf = new Configuration(false);
            this._addResources(conf, config_path);
            userName = this.loginIfNeedIgnoreErr(conf, (String)storageParams.apply((Object)AtlasStorageInfo$.MODULE$.STORAGE_CONF_DIR()));
            if (StringUtils.isNotBlank((CharSequence)userName)) {
                conf.set(this.ATLAS_FILESYSTEM_LOGIN_USER(), userName);
            }
        }
        return var2_2;
    }

    private String loginIfNeedIgnoreErr(Configuration conf, String storageConfDir) {
        String user_name = null;
        if (StringUtils.isNotBlank((CharSequence)conf.get(this.ATLAS_PRINCIPAL())) && StringUtils.isNotBlank((CharSequence)conf.get(this.ATLAS_KEYTAB()))) {
            Option keytabFileOpt = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new File(storageConfDir).listFiles(new FilenameFilter(conf){
                private final Configuration conf$2;

                public boolean accept(File dir, String name) {
                    return this.conf$2.get(FileSystemFactory$.MODULE$.ATLAS_KEYTAB()).equalsIgnoreCase(name.toLowerCase());
                }
                {
                    this.conf$2 = conf$2;
                }
            }))).headOption();
            if (keytabFileOpt.isDefined()) {
                UserGroupInformation.setConfiguration((Configuration)conf);
                try {
                    UserGroupInformation.loginUserFromKeytab((String)conf.get(this.ATLAS_PRINCIPAL()), (String)((File)keytabFileOpt.get()).getPath());
                    user_name = conf.get(this.ATLAS_PRINCIPAL());
                    this.logger().info(new StringBuilder(27).append("kerberos\u767b\u5f55\u6210\u529f, \u7528\u6237:").append(conf.get(this.ATLAS_PRINCIPAL())).append(", keytab: ").append(((File)keytabFileOpt.get()).getPath()).toString());
                }
                catch (Throwable throwable) {
                    this.logger().warn(new StringBuilder(34).append("kerberos\u8ba4\u8bc1\u5931\u8d25\uff0cPRINCIPAL: ").append(conf.get(this.ATLAS_PRINCIPAL())).append(", KEYTAB: ").append(((File)keytabFileOpt.get()).getPath()).toString());
                }
            } else {
                this.logger().warn(new StringBuilder(13).append("\u672a\u627e\u5230keytab\u6587\u4ef6: ").append(conf.get(this.ATLAS_KEYTAB())).toString());
            }
        } else {
            this.logger().warn("\u672a\u914d\u7f6ekerberos\u8ba4\u8bc1\u4fe1\u606f!");
        }
        this.logger().info(new StringBuilder(51).append("Kerberos \u767b\u5f55\u7528\u6237:").append(UserGroupInformation.getLoginUser()).append(", \u5f53\u524d\u7528\u6237\uff1a").append(UserGroupInformation.getCurrentUser()).append(", LoginReal\u7528\u6237\uff1a").append(UserGroupInformation.getLoginUser().getRealUser()).append(", currentReal\u7528\u6237\uff1a").append(UserGroupInformation.getCurrentUser().getRealUser()).toString());
        return user_name;
    }

    private void _addResources(Configuration conf, String paths) {
        block0: {
            if (!StringUtils.isNotBlank((CharSequence)paths)) break block0;
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(paths)).split(','))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.trim(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).filterNot((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.isEmpty())))).foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
                FileSystemFactory$.MODULE$._addResource(conf, x$4);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void _addResource(Configuration conf, String path) {
        File configFile = new File(path);
        if (configFile.exists()) {
            conf.addResource((InputStream)new FileInputStream(configFile));
        } else {
            this.logger().warn(new StringBuilder(12).append("\u65e0\u6cd5\u8f7d\u5165\u6307\u5b9a\u7684\u914d\u7f6e\u6587\u4ef6:").append(configFile).toString());
        }
    }

    private FileSystemFactory$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.HDFS_CONF_FILES = (String[])((Object[])new String[]{"core-site.xml", "hdfs-site.xml", "atlas-site.xml"});
        this.ATLAS_PRINCIPAL = "atlas.kerberos.principal";
        this.ATLAS_KEYTAB = "atlas.kerberos.keytab";
        this.ATLAS_FILESYSTEM_LOGIN_USER = "atlas.filesystem.login.user";
    }
}

