/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.store;

import com.geoway.atlas.common.error.NotSupportException;
import java.io.IOException;
import java.sql.Connection;
import java.util.Map;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureWriter;
import org.geotools.data.InProcessLockingManager;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.data.store.ContentFeatureStore;
import org.geotools.data.store.DiffTransactionState;
import org.geotools.data.store.EventContentFeatureWriter;
import org.geotools.feature.NameImpl;
import org.geotools.jdbc.GeoToolsJdbcProxyUtils;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.util.factory.Hints;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

public class ContentDataStoreUtils {
    public static final int WRITER_ADD = 1;
    public static final int WRITER_UPDATE = 2;
    public static final int WRITER_COMMIT = 4;

    public static ContentEntry entry(ContentDataStore cds, Name name) throws IOException {
        return cds.entry(name);
    }

    public static void removeEntry(ContentDataStore cds, Name name) {
        cds.removeEntry(name);
    }

    public static FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(JDBCDataStore jdbcDataStore, String typeName, Transaction tx) throws IOException {
        ContentFeatureStore featureStore = jdbcDataStore.ensureFeatureStore(typeName, tx);
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = ContentDataStoreUtils.getWriter(featureStore, (Filter)Filter.INCLUDE, 1);
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }

    public static FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(JDBCDataStore jdbcDataStore, String typeName, Transaction tx, Connection connection) throws IOException {
        ContentFeatureStore featureStore = jdbcDataStore.ensureFeatureStore(typeName, tx);
        FeatureWriter<SimpleFeatureType, SimpleFeature> writer = ContentDataStoreUtils.getWriter(featureStore, (Filter)Filter.INCLUDE, 1, connection);
        while (writer.hasNext()) {
            writer.next();
        }
        return writer;
    }

    public static FeatureWriter<SimpleFeatureType, SimpleFeature> getWriter(ContentFeatureStore featureStore, Filter filter, int flags) throws IOException {
        return ContentDataStoreUtils.getWriter(featureStore, new Query(featureStore.getSchema().getTypeName(), filter), flags);
    }

    public static FeatureWriter<SimpleFeatureType, SimpleFeature> getWriter(ContentFeatureStore featureStore, Filter filter, int flags, Connection connection) throws IOException {
        return ContentDataStoreUtils.getWriter(featureStore, new Query(featureStore.getSchema().getTypeName(), filter), flags, connection);
    }

    public static FeatureWriter<SimpleFeatureType, SimpleFeature> getWriter(ContentFeatureStore featureStore, Query query, int flags) throws IOException {
        FilteringFeatureWriter writer;
        query = featureStore.joinQuery(query);
        query = featureStore.resolvePropertyNames(query);
        if (!featureStore.canTransact() && featureStore.transaction != null && featureStore.transaction != Transaction.AUTO_COMMIT) {
            if ((flags | 4) == 4) {
                writer = ContentDataStoreUtils.getWriterInternal(featureStore, query, flags);
                if (!featureStore.canFilter() && query.getFilter() != null && query.getFilter() != Filter.INCLUDE) {
                    writer = new FilteringFeatureWriter((FeatureWriter)writer, query.getFilter());
                }
            } else {
                DiffTransactionState state = (DiffTransactionState)featureStore.getTransaction().getState((Object)featureStore.getEntry());
                FeatureReader reader = featureStore.getReader(query);
                writer = state.diffWriter(featureStore, reader);
            }
        } else {
            writer = ContentDataStoreUtils.getWriterInternal(featureStore, query, flags);
            if (!featureStore.canEvent()) {
                writer = new EventContentFeatureWriter(featureStore, writer);
            }
            if (!featureStore.canFilter() && query.getFilter() != null && query.getFilter() != Filter.INCLUDE) {
                writer = new FilteringFeatureWriter(writer, query.getFilter());
            }
        }
        if (!featureStore.canLock()) {
            InProcessLockingManager lockingManager = (InProcessLockingManager)featureStore.getDataStore().getLockingManager();
            writer = lockingManager.checkedWriter(writer, featureStore.transaction);
        }
        return writer;
    }

    public static FeatureWriter<SimpleFeatureType, SimpleFeature> getWriter(ContentFeatureStore featureStore, Query query, int flags, Connection connection) throws IOException {
        FilteringFeatureWriter writer;
        query = featureStore.joinQuery(query);
        query = featureStore.resolvePropertyNames(query);
        if (!featureStore.canTransact() && featureStore.transaction != null && featureStore.transaction != Transaction.AUTO_COMMIT) {
            if ((flags | 4) == 4) {
                writer = ContentDataStoreUtils.getWriterInternal(featureStore, query, flags, connection);
                if (!featureStore.canFilter() && query.getFilter() != null && query.getFilter() != Filter.INCLUDE) {
                    writer = new FilteringFeatureWriter((FeatureWriter)writer, query.getFilter());
                }
            } else {
                DiffTransactionState state = (DiffTransactionState)featureStore.getTransaction().getState((Object)featureStore.getEntry());
                FeatureReader reader = featureStore.getReader(query);
                writer = state.diffWriter(featureStore, reader);
            }
        } else {
            writer = ContentDataStoreUtils.getWriterInternal(featureStore, query, flags, connection);
            if (!featureStore.canEvent()) {
                writer = new EventContentFeatureWriter(featureStore, writer);
            }
            if (!featureStore.canFilter() && query.getFilter() != null && query.getFilter() != Filter.INCLUDE) {
                writer = new FilteringFeatureWriter(writer, query.getFilter());
            }
        }
        return writer;
    }

    public static FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(ContentFeatureStore featureStore, Query query, int flags) throws IOException {
        if (featureStore instanceof JDBCFeatureStore) {
            return GeoToolsJdbcProxyUtils.getWriterInternal((JDBCFeatureStore)featureStore, query, flags);
        }
        throw new NotSupportException("\u4e0d\u652f\u6301\u5f53\u524d\u7684\u6570\u636e\u96c6\u7c7b\u578b:" + featureStore.getClass().getSimpleName(), Thread.currentThread(), 3);
    }

    public static FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(ContentFeatureStore featureStore, Query query, int flags, Connection connection) throws IOException {
        if (featureStore instanceof JDBCFeatureStore) {
            return GeoToolsJdbcProxyUtils.getWriterInternal((JDBCFeatureStore)featureStore, query, flags, connection);
        }
        throw new NotSupportException("\u4e0d\u652f\u6301\u5f53\u524d\u7684\u6570\u636e\u96c6\u7c7b\u578b:" + featureStore.getClass().getSimpleName(), Thread.currentThread(), 3);
    }

    public static ContentFeatureSource getFeatureSource(JDBCDataStore ds, SimpleFeatureType sft) throws IOException {
        return ContentDataStoreUtils.getFeatureSource(ds, sft, Transaction.AUTO_COMMIT);
    }

    public static ContentFeatureSource getFeatureSource(JDBCDataStore ds, SimpleFeatureType sft, Transaction tx) throws IOException {
        NameImpl typeName = new NameImpl(null, sft.getName().getLocalPart());
        ContentEntry entry = ds.ensureEntry((Name)typeName);
        ContentFeatureSource featureSource = ContentDataStoreUtils.createFeatureSource(ds, entry, sft);
        featureSource.setTransaction(tx);
        return featureSource;
    }

    protected static ContentFeatureSource createFeatureSource(JDBCDataStore ds, ContentEntry entry, SimpleFeatureType sft) throws IOException {
        Object readOnlyMarker;
        SimpleFeatureType schema = entry.getState(Transaction.AUTO_COMMIT).getFeatureType();
        if (schema == null) {
            ContentDataStoreUtils.repairSft(sft);
            schema = sft;
            entry.getState(Transaction.AUTO_COMMIT).setFeatureType(schema);
        }
        if (Boolean.TRUE.equals(readOnlyMarker = schema.getUserData().get("org.geotools.jdbc.readOnly"))) {
            return new JDBCFeatureSource(entry, null);
        }
        return new JDBCFeatureStore(entry, null);
    }

    public static void repairSft(SimpleFeatureType sft) {
        for (AttributeDescriptor ad : sft.getAttributeDescriptors()) {
            Map userdata = ad.getUserData();
            if (userdata.containsKey("org.geotools.jdbc.nativeType")) {
                userdata.put("org.geotools.jdbc.nativeType", Integer.parseInt(userdata.get("org.geotools.jdbc.nativeType").toString()));
            }
            if (userdata.containsKey("org.geotools.jdbc.pk.column")) {
                userdata.put("org.geotools.jdbc.pk.column", Boolean.parseBoolean(userdata.get("org.geotools.jdbc.pk.column").toString()));
            }
            if (userdata.containsKey("nativeSRID")) {
                userdata.put("nativeSRID", Integer.parseInt(userdata.get("nativeSRID").toString()));
            }
            if (!userdata.containsKey(Hints.COORDINATE_DIMENSION.toString())) continue;
            userdata.put(Hints.COORDINATE_DIMENSION, Integer.parseInt(userdata.get(Hints.COORDINATE_DIMENSION.toString()).toString()));
        }
    }
}

