/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import com.geoway.atlas.common.error.ExistException;
import com.geoway.atlas.common.error.IoException;
import com.geoway.atlas.common.error.NotFoundException;
import com.geoway.atlas.common.error.NotMatchException;
import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.utils.CollectionUtilsForJ;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureWriter;
import org.geotools.data.Query;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentDataStoreUtils;
import org.geotools.data.store.ContentEntry;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.AJDBCInsertFeatureWriter;
import org.geotools.jdbc.AJDBCUpdateInsertFeatureWriter;
import org.geotools.jdbc.AttributeRange;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.ColumnMetadata;
import org.geotools.jdbc.EnumMapper;
import org.geotools.jdbc.GeoToolsJdbcRangeUtils;
import org.geotools.jdbc.InsertionClassifier;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JDBCDataStoreFactory;
import org.geotools.jdbc.JDBCFeatureSource;
import org.geotools.jdbc.JDBCFeatureStore;
import org.geotools.jdbc.JDBCState;
import org.geotools.jdbc.JDBCUpdateFeatureWriter;
import org.geotools.jdbc.JdbcOp;
import org.geotools.jdbc.KeysFetcher;
import org.geotools.jdbc.NonIncrementFetcher;
import org.geotools.jdbc.NonIncrementingPrimaryKeyColumn;
import org.geotools.jdbc.NullPrimaryKey;
import org.geotools.jdbc.PkeyAttr;
import org.geotools.jdbc.PreparedStatementSQLDialect;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.SQLDialect;
import org.geotools.jdbc.VirtualTable;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Association;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.PropertyIsLessThanOrEqualTo;
import org.opengis.filter.expression.Function;
import org.opengis.filter.expression.Literal;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.SingleCRS;

public class GeoToolsJdbcProxyUtils {
    public static String getDatabaseID(JDBCDataStoreFactory jdbcDataStoreFactory) {
        return jdbcDataStoreFactory.getDatabaseID();
    }

    public static boolean existSchema(JDBCDataStore jdbcDataStore, String typeName, boolean writeForce) throws IOException {
        SimpleFeatureType existSft;
        ContentEntry ce = ContentDataStoreUtils.entry((ContentDataStore)jdbcDataStore, (Name)new NameImpl(null, typeName));
        if (ce != null && !GeoToolsJdbcProxyUtils.existTable(jdbcDataStore, typeName)) {
            ContentDataStoreUtils.removeEntry((ContentDataStore)jdbcDataStore, ce.getName());
            ce = null;
        }
        SimpleFeatureType simpleFeatureType = existSft = ce == null ? null : GeoToolsJdbcProxyUtils.getSchema(jdbcDataStore, typeName);
        if (existSft != null && !writeForce) {
            throw new ExistException("\u6570\u636e\u96c6\u5df2\u5b58\u5728:" + typeName, Thread.currentThread(), 3);
        }
        return existSft != null;
    }

    public static boolean deleteSchema(JDBCDataStore jdbcDataStore, String tableName) throws IOException {
        SimpleFeatureType existSft;
        ContentEntry ce = ContentDataStoreUtils.entry((ContentDataStore)jdbcDataStore, (Name)new NameImpl(null, tableName));
        if (ce != null && !GeoToolsJdbcProxyUtils.existTable(jdbcDataStore, tableName)) {
            ContentDataStoreUtils.removeEntry((ContentDataStore)jdbcDataStore, ce.getName());
            ce = null;
        }
        SimpleFeatureType simpleFeatureType = existSft = ce == null ? null : GeoToolsJdbcProxyUtils.getSchema(jdbcDataStore, tableName);
        if (existSft != null) {
            jdbcDataStore.removeSchema(tableName);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createSchema(JDBCDataStore jdbcDataStore, SimpleFeatureType featureType, boolean isOverride, boolean writeForce, boolean isCreateSpatialIndex) throws IOException {
        SimpleFeatureType existSft;
        ContentEntry ce = ContentDataStoreUtils.entry((ContentDataStore)jdbcDataStore, (Name)new NameImpl(null, featureType.getTypeName()));
        if (ce != null && !GeoToolsJdbcProxyUtils.existTable(jdbcDataStore, featureType.getTypeName())) {
            ContentDataStoreUtils.removeEntry((ContentDataStore)jdbcDataStore, ce.getName());
            ce = null;
        }
        SimpleFeatureType simpleFeatureType = existSft = ce == null ? null : GeoToolsJdbcProxyUtils.getSchema(jdbcDataStore, featureType.getTypeName());
        if (existSft != null && !writeForce) {
            throw new ExistException("\u6570\u636e\u96c6\u5df2\u5b58\u5728:" + featureType.getTypeName(), Thread.currentThread(), 3);
        }
        if (isOverride) {
            if (existSft != null) {
                jdbcDataStore.removeSchema(featureType.getTypeName());
            }
        } else if (existSft != null) {
            return;
        }
        Connection cx = jdbcDataStore.createConnection();
        try {
            String sql = GeoToolsJdbcProxyUtils.createTableSQL(jdbcDataStore, featureType, cx);
            jdbcDataStore.getLogger().log(Level.INFO, "Create schema: {0}", sql);
            Statement st = cx.createStatement();
            try {
                st.execute(sql);
            }
            finally {
                jdbcDataStore.closeSafe(st);
            }
            GeoToolsJdbcProxyUtils.postCreateTable(jdbcDataStore.dialect, jdbcDataStore.databaseSchema, featureType, cx, isCreateSpatialIndex);
        }
        catch (Exception e) {
            String msg = "Error occurred creating table";
            throw (IOException)new IOException(msg).initCause(e);
        }
        finally {
            jdbcDataStore.closeSafe(cx);
        }
    }

    public static boolean existTable(JDBCDataStore jdbcDataStore, String tableName) {
        Connection connection = jdbcDataStore.createConnection();
        try {
            boolean bl = jdbcDataStore.getSQLDialect().includeTable(jdbcDataStore.getDatabaseSchema(), tableName, connection);
            return bl;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            jdbcDataStore.closeSafe(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleFeatureType getSchema(JDBCDataStore jdbcDataStore, String typeName) throws IOException {
        JDBCFeatureSource jdbcFeatureSource = jdbcDataStore.getAbsoluteFeatureSource(typeName);
        ContentEntry ce = jdbcFeatureSource.getEntry();
        PrimaryKey pkey = jdbcFeatureSource.getPrimaryKey();
        VirtualTable virtualTable = (VirtualTable)jdbcDataStore.getVirtualTables().get(ce.getTypeName());
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        AttributeTypeBuilder ab = new AttributeTypeBuilder();
        boolean readOnly = false;
        if (pkey == null || pkey instanceof NullPrimaryKey || virtualTable != null) {
            readOnly = true;
        }
        String tableName = ce.getName().getLocalPart();
        tb.setName(tableName);
        if (ce.getName().getNamespaceURI() != null) {
            tb.setNamespaceURI(ce.getName().getNamespaceURI());
        } else {
            tb.setNamespaceURI(jdbcDataStore.getNamespaceURI());
        }
        JDBCState state = jdbcFeatureSource.getState();
        String databaseSchema = jdbcDataStore.getDatabaseSchema();
        Connection cx = jdbcDataStore.getConnection(state);
        SQLDialect dialect = jdbcDataStore.getSQLDialect();
        try {
            DatabaseMetaData metaData = cx.getMetaData();
            List<ColumnMetadata> columns = virtualTable != null ? GeoToolsJdbcProxyUtils.getColumnMetadata(cx, virtualTable, dialect, jdbcDataStore) : GeoToolsJdbcProxyUtils.getColumnMetadata(cx, databaseSchema, tableName, dialect);
            for (ColumnMetadata column : columns) {
                Class binding;
                String name = column.name;
                for (PrimaryKeyColumn pkeycol : pkey.getColumns()) {
                    if (name.equals(pkeycol.getName()) && !state.isExposePrimaryKeyColumns()) {
                        name = null;
                        break;
                    }
                    if (pkeycol.type != null) continue;
                    pkeycol.type = column.binding;
                }
                if (name == null) continue;
                if (jdbcDataStore.isAssociations()) {
                    jdbcDataStore.ensureAssociationTablesExist(cx);
                    Statement st = null;
                    ResultSet relationships = null;
                    if (jdbcDataStore.getSQLDialect() instanceof PreparedStatementSQLDialect) {
                        st = jdbcDataStore.selectRelationshipSQLPS(tableName, name, cx);
                        relationships = st.executeQuery();
                    } else {
                        String sql = jdbcDataStore.selectRelationshipSQL(tableName, name);
                        jdbcDataStore.getLogger().info(sql);
                        st = cx.createStatement();
                        relationships = st.executeQuery(sql);
                    }
                    try {
                        if (relationships.next()) {
                            tb.add(name, Association.class);
                            continue;
                        }
                    }
                    finally {
                        jdbcDataStore.closeSafe(relationships);
                        jdbcDataStore.closeSafe(st);
                        continue;
                    }
                }
                if ((binding = column.binding) == null) {
                    binding = jdbcDataStore.getMapping(column.typeName);
                }
                if (binding == null) {
                    binding = jdbcDataStore.getMapping(column.sqlType);
                }
                if (binding == null) {
                    jdbcDataStore.getLogger().warning("Could not find mapping for '" + name + "', ignoring the column and setting the feature type read only");
                    readOnly = true;
                    continue;
                }
                ab.addUserData((Object)"org.geotools.jdbc.nativeTypeName", (Object)column.typeName);
                ab.addUserData((Object)"org.geotools.jdbc.nativeType", (Object)column.sqlType);
                if (!column.nullable) {
                    ab.nillable(false);
                    ab.minOccurs(1);
                }
                if (column.restriction != null) {
                    ab.addRestriction(column.restriction);
                }
                AttributeDescriptor att = null;
                if (Geometry.class.isAssignableFrom(binding)) {
                    Integer srid = null;
                    CoordinateReferenceSystem crs = null;
                    try {
                        srid = virtualTable != null ? Integer.valueOf(virtualTable.getNativeSrid(name)) : dialect.getGeometrySRID(databaseSchema, tableName, name, cx);
                        if (srid != null && srid > 0) {
                            crs = GeoToolsJdbcProxyUtils.getJdbcOp(dialect).createCRS(srid, cx);
                        }
                    }
                    catch (Exception e) {
                        String msg = "Error occured determing srid for " + tableName + "." + name;
                        jdbcDataStore.getLogger().log(Level.WARNING, msg, e);
                    }
                    int dimension = 2;
                    try {
                        dimension = virtualTable != null ? virtualTable.getDimension(name) : dialect.getGeometryDimension(databaseSchema, tableName, name, cx);
                    }
                    catch (Exception e) {
                        String msg = "Error occured determing dimension for " + tableName + "." + name;
                        jdbcDataStore.getLogger().log(Level.WARNING, msg, e);
                    }
                    ab.setBinding(binding);
                    ab.setName(name);
                    ab.setCRS(crs);
                    if (srid != null) {
                        ab.addUserData((Object)"nativeSRID", (Object)srid);
                    }
                    ab.addUserData((Object)Hints.COORDINATE_DIMENSION, (Object)dimension);
                    att = ab.buildDescriptor(name, ab.buildGeometryType());
                } else {
                    ab.setName(name);
                    ab.setBinding(binding);
                    att = ab.buildDescriptor(name, ab.buildType());
                }
                if (pkey.getColumn(att.getLocalName()) != null) {
                    att.getUserData().put("org.geotools.jdbc.pk.column", true);
                }
                dialect.postCreateAttribute(att, tableName, databaseSchema, cx);
                tb.add(att);
            }
            SimpleFeatureType ft = tb.buildFeatureType();
            if (readOnly) {
                ft.getUserData().put("org.geotools.jdbc.readOnly", Boolean.TRUE);
            }
            dialect.postCreateFeatureType(ft, metaData, databaseSchema, cx);
            SimpleFeatureType simpleFeatureType = ft;
            return simpleFeatureType;
        }
        catch (SQLException e) {
            String msg = "Error occurred building feature type";
            throw (IOException)new IOException(msg).initCause(e);
        }
        finally {
            jdbcDataStore.releaseConnection(cx, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ColumnMetadata> getColumnMetadata(Connection cx, VirtualTable vtable, SQLDialect dialect, JDBCDataStore store) throws SQLException {
        ArrayList<ColumnMetadata> result = new ArrayList<ColumnMetadata>();
        Statement st = null;
        ResultSet rs = null;
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("select * from (");
            sb.append(vtable.expandParameters(null));
            sb.append(")");
            dialect.encodeTableAlias("vtable", sb);
            sb.append(" where 1 = 0");
            String sql = sb.toString();
            st = cx.createStatement();
            store.getLogger().log(Level.INFO, "Gathering sql view result structure: {0}", sql);
            rs = st.executeQuery(sql);
            ResultSetMetaData metadata = rs.getMetaData();
            for (int i = 1; i < metadata.getColumnCount() + 1; ++i) {
                ColumnMetadata column = new ColumnMetadata();
                column.name = metadata.getColumnLabel(i);
                column.typeName = metadata.getColumnTypeName(i);
                column.sqlType = metadata.getColumnType(i);
                column.nullable = metadata.isNullable(i) != 0;
                column.srid = vtable.getNativeSrid(column.name);
                column.binding = vtable.getGeometryType(column.name);
                if (column.binding == null) {
                    column.binding = store.getMapping(column.typeName);
                    if (column.binding == null) {
                        column.binding = store.getMapping(column.sqlType);
                    }
                }
                result.add(column);
            }
        }
        catch (Throwable throwable) {
            store.closeSafe(st);
            store.closeSafe(rs);
            throw throwable;
        }
        store.closeSafe(st);
        store.closeSafe(rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ColumnMetadata> getColumnMetadata(Connection cx, String databaseSchema, String tableName, SQLDialect dialect) throws SQLException {
        ArrayList<ColumnMetadata> result = new ArrayList<ColumnMetadata>();
        DatabaseMetaData metaData = cx.getMetaData();
        ResultSet columns = metaData.getColumns(cx.getCatalog(), dialect.dataStore.escapeNamePattern(metaData, databaseSchema), dialect.dataStore.escapeNamePattern(metaData, tableName), "%");
        try {
            if (dialect.dataStore.getFetchSize() > 0) {
                columns.setFetchSize(dialect.dataStore.getFetchSize());
            }
            while (columns.next()) {
                ColumnMetadata column = new ColumnMetadata();
                column.name = columns.getString("COLUMN_NAME");
                column.typeName = columns.getString("TYPE_NAME");
                column.sqlType = columns.getInt("DATA_TYPE");
                column.nullable = "YES".equalsIgnoreCase(columns.getString("IS_NULLABLE"));
                column.binding = dialect.getMapping(columns, cx);
                if (column.binding == null) {
                    column.binding = dialect.dataStore.getMapping(column.typeName);
                }
                if (column.binding == null) {
                    column.binding = dialect.dataStore.getMapping(column.sqlType);
                }
                if (column.binding == null) {
                    dialect.dataStore.getLogger().warning("Could not find mapping for '" + column.name + "', ignoring the column and setting the feature type read only");
                }
                column.restriction = dialect.getRestrictions(columns, cx);
                if (column.restriction == null) {
                    int columnSize = columns.getInt("COLUMN_SIZE");
                    column.restriction = FeatureTypes.createLengthRestriction((int)columnSize);
                }
                GeoToolsJdbcProxyUtils.transDecimal(column, columns);
                if (column.sqlType == 2001) {
                    dialect.handleUserDefinedType(columns, column, cx);
                }
                result.add(column);
            }
        }
        finally {
            dialect.dataStore.closeSafe(columns);
        }
        return result;
    }

    public static void transDecimal(ColumnMetadata column, ResultSet columns) throws SQLException {
        if (column.binding != null && BigDecimal.class.isAssignableFrom(column.binding)) {
            int columnSize;
            int decimalDigits = columns.getInt("DECIMAL_DIGITS");
            column.binding = decimalDigits == 0 ? ((columnSize = columns.getInt("COLUMN_SIZE")) == 0 ? Long.class : (columnSize > 32 ? Long.class : Integer.class)) : ((columnSize = columns.getInt("COLUMN_SIZE")) == 0 ? Double.class : (columnSize > 32 ? Double.class : Float.class));
        }
    }

    public static JDBCDataStore getSQLDialectDataStore(SQLDialect sqlDialect) {
        return sqlDialect.dataStore;
    }

    public static Logger getSQLDialectLogger(SQLDialect sqlDialect) {
        return SQLDialect.LOGGER;
    }

    public static AttributeRange getRange(JDBCDataStore jdbcDataStore, SimpleFeatureType sft, String attributeName, Query query) {
        return GeoToolsJdbcRangeUtils.getRange(jdbcDataStore, sft, attributeName, query);
    }

    public static void createSpatialIndex(JDBCDataStore jdbcDataStore, String schemaName, SimpleFeatureType sft) {
        JdbcOp service = GeoToolsJdbcProxyUtils.getJdbcOp(jdbcDataStore.dialect);
        Connection cx = jdbcDataStore.createConnection();
        try {
            if (service != null) {
                service.createSpatialIndex(schemaName, sft, cx);
            }
        }
        catch (SQLException ioException) {
            String message = "\u6267\u884csql\u8fc7\u7a0b\u4e2d\u53d1\u751fio\u5f02\u5e38:" + ExceptionUtils.getRootCauseMessage((Throwable)ioException);
            jdbcDataStore.getLogger().log(Level.SEVERE, message, ioException);
            throw new IoException("\u6267\u884csql\u8fc7\u7a0b\u4e2d\u53d1\u751fio\u5f02\u5e38:" + message, Thread.currentThread(), 3);
        }
        finally {
            jdbcDataStore.closeSafe(cx);
        }
    }

    public static AttributeRange getPkRange(JDBCDataStore jdbcDataStore, SimpleFeatureType sft, Query query) throws IOException {
        PrimaryKey primaryKey = jdbcDataStore.getPrimaryKey(sft);
        List pkc = primaryKey.getColumns();
        if (pkc.size() == 0) {
            throw new NotFoundException("\u6ca1\u6709\u627e\u5230\u4e3b\u952e!", Thread.currentThread(), 3);
        }
        if (pkc.size() > 1) {
            List pkNames = pkc.stream().map(PrimaryKeyColumn::getName).distinct().collect(Collectors.toList());
            if (pkNames.size() == 1) {
                throw new NotMatchException("\u53d1\u73b0\u591a\u4e8e1\u4e2a\u4e3b\u952e\u5217\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6307\u5b9a\u6570\u636eschema!", Thread.currentThread(), 3);
            }
            throw new NotMatchException("\u53d1\u73b0\u591a\u4e8e1\u4e2a\u4e3b\u952e\u5217" + CollectionUtilsForJ.join((Collection)pkc, PrimaryKeyColumn::getName, (String)",") + "\uff0c\u5fc5\u987b\u6307\u5b9a\u552f\u4e00\u5217\u8fdb\u884c\u8303\u56f4\u8ba1\u7b97!", Thread.currentThread(), 3);
        }
        if (!(Integer.class.isAssignableFrom(((PrimaryKeyColumn)pkc.get(0)).getType()) || Long.class.isAssignableFrom(((PrimaryKeyColumn)pkc.get(0)).getType()) || Short.class.isAssignableFrom(((PrimaryKeyColumn)pkc.get(0)).getType()) || Double.class.isAssignableFrom(((PrimaryKeyColumn)pkc.get(0)).getType()) || BigDecimal.class.isAssignableFrom(((PrimaryKeyColumn)pkc.get(0)).getType()) || Date.class.isAssignableFrom(((PrimaryKeyColumn)pkc.get(0)).getType()) || java.sql.Date.class.isAssignableFrom(((PrimaryKeyColumn)pkc.get(0)).getType()))) {
            throw new NotMatchException("\u8f93\u5165\u7684\u4e3b\u952e\u7c7b\u578b\u4e0d\u5339\u914d, \u4e0d\u652f\u6301\u7684\u4e3b\u952e\u7c7b\u578b:" + ((PrimaryKeyColumn)pkc.get(0)).getType().getSimpleName(), Thread.currentThread(), 3);
        }
        AttributeRange attributeRange = GeoToolsJdbcProxyUtils.getRange(jdbcDataStore, sft, ((PrimaryKeyColumn)pkc.get((int)0)).name, query);
        attributeRange.setMax(Long.valueOf(attributeRange.getMax().toString()));
        attributeRange.setMin(Long.valueOf(attributeRange.getMin().toString()));
        return attributeRange;
    }

    public static ReferencedEnvelope getBounds(JDBCDataStore jdbcDataStore, SimpleFeatureType sft, Query query) {
        Connection cx = jdbcDataStore.createConnection();
        try {
            ReferencedEnvelope referencedEnvelope = GeoToolsJdbcProxyUtils.getJdbcBounds(jdbcDataStore, sft, query, cx);
            return referencedEnvelope;
        }
        catch (IOException ioException) {
            String message = "\u6267\u884csql\u8fc7\u7a0b\u4e2d\u53d1\u751fio\u5f02\u5e38:" + ExceptionUtils.getRootCauseMessage((Throwable)ioException);
            jdbcDataStore.getLogger().log(Level.SEVERE, message, ioException);
            throw new IoException("\u6267\u884csql\u8fc7\u7a0b\u4e2d\u53d1\u751fio\u5f02\u5e38:" + message, Thread.currentThread(), 3);
        }
        finally {
            jdbcDataStore.closeSafe(cx);
        }
    }

    public static ReferencedEnvelope getJdbcBounds(JDBCDataStore jdbcDataStore, SimpleFeatureType featureType, Query query, Connection cx) throws IOException {
        int defaultGeoIndex;
        ReferencedEnvelope bounds;
        ResultSet rs;
        Statement st;
        SQLDialect dialect;
        block10: {
            JdbcOp jdbcOp;
            ReferencedEnvelope result;
            if (featureType.getGeometryDescriptor() == null) {
                return JDBCDataStore.EMPTY_ENVELOPE;
            }
            dialect = jdbcDataStore.getSQLDialect();
            st = null;
            rs = null;
            bounds = ReferencedEnvelope.create((CoordinateReferenceSystem)featureType.getCoordinateReferenceSystem());
            defaultGeoIndex = featureType.getAttributeDescriptors().stream().filter(ad -> ad instanceof GeometryDescriptor).collect(Collectors.toList()).indexOf(featureType.getGeometryDescriptor());
            if (!GeoToolsJdbcProxyUtils.isFullBoundsQuery(query, featureType) || (result = (jdbcOp = GeoToolsJdbcProxyUtils.getJdbcOp(jdbcDataStore.getSQLDialect())).getOptimizedBounds(jdbcDataStore, jdbcDataStore.getDatabaseSchema(), featureType, cx)) == null || result.isEmpty()) break block10;
            ReferencedEnvelope referencedEnvelope = bounds = result;
            jdbcDataStore.closeSafe(rs);
            jdbcDataStore.closeSafe(st);
            return referencedEnvelope;
        }
        try {
            if (dialect instanceof PreparedStatementSQLDialect) {
                st = jdbcDataStore.selectBoundsSQLPS(featureType, query, cx);
                rs = st.executeQuery();
            } else {
                String sql = jdbcDataStore.selectBoundsSQL(featureType, query);
                jdbcDataStore.getLogger().log(Level.INFO, "Retrieving bounding box: {0}", sql);
                st = cx.createStatement();
                rs = st.executeQuery(sql);
            }
            SingleCRS flatCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)featureType.getCoordinateReferenceSystem());
            int columns = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                int i = defaultGeoIndex + 1;
                Envelope envelope = dialect.decodeGeometryEnvelope(rs, i, st.getConnection());
                if (envelope == null) continue;
                if (envelope instanceof ReferencedEnvelope) {
                    bounds = jdbcDataStore.mergeEnvelope(bounds, (ReferencedEnvelope)envelope);
                    continue;
                }
                bounds = jdbcDataStore.mergeEnvelope(bounds, new ReferencedEnvelope(envelope, (CoordinateReferenceSystem)flatCRS));
            }
        }
        catch (Exception e) {
            try {
                String msg = "Error occured calculating bounds for " + featureType.getTypeName();
                throw (IOException)new IOException(msg).initCause(e);
            }
            catch (Throwable throwable) {
                jdbcDataStore.closeSafe(rs);
                jdbcDataStore.closeSafe(st);
                throw throwable;
            }
        }
        jdbcDataStore.closeSafe(rs);
        jdbcDataStore.closeSafe(st);
        return bounds;
    }

    private static boolean isFullBoundsQuery(Query query, SimpleFeatureType schema) {
        if (query == null) {
            return true;
        }
        if (!query.isMaxFeaturesUnlimited()) {
            return false;
        }
        if (query.getStartIndex() != null && query.getStartIndex() > 0) {
            return false;
        }
        if (!Filter.INCLUDE.equals(query.getFilter())) {
            return false;
        }
        if (query.getProperties() == Query.ALL_PROPERTIES) {
            return true;
        }
        List<String> names = Arrays.asList(query.getPropertyNames());
        for (AttributeDescriptor ad : schema.getAttributeDescriptors()) {
            if (!(ad instanceof GeometryDescriptor) || names.contains(ad.getLocalName())) continue;
            return false;
        }
        return true;
    }

    public static JdbcOp getJdbcOp(SQLDialect sqlDialect) {
        for (JdbcOp candidateService : ServiceLoader.load(JdbcOp.class)) {
            if (!candidateService.load(sqlDialect)) continue;
            return candidateService;
        }
        return null;
    }

    public static JdbcOp getJdbcOp(JDBCDataStoreFactory jdbcDataStoreFactory) {
        for (JdbcOp candidateService : ServiceLoader.load(JdbcOp.class)) {
            if (!candidateService.isFactory(jdbcDataStoreFactory)) continue;
            return candidateService;
        }
        return null;
    }

    private static void postCreateTable(SQLDialect sqlDialect, String dbSchema, SimpleFeatureType sft, Connection cx, boolean isCreateSpatialIndex) throws IOException, SQLException {
        JdbcOp service = GeoToolsJdbcProxyUtils.getJdbcOp(sqlDialect);
        if (service == null) {
            sqlDialect.postCreateTable(dbSchema, sft, cx);
        } else if (isCreateSpatialIndex) {
            service.postCreateTable(dbSchema, sft, cx);
        } else {
            service.createNoSpatialIndexTable(dbSchema, sft, cx);
        }
    }

    private static String createTableSQL(JDBCDataStore jdbcDataStore, SimpleFeatureType featureType, Connection cx) throws Exception {
        String[] columnNames = new String[featureType.getAttributeCount()];
        Class[] classes = new Class[featureType.getAttributeCount()];
        boolean[] nillable = new boolean[featureType.getAttributeCount()];
        for (int i = 0; i < featureType.getAttributeCount(); ++i) {
            AttributeDescriptor attributeType = featureType.getDescriptor(i);
            columnNames[i] = attributeType.getLocalName();
            classes[i] = attributeType.getType().getBinding();
            nillable[i] = attributeType.getMinOccurs() <= 0 || attributeType.isNillable();
        }
        String[] sqlTypeNames = GeoToolsJdbcProxyUtils.getSQLTypeNames(jdbcDataStore, featureType.getAttributeDescriptors(), cx);
        for (int i = 0; i < sqlTypeNames.length; ++i) {
            if (sqlTypeNames[i] != null) continue;
            String msg = "Unable to map " + columnNames[i] + "( " + classes[i].getName() + ")";
            throw new RuntimeException(msg);
        }
        return GeoToolsJdbcProxyUtils.createTableSQL(jdbcDataStore, featureType.getTypeName(), columnNames, sqlTypeNames, nillable, GeoToolsJdbcProxyUtils.findPrimaryKeyColumnName(featureType), featureType);
    }

    private static String createTableSQL(JDBCDataStore jdbcDataStore, String tableName, String[] columnNames, String[] sqlTypeNames, boolean[] nillable, PkeyAttr pkeyColumn, SimpleFeatureType featureType) throws SQLException {
        StringBuffer sql = new StringBuffer();
        jdbcDataStore.dialect.encodeCreateTable(sql);
        jdbcDataStore.encodeTableName(tableName, sql, null);
        sql.append(" ( ");
        if (pkeyColumn.getAutoGenerate().booleanValue()) {
            try {
                if (Class.forName("org.geotools.data.oracle.OracleDialect").isAssignableFrom(jdbcDataStore.dialect.getClass())) {
                    throw new NotSupportException("\u4e0d\u652f\u6301\u8bbe\u7f6e\u81ea\u589e\u4e3b\u952e!", Thread.currentThread(), 3);
                }
                jdbcDataStore.dialect.encodePrimaryKey(pkeyColumn.getColumnName(), sql);
            }
            catch (ClassNotFoundException e) {
                throw new NotFoundException("\u4e0d\u80fd\u627e\u5230oracle\u7684\u65b9\u8a00\u5b9e\u4f8b!", Thread.currentThread(), 3);
            }
            sql.append(", ");
        }
        for (int i = 0; i < columnNames.length; ++i) {
            AttributeDescriptor att;
            jdbcDataStore.dialect.encodeColumnName(null, columnNames[i], sql);
            sql.append(" ");
            int length = -1;
            if (sqlTypeNames[i].toUpperCase().startsWith("VARCHAR") && featureType != null && (Integer.MAX_VALUE == (length = GeoToolsJdbcProxyUtils.findVarcharColumnLength(jdbcDataStore, att = featureType.getDescriptor(columnNames[i])).intValue()) || length >= 10000000)) {
                sqlTypeNames[i] = "TEXT";
                length = -1;
            }
            if (length == -1) {
                jdbcDataStore.dialect.encodeColumnType(sqlTypeNames[i], sql);
            } else {
                jdbcDataStore.dialect.encodeColumnType(sqlTypeNames[i] + "(" + length + ")", sql);
            }
            if (!pkeyColumn.getAutoGenerate().booleanValue() && pkeyColumn.getColumnName().equals(columnNames[i])) {
                sql.append(" PRIMARY KEY ");
            }
            if (nillable != null && !nillable[i]) {
                sql.append(" NOT NULL ");
            }
            if (featureType != null) {
                att = featureType.getDescriptor(columnNames[i]);
                jdbcDataStore.dialect.encodePostColumnCreateTable(att, sql);
            }
            if (i >= sqlTypeNames.length - 1) continue;
            sql.append(", ");
        }
        sql.append(" ) ");
        jdbcDataStore.dialect.encodePostCreateTable(tableName, sql);
        return sql.toString();
    }

    private static Integer findVarcharColumnLength(JDBCDataStore jdbcDataStore, AttributeDescriptor att) {
        for (Filter r : att.getType().getRestrictions()) {
            Integer length;
            PropertyIsLessThanOrEqualTo c;
            if (!(r instanceof PropertyIsLessThanOrEqualTo) || !((c = (PropertyIsLessThanOrEqualTo)r).getExpression1() instanceof Function) || !((Function)c.getExpression1()).getName().toLowerCase().endsWith("length") || !(c.getExpression2() instanceof Literal) || (length = (Integer)c.getExpression2().evaluate(null, Integer.class)) == null) continue;
            return length;
        }
        return jdbcDataStore.dialect.getDefaultVarcharSize();
    }

    private static PkeyAttr findPrimaryKeyColumnName(SimpleFeatureType featureType) {
        PkeyAttr pkeyAttr = new PkeyAttr();
        ArrayList<String> adNames = new ArrayList<String>();
        for (AttributeDescriptor ad : featureType.getAttributeDescriptors()) {
            if (ad.getUserData().containsKey("pk.column") && Boolean.parseBoolean(ad.getUserData().get("pk.column").toString())) {
                pkeyAttr.setColumnName(ad.getLocalName());
                pkeyAttr.setAutoGenerate(false);
                return pkeyAttr;
            }
            adNames.add(ad.getLocalName());
        }
        String pkColumn = "fid";
        if (featureType.getUserData().containsKey("pk.name")) {
            pkColumn = featureType.getUserData().get("pk.name").toString();
        }
        String pkInitColumn = pkColumn;
        int suffix = 0;
        while (adNames.contains(pkColumn)) {
            pkColumn = pkInitColumn + "_" + ++suffix;
        }
        pkeyAttr.setColumnName(pkColumn);
        pkeyAttr.setAutoGenerate(true);
        return pkeyAttr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getSQLTypeNames(JDBCDataStore jdbcDataStore, List<AttributeDescriptor> descriptors, Connection cx) throws SQLException {
        boolean allTypesFound;
        String sqlTypeName;
        int[] sqlTypes = new int[descriptors.size()];
        Object[] sqlTypeNames = new String[sqlTypes.length];
        for (int i = 0; i < descriptors.size(); ++i) {
            String sqlTypeDBName;
            AttributeDescriptor ad = descriptors.get(i);
            Class clazz = ad.getType().getBinding();
            Integer sqlType = jdbcDataStore.dialect.getSQLType(ad);
            if (sqlType == null) {
                sqlType = jdbcDataStore.getMapping(clazz);
            }
            if (sqlType == null) {
                jdbcDataStore.getLogger().warning("No sql type mapping for: " + ad.getLocalName() + " of type " + clazz);
                sqlType = 1111;
            }
            sqlTypes[i] = sqlType;
            if (Geometry.class.isAssignableFrom(clazz) && (sqlTypeName = jdbcDataStore.dialect.getGeometryTypeName(sqlType)) != null) {
                sqlTypeNames[i] = sqlTypeName;
            }
            if ((sqlTypeDBName = (String)jdbcDataStore.getDBsqlTypesCache().get(sqlType)) == null) continue;
            sqlTypeNames[i] = sqlTypeDBName;
        }
        boolean bl = allTypesFound = !ArrayUtils.contains((Object[])sqlTypeNames, null);
        if (!allTypesFound) {
            jdbcDataStore.getLogger().log(Level.WARNING, "Fetching fields from Database");
            DatabaseMetaData metaData = cx.getMetaData();
            ResultSet types = metaData.getTypeInfo();
            try {
                while (types.next()) {
                    int sqlType = types.getInt("DATA_TYPE");
                    sqlTypeName = types.getString("TYPE_NAME");
                    for (int i = 0; i < sqlTypes.length; ++i) {
                        if (sqlTypeNames[i] != null || sqlType != sqlTypes[i]) continue;
                        sqlTypeNames[i] = sqlTypeName;
                        jdbcDataStore.getDBsqlTypesCache().putIfAbsent(sqlType, sqlTypeName);
                    }
                }
            }
            finally {
                jdbcDataStore.closeSafe(types);
            }
        }
        Map overrides = jdbcDataStore.getSqlTypeToSqlTypeNameOverrides();
        for (int i = 0; i < sqlTypes.length; ++i) {
            String override = (String)overrides.get(sqlTypes[i]);
            if (override == null) continue;
            sqlTypeNames[i] = override;
        }
        return sqlTypeNames;
    }

    public static FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(JDBCFeatureStore featureStore, Query query, int flags, Connection cx) throws IOException {
        Object writer;
        Filter postFilter;
        if (flags == 0) {
            throw new IllegalArgumentException("no write flags set");
        }
        try {
            if ((flags | 1) == 1) {
                Query queryNone = new Query(query);
                queryNone.setFilter((Filter)Filter.EXCLUDE);
                if (featureStore.getDataStore().getSQLDialect() instanceof PreparedStatementSQLDialect) {
                    PreparedStatement ps = featureStore.getDataStore().selectSQLPS(featureStore.getSchema(), queryNone, cx);
                    return new AJDBCInsertFeatureWriter(ps, cx, featureStore.delegate, query);
                }
                String sql = featureStore.getDataStore().selectSQL(featureStore.getSchema(), queryNone);
                featureStore.getDataStore().getLogger().info(sql);
                return new AJDBCInsertFeatureWriter(sql, cx, featureStore.delegate, query);
            }
            Filter[] split = featureStore.delegate.splitFilter(query.getFilter());
            Filter preFilter = split[0];
            postFilter = split[1];
            Query preQuery = new Query(query);
            preQuery.setFilter(preFilter);
            if (featureStore.getDataStore().getSQLDialect() instanceof PreparedStatementSQLDialect) {
                PreparedStatement ps = featureStore.getDataStore().selectSQLPS(featureStore.getSchema(), preQuery, cx);
                writer = (flags | 2) == 2 ? new JDBCUpdateFeatureWriter(ps, cx, featureStore.delegate, query) : new AJDBCUpdateInsertFeatureWriter(ps, cx, featureStore.delegate, query.getPropertyNames(), query);
            } else {
                String sql = featureStore.getDataStore().selectSQL(featureStore.getSchema(), preQuery);
                featureStore.getDataStore().getLogger().info(sql);
                writer = (flags | 2) == 2 ? new JDBCUpdateFeatureWriter(sql, cx, featureStore.delegate, query) : new AJDBCUpdateInsertFeatureWriter(sql, cx, featureStore.delegate, query);
            }
        }
        catch (Throwable e) {
            featureStore.getDataStore().closeSafe(cx);
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw (IOException)new IOException().initCause(e);
        }
        if (postFilter != null && postFilter != Filter.INCLUDE) {
            writer = new FilteringFeatureWriter((FeatureWriter)writer, postFilter);
        }
        return writer;
    }

    public static FeatureWriter<SimpleFeatureType, SimpleFeature> getWriterInternal(JDBCFeatureStore featureStore, Query query, int flags) throws IOException {
        if (flags == 0) {
            throw new IllegalArgumentException("no write flags set");
        }
        Connection cx = featureStore.getDataStore().getConnection(featureStore.getState());
        return GeoToolsJdbcProxyUtils.getWriterInternal(featureStore, query, flags, cx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean insert(JDBCDataStore jdbcDataStore, Collection<? extends SimpleFeature> features, SimpleFeatureType featureType, Connection cx) throws IOException {
        PrimaryKey key = jdbcDataStore.getPrimaryKey(featureType);
        boolean result = true;
        JDBCDataStore jDBCDataStore = jdbcDataStore;
        synchronized (jDBCDataStore) {
            try {
                if (jdbcDataStore.dialect instanceof PreparedStatementSQLDialect) {
                    Map kinds = InsertionClassifier.classify((SimpleFeatureType)featureType, features);
                    for (InsertionClassifier kind : kinds.keySet()) {
                        GeoToolsJdbcProxyUtils.insertPS(jdbcDataStore, (Collection)kinds.get(kind), kind, featureType, cx, key);
                    }
                    result = false;
                } else {
                    ArrayList<SimpleFeature> useExistings = new ArrayList<SimpleFeature>();
                    ArrayList notUseExistings = new ArrayList();
                    for (SimpleFeature simpleFeature : features) {
                        (InsertionClassifier.useExisting((SimpleFeature)simpleFeature) ? useExistings : notUseExistings).add(simpleFeature);
                    }
                    GeoToolsJdbcProxyUtils.insertNonPS(jdbcDataStore, useExistings, featureType, cx, key, true);
                    GeoToolsJdbcProxyUtils.insertNonPS(jdbcDataStore, notUseExistings, featureType, cx, key, false);
                    result = false;
                }
            }
            catch (SQLException e) {
                String msg = "Error inserting features";
                throw (IOException)new IOException(msg).initCause(e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertNonPS(JDBCDataStore jdbcDataStore, Collection<? extends SimpleFeature> features, SimpleFeatureType featureType, Connection cx, PrimaryKey key, boolean useExisting) throws IOException, SQLException {
        if (features.isEmpty()) {
            return;
        }
        Statement st = cx.createStatement();
        NonIncrementFetcher keysFetcher = key.getColumns().stream().allMatch(primaryKeyColumn -> primaryKeyColumn instanceof NonIncrementingPrimaryKeyColumn) ? NonIncrementFetcher.getInstance(jdbcDataStore.dialect, key) : KeysFetcher.create((JDBCDataStore)jdbcDataStore, (Connection)cx, (boolean)useExisting, (PrimaryKey)key);
        try {
            String sql = GeoToolsJdbcProxyUtils.insertSQLs(jdbcDataStore, featureType, features, keysFetcher, cx);
            ((BasicSQLDialect)jdbcDataStore.dialect).onInsert(st, cx, featureType);
            st.executeUpdate(sql);
        }
        finally {
            jdbcDataStore.closeSafe(st);
        }
    }

    private static String insertSQLs(JDBCDataStore jdbcDataStore, SimpleFeatureType featureType, Collection<? extends SimpleFeature> features, KeysFetcher keysFetcher, Connection cx) throws SQLException, IOException {
        BasicSQLDialect dialect = (BasicSQLDialect)jdbcDataStore.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        jdbcDataStore.encodeTableName(featureType.getTypeName(), sql, null);
        sql.append(" ( ");
        for (int i = 0; i < featureType.getAttributeCount(); ++i) {
            String string = featureType.getDescriptor(i).getLocalName();
            if (keysFetcher.isKey(string)) continue;
            dialect.encodeColumnName(null, string, sql);
            sql.append(",");
        }
        keysFetcher.addKeyColumns(sql);
        sql.setLength(sql.length() - 1);
        sql.append(" ) VALUES");
        for (SimpleFeature simpleFeature : features) {
            sql.append(" ( ");
            for (int i = 0; i < featureType.getAttributeCount(); ++i) {
                AttributeDescriptor att = featureType.getDescriptor(i);
                String colName = att.getLocalName();
                if (keysFetcher.isKey(colName)) continue;
                Class<Integer> binding = att.getType().getBinding();
                EnumMapper mapper = (EnumMapper)att.getUserData().get("org.geotools.jdbc.enumMap");
                Object value = simpleFeature.getAttribute(colName);
                if (value == null) {
                    if (!att.isNillable()) {
                        throw new IOException("Cannot set a NULL value on the not null column " + colName);
                    }
                    sql.append("null");
                } else if (Geometry.class.isAssignableFrom(binding)) {
                    try {
                        Geometry g = (Geometry)value;
                        int srid = jdbcDataStore.getGeometrySRID(g, att);
                        int dimension = jdbcDataStore.getGeometryDimension(g, att);
                        dialect.encodeGeometryValue(g, dimension, srid, sql);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } else {
                    if (mapper != null) {
                        value = mapper.fromString((String)value);
                        binding = Integer.class;
                    }
                    dialect.encodeValue(value, (Class)binding, sql);
                }
                sql.append(",");
            }
            keysFetcher.setKeyValues(jdbcDataStore, cx, featureType, simpleFeature, sql);
            sql.setLength(sql.length() - 1);
            sql.append("),");
        }
        sql.setLength(sql.length() - 1);
        return sql.toString();
    }

    private static String insertSQL(JDBCDataStore jdbcDataStore, SimpleFeatureType featureType, SimpleFeature feature, KeysFetcher keysFetcher, Connection cx) throws SQLException, IOException {
        int i;
        BasicSQLDialect dialect = (BasicSQLDialect)jdbcDataStore.getSQLDialect();
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        jdbcDataStore.encodeTableName(featureType.getTypeName(), sql, null);
        sql.append(" ( ");
        for (i = 0; i < featureType.getAttributeCount(); ++i) {
            String colName = featureType.getDescriptor(i).getLocalName();
            if (keysFetcher.isKey(colName)) continue;
            dialect.encodeColumnName(null, colName, sql);
            sql.append(",");
        }
        keysFetcher.addKeyColumns(sql);
        sql.setLength(sql.length() - 1);
        sql.append(" ) VALUES ( ");
        for (i = 0; i < featureType.getAttributeCount(); ++i) {
            AttributeDescriptor att = featureType.getDescriptor(i);
            String colName = att.getLocalName();
            if (keysFetcher.isKey(colName)) continue;
            Class<Integer> binding = att.getType().getBinding();
            EnumMapper mapper = (EnumMapper)att.getUserData().get("org.geotools.jdbc.enumMap");
            Object value = feature.getAttribute(colName);
            if (value == null) {
                if (!att.isNillable()) {
                    throw new IOException("Cannot set a NULL value on the not null column " + colName);
                }
                sql.append("null");
            } else if (Geometry.class.isAssignableFrom(binding)) {
                try {
                    Geometry g = (Geometry)value;
                    int srid = jdbcDataStore.getGeometrySRID(g, att);
                    int dimension = jdbcDataStore.getGeometryDimension(g, att);
                    dialect.encodeGeometryValue(g, dimension, srid, sql);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                if (mapper != null) {
                    value = mapper.fromString((String)value);
                    binding = Integer.class;
                }
                dialect.encodeValue(value, (Class)binding, sql);
            }
            sql.append(",");
        }
        keysFetcher.setKeyValues(jdbcDataStore, cx, featureType, feature, sql);
        sql.setLength(sql.length() - 1);
        sql.append(")");
        return sql.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void insertPS(JDBCDataStore jdbcDataStore, Collection<SimpleFeature> features, InsertionClassifier kind, SimpleFeatureType featureType, Connection cx, PrimaryKey key) throws IOException, SQLException {
        PreparedStatementSQLDialect dialect = (PreparedStatementSQLDialect)jdbcDataStore.getSQLDialect();
        NonIncrementFetcher keysFetcher = key.getColumns().stream().allMatch(primaryKeyColumn -> primaryKeyColumn instanceof NonIncrementingPrimaryKeyColumn) ? NonIncrementFetcher.getInstance(jdbcDataStore.dialect, key) : KeysFetcher.create((JDBCDataStore)jdbcDataStore, (Connection)cx, (boolean)kind.useExisting, (PrimaryKey)key);
        String sql = GeoToolsJdbcProxyUtils.buildInsertPS(jdbcDataStore, kind, featureType, keysFetcher, dialect);
        jdbcDataStore.getLogger().log(Level.INFO, "Inserting new features with ps: {0}", sql);
        PreparedStatement ps = keysFetcher.isPostInsert() ? cx.prepareStatement(sql, keysFetcher.getColumnNames()) : cx.prepareStatement(sql);
        try {
            for (SimpleFeature feature : features) {
                int i = 1;
                for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
                    String colName = att.getLocalName();
                    if (keysFetcher.isKey(colName)) continue;
                    Class<Integer> binding = att.getType().getBinding();
                    EnumMapper mapper = (EnumMapper)att.getUserData().get("org.geotools.jdbc.enumMap");
                    Object value = feature.getAttribute(colName);
                    if (value == null && !att.isNillable()) {
                        throw new IOException("Cannot set a NULL value on the not null column " + colName);
                    }
                    if (Geometry.class.isAssignableFrom(binding)) {
                        Geometry g = (Geometry)value;
                        int srid = jdbcDataStore.getGeometrySRID(g, att);
                        int dimension = jdbcDataStore.getGeometryDimension(g, att);
                        dialect.setGeometryValue(g, dimension, srid, binding, ps, i);
                    } else if (jdbcDataStore.dialect.isArray(att)) {
                        dialect.setArrayValue(value, att, ps, i, cx);
                    } else {
                        if (mapper != null) {
                            value = mapper.fromString((String)value);
                            binding = Integer.class;
                        }
                        dialect.setValue(value, binding, ps, i, cx);
                    }
                    ++i;
                }
                keysFetcher.setKeyValues(dialect, ps, cx, featureType, feature, i);
                dialect.onInsert(ps, cx, featureType);
                ps.addBatch();
            }
            int[] inserts = ps.executeBatch();
            JDBCDataStore.checkAllInserted((int[])inserts, (int)features.size());
        }
        finally {
            jdbcDataStore.closeSafe((Statement)ps);
        }
    }

    private static String buildInsertPS(JDBCDataStore jdbcDataStore, InsertionClassifier kind, SimpleFeatureType featureType, KeysFetcher keysFetcher, PreparedStatementSQLDialect dialect) throws SQLException {
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO ");
        jdbcDataStore.encodeTableName(featureType.getTypeName(), sql, null);
        sql.append(" ( ");
        for (int i = 0; i < featureType.getAttributeCount(); ++i) {
            String colName = featureType.getDescriptor(i).getLocalName();
            if (keysFetcher.isKey(colName)) continue;
            dialect.encodeColumnName(null, colName, sql);
            sql.append(",");
        }
        keysFetcher.addKeyColumns(sql);
        sql.setLength(sql.length() - 1);
        sql.append(" ) VALUES ( ");
        for (AttributeDescriptor att : featureType.getAttributeDescriptors()) {
            String colName = att.getLocalName();
            if (keysFetcher.isKey(colName)) continue;
            if (att instanceof GeometryDescriptor) {
                Class geometryClass = (Class)kind.geometryTypes.get(att.getName().getLocalPart());
                dialect.prepareGeometryValue(geometryClass, jdbcDataStore.getDescriptorDimension(att), jdbcDataStore.getDescriptorSRID(att), att.getType().getBinding(), sql);
            } else {
                sql.append("?");
            }
            sql.append(",");
        }
        keysFetcher.addKeyBindings(sql);
        sql.setLength(sql.length() - 1);
        sql.append(")");
        return sql.toString();
    }
}

