/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.geotools.jdbc.KeysFetcher;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyColumn;
import org.geotools.jdbc.SQLDialect;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class NonIncrementFetcher
extends KeysFetcher {
    private final String keyColumnNames;

    public static NonIncrementFetcher getInstance(SQLDialect dialect, PrimaryKey key) {
        return new NonIncrementFetcher(dialect, key);
    }

    protected NonIncrementFetcher(SQLDialect dialect, PrimaryKey key) {
        super(key);
        StringBuffer keyColumnNames = new StringBuffer();
        for (PrimaryKeyColumn col : key.getColumns()) {
            dialect.encodeColumnName(null, col.getName(), keyColumnNames);
            keyColumnNames.append(",");
        }
        this.keyColumnNames = keyColumnNames.toString();
    }

    public void addKeyColumns(StringBuffer sql) {
        sql.append(this.keyColumnNames);
    }

    public void addKeyBindings(StringBuffer sql) {
        for (int i = 0; i < this.key.getColumns().size(); ++i) {
            sql.append("?,");
        }
    }

    public void postInsert(SimpleFeatureType featureType, Collection<SimpleFeature> features, PreparedStatement ps) throws SQLException {
    }

    public void postInsert(SimpleFeatureType featureType, SimpleFeature feature, Connection cx, Statement st) throws SQLException {
    }

    public boolean isPostInsert() {
        return false;
    }

    protected List<Object> getNextValues(Connection cx, SimpleFeature feature) throws IOException, SQLException {
        return this.key.getColumns().stream().map(primaryKeyColumn -> feature.getAttribute(primaryKeyColumn.getName())).collect(Collectors.toList());
    }
}

