/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc.impl;

import java.sql.Connection;
import java.sql.SQLException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.JdbcOp;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJdbcOp
implements JdbcOp {
    public final Logger logger = LoggerFactory.getLogger(JdbcOp.class);

    @Override
    public CoordinateReferenceSystem createCRS(int srid, Connection cx) throws SQLException {
        try {
            return CRS.decode((String)("EPSG:" + srid), (boolean)true);
        }
        catch (Exception e) {
            this.logger.warn("Could not decode " + srid + " using the built-in EPSG database");
            return null;
        }
    }

    @Override
    public ReferencedEnvelope getOptimizedBounds(JDBCDataStore jdbcDataStore, String dbSchema, SimpleFeatureType featureType, Connection cx) {
        return null;
    }
}

