/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.common.crs;

import com.geoway.atlas.common.cache.AtlasCache;
import com.geoway.atlas.common.cache.AtlasCache$;
import com.geoway.atlas.common.error.NotFoundException;
import com.geoway.atlas.common.error.NotFoundException$;
import com.geoway.atlas.common.error.NullException;
import com.geoway.atlas.common.error.NullException$;
import com.geoway.atlas.data.vector.common.crs.package;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.geotools.referencing.CRS;
import org.geotools.referencing.NamedIdentifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class package$ {
    public static package$ MODULE$;
    private Logger logger;
    private final AtlasCache<String, Object> WKT_TO_SRID_CACHE;
    private final String lock;
    private final AtlasCache<CoordinateReferenceSystem, Object> FIND_SRID_CACHE;
    private final AtlasCache<String, CoordinateReferenceSystem> GET_CRS_WKT_CACHE;
    private final AtlasCache<Object, CoordinateReferenceSystem> GET_CRS_EPSG_CACHE;
    private volatile boolean bitmap$0;

    static {
        new package$();
    }

    private Logger logger$lzycompute() {
        package$ package$2 = this;
        synchronized (package$2) {
            if (!this.bitmap$0) {
                this.logger = LoggerFactory.getLogger(this.getClass());
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    private Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    private AtlasCache<String, Object> WKT_TO_SRID_CACHE() {
        return this.WKT_TO_SRID_CACHE;
    }

    private String lock() {
        return this.lock;
    }

    private AtlasCache<CoordinateReferenceSystem, Object> FIND_SRID_CACHE() {
        return this.FIND_SRID_CACHE;
    }

    private AtlasCache<String, CoordinateReferenceSystem> GET_CRS_WKT_CACHE() {
        return this.GET_CRS_WKT_CACHE;
    }

    private AtlasCache<Object, CoordinateReferenceSystem> GET_CRS_EPSG_CACHE() {
        return this.GET_CRS_EPSG_CACHE;
    }

    /*
     * WARNING - void declaration
     */
    public int FIND_SRID(CoordinateReferenceSystem crs) {
        int n;
        if (!this.FIND_SRID_CACHE().exist((Object)crs)) {
            void var2_2;
            int srid = this.findSrid(crs);
            this.FIND_SRID_CACHE().put((Object)crs, (Object)BoxesRunTime.boxToInteger((int)srid));
            n = var2_2;
        } else {
            n = BoxesRunTime.unboxToInt((Object)this.FIND_SRID_CACHE().apply((Object)crs, (Function1 & Serializable & scala.Serializable)k -> BoxesRunTime.boxToInteger((int)package$.MODULE$.findSrid(k))));
        }
        return n;
    }

    private int findSrid(CoordinateReferenceSystem crs) {
        int n;
        String string = this.lock();
        synchronized (string) {
            int n2;
            String result = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)false);
            if (StringUtils.isNotBlank((CharSequence)result)) {
                n2 = new StringOps(Predef$.MODULE$.augmentString(((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.split(":"))).last()).trim())).toInt();
            } else {
                result = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)true);
                if (StringUtils.isNotBlank((CharSequence)result)) {
                    n2 = new StringOps(Predef$.MODULE$.augmentString(((String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])result.split(":"))).last()).trim())).toInt();
                } else {
                    Set filterName = (Set)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(crs.getIdentifiers()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$findSrid$1(x$1)))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)package$.$anonfun$findSrid$2(x$2)));
                    if (filterName.size() != 1) {
                        this.logger().error("CrsPackage-findSrid: \u65e0\u6cd5\u901a\u8fc7\u6807\u8bc6\u83b7\u53d6srid!");
                        n2 = -1;
                    } else {
                        ReferenceIdentifier name = (ReferenceIdentifier)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filterName.toArray(ClassTag$.MODULE$.apply(ReferenceIdentifier.class)))).head();
                        n2 = package$.liftedTree1$1(name);
                    }
                }
            }
            n = n2;
        }
        return n;
    }

    public CoordinateReferenceSystem GET_CRS_WKT(String wkt) {
        CoordinateReferenceSystem coordinateReferenceSystem;
        if (!this.GET_CRS_WKT_CACHE().exist((Object)wkt)) {
            String string = this.lock();
            synchronized (string) {
                CoordinateReferenceSystem crs = CRS.parseWKT((String)this.replaceDatumName(wkt));
                this.GET_CRS_WKT_CACHE().put((Object)wkt, (Object)crs);
                CoordinateReferenceSystem coordinateReferenceSystem2 = crs;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl8 : MonitorExitStatement: MONITOREXIT : var2_2
                coordinateReferenceSystem = coordinateReferenceSystem2;
            }
        } else {
            coordinateReferenceSystem = (CoordinateReferenceSystem)this.GET_CRS_WKT_CACHE().apply((Object)wkt, (Function1 & Serializable & scala.Serializable)x$3 -> CRS.parseWKT((String)MODULE$.replaceDatumName(wkt)));
        }
        return coordinateReferenceSystem;
    }

    /*
     * WARNING - void declaration
     */
    public int WKT_TO_SRID(String wkt) {
        int n;
        if (!this.WKT_TO_SRID_CACHE().exist((Object)wkt)) {
            void var3_3;
            CoordinateReferenceSystem crs = this.GET_CRS_WKT(wkt);
            int srid = this.FIND_SRID(crs);
            n = var3_3;
        } else {
            n = BoxesRunTime.unboxToInt((Object)this.WKT_TO_SRID_CACHE().apply((Object)wkt, (Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)package$.MODULE$.FIND_SRID(package$.MODULE$.GET_CRS_WKT(wkt)))));
        }
        return n;
    }

    public CoordinateReferenceSystem GET_CRS_EPSG(int srid) {
        CoordinateReferenceSystem coordinateReferenceSystem;
        if (srid == -1) {
            String x$1 = "\u65e0\u6cd5\u627e\u5230epsg\u4e3a-1\u65f6\u5bf9\u5e94\u7684\u5750\u6807\u7cfb!";
            Thread x$2 = NotFoundException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotFoundException$.MODULE$.apply$default$3(x$1);
            throw new NotFoundException(x$1, x$2, x$3);
        }
        if (!this.GET_CRS_EPSG_CACHE().exist((Object)BoxesRunTime.boxToInteger((int)srid))) {
            String string = this.lock();
            synchronized (string) {
                CoordinateReferenceSystem crs = CRS.decode((String)new StringBuilder(5).append("EPSG:").append(srid).toString(), (boolean)true);
                this.GET_CRS_EPSG_CACHE().put((Object)BoxesRunTime.boxToInteger((int)srid), (Object)crs);
                CoordinateReferenceSystem coordinateReferenceSystem2 = crs;
                // MONITOREXIT @DISABLED, blocks:[0, 1, 4] lbl13 : MonitorExitStatement: MONITOREXIT : var5_5
                coordinateReferenceSystem = coordinateReferenceSystem2;
            }
        } else {
            coordinateReferenceSystem = (CoordinateReferenceSystem)this.GET_CRS_EPSG_CACHE().apply((Object)BoxesRunTime.boxToInteger((int)srid), (Function1 & Serializable & scala.Serializable)k -> package$.$anonfun$GET_CRS_EPSG$1(srid, BoxesRunTime.unboxToInt((Object)k)));
        }
        return coordinateReferenceSystem;
    }

    public CoordinateReferenceSystem SRID_WKT_TO_CRS(int srid, String wkt) {
        CoordinateReferenceSystem coordinateReferenceSystem;
        if (srid > 0) {
            coordinateReferenceSystem = this.GET_CRS_EPSG(srid);
        } else if (StringUtils.isNotEmpty((CharSequence)wkt)) {
            coordinateReferenceSystem = this.GET_CRS_WKT(wkt);
        } else {
            String x$1 = "\u672a\u53d1\u73b0\u53ef\u4ee5\u8bbe\u7f6e\u7684\u5750\u6807\u7cfb!";
            Thread x$2 = NotFoundException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotFoundException$.MODULE$.apply$default$3(x$1);
            throw new NotFoundException(x$1, x$2, x$3);
        }
        return coordinateReferenceSystem;
    }

    public MathTransform GET_THRANSFORM(CoordinateReferenceSystem sCrs, CoordinateReferenceSystem tCrs) {
        return CRS.findMathTransform((CoordinateReferenceSystem)sCrs, (CoordinateReferenceSystem)tCrs, (boolean)true);
    }

    private String replaceDatumName(String wktProj) {
        String datumName;
        if (StringUtils.isEmpty((CharSequence)wktProj)) {
            String x$1 = "\u8f93\u5165\u7684\u5750\u6807\u5b57\u7b26\u4e32\u4e3a\u7a7a!";
            Thread x$2 = NullException$.MODULE$.apply$default$2(x$1);
            int x$3 = NullException$.MODULE$.apply$default$3(x$1);
            throw new NullException(x$1, x$2, x$3);
        }
        String reg = "DATUM\\[\"(.*?)\"";
        Pattern pattern = Pattern.compile(reg);
        String result = wktProj;
        Matcher matcher = pattern.matcher(wktProj);
        if (matcher.find() && (datumName = matcher.group(1)).contains("CGCS")) {
            String newDatumName = datumName.replace("CGCS", "China");
            result = new StringBuilder(0).append(wktProj.substring(0, matcher.start(1))).append(newDatumName).append(wktProj.substring(matcher.end(1))).toString();
        }
        result = this.modifyCrsContent(result, "GEOGCS", "METADATA");
        result = this.modifyCrsContent(result, "PROJCS", "EXTENSION");
        return result;
    }

    private String modifyCrsContent(String projWkt, String findLabel, String removeSubLabel) {
        int beginSearchIndex = projWkt.indexOf(findLabel);
        if (beginSearchIndex != -1) {
            String searchBody = projWkt.substring(beginSearchIndex);
            int indexBracket = 0;
            int bracketCount = 0;
            boolean isContinue = true;
            for (int index$macro$1 = 0; index$macro$1 < searchBody.length() && isContinue; ++index$macro$1) {
                if (((Object)BoxesRunTime.boxToCharacter((char)'[')).equals(BoxesRunTime.boxToCharacter((char)searchBody.charAt(index$macro$1)))) {
                    ++bracketCount;
                    continue;
                }
                if (!((Object)BoxesRunTime.boxToCharacter((char)']')).equals(BoxesRunTime.boxToCharacter((char)StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(searchBody), index$macro$1))) || --bracketCount != 0) continue;
                indexBracket = index$macro$1;
                isContinue = false;
            }
            if (indexBracket != 0) {
                String substring = indexBracket != searchBody.length() - 1 ? searchBody.substring(0, indexBracket + 1) : searchBody;
                String reg = new StringBuilder(9).append(",*?").append(removeSubLabel).append("\\[.*?]").toString();
                Pattern pattern = Pattern.compile(reg);
                Matcher matcher = pattern.matcher(substring);
                if (matcher.find()) {
                    int startReplaceIndex = beginSearchIndex + matcher.start(0);
                    int endReplaceIndex = beginSearchIndex + matcher.end(0);
                    return new StringBuilder(0).append(projWkt.substring(0, startReplaceIndex)).append((Object)(endReplaceIndex == projWkt.length() - 1 ? "" : projWkt.substring(endReplaceIndex))).toString();
                }
            }
        }
        return projWkt;
    }

    public package.RichCRS RichCRS(CoordinateReferenceSystem crs) {
        return new package.RichCRS(crs);
    }

    public static final /* synthetic */ boolean $anonfun$findSrid$1(ReferenceIdentifier x$1) {
        return x$1 instanceof NamedIdentifier;
    }

    public static final /* synthetic */ boolean $anonfun$findSrid$2(ReferenceIdentifier x$2) {
        return x$2.getCodeSpace().equalsIgnoreCase("EPSG");
    }

    private static final /* synthetic */ int liftedTree1$1(ReferenceIdentifier name$1) {
        int n;
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(name$1.getCode())).toInt();
        }
        catch (Throwable throwable) {
            n = -1;
        }
        return n;
    }

    public static final /* synthetic */ CoordinateReferenceSystem $anonfun$GET_CRS_EPSG$1(int srid$1, int k) {
        return CRS.decode((String)new StringBuilder(5).append("EPSG:").append(srid$1).toString(), (boolean)true);
    }

    private package$() {
        MODULE$ = this;
        this.WKT_TO_SRID_CACHE = AtlasCache$.MODULE$.apply();
        this.lock = "lock";
        this.FIND_SRID_CACHE = AtlasCache$.MODULE$.apply();
        this.GET_CRS_WKT_CACHE = AtlasCache$.MODULE$.apply();
        this.GET_CRS_EPSG_CACHE = AtlasCache$.MODULE$.apply();
    }
}

