/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.common.feature.sft;

import com.geoway.atlas.common.error.NotSupportException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public enum GeometryType {
    UNKNOWN(0),
    POINT(1),
    POINTM(2001),
    POINTZM(3001),
    LINESTRING(2),
    LINESTRINGM(2002),
    LINESTRINGZM(3002),
    POLYGON(3),
    POLYGONM(2003),
    POLYGONZM(3003),
    MULTIPOINT(4),
    MULTIPOINTM(2004),
    MULTIPOINTZM(3004),
    MULTILINESTRING(5),
    MULTILINESTRINGM(2005),
    MULTILINESTRINGZM(3005),
    MULTIPOLYGON(6),
    MULTIPOLYGONM(2006),
    MULTIPOLYGONZM(3006),
    GEOMETRYCOLLECTION(7),
    GEOMETRYCOLLECTIONM(2007),
    GEOMETRYCOLLECTIONZM(3007);

    private int value = 0;
    private static final Map<Integer, GeometryType> GEOMETRY_DICT;

    private GeometryType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public static GeometryType from(byte iGeoType, byte zmFlag) {
        int baseType = 0;
        if (iGeoType == 4) {
            baseType = GeometryType.GEOMETRYCOLLECTION.value;
        } else if (iGeoType == 1) {
            baseType = GeometryType.POINT.value;
        } else if (iGeoType == 2) {
            baseType = GeometryType.LINESTRING.value;
        } else if (iGeoType == 3) {
            baseType = GeometryType.POLYGON.value;
        } else if (iGeoType == 17) {
            baseType = GeometryType.MULTIPOINT.value;
        } else if (iGeoType == 18) {
            baseType = GeometryType.MULTILINESTRING.value;
        } else if (iGeoType == 19) {
            baseType = GeometryType.MULTIPOLYGON.value;
        } else {
            throw new NotSupportException("\u4e0d\u652f\u6301\u7684\u56fe\u5c42\u7a7a\u95f4\u7c7b\u578b:" + iGeoType, Thread.currentThread(), 3);
        }
        if (zmFlag == 0) {
            return GEOMETRY_DICT.get(baseType);
        }
        if (zmFlag == 1) {
            return GEOMETRY_DICT.get(baseType + 2000);
        }
        return GEOMETRY_DICT.get(baseType + 3000);
    }

    static {
        GEOMETRY_DICT = new HashMap<Integer, GeometryType>();
        for (GeometryType gType : EnumSet.allOf(GeometryType.class)) {
            GEOMETRY_DICT.put(gType.value, gType);
        }
    }
}

