/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.data.vector.common.jts;

import com.geoway.atlas.algorithm.vector.overlay.geom.AtlasOverlayOp$;
import com.geoway.atlas.data.vector.common.crs.CrsUtils$;
import com.geoway.atlas.data.vector.common.crs.package$;
import java.io.Serializable;
import org.geotools.metadata.i18n.Errors;
import org.geotools.util.Classes;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import scala.Function1;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class JTSUtils$ {
    public static JTSUtils$ MODULE$;
    private final GeometryFactory gf;

    static {
        new JTSUtils$();
    }

    public GeometryFactory gf() {
        return this.gf;
    }

    public Geometry intersection(Geometry g0, Geometry g1) {
        return AtlasOverlayOp$.MODULE$.intersection(g0, g1);
    }

    /*
     * WARNING - void declaration
     */
    public Geometry toGeometry(Envelope envelope) {
        void var2_2;
        this.ensureNonNull("env", envelope);
        Polygon polygon = this.gf().createPolygon(this.gf().createLinearRing((Coordinate[])((Object[])new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMinY())})), null);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Geometry toGeometry(double[] doubles) {
        void var2_2;
        Polygon polygon = this.gf().createPolygon(this.gf().createLinearRing((Coordinate[])((Object[])new Coordinate[]{new Coordinate(doubles[0], doubles[2]), new Coordinate(doubles[0], doubles[3]), new Coordinate(doubles[1], doubles[3]), new Coordinate(doubles[1], doubles[2]), new Coordinate(doubles[0], doubles[2])})), null);
        return var2_2;
    }

    public MultiPolygon toMultiPolygon(Seq<Envelope> envelopes) {
        return this.gf().createMultiPolygon((Polygon[])((TraversableOnce)envelopes.map((Function1 & Serializable & scala.Serializable)e -> (Polygon)MODULE$.toGeometry((Envelope)e), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Polygon.class)));
    }

    public Geometry toUnionMultiPolygon(Seq<Envelope> envelopes) {
        return AtlasOverlayOp$.MODULE$.union((Seq)new .colon.colon((Object)this.toMultiPolygon((Seq<Envelope>)((Seq)envelopes.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JTSUtils$.$anonfun$toUnionMultiPolygon$1(x$1))))), (List)Nil$.MODULE$));
    }

    public Geometry toUnionGeometry(Seq<Geometry> geometries) {
        return AtlasOverlayOp$.MODULE$.union(geometries);
    }

    public Envelope transform(Envelope envelope, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        double densificationDistance = CrsUtils$.MODULE$.getDistanceFromMeters(sourceCRS, envelope.getMinX(), envelope.getMaxY(), CrsUtils$.MODULE$.getDensificationDistanceMeter());
        MathTransform transform = package$.MODULE$.GET_THRANSFORM(sourceCRS, targetCRS);
        return this.transform(envelope, transform, densificationDistance);
    }

    public void ensureNonNull(String name, Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException(Errors.format((int)143, (Object)name));
        }
    }

    public Envelope transform(Envelope sourceEnvelope, MathTransform transform, double meters) {
        this.ensureNonNull("sourceEnvelope", sourceEnvelope);
        this.ensureNonNull("transform", transform);
        if (transform.getSourceDimensions() != transform.getTargetDimensions() || transform.getSourceDimensions() < 2) {
            throw new MismatchedDimensionException(Errors.format((int)15, (Object)Classes.getShortClassName((Object)transform)));
        }
        double xmin = sourceEnvelope.getMinX();
        double xmax = sourceEnvelope.getMaxX();
        double ymin = sourceEnvelope.getMinY();
        double ymax = sourceEnvelope.getMaxY();
        int rangeX = (int)Math.ceil(sourceEnvelope.getWidth() / meters);
        int rangeY = (int)Math.ceil(sourceEnvelope.getHeight() / meters);
        double scaleX = sourceEnvelope.getWidth() / (double)rangeX;
        double scaleY = sourceEnvelope.getHeight() / (double)rangeY;
        double[] rangeXDoubles = new double[4 * rangeX];
        for (int index$macro$1 = 0; index$macro$1 < rangeX; ++index$macro$1) {
            rangeXDoubles[index$macro$1 * 4] = xmin + (double)index$macro$1 * scaleX;
            rangeXDoubles[index$macro$1 * 4 + 1] = ymin;
            rangeXDoubles[index$macro$1 * 4 + 2] = xmax - (double)index$macro$1 * scaleX;
            rangeXDoubles[index$macro$1 * 4 + 3] = ymax;
        }
        double[] rangeYDoubles = new double[4 * rangeY];
        for (int index$macro$2 = 0; index$macro$2 < rangeY; ++index$macro$2) {
            rangeYDoubles[index$macro$2 * 4] = xmin;
            rangeYDoubles[index$macro$2 * 4 + 1] = ymax - (double)index$macro$2 * scaleY;
            rangeYDoubles[index$macro$2 * 4 + 2] = xmax;
            rangeYDoubles[index$macro$2 * 4 + 3] = ymin + (double)index$macro$2 * scaleY;
        }
        this.xform(transform, rangeXDoubles, rangeXDoubles);
        this.xform(transform, rangeYDoubles, rangeYDoubles);
        Envelope targetEnvelope = new Envelope();
        for (int index$macro$3 = 0; index$macro$3 < rangeX * 2; ++index$macro$3) {
            targetEnvelope.expandToInclude(rangeXDoubles[2 * index$macro$3], rangeXDoubles[2 * index$macro$3 + 1]);
        }
        for (int index$macro$4 = 0; index$macro$4 < rangeY * 2; ++index$macro$4) {
            targetEnvelope.expandToInclude(rangeYDoubles[2 * index$macro$4], rangeYDoubles[2 * index$macro$4 + 1]);
        }
        return targetEnvelope;
    }

    public void xform(MathTransform transform, double[] src, double[] dest) {
        this.ensureNonNull("transform", transform);
        int sourceDim = transform.getSourceDimensions();
        int targetDim = transform.getTargetDimensions();
        if (targetDim != sourceDim) {
            throw new MismatchedDimensionException();
        }
        TransformException firstError = null;
        boolean startPointTransformed = false;
        for (int index$macro$2 = 0; index$macro$2 < src.length; index$macro$2 += sourceDim) {
            try {
                transform.transform(src, index$macro$2, dest, index$macro$2, 1);
                if (startPointTransformed) continue;
                startPointTransformed = true;
                for (int index$macro$1 = 0; index$macro$1 < index$macro$2; ++index$macro$1) {
                    System.arraycopy(dest, index$macro$1, dest, index$macro$2, targetDim);
                }
                continue;
            }
            catch (TransformException e) {
                if (firstError == null) {
                    firstError = e;
                }
                if (!startPointTransformed) continue;
                System.arraycopy(dest, index$macro$2 - targetDim, dest, index$macro$2, targetDim);
            }
        }
        if (!startPointTransformed && firstError != null) {
            throw firstError;
        }
    }

    public static final /* synthetic */ boolean $anonfun$toUnionMultiPolygon$1(Envelope x$1) {
        return !x$1.isNull();
    }

    private JTSUtils$() {
        MODULE$ = this;
        this.gf = new GeometryFactory();
    }
}

