/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.jts;

import com.geoway.atlas.jts.AttributeStreamOfDbl;
import com.geoway.atlas.jts.ECoordinate;
import com.geoway.atlas.jts.EditShape;
import com.geoway.atlas.jts.Envelope;
import com.geoway.atlas.jts.Geometry;
import com.geoway.atlas.jts.Line;
import com.geoway.atlas.jts.MultiPath;
import com.geoway.atlas.jts.MultiPathImpl;
import com.geoway.atlas.jts.MultiVertexGeometry;
import com.geoway.atlas.jts.MultiVertexGeometryImpl;
import com.geoway.atlas.jts.NumberUtils;
import com.geoway.atlas.jts.Point;
import com.geoway.atlas.jts.Point2D;
import com.geoway.atlas.jts.Polygon;
import com.geoway.atlas.jts.Polyline;
import com.geoway.atlas.jts.ProgressTracker;
import com.geoway.atlas.jts.Segment;
import com.geoway.atlas.jts.Treap;
import com.geoway.atlas.jts.VertexDescription;

class ConvexHull {
    private Treap m_tree_hull = new Treap();
    private EditShape m_shape;
    private AttributeStreamOfDbl m_stream;
    private Point2D[] m_points;
    private int m_geometry_handle;
    private int m_path_handle;
    private Line m_line;
    private CallBack m_call_back;

    ConvexHull() {
        this.m_tree_hull.setCapacity(20);
        this.m_shape = new EditShape();
        this.m_geometry_handle = this.m_shape.createGeometry(Geometry.Type.MultiPoint);
        this.m_path_handle = this.m_shape.insertPath(this.m_geometry_handle, -1);
        this.m_call_back = new CallBackShape(this);
    }

    private ConvexHull(AttributeStreamOfDbl stream, int n) {
        this.m_tree_hull.setCapacity(Math.min(20, n));
        this.m_stream = stream;
        this.m_call_back = new CallBackStream(this);
    }

    private ConvexHull(Point2D[] points, int n) {
        this.m_tree_hull.setCapacity(Math.min(20, n));
        this.m_points = points;
        this.m_call_back = new CallBackPoints(this);
    }

    void addGeometry(Geometry geometry) {
        if (geometry.isEmpty()) {
            return;
        }
        int type = geometry.getType().value();
        if (MultiVertexGeometry.isMultiVertex(type)) {
            this.addMultiVertexGeometry_((MultiVertexGeometry)geometry);
        } else if (MultiPath.isSegment(type)) {
            this.addSegment_((Segment)geometry);
        } else if (type == 197) {
            this.addEnvelope_((Envelope)geometry);
        } else if (type == 33) {
            this.addPoint_((Point)geometry);
        } else {
            throw new IllegalArgumentException("invalid shape type");
        }
    }

    Geometry getBoundingGeometry() {
        Point point = new Point();
        int first = this.m_tree_hull.getFirst(-1);
        Polygon hull = new Polygon(this.m_shape.getVertexDescription());
        if (this.m_tree_hull.size(-1) == 0) {
            return hull;
        }
        this.m_shape.queryPoint(this.m_tree_hull.getElement(first), point);
        hull.startPath(point);
        int i = this.m_tree_hull.getNext(first);
        while (i != -1) {
            this.m_shape.queryPoint(this.m_tree_hull.getElement(i), point);
            hull.lineTo(point);
            i = this.m_tree_hull.getNext(i);
        }
        return hull;
    }

    static Geometry construct(MultiVertexGeometry mvg) {
        Geometry hull;
        VertexDescription description;
        int tm;
        if (mvg.isEmpty()) {
            return new Polygon(mvg.getDescription());
        }
        MultiVertexGeometryImpl mvg_impl = (MultiVertexGeometryImpl)mvg._getImpl();
        int N = mvg_impl.getPointCount();
        if (N <= 2) {
            if (N == 1 || mvg_impl.getXY(0).equals(mvg_impl.getXY(1))) {
                Point point = new Point(mvg_impl.getDescription());
                mvg_impl.getPointByVal(0, point);
                return point;
            }
            Point pt = new Point();
            Polyline polyline = new Polyline(mvg_impl.getDescription());
            mvg_impl.getPointByVal(0, pt);
            polyline.startPath(pt);
            mvg_impl.getPointByVal(1, pt);
            polyline.lineTo(pt);
            return polyline;
        }
        AttributeStreamOfDbl stream = (AttributeStreamOfDbl)mvg_impl.getAttributeStreamRef(0);
        ConvexHull convex_hull = new ConvexHull(stream, N);
        int t0 = 0;
        Point2D pt_0 = new Point2D();
        Point2D pt_m = new Point2D();
        Point2D pt_p = new Point2D();
        stream.read(t0 << 1, pt_0);
        for (tm = 1; tm < N; ++tm) {
            stream.read(tm << 1, pt_m);
            if (!pt_m.isEqual(pt_0, NumberUtils.doubleEps())) break;
        }
        convex_hull.m_tree_hull.addElement(t0, -1);
        if (tm < N) {
            convex_hull.m_tree_hull.addBiggestElement(tm, -1);
            for (int tp = tm + 1; tp < mvg_impl.getPointCount(); ++tp) {
                stream.read(tp << 1, pt_p);
                int p = convex_hull.treeHull_(pt_p);
                if (p == -1) continue;
                convex_hull.m_tree_hull.setElement(p, tp);
            }
        }
        boolean b_has_attributes = (description = mvg_impl.getDescription()).getAttributeCount() > 1;
        int point_count = convex_hull.m_tree_hull.size(-1);
        if (point_count >= 2) {
            hull = point_count >= 3 ? new Polygon(description) : new Polyline(description);
            MultiPathImpl hull_impl = (MultiPathImpl)((Geometry)hull)._getImpl();
            hull_impl.addPath((Point2D[])null, 0, true);
            Point point = null;
            if (b_has_attributes) {
                point = new Point();
            }
            int i = convex_hull.m_tree_hull.getFirst(-1);
            while (i != -1) {
                if (b_has_attributes) {
                    mvg_impl.getPointByVal(convex_hull.m_tree_hull.getElement(i), point);
                    hull_impl.insertPoint(0, -1, point);
                } else {
                    stream.read(convex_hull.m_tree_hull.getElement(i) << 1, pt_p);
                    hull_impl.insertPoint(0, -1, pt_p);
                }
                i = convex_hull.m_tree_hull.getNext(i);
            }
        } else {
            assert (point_count == 1);
            if (b_has_attributes) {
                Point point = new Point(description);
                mvg_impl.getPointByVal(convex_hull.m_tree_hull.getElement(convex_hull.m_tree_hull.getFirst(-1)), point);
                hull = point;
            } else {
                stream.read(convex_hull.m_tree_hull.getElement(convex_hull.m_tree_hull.getFirst(-1)) << 1, pt_p);
                hull = new Point(pt_p);
            }
        }
        return hull;
    }

    static int construct(Point2D[] points, int count, int[] out_convex_hull) {
        int tm;
        ConvexHull convex_hull = new ConvexHull(points, count);
        int t0 = 0;
        Point2D pt_0 = points[t0];
        for (tm = 1; tm < count && points[tm].isEqual(pt_0, NumberUtils.doubleEps()); ++tm) {
        }
        convex_hull.m_tree_hull.addElement(t0, -1);
        if (tm < count) {
            convex_hull.m_tree_hull.addBiggestElement(tm, -1);
            for (int tp = tm + 1; tp < count; ++tp) {
                Point2D pt_p = points[tp];
                int p = convex_hull.treeHull_(pt_p);
                if (p == -1) continue;
                convex_hull.m_tree_hull.setElement(p, tp);
            }
        }
        int out_count = 0;
        int i = convex_hull.m_tree_hull.getFirst(-1);
        while (i != -1) {
            out_convex_hull[out_count++] = convex_hull.m_tree_hull.getElement(i);
            i = convex_hull.m_tree_hull.getNext(i);
        }
        return out_count;
    }

    static boolean isPathConvex(MultiPath multi_path, int path_index, ProgressTracker progress_tracker) {
        MultiPathImpl mimpl = (MultiPathImpl)multi_path._getImpl();
        int path_start = mimpl.getPathStart(path_index);
        int path_end = mimpl.getPathEnd(path_index);
        boolean bxyclosed = !mimpl.isClosedPath(path_index) && mimpl.isClosedPathInXYPlane(path_index);
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)mimpl.getAttributeStreamRef(0);
        int position_start = 2 * path_start;
        int position_end = 2 * path_end;
        if (bxyclosed) {
            position_end -= 2;
        }
        if (position_end - position_start < 6) {
            return true;
        }
        Point2D pt_0 = new Point2D();
        Point2D pt_m = new Point2D();
        Point2D pt_pivot = new Point2D();
        position.read(position_start, pt_0);
        position.read(position_start + 2, pt_m);
        position.read(position_start + 4, pt_pivot);
        ECoordinate det_ec = ConvexHull.determinant_(pt_m, pt_pivot, pt_0);
        if (det_ec.isFuzzyZero() || !ConvexHull.isClockwise_(det_ec.value())) {
            return false;
        }
        Point2D pt_1 = new Point2D(pt_m.x, pt_m.y);
        Point2D pt_m_prev = new Point2D();
        for (int i = position_start + 6; i < position_end; i += 2) {
            pt_m_prev.setCoords(pt_m);
            pt_m.setCoords(pt_pivot);
            position.read(i, pt_pivot);
            det_ec = ConvexHull.determinant_(pt_m, pt_pivot, pt_0);
            if (det_ec.isFuzzyZero() || !ConvexHull.isClockwise_(det_ec.value())) {
                return false;
            }
            det_ec = ConvexHull.determinant_(pt_1, pt_pivot, pt_0);
            if (det_ec.isFuzzyZero() || !ConvexHull.isClockwise_(det_ec.value())) {
                return false;
            }
            det_ec = ConvexHull.determinant_(pt_m, pt_pivot, pt_m_prev);
            if (!det_ec.isFuzzyZero() && ConvexHull.isClockwise_(det_ec.value())) continue;
            return false;
        }
        return true;
    }

    private void addMultiVertexGeometry_(MultiVertexGeometry mvg) {
        Point point = new Point();
        Point2D pt_p = new Point2D();
        for (int i = 0; i < mvg.getPointCount(); ++i) {
            mvg.getXY(i, pt_p);
            int p = this.addPoint_(pt_p);
            if (p == -1) continue;
            mvg.getPointByVal(i, point);
            int tp = this.m_shape.addPoint(this.m_path_handle, point);
            this.m_tree_hull.setElement(p, tp);
        }
    }

    private void addEnvelope_(Envelope envelope) {
        Point point = new Point();
        Point2D pt_p = new Point2D();
        for (int i = 0; i < 4; ++i) {
            envelope.queryCorner(i, pt_p);
            int p = this.addPoint_(pt_p);
            if (p == -1) continue;
            envelope.queryCornerByVal(i, point);
            int tp = this.m_shape.addPoint(this.m_path_handle, point);
            this.m_tree_hull.setElement(p, tp);
        }
    }

    private void addSegment_(Segment segment) {
        Point2D pt_end;
        int p_end;
        Point point = new Point();
        Point2D pt_start = segment.getStartXY();
        int p_start = this.addPoint_(pt_start);
        if (p_start != -1) {
            segment.queryStart(point);
            int t_start = this.m_shape.addPoint(this.m_path_handle, point);
            this.m_tree_hull.setElement(p_start, t_start);
        }
        if ((p_end = this.addPoint_(pt_end = segment.getEndXY())) != -1) {
            segment.queryEnd(point);
            int t_end = this.m_shape.addPoint(this.m_path_handle, point);
            this.m_tree_hull.setElement(p_end, t_end);
        }
    }

    private void addPoint_(Point point) {
        Point2D pt_p = point.getXY();
        int p = this.addPoint_(pt_p);
        if (p != -1) {
            int tp = this.m_shape.addPoint(this.m_path_handle, point);
            this.m_tree_hull.setElement(p, tp);
        }
    }

    private int addPoint_(Point2D pt_p) {
        int p = -1;
        if (this.m_tree_hull.size(-1) == 0) {
            p = this.m_tree_hull.addElement(-4, -1);
            return p;
        }
        if (this.m_tree_hull.size(-1) == 1) {
            int t0 = this.m_tree_hull.getElement(this.m_tree_hull.getFirst(-1));
            Point2D pt_0 = this.m_shape.getXY(t0);
            if (!pt_p.isEqual(pt_0, NumberUtils.doubleEps())) {
                p = this.m_tree_hull.addBiggestElement(-5, -1);
            }
            return p;
        }
        p = this.treeHull_(pt_p);
        return p;
    }

    private int treeHull_(Point2D pt_pivot) {
        int p;
        block8: {
            int between;
            int last;
            int first;
            block10: {
                int orient_m_p_0;
                Point2D pt_m;
                Point2D pt_0;
                block9: {
                    int orient_k_prev_p_k;
                    int tk;
                    block7: {
                        assert (this.m_tree_hull.size(-1) >= 2);
                        p = -1;
                        first = this.m_tree_hull.getFirst(-1);
                        last = this.m_tree_hull.getLast(-1);
                        int t0 = this.m_tree_hull.getElement(first);
                        int tm = this.m_tree_hull.getElement(last);
                        pt_0 = new Point2D();
                        pt_m = new Point2D();
                        this.m_call_back.getXY(t0, pt_0);
                        this.m_call_back.getXY(tm, pt_m);
                        assert (!pt_0.isEqual(pt_m, NumberUtils.doubleEps()));
                        orient_m_p_0 = Point2D.orientationRobust(pt_m, pt_pivot, pt_0);
                        if (!ConvexHull.isClockwise_(orient_m_p_0)) break block7;
                        p = this.m_tree_hull.addBiggestElement(-1, -1);
                        int l = this.treeHullWalkBackward_(pt_pivot, last, first);
                        if (l == first) break block8;
                        this.treeHullWalkForward_(pt_pivot, first, this.m_tree_hull.getPrev(l));
                        break block8;
                    }
                    if (!ConvexHull.isCounterClockwise_(orient_m_p_0)) break block9;
                    int k = this.m_tree_hull.getRoot(-1);
                    int k_min = this.m_tree_hull.getFirst(-1);
                    int k_max = this.m_tree_hull.getLast(-1);
                    Point2D pt_k = new Point2D();
                    Point2D pt_k_prev = new Point2D();
                    while (k_min != this.m_tree_hull.getPrev(k_max)) {
                        tk = this.m_tree_hull.getElement(k);
                        this.m_call_back.getXY(tk, pt_k);
                        int orient_k_p_0 = Point2D.orientationRobust(pt_k, pt_pivot, pt_0);
                        if (ConvexHull.isCounterClockwise_(orient_k_p_0)) {
                            k_max = k;
                            k = this.m_tree_hull.getLeft(k);
                            continue;
                        }
                        k_min = k;
                        k = this.m_tree_hull.getRight(k);
                    }
                    k = k_max;
                    int k_prev = k_min;
                    tk = this.m_tree_hull.getElement(k);
                    int tk_prev = this.m_tree_hull.getElement(k_prev);
                    this.m_call_back.getXY(tk, pt_k);
                    this.m_call_back.getXY(tk_prev, pt_k_prev);
                    assert (ConvexHull.isCounterClockwise_(Point2D.orientationRobust(pt_k, pt_pivot, pt_0)) && !ConvexHull.isCounterClockwise_(Point2D.orientationRobust(pt_k_prev, pt_pivot, pt_0)));
                    assert (k_prev != first || ConvexHull.isCounterClockwise_(Point2D.orientationRobust(pt_k, pt_pivot, pt_0)));
                    if (k_prev != first && !ConvexHull.isClockwise_(orient_k_prev_p_k = Point2D.orientationRobust(pt_k_prev, pt_pivot, pt_k))) break block8;
                    p = this.m_tree_hull.addElementAtPosition(k_prev, k, -2, true, false, -1);
                    this.treeHullWalkForward_(pt_pivot, k, last);
                    this.treeHullWalkBackward_(pt_pivot, k_prev, first);
                    break block8;
                }
                assert (ConvexHull.isDegenerate_(orient_m_p_0));
                between = ConvexHull.isBetween_(pt_pivot, pt_m, pt_0);
                if (between != -1) break block10;
                int l = this.m_tree_hull.getPrev(last);
                this.m_tree_hull.deleteNode(last, -1);
                p = this.m_tree_hull.addBiggestElement(-3, -1);
                this.treeHullWalkBackward_(pt_pivot, l, first);
                break block8;
            }
            if (between != 1) break block8;
            int j = this.m_tree_hull.getNext(first);
            this.m_tree_hull.deleteNode(first, -1);
            p = this.m_tree_hull.addElementAtPosition(-1, j, -3, true, false, -1);
            this.treeHullWalkForward_(pt_pivot, j, last);
        }
        return p;
    }

    private int treeHullWalkForward_(Point2D pt_pivot, int start, int end) {
        if (start == end) {
            return end;
        }
        int j = start;
        int tj = this.m_tree_hull.getElement(j);
        int j_next = this.m_tree_hull.getNext(j);
        Point2D pt_j = new Point2D();
        Point2D pt_j_next = new Point2D();
        this.m_call_back.getXY(tj, pt_j);
        while (j != end && this.m_tree_hull.size(-1) > 2) {
            int tj_next = this.m_tree_hull.getElement(j_next);
            this.m_call_back.getXY(tj_next, pt_j_next);
            int orient_j_next_p_j = Point2D.orientationRobust(pt_j_next, pt_pivot, pt_j);
            if (ConvexHull.isClockwise_(orient_j_next_p_j)) break;
            int ccw = j;
            j = j_next;
            pt_j.setCoords(pt_j_next);
            j_next = this.m_tree_hull.getNext(j);
            this.m_call_back.deleteNode(ccw);
        }
        return j;
    }

    private int treeHullWalkBackward_(Point2D pt_pivot, int start, int end) {
        if (start == end) {
            return end;
        }
        int l = start;
        int tl = this.m_tree_hull.getElement(l);
        int l_prev = this.m_tree_hull.getPrev(l);
        Point2D pt_l = new Point2D();
        Point2D pt_l_prev = new Point2D();
        this.m_call_back.getXY(tl, pt_l);
        while (l != end && this.m_tree_hull.size(-1) > 2) {
            int tl_prev = this.m_tree_hull.getElement(l_prev);
            this.m_call_back.getXY(tl_prev, pt_l_prev);
            int orient_l_p_l_prev = Point2D.orientationRobust(pt_l, pt_pivot, pt_l_prev);
            if (ConvexHull.isClockwise_(orient_l_p_l_prev)) break;
            int ccw = l;
            l = l_prev;
            pt_l.setCoords(pt_l_prev);
            l_prev = this.m_tree_hull.getPrev(l);
            this.m_call_back.deleteNode(ccw);
        }
        return l;
    }

    private static ECoordinate determinant_(Point2D p, Point2D q, Point2D r) {
        ECoordinate det_ec = new ECoordinate();
        det_ec.set(q.x);
        det_ec.sub(p.x);
        ECoordinate rp_y_ec = new ECoordinate();
        rp_y_ec.set(r.y);
        rp_y_ec.sub(p.y);
        ECoordinate qp_y_ec = new ECoordinate();
        qp_y_ec.set(q.y);
        qp_y_ec.sub(p.y);
        ECoordinate rp_x_ec = new ECoordinate();
        rp_x_ec.set(r.x);
        rp_x_ec.sub(p.x);
        det_ec.mul(rp_y_ec);
        qp_y_ec.mul(rp_x_ec);
        det_ec.sub(qp_y_ec);
        return det_ec;
    }

    private static boolean isClockwise_(double det) {
        return det < 0.0;
    }

    private static boolean isCounterClockwise_(double det) {
        return det > 0.0;
    }

    private static boolean isDegenerate_(double det) {
        return det == 0.0;
    }

    private static boolean isClockwise_(int orientation) {
        return (double)orientation < 0.0;
    }

    private static boolean isCounterClockwise_(int orientation) {
        return (double)orientation > 0.0;
    }

    private static boolean isDegenerate_(int orientation) {
        return (double)orientation == 0.0;
    }

    private static int isBetween_(Point2D pt_pivot, Point2D pt_m, Point2D pt_0) {
        double diff_y;
        double diff_x;
        int ordinate = -1;
        ordinate = pt_m.y == pt_0.y ? 0 : (pt_m.x == pt_0.x ? 1 : ((diff_x = Math.abs(pt_m.x - pt_0.x)) >= (diff_y = Math.abs(pt_m.y - pt_0.y)) ? 0 : 1));
        int res = -1;
        if (ordinate == 0) {
            assert (pt_m.x != pt_0.x);
            if (pt_m.x < pt_0.x) {
                res = pt_pivot.x < pt_m.x ? -1 : (pt_0.x < pt_pivot.x ? 1 : 0);
            } else {
                assert (pt_0.x < pt_m.x);
                res = pt_m.x < pt_pivot.x ? -1 : (pt_pivot.x < pt_0.x ? 1 : 0);
            }
        } else {
            assert (pt_m.y != pt_0.y);
            if (pt_m.y < pt_0.y) {
                res = pt_pivot.y < pt_m.y ? -1 : (pt_0.y < pt_pivot.y ? 1 : 0);
            } else {
                assert (pt_0.y < pt_m.y);
                res = pt_m.y < pt_pivot.y ? -1 : (pt_pivot.y < pt_0.y ? 1 : 0);
            }
        }
        return res;
    }

    private static final class CallBackPoints
    extends CallBack {
        private ConvexHull m_convex_hull;

        CallBackPoints(ConvexHull convex_hull) {
            this.m_convex_hull = convex_hull;
        }

        @Override
        void getXY(int ti, Point2D pt) {
            pt.setCoords(this.m_convex_hull.m_points[ti]);
        }

        @Override
        void deleteNode(int i) {
            this.m_convex_hull.m_tree_hull.deleteNode(i, -1);
        }
    }

    private static final class CallBackStream
    extends CallBack {
        private ConvexHull m_convex_hull;

        CallBackStream(ConvexHull convex_hull) {
            this.m_convex_hull = convex_hull;
        }

        @Override
        void getXY(int ti, Point2D pt) {
            this.m_convex_hull.m_stream.read(ti << 1, pt);
        }

        @Override
        void deleteNode(int i) {
            this.m_convex_hull.m_tree_hull.deleteNode(i, -1);
        }
    }

    private static final class CallBackShape
    extends CallBack {
        private ConvexHull m_convex_hull;

        CallBackShape(ConvexHull convex_hull) {
            this.m_convex_hull = convex_hull;
        }

        @Override
        void getXY(int ti, Point2D pt) {
            this.m_convex_hull.m_shape.getXY(ti, pt);
        }

        @Override
        void deleteNode(int i) {
            int ti = this.m_convex_hull.m_tree_hull.getElement(i);
            this.m_convex_hull.m_tree_hull.deleteNode(i, -1);
            this.m_convex_hull.m_shape.removeVertex(ti, false);
        }
    }

    private static abstract class CallBack {
        private CallBack() {
        }

        abstract void getXY(int var1, Point2D var2);

        abstract void deleteNode(int var1);
    }
}

