/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.jts;

import com.geoway.atlas.jts.Clusterer;
import com.geoway.atlas.jts.Cracker;
import com.geoway.atlas.jts.EditShape;
import com.geoway.atlas.jts.GeometryException;
import com.geoway.atlas.jts.InternalUtils;
import com.geoway.atlas.jts.MathUtils;
import com.geoway.atlas.jts.Point;
import com.geoway.atlas.jts.ProgressTracker;

final class CrackAndCluster {
    private EditShape m_shape = null;
    private ProgressTracker m_progressTracker = null;
    private double m_tolerance;
    private boolean m_filter_degenerate_segments = true;

    private CrackAndCluster(ProgressTracker progressTracker) {
        this.m_progressTracker = progressTracker;
    }

    static boolean non_empty_points_need_to_cluster(double tolerance, Point pt1, Point pt2) {
        double tolerance_for_clustering = InternalUtils.adjust_tolerance_for_TE_clustering(tolerance);
        return Clusterer.isClusterCandidate_(pt1.getX(), pt1.getY(), pt2.getX(), pt2.getY(), MathUtils.sqr(tolerance_for_clustering));
    }

    static Point cluster_non_empty_points(Point pt1, Point pt2, double w1, int rank1, double w2, int rank2) {
        if (rank1 > rank2) {
            return pt1;
        }
        if (rank2 < rank1) {
            return pt2;
        }
        int[] rank = null;
        double[] w = null;
        Point pt = new Point();
        Clusterer.mergeVertices(pt1, pt2, w1, rank1, w2, rank2, pt, w, rank);
        return pt;
    }

    public static boolean execute(EditShape shape, double tolerance, ProgressTracker progressTracker, boolean filter_degenerate_segments) {
        CrackAndCluster cracker = new CrackAndCluster(progressTracker);
        cracker.m_shape = shape;
        cracker.m_tolerance = tolerance;
        cracker.m_filter_degenerate_segments = filter_degenerate_segments;
        return cracker._do();
    }

    private boolean _cluster(double toleranceCluster) {
        boolean res = Clusterer.executeNonReciprocal(this.m_shape, toleranceCluster);
        return res;
    }

    private boolean _crack(double tolerance_for_cracking) {
        boolean res = Cracker.execute(this.m_shape, tolerance_for_cracking, this.m_progressTracker);
        return res;
    }

    private boolean _do() {
        double tol = this.m_tolerance;
        double c_factor = 1.0E-5;
        double c_factor_for_needs_cracking = 1.0E-6;
        double tolerance_for_clustering = InternalUtils.adjust_tolerance_for_TE_clustering(tol);
        double tolerance_for_needs_cracking = InternalUtils.adjust_tolerance_for_TE_cracking(tol);
        double tolerance_for_cracking = tolerance_for_needs_cracking * 1.00001;
        tolerance_for_needs_cracking *= 1.000001;
        assert (tolerance_for_clustering > tolerance_for_cracking);
        assert (tolerance_for_cracking > tolerance_for_needs_cracking);
        boolean bChanged = false;
        int max_iter = this.m_shape.getTotalPointCount() + 10 > 30 ? 1000 : (this.m_shape.getTotalPointCount() + 10) * (this.m_shape.getTotalPointCount() + 10);
        int iter = 0;
        boolean has_point_features = this.m_shape.hasPointFeatures();
        while (true) {
            if (iter > max_iter) {
                throw new GeometryException("Internal Error: max number of iterations exceeded");
            }
            boolean bClustered = this._cluster(tolerance_for_clustering);
            bChanged |= bClustered;
            if (this.m_filter_degenerate_segments) {
                boolean bFiltered = this.m_shape.filterClosePoints(tolerance_for_clustering, true, false) != 0;
                bChanged |= bFiltered;
            }
            boolean b_cracked = false;
            if (iter == 0 || has_point_features || Cracker.needsCracking(true, this.m_shape, tolerance_for_needs_cracking, null, this.m_progressTracker)) {
                b_cracked = this._crack(tolerance_for_cracking);
                bChanged |= b_cracked;
            }
            if (!b_cracked) break;
            ProgressTracker.checkAndThrow(this.m_progressTracker);
            ++iter;
        }
        return bChanged;
    }
}

