/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.jts;

import com.geoway.atlas.jts.AttributeStreamBase;
import com.geoway.atlas.jts.AttributeStreamBaseOffset;
import com.geoway.atlas.jts.AttributeStreamOfDbl;
import com.geoway.atlas.jts.AttributeStreamOfInt32;
import com.geoway.atlas.jts.AttributeStreamOfInt8;
import com.geoway.atlas.jts.EditShape;
import com.geoway.atlas.jts.Geometry;
import com.geoway.atlas.jts.MultiPathImpl;
import com.geoway.atlas.jts.Polygon;
import com.geoway.atlas.jts.TopologicalOperations;
import com.geoway.atlas.jts.VertexDescription;
import java.util.ArrayList;
import java.util.Map;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygonal;

public class EditShapeUtils {
    public static Geometry getEmptyGeometry(Polygonal polygonal) {
        ArrayList<org.locationtech.jts.geom.Polygon> jtsPolygons = new ArrayList<org.locationtech.jts.geom.Polygon>();
        Coordinate coordinate = ((org.locationtech.jts.geom.Geometry)((Object)polygonal)).getCoordinate();
        boolean hasZ = false;
        boolean hasM = false;
        if (!(coordinate instanceof CoordinateXY)) {
            if (coordinate instanceof CoordinateXYM) {
                hasM = true;
            } else if (coordinate instanceof CoordinateXYZM) {
                hasM = true;
                hasZ = true;
            } else if (coordinate instanceof Coordinate && !Double.isNaN(coordinate.z)) {
                hasZ = true;
            }
        }
        if (polygonal instanceof org.locationtech.jts.geom.Polygon) {
            jtsPolygons.add((org.locationtech.jts.geom.Polygon)polygonal);
        } else {
            MultiPolygon multiPolygon = (MultiPolygon)polygonal;
            if (multiPolygon.getNumGeometries() > 0) {
                for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                    jtsPolygons.add((org.locationtech.jts.geom.Polygon)multiPolygon.getGeometryN(i));
                }
            }
        }
        int pointCount = 0;
        int partCount = 0;
        AttributeStreamOfInt32 parts = null;
        AttributeStreamOfInt8 pathFlags = null;
        ArrayList<Integer> pathFlagsCache = new ArrayList<Integer>();
        ArrayList<Integer> partsCache = new ArrayList<Integer>();
        for (org.locationtech.jts.geom.Polygon jtsPolygon : jtsPolygons) {
            int i;
            LinearRing linearRing = jtsPolygon.getExteriorRing();
            pathFlagsCache.add(partCount);
            int numInteriorRing = jtsPolygon.getNumInteriorRing();
            ArrayList<Object> rings = new ArrayList<Object>();
            rings.add(linearRing);
            if (numInteriorRing > 0) {
                for (i = 0; i < numInteriorRing; ++i) {
                    LinearRing interiorRing = jtsPolygon.getInteriorRingN(i);
                    rings.add(interiorRing);
                }
            }
            for (i = 0; i < rings.size(); ++i) {
                LinearRing ring = (LinearRing)rings.get(i);
                int numPoints = ring.getNumPoints();
                if (numPoints == 0) continue;
                if (numPoints <= 2) {
                    pointCount = numPoints == 1 ? (pointCount += numPoints + 1) : (pointCount += numPoints);
                    ++partCount;
                    partsCache.add(pointCount);
                    continue;
                }
                pointCount = ring.isClosed() ? (pointCount += numPoints - 1) : (pointCount += numPoints);
                ++partCount;
                partsCache.add(pointCount);
            }
        }
        Polygon newPolygon = new Polygon();
        MultiPathImpl polygon = (MultiPathImpl)((Geometry)newPolygon)._getImpl();
        if (pointCount > 0) {
            parts = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(partCount + 1, 0);
            pathFlags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(parts.size(), (byte)1);
        }
        if (hasZ) {
            polygon.addAttribute(1);
        }
        if (hasM) {
            polygon.addAttribute(2);
        }
        for (Integer pathFlag : pathFlagsCache) {
            pathFlags.setBits(pathFlag, (byte)4);
        }
        for (int partIndex = 0; partIndex < partsCache.size(); ++partIndex) {
            parts.write(partIndex + 1, (Integer)partsCache.get(partIndex));
        }
        if (pointCount > 0) {
            polygon.setPathStreamRef(parts);
            polygon.setPathFlagsStreamRef(pathFlags);
            polygon.notifyModified(0xFFFFFF);
        }
        polygon.setIsSimple(1, 0.0, false);
        polygon.setDirtyOGCFlags(false);
        return newPolygon;
    }

    public static VertexDescription getVertexDescription(Polygonal polygonal) {
        ArrayList<org.locationtech.jts.geom.Polygon> jtsPolygons = new ArrayList<org.locationtech.jts.geom.Polygon>();
        Coordinate coordinate = ((org.locationtech.jts.geom.Geometry)((Object)polygonal)).getCoordinate();
        boolean hasZ = false;
        boolean hasM = false;
        if (!(coordinate instanceof CoordinateXY)) {
            if (coordinate instanceof CoordinateXYM) {
                hasM = true;
            } else if (coordinate instanceof CoordinateXYZM) {
                hasM = true;
                hasZ = true;
            } else if (coordinate instanceof Coordinate && !Double.isNaN(coordinate.z)) {
                hasZ = true;
            }
        }
        if (polygonal instanceof org.locationtech.jts.geom.Polygon) {
            jtsPolygons.add((org.locationtech.jts.geom.Polygon)polygonal);
        } else {
            MultiPolygon multiPolygon = (MultiPolygon)polygonal;
            if (multiPolygon.getNumGeometries() > 0) {
                for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                    jtsPolygons.add((org.locationtech.jts.geom.Polygon)multiPolygon.getGeometryN(i));
                }
            }
        }
        int pointCount = 0;
        int partCount = 0;
        AttributeStreamOfInt32 parts = null;
        AttributeStreamOfInt8 pathFlags = null;
        ArrayList<Integer> pathFlagsCache = new ArrayList<Integer>();
        ArrayList<Integer> partsCache = new ArrayList<Integer>();
        for (org.locationtech.jts.geom.Polygon jtsPolygon : jtsPolygons) {
            int i;
            LinearRing linearRing = jtsPolygon.getExteriorRing();
            pathFlagsCache.add(partCount);
            int numInteriorRing = jtsPolygon.getNumInteriorRing();
            ArrayList<Object> rings = new ArrayList<Object>();
            rings.add(linearRing);
            if (numInteriorRing > 0) {
                for (i = 0; i < numInteriorRing; ++i) {
                    LinearRing interiorRing = jtsPolygon.getInteriorRingN(i);
                    rings.add(interiorRing);
                }
            }
            for (i = 0; i < rings.size(); ++i) {
                LinearRing ring = (LinearRing)rings.get(i);
                int numPoints = ring.getNumPoints();
                if (numPoints == 0) continue;
                if (numPoints <= 2) {
                    pointCount = numPoints == 1 ? (pointCount += numPoints + 1) : (pointCount += numPoints);
                    ++partCount;
                    partsCache.add(pointCount);
                    continue;
                }
                pointCount = ring.isClosed() ? (pointCount += numPoints - 1) : (pointCount += numPoints);
                ++partCount;
                partsCache.add(pointCount);
            }
        }
        Polygon newPolygon = new Polygon();
        MultiPathImpl polygon = (MultiPathImpl)((Geometry)newPolygon)._getImpl();
        if (pointCount > 0) {
            parts = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(partCount + 1, 0);
            pathFlags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(parts.size(), (byte)1);
        }
        if (hasZ) {
            polygon.addAttribute(1);
        }
        if (hasM) {
            polygon.addAttribute(2);
        }
        for (Integer pathFlag : pathFlagsCache) {
            pathFlags.setBits(pathFlag, (byte)4);
        }
        for (int partIndex = 0; partIndex < partsCache.size(); ++partIndex) {
            parts.write(partIndex + 1, (Integer)partsCache.get(partIndex));
        }
        if (pointCount > 0) {
            polygon.setPathStreamRef(parts);
            polygon.setPathFlagsStreamRef(pathFlags);
            polygon.notifyModified(0xFFFFFF);
        }
        polygon.setIsSimple(1, 0.0, false);
        polygon.setDirtyOGCFlags(false);
        return polygon.getDescription();
    }

    public static void setAttributeStreamBase(Map<Integer, AttributeStreamBaseOffset> asbs, VertexDescription vd, Polygonal polygonal) {
        ArrayList<org.locationtech.jts.geom.Polygon> jtsPolygons = new ArrayList<org.locationtech.jts.geom.Polygon>();
        if (polygonal instanceof org.locationtech.jts.geom.Polygon) {
            jtsPolygons.add((org.locationtech.jts.geom.Polygon)polygonal);
        } else {
            MultiPolygon multiPolygon = (MultiPolygon)polygonal;
            for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
                jtsPolygons.add((org.locationtech.jts.geom.Polygon)multiPolygon.getGeometryN(i));
            }
        }
        ArrayList<Integer> semantics = new ArrayList<Integer>();
        int nattrib = vd.getAttributeCount();
        for (int iattrib = 0; iattrib < nattrib; ++iattrib) {
            semantics.add(vd._getSemanticsImpl(iattrib));
        }
        AttributeStreamOfDbl position = (AttributeStreamOfDbl)asbs.get(0).getAttributeStreamBase();
        int positionOffset = asbs.get(0).getOffset();
        AttributeStreamOfDbl zs = null;
        int zsOffset = 0;
        AttributeStreamOfDbl ms = null;
        int msOffset = 0;
        boolean hasZ = false;
        if (semantics.contains(1)) {
            zs = (AttributeStreamOfDbl)asbs.get(1).getAttributeStreamBase();
            zsOffset = asbs.get(1).getOffset();
            hasZ = true;
        }
        boolean hasM = false;
        if (semantics.contains(2)) {
            ms = (AttributeStreamOfDbl)asbs.get(2).getAttributeStreamBase();
            msOffset = asbs.get(2).getOffset();
            hasM = true;
        }
        int iPartEnd = 0;
        for (org.locationtech.jts.geom.Polygon jtsPolygon : jtsPolygons) {
            LinearRing exteriorRing = jtsPolygon.getExteriorRing();
            int numInteriorRing = jtsPolygon.getNumInteriorRing();
            ArrayList<LinearRing> rings = new ArrayList<LinearRing>();
            rings.add(exteriorRing);
            if (numInteriorRing > 0) {
                for (int i = 0; i < numInteriorRing; ++i) {
                    rings.add(jtsPolygon.getInteriorRingN(i));
                }
            }
            for (LinearRing lr : rings) {
                int iPointCount = lr.getNumPoints();
                if (iPointCount == 0) continue;
                int iPartStart = iPartEnd;
                iPartEnd += iPointCount;
                boolean bSkipLastPoint = true;
                if (iPointCount == 1) {
                    ++iPartEnd;
                } else if (iPointCount == 2) {
                    bSkipLastPoint = false;
                } else {
                    bSkipLastPoint = lr.isClosed();
                    if (bSkipLastPoint) {
                        --iPartEnd;
                    }
                }
                int coordinateIndex = 0;
                for (int i = ++iPartStart; i < iPartEnd; ++i) {
                    position.write(positionOffset + 2 * i, lr.getCoordinateN(coordinateIndex).getX());
                    position.write(positionOffset + 2 * i + 1, lr.getCoordinateN(coordinateIndex).getY());
                    if (hasZ) {
                        zs.write(zsOffset + i, lr.getCoordinateN(coordinateIndex).getZ());
                    }
                    if (hasM) {
                        ms.write(msOffset + i, lr.getCoordinateN(coordinateIndex).getM());
                    }
                    ++coordinateIndex;
                }
                if (iPointCount != 1) continue;
                double x = position.read(positionOffset + 2 * iPartStart);
                double y = position.read(positionOffset + 2 * iPartStart + 1);
                position.write(positionOffset + 2 * (iPartStart - 1), x);
                position.write(positionOffset + 2 * (iPartStart - 1) + 1, y);
                if (hasZ) {
                    double z = zs.read(zsOffset + iPartStart);
                    zs.write(zsOffset + iPartStart - 1, z);
                }
                if (!hasM) continue;
                double m = ms.read(msOffset + iPartStart);
                ms.write(msOffset + iPartStart - 1, m);
            }
        }
    }

    public static org.locationtech.jts.geom.Geometry testIntersection(Polygonal geometry_a, Polygonal geometry_b, double tolerance) {
        TopologicalOperations topoOps = new TopologicalOperations();
        EditShape edit_shape = new EditShape();
        int geom_a = edit_shape.addGeometry(geometry_a);
        int geom_b = edit_shape.addGeometry(geometry_b);
        topoOps.setEditShapeCrackAndCluster(edit_shape, tolerance, null);
        int result = topoOps.intersection(geom_a, geom_b);
        return edit_shape.getJTSGeometry(result);
    }
}

