/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.jts;

import com.geoway.atlas.jts.Envelope2D;
import com.geoway.atlas.jts.Envelope2DIntersectorImpl;
import com.geoway.atlas.jts.GeometryAccelerators;
import com.geoway.atlas.jts.GeometryException;
import com.geoway.atlas.jts.InternalUtils;
import com.geoway.atlas.jts.MultiPathImpl;
import com.geoway.atlas.jts.QuadTreeImpl;
import com.geoway.atlas.jts.Segment;
import com.geoway.atlas.jts.SegmentIteratorImpl;

class PairwiseIntersectorImpl {
    private MultiPathImpl m_multi_path_impl_a;
    private MultiPathImpl m_multi_path_impl_b;
    private boolean m_b_paths;
    private boolean m_b_quad_tree;
    private boolean m_b_done;
    private boolean m_b_swap_elements;
    private double m_tolerance;
    private int m_path_index;
    private int m_element_handle;
    private Envelope2D m_paths_query = new Envelope2D();
    private QuadTreeImpl m_quad_tree;
    private QuadTreeImpl.QuadTreeIteratorImpl m_qt_iter;
    private SegmentIteratorImpl m_seg_iter;
    private Envelope2DIntersectorImpl m_intersector;
    private int m_function;

    PairwiseIntersectorImpl(MultiPathImpl multi_path_impl_a, MultiPathImpl multi_path_impl_b, double tolerance, boolean b_paths) {
        GeometryAccelerators geometry_accelerators_b;
        this.m_multi_path_impl_a = multi_path_impl_a;
        this.m_multi_path_impl_b = multi_path_impl_b;
        this.m_b_paths = b_paths;
        this.m_path_index = -1;
        this.m_b_quad_tree = false;
        GeometryAccelerators geometry_accelerators_a = multi_path_impl_a._getAccelerators();
        if (geometry_accelerators_a != null) {
            QuadTreeImpl qtree_a;
            QuadTreeImpl quadTreeImpl = qtree_a = !b_paths ? geometry_accelerators_a.getQuadTree() : geometry_accelerators_a.getQuadTreeForPaths();
            if (qtree_a != null) {
                this.m_b_done = false;
                this.m_tolerance = tolerance;
                this.m_quad_tree = qtree_a;
                this.m_qt_iter = this.m_quad_tree.getIterator();
                this.m_b_quad_tree = true;
                this.m_b_swap_elements = true;
                this.m_function = 0;
                if (!b_paths) {
                    this.m_seg_iter = multi_path_impl_b.querySegmentIterator();
                } else {
                    this.m_path_index = multi_path_impl_b.getPathCount();
                }
            }
        }
        if (!this.m_b_quad_tree && (geometry_accelerators_b = multi_path_impl_b._getAccelerators()) != null) {
            QuadTreeImpl qtree_b;
            QuadTreeImpl quadTreeImpl = qtree_b = !b_paths ? geometry_accelerators_b.getQuadTree() : geometry_accelerators_b.getQuadTreeForPaths();
            if (qtree_b != null) {
                this.m_b_done = false;
                this.m_tolerance = tolerance;
                this.m_quad_tree = qtree_b;
                this.m_qt_iter = this.m_quad_tree.getIterator();
                this.m_b_quad_tree = true;
                this.m_b_swap_elements = false;
                this.m_function = 0;
                if (!b_paths) {
                    this.m_seg_iter = multi_path_impl_a.querySegmentIterator();
                } else {
                    this.m_path_index = multi_path_impl_a.getPathCount();
                }
            }
        }
        if (!this.m_b_quad_tree) {
            if (!b_paths) {
                this.m_intersector = InternalUtils.getEnvelope2DIntersector(multi_path_impl_a, multi_path_impl_b, tolerance);
            } else {
                boolean b_simple_a = multi_path_impl_a.getIsSimple(0.0) >= 1;
                boolean b_simple_b = multi_path_impl_b.getIsSimple(0.0) >= 1;
                this.m_intersector = InternalUtils.getEnvelope2DIntersectorForParts(multi_path_impl_a, multi_path_impl_b, tolerance, b_simple_a, b_simple_b);
            }
        }
    }

    boolean next() {
        if (this.m_b_quad_tree) {
            if (this.m_b_done) {
                return false;
            }
            boolean b_searching = true;
            block5: while (b_searching) {
                switch (this.m_function) {
                    case 0: {
                        b_searching = this.nextPath_();
                        continue block5;
                    }
                    case 1: {
                        b_searching = this.nextSegment_();
                        continue block5;
                    }
                    case 2: {
                        b_searching = this.iterate_();
                        continue block5;
                    }
                }
                throw GeometryException.GeometryInternalError();
            }
            return !this.m_b_done;
        }
        if (this.m_intersector == null) {
            return false;
        }
        return this.m_intersector.next();
    }

    int getRedElement() {
        if (this.m_b_quad_tree) {
            if (!this.m_b_swap_elements) {
                return !this.m_b_paths ? this.m_seg_iter.getStartPointIndex() : this.m_path_index;
            }
            return this.m_quad_tree.getElement(this.m_element_handle);
        }
        return this.m_intersector.getRedElement(this.m_intersector.getHandleA());
    }

    int getBlueElement() {
        if (this.m_b_quad_tree) {
            if (this.m_b_swap_elements) {
                return !this.m_b_paths ? this.m_seg_iter.getStartPointIndex() : this.m_path_index;
            }
            return this.m_quad_tree.getElement(this.m_element_handle);
        }
        return this.m_intersector.getBlueElement(this.m_intersector.getHandleB());
    }

    Envelope2D getRedEnvelope() {
        if (!this.m_b_paths) {
            throw GeometryException.GeometryInternalError();
        }
        if (this.m_b_quad_tree) {
            if (!this.m_b_swap_elements) {
                return this.m_paths_query;
            }
            return this.m_quad_tree.getElementExtent(this.m_element_handle);
        }
        return this.m_intersector.getRedEnvelope(this.m_intersector.getHandleA());
    }

    Envelope2D getBlueEnvelope() {
        if (!this.m_b_paths) {
            throw GeometryException.GeometryInternalError();
        }
        if (this.m_b_quad_tree) {
            if (this.m_b_swap_elements) {
                return this.m_paths_query;
            }
            return this.m_quad_tree.getElementExtent(this.m_element_handle);
        }
        return this.m_intersector.getBlueEnvelope(this.m_intersector.getHandleB());
    }

    boolean nextPath_() {
        if (!this.m_b_paths) {
            if (!this.m_seg_iter.nextPath()) {
                this.m_b_done = true;
                return false;
            }
            this.m_function = 1;
            return true;
        }
        if (--this.m_path_index == -1) {
            this.m_b_done = true;
            return false;
        }
        if (this.m_b_swap_elements) {
            this.m_multi_path_impl_b.queryPathEnvelope2D(this.m_path_index, this.m_paths_query);
        } else {
            this.m_multi_path_impl_a.queryPathEnvelope2D(this.m_path_index, this.m_paths_query);
        }
        this.m_qt_iter.resetIterator(this.m_paths_query, this.m_tolerance);
        this.m_function = 2;
        return true;
    }

    boolean nextSegment_() {
        if (!this.m_seg_iter.hasNextSegment()) {
            this.m_function = 0;
            return true;
        }
        Segment segment = this.m_seg_iter.nextSegment();
        this.m_qt_iter.resetIterator(segment, this.m_tolerance);
        this.m_function = 2;
        return true;
    }

    boolean iterate_() {
        this.m_element_handle = this.m_qt_iter.next();
        if (this.m_element_handle == -1) {
            this.m_function = !this.m_b_paths ? 1 : 0;
            return true;
        }
        return false;
    }

    private static interface State {
        public static final int nextPath = 0;
        public static final int nextSegment = 1;
        public static final int iterate = 2;
    }
}

