/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.overlayng;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.locationtech.jts.operation.overlayng.OverlayNG;

public class PrecisionReducer {
    public static Geometry reducePrecision(Geometry geom, PrecisionModel pm) {
        OverlayNG ov = new OverlayNG(geom, pm);
        if (geom.getDimension() == 2) {
            ov.setAreaResultOnly(true);
        }
        try {
            Geometry reduced = ov.getResult();
            return reduced;
        }
        catch (TopologyException ex) {
            Geometry fixGeo;
            try {
                fixGeo = GeometryFixer.fix(geom);
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("Reduction failed, possible invalid input");
            }
            ov = new OverlayNG(fixGeo, pm);
            if (geom.getDimension() == 2) {
                ov.setAreaResultOnly(true);
            }
            try {
                return ov.getResult();
            }
            catch (Throwable throwable) {
                throw new IllegalArgumentException("Reduction failed, possible invalid input");
            }
        }
    }

    private PrecisionReducer() {
    }
}

