/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.jts;

import com.geoway.atlas.jts.AttributeStreamBase;
import com.geoway.atlas.jts.AttributeStreamOfDbl;
import com.geoway.atlas.jts.AttributeStreamOfInt32;
import com.geoway.atlas.jts.AttributeStreamOfInt8;
import com.geoway.atlas.jts.GeoJsonCrsTables;
import com.geoway.atlas.jts.Geometry;
import com.geoway.atlas.jts.GeometryException;
import com.geoway.atlas.jts.InternalUtils;
import com.geoway.atlas.jts.JsonGeometryException;
import com.geoway.atlas.jts.JsonParserReader;
import com.geoway.atlas.jts.JsonReader;
import com.geoway.atlas.jts.MapGeometry;
import com.geoway.atlas.jts.MapOGCStructure;
import com.geoway.atlas.jts.MultiPathImpl;
import com.geoway.atlas.jts.MultiPoint;
import com.geoway.atlas.jts.MultiPointImpl;
import com.geoway.atlas.jts.NumberUtils;
import com.geoway.atlas.jts.OGCStructure;
import com.geoway.atlas.jts.OperatorImportFromGeoJson;
import com.geoway.atlas.jts.Point;
import com.geoway.atlas.jts.Point2D;
import com.geoway.atlas.jts.Polygon;
import com.geoway.atlas.jts.Polyline;
import com.geoway.atlas.jts.ProgressTracker;
import com.geoway.atlas.jts.SpatialReference;
import com.geoway.atlas.jts.VertexDescription;
import java.util.ArrayList;

class OperatorImportFromGeoJsonLocal
extends OperatorImportFromGeoJson {
    OperatorImportFromGeoJsonLocal() {
    }

    @Override
    public MapGeometry execute(int importFlags, Geometry.Type type, String geoJsonString, ProgressTracker progressTracker) throws JsonGeometryException {
        MapGeometry map_geometry = OperatorImportFromGeoJsonHelper.importFromGeoJson(importFlags, type, JsonParserReader.createFromString(geoJsonString), progressTracker, false);
        return map_geometry;
    }

    @Override
    public MapGeometry execute(int importFlags, Geometry.Type type, JsonReader jsonReader, ProgressTracker progressTracker) throws JsonGeometryException {
        if (jsonReader == null) {
            return null;
        }
        return OperatorImportFromGeoJsonHelper.importFromGeoJson(importFlags, type, jsonReader, progressTracker, false);
    }

    @Override
    public MapOGCStructure executeOGC(int import_flags, String geoJsonString, ProgressTracker progress_tracker) throws JsonGeometryException {
        return this.executeOGC(import_flags, JsonParserReader.createFromString(geoJsonString), progress_tracker);
    }

    public MapOGCStructure executeOGC(int import_flags, JsonReader json_iterator, ProgressTracker progress_tracker) throws JsonGeometryException {
        MapOGCStructure mapOGCStructure = OperatorImportFromGeoJsonHelper.importFromGeoJson(import_flags, Geometry.Type.Unknown, json_iterator, progress_tracker, false, 0);
        MapOGCStructure res = new MapOGCStructure();
        res.m_ogcStructure = new OGCStructure();
        res.m_ogcStructure.m_type = 0;
        res.m_ogcStructure.m_structures = new ArrayList<OGCStructure>();
        res.m_ogcStructure.m_structures.add(mapOGCStructure.m_ogcStructure);
        res.m_spatialReference = mapOGCStructure.m_spatialReference;
        return res;
    }

    static final class OperatorImportFromGeoJsonHelper {
        private AttributeStreamOfDbl m_position = null;
        private AttributeStreamOfDbl m_zs = null;
        private AttributeStreamOfDbl m_ms = null;
        private AttributeStreamOfInt32 m_paths = null;
        private AttributeStreamOfInt8 m_path_flags = null;
        private Point m_point = null;
        private boolean m_b_has_zs = false;
        private boolean m_b_has_ms = false;
        private boolean m_b_has_zs_known = false;
        private boolean m_b_has_ms_known = false;
        private int m_num_embeddings = 0;
        int m_ogcType = 0;

        OperatorImportFromGeoJsonHelper() {
        }

        static MapGeometry importFromGeoJson(int importFlags, Geometry.Type type, JsonReader json_iterator, ProgressTracker progress_tracker, boolean skip_coordinates) throws JsonGeometryException {
            OperatorImportFromGeoJsonHelper geo_json_helper = new OperatorImportFromGeoJsonHelper();
            MapOGCStructure ms = geo_json_helper.importFromGeoJsonImpl(importFlags, type, json_iterator, progress_tracker, skip_coordinates, 0);
            if (geo_json_helper.m_ogcType == GeoJsonValues.GeometryCollection && !skip_coordinates) {
                throw new JsonGeometryException("parsing error");
            }
            return new MapGeometry(ms.m_ogcStructure.m_geometry, ms.m_spatialReference);
        }

        static MapOGCStructure importFromGeoJson(int importFlags, Geometry.Type type, JsonReader json_iterator, ProgressTracker progress_tracker, boolean skip_coordinates, int recursion) throws JsonGeometryException {
            OperatorImportFromGeoJsonHelper geo_json_helper = new OperatorImportFromGeoJsonHelper();
            MapOGCStructure ms = geo_json_helper.importFromGeoJsonImpl(importFlags, type, json_iterator, progress_tracker, skip_coordinates, recursion);
            if (geo_json_helper.m_ogcType == GeoJsonValues.GeometryCollection && !skip_coordinates) {
                throw new JsonGeometryException("parsing error");
            }
            return ms;
        }

        MapOGCStructure importFromGeoJsonImpl(int importFlags, Geometry.Type type, JsonReader json_iterator, ProgressTracker progress_tracker, boolean skip_coordinates, int recursion) throws JsonGeometryException {
            JsonReader.Token current_token;
            OperatorImportFromGeoJsonHelper geo_json_helper = this;
            boolean b_type_found = false;
            boolean b_coordinates_found = false;
            boolean b_crs_found = false;
            boolean b_crsURN_found = false;
            boolean b_geometry_collection = false;
            boolean b_geometries_found = false;
            GeoJsonType geo_json_type = null;
            Geometry geometry = null;
            SpatialReference spatial_reference = null;
            String field_name = null;
            MapOGCStructure ms = new MapOGCStructure();
            while ((current_token = json_iterator.nextToken()) != JsonReader.Token.END_OBJECT) {
                field_name = json_iterator.currentString();
                if (field_name.equals("type")) {
                    if (b_type_found) {
                        throw new JsonGeometryException("parsing error");
                    }
                    b_type_found = true;
                    current_token = json_iterator.nextToken();
                    if (current_token != JsonReader.Token.VALUE_STRING) {
                        throw new JsonGeometryException("parsing error");
                    }
                    String s = json_iterator.currentString();
                    try {
                        geo_json_type = GeoJsonType.valueOf(s);
                    }
                    catch (Exception ex) {
                        throw new JsonGeometryException(s);
                    }
                    if (geo_json_type != GeoJsonType.GeometryCollection) continue;
                    if (type != Geometry.Type.Unknown) {
                        throw new JsonGeometryException("parsing error");
                    }
                    b_geometry_collection = true;
                    continue;
                }
                if (field_name.equals("geometries")) {
                    b_geometries_found = true;
                    if (type != Geometry.Type.Unknown) {
                        throw new JsonGeometryException("parsing error");
                    }
                    if (recursion > 10) {
                        throw new JsonGeometryException("deep geojson");
                    }
                    if (skip_coordinates) {
                        json_iterator.skipChildren();
                        continue;
                    }
                    current_token = json_iterator.nextToken();
                    ms.m_ogcStructure = new OGCStructure();
                    ms.m_ogcStructure.m_type = GeoJsonValues.GeometryCollection;
                    ms.m_ogcStructure.m_structures = new ArrayList<OGCStructure>(0);
                    if (current_token == JsonReader.Token.START_ARRAY) {
                        current_token = json_iterator.nextToken();
                        while (current_token != JsonReader.Token.END_ARRAY) {
                            MapOGCStructure child = OperatorImportFromGeoJsonHelper.importFromGeoJson(importFlags | 8, type, json_iterator, progress_tracker, false, recursion + 1);
                            ms.m_ogcStructure.m_structures.add(child.m_ogcStructure);
                            current_token = json_iterator.nextToken();
                        }
                        continue;
                    }
                    if (current_token == JsonReader.Token.VALUE_NULL) continue;
                    throw new JsonGeometryException("parsing error");
                }
                if (field_name.equals("coordinates")) {
                    if (b_coordinates_found) {
                        throw new JsonGeometryException("parsing error");
                    }
                    b_coordinates_found = true;
                    current_token = json_iterator.nextToken();
                    if (skip_coordinates) {
                        json_iterator.skipChildren();
                        continue;
                    }
                    if (current_token == JsonReader.Token.VALUE_NULL) continue;
                    if (current_token != JsonReader.Token.START_ARRAY) {
                        throw new JsonGeometryException("parsing error");
                    }
                    geo_json_helper.import_coordinates_(json_iterator, progress_tracker);
                    continue;
                }
                if (field_name.equals("crs")) {
                    if (b_crs_found || b_crsURN_found) {
                        throw new JsonGeometryException("parsing error");
                    }
                    b_crs_found = true;
                    current_token = json_iterator.nextToken();
                    if ((importFlags & 8) == 0) {
                        spatial_reference = OperatorImportFromGeoJsonHelper.importSpatialReferenceFromCrs(json_iterator, progress_tracker);
                        continue;
                    }
                    json_iterator.skipChildren();
                    continue;
                }
                if (field_name.equals("crsURN")) {
                    if (b_crs_found || b_crsURN_found) {
                        throw new JsonGeometryException("parsing error");
                    }
                    b_crsURN_found = true;
                    current_token = json_iterator.nextToken();
                    spatial_reference = OperatorImportFromGeoJsonHelper.importSpatialReferenceFromCrsUrn_(json_iterator, progress_tracker);
                    continue;
                }
                json_iterator.nextToken();
                json_iterator.skipChildren();
            }
            if (!b_type_found || !b_geometry_collection && !b_coordinates_found && !skip_coordinates) {
                throw new JsonGeometryException("parsing error");
            }
            if (!b_geometry_collection && b_geometries_found || b_geometry_collection && !b_geometries_found) {
                throw new JsonGeometryException("parsing error");
            }
            if (!skip_coordinates && !b_geometry_collection) {
                geometry = geo_json_helper.createGeometry_(geo_json_type, type.value());
                ms.m_ogcStructure = new OGCStructure();
                ms.m_ogcStructure.m_type = this.m_ogcType;
                ms.m_ogcStructure.m_geometry = geometry;
            }
            if (!b_crs_found && !b_crsURN_found && (importFlags & 8) == 0 && (importFlags & 0x10) == 0) {
                spatial_reference = SpatialReference.create(4326);
            }
            ms.m_spatialReference = spatial_reference;
            return ms;
        }

        private void import_coordinates_(JsonReader json_iterator, ProgressTracker progress_tracker) throws JsonGeometryException {
            assert (json_iterator.currentToken() == JsonReader.Token.START_ARRAY);
            int coordinates_level_lower = 1;
            int coordinates_level_upper = 4;
            json_iterator.nextToken();
            while (json_iterator.currentToken() != JsonReader.Token.END_ARRAY) {
                if (this.isDouble_(json_iterator)) {
                    if (coordinates_level_upper > 1) {
                        coordinates_level_upper = 1;
                    }
                } else if (json_iterator.currentToken() == JsonReader.Token.START_ARRAY) {
                    if (coordinates_level_lower < 2) {
                        coordinates_level_lower = 2;
                    }
                } else {
                    throw new JsonGeometryException("parsing error");
                }
                if (coordinates_level_lower > coordinates_level_upper) {
                    throw new IllegalArgumentException("invalid argument");
                }
                if (coordinates_level_lower == coordinates_level_upper && coordinates_level_lower == 1) {
                    this.readCoordinateAsPoint_(json_iterator);
                    continue;
                }
                boolean b_add_path_level_3 = true;
                boolean b_polygon_start_level_4 = true;
                assert (json_iterator.currentToken() == JsonReader.Token.START_ARRAY);
                json_iterator.nextToken();
                while (json_iterator.currentToken() != JsonReader.Token.END_ARRAY) {
                    if (this.isDouble_(json_iterator)) {
                        if (coordinates_level_upper > 2) {
                            coordinates_level_upper = 2;
                        }
                    } else if (json_iterator.currentToken() == JsonReader.Token.START_ARRAY) {
                        if (coordinates_level_lower < 3) {
                            coordinates_level_lower = 3;
                        }
                    } else {
                        throw new JsonGeometryException("parsing error");
                    }
                    if (coordinates_level_lower > coordinates_level_upper) {
                        throw new JsonGeometryException("parsing error");
                    }
                    if (coordinates_level_lower == coordinates_level_upper && coordinates_level_lower == 2) {
                        this.addCoordinate_(json_iterator);
                        continue;
                    }
                    boolean b_add_path_level_4 = true;
                    assert (json_iterator.currentToken() == JsonReader.Token.START_ARRAY);
                    json_iterator.nextToken();
                    while (json_iterator.currentToken() != JsonReader.Token.END_ARRAY) {
                        if (this.isDouble_(json_iterator)) {
                            if (coordinates_level_upper > 3) {
                                coordinates_level_upper = 3;
                            }
                        } else if (json_iterator.currentToken() == JsonReader.Token.START_ARRAY) {
                            if (coordinates_level_lower < 4) {
                                coordinates_level_lower = 4;
                            }
                        } else {
                            throw new JsonGeometryException("parsing error");
                        }
                        if (coordinates_level_lower > coordinates_level_upper) {
                            throw new JsonGeometryException("parsing error");
                        }
                        if (coordinates_level_lower == coordinates_level_upper && coordinates_level_lower == 3) {
                            if (b_add_path_level_3) {
                                this.addPath_();
                                b_add_path_level_3 = false;
                            }
                            this.addCoordinate_(json_iterator);
                            continue;
                        }
                        assert (json_iterator.currentToken() == JsonReader.Token.START_ARRAY);
                        json_iterator.nextToken();
                        if (json_iterator.currentToken() != JsonReader.Token.END_ARRAY) {
                            if (!this.isDouble_(json_iterator)) {
                                throw new JsonGeometryException("parsing error");
                            }
                            assert (coordinates_level_lower == coordinates_level_upper && coordinates_level_lower == 4);
                            if (b_add_path_level_4) {
                                this.addPath_();
                                this.addPathFlag_(b_polygon_start_level_4);
                                b_add_path_level_4 = false;
                                b_polygon_start_level_4 = false;
                            }
                            this.addCoordinate_(json_iterator);
                        }
                        json_iterator.nextToken();
                    }
                    json_iterator.nextToken();
                }
                json_iterator.nextToken();
            }
            if (this.m_paths != null) {
                this.m_paths.add(this.m_position.size() / 2);
            }
            if (this.m_path_flags != null) {
                this.m_path_flags.add((byte)0);
            }
            this.m_num_embeddings = coordinates_level_lower;
        }

        private void readCoordinateAsPoint_(JsonReader json_iterator) throws JsonGeometryException {
            assert (this.isDouble_(json_iterator));
            this.m_point = new Point();
            double x = this.readDouble_(json_iterator);
            json_iterator.nextToken();
            double y = this.readDouble_(json_iterator);
            json_iterator.nextToken();
            if (NumberUtils.isNaN(y)) {
                x = NumberUtils.NaN();
            }
            this.m_point.setXY(x, y);
            if (this.isDouble_(json_iterator)) {
                double z = this.readDouble_(json_iterator);
                json_iterator.nextToken();
                this.m_point.setZ(z);
            }
            if (this.isDouble_(json_iterator)) {
                double m = this.readDouble_(json_iterator);
                json_iterator.nextToken();
                this.m_point.setM(m);
            }
            if (json_iterator.currentToken() != JsonReader.Token.END_ARRAY) {
                throw new JsonGeometryException("parsing error");
            }
        }

        private void addCoordinate_(JsonReader json_iterator) throws JsonGeometryException {
            assert (this.isDouble_(json_iterator));
            if (this.m_position == null) {
                this.m_position = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0);
            }
            double x = this.readDouble_(json_iterator);
            json_iterator.nextToken();
            double y = this.readDouble_(json_iterator);
            json_iterator.nextToken();
            int size = this.m_position.size();
            this.m_position.add(x);
            this.m_position.add(y);
            if (this.isDouble_(json_iterator)) {
                if (!this.m_b_has_zs_known) {
                    this.m_b_has_zs_known = true;
                    this.m_b_has_zs = true;
                    this.m_zs = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0);
                } else if (!this.m_b_has_zs) {
                    this.m_zs = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(size >> 1, VertexDescription.getDefaultValue(1));
                    this.m_b_has_zs = true;
                }
                double z = this.readDouble_(json_iterator);
                json_iterator.nextToken();
                this.m_zs.add(z);
            } else if (!this.m_b_has_zs_known) {
                this.m_b_has_zs_known = true;
                this.m_b_has_zs = false;
            } else if (this.m_b_has_zs) {
                this.m_zs.add(VertexDescription.getDefaultValue(1));
            }
            if (this.isDouble_(json_iterator)) {
                if (!this.m_b_has_ms_known) {
                    this.m_b_has_ms_known = true;
                    this.m_b_has_ms = true;
                    this.m_ms = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(0);
                } else if (!this.m_b_has_ms) {
                    this.m_ms = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(size >> 1, VertexDescription.getDefaultValue(2));
                    this.m_b_has_ms = true;
                }
                double m = this.readDouble_(json_iterator);
                json_iterator.nextToken();
                this.m_ms.add(m);
            } else if (!this.m_b_has_ms_known) {
                this.m_b_has_ms_known = true;
                this.m_b_has_ms = false;
            } else if (this.m_b_has_ms) {
                this.m_zs.add(VertexDescription.getDefaultValue(2));
            }
            if (json_iterator.currentToken() != JsonReader.Token.END_ARRAY) {
                throw new JsonGeometryException("parsing error");
            }
        }

        private void addPath_() {
            if (this.m_paths == null) {
                this.m_paths = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(0);
            }
            if (this.m_position == null) {
                this.m_paths.add(0);
            } else {
                this.m_paths.add(this.m_position.size() / 2);
            }
        }

        private void addPathFlag_(boolean b_polygon_start) {
            if (this.m_path_flags == null) {
                this.m_path_flags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(0);
            }
            if (b_polygon_start) {
                this.m_path_flags.add((byte)5);
            } else {
                this.m_path_flags.add((byte)1);
            }
        }

        private double readDouble_(JsonReader json_iterator) throws JsonGeometryException {
            JsonReader.Token current_token = json_iterator.currentToken();
            if (current_token == JsonReader.Token.VALUE_NULL || current_token == JsonReader.Token.VALUE_STRING && json_iterator.currentString().equals("NaN")) {
                return NumberUtils.NaN();
            }
            return json_iterator.currentDoubleValue();
        }

        private boolean isDouble_(JsonReader json_iterator) throws JsonGeometryException {
            JsonReader.Token current_token = json_iterator.currentToken();
            if (current_token == JsonReader.Token.VALUE_NUMBER_FLOAT) {
                return true;
            }
            if (current_token == JsonReader.Token.VALUE_NUMBER_INT) {
                return true;
            }
            return current_token == JsonReader.Token.VALUE_NULL || current_token == JsonReader.Token.VALUE_STRING && json_iterator.currentString().equals("NaN");
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Geometry createGeometry_(GeoJsonType geo_json_type, int type) throws JsonGeometryException {
            void var3_15;
            if (type != 0) {
                switch (type) {
                    case 1736: {
                        if (geo_json_type == GeoJsonType.MultiPolygon || geo_json_type == GeoJsonType.Polygon) break;
                        throw new GeometryException("invalid shape type");
                    }
                    case 1607: {
                        if (geo_json_type == GeoJsonType.MultiLineString || geo_json_type == GeoJsonType.LineString) break;
                        throw new GeometryException("invalid shape type");
                    }
                    case 550: {
                        if (geo_json_type == GeoJsonType.MultiPoint) break;
                        throw new GeometryException("invalid shape type");
                    }
                    case 33: {
                        if (geo_json_type == GeoJsonType.Point) break;
                        throw new GeometryException("invalid shape type");
                    }
                    default: {
                        throw new GeometryException("invalid shape type");
                    }
                }
            }
            this.m_ogcType = geo_json_type.geogsjonvalue();
            if (geo_json_type == GeoJsonType.GeometryCollection) {
                throw new IllegalArgumentException("invalid argument");
            }
            if (this.m_position == null && this.m_point == null) {
                switch (geo_json_type) {
                    case Point: {
                        if (this.m_num_embeddings > 1) {
                            throw new JsonGeometryException("parsing error");
                        }
                        Point point = new Point();
                        return var3_15;
                    }
                    case MultiPoint: {
                        if (this.m_num_embeddings > 2) {
                            throw new JsonGeometryException("parsing error");
                        }
                        MultiPoint multiPoint = new MultiPoint();
                        return var3_15;
                    }
                    case LineString: {
                        if (this.m_num_embeddings > 2) {
                            throw new JsonGeometryException("parsing error");
                        }
                        Polyline polyline = new Polyline();
                        return var3_15;
                    }
                    case MultiLineString: {
                        if (this.m_num_embeddings > 3) {
                            throw new JsonGeometryException("parsing error");
                        }
                        Polyline polyline = new Polyline();
                        return var3_15;
                    }
                    case Polygon: {
                        if (this.m_num_embeddings > 3) {
                            throw new JsonGeometryException("parsing error");
                        }
                        Polygon polygon = new Polygon();
                        return var3_15;
                    }
                    case MultiPolygon: {
                        assert (this.m_num_embeddings <= 4);
                        Polygon polygon = new Polygon();
                        return var3_15;
                    }
                    default: {
                        throw new JsonGeometryException("parsing error");
                    }
                }
            }
            if (this.m_num_embeddings == 1) {
                if (geo_json_type != GeoJsonType.Point) {
                    throw new JsonGeometryException("parsing error");
                }
                assert (this.m_point != null);
                Point point = this.m_point;
                return var3_15;
            } else if (this.m_num_embeddings == 2) {
                if (geo_json_type == GeoJsonType.MultiPoint) {
                    Geometry geometry = this.createMultiPointFromStreams_();
                    return var3_15;
                } else {
                    if (geo_json_type != GeoJsonType.LineString) throw new JsonGeometryException("parsing error");
                    Geometry geometry = this.createPolylineFromStreams_();
                }
                return var3_15;
            } else if (this.m_num_embeddings == 3) {
                if (geo_json_type == GeoJsonType.Polygon) {
                    Geometry geometry = this.createPolygonFromStreams_();
                    return var3_15;
                } else {
                    if (geo_json_type != GeoJsonType.MultiLineString) throw new JsonGeometryException("parsing error");
                    Geometry geometry = this.createPolylineFromStreams_();
                }
                return var3_15;
            } else {
                if (geo_json_type != GeoJsonType.MultiPolygon) {
                    throw new JsonGeometryException("parsing error");
                }
                Geometry geometry = this.createPolygonFromStreams_();
            }
            return var3_15;
        }

        private Geometry createPolygonFromStreams_() {
            assert (this.m_position != null);
            assert (this.m_paths != null);
            assert (this.m_num_embeddings == 3 && this.m_path_flags == null || this.m_num_embeddings == 4 && this.m_path_flags != null);
            Polygon polygon = new Polygon();
            MultiPathImpl multi_path_impl = (MultiPathImpl)polygon._getImpl();
            this.checkPathPointCountsForMultiPath_(true);
            multi_path_impl.setAttributeStreamRef(0, this.m_position);
            if (this.m_b_has_zs) {
                assert (this.m_zs != null);
                multi_path_impl.setAttributeStreamRef(1, this.m_zs);
            }
            if (this.m_b_has_ms) {
                assert (this.m_ms != null);
                multi_path_impl.setAttributeStreamRef(2, this.m_ms);
            }
            if (this.m_path_flags == null) {
                this.m_path_flags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(this.m_paths.size(), (byte)0);
                this.m_path_flags.setBits(0, (byte)5);
                for (int i = 1; i < this.m_path_flags.size() - 1; ++i) {
                    this.m_path_flags.setBits(i, (byte)1);
                }
            }
            multi_path_impl.setPathStreamRef(this.m_paths);
            multi_path_impl.setPathFlagsStreamRef(this.m_path_flags);
            multi_path_impl.notifyModified(0xFFFFFF);
            AttributeStreamOfInt8 path_flags_clone = new AttributeStreamOfInt8(this.m_path_flags);
            for (int i = 0; i < path_flags_clone.size() - 1; ++i) {
                assert ((path_flags_clone.read(i) & 1) != 0);
                assert ((this.m_path_flags.read(i) & 1) != 0);
                if ((path_flags_clone.read(i) & 4) != 0) {
                    if (InternalUtils.isClockwiseRing(multi_path_impl, i)) continue;
                    multi_path_impl.reversePath(i);
                    continue;
                }
                if (!InternalUtils.isClockwiseRing(multi_path_impl, i)) continue;
                multi_path_impl.reversePath(i);
            }
            multi_path_impl.setPathFlagsStreamRef(path_flags_clone);
            multi_path_impl.clearDirtyOGCFlags();
            return polygon;
        }

        private Geometry createPolylineFromStreams_() {
            assert (this.m_position != null);
            assert (this.m_num_embeddings == 2 && this.m_paths == null || this.m_num_embeddings == 3 && this.m_paths != null);
            assert (this.m_path_flags == null);
            Polyline polyline = new Polyline();
            MultiPathImpl multi_path_impl = (MultiPathImpl)polyline._getImpl();
            if (this.m_paths == null) {
                this.m_paths = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(0);
                this.m_paths.add(0);
                this.m_paths.add(this.m_position.size() / 2);
            }
            this.checkPathPointCountsForMultiPath_(false);
            multi_path_impl.setAttributeStreamRef(0, this.m_position);
            if (this.m_b_has_zs) {
                assert (this.m_zs != null);
                multi_path_impl.setAttributeStreamRef(1, this.m_zs);
            }
            if (this.m_b_has_ms) {
                assert (this.m_ms != null);
                multi_path_impl.setAttributeStreamRef(2, this.m_ms);
            }
            this.m_path_flags = (AttributeStreamOfInt8)AttributeStreamBase.createByteStream(this.m_paths.size(), (byte)0);
            multi_path_impl.setPathStreamRef(this.m_paths);
            multi_path_impl.setPathFlagsStreamRef(this.m_path_flags);
            multi_path_impl.notifyModified(0xFFFFFF);
            return polyline;
        }

        private Geometry createMultiPointFromStreams_() {
            assert (this.m_position != null);
            assert (this.m_paths == null);
            assert (this.m_path_flags == null);
            MultiPoint multi_point = new MultiPoint();
            MultiPointImpl multi_point_impl = (MultiPointImpl)multi_point._getImpl();
            multi_point_impl.setAttributeStreamRef(0, this.m_position);
            if (this.m_b_has_zs) {
                assert (this.m_zs != null);
                multi_point_impl.setAttributeStreamRef(1, this.m_zs);
            }
            if (this.m_b_has_ms) {
                assert (this.m_ms != null);
                multi_point_impl.setAttributeStreamRef(2, this.m_ms);
            }
            multi_point_impl.resize(this.m_position.size() / 2);
            multi_point_impl.notifyModified(0xFFFFFF);
            return multi_point;
        }

        private void checkPathPointCountsForMultiPath_(boolean b_is_polygon) {
            Point2D pt1 = new Point2D();
            Point2D pt2 = new Point2D();
            double z1 = 0.0;
            double z2 = 0.0;
            double m1 = 0.0;
            double m2 = 0.0;
            int path_count = this.m_paths.size() - 1;
            int guess_adjustment = 0;
            if (b_is_polygon) {
                guess_adjustment = path_count;
            } else {
                for (int path = 0; path < path_count; ++path) {
                    int path_size = this.m_paths.read(path + 1) - this.m_paths.read(path);
                    if (path_size != 1) continue;
                    --guess_adjustment;
                }
                if (guess_adjustment == 0) {
                    return;
                }
            }
            AttributeStreamOfDbl adjusted_position = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(this.m_position.size() - guess_adjustment);
            AttributeStreamOfInt32 adjusted_paths = (AttributeStreamOfInt32)AttributeStreamBase.createIndexStream(this.m_paths.size());
            AttributeStreamOfDbl adjusted_zs = null;
            AttributeStreamOfDbl adjusted_ms = null;
            if (this.m_b_has_zs) {
                adjusted_zs = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(this.m_zs.size() - guess_adjustment);
            }
            if (this.m_b_has_ms) {
                adjusted_ms = (AttributeStreamOfDbl)AttributeStreamBase.createDoubleStream(this.m_ms.size() - guess_adjustment);
            }
            int adjusted_start = 0;
            adjusted_paths.write(0, 0);
            for (int path = 0; path < path_count; ++path) {
                int path_start = this.m_paths.read(path);
                int path_end = this.m_paths.read(path + 1);
                int path_size = path_end - path_start;
                assert (path_size != 0);
                if (path_size == 1) {
                    this.insertIntoAdjustedStreams_(adjusted_position, adjusted_zs, adjusted_ms, adjusted_start, path_start, path_size);
                    this.insertIntoAdjustedStreams_(adjusted_position, adjusted_zs, adjusted_ms, adjusted_start + 1, path_start, path_size);
                    adjusted_start += 2;
                } else if (path_size >= 3 && b_is_polygon) {
                    this.m_position.read(path_start * 2, pt1);
                    this.m_position.read((path_end - 1) * 2, pt2);
                    if (this.m_b_has_zs) {
                        z1 = this.m_zs.readAsDbl(path_start);
                        z2 = this.m_zs.readAsDbl(path_end - 1);
                    }
                    if (this.m_b_has_ms) {
                        m1 = this.m_ms.readAsDbl(path_start);
                        m2 = this.m_ms.readAsDbl(path_end - 1);
                    }
                    if (pt1.equals(pt2) && (NumberUtils.isNaN(z1) && NumberUtils.isNaN(z2) || z1 == z2) && (NumberUtils.isNaN(m1) && NumberUtils.isNaN(m2) || m1 == m2)) {
                        this.insertIntoAdjustedStreams_(adjusted_position, adjusted_zs, adjusted_ms, adjusted_start, path_start, path_size - 1);
                        adjusted_start += path_size - 1;
                    } else {
                        this.insertIntoAdjustedStreams_(adjusted_position, adjusted_zs, adjusted_ms, adjusted_start, path_start, path_size);
                        adjusted_start += path_size;
                    }
                } else {
                    this.insertIntoAdjustedStreams_(adjusted_position, adjusted_zs, adjusted_ms, adjusted_start, path_start, path_size);
                    adjusted_start += path_size;
                }
                adjusted_paths.write(path + 1, adjusted_start);
            }
            this.m_position = adjusted_position;
            this.m_paths = adjusted_paths;
            this.m_zs = adjusted_zs;
            this.m_ms = adjusted_ms;
        }

        private void insertIntoAdjustedStreams_(AttributeStreamOfDbl adjusted_position, AttributeStreamOfDbl adjusted_zs, AttributeStreamOfDbl adjusted_ms, int adjusted_start, int path_start, int count) {
            adjusted_position.insertRange(adjusted_start * 2, this.m_position, path_start * 2, count * 2, true, 2, adjusted_start * 2);
            if (this.m_b_has_zs) {
                adjusted_zs.insertRange(adjusted_start, this.m_zs, path_start, count, true, 1, adjusted_start);
            }
            if (this.m_b_has_ms) {
                adjusted_ms.insertRange(adjusted_start, this.m_ms, path_start, count, true, 1, adjusted_start);
            }
        }

        static SpatialReference importSpatialReferenceFromCrs(JsonReader json_iterator, ProgressTracker progress_tracker) throws JsonGeometryException {
            if (json_iterator.currentToken() == JsonReader.Token.VALUE_NULL) {
                return null;
            }
            if (json_iterator.currentToken() == JsonReader.Token.VALUE_STRING) {
                String crs_short_form = json_iterator.currentString();
                int wkid = GeoJsonCrsTables.getWkidFromCrsShortForm(crs_short_form);
                if (wkid == -1) {
                    throw new GeometryException("not implemented");
                }
                SpatialReference spatial_reference = null;
                try {
                    spatial_reference = SpatialReference.create(wkid);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return spatial_reference;
            }
            if (json_iterator.currentToken() != JsonReader.Token.START_OBJECT) {
                throw new JsonGeometryException("parsing error");
            }
            boolean b_found_type = false;
            boolean b_found_properties = false;
            boolean b_found_properties_name = false;
            boolean b_found_properties_href = false;
            boolean b_found_properties_urn = false;
            boolean b_found_properties_url = false;
            boolean b_found_properties_code = false;
            boolean b_found_esriwkt = false;
            String crs_field = null;
            String properties_field = null;
            String crs_identifier_name = null;
            String crs_identifier_urn = null;
            String crs_identifier_href = null;
            String crs_identifier_url = null;
            String esriwkt = null;
            int crs_identifier_code = -1;
            while (json_iterator.nextToken() != JsonReader.Token.END_OBJECT) {
                JsonReader.Token current_token;
                crs_field = json_iterator.currentString();
                if (crs_field.equals("type")) {
                    if (b_found_type) {
                        throw new JsonGeometryException("parsing error");
                    }
                    b_found_type = true;
                    current_token = json_iterator.nextToken();
                    if (current_token == JsonReader.Token.VALUE_STRING) continue;
                    throw new JsonGeometryException("parsing error");
                }
                if (crs_field.equals("properties")) {
                    if (b_found_properties) {
                        throw new JsonGeometryException("parsing error");
                    }
                    b_found_properties = true;
                    current_token = json_iterator.nextToken();
                    if (current_token != JsonReader.Token.START_OBJECT) {
                        throw new JsonGeometryException("parsing error");
                    }
                    while (json_iterator.nextToken() != JsonReader.Token.END_OBJECT) {
                        properties_field = json_iterator.currentString();
                        if (properties_field.equals("name")) {
                            if (b_found_properties_name) {
                                throw new JsonGeometryException("parsing error");
                            }
                            b_found_properties_name = true;
                            crs_identifier_name = OperatorImportFromGeoJsonHelper.getCrsIdentifier_(json_iterator);
                            continue;
                        }
                        if (properties_field.equals("href")) {
                            if (b_found_properties_href) {
                                throw new JsonGeometryException("parsing error");
                            }
                            b_found_properties_href = true;
                            crs_identifier_href = OperatorImportFromGeoJsonHelper.getCrsIdentifier_(json_iterator);
                            continue;
                        }
                        if (properties_field.equals("urn")) {
                            if (b_found_properties_urn) {
                                throw new JsonGeometryException("parsing error");
                            }
                            b_found_properties_urn = true;
                            crs_identifier_urn = OperatorImportFromGeoJsonHelper.getCrsIdentifier_(json_iterator);
                            continue;
                        }
                        if (properties_field.equals("url")) {
                            if (b_found_properties_url) {
                                throw new JsonGeometryException("parsing error");
                            }
                            b_found_properties_url = true;
                            crs_identifier_url = OperatorImportFromGeoJsonHelper.getCrsIdentifier_(json_iterator);
                            continue;
                        }
                        if (properties_field.equals("code")) {
                            if (b_found_properties_code) {
                                throw new JsonGeometryException("parsing error");
                            }
                            b_found_properties_code = true;
                            current_token = json_iterator.nextToken();
                            if (current_token != JsonReader.Token.VALUE_NUMBER_INT) {
                                throw new JsonGeometryException("parsing error");
                            }
                            crs_identifier_code = json_iterator.currentIntValue();
                            continue;
                        }
                        json_iterator.nextToken();
                        json_iterator.skipChildren();
                    }
                    continue;
                }
                if (crs_field.equals("esriwkt")) {
                    if (b_found_esriwkt) {
                        throw new JsonGeometryException("parsing error");
                    }
                    b_found_esriwkt = true;
                    current_token = json_iterator.nextToken();
                    if (current_token != JsonReader.Token.VALUE_STRING) {
                        throw new JsonGeometryException("parsing error");
                    }
                    esriwkt = json_iterator.currentString();
                    continue;
                }
                json_iterator.nextToken();
                json_iterator.skipChildren();
            }
            if (!(b_found_type && b_found_properties || b_found_esriwkt)) {
                throw new JsonGeometryException("parsing error");
            }
            int wkid = -1;
            if (b_found_properties_name) {
                wkid = GeoJsonCrsTables.getWkidFromCrsName(crs_identifier_name);
            } else if (b_found_properties_href) {
                wkid = GeoJsonCrsTables.getWkidFromCrsHref(crs_identifier_href);
            } else if (b_found_properties_urn) {
                wkid = GeoJsonCrsTables.getWkidFromCrsOgcUrn(crs_identifier_urn);
            } else if (b_found_properties_url) {
                wkid = GeoJsonCrsTables.getWkidFromCrsHref(crs_identifier_url);
            } else if (b_found_properties_code) {
                wkid = crs_identifier_code;
            } else if (!b_found_esriwkt) {
                throw new JsonGeometryException("parsing error");
            }
            if (wkid < 0 && !b_found_esriwkt && !b_found_properties_name) {
                throw new JsonGeometryException("parsing error");
            }
            SpatialReference spatial_reference = null;
            if (wkid > 0) {
                try {
                    spatial_reference = SpatialReference.create(wkid);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (spatial_reference == null) {
                try {
                    if (b_found_esriwkt) {
                        spatial_reference = SpatialReference.create(esriwkt);
                    } else if (b_found_properties_name) {
                        String potential_wkt = GeoJsonCrsTables.getWktFromCrsName(crs_identifier_name);
                        spatial_reference = SpatialReference.create(potential_wkt);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return spatial_reference;
        }

        static SpatialReference importSpatialReferenceFromCrsUrn_(JsonReader json_iterator, ProgressTracker progress_tracker) throws JsonGeometryException {
            if (json_iterator.currentToken() == JsonReader.Token.VALUE_NULL) {
                return null;
            }
            if (json_iterator.currentToken() != JsonReader.Token.VALUE_STRING) {
                throw new JsonGeometryException("parsing error");
            }
            String crs_identifier_urn = json_iterator.currentString();
            int wkid = GeoJsonCrsTables.getWkidFromCrsName(crs_identifier_urn);
            if (wkid == -1) {
                throw new GeometryException("not implemented");
            }
            SpatialReference spatial_reference = SpatialReference.create(wkid);
            return spatial_reference;
        }

        private static String getCrsIdentifier_(JsonReader json_iterator) throws JsonGeometryException {
            JsonReader.Token current_token = json_iterator.nextToken();
            if (current_token != JsonReader.Token.VALUE_STRING) {
                throw new JsonGeometryException("parsing error");
            }
            return json_iterator.currentString();
        }
    }

    static interface GeoJsonValues {
        public static final int Point = GeoJsonType.Point.geogsjonvalue();
        public static final int LineString = GeoJsonType.LineString.geogsjonvalue();
        public static final int Polygon = GeoJsonType.Polygon.geogsjonvalue();
        public static final int MultiPoint = GeoJsonType.MultiPoint.geogsjonvalue();
        public static final int MultiLineString = GeoJsonType.MultiLineString.geogsjonvalue();
        public static final int MultiPolygon = GeoJsonType.MultiPolygon.geogsjonvalue();
        public static final int GeometryCollection = GeoJsonType.GeometryCollection.geogsjonvalue();
    }

    static enum GeoJsonType {
        Point,
        LineString,
        Polygon,
        MultiPoint,
        MultiLineString,
        MultiPolygon,
        GeometryCollection;


        static GeoJsonType fromGeoJsonValue(int v) {
            return GeoJsonType.values()[v - 1];
        }

        public int geogsjonvalue() {
            return this.ordinal() + 1;
        }
    }
}

