/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.jts.ogc;

import com.geoway.atlas.jts.Geometry;
import com.geoway.atlas.jts.GeometryEngine;
import com.geoway.atlas.jts.Operator;
import com.geoway.atlas.jts.OperatorExportToGeoJson;
import com.geoway.atlas.jts.OperatorExportToWkb;
import com.geoway.atlas.jts.OperatorFactoryLocal;
import com.geoway.atlas.jts.Polygon;
import com.geoway.atlas.jts.Polyline;
import com.geoway.atlas.jts.SpatialReference;
import com.geoway.atlas.jts.ogc.OGCGeometry;
import com.geoway.atlas.jts.ogc.OGCMultiCurve;
import com.geoway.atlas.jts.ogc.OGCMultiSurface;
import com.geoway.atlas.jts.ogc.OGCPolygon;
import java.nio.ByteBuffer;

public class OGCMultiPolygon
extends OGCMultiSurface {
    public static String TYPE = "MultiPolygon";
    Polygon polygon;

    public OGCMultiPolygon(Polygon src, SpatialReference sr) {
        this.polygon = src;
        this.esriSR = sr;
    }

    public OGCMultiPolygon(SpatialReference sr) {
        this.polygon = new Polygon();
        this.esriSR = sr;
    }

    @Override
    public String asText() {
        return GeometryEngine.geometryToWkt(this.getEsriGeometry(), 32);
    }

    @Override
    public ByteBuffer asBinary() {
        OperatorExportToWkb op = (OperatorExportToWkb)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToWkb);
        return op.execute(32, this.getEsriGeometry(), null);
    }

    @Override
    public String asGeoJson() {
        OperatorExportToGeoJson op = (OperatorExportToGeoJson)OperatorFactoryLocal.getInstance().getOperator(Operator.Type.ExportToGeoJson);
        return op.execute(1, null, this.getEsriGeometry());
    }

    @Override
    public int numGeometries() {
        return this.polygon.getExteriorRingCount();
    }

    @Override
    public OGCGeometry geometryN(int n) {
        int exterior = 0;
        for (int i = 0; i < this.polygon.getPathCount(); ++i) {
            if (this.polygon.isExteriorRing(i)) {
                ++exterior;
            }
            if (exterior != n + 1) continue;
            return new OGCPolygon(this.polygon, i, this.esriSR);
        }
        throw new IllegalArgumentException("geometryN: n out of range");
    }

    @Override
    public String geometryType() {
        return TYPE;
    }

    @Override
    public long estimateMemorySize() {
        return 24L + (this.polygon != null ? this.polygon.estimateMemorySize() : 0L);
    }

    @Override
    public OGCGeometry boundary() {
        Polyline polyline = new Polyline();
        polyline.add(this.polygon, true);
        return (OGCMultiCurve)OGCMultiPolygon.createFromEsriGeometry(polyline, this.esriSR, true);
    }

    @Override
    public OGCGeometry locateAlong(double mValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OGCGeometry locateBetween(double mStart, double mEnd) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Geometry getEsriGeometry() {
        return this.polygon;
    }

    @Override
    public OGCGeometry convertToMulti() {
        return this;
    }

    @Override
    public OGCGeometry reduceFromMulti() {
        int n = this.numGeometries();
        if (n == 0) {
            return new OGCPolygon(new Polygon(this.polygon.getDescription()), 0, this.esriSR);
        }
        if (n == 1) {
            return this.geometryN(0);
        }
        return this;
    }
}

