/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.jts;

import com.geoway.atlas.jts.AttributeStreamOfInt32;
import com.geoway.atlas.jts.EditShape;
import com.geoway.atlas.jts.Geometry;
import com.geoway.atlas.jts.GeometryException;
import com.geoway.atlas.jts.IndexMultiList;
import com.geoway.atlas.jts.Line;
import com.geoway.atlas.jts.Point;
import com.geoway.atlas.jts.Point2D;
import com.geoway.atlas.jts.Segment;
import com.geoway.atlas.jts.SegmentIntersector;
import com.geoway.atlas.jts.StridedIndexTypeCollection;
import com.geoway.atlas.jts.SweepComparator;
import com.geoway.atlas.jts.SweepMonkierComparator;
import com.geoway.atlas.jts.Transformation2D;
import com.geoway.atlas.jts.Treap;

final class PlaneSweepCrackerHelper {
    private EditShape m_shape;
    private StridedIndexTypeCollection m_edges;
    private StridedIndexTypeCollection m_clusters;
    private IndexMultiList m_cluster_vertices;
    private IndexMultiList m_edge_vertices;
    private Point m_helper_point;
    private Treap m_event_q;
    private Treap m_sweep_structure;
    boolean m_complications = false;
    SimplifySweepComparator m_sweep_comparator;
    AttributeStreamOfInt32 m_temp_edge_buffer;
    AttributeStreamOfInt32 m_modified_clusters;
    AttributeStreamOfInt32 m_edges_to_insert_in_sweep_structure;
    int m_prev_neighbour;
    int m_next_neighbour;
    boolean m_b_continuing_segment_chain_optimization;
    SegmentIntersector m_segment_intersector;
    Line m_line_1;
    Line m_line_2;
    Point2D m_sweep_point;
    double m_tolerance;
    double m_tolerance_sqr;
    int m_sweep_point_cluster;
    int m_vertex_cluster_index;
    boolean m_b_cracked;
    boolean m_b_sweep_point_cluster_was_modified;
    Point2D pt_1 = new Point2D();
    Point2D pt_2 = new Point2D();

    PlaneSweepCrackerHelper() {
        this.m_edges = new StridedIndexTypeCollection(8);
        this.m_clusters = new StridedIndexTypeCollection(5);
        this.m_cluster_vertices = new IndexMultiList();
        this.m_edge_vertices = new IndexMultiList();
        this.m_sweep_point = new Point2D();
        this.m_sweep_point.setCoords(0.0, 0.0);
        this.m_tolerance = 0.0;
        this.m_vertex_cluster_index = -1;
        this.m_b_cracked = false;
        this.m_shape = null;
        this.m_event_q = new Treap();
        this.m_sweep_structure = new Treap();
        this.m_edges_to_insert_in_sweep_structure = new AttributeStreamOfInt32(0);
        this.m_segment_intersector = new SegmentIntersector();
        this.m_temp_edge_buffer = new AttributeStreamOfInt32(0);
        this.m_modified_clusters = new AttributeStreamOfInt32(0);
        this.m_helper_point = new Point();
    }

    boolean sweep(EditShape shape, double tolerance) {
        Transformation2D transform = new Transformation2D();
        transform.setSwapCoordinates();
        shape.applyTransformation(transform);
        this.setEditShape_(shape);
        this.m_b_cracked = false;
        this.m_tolerance = tolerance;
        this.m_tolerance_sqr = tolerance * tolerance;
        boolean b_cracked = this.sweepImpl_();
        shape.applyTransformation(transform);
        if (!b_cracked) {
            this.fillEventQueuePass2();
            b_cracked |= this.sweepImpl_();
        }
        if (this.m_vertex_cluster_index != -1) {
            this.m_shape.removeUserIndex(this.m_vertex_cluster_index);
            this.m_vertex_cluster_index = -1;
        }
        this.m_shape = null;
        return this.m_b_cracked;
    }

    boolean sweepVertical(EditShape shape, double tolerance) {
        this.setEditShape_(shape);
        this.m_b_cracked = false;
        this.m_tolerance = tolerance;
        this.m_tolerance_sqr = tolerance * tolerance;
        this.m_complications = false;
        boolean bresult = this.sweepImpl_();
        if (!this.m_complications) {
            int filtered = shape.filterClosePoints(tolerance, true, false);
            this.m_complications = filtered == 1;
            bresult |= filtered == 1;
        }
        if (this.m_vertex_cluster_index != -1) {
            this.m_shape.removeUserIndex(this.m_vertex_cluster_index);
            this.m_vertex_cluster_index = -1;
        }
        this.m_shape = null;
        return bresult;
    }

    boolean hadCompications() {
        return this.m_complications;
    }

    int getEdgeCluster(int edge, int end) {
        assert (end == 0 || end == 1);
        return this.m_edges.getField(edge, 0 + end);
    }

    void setEdgeCluster_(int edge, int end, int cluster) {
        assert (end == 0 || end == 1);
        this.m_edges.setField(edge, 0 + end, cluster);
    }

    int getEdgeOriginVertices(int edge) {
        return this.m_edges.getField(edge, 2);
    }

    void setEdgeOriginVertices_(int edge, int vertices) {
        this.m_edges.setField(edge, 2, vertices);
    }

    int getNextEdgeEx(int edge, int end) {
        assert (end == 0 || end == 1);
        return this.m_edges.getField(edge, 3 + end);
    }

    void setNextEdgeEx_(int edge, int end, int next_edge) {
        assert (end == 0 || end == 1);
        this.m_edges.setField(edge, 3 + end, next_edge);
    }

    int getEdgeSweepNode(int edge) {
        return this.m_edges.getField(edge, 7);
    }

    void setEdgeSweepNode_(int edge, int sweepNode) {
        this.m_edges.setField(edge, 7, sweepNode);
    }

    int getNextEdge(int edge, int cluster) {
        int end = this.getEdgeEnd(edge, cluster);
        assert (end == 0 || end == 1);
        return this.m_edges.getField(edge, 3 + end);
    }

    void setNextEdge_(int edge, int cluster, int next_edge) {
        int end = this.getEdgeEnd(edge, cluster);
        assert (end == 0 || end == 1);
        this.m_edges.setField(edge, 3 + end, next_edge);
    }

    int getPrevEdge(int edge, int cluster) {
        int end = this.getEdgeEnd(edge, cluster);
        assert (end == 0 || end == 1);
        return this.m_edges.getField(edge, 5 + end);
    }

    void setPrevEdge_(int edge, int cluster, int prevEdge) {
        int end = this.getEdgeEnd(edge, cluster);
        assert (end == 0 || end == 1);
        this.m_edges.setField(edge, 5 + end, prevEdge);
    }

    int getClusterVertices(int cluster) {
        return this.m_clusters.getField(cluster, 0);
    }

    void setClusterVertices_(int cluster, int vertices) {
        this.m_clusters.setField(cluster, 0, vertices);
    }

    int getClusterVertexIndex(int cluster) {
        return this.m_clusters.getField(cluster, 4);
    }

    void setClusterVertexIndex_(int cluster, int vindex) {
        this.m_clusters.setField(cluster, 4, vindex);
    }

    int getClusterSweepEdgeList(int cluster) {
        return this.m_clusters.getField(cluster, 2);
    }

    void setClusterSweepEdgeList_(int cluster, int sweep_edges) {
        this.m_clusters.setField(cluster, 2, sweep_edges);
    }

    int getClusterFirstEdge(int cluster) {
        return this.m_clusters.getField(cluster, 1);
    }

    void setClusterFirstEdge_(int cluster, int first_edge) {
        this.m_clusters.setField(cluster, 1, first_edge);
    }

    int getClusterEventQNode(int cluster) {
        return this.m_clusters.getField(cluster, 3);
    }

    void setClusterEventQNode_(int cluster, int node) {
        this.m_clusters.setField(cluster, 3, node);
    }

    int newCluster_(int vertex) {
        int cluster = this.m_clusters.newElement();
        int vertexList = this.m_cluster_vertices.createList();
        this.setClusterVertices_(cluster, vertexList);
        if (vertex != -1) {
            this.m_cluster_vertices.addElement(vertexList, vertex);
            assert (this.m_shape.getUserIndex(vertex, this.m_vertex_cluster_index) == -1);
            this.m_shape.setUserIndex(vertex, this.m_vertex_cluster_index, cluster);
            this.setClusterVertexIndex_(cluster, this.m_shape.getVertexIndex(vertex));
        } else {
            this.setClusterVertexIndex_(cluster, -1);
        }
        return cluster;
    }

    void deleteCluster_(int cluster) {
        this.m_clusters.deleteElement(cluster);
    }

    void addVertexToCluster_(int cluster, int vertex) {
        assert (this.m_shape.getUserIndex(vertex, this.m_vertex_cluster_index) == -1);
        int vertexList = this.getClusterVertices(cluster);
        this.m_cluster_vertices.addElement(vertexList, vertex);
        this.m_shape.setUserIndex(vertex, this.m_vertex_cluster_index, cluster);
    }

    int newEdge_(int origin_vertex) {
        int edge = this.m_edges.newElement();
        int edgeVertices = this.m_edge_vertices.createList();
        this.setEdgeOriginVertices_(edge, edgeVertices);
        if (origin_vertex != -1) {
            this.m_edge_vertices.addElement(edgeVertices, origin_vertex);
        }
        return edge;
    }

    void addVertexToEdge_(int edge, int vertex) {
        int vertexList = this.getEdgeOriginVertices(edge);
        this.m_edge_vertices.addElement(vertexList, vertex);
    }

    void deleteEdge_(int edge) {
        this.m_edges.deleteElement(edge);
        int ind = this.m_edges_to_insert_in_sweep_structure.findElement(edge);
        if (ind >= 0) {
            this.m_edges_to_insert_in_sweep_structure.popElement(ind);
        }
    }

    void addEdgeToCluster(int edge, int cluster) {
        if (this.getEdgeCluster(edge, 0) == -1) {
            assert (this.getEdgeCluster(edge, 1) != cluster);
            this.setEdgeCluster_(edge, 0, cluster);
        } else if (this.getEdgeCluster(edge, 1) == -1) {
            assert (this.getEdgeCluster(edge, 0) != cluster);
            this.setEdgeCluster_(edge, 1, cluster);
        } else {
            throw GeometryException.GeometryInternalError();
        }
        this.addEdgeToClusterImpl_(edge, cluster);
    }

    void addEdgeToClusterImpl_(int edge, int cluster) {
        int first_edge = this.getClusterFirstEdge(cluster);
        if (first_edge != -1) {
            int next = this.getNextEdge(first_edge, cluster);
            this.setPrevEdge_(next, cluster, edge);
            this.setNextEdge_(edge, cluster, next);
            this.setNextEdge_(first_edge, cluster, edge);
            this.setPrevEdge_(edge, cluster, first_edge);
        } else {
            this.setPrevEdge_(edge, cluster, edge);
            this.setNextEdge_(edge, cluster, edge);
            this.setClusterFirstEdge_(cluster, edge);
        }
    }

    int getEdgeEnd(int edge, int cluster) {
        if (this.getEdgeCluster(edge, 0) == cluster) {
            assert (this.getEdgeCluster(edge, 1) != cluster);
            return 0;
        }
        assert (this.getEdgeCluster(edge, 1) == cluster);
        return 1;
    }

    void mergeClusters_(int cluster_1, int cluster2) {
        int eventQnode = this.getClusterEventQNode(cluster2);
        if (eventQnode != -1) {
            this.m_event_q.deleteNode(eventQnode, -1);
            this.setClusterEventQNode_(cluster2, -1);
        }
        int firstEdge1 = this.getClusterFirstEdge(cluster_1);
        int firstEdge2 = this.getClusterFirstEdge(cluster2);
        if (firstEdge2 != -1) {
            int end;
            int nextEdge2;
            int edge2 = firstEdge2;
            int lastEdge = firstEdge2;
            boolean bForceContinue = false;
            do {
                bForceContinue = false;
                end = this.getEdgeEnd(edge2, cluster2);
                nextEdge2 = this.getNextEdgeEx(edge2, end);
                if (this.getEdgeCluster(edge2, end + 1 & 1) == cluster_1) {
                    this.disconnectEdge_(edge2);
                    int edgeOrigins2 = this.getEdgeOriginVertices(edge2);
                    this.m_edge_vertices.deleteList(edgeOrigins2);
                    this.deleteEdge_(edge2);
                    if (edge2 == nextEdge2) {
                        firstEdge2 = -1;
                        break;
                    }
                    if (firstEdge2 != edge2) continue;
                    firstEdge2 = this.getClusterFirstEdge(cluster2);
                    lastEdge = nextEdge2;
                    bForceContinue = true;
                    continue;
                }
                assert (edge2 != this.getClusterFirstEdge(cluster_1));
            } while ((edge2 = nextEdge2) != lastEdge || bForceContinue);
            if (firstEdge2 != -1) {
                do {
                    end = this.getEdgeEnd(edge2, cluster2);
                    nextEdge2 = this.getNextEdgeEx(edge2, end);
                    assert (edge2 != this.getClusterFirstEdge(cluster_1));
                    this.setEdgeCluster_(edge2, end, cluster_1);
                } while ((edge2 = nextEdge2) != lastEdge);
                firstEdge1 = this.getClusterFirstEdge(cluster_1);
                if (firstEdge1 != -1) {
                    int next1 = this.getNextEdge(firstEdge1, cluster_1);
                    int next2 = this.getNextEdge(firstEdge2, cluster_1);
                    if (next1 == firstEdge1) {
                        this.setClusterFirstEdge_(cluster_1, firstEdge2);
                        this.addEdgeToClusterImpl_(firstEdge1, cluster_1);
                        this.setClusterFirstEdge_(cluster_1, firstEdge1);
                    } else if (next2 == firstEdge2) {
                        this.addEdgeToClusterImpl_(firstEdge2, cluster_1);
                    }
                    this.setNextEdge_(firstEdge2, cluster_1, next1);
                    this.setPrevEdge_(next1, cluster_1, firstEdge2);
                    this.setNextEdge_(firstEdge1, cluster_1, next2);
                    this.setPrevEdge_(next2, cluster_1, firstEdge1);
                } else {
                    this.setClusterFirstEdge_(cluster_1, firstEdge2);
                }
            }
        }
        int vertices1 = this.getClusterVertices(cluster_1);
        int vertices2 = this.getClusterVertices(cluster2);
        int vh = this.m_cluster_vertices.getFirst(vertices2);
        while (vh != -1) {
            int v = this.m_cluster_vertices.getElement(vh);
            this.m_shape.setUserIndex(v, this.m_vertex_cluster_index, cluster_1);
            vh = this.m_cluster_vertices.getNext(vh);
        }
        this.m_cluster_vertices.concatenateLists(vertices1, vertices2);
        this.deleteCluster_(cluster2);
    }

    void mergeEdges_(int edge1, int edge2) {
        int cluster_1 = this.getEdgeCluster(edge1, 0);
        int cluster2 = this.getEdgeCluster(edge1, 1);
        int cluster21 = this.getEdgeCluster(edge2, 0);
        int cluster22 = this.getEdgeCluster(edge2, 1);
        int originVertices1 = this.getEdgeOriginVertices(edge1);
        int originVertices2 = this.getEdgeOriginVertices(edge2);
        this.m_edge_vertices.concatenateLists(originVertices1, originVertices2);
        if (edge2 == this.getClusterFirstEdge(cluster_1)) {
            this.setClusterFirstEdge_(cluster_1, edge1);
        }
        if (edge2 == this.getClusterFirstEdge(cluster2)) {
            this.setClusterFirstEdge_(cluster2, edge1);
        }
        this.disconnectEdge_(edge2);
        this.deleteEdge_(edge2);
        if (!(cluster_1 == cluster21 && cluster2 == cluster22 || cluster2 == cluster21 && cluster_1 == cluster22)) {
            this.getClusterXY(cluster_1, this.pt_1);
            this.getClusterXY(cluster21, this.pt_2);
            if (this.pt_1.isEqual(this.pt_2)) {
                if (cluster_1 != cluster21) {
                    this.mergeClusters_(cluster_1, cluster21);
                    assert (!this.m_modified_clusters.hasElement(cluster21));
                }
                if (cluster2 != cluster22) {
                    this.mergeClusters_(cluster2, cluster22);
                    assert (!this.m_modified_clusters.hasElement(cluster22));
                }
            } else {
                if (cluster2 != cluster21) {
                    this.mergeClusters_(cluster2, cluster21);
                    assert (!this.m_modified_clusters.hasElement(cluster21));
                }
                if (cluster_1 != cluster22) {
                    this.mergeClusters_(cluster_1, cluster22);
                    assert (!this.m_modified_clusters.hasElement(cluster22));
                }
            }
        }
    }

    void disconnectEdge_(int edge) {
        int cluster_1 = this.getEdgeCluster(edge, 0);
        int cluster2 = this.getEdgeCluster(edge, 1);
        this.disconnectEdgeFromCluster_(edge, cluster_1);
        this.disconnectEdgeFromCluster_(edge, cluster2);
    }

    void disconnectEdgeFromCluster_(int edge, int cluster) {
        int next = this.getNextEdge(edge, cluster);
        assert (this.getPrevEdge(next, cluster) == edge);
        int prev = this.getPrevEdge(edge, cluster);
        assert (this.getNextEdge(prev, cluster) == edge);
        int first_edge = this.getClusterFirstEdge(cluster);
        if (next != edge) {
            this.setNextEdge_(prev, cluster, next);
            this.setPrevEdge_(next, cluster, prev);
            if (first_edge == edge) {
                this.setClusterFirstEdge_(cluster, next);
            }
        } else {
            this.setClusterFirstEdge_(cluster, -1);
        }
    }

    void applyIntersectorToEditShape_(int edgeOrigins, SegmentIntersector intersector, int intersector_index) {
        int cluster2;
        boolean bComplexCase;
        int vertexHandle = this.m_edge_vertices.getFirst(edgeOrigins);
        int first_vertex = this.m_edge_vertices.getElement(vertexHandle);
        int cluster_1 = this.getClusterFromVertex(first_vertex);
        boolean bl = bComplexCase = cluster_1 == (cluster2 = this.getClusterFromVertex(this.m_shape.getNextVertex(first_vertex)));
        assert (!bComplexCase);
        this.m_shape.splitSegment_(first_vertex, intersector, intersector_index, true);
        vertexHandle = this.m_edge_vertices.getNext(vertexHandle);
        while (vertexHandle != -1) {
            boolean b_forward;
            int vertex = this.m_edge_vertices.getElement(vertexHandle);
            boolean bl2 = b_forward = this.getClusterFromVertex(vertex) == cluster_1;
            assert (b_forward && this.getClusterFromVertex(this.m_shape.getNextVertex(vertex)) == cluster2 || this.getClusterFromVertex(vertex) == cluster2 && this.getClusterFromVertex(this.m_shape.getNextVertex(vertex)) == cluster_1);
            this.m_shape.splitSegment_(vertex, intersector, intersector_index, b_forward);
            vertexHandle = this.m_edge_vertices.getNext(vertexHandle);
        }
        Point2D pt_0 = intersector.getResultSegment(intersector_index, 0).getStartXY();
        Point2D pt_1 = intersector.getResultSegment(intersector_index, intersector.getResultSegmentCount(intersector_index) - 1).getEndXY();
        this.updateClusterXY(cluster_1, pt_0);
        this.updateClusterXY(cluster2, pt_1);
    }

    void createEdgesAndClustersFromSplitEdge_(int edge1, SegmentIntersector intersector, int intersector_index) {
        int edgeOrigins1 = this.getEdgeOriginVertices(edge1);
        int cluster_1 = this.getEdgeCluster(edge1, 0);
        int cluster2 = this.getEdgeCluster(edge1, 1);
        int prevEdge = this.newEdge_(-1);
        this.m_edges_to_insert_in_sweep_structure.add(prevEdge);
        int c_3 = StridedIndexTypeCollection.impossibleIndex3();
        this.setEdgeSweepNode_(prevEdge, c_3);
        this.m_temp_edge_buffer.add(prevEdge);
        this.addEdgeToCluster(prevEdge, cluster_1);
        int n = intersector.getResultSegmentCount(intersector_index);
        for (int i = 1; i < n; ++i) {
            int newCluster = this.newCluster_(-1);
            this.m_modified_clusters.add(newCluster);
            this.m_temp_edge_buffer.add(newCluster);
            this.addEdgeToCluster(prevEdge, newCluster);
            int newEdge = this.newEdge_(-1);
            this.m_edges_to_insert_in_sweep_structure.add(newEdge);
            this.setEdgeSweepNode_(newEdge, c_3);
            this.m_temp_edge_buffer.add(newEdge);
            this.addEdgeToCluster(newEdge, newCluster);
            prevEdge = newEdge;
        }
        this.addEdgeToCluster(prevEdge, cluster2);
        int vertexHandle = this.m_edge_vertices.getFirst(edgeOrigins1);
        while (vertexHandle != -1) {
            int edge;
            int c;
            int i;
            int vertex = this.m_edge_vertices.getElement(vertexHandle);
            int cluster = this.getClusterFromVertex(vertex);
            if (cluster == cluster_1) {
                i = 0;
                do {
                    if (i > 0) {
                        c = this.m_temp_edge_buffer.get(i - 1);
                        this.addVertexToCluster_(c, vertex);
                        if (this.getClusterVertexIndex(c) == -1) {
                            this.setClusterVertexIndex_(c, this.m_shape.getVertexIndex(vertex));
                        }
                    }
                    edge = this.m_temp_edge_buffer.get(i);
                    this.addVertexToEdge_(edge, vertex);
                    vertex = this.m_shape.getNextVertex(vertex);
                } while ((i += 2) < this.m_temp_edge_buffer.size());
                assert (this.getClusterFromVertex(vertex) == cluster2);
            } else {
                assert (cluster == cluster2);
                i = this.m_temp_edge_buffer.size() - 1;
                do {
                    if (i < this.m_temp_edge_buffer.size() - 2) {
                        c = this.m_temp_edge_buffer.get(i + 1);
                        this.addVertexToCluster_(c, vertex);
                        if (this.getClusterVertexIndex(c) < 0) {
                            this.setClusterVertexIndex_(c, this.m_shape.getVertexIndex(vertex));
                        }
                    }
                    assert (i % 2 == 0);
                    edge = this.m_temp_edge_buffer.get(i);
                    this.addVertexToEdge_(edge, vertex);
                    vertex = this.m_shape.getNextVertex(vertex);
                } while ((i -= 2) >= 0);
                assert (this.getClusterFromVertex(vertex) == cluster_1);
            }
            vertexHandle = this.m_edge_vertices.getNext(vertexHandle);
        }
        this.m_temp_edge_buffer.clear(false);
    }

    int getVertexFromClusterIndex(int cluster) {
        int vertexList = this.getClusterVertices(cluster);
        int vertex = this.m_cluster_vertices.getFirstElement(vertexList);
        return vertex;
    }

    int getClusterFromVertex(int vertex) {
        return this.m_shape.getUserIndex(vertex, this.m_vertex_cluster_index);
    }

    void processSplitHelper1_(int index, int edge, SegmentIntersector intersector) {
        Point2D newEnd;
        int clusterStart = this.getEdgeCluster(edge, 0);
        Point2D ptClusterStart = new Point2D();
        this.getClusterXY(clusterStart, ptClusterStart);
        Point2D ptClusterEnd = new Point2D();
        int clusterEnd = this.getEdgeCluster(edge, 1);
        this.getClusterXY(clusterEnd, ptClusterEnd);
        int count = intersector.getResultSegmentCount(index);
        Segment seg = intersector.getResultSegment(index, 0);
        Point2D newStart = new Point2D();
        seg.getStartXY(newStart);
        if (!ptClusterStart.isEqual(newStart)) {
            int res2;
            int res1;
            if (!this.m_complications && (res1 = ptClusterStart.compare(this.m_sweep_point)) * (res2 = newStart.compare(this.m_sweep_point)) < 0) {
                this.m_complications = true;
            }
            this.getAffectedEdges(clusterStart, this.m_temp_edge_buffer);
            this.m_modified_clusters.add(clusterStart);
        }
        if (!this.m_complications && count > 1) {
            int dir = ptClusterStart.compare(ptClusterEnd);
            Point2D midPoint = seg.getEndXY();
            if (ptClusterStart.compare(midPoint) != dir || midPoint.compare(ptClusterEnd) != dir) {
                this.m_complications = true;
            } else if (midPoint.compare(this.m_sweep_point) < 0) {
                this.m_complications = true;
            }
        }
        if (!ptClusterEnd.isEqual(newEnd = (seg = intersector.getResultSegment(index, count - 1)).getEndXY())) {
            int res2;
            int res1;
            if (!this.m_complications && (res1 = ptClusterEnd.compare(this.m_sweep_point)) * (res2 = newEnd.compare(this.m_sweep_point)) < 0) {
                this.m_complications = true;
            }
            this.getAffectedEdges(clusterEnd, this.m_temp_edge_buffer);
            this.m_modified_clusters.add(clusterEnd);
        }
        this.m_temp_edge_buffer.add(edge);
        int n = this.m_temp_edge_buffer.size();
        for (int i = 0; i < n; ++i) {
            int e = this.m_temp_edge_buffer.get(i);
            int sweepNode = this.getEdgeSweepNode(e);
            if (StridedIndexTypeCollection.isValidElement(sweepNode)) {
                this.m_sweep_structure.deleteNode(sweepNode, -1);
                this.setEdgeSweepNode_(e, -1);
            }
            int c_3 = StridedIndexTypeCollection.impossibleIndex3();
            if (e == edge || this.getEdgeSweepNode(e) == c_3) continue;
            this.m_edges_to_insert_in_sweep_structure.add(e);
            this.setEdgeSweepNode_(e, c_3);
        }
        this.m_temp_edge_buffer.clear(false);
    }

    boolean checkAndFixIntersection_(int leftSweepNode, int rightSweepNode) {
        int leftEdge = this.m_sweep_structure.getElement(leftSweepNode);
        this.m_sweep_comparator.compare(this.m_sweep_structure, leftEdge, rightSweepNode);
        if (this.m_sweep_comparator.intersectionDetected()) {
            this.m_sweep_comparator.clearIntersectionDetectedFlag();
            this.fixIntersection_(leftSweepNode, rightSweepNode);
            return true;
        }
        return false;
    }

    void fixIntersection_(int left, int right) {
        Segment seg_2;
        this.m_b_cracked = true;
        int edge1 = this.m_sweep_structure.getElement(left);
        int edge2 = this.m_sweep_structure.getElement(right);
        assert (edge1 != edge2);
        int vertexList1 = this.getEdgeOriginVertices(edge1);
        int origin1 = this.m_edge_vertices.getFirstElement(vertexList1);
        int vertexList2 = this.getEdgeOriginVertices(edge2);
        int origin2 = this.m_edge_vertices.getFirstElement(vertexList2);
        Segment seg_1 = this.m_shape.getSegment(origin1);
        if (seg_1 == null) {
            if (this.m_line_1 == null) {
                this.m_line_1 = new Line();
            }
            this.m_shape.queryLineConnector(origin1, this.m_line_1);
            seg_1 = this.m_line_1;
        }
        if ((seg_2 = this.m_shape.getSegment(origin2)) == null) {
            if (this.m_line_2 == null) {
                this.m_line_2 = new Line();
            }
            this.m_shape.queryLineConnector(origin2, this.m_line_2);
            seg_2 = this.m_line_2;
        }
        this.m_segment_intersector.pushSegment(seg_1);
        this.m_segment_intersector.pushSegment(seg_2);
        if (this.m_segment_intersector.intersect(this.m_tolerance, true)) {
            this.m_complications = true;
        }
        this.splitEdge_(edge1, edge2, -1, this.m_segment_intersector);
        this.m_segment_intersector.clear();
    }

    void fixIntersectionPointSegment_(int cluster, int node) {
        this.m_b_cracked = true;
        int edge1 = this.m_sweep_structure.getElement(node);
        int vertexList1 = this.getEdgeOriginVertices(edge1);
        int origin1 = this.m_edge_vertices.getFirstElement(vertexList1);
        Segment seg_1 = this.m_shape.getSegment(origin1);
        if (seg_1 == null) {
            if (this.m_line_1 == null) {
                this.m_line_1 = new Line();
            }
            this.m_shape.queryLineConnector(origin1, this.m_line_1);
            seg_1 = this.m_line_1;
        }
        int clusterVertex = this.getClusterFirstVertex(cluster);
        this.m_segment_intersector.pushSegment(seg_1);
        this.m_shape.queryPoint(clusterVertex, this.m_helper_point);
        this.m_segment_intersector.intersect(this.m_tolerance, this.m_helper_point, 0, 1.0, true);
        this.splitEdge_(edge1, -1, cluster, this.m_segment_intersector);
        this.m_segment_intersector.clear();
    }

    void insertNewEdges_() {
        if (this.m_edges_to_insert_in_sweep_structure.size() == 0) {
            return;
        }
        while (this.m_edges_to_insert_in_sweep_structure.size() != 0) {
            if (this.m_edges_to_insert_in_sweep_structure.size() > Math.max(100, this.m_shape.getTotalPointCount())) {
                assert (false);
                this.m_edges_to_insert_in_sweep_structure.clear(false);
                this.m_complications = true;
                break;
            }
            int edge = this.m_edges_to_insert_in_sweep_structure.getLast();
            this.m_edges_to_insert_in_sweep_structure.removeLast();
            assert (this.getEdgeSweepNode(edge) == StridedIndexTypeCollection.impossibleIndex3());
            this.setEdgeSweepNode_(edge, -1);
            int terminatingCluster = this.isEdgeOnSweepLine_(edge);
            if (terminatingCluster != -1) {
                this.insertNewEdgeToSweepStructure_(edge, terminatingCluster);
            }
            this.m_b_continuing_segment_chain_optimization = false;
        }
    }

    boolean insertNewEdgeToSweepStructure_(int edge, int terminatingCluster) {
        int newEdgeNode;
        assert (this.getEdgeSweepNode(edge) == -1);
        if (this.m_b_continuing_segment_chain_optimization) {
            newEdgeNode = this.m_sweep_structure.addElementAtPosition(this.m_prev_neighbour, this.m_next_neighbour, edge, true, true, -1);
            this.m_b_continuing_segment_chain_optimization = false;
        } else {
            newEdgeNode = this.m_sweep_structure.addUniqueElement(edge, -1);
        }
        if (newEdgeNode == -1) {
            int existingNode = this.m_sweep_structure.getDuplicateElement(-1);
            int existingEdge = this.m_sweep_structure.getElement(existingNode);
            this.mergeEdges_(existingEdge, edge);
            return false;
        }
        this.setEdgeSweepNode_(edge, newEdgeNode);
        if (this.m_sweep_comparator.intersectionDetected()) {
            this.m_sweep_comparator.clearIntersectionDetectedFlag();
            int intersectionNode = this.m_sweep_comparator.getLastComparedNode();
            this.fixIntersection_(intersectionNode, newEdgeNode);
            return true;
        }
        return false;
    }

    int isEdgeOnSweepLine_(int edge) {
        int cluster_1 = this.getEdgeCluster(edge, 0);
        int cluster2 = this.getEdgeCluster(edge, 1);
        this.getClusterXY(cluster_1, this.pt_1);
        this.getClusterXY(cluster2, this.pt_2);
        if (Point2D.sqrDistance(this.pt_1, this.pt_2) <= this.m_tolerance_sqr) {
            this.m_complications = true;
            return -1;
        }
        int cmp1 = this.pt_1.compare(this.m_sweep_point);
        int cmp2 = this.pt_2.compare(this.m_sweep_point);
        if (cmp1 <= 0 && cmp2 > 0) {
            return cluster2;
        }
        if (cmp2 <= 0 && cmp1 > 0) {
            return cluster_1;
        }
        return -1;
    }

    void fillEventQueue() {
        AttributeStreamOfInt32 event_q = new AttributeStreamOfInt32(0);
        event_q.reserve(this.m_shape.getTotalPointCount());
        EditShape.VertexIterator iter = this.m_shape.queryVertexIterator();
        int vert = iter.next();
        while (vert != -1) {
            if (this.m_shape.getUserIndex(vert, this.m_vertex_cluster_index) != -1) {
                event_q.add(vert);
            }
            vert = iter.next();
        }
        this.m_shape.sortVerticesSimpleByY_(event_q, 0, event_q.size());
        this.m_event_q.clear();
        this.m_event_q.setCapacity(event_q.size());
        this.m_event_q.setComparator(new QComparator(this.m_shape));
        Point2D cluster_pt = new Point2D();
        cluster_pt.setNaN();
        int cluster = -1;
        Point2D pt = new Point2D();
        int nvertex = event_q.size();
        for (int index = 0; index < nvertex; ++index) {
            int vertex = event_q.get(index);
            this.m_shape.getXY(vertex, pt);
            if (pt.isEqual(cluster_pt)) {
                int vertexCluster = this.m_shape.getUserIndex(vertex, this.m_vertex_cluster_index);
                this.mergeClusters_(cluster, vertexCluster);
                continue;
            }
            cluster = this.getClusterFromVertex(vertex);
            this.m_shape.getXY(vertex, cluster_pt);
            int eventQnode = this.m_event_q.addBiggestElement(vertex, -1);
            this.setClusterEventQNode_(cluster, eventQnode);
        }
    }

    void fillEventQueuePass2() {
        AttributeStreamOfInt32 event_q = new AttributeStreamOfInt32(0);
        event_q.reserve(this.m_shape.getTotalPointCount());
        int node = this.m_event_q.getFirst(-1);
        while (node != -1) {
            int v = this.m_event_q.getElement(node);
            event_q.add(v);
            node = this.m_event_q.getNext(node);
        }
        assert (event_q.size() == this.m_event_q.size(-1));
        this.m_event_q.clear();
        this.m_shape.sortVerticesSimpleByY_(event_q, 0, event_q.size());
        int nvertex = event_q.size();
        for (int index = 0; index < nvertex; ++index) {
            int vertex = event_q.get(index);
            int cluster = this.getClusterFromVertex(vertex);
            int eventQnode = this.m_event_q.addBiggestElement(vertex, -1);
            this.setClusterEventQNode_(cluster, eventQnode);
        }
    }

    void getAffectedEdges(int cluster, AttributeStreamOfInt32 edges) {
        int first_edge = this.getClusterFirstEdge(cluster);
        if (first_edge == -1) {
            return;
        }
        int edge = first_edge;
        do {
            int sweepNode;
            if (!StridedIndexTypeCollection.isValidElement(sweepNode = this.getEdgeSweepNode(edge))) continue;
            edges.add(edge);
        } while ((edge = this.getNextEdge(edge, cluster)) != first_edge);
    }

    void updateClusterXY(int cluster, Point2D pt) {
        int vertexList = this.getClusterVertices(cluster);
        int vh = this.m_cluster_vertices.getFirst(vertexList);
        while (vh != -1) {
            int vertex = this.m_cluster_vertices.getElement(vh);
            this.m_shape.setXY(vertex, pt);
            vh = this.m_cluster_vertices.getNext(vh);
        }
    }

    void splitEdge_(int edge1, int edge2, int intersectionCluster, SegmentIntersector intersector) {
        this.disconnectEdge_(edge1);
        if (edge2 != -1) {
            this.disconnectEdge_(edge2);
        }
        this.processSplitHelper1_(0, edge1, intersector);
        if (edge2 != -1) {
            this.processSplitHelper1_(1, edge2, intersector);
        }
        if (intersectionCluster != -1) {
            intersector.getResultPoint().getXY(this.pt_1);
            this.getClusterXY(intersectionCluster, this.pt_2);
            if (!this.pt_2.isEqual(this.pt_1)) {
                this.m_modified_clusters.add(intersectionCluster);
            }
        }
        int n = this.m_modified_clusters.size();
        for (int i = 0; i < n; ++i) {
            int cluster = this.m_modified_clusters.get(i);
            int eventQnode = this.getClusterEventQNode(cluster);
            if (eventQnode == -1) continue;
            this.m_event_q.deleteNode(eventQnode, -1);
            this.setClusterEventQNode_(cluster, -1);
        }
        int edgeOrigins1 = this.getEdgeOriginVertices(edge1);
        int edgeOrigins2 = edge2 != -1 ? this.getEdgeOriginVertices(edge2) : -1;
        this.applyIntersectorToEditShape_(edgeOrigins1, intersector, 0);
        if (edgeOrigins2 != -1) {
            this.applyIntersectorToEditShape_(edgeOrigins2, intersector, 1);
        } else {
            assert (intersectionCluster != -1);
            Point2D pt = intersector.getResultPoint().getXY();
            this.updateClusterXY(intersectionCluster, pt);
        }
        this.createEdgesAndClustersFromSplitEdge_(edge1, intersector, 0);
        if (edge2 != -1) {
            this.createEdgesAndClustersFromSplitEdge_(edge2, intersector, 1);
        }
        this.m_edge_vertices.deleteList(edgeOrigins1);
        this.deleteEdge_(edge1);
        if (edge2 != -1) {
            this.m_edge_vertices.deleteList(edgeOrigins2);
            this.deleteEdge_(edge2);
        }
        int n2 = this.m_modified_clusters.size();
        for (int i = 0; i < n2; ++i) {
            int eventQnode;
            int cluster = this.m_modified_clusters.get(i);
            if (cluster == this.m_sweep_point_cluster) {
                this.m_b_sweep_point_cluster_was_modified = true;
            }
            if ((eventQnode = this.getClusterEventQNode(cluster)) != -1) continue;
            int vertex = this.getClusterFirstVertex(cluster);
            assert (this.getClusterFromVertex(vertex) == cluster);
            eventQnode = this.m_event_q.addUniqueElement(vertex, -1);
            if (eventQnode == -1) {
                int existingNode = this.m_event_q.getDuplicateElement(-1);
                int v = this.m_event_q.getElement(existingNode);
                assert (this.m_shape.isEqualXY(vertex, v));
                int existingCluster = this.getClusterFromVertex(v);
                this.mergeClusters_(existingCluster, cluster);
                continue;
            }
            this.setClusterEventQNode_(cluster, eventQnode);
        }
        this.m_modified_clusters.clear(false);
    }

    void getClusterXY(int cluster, Point2D ptOut) {
        int vindex = this.getClusterVertexIndex(cluster);
        this.m_shape.getXYWithIndex(vindex, ptOut);
    }

    int getClusterFirstVertex(int cluster) {
        int vertexList = this.getClusterVertices(cluster);
        int vertex = this.m_cluster_vertices.getFirstElement(vertexList);
        return vertex;
    }

    boolean sweepImpl_() {
        this.m_b_sweep_point_cluster_was_modified = false;
        this.m_sweep_point_cluster = -1;
        if (this.m_sweep_comparator == null) {
            this.m_sweep_structure.disableBalancing();
            this.m_sweep_comparator = new SimplifySweepComparator(this);
            this.m_sweep_structure.setComparator(this.m_sweep_comparator);
        }
        AttributeStreamOfInt32 edgesToDelete = new AttributeStreamOfInt32(0);
        SweepMonkierComparator sweepMoniker = null;
        QMonikerComparator moniker = null;
        int iterationCounter = 0;
        this.m_prev_neighbour = -1;
        this.m_next_neighbour = -1;
        this.m_b_continuing_segment_chain_optimization = false;
        int c_2 = StridedIndexTypeCollection.impossibleIndex2();
        int c_3 = StridedIndexTypeCollection.impossibleIndex3();
        assert (c_2 != c_3);
        int eventQnode = this.m_event_q.getFirst(-1);
        while (eventQnode != -1) {
            ++iterationCounter;
            this.m_b_continuing_segment_chain_optimization = false;
            int vertex = this.m_event_q.getElement(eventQnode);
            this.m_sweep_point_cluster = this.getClusterFromVertex(vertex);
            this.m_shape.getXY(vertex, this.m_sweep_point);
            this.m_sweep_comparator.setSweepY(this.m_sweep_point.y, this.m_sweep_point.x);
            boolean bDisconnectedCluster = false;
            int first_edge = this.getClusterFirstEdge(this.m_sweep_point_cluster);
            boolean bl = bDisconnectedCluster = first_edge == -1;
            if (!bDisconnectedCluster) {
                int edge = first_edge;
                do {
                    int sweepNode;
                    if ((sweepNode = this.getEdgeSweepNode(edge)) == -1) {
                        this.m_edges_to_insert_in_sweep_structure.add(edge);
                        this.setEdgeSweepNode_(edge, c_3);
                        continue;
                    }
                    if (sweepNode == c_3) continue;
                    assert (StridedIndexTypeCollection.isValidElement(sweepNode));
                    edgesToDelete.add(sweepNode);
                } while ((edge = this.getNextEdge(edge, this.m_sweep_point_cluster)) != first_edge);
            }
            if (edgesToDelete.size() > 0) {
                int sweepNode;
                int i;
                this.m_b_continuing_segment_chain_optimization = edgesToDelete.size() == 1 && this.m_edges_to_insert_in_sweep_structure.size() == 1;
                int n = edgesToDelete.size();
                for (int i2 = 0; i2 < n; ++i2) {
                    int edge = this.m_sweep_structure.getElement(edgesToDelete.get(i2));
                    this.setEdgeSweepNode_(edge, c_2);
                }
                int left = c_2;
                int right = c_2;
                int n2 = edgesToDelete.size();
                for (i = 0; i < n2; ++i) {
                    int node;
                    int edge;
                    sweepNode = edgesToDelete.get(i);
                    if (left == c_2) {
                        int localleft = this.m_sweep_structure.getPrev(sweepNode);
                        if (localleft != -1) {
                            edge = this.m_sweep_structure.getElement(localleft);
                            node = this.getEdgeSweepNode(edge);
                            if (node != c_2) {
                                left = localleft;
                            }
                        } else {
                            left = -1;
                        }
                    }
                    if (right == c_2) {
                        int localright = this.m_sweep_structure.getNext(sweepNode);
                        if (localright != -1) {
                            edge = this.m_sweep_structure.getElement(localright);
                            node = this.getEdgeSweepNode(edge);
                            if (node != c_2) {
                                right = localright;
                            }
                        } else {
                            right = -1;
                        }
                    }
                    if (left != c_2 && right != c_2) break;
                }
                assert (left != c_2 && right != c_2);
                n2 = edgesToDelete.size();
                for (i = 0; i < n2; ++i) {
                    sweepNode = edgesToDelete.get(i);
                    int edge = this.m_sweep_structure.getElement(sweepNode);
                    this.m_sweep_structure.deleteNode(sweepNode, -1);
                    this.setEdgeSweepNode_(edge, -1);
                }
                edgesToDelete.clear(false);
                this.m_prev_neighbour = left != -1 ? left : -1;
                int n3 = this.m_next_neighbour = right != -1 ? right : -1;
                if (left != -1 && right != -1) {
                    if (!this.m_b_continuing_segment_chain_optimization) {
                        boolean bl2 = this.checkAndFixIntersection_(left, right);
                    }
                } else if (left == -1 && right == -1) {
                    this.m_b_continuing_segment_chain_optimization = false;
                }
            } else if (bDisconnectedCluster) {
                if (sweepMoniker == null) {
                    sweepMoniker = new SimplifySweepMonikerComparator(this);
                }
                sweepMoniker.setPoint(this.m_sweep_point);
                this.m_sweep_structure.searchUpperBound(sweepMoniker, -1);
                if (sweepMoniker.intersectionDetected()) {
                    sweepMoniker.clearIntersectionDetectedFlag();
                    this.fixIntersectionPointSegment_(this.m_sweep_point_cluster, sweepMoniker.getCurrentNode());
                }
            }
            this.insertNewEdges_();
            if (this.m_b_sweep_point_cluster_was_modified) {
                this.m_b_sweep_point_cluster_was_modified = false;
                if (moniker == null) {
                    moniker = new QMonikerComparator(this.m_shape);
                }
                moniker.setPoint(this.m_sweep_point);
                eventQnode = this.m_event_q.searchUpperBound(moniker, -1);
                continue;
            }
            eventQnode = this.m_event_q.getNext(eventQnode);
        }
        return this.m_b_cracked;
    }

    void setEditShape_(EditShape shape) {
        this.m_shape = shape;
        this.m_vertex_cluster_index = this.m_shape.createUserIndex();
        this.m_edges.setCapacity(shape.getTotalPointCount() + 32);
        this.m_clusters.setCapacity(shape.getTotalPointCount());
        this.m_cluster_vertices.reserveLists(shape.getTotalPointCount());
        this.m_cluster_vertices.reserveNodes(shape.getTotalPointCount());
        this.m_edge_vertices.reserveLists(shape.getTotalPointCount() + 32);
        this.m_edge_vertices.reserveNodes(shape.getTotalPointCount() + 32);
        int geometry = this.m_shape.getFirstGeometry();
        while (geometry != -1) {
            int path;
            boolean bMultiPath = Geometry.isMultiPath(this.m_shape.getGeometryType(geometry));
            if (!bMultiPath) {
                assert (this.m_shape.getGeometryType(geometry) == 550);
                path = this.m_shape.getFirstPath(geometry);
                while (path != -1) {
                    int vertex = this.m_shape.getFirstVertex(path);
                    int n = this.m_shape.getPathSize(path);
                    for (int i = 0; i < n; ++i) {
                        this.newCluster_(vertex);
                        vertex = this.m_shape.getNextVertex(vertex);
                    }
                    path = this.m_shape.getNextPath(path);
                }
            } else {
                path = this.m_shape.getFirstPath(geometry);
                while (path != -1) {
                    int cluster;
                    int path_size = this.m_shape.getPathSize(path);
                    assert (path_size > 1);
                    int first_vertex = this.m_shape.getFirstVertex(path);
                    int firstCluster = this.newCluster_(first_vertex);
                    int first_edge = this.newEdge_(first_vertex);
                    this.addEdgeToCluster(first_edge, firstCluster);
                    int prevEdge = first_edge;
                    int vertex = this.m_shape.getNextVertex(first_vertex);
                    int n = path_size - 2;
                    for (int index = 0; index < n; ++index) {
                        int nextvertex = this.m_shape.getNextVertex(vertex);
                        int cluster2 = this.newCluster_(vertex);
                        this.addEdgeToCluster(prevEdge, cluster2);
                        int newEdge = this.newEdge_(vertex);
                        this.addEdgeToCluster(newEdge, cluster2);
                        prevEdge = newEdge;
                        vertex = nextvertex;
                    }
                    if (this.m_shape.isClosedPath(path)) {
                        cluster = this.newCluster_(vertex);
                        this.addEdgeToCluster(prevEdge, cluster);
                        int newEdge = this.newEdge_(vertex);
                        this.addEdgeToCluster(newEdge, cluster);
                        this.addEdgeToCluster(newEdge, firstCluster);
                    } else {
                        cluster = this.newCluster_(vertex);
                        this.addEdgeToCluster(prevEdge, cluster);
                    }
                    path = this.m_shape.getNextPath(path);
                }
            }
            geometry = this.m_shape.getNextGeometry(geometry);
        }
        this.fillEventQueue();
    }

    static final class QMonikerComparator
    extends Treap.MonikerComparator {
        EditShape m_shape;
        Point2D m_point = new Point2D();
        Point2D m_pt = new Point2D();

        QMonikerComparator(EditShape shape) {
            this.m_shape = shape;
        }

        void setPoint(Point2D pt) {
            this.m_point.setCoords(pt);
        }

        @Override
        int compare(Treap treap, int node) {
            int v = treap.getElement(node);
            this.m_shape.getXY(v, this.m_pt);
            return this.m_point.compare(this.m_pt);
        }
    }

    static final class QComparator
    extends Treap.Comparator {
        EditShape m_shape;
        Point2D pt_1 = new Point2D();
        Point2D pt_2 = new Point2D();

        QComparator(EditShape shape) {
            this.m_shape = shape;
        }

        @Override
        int compare(Treap treap, int vertex, int node) {
            this.m_shape.getXY(vertex, this.pt_1);
            int v_2 = treap.getElement(node);
            this.m_shape.getXY(v_2, this.pt_2);
            return this.pt_1.compare(this.pt_2);
        }
    }

    static final class SimplifySweepMonikerComparator
    extends SweepMonkierComparator {
        PlaneSweepCrackerHelper m_parent;

        SimplifySweepMonikerComparator(PlaneSweepCrackerHelper parent) {
            super(parent.m_shape, parent.m_tolerance);
            this.m_parent = parent;
        }

        @Override
        int compare(Treap treap, int node) {
            if (this.m_b_intersection_detected) {
                return -1;
            }
            int elm = treap.getElement(node);
            int vertexList = this.m_parent.getEdgeOriginVertices(elm);
            int vertex = this.m_parent.m_edge_vertices.getFirstElement(vertexList);
            this.m_current_node = node;
            return this.compareVertex_(treap, node, vertex);
        }
    }

    static final class SimplifySweepComparator
    extends SweepComparator {
        PlaneSweepCrackerHelper m_parent;

        SimplifySweepComparator(PlaneSweepCrackerHelper parent) {
            super(parent.m_shape, parent.m_tolerance, false);
            this.m_parent = parent;
        }

        @Override
        int compare(Treap treap, int elm, int node) {
            if (this.m_b_intersection_detected) {
                return -1;
            }
            int vertex_list_left = this.m_parent.getEdgeOriginVertices(elm);
            int left = this.m_parent.m_edge_vertices.getFirstElement(vertex_list_left);
            int right_elm = treap.getElement(node);
            assert (this.m_parent.getEdgeSweepNode(right_elm) == node);
            int vertex_list_right = this.m_parent.getEdgeOriginVertices(right_elm);
            int right = this.m_parent.m_edge_vertices.getFirstElement(vertex_list_right);
            this.m_current_node = node;
            return this.compareSegments(elm, left, right_elm, right);
        }
    }
}

