/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.jts;

import com.geoway.atlas.jts.AttributeStreamOfDbl;
import com.geoway.atlas.jts.AttributeStreamOfFloat;
import com.geoway.atlas.jts.AttributeStreamOfInt16;
import com.geoway.atlas.jts.AttributeStreamOfInt32;
import com.geoway.atlas.jts.AttributeStreamOfInt64;
import com.geoway.atlas.jts.AttributeStreamOfInt8;
import com.geoway.atlas.jts.GeometryException;
import com.geoway.atlas.jts.Point;
import com.geoway.atlas.jts.VertexDescription;
import java.nio.ByteBuffer;

abstract class AttributeStreamBase {
    protected boolean m_bLockedInSize = false;
    protected boolean m_bReadonly = false;

    public abstract int virtualSize();

    public abstract long estimateMemorySize();

    public abstract int getPersistence();

    public abstract double readAsDbl(int var1);

    public abstract void writeAsDbl(int var1, double var2);

    public abstract int readAsInt(int var1);

    public abstract void writeAsInt(int var1, int var2);

    public abstract long readAsInt64(int var1);

    public abstract void writeAsInt64(int var1, long var2);

    public abstract void resize(int var1, double var2);

    public abstract void resize(int var1);

    public abstract void resizePreserveCapacity(int var1);

    void clear(boolean bFreeMemory) {
        if (bFreeMemory) {
            this.resize(0);
        } else {
            this.resizePreserveCapacity(0);
        }
    }

    public abstract void addRange(AttributeStreamBase var1, int var2, int var3, boolean var4, int var5);

    public abstract void insertRange(int var1, AttributeStreamBase var2, int var3, int var4, boolean var5, int var6, int var7);

    public abstract void insertRange(int var1, double var2, int var4, int var5);

    public abstract void insertAttributes(int var1, Point var2, int var3, int var4);

    public abstract void setRange(double var1, int var3, int var4);

    public abstract void writeRange(int var1, int var2, AttributeStreamBase var3, int var4, boolean var5, int var6);

    public abstract void writeRange(int var1, int var2, ByteBuffer var3, int var4, boolean var5);

    public abstract void readRange(int var1, int var2, ByteBuffer var3, int var4, boolean var5);

    public abstract void eraseRange(int var1, int var2, int var3);

    public abstract void reverseRange(int var1, int var2, int var3);

    public static AttributeStreamBase createByteStream(int size) {
        AttributeStreamOfInt8 newStream = new AttributeStreamOfInt8(size);
        return newStream;
    }

    public static AttributeStreamBase createByteStream(int size, byte defaultValue) {
        AttributeStreamOfInt8 newStream = new AttributeStreamOfInt8(size, defaultValue);
        return newStream;
    }

    public static AttributeStreamBase createDoubleStream(int size) {
        AttributeStreamOfDbl newStream = new AttributeStreamOfDbl(size);
        return newStream;
    }

    public static AttributeStreamBase createDoubleStream(int size, double defaultValue) {
        AttributeStreamOfDbl newStream = new AttributeStreamOfDbl(size, defaultValue);
        return newStream;
    }

    public abstract AttributeStreamBase restrictedClone(int var1);

    public void setReadonly() {
        this.m_bReadonly = true;
        this.m_bLockedInSize = true;
    }

    public boolean isReadonly() {
        return this.m_bReadonly;
    }

    public void lockSize() {
        this.m_bLockedInSize = true;
    }

    public boolean isLockedSize() {
        return this.m_bLockedInSize;
    }

    public static AttributeStreamBase createAttributeStreamWithPersistence(int persistence, int size) {
        AttributeStreamBase newStream;
        switch (persistence) {
            case 0: {
                newStream = new AttributeStreamOfFloat(size);
                break;
            }
            case 1: {
                newStream = new AttributeStreamOfDbl(size);
                break;
            }
            case 2: {
                newStream = new AttributeStreamOfInt32(size);
                break;
            }
            case 3: {
                newStream = new AttributeStreamOfInt64(size);
                break;
            }
            case 4: {
                newStream = new AttributeStreamOfInt8(size);
                break;
            }
            case 5: {
                newStream = new AttributeStreamOfInt16(size);
                break;
            }
            default: {
                throw new GeometryException("Internal Error");
            }
        }
        return newStream;
    }

    public static AttributeStreamBase createAttributeStreamWithPersistence(int persistence, int size, double defaultValue) {
        AttributeStreamBase newStream;
        switch (persistence) {
            case 0: {
                newStream = new AttributeStreamOfFloat(size, (float)defaultValue);
                break;
            }
            case 1: {
                newStream = new AttributeStreamOfDbl(size, defaultValue);
                break;
            }
            case 2: {
                newStream = new AttributeStreamOfInt32(size, (int)defaultValue);
                break;
            }
            case 3: {
                newStream = new AttributeStreamOfInt64(size, (long)defaultValue);
                break;
            }
            case 4: {
                newStream = new AttributeStreamOfInt8(size, (byte)defaultValue);
                break;
            }
            case 5: {
                newStream = new AttributeStreamOfInt16(size, (short)defaultValue);
                break;
            }
            default: {
                throw new GeometryException("Internal Error");
            }
        }
        return newStream;
    }

    public static AttributeStreamBase createAttributeStreamWithSemantics(int semantics, int vertexCount) {
        int ncomps = VertexDescription.getComponentCount(semantics);
        int persistence = VertexDescription.getPersistence(semantics);
        return AttributeStreamBase.createAttributeStreamWithPersistence(persistence, vertexCount * ncomps, VertexDescription.getDefaultValue(semantics));
    }

    public static AttributeStreamBase createIndexStream(int size) {
        AttributeStreamBase newStream;
        int persistence = 2;
        switch (persistence) {
            case 2: {
                newStream = new AttributeStreamOfInt32(size);
                break;
            }
            case 3: {
                newStream = new AttributeStreamOfInt64(size);
                break;
            }
            default: {
                throw new GeometryException("Internal Error");
            }
        }
        return newStream;
    }

    public static AttributeStreamBase createIndexStream(int size, int defaultValue) {
        AttributeStreamBase newStream;
        int persistence = 2;
        switch (persistence) {
            case 2: {
                newStream = new AttributeStreamOfInt32(size, defaultValue);
                break;
            }
            case 3: {
                newStream = new AttributeStreamOfInt64(size, (long)defaultValue);
                break;
            }
            default: {
                throw new GeometryException("Internal Error");
            }
        }
        return newStream;
    }

    public abstract int calculateHashImpl(int var1, int var2, int var3);

    public abstract boolean equals(AttributeStreamBase var1, int var2, int var3);
}

