/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.jts;

import com.geoway.atlas.jts.Geometry;
import com.geoway.atlas.jts.GeometryAccelerators;
import com.geoway.atlas.jts.MultiVertexGeometryImpl;
import com.geoway.atlas.jts.SpatialReference;

public abstract class Operator {
    public abstract Type getType();

    public boolean accelerateGeometry(Geometry geometry, SpatialReference spatialReference, Geometry.GeometryAccelerationDegree accelDegree) {
        return false;
    }

    public boolean canAccelerateGeometry(Geometry geometry) {
        return false;
    }

    public static void deaccelerateGeometry(Geometry geometry) {
        GeometryAccelerators accel;
        Geometry.Type gt = geometry.getType();
        if (Geometry.isMultiVertex(gt.value()) && (accel = ((MultiVertexGeometryImpl)geometry._getImpl())._getAccelerators()) != null) {
            accel._setRasterizedGeometry(null);
            accel._setQuadTree(null);
        }
    }

    public static enum Type {
        Project,
        ExportToJson,
        ImportFromJson,
        ExportToESRIShape,
        ImportFromESRIShape,
        Union,
        Difference,
        Proximity2D,
        Centroid2D,
        Relate,
        Equals,
        Disjoint,
        Intersects,
        Within,
        Contains,
        Crosses,
        Touches,
        Overlaps,
        Buffer,
        Distance,
        Intersection,
        Clip,
        Cut,
        DensifyByLength,
        DensifyByAngle,
        LabelPoint,
        GeodesicBuffer,
        GeodeticDensifyByLength,
        ShapePreservingDensify,
        GeodeticLength,
        GeodeticArea,
        Simplify,
        SimplifyOGC,
        Offset,
        Generalize,
        ExportToWkb,
        ImportFromWkb,
        ExportToWkt,
        ImportFromWkt,
        ImportFromGeoJson,
        ExportToGeoJson,
        SymmetricDifference,
        ConvexHull,
        Boundary;

    }
}

