/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.algorithm.vector.overlay.geom;

import com.geoway.atlas.algorithm.vector.overlay.geom.AtlasOverlayOp$SideType$;
import com.geoway.atlas.common.config.AtlasSystemProperties;
import com.geoway.atlas.common.error.NotSupportException;
import com.geoway.atlas.common.error.NotSupportException$;
import com.geoway.atlas.common.error.UnCatchException;
import com.geoway.atlas.common.error.UnCatchException$;
import com.geoway.atlas.common.log.LazyLogging;
import com.geoway.atlas.data.vector.common.geom.GeometryDimension$;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Lineal;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.Polygonal;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.geom.util.GeometryCollectionMapper;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.locationtech.jts.operation.buffer.BufferOp;
import org.locationtech.jts.operation.buffer.BufferParameters;
import org.locationtech.jts.operation.overlay.OverlayOp;
import org.locationtech.jts.operation.overlayng.OverlayNG;
import org.locationtech.jts.operation.overlayng.OverlayNGRobust;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class AtlasOverlayOp$
implements LazyLogging {
    public static AtlasOverlayOp$ MODULE$;
    private final boolean HAS_TOLERANCE;
    private final int SPLIT_LIMIT;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new AtlasOverlayOp$();
    }

    private Logger logger$lzycompute() {
        AtlasOverlayOp$ atlasOverlayOp$ = this;
        synchronized (atlasOverlayOp$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public boolean HAS_TOLERANCE() {
        return this.HAS_TOLERANCE;
    }

    public int SPLIT_LIMIT() {
        return this.SPLIT_LIMIT;
    }

    public Geometry intersection(Geometry a, Geometry b, PrecisionModel precisionModel, boolean hasTolerance) {
        if (a.isEmpty() || b.isEmpty()) {
            return OverlayOp.createEmptyResult(1, a, b, a.getFactory());
        }
        if (!a.getEnvelopeInternal().intersects(b.getEnvelopeInternal())) {
            return OverlayOp.createEmptyResult(1, a, b, a.getFactory());
        }
        if (a.getClass().getSimpleName().equals("GeometryCollection")) {
            Geometry g2 = b;
            return GeometryCollectionMapper.map((GeometryCollection)a, g -> MODULE$.intersection(g, g2, precisionModel, hasTolerance));
        }
        return this.overlay(a, b, OverlayNG.INTERSECTION, precisionModel, hasTolerance);
    }

    public Geometry intersection(Geometry a, Geometry b, PrecisionModel precisionModel) {
        return this.intersection(a, b, precisionModel, this.HAS_TOLERANCE());
    }

    public Geometry intersection(Geometry a, Geometry b) {
        if (a.isEmpty() || b.isEmpty()) {
            return OverlayOp.createEmptyResult(1, a, b, a.getFactory());
        }
        if (!a.getEnvelopeInternal().intersects(b.getEnvelopeInternal())) {
            return OverlayOp.createEmptyResult(1, a, b, a.getFactory());
        }
        if (a.getClass().getSimpleName().equals("GeometryCollection")) {
            Geometry g2 = b;
            return GeometryCollectionMapper.map((GeometryCollection)a, g -> MODULE$.intersection(g, g2));
        }
        return this.overlay(a, b, OverlayNG.INTERSECTION, a.getPrecisionModel());
    }

    public Geometry difference(Geometry a, Geometry b) {
        if (a.isEmpty()) {
            return OverlayOp.createEmptyResult(3, a, b, a.getFactory());
        }
        if (b.isEmpty()) {
            return a.copy();
        }
        if (a.getClass().getSimpleName().equals("GeometryCollection")) {
            String x$1 = "\u65e0\u6cd5\u5904\u7406GeometryCollection\u7c7b\u578b\u7684difference!";
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        if (b.getClass().getSimpleName().equals("GeometryCollection")) {
            String x$4 = "\u65e0\u6cd5\u5904\u7406GeometryCollection\u7c7b\u578b\u7684difference!";
            Thread x$5 = NotSupportException$.MODULE$.apply$default$2(x$4);
            int x$6 = NotSupportException$.MODULE$.apply$default$3(x$4);
            throw new NotSupportException(x$4, x$5, x$6);
        }
        return this.overlay(a, b, OverlayNG.DIFFERENCE, a.getPrecisionModel());
    }

    public Geometry difference(Geometry a, Geometry b, PrecisionModel precisionModel, boolean hasTolerance) {
        if (a.isEmpty()) {
            return OverlayOp.createEmptyResult(3, a, b, a.getFactory());
        }
        if (b.isEmpty()) {
            return a.copy();
        }
        if (a.getClass().getSimpleName().equals("GeometryCollection")) {
            String x$1 = "\u65e0\u6cd5\u5904\u7406GeometryCollection\u7c7b\u578b\u7684difference!";
            Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
            int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
            throw new NotSupportException(x$1, x$2, x$3);
        }
        if (b.getClass().getSimpleName().equals("GeometryCollection")) {
            String x$4 = "\u65e0\u6cd5\u5904\u7406GeometryCollection\u7c7b\u578b\u7684difference!";
            Thread x$5 = NotSupportException$.MODULE$.apply$default$2(x$4);
            int x$6 = NotSupportException$.MODULE$.apply$default$3(x$4);
            throw new NotSupportException(x$4, x$5, x$6);
        }
        return this.overlay(a, b, OverlayNG.DIFFERENCE, precisionModel, hasTolerance);
    }

    public Geometry difference(Geometry a, Geometry b, PrecisionModel precisionModel) {
        return this.difference(a, b, precisionModel, this.HAS_TOLERANCE());
    }

    public Geometry union(Seq<Geometry> geometries) {
        return geometries.nonEmpty() ? this.unionBase(geometries, ((Geometry)geometries.head()).getPrecisionModel()) : ((Geometry)geometries.head()).getFactory().createEmpty(((Geometry)geometries.head()).getDimension());
    }

    public Geometry union(Seq<Geometry> geometries, PrecisionModel pm) {
        return geometries.nonEmpty() ? this.unionBase(geometries, pm) : ((Geometry)geometries.head()).getFactory().createEmpty(((Geometry)geometries.head()).getDimension());
    }

    public Geometry buffer(Geometry geometry, double distance, int end_type, int side_type, PrecisionModel pm) {
        Geometry geometry2;
        BufferParameters bufferParameters = new BufferParameters();
        bufferParameters.setEndCapStyle(end_type);
        int n = side_type;
        if (AtlasOverlayOp$SideType$.MODULE$.FULL() == n) {
            geometry2 = BufferOp.bufferOp(geometry, distance, bufferParameters);
        } else if (AtlasOverlayOp$SideType$.MODULE$.LEFT() == n) {
            Geometry geometry3;
            Geometry geometry4 = geometry;
            if (geometry4 instanceof Lineal) {
                Geometry geometry5 = geometry4;
                bufferParameters.setSingleSided(true);
                geometry3 = BufferOp.bufferOp(geometry5, Math.abs(distance), bufferParameters);
            } else {
                geometry3 = BufferOp.bufferOp(geometry, distance, bufferParameters);
            }
            geometry2 = geometry3;
        } else if (AtlasOverlayOp$SideType$.MODULE$.RIGHT() == n) {
            Geometry geometry6;
            Geometry geometry7 = geometry;
            if (geometry7 instanceof Lineal) {
                Geometry geometry8 = geometry7;
                bufferParameters.setSingleSided(true);
                geometry6 = BufferOp.bufferOp(geometry8, -Math.abs(distance), bufferParameters);
            } else {
                geometry6 = BufferOp.bufferOp(geometry, distance, bufferParameters);
            }
            geometry2 = geometry6;
        } else if (AtlasOverlayOp$SideType$.MODULE$.OUTSIDE_ONLY() == n) {
            Geometry geometry9 = geometry;
            if (!(geometry9 instanceof Polygonal)) {
                String x$1 = "\u975e\u591a\u8fb9\u5f62\u7c7b\u578b\u4e0d\u652f\u6301\u5f53\u524d\u8fb9\u7f13\u5b58\u7c7b\u578b:OUTSIDE_ONLY!";
                Thread x$2 = NotSupportException$.MODULE$.apply$default$2(x$1);
                int x$3 = NotSupportException$.MODULE$.apply$default$3(x$1);
                throw new NotSupportException(x$1, x$2, x$3);
            }
            Geometry geometry10 = geometry9;
            Geometry bufferGeometry = BufferOp.bufferOp(geometry10, distance, bufferParameters);
            Geometry geometry11 = this.difference(bufferGeometry, geometry10, pm);
            geometry2 = geometry11;
        } else {
            throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
        }
        return geometry2;
    }

    public Geometry getFilterResult(int overlay_type, Seq<Geometry> geometries, Geometry resultGeometry, PrecisionModel pm) {
        Seq distinctDimension = (Seq)((SeqLike)geometries.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.getDimension()), Seq$.MODULE$.canBuildFrom())).distinct();
        return distinctDimension.length() == 1 && BoxesRunTime.unboxToInt((Object)distinctDimension.head()) == 2 ? GeometryDimension$.MODULE$.getTargetDimension(resultGeometry, 2, ((Geometry)geometries.head()).getFactory(), pm) : resultGeometry;
    }

    public void splitGeometry(Geometry geometry, Envelope envelope, PrecisionModel pm, List<Geometry> results, int splitLimit) {
        block2: {
            BoxedUnit boxedUnit;
            while (geometry != null && !geometry.isEmpty()) {
                if (geometry.getNumPoints() <= splitLimit) {
                    results.add(geometry);
                    boxedUnit = BoxedUnit.UNIT;
                    break block2;
                }
                Envelope NW = new Envelope(envelope.getMinX(), (envelope.getMinX() + envelope.getMaxX()) / (double)2, (envelope.getMinY() + envelope.getMaxY()) / (double)2, envelope.getMaxY());
                Envelope NE = new Envelope((envelope.getMinX() + envelope.getMaxX()) / (double)2, envelope.getMaxX(), (envelope.getMinY() + envelope.getMaxY()) / (double)2, envelope.getMaxY());
                Envelope SE = new Envelope((envelope.getMinX() + envelope.getMaxX()) / (double)2, envelope.getMaxX(), envelope.getMinY(), (envelope.getMinY() + envelope.getMaxY()) / (double)2);
                Envelope SW = new Envelope(envelope.getMinX(), (envelope.getMinX() + envelope.getMaxX()) / (double)2, envelope.getMinY(), (envelope.getMinY() + envelope.getMaxY()) / (double)2);
                this.splitGeometry(this.clipEnvelope(geometry, NW, pm), NW, pm, results, splitLimit);
                this.splitGeometry(this.clipEnvelope(geometry, NE, pm), NE, pm, results, splitLimit);
                this.splitGeometry(this.clipEnvelope(geometry, SE, pm), SE, pm, results, splitLimit);
                Geometry geometry2 = this.clipEnvelope(geometry, SW, pm);
                envelope = SW;
                geometry = geometry2;
            }
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Geometry clipEnvelope(Geometry geometry, Envelope envelope, PrecisionModel pm) {
        return this.intersection(geometry, this.toGeometry(envelope, geometry.getFactory()), pm, false);
    }

    /*
     * WARNING - void declaration
     */
    public Geometry toGeometry(Envelope envelope, GeometryFactory gf) {
        void var3_3;
        Polygon polygon = gf.createPolygon(gf.createLinearRing((Coordinate[])((Object[])new Coordinate[]{new Coordinate(envelope.getMinX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMaxY()), new Coordinate(envelope.getMaxX(), envelope.getMinY()), new Coordinate(envelope.getMinX(), envelope.getMinY())})), null);
        return var3_3;
    }

    public Geometry overlay(Geometry geom0, Geometry geom1, int opCode, PrecisionModel pm, boolean isUseArc) {
        Geometry result = null;
        try {
            OverlayNG ov = new OverlayNG(geom0, geom1, pm, opCode);
            ov.setUseArc(isUseArc);
            ov.setStrictMode(true);
            result = ov.getResult();
        }
        catch (Throwable throwable) {
            try {
                Geometry gg0 = this.topoFix(geom0);
                Geometry gg1 = this.topoFix(geom1);
                result = OverlayNGRobust.overlay(gg0, gg1, opCode, true, pm);
            }
            catch (TopologyException te) {
                this.logger().error(new StringBuilder(12).append("\u53e0\u52a0\u6a21\u5f0f:").append(opCode).append(", \u62d3\u6251\u9519\u8bef:").append(ExceptionUtils.getMessage((Throwable)te)).toString());
                this.logger().error(new StringBuilder(14).append("\u53e0\u52a0\u6a21\u5f0f:").append(opCode).append(", \u9519\u8bef\u7684\u56fe\u6591:").append(geom0.toText()).append(",").append(geom1.toText()).toString());
                result = geom0.getFactory().createEmpty(Math.min(geom0.getDimension(), geom1.getDimension()));
            }
            catch (Throwable t) {
                String x$1 = new StringBuilder(11).append("\u53e0\u52a0\u6a21\u5f0f:").append(opCode).append(", \u672a\u77e5\u9519\u8bef").toString();
                Throwable x$2 = t;
                Thread x$3 = UnCatchException$.MODULE$.apply$default$3(x$1, x$2);
                int x$4 = UnCatchException$.MODULE$.apply$default$4(x$1, x$2);
                throw new UnCatchException(x$1, x$2, x$3, x$4);
            }
        }
        return this.getFilterResult(opCode, (Seq<Geometry>)Predef$.MODULE$.wrapRefArray((Object[])new Geometry[]{geom0, geom1}), result, pm);
    }

    public Geometry overlay(Geometry geom0, Geometry geom1, int opCode, PrecisionModel pm) {
        return this.overlay(geom0, geom1, opCode, pm, this.HAS_TOLERANCE());
    }

    private Geometry topoFix(Geometry g) {
        Geometry result;
        block3: {
            result = g;
            if (result.isValid()) break block3;
            try {
                result = GeometryFixer.fix(result);
                if (!result.isValid()) {
                    result = result.buffer(0.0);
                }
            }
            catch (Throwable throwable) {
                result = g.buffer(0.0);
            }
        }
        return result;
    }

    public Geometry unionBase(Seq<Geometry> geometries, PrecisionModel pm) {
        Geometry result = null;
        try {
            result = OverlayNGRobust.unionNG((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter(geometries).asJava(), pm, true);
        }
        catch (TopologyException topologyException) {
            this.logger().error(new StringBuilder(7).append("\u8054\u5408\u62d3\u6251\u9519\u8bef:").append(ExceptionUtils.getMessage((Throwable)topologyException)).toString());
            this.logger().error(new StringBuilder(8).append("\u9519\u8bef\u8054\u5408\u7684\u56fe\u6591:").append(((TraversableOnce)geometries.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toText(), Seq$.MODULE$.canBuildFrom())).mkString(",")).toString());
            result = GeometryDimension$.MODULE$.getHighDimension(geometries, pm);
        }
        catch (Throwable t) {
            String x$1 = "\u8054\u5408\u672a\u77e5\u9519\u8bef";
            Throwable x$2 = t;
            Thread x$32 = UnCatchException$.MODULE$.apply$default$3(x$1, x$2);
            int x$4 = UnCatchException$.MODULE$.apply$default$4(x$1, x$2);
            throw new UnCatchException(x$1, x$2, x$32, x$4);
        }
        return this.getFilterResult(2, geometries, result, pm);
    }

    public static final /* synthetic */ boolean $anonfun$HAS_TOLERANCE$1(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toBoolean();
    }

    private AtlasOverlayOp$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
        this.HAS_TOLERANCE = new AtlasSystemProperties.SystemProperty("atlas.vector.algorithm.tolerance.enable", AtlasSystemProperties.SystemProperty$.MODULE$.apply$default$2()).option().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)AtlasOverlayOp$.$anonfun$HAS_TOLERANCE$1(x$1)));
        this.SPLIT_LIMIT = 100;
    }
}

