/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.jts;

import com.geoway.atlas.jts.Envelope2D;
import com.geoway.atlas.jts.Geometry;
import com.geoway.atlas.jts.QuadTreeImpl;
import java.io.Serializable;

public class QuadTree
implements Serializable {
    private static final long serialVersionUID = 1L;
    private QuadTreeImpl m_impl;

    public QuadTree(Envelope2D extent, int height) {
        this.m_impl = new QuadTreeImpl(extent, height);
    }

    public QuadTree(Envelope2D extent, int height, boolean bStoreDuplicates) {
        this.m_impl = new QuadTreeImpl(extent, height, bStoreDuplicates);
    }

    public int insert(int element, Envelope2D boundingBox) {
        return this.m_impl.insert(element, boundingBox);
    }

    public int insert(int element, Envelope2D boundingBox, int hintIndex) {
        return this.m_impl.insert(element, boundingBox, hintIndex);
    }

    public void removeElement(int elementHandle) {
        this.m_impl.removeElement(elementHandle);
    }

    public int getElement(int elementHandle) {
        return this.m_impl.getElement(elementHandle);
    }

    public Envelope2D getElementExtent(int elementHandle) {
        return this.m_impl.getElementExtent(elementHandle);
    }

    public Envelope2D getDataExtent() {
        return this.m_impl.getDataExtent();
    }

    public Envelope2D getQuadTreeExtent() {
        return this.m_impl.getQuadTreeExtent();
    }

    public int getSubTreeElementCount(int quadHandle) {
        return this.m_impl.getSubTreeElementCount(quadHandle);
    }

    public int getContainedSubTreeElementCount(int quadHandle) {
        return this.m_impl.getContainedSubTreeElementCount(quadHandle);
    }

    public int getIntersectionCount(Envelope2D query, double tolerance, int maxCount) {
        return this.m_impl.getIntersectionCount(query, tolerance, maxCount);
    }

    public boolean hasData(Envelope2D query, double tolerance) {
        return this.m_impl.hasData(query, tolerance);
    }

    public int getHeight(int quadHandle) {
        return this.m_impl.getHeight(quadHandle);
    }

    public int getMaxHeight() {
        return this.m_impl.getMaxHeight();
    }

    public Envelope2D getExtent(int quadHandle) {
        return this.m_impl.getExtent(quadHandle);
    }

    public int getQuad(int elementHandle) {
        return this.m_impl.getQuad(elementHandle);
    }

    public int getElementCount() {
        return this.m_impl.getElementCount();
    }

    public QuadTreeIterator getIterator(Geometry query, double tolerance) {
        QuadTreeImpl.QuadTreeIteratorImpl iterator = this.m_impl.getIterator(query, tolerance);
        return new QuadTreeIterator(iterator, false);
    }

    public QuadTreeIterator getIterator(Envelope2D query, double tolerance) {
        QuadTreeImpl.QuadTreeIteratorImpl iterator = this.m_impl.getIterator(query, tolerance);
        return new QuadTreeIterator(iterator, false);
    }

    public QuadTreeIterator getIterator() {
        QuadTreeImpl.QuadTreeIteratorImpl iterator = this.m_impl.getIterator();
        return new QuadTreeIterator(iterator, false);
    }

    public QuadTreeIterator getIterator(Geometry query, double tolerance, boolean bSorted) {
        if (!bSorted) {
            QuadTreeImpl.QuadTreeIteratorImpl iterator = this.m_impl.getIterator(query, tolerance);
            return new QuadTreeIterator(iterator, false);
        }
        QuadTreeImpl.QuadTreeSortedIteratorImpl iterator = this.m_impl.getSortedIterator(query, tolerance);
        return new QuadTreeIterator(iterator, true);
    }

    public QuadTreeIterator getIterator(Envelope2D query, double tolerance, boolean bSorted) {
        if (!bSorted) {
            QuadTreeImpl.QuadTreeIteratorImpl iterator = this.m_impl.getIterator(query, tolerance);
            return new QuadTreeIterator(iterator, false);
        }
        QuadTreeImpl.QuadTreeSortedIteratorImpl iterator = this.m_impl.getSortedIterator(query, tolerance);
        return new QuadTreeIterator(iterator, true);
    }

    public QuadTreeIterator getIterator(boolean bSorted) {
        if (!bSorted) {
            QuadTreeImpl.QuadTreeIteratorImpl iterator = this.m_impl.getIterator();
            return new QuadTreeIterator(iterator, false);
        }
        QuadTreeImpl.QuadTreeSortedIteratorImpl iterator = this.m_impl.getSortedIterator();
        return new QuadTreeIterator(iterator, true);
    }

    Object getImpl_() {
        return this.m_impl;
    }

    public static final class QuadTreeIterator {
        private Object m_impl;
        private boolean m_b_sorted;

        public void resetIterator(Geometry query, double tolerance) {
            if (!this.m_b_sorted) {
                ((QuadTreeImpl.QuadTreeIteratorImpl)this.m_impl).resetIterator(query, tolerance);
            } else {
                ((QuadTreeImpl.QuadTreeSortedIteratorImpl)this.m_impl).resetIterator(query, tolerance);
            }
        }

        public void resetIterator(Envelope2D query, double tolerance) {
            if (!this.m_b_sorted) {
                ((QuadTreeImpl.QuadTreeIteratorImpl)this.m_impl).resetIterator(query, tolerance);
            } else {
                ((QuadTreeImpl.QuadTreeSortedIteratorImpl)this.m_impl).resetIterator(query, tolerance);
            }
        }

        public int next() {
            if (!this.m_b_sorted) {
                return ((QuadTreeImpl.QuadTreeIteratorImpl)this.m_impl).next();
            }
            return ((QuadTreeImpl.QuadTreeSortedIteratorImpl)this.m_impl).next();
        }

        Object getImpl_() {
            return this.m_impl;
        }

        private QuadTreeIterator(Object obj, boolean bSorted) {
            this.m_impl = obj;
            this.m_b_sorted = bSorted;
        }
    }
}

