/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.jts;

import com.geoway.atlas.jts.Geometry;
import com.geoway.atlas.jts.MapGeometry;
import com.geoway.atlas.jts.Operator;
import com.geoway.atlas.jts.OperatorBoundaryLocal;
import com.geoway.atlas.jts.OperatorBufferLocal;
import com.geoway.atlas.jts.OperatorCentroid2DLocal;
import com.geoway.atlas.jts.OperatorClipLocal;
import com.geoway.atlas.jts.OperatorContainsLocal;
import com.geoway.atlas.jts.OperatorConvexHullLocal;
import com.geoway.atlas.jts.OperatorCrossesLocal;
import com.geoway.atlas.jts.OperatorCutLocal;
import com.geoway.atlas.jts.OperatorDensifyByLengthLocal;
import com.geoway.atlas.jts.OperatorDifferenceLocal;
import com.geoway.atlas.jts.OperatorDisjointLocal;
import com.geoway.atlas.jts.OperatorDistanceLocal;
import com.geoway.atlas.jts.OperatorEqualsLocal;
import com.geoway.atlas.jts.OperatorExportToESRIShape;
import com.geoway.atlas.jts.OperatorExportToESRIShapeLocal;
import com.geoway.atlas.jts.OperatorExportToGeoJsonLocal;
import com.geoway.atlas.jts.OperatorExportToJson;
import com.geoway.atlas.jts.OperatorExportToJsonLocal;
import com.geoway.atlas.jts.OperatorExportToWkbLocal;
import com.geoway.atlas.jts.OperatorExportToWkt;
import com.geoway.atlas.jts.OperatorExportToWktLocal;
import com.geoway.atlas.jts.OperatorFactory;
import com.geoway.atlas.jts.OperatorGeneralizeLocal;
import com.geoway.atlas.jts.OperatorGeodesicBufferLocal;
import com.geoway.atlas.jts.OperatorGeodeticAreaLocal;
import com.geoway.atlas.jts.OperatorGeodeticDensifyLocal;
import com.geoway.atlas.jts.OperatorGeodeticLengthLocal;
import com.geoway.atlas.jts.OperatorImportFromESRIShape;
import com.geoway.atlas.jts.OperatorImportFromESRIShapeLocal;
import com.geoway.atlas.jts.OperatorImportFromGeoJsonLocal;
import com.geoway.atlas.jts.OperatorImportFromJson;
import com.geoway.atlas.jts.OperatorImportFromJsonLocal;
import com.geoway.atlas.jts.OperatorImportFromWkbLocal;
import com.geoway.atlas.jts.OperatorImportFromWkt;
import com.geoway.atlas.jts.OperatorImportFromWktLocal;
import com.geoway.atlas.jts.OperatorIntersectionLocal;
import com.geoway.atlas.jts.OperatorIntersectsLocal;
import com.geoway.atlas.jts.OperatorOffsetLocal;
import com.geoway.atlas.jts.OperatorOverlapsLocal;
import com.geoway.atlas.jts.OperatorProjectLocal;
import com.geoway.atlas.jts.OperatorProximity2DLocal;
import com.geoway.atlas.jts.OperatorRelateLocal;
import com.geoway.atlas.jts.OperatorShapePreservingDensifyLocal;
import com.geoway.atlas.jts.OperatorSimplifyLocal;
import com.geoway.atlas.jts.OperatorSimplifyLocalOGC;
import com.geoway.atlas.jts.OperatorSymmetricDifferenceLocal;
import com.geoway.atlas.jts.OperatorTouchesLocal;
import com.geoway.atlas.jts.OperatorUnionLocal;
import com.geoway.atlas.jts.OperatorWithinLocal;
import com.geoway.atlas.jts.SpatialReference;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.HashMap;

public class OperatorFactoryLocal
extends OperatorFactory {
    private static final OperatorFactoryLocal INSTANCE = new OperatorFactoryLocal();
    private static final HashMap<Operator.Type, Operator> st_supportedOperators = new HashMap();

    private OperatorFactoryLocal() {
    }

    public static OperatorFactoryLocal getInstance() {
        return INSTANCE;
    }

    @Override
    public Operator getOperator(Operator.Type type) {
        if (st_supportedOperators.containsKey((Object)type)) {
            return st_supportedOperators.get((Object)type);
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isOperatorSupported(Operator.Type type) {
        return st_supportedOperators.containsKey((Object)type);
    }

    public static void saveJSONToTextFileDbg(String file_name, Geometry geometry, SpatialReference spatial_ref) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        OperatorFactoryLocal engine = OperatorFactoryLocal.getInstance();
        OperatorExportToJson exporterJSON = (OperatorExportToJson)engine.getOperator(Operator.Type.ExportToJson);
        String jsonString = exporterJSON.execute(spatial_ref, geometry);
        try {
            FileOutputStream outfile = new FileOutputStream(file_name);
            PrintStream p = new PrintStream(outfile);
            p.print(jsonString);
            p.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapGeometry loadGeometryFromJSONFileDbg(String file_name) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        String jsonString = null;
        Reader reader = null;
        try {
            int read;
            FileInputStream stream = new FileInputStream(file_name);
            reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[8192];
            while ((read = reader.read(buffer, 0, buffer.length)) > 0) {
                builder.append(buffer, 0, read);
            }
            jsonString = builder.toString();
        }
        catch (Exception stream) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException stream) {}
            }
        }
        MapGeometry mapGeom = OperatorImportFromJson.local().execute(Geometry.Type.Unknown, jsonString);
        return mapGeom;
    }

    public static MapGeometry loadGeometryFromJSONStringDbg(String json) {
        if (json == null) {
            throw new IllegalArgumentException();
        }
        MapGeometry mapGeom = null;
        try {
            mapGeom = OperatorImportFromJson.local().execute(Geometry.Type.Unknown, json);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.toString());
        }
        return mapGeom;
    }

    public static Geometry loadGeometryFromEsriShapeDbg(String file_name) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        try {
            FileInputStream stream = new FileInputStream(file_name);
            FileChannel fchan = stream.getChannel();
            ByteBuffer bb = ByteBuffer.allocate((int)fchan.size());
            fchan.read(bb);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            Geometry g = OperatorImportFromESRIShape.local().execute(0, Geometry.Type.Unknown, bb);
            fchan.close();
            stream.close();
            return g;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException();
        }
    }

    public static void saveGeometryToEsriShapeDbg(String file_name, Geometry geometry) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        try {
            ByteBuffer bb = OperatorExportToESRIShape.local().execute(0, geometry);
            FileOutputStream outfile = new FileOutputStream(file_name);
            FileChannel fchan = outfile.getChannel();
            fchan.write(bb);
            fchan.close();
            outfile.close();
        }
        catch (Exception ex) {
            throw new IllegalArgumentException();
        }
    }

    public static void saveToWKTFileDbg(String file_name, Geometry geometry, SpatialReference spatial_ref) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        String jsonString = OperatorExportToWkt.local().execute(0, geometry, null);
        try {
            FileOutputStream outfile = new FileOutputStream(file_name);
            PrintStream p = new PrintStream(outfile);
            p.print(jsonString);
            p.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Geometry loadGeometryFromWKTFileDbg(String file_name) {
        if (file_name == null) {
            throw new IllegalArgumentException();
        }
        String s = null;
        Reader reader = null;
        try {
            int read;
            FileInputStream stream = new FileInputStream(file_name);
            reader = new BufferedReader(new InputStreamReader(stream));
            StringBuilder builder = new StringBuilder();
            char[] buffer = new char[8192];
            while ((read = reader.read(buffer, 0, buffer.length)) > 0) {
                builder.append(buffer, 0, read);
            }
            s = builder.toString();
        }
        catch (Exception exception) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return OperatorImportFromWkt.local().execute(0, Geometry.Type.Unknown, s, null);
    }

    static {
        st_supportedOperators.put(Operator.Type.Project, new OperatorProjectLocal());
        st_supportedOperators.put(Operator.Type.ExportToJson, new OperatorExportToJsonLocal());
        st_supportedOperators.put(Operator.Type.ImportFromJson, new OperatorImportFromJsonLocal());
        st_supportedOperators.put(Operator.Type.ExportToESRIShape, new OperatorExportToESRIShapeLocal());
        st_supportedOperators.put(Operator.Type.ImportFromESRIShape, new OperatorImportFromESRIShapeLocal());
        st_supportedOperators.put(Operator.Type.Proximity2D, new OperatorProximity2DLocal());
        st_supportedOperators.put(Operator.Type.Centroid2D, new OperatorCentroid2DLocal());
        st_supportedOperators.put(Operator.Type.DensifyByLength, new OperatorDensifyByLengthLocal());
        st_supportedOperators.put(Operator.Type.Relate, new OperatorRelateLocal());
        st_supportedOperators.put(Operator.Type.Equals, new OperatorEqualsLocal());
        st_supportedOperators.put(Operator.Type.Disjoint, new OperatorDisjointLocal());
        st_supportedOperators.put(Operator.Type.Intersects, new OperatorIntersectsLocal());
        st_supportedOperators.put(Operator.Type.Within, new OperatorWithinLocal());
        st_supportedOperators.put(Operator.Type.Contains, new OperatorContainsLocal());
        st_supportedOperators.put(Operator.Type.Crosses, new OperatorCrossesLocal());
        st_supportedOperators.put(Operator.Type.Touches, new OperatorTouchesLocal());
        st_supportedOperators.put(Operator.Type.Overlaps, new OperatorOverlapsLocal());
        st_supportedOperators.put(Operator.Type.SimplifyOGC, new OperatorSimplifyLocalOGC());
        st_supportedOperators.put(Operator.Type.Simplify, new OperatorSimplifyLocal());
        st_supportedOperators.put(Operator.Type.Offset, new OperatorOffsetLocal());
        st_supportedOperators.put(Operator.Type.GeodeticDensifyByLength, new OperatorGeodeticDensifyLocal());
        st_supportedOperators.put(Operator.Type.ShapePreservingDensify, new OperatorShapePreservingDensifyLocal());
        st_supportedOperators.put(Operator.Type.GeodesicBuffer, new OperatorGeodesicBufferLocal());
        st_supportedOperators.put(Operator.Type.GeodeticLength, new OperatorGeodeticLengthLocal());
        st_supportedOperators.put(Operator.Type.GeodeticArea, new OperatorGeodeticAreaLocal());
        st_supportedOperators.put(Operator.Type.Buffer, new OperatorBufferLocal());
        st_supportedOperators.put(Operator.Type.Distance, new OperatorDistanceLocal());
        st_supportedOperators.put(Operator.Type.Intersection, new OperatorIntersectionLocal());
        st_supportedOperators.put(Operator.Type.Difference, new OperatorDifferenceLocal());
        st_supportedOperators.put(Operator.Type.SymmetricDifference, new OperatorSymmetricDifferenceLocal());
        st_supportedOperators.put(Operator.Type.Clip, new OperatorClipLocal());
        st_supportedOperators.put(Operator.Type.Cut, new OperatorCutLocal());
        st_supportedOperators.put(Operator.Type.ExportToWkb, new OperatorExportToWkbLocal());
        st_supportedOperators.put(Operator.Type.ImportFromWkb, new OperatorImportFromWkbLocal());
        st_supportedOperators.put(Operator.Type.ExportToWkt, new OperatorExportToWktLocal());
        st_supportedOperators.put(Operator.Type.ImportFromWkt, new OperatorImportFromWktLocal());
        st_supportedOperators.put(Operator.Type.ImportFromGeoJson, new OperatorImportFromGeoJsonLocal());
        st_supportedOperators.put(Operator.Type.ExportToGeoJson, new OperatorExportToGeoJsonLocal());
        st_supportedOperators.put(Operator.Type.Union, new OperatorUnionLocal());
        st_supportedOperators.put(Operator.Type.Generalize, new OperatorGeneralizeLocal());
        st_supportedOperators.put(Operator.Type.ConvexHull, new OperatorConvexHullLocal());
        st_supportedOperators.put(Operator.Type.Boundary, new OperatorBoundaryLocal());
    }
}

