/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.atlas.jts;

import com.geoway.atlas.jts.Geometry;
import com.geoway.atlas.jts.MultiVertexGeometry;
import com.geoway.atlas.jts.QuadTreeImpl;
import com.geoway.atlas.jts.RasterizedGeometry2D;

class GeometryAccelerators {
    private RasterizedGeometry2D m_rasterizedGeometry;
    private QuadTreeImpl m_quad_tree;
    private QuadTreeImpl m_quad_tree_for_paths;

    GeometryAccelerators() {
    }

    public RasterizedGeometry2D getRasterizedGeometry() {
        return this.m_rasterizedGeometry;
    }

    public QuadTreeImpl getQuadTree() {
        return this.m_quad_tree;
    }

    public QuadTreeImpl getQuadTreeForPaths() {
        return this.m_quad_tree_for_paths;
    }

    void _setRasterizedGeometry(RasterizedGeometry2D rg) {
        this.m_rasterizedGeometry = rg;
    }

    void _setQuadTree(QuadTreeImpl quad_tree) {
        this.m_quad_tree = quad_tree;
    }

    void _setQuadTreeForPaths(QuadTreeImpl quad_tree) {
        this.m_quad_tree_for_paths = quad_tree;
    }

    static boolean canUseRasterizedGeometry(Geometry geom) {
        return !geom.isEmpty() && (geom.getType() == Geometry.Type.Polyline || geom.getType() == Geometry.Type.Polygon);
    }

    static boolean canUseQuadTree(Geometry geom) {
        if (geom.isEmpty() || geom.getType() != Geometry.Type.Polyline && geom.getType() != Geometry.Type.Polygon) {
            return false;
        }
        return ((MultiVertexGeometry)geom).getPointCount() >= 20;
    }

    static boolean canUseQuadTreeForPaths(Geometry geom) {
        if (geom.isEmpty() || geom.getType() != Geometry.Type.Polyline && geom.getType() != Geometry.Type.Polygon) {
            return false;
        }
        return ((MultiVertexGeometry)geom).getPointCount() >= 20;
    }

    public long estimateMemorySize() {
        return (this.m_rasterizedGeometry != null ? this.m_rasterizedGeometry.estimateMemorySize() : 0L) + (this.m_quad_tree != null ? this.m_quad_tree.estimateMemorySize() : 0L) + (this.m_quad_tree_for_paths != null ? this.m_quad_tree_for_paths.estimateMemorySize() : 0L);
    }
}

